/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class RecursiveTemporalEvaluator
extends RecursiveEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;
    private String functionName;

    public RecursiveTemporalEvaluator(StreamExpression expression, StreamFactory factory, String functionName) throws IOException {
        super(expression, factory);
        this.functionName = functionName;
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    public String getFunction() {
        return this.functionName;
    }

    protected abstract Object getDatePart(TemporalAccessor var1);

    @Override
    public Object normalizeInputType(Object value) throws StreamEvaluatorException {
        if (null == value) {
            return value;
        }
        if (value instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)value, ZoneOffset.UTC);
        }
        if (value instanceof TemporalAccessor) {
            return value;
        }
        if (value instanceof Long) {
            return this.normalizeInputType(Instant.ofEpochMilli((Long)value));
        }
        if (value instanceof Date) {
            return this.normalizeInputType(((Date)value).toInstant());
        }
        if (value instanceof String) {
            String valueStr = (String)value;
            if (!valueStr.isEmpty()) {
                try {
                    return this.normalizeInputType(Instant.parse(valueStr));
                }
                catch (DateTimeParseException e) {
                    throw new UncheckedIOException(new IOException(String.format(Locale.ROOT, "Invalid parameter %s - The String must be formatted in the ISO_INSTANT date format.", valueStr)));
                }
            }
        } else if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.normalizeInputType(innerValue)).collect(Collectors.toList());
        }
        throw new UncheckedIOException(new IOException(String.format(Locale.ROOT, "Invalid parameter %s - The parameter must be a string formatted ISO_INSTANT or of type Long,Instant,Date,LocalDateTime or TemporalAccessor.", String.valueOf(value))));
    }

    @Override
    public Object doWork(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.doWork(innerValue)).collect(Collectors.toList());
        }
        try {
            return this.getDatePart((TemporalAccessor)value);
        }
        catch (UnsupportedTemporalTypeException utte) {
            throw new UncheckedIOException(new IOException(String.format(Locale.ROOT, "It is not possible to call '%s' function on %s", this.getFunction(), value.getClass().getName())));
        }
    }
}

