/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRShortAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRShortCountIncrementer;
import net.sf.jasperreports.engine.fill.JRShortDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRShortStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRShortSumIncrementer;
import net.sf.jasperreports.engine.fill.JRShortVarianceIncrementer;

public class JRShortIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Short ZERO = new Short(0);
    private static JRShortIncrementerFactory mainInstance = new JRShortIncrementerFactory();

    private JRShortIncrementerFactory() {
    }

    public static JRShortIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(byte calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRShortCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRShortSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRShortAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRShortStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRShortVarianceIncrementer.getInstance();
                break;
            }
            case 10: {
                incrementer = JRShortDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

