/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.UndoLogRecord;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.util.Utils;

public class UndoLog {
    private final Database database;
    private final ArrayList<Long> storedEntriesPos = Utils.newSmallArrayList();
    private final ArrayList<UndoLogRecord> records = Utils.newSmallArrayList();
    private FileStore file;
    private Data rowBuff;
    private int memoryUndo;
    private int storedEntries;
    private HashMap<Integer, Table> tables;

    UndoLog(Database database) {
        this.database = database;
    }

    int size() {
        return this.storedEntries + this.records.size();
    }

    void clear() {
        this.records.clear();
        this.storedEntries = 0;
        this.storedEntriesPos.clear();
        this.memoryUndo = 0;
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }

    public UndoLogRecord getLast() {
        UndoLogRecord undoLogRecord;
        int n = this.records.size() - 1;
        if (n < 0 && this.storedEntries > 0) {
            int n2 = this.storedEntriesPos.size() - 1;
            long l = this.storedEntriesPos.remove(n2);
            long l2 = this.file.length();
            int n3 = (int)(l2 - l);
            Data data = Data.create((DataHandler)this.database, n3, true);
            this.file.seek(l);
            this.file.readFully(data.getBytes(), 0, n3);
            while (data.length() < n3) {
                UndoLogRecord undoLogRecord2 = UndoLogRecord.loadFromBuffer(data, this);
                this.records.add(undoLogRecord2);
                ++this.memoryUndo;
            }
            this.storedEntries -= this.records.size();
            this.file.setLength(l);
            this.file.seek(l);
        }
        if ((undoLogRecord = this.records.get(n = this.records.size() - 1)).isStored()) {
            UndoLogRecord undoLogRecord3;
            int n4;
            int n5 = Math.max(0, n - this.database.getMaxMemoryUndo() / 2);
            UndoLogRecord undoLogRecord4 = null;
            for (n4 = n5; n4 <= n; ++n4) {
                undoLogRecord3 = this.records.get(n4);
                if (!undoLogRecord3.isStored()) continue;
                undoLogRecord3.load(this.rowBuff, this.file, this);
                ++this.memoryUndo;
                if (undoLogRecord4 != null) continue;
                undoLogRecord4 = undoLogRecord3;
            }
            for (n4 = 0; n4 < n; ++n4) {
                undoLogRecord3 = this.records.get(n4);
                undoLogRecord3.invalidatePos();
            }
            this.seek(undoLogRecord4.getFilePos());
        }
        return undoLogRecord;
    }

    void seek(long l) {
        this.file.seek(l * 16L);
    }

    void removeLast() {
        int n = this.records.size() - 1;
        UndoLogRecord undoLogRecord = this.records.remove(n);
        if (!undoLogRecord.isStored()) {
            --this.memoryUndo;
        }
    }

    void add(UndoLogRecord undoLogRecord) {
        this.records.add(undoLogRecord);
        ++this.memoryUndo;
        if (this.memoryUndo > this.database.getMaxMemoryUndo() && this.database.isPersistent() && !this.database.isMVStore()) {
            Object object;
            if (this.file == null) {
                object = this.database.createTempFile();
                this.file = this.database.openFile((String)object, "rw", false);
                this.file.autoDelete();
                this.file.setCheckedWriting(false);
                this.file.setLength(48L);
            }
            object = Data.create((DataHandler)this.database, 4096, true);
            for (int i = 0; i < this.records.size(); ++i) {
                UndoLogRecord undoLogRecord2 = this.records.get(i);
                ((Data)object).checkCapacity(4096);
                undoLogRecord2.append((Data)object, this);
                if (i != this.records.size() - 1 && ((Data)object).length() <= 0x100000) continue;
                this.storedEntriesPos.add(this.file.getFilePointer());
                this.file.write(((Data)object).getBytes(), 0, ((Data)object).length());
                ((Data)object).reset();
            }
            this.storedEntries += this.records.size();
            this.memoryUndo = 0;
            this.records.clear();
        }
    }

    int getTableId(Table table) {
        int n = table.getId();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        this.tables.put(n, table);
        return n;
    }

    Table getTable(int n) {
        return this.tables.get(n);
    }
}

