/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.ChannelData;
import org.ice4j.message.Message;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.ChannelDataEventHandler;
import org.ice4j.stack.Connector;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.MessageProcessor;
import org.ice4j.stack.MessageQueue;
import org.ice4j.stack.PeerUdpMessageEventHandler;
import org.ice4j.stack.StunStack;

class NetAccessManager
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(NetAccessManager.class.getName());
    private final Map<TransportAddress, Map<TransportAddress, Connector>> udpConnectors = new HashMap<TransportAddress, Map<TransportAddress, Connector>>();
    private final Map<TransportAddress, Map<TransportAddress, Connector>> tcpConnectors = new HashMap<TransportAddress, Map<TransportAddress, Connector>>();
    private final MessageQueue messageQueue = new MessageQueue();
    private final Vector<MessageProcessor> messageProcessors = new Vector();
    private final MessageEventHandler messageEventHandler;
    private final PeerUdpMessageEventHandler peerUdpMessageEventHandler;
    private final ChannelDataEventHandler channelDataEventHandler;
    private int initialThreadPoolSize = 3;
    private final StunStack stunStack;

    NetAccessManager(StunStack stunStack) {
        this(stunStack, null, null);
    }

    NetAccessManager(StunStack stunStack, PeerUdpMessageEventHandler peerUdpMessageEventHandler, ChannelDataEventHandler channelDataEventHandler) {
        this.stunStack = stunStack;
        this.messageEventHandler = stunStack;
        this.peerUdpMessageEventHandler = peerUdpMessageEventHandler;
        this.channelDataEventHandler = channelDataEventHandler;
        this.initThreadPool();
    }

    MessageEventHandler getMessageEventHandler() {
        return this.messageEventHandler;
    }

    public PeerUdpMessageEventHandler getUdpMessageEventHandler() {
        return this.peerUdpMessageEventHandler;
    }

    public ChannelDataEventHandler getChannelDataMessageEventHandler() {
        return this.channelDataEventHandler;
    }

    MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    StunStack getStunStack() {
        return this.stunStack;
    }

    @Override
    public void handleError(String message, Throwable error) {
        logger.log(Level.FINE, "The following error occurred with an incoming message:", error);
    }

    @Override
    public void handleFatalError(Runnable callingThread, String message, Throwable error) {
        if (callingThread instanceof Connector) {
            Connector connector = (Connector)callingThread;
            this.removeSocket(connector.getListenAddress(), connector.getRemoteAddress());
            logger.log(Level.WARNING, "Removing connector:" + connector, error);
        } else if (callingThread instanceof MessageProcessor) {
            MessageProcessor mp = (MessageProcessor)callingThread;
            logger.log(Level.WARNING, "A message processor has unexpectedly stopped. AP:" + mp, error);
            mp.stop();
            this.messageProcessors.remove(mp);
            mp = new MessageProcessor(this);
            mp.start();
            logger.fine("A message processor has been relaunched because of an error.");
        }
    }

    protected void addSocket(IceSocketWrapper socket) {
        Socket tcpSocket = socket.getTCPSocket();
        TransportAddress remoteAddress = null;
        if (tcpSocket != null) {
            remoteAddress = new TransportAddress(tcpSocket.getInetAddress(), tcpSocket.getPort(), Transport.TCP);
        }
        this.addSocket(socket, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSocket(IceSocketWrapper socket, TransportAddress remoteAddress) {
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap;
        Transport transport = socket.getUDPSocket() != null ? Transport.UDP : Transport.TCP;
        TransportAddress localAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), transport);
        Map<TransportAddress, Map<TransportAddress, Connector>> map = connectorsMap = transport == Transport.UDP ? this.udpConnectors : this.tcpConnectors;
        synchronized (map) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress == null) {
                connectorsForLocalAddress = new HashMap<TransportAddress, Connector>();
                connectorsMap.put(localAddress, connectorsForLocalAddress);
            }
            if (!connectorsForLocalAddress.containsKey(remoteAddress)) {
                Connector connector = new Connector(socket, remoteAddress, this.messageQueue, this);
                connectorsForLocalAddress.put(remoteAddress, connector);
                connector.start();
            } else {
                logger.info("Not creating a new Connector, because we already have one for the given address pair: " + localAddress + " -> " + remoteAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(TransportAddress localAddress, TransportAddress remoteAddress) {
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap;
        Connector connector = null;
        Map<TransportAddress, Map<TransportAddress, Connector>> map = connectorsMap = localAddress.getTransport() == Transport.UDP ? this.udpConnectors : this.tcpConnectors;
        synchronized (map) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress != null && (connector = connectorsForLocalAddress.get(remoteAddress)) != null) {
                connectorsForLocalAddress.remove(remoteAddress);
                if (connectorsForLocalAddress.isEmpty()) {
                    connectorsMap.remove(localAddress);
                }
            }
        }
        if (connector != null) {
            connector.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        for (MessageProcessor mp : this.messageProcessors) {
            mp.stop();
        }
        for (Object o : new Object[]{this.udpConnectors, this.tcpConnectors}) {
            Map connectorsMap;
            Map map = connectorsMap = (Map)o;
            synchronized (map) {
                for (Map connectorsForLocalAddress : connectorsMap.values()) {
                    for (Connector connector : connectorsForLocalAddress.values()) {
                        connector.stop();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connector getConnector(TransportAddress localAddress, TransportAddress remoteAddress) {
        boolean udp = localAddress.getTransport() == Transport.UDP;
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap = udp ? this.udpConnectors : this.tcpConnectors;
        Connector connector = null;
        Map<TransportAddress, Map<TransportAddress, Connector>> map = connectorsMap;
        synchronized (map) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress != null) {
                connector = connectorsForLocalAddress.get(remoteAddress);
                if (udp && connector == null) {
                    connector = connectorsForLocalAddress.get(null);
                }
            }
        }
        return connector;
    }

    void setThreadPoolSize(int threadPoolSize) throws IllegalArgumentException {
        if (threadPoolSize < 1) {
            throw new IllegalArgumentException(threadPoolSize + " is not a legal thread pool size value.");
        }
        if (this.messageProcessors.size() < threadPoolSize) {
            this.fillUpThreadPool(threadPoolSize);
        } else {
            this.shrinkThreadPool(threadPoolSize);
        }
    }

    private void initThreadPool() {
        this.fillUpThreadPool(this.initialThreadPoolSize);
    }

    private void fillUpThreadPool(int newSize) {
        this.messageProcessors.ensureCapacity(newSize);
        for (int i = this.messageProcessors.size(); i < newSize; ++i) {
            MessageProcessor mp = new MessageProcessor(this);
            this.messageProcessors.add(mp);
            mp.start();
        }
    }

    private void shrinkThreadPool(int newSize) {
        while (this.messageProcessors.size() > newSize) {
            MessageProcessor mp = this.messageProcessors.remove(0);
            mp.stop();
        }
    }

    void sendMessage(Message stunMessage, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException {
        this.sendMessage(stunMessage.encode(this.stunStack), srcAddr, remoteAddr);
    }

    void sendMessage(ChannelData channelData, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException, StunException {
        this.sendMessage(channelData.encode(), srcAddr, remoteAddr);
    }

    void sendMessage(byte[] bytes, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException {
        Connector ap = this.getConnector(srcAddr, remoteAddr);
        if (ap == null) {
            throw new IllegalArgumentException("No socket found for " + srcAddr + "->" + remoteAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }
}

