(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/proto/cookie#challenge-digest
    std/crypto/digest#digest::sha256)
  (define std/actor/rpc/proto/cookie#challenge-length
    (std/crypto/digest#digest-size
     std/actor/rpc/proto/cookie#challenge-digest))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-accept
    (lambda (_ibuf512_ _obuf513_ _cookie514_)
      (std/actor/rpc/proto/null#rpc-proto-accept-e
       _ibuf512_
       _obuf513_
       std/actor/rpc/proto/message#rpc-proto-cookie
       (lambda (_ibuf516_ _obuf517_)
         (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
          _ibuf516_
          _obuf517_
          _cookie514_)
         (values std/actor/rpc/proto/null#rpc-null-proto-read
                 std/actor/rpc/proto/null#rpc-null-proto-write)))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-connect
    (lambda (_ibuf503_ _obuf504_ _cookie505_)
      (std/actor/rpc/proto/null#rpc-proto-connect-e
       _ibuf503_
       _obuf504_
       std/actor/rpc/proto/message#rpc-proto-cookie
       (lambda (_ibuf507_ _obuf508_)
         (let ((_e510_ (std/net/bio/input#bio-read-u8 _ibuf507_)))
           (if (eq? _e510_ std/actor/rpc/proto/message#rpc-proto-challenge)
               (begin
                 (std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
                  _ibuf507_
                  _obuf508_
                  _cookie505_)
                 (values std/actor/rpc/proto/null#rpc-null-proto-read
                         std/actor/rpc/proto/null#rpc-null-proto-write))
               (if (eof-object? _e510_)
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"connection closed")
                   (std/actor/proto#raise-rpc-io-error
                    'rpc-proto-connect
                    '"bad hello"
                    _e510_))))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge
    (lambda (_ibuf486_ _obuf487_ _cookie488_)
      (std/net/bio/output#bio-write-u8
       std/actor/rpc/proto/message#rpc-proto-challenge
       _obuf487_)
      (let ((_challenge490_
             (std/crypto/etc#random-bytes
              std/actor/rpc/proto/cookie#challenge-length)))
        (std/net/bio/output#bio-write-u32
         std/actor/rpc/proto/cookie#challenge-length
         _obuf487_)
        (std/net/bio/output#bio-write-bytes _challenge490_ _obuf487_)
        (std/net/bio/output#bio-force-output _obuf487_)
        (let* ((_sz492_ (std/net/bio/input#bio-read-u32 _ibuf486_))
               (_g5580_ (if (fx= _sz492_
                                 std/actor/rpc/proto/cookie#challenge-length)
                            '#!void
                            (std/actor/proto#raise-rpc-io-error
                             'rpc-proto-authen
                             '"challenge response size mismatch"
                             _sz492_)))
               (_response495_ (make-u8vector _sz492_))
               (_g5581_ (std/net/bio/input#bio-read-bytes
                         _response495_
                         _ibuf486_))
               (_secret500_
                (let ((_digest498_
                       (let ((__obj5578
                              (make-object std/crypto/digest#digest::t '2)))
                         (std/crypto/digest#digest:::init!
                          __obj5578
                          std/actor/rpc/proto/cookie#challenge-digest)
                         __obj5578)))
                  (std/crypto/digest#digest-update!__0 _digest498_ _cookie488_)
                  (std/crypto/digest#digest-update!__0
                   _digest498_
                   _challenge490_)
                  (std/crypto/digest#digest-final!__0 _digest498_))))
          (if (equal? _response495_ _secret500_)
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-connect-accept
                 _obuf487_)
                (std/net/bio/output#bio-force-output _obuf487_))
              (begin
                (std/net/bio/output#bio-write-u8
                 std/actor/rpc/proto/message#rpc-proto-connect-reject
                 _obuf487_)
                (std/net/bio/output#bio-force-output _obuf487_)
                (std/actor/proto#raise-rpc-io-error
                 'rpc-proto-authen
                 '"authentication failure"
                 _challenge490_
                 _response495_)))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto-challenge-respond
    (lambda (_ibuf469_ _obuf470_ _cookie471_)
      (let* ((_sz473_ (std/net/bio/input#bio-read-u32 _ibuf469_))
             (_g5582_ (if (fx> _sz473_ '1024)
                          (std/actor/proto#raise-rpc-io-error
                           'rpc-proto-authen
                           '"inordinately sized challenge"
                           _sz473_)
                          '#!void))
             (_challenge476_ (make-u8vector _sz473_))
             (_g5583_ (std/net/bio/input#bio-read-bytes
                       _challenge476_
                       _ibuf469_))
             (_digest479_
              (let ((__obj5579 (make-object std/crypto/digest#digest::t '2)))
                (std/crypto/digest#digest:::init!
                 __obj5579
                 std/actor/rpc/proto/cookie#challenge-digest)
                __obj5579)))
        (std/crypto/digest#digest-update!__0 _digest479_ _cookie471_)
        (std/crypto/digest#digest-update!__0 _digest479_ _challenge476_)
        (let ((_response482_ (std/crypto/digest#digest-final!__0 _digest479_)))
          (std/net/bio/output#bio-write-u32
           std/actor/rpc/proto/cookie#challenge-length
           _obuf470_)
          (std/net/bio/output#bio-write-bytes _response482_ _obuf470_)
          (std/net/bio/output#bio-force-output _obuf470_))
        (let ((_e484_ (std/net/bio/input#bio-read-u8 _ibuf469_)))
          (if (eq? _e484_ std/actor/rpc/proto/message#rpc-proto-connect-accept)
              '#!void
              (if (eof-object? _e484_)
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-authen
                   '"connection closed")
                  (std/actor/proto#raise-rpc-io-error
                   'rpc-proto-authen
                   '"authentication failure"
                   _e484_)))))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto__%
    (lambda (_cookie-file443_)
      (let ((_cookie445_ (call-with-input-file _cookie-file443_ read)))
        (if (u8vector? _cookie445_)
            (##structure
             std/actor/rpc/base#!rpc-protocol::t
             (lambda (_g446449_ _g447451_)
               (std/actor/rpc/proto/cookie#rpc-cookie-proto-connect
                _g446449_
                _g447451_
                _cookie445_))
             (lambda (_g453456_ _g454458_)
               (std/actor/rpc/proto/cookie#rpc-cookie-proto-accept
                _g453456_
                _g454458_
                _cookie445_)))
            (error '"Invalid cookie; expected u8vector"
                   _cookie-file443_
                   _cookie445_)))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto__0
    (lambda ()
      (let ((_cookie-file465_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cookie#rpc-cookie-proto__% _cookie-file465_))))
  (define std/actor/rpc/proto/cookie#rpc-cookie-proto
    (lambda _g5585_
      (let ((_g5584_ (##length _g5585_)))
        (cond ((##fx= _g5584_ 0)
               (apply std/actor/rpc/proto/cookie#rpc-cookie-proto__0 _g5585_))
              ((##fx= _g5584_ 1)
               (apply std/actor/rpc/proto/cookie#rpc-cookie-proto__% _g5585_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cookie#rpc-cookie-proto
                _g5585_))))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
    (lambda (_cookie-file426_)
      (let ((_cookie428_
             (std/crypto/etc#random-bytes
              std/actor/rpc/proto/cookie#challenge-length)))
        (call-with-output-file
         _cookie-file426_
         (lambda (_g429431_) (write _cookie428_ _g429431_))))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!__0
    (lambda ()
      (let ((_cookie-file438_ '"~/.gerbil/cookie"))
        (std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
         _cookie-file438_))))
  (define std/actor/rpc/proto/cookie#rpc-generate-cookie!
    (lambda _g5587_
      (let ((_g5586_ (##length _g5587_)))
        (cond ((##fx= _g5586_ 0)
               (apply std/actor/rpc/proto/cookie#rpc-generate-cookie!__0
                      _g5587_))
              ((##fx= _g5586_ 1)
               (apply std/actor/rpc/proto/cookie#rpc-generate-cookie!__%
                      _g5587_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/proto/cookie#rpc-generate-cookie!
                _g5587_)))))))
