(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/bytes#big 'big)
  (define std/misc/bytes#little 'little)
  (define std/misc/bytes#native 'native)
  (define std/misc/bytes#u8vector-s8-ref
    (lambda (_v2724_ _i2725_)
      (if (u8vector? _v2724_) '#!void (error '"Expected u8vector" _v2724_))
      (if (and (fixnum? _i2725_)
               (fx<= '0
                     _i2725_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2724_))
                          '1)))
          '#!void
          (error '"Bad index" _v2724_ _i2725_))
      (if (and (fixnum? '1)
               (fx<= '0
                     '1
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2724_))
                          _i2725_)))
          '#!void
          (error '"Bad integer size" _v2724_ _i2725_ '1))
      (std/misc/bytes#&u8vector-s8-ref _v2724_ _i2725_)))
  (define std/misc/bytes#&u8vector-s8-ref
    (lambda (_v2718_ _i2719_)
      (declare (not safe))
      (let ((_u82722_ (u8vector-ref _v2718_ _i2719_)))
        (if (fx> _u82722_ '127) (fx- _u82722_ '256) _u82722_))))
  (define std/misc/bytes#u8vector-s8-set!
    (lambda (_v2714_ _i2715_ _s82716_)
      (if (u8vector? _v2714_) '#!void (error '"Expected u8vector" _v2714_))
      (if (and (fixnum? _i2715_)
               (fx<= '0
                     _i2715_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2714_))
                          '1)))
          '#!void
          (error '"Bad index" _v2714_ _i2715_))
      (if (and (fixnum? '1)
               (fx<= '0
                     '1
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2714_))
                          _i2715_)))
          '#!void
          (error '"Bad integer size" _v2714_ _i2715_ '1))
      (if (fixnum? _s82716_) '#!void (error '"expected fixnum" _s82716_))
      (std/misc/bytes#&u8vector-s8-set! _v2714_ _i2715_ _s82716_)))
  (define std/misc/bytes#&u8vector-s8-set!
    (lambda (_v2707_ _i2708_ _s82709_)
      (declare (not safe))
      (let ((_u82712_ (if (fx< _s82709_ '0) (fx+ _s82709_ '256) _s82709_)))
        (u8vector-set! _v2707_ _i2708_ _u82712_))))
  (define std/misc/bytes#u8vector-uint-ref
    (lambda (_v2699_ _k2700_ _endianness2701_ _size2702_)
      (if (u8vector? _v2699_) '#!void (error '"Expected u8vector" _v2699_))
      (if (and (fixnum? _k2700_)
               (fx<= '0
                     _k2700_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2699_))
                          '1)))
          '#!void
          (error '"Bad index" _v2699_ _k2700_))
      (if (and (fixnum? _size2702_)
               (fx<= '0
                     _size2702_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2699_))
                          _k2700_)))
          '#!void
          (error '"Bad integer size" _v2699_ _k2700_ _size2702_))
      (let ((_$e2704_ _endianness2701_))
        (if (eq? 'big _$e2704_)
            (std/misc/bytes#&u8vector-uint-ref/be _v2699_ _k2700_ _size2702_)
            (if (eq? 'little _$e2704_)
                (std/misc/bytes#&u8vector-uint-ref/le
                 _v2699_
                 _k2700_
                 _size2702_)
                (if (eq? 'native _$e2704_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector-uint-ref/le
                         _v2699_
                         _k2700_
                         _size2702_)
                        (std/misc/bytes#&u8vector-uint-ref/be
                         _v2699_
                         _k2700_
                         _size2702_))
                    (error '"Bad endianness" _endianness2701_)))))))
  (define std/misc/bytes#&u8vector-uint-ref/be
    (lambda (_v2685_ _k2686_ _size2687_)
      (declare (not safe))
      (let ((_k+size2690_ (fx+ _k2686_ _size2687_)))
        (let _lp2692_ ((_i2694_ _k2686_) (_r2695_ '0))
          (if (fx< _i2694_ _k+size2690_)
              (let ((_u82697_ (u8vector-ref _v2685_ _i2694_)))
                (_lp2692_
                 (fx+ _i2694_ '1)
                 (bitwise-ior (arithmetic-shift _r2695_ '8) _u82697_)))
              _r2695_)))))
  (define std/misc/bytes#&u8vector-uint-ref/le
    (lambda (_v2671_ _k2672_ _size2673_)
      (declare (not safe))
      (let ((_k+size-12676_ (fx- (fx+ _k2672_ _size2673_) '1)))
        (let _lp2678_ ((_i2680_ _k+size-12676_) (_r2681_ '0))
          (if (fx>= _i2680_ _k2672_)
              (let ((_u82683_ (u8vector-ref _v2671_ _i2680_)))
                (_lp2678_
                 (fx- _i2680_ '1)
                 (bitwise-ior (arithmetic-shift _r2681_ '8) _u82683_)))
              _r2681_)))))
  (define std/misc/bytes#u8vector-uint-set!
    (lambda (_v2662_ _k2663_ _uint2664_ _endianness2665_ _size2666_)
      (if (u8vector? _v2662_) '#!void (error '"Expected u8vector" _v2662_))
      (if (and (fixnum? _k2663_)
               (fx<= '0
                     _k2663_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2662_))
                          '1)))
          '#!void
          (error '"Bad index" _v2662_ _k2663_))
      (if (and (fixnum? _size2666_)
               (fx<= '0
                     _size2666_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2662_))
                          _k2663_)))
          '#!void
          (error '"Bad integer size" _v2662_ _k2663_ _size2666_))
      (let ((_$e2668_ _endianness2665_))
        (if (eq? 'big _$e2668_)
            (std/misc/bytes#&u8vector-uint-set!/be
             _v2662_
             _k2663_
             _uint2664_
             _size2666_)
            (if (eq? 'little _$e2668_)
                (std/misc/bytes#&u8vector-uint-set!/le
                 _v2662_
                 _k2663_
                 _uint2664_
                 _size2666_)
                (if (eq? 'native _$e2668_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector-uint-set!/le
                         _v2662_
                         _k2663_
                         _uint2664_
                         _size2666_)
                        (std/misc/bytes#&u8vector-uint-set!/be
                         _v2662_
                         _k2663_
                         _uint2664_
                         _size2666_))
                    (error '"Bad endianness" _endianness2665_)))))))
  (define std/misc/bytes#&u8vector-uint-set!/be
    (lambda (_v2647_ _k2648_ _uint2649_ _size2650_)
      (declare (not safe))
      (let ((_k+size-12653_ (fx- (fx+ _k2648_ _size2650_) '1)))
        (let _lp2655_ ((_i2657_ _k+size-12653_) (_uint2658_ _uint2649_))
          (if (fx>= _i2657_ _k2648_)
              (let ((_u82660_ (bitwise-and _uint2658_ '255)))
                (u8vector-set! _v2647_ _i2657_ _u82660_)
                (_lp2655_ (fx- _i2657_ '1) (arithmetic-shift _uint2658_ '-8)))
              '#!void)))))
  (define std/misc/bytes#&u8vector-uint-set!/le
    (lambda (_v2632_ _k2633_ _uint2634_ _size2635_)
      (declare (not safe))
      (let ((_k+size2638_ (fx+ _k2633_ _size2635_)))
        (let _lp2640_ ((_i2642_ _k2633_) (_uint2643_ _uint2634_))
          (if (fx< _i2642_ _k+size2638_)
              (let ((_u82645_ (bitwise-and _uint2643_ '255)))
                (u8vector-set! _v2632_ _i2642_ _u82645_)
                (_lp2640_ (fx+ _i2642_ '1) (arithmetic-shift _uint2643_ '-8)))
              '#!void)))))
  (define std/misc/bytes#u8vector-sint-ref
    (lambda (_v2624_ _k2625_ _endianness2626_ _size2627_)
      (if (u8vector? _v2624_) '#!void (error '"Expected u8vector" _v2624_))
      (if (and (fixnum? _k2625_)
               (fx<= '0
                     _k2625_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2624_))
                          '1)))
          '#!void
          (error '"Bad index" _v2624_ _k2625_))
      (if (and (fixnum? _size2627_)
               (fx<= '0
                     _size2627_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2624_))
                          _k2625_)))
          '#!void
          (error '"Bad integer size" _v2624_ _k2625_ _size2627_))
      (let ((_$e2629_ _endianness2626_))
        (if (eq? 'big _$e2629_)
            (std/misc/bytes#&u8vector-sint-ref/be _v2624_ _k2625_ _size2627_)
            (if (eq? 'little _$e2629_)
                (std/misc/bytes#&u8vector-sint-ref/le
                 _v2624_
                 _k2625_
                 _size2627_)
                (if (eq? 'native _$e2629_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector-sint-ref/le
                         _v2624_
                         _k2625_
                         _size2627_)
                        (std/misc/bytes#&u8vector-sint-ref/be
                         _v2624_
                         _k2625_
                         _size2627_))
                    (error '"Bad endianness" _endianness2626_)))))))
  (define std/misc/bytes#&u8vector-sint-ref/be
    (lambda (_v2617_ _k2618_ _size2619_)
      (let ((_uint2621_
             (std/misc/bytes#&u8vector-uint-ref/be
              _v2617_
              _k2618_
              _size2619_)))
        (if (> _uint2621_ (- (expt '2 (- (fx* _size2619_ '8) '1)) '1))
            (- _uint2621_ (expt '2 (fx* _size2619_ '8)))
            _uint2621_))))
  (define std/misc/bytes#&u8vector-sint-ref/le
    (lambda (_v2610_ _k2611_ _size2612_)
      (let ((_uint2614_
             (std/misc/bytes#&u8vector-uint-ref/le
              _v2610_
              _k2611_
              _size2612_)))
        (if (> _uint2614_ (- (expt '2 (- (fx* _size2612_ '8) '1)) '1))
            (- _uint2614_ (expt '2 (fx* _size2612_ '8)))
            _uint2614_))))
  (define std/misc/bytes#u8vector-sint-set!
    (lambda (_v2601_ _k2602_ _sint2603_ _endianness2604_ _size2605_)
      (if (u8vector? _v2601_) '#!void (error '"Expected u8vector" _v2601_))
      (if (and (fixnum? _k2602_)
               (fx<= '0
                     _k2602_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2601_))
                          '1)))
          '#!void
          (error '"Bad index" _v2601_ _k2602_))
      (if (and (fixnum? _size2605_)
               (fx<= '0
                     _size2605_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2601_))
                          _k2602_)))
          '#!void
          (error '"Bad integer size" _v2601_ _k2602_ _size2605_))
      (let ((_$e2607_ _endianness2604_))
        (if (eq? 'big _$e2607_)
            (std/misc/bytes#&u8vector-sint-set!/be
             _v2601_
             _k2602_
             _sint2603_
             _size2605_)
            (if (eq? 'little _$e2607_)
                (std/misc/bytes#&u8vector-sint-set!/le
                 _v2601_
                 _k2602_
                 _sint2603_
                 _size2605_)
                (if (eq? 'native _$e2607_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector-sint-set!/le
                         _v2601_
                         _k2602_
                         _sint2603_
                         _size2605_)
                        (std/misc/bytes#&u8vector-sint-set!/be
                         _v2601_
                         _k2602_
                         _sint2603_
                         _size2605_))
                    (error '"Bad endianness" _endianness2604_)))))))
  (define std/misc/bytes#&u8vector-sint-set!/be
    (lambda (_v2594_ _k2595_ _sint2596_ _size2597_)
      (let ((_uint2599_
             (if (< _sint2596_ '0)
                 (+ _sint2596_ (expt '2 (fx* _size2597_ '8)))
                 _sint2596_)))
        (std/misc/bytes#&u8vector-uint-set!/be
         _v2594_
         _k2595_
         _uint2599_
         _size2597_))))
  (define std/misc/bytes#&u8vector-sint-set!/le
    (lambda (_v2587_ _k2588_ _sint2589_ _size2590_)
      (let ((_uint2592_
             (if (< _sint2589_ '0)
                 (+ _sint2589_ (expt '2 (fx* _size2590_ '8)))
                 _sint2589_)))
        (std/misc/bytes#&u8vector-uint-set!/le
         _v2587_
         _k2588_
         _uint2592_
         _size2590_))))
  (define std/misc/bytes#u8vector->uint-list
    (lambda (_v2580_ _endianness2581_ _size2582_)
      (if (u8vector? _v2580_) '#!void (error '"Expected u8vector" _v2580_))
      (if (and (fixnum? _size2582_)
               (fx> _size2582_ '0)
               (fxzero? (fxremainder
                         (let ()
                           (declare (not safe))
                           (##u8vector-length _v2580_))
                         _size2582_)))
          '#!void
          (error '"Bad size" _v2580_ _size2582_))
      (let ((_$e2584_ _endianness2581_))
        (if (eq? 'big _$e2584_)
            (std/misc/bytes#&u8vector->int-list
             _v2580_
             _size2582_
             std/misc/bytes#&u8vector-uint-ref/be)
            (if (eq? 'little _$e2584_)
                (std/misc/bytes#&u8vector->int-list
                 _v2580_
                 _size2582_
                 std/misc/bytes#&u8vector-uint-ref/le)
                (if (eq? 'native _$e2584_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector->int-list
                         _v2580_
                         _size2582_
                         std/misc/bytes#&u8vector-uint-ref/le)
                        (std/misc/bytes#&u8vector->int-list
                         _v2580_
                         _size2582_
                         std/misc/bytes#&u8vector-uint-ref/be))
                    (error '"Bad endianness" _endianness2581_)))))))
  (define std/misc/bytes#u8vector->sint-list
    (lambda (_v2573_ _endianness2574_ _size2575_)
      (if (u8vector? _v2573_) '#!void (error '"Expected u8vector" _v2573_))
      (if (and (fixnum? _size2575_)
               (fx> _size2575_ '0)
               (fxzero? (fxremainder
                         (let ()
                           (declare (not safe))
                           (##u8vector-length _v2573_))
                         _size2575_)))
          '#!void
          (error '"Bad size" _v2573_ _size2575_))
      (let ((_$e2577_ _endianness2574_))
        (if (eq? 'big _$e2577_)
            (std/misc/bytes#&u8vector->int-list
             _v2573_
             _size2575_
             std/misc/bytes#&u8vector-sint-ref/be)
            (if (eq? 'little _$e2577_)
                (std/misc/bytes#&u8vector->int-list
                 _v2573_
                 _size2575_
                 std/misc/bytes#&u8vector-sint-ref/le)
                (if (eq? 'native _$e2577_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector->int-list
                         _v2573_
                         _size2575_
                         std/misc/bytes#&u8vector-sint-ref/le)
                        (std/misc/bytes#&u8vector->int-list
                         _v2573_
                         _size2575_
                         std/misc/bytes#&u8vector-sint-ref/be))
                    (error '"Bad endianness" _endianness2574_)))))))
  (define std/misc/bytes#&u8vector->int-list
    (lambda (_v2559_ _size2560_ _getf2561_)
      (declare (fixnum) (not safe))
      (let ((_len2564_ (u8vector-length _v2559_)))
        (let _lp2566_ ((_i2568_ '0) (_r2569_ '()))
          (if (< _i2568_ _len2564_)
              (let ((_next2571_ (_getf2561_ _v2559_ _i2568_ _size2560_)))
                (_lp2566_ (+ _i2568_ _size2560_) (cons _next2571_ _r2569_)))
              (reverse _r2569_))))))
  (define std/misc/bytes#uint-list->u8vector
    (lambda (_lst2552_ _endianness2553_ _size2554_)
      (if (and (list? _lst2552_) (andmap1 exact-integer? _lst2552_))
          '#!void
          (error '"Expected list of exact integers" _lst2552_))
      (if (and (fixnum? _size2554_) (fx> _size2554_ '0))
          '#!void
          (error '"Bad size" _size2554_))
      (let ((_$e2556_ _endianness2553_))
        (if (eq? 'big _$e2556_)
            (std/misc/bytes#&int-list->u8vector
             _lst2552_
             _size2554_
             std/misc/bytes#&u8vector-uint-set!/be)
            (if (eq? 'little _$e2556_)
                (std/misc/bytes#&int-list->u8vector
                 _lst2552_
                 _size2554_
                 std/misc/bytes#&u8vector-uint-set!/le)
                (if (eq? 'native _$e2556_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&int-list->u8vector
                         _lst2552_
                         _size2554_
                         std/misc/bytes#&u8vector-uint-set!/le)
                        (std/misc/bytes#&int-list->u8vector
                         _lst2552_
                         _size2554_
                         std/misc/bytes#&u8vector-uint-set!/be))
                    (error '"Bad endianness" _endianness2553_)))))))
  (define std/misc/bytes#sint-list->u8vector
    (lambda (_lst2545_ _endianness2546_ _size2547_)
      (if (and (list? _lst2545_) (andmap1 exact-integer? _lst2545_))
          '#!void
          (error '"Expected list of exact integers" _lst2545_))
      (if (and (fixnum? _size2547_) (fx> _size2547_ '0))
          '#!void
          (error '"Bad size" _size2547_))
      (let ((_$e2549_ _endianness2546_))
        (if (eq? 'big _$e2549_)
            (std/misc/bytes#&int-list->u8vector
             _lst2545_
             _size2547_
             std/misc/bytes#&u8vector-sint-set!/be)
            (if (eq? 'little _$e2549_)
                (std/misc/bytes#&int-list->u8vector
                 _lst2545_
                 _size2547_
                 std/misc/bytes#&u8vector-sint-set!/le)
                (if (eq? 'native _$e2549_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&int-list->u8vector
                         _lst2545_
                         _size2547_
                         std/misc/bytes#&u8vector-sint-set!/le)
                        (std/misc/bytes#&int-list->u8vector
                         _lst2545_
                         _size2547_
                         std/misc/bytes#&u8vector-sint-set!/be))
                    (error '"Bad endianness" _endianness2546_)))))))
  (define std/misc/bytes#&int-list->u8vector
    (lambda (_lst2497_ _size2498_ _setf2499_)
      (declare (fixnum) (not safe))
      (let* ((_len2502_ (* (length _lst2497_) _size2498_))
             (_v2504_ (make-u8vector _len2502_)))
        (let _lp2507_ ((_rest2509_ _lst2497_) (_i2510_ '0))
          (let* ((_rest25112519_ _rest2509_)
                 (_else25132527_ (lambda () _v2504_))
                 (_K25152533_
                  (lambda (_rest2530_ _int2531_)
                    (_setf2499_ _v2504_ _i2510_ _int2531_ _size2498_)
                    (_lp2507_ _rest2530_ (+ _i2510_ _size2498_)))))
            (if (##pair? _rest25112519_)
                (let ((_hd25162536_ (##car _rest25112519_))
                      (_tl25172538_ (##cdr _rest25112519_)))
                  (let* ((_int2541_ _hd25162536_) (_rest2543_ _tl25172538_))
                    (_K25152533_ _rest2543_ _int2541_)))
                (_else25132527_)))))))
  (define std/misc/bytes#u8vector-u16-ref
    (lambda (_v2490_ _k2491_ _endianness2492_)
      (if (u8vector? _v2490_) '#!void (error '"Expected u8vector" _v2490_))
      (if (and (fixnum? _k2491_)
               (fx<= '0
                     _k2491_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2490_))
                          '1)))
          '#!void
          (error '"Bad index" _v2490_ _k2491_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2490_))
                          _k2491_)))
          '#!void
          (error '"Bad integer size" _v2490_ _k2491_ '2))
      (if (eq? _endianness2492_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u16-ref/native _v2490_ _k2491_)
          (let ((_$e2494_ _endianness2492_))
            (if (eq? 'big _$e2494_)
                (std/misc/bytes#&u8vector-uint-ref/be _v2490_ _k2491_ '2)
                (if (eq? 'little _$e2494_)
                    (std/misc/bytes#&u8vector-uint-ref/le _v2490_ _k2491_ '2)
                    (if (eq? 'native _$e2494_)
                        (std/misc/bytes#&u8vector-u16-ref/native
                         _v2490_
                         _k2491_)
                        (error '"Bad endianness" _endianness2492_))))))))
  (define std/misc/bytes#u8vector-u16-set!
    (lambda (_v2482_ _k2483_ _n2484_ _endianness2485_)
      (if (u8vector? _v2482_) '#!void (error '"Expected u8vector" _v2482_))
      (if (and (fixnum? _k2483_)
               (fx<= '0
                     _k2483_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2482_))
                          '1)))
          '#!void
          (error '"Bad index" _v2482_ _k2483_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2482_))
                          _k2483_)))
          '#!void
          (error '"Bad integer size" _v2482_ _k2483_ '2))
      (if (eq? _endianness2485_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u16-set!/native _v2482_ _k2483_ _n2484_)
          (let ((_$e2487_ _endianness2485_))
            (if (eq? 'big _$e2487_)
                (std/misc/bytes#&u8vector-uint-set!/be
                 _v2482_
                 _k2483_
                 _n2484_
                 '2)
                (if (eq? 'little _$e2487_)
                    (std/misc/bytes#&u8vector-uint-set!/le
                     _v2482_
                     _k2483_
                     _n2484_
                     '2)
                    (if (eq? 'native _$e2487_)
                        (std/misc/bytes#&u8vector-u16-set!/native
                         _v2482_
                         _k2483_
                         _n2484_)
                        (error '"Bad endianness" _endianness2485_))))))))
  (define std/misc/bytes#u8vector-u16-native-ref
    (lambda (_v2479_ _k2480_)
      (if (u8vector? _v2479_) '#!void (error '"Expected u8vector" _v2479_))
      (if (and (fixnum? _k2480_)
               (fx<= '0
                     _k2480_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2479_))
                          '1)))
          '#!void
          (error '"Bad index" _v2479_ _k2480_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2479_))
                          _k2480_)))
          '#!void
          (error '"Bad integer size" _v2479_ _k2480_ '2))
      (std/misc/bytes#&u8vector-u16-ref/native _v2479_ _k2480_)))
  (define std/misc/bytes#u8vector-u16-native-set!
    (lambda (_v2475_ _k2476_ _n2477_)
      (if (u8vector? _v2475_) '#!void (error '"Expected u8vector" _v2475_))
      (if (and (fixnum? _k2476_)
               (fx<= '0
                     _k2476_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2475_))
                          '1)))
          '#!void
          (error '"Bad index" _v2475_ _k2476_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2475_))
                          _k2476_)))
          '#!void
          (error '"Bad integer size" _v2475_ _k2476_ '2))
      (std/misc/bytes#&u8vector-u16-set!/native _v2475_ _k2476_ _n2477_)))
  (define std/misc/bytes#u8vector-s16-ref
    (lambda (_v2468_ _k2469_ _endianness2470_)
      (if (u8vector? _v2468_) '#!void (error '"Expected u8vector" _v2468_))
      (if (and (fixnum? _k2469_)
               (fx<= '0
                     _k2469_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2468_))
                          '1)))
          '#!void
          (error '"Bad index" _v2468_ _k2469_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2468_))
                          _k2469_)))
          '#!void
          (error '"Bad integer size" _v2468_ _k2469_ '2))
      (if (eq? _endianness2470_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s16-ref/native _v2468_ _k2469_)
          (let ((_$e2472_ _endianness2470_))
            (if (eq? 'big _$e2472_)
                (std/misc/bytes#&u8vector-sint-ref/be _v2468_ _k2469_ '2)
                (if (eq? 'little _$e2472_)
                    (std/misc/bytes#&u8vector-sint-ref/le _v2468_ _k2469_ '2)
                    (if (eq? 'native _$e2472_)
                        (std/misc/bytes#&u8vector-s16-ref/native
                         _v2468_
                         _k2469_)
                        (error '"Bad endianness" _endianness2470_))))))))
  (define std/misc/bytes#u8vector-s16-set!
    (lambda (_v2460_ _k2461_ _n2462_ _endianness2463_)
      (if (u8vector? _v2460_) '#!void (error '"Expected u8vector" _v2460_))
      (if (and (fixnum? _k2461_)
               (fx<= '0
                     _k2461_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2460_))
                          '1)))
          '#!void
          (error '"Bad index" _v2460_ _k2461_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2460_))
                          _k2461_)))
          '#!void
          (error '"Bad integer size" _v2460_ _k2461_ '2))
      (if (eq? _endianness2463_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s16-set!/native _v2460_ _k2461_ _n2462_)
          (let ((_$e2465_ _endianness2463_))
            (if (eq? 'big _$e2465_)
                (std/misc/bytes#&u8vector-sint-set!/be
                 _v2460_
                 _k2461_
                 _n2462_
                 '2)
                (if (eq? 'little _$e2465_)
                    (std/misc/bytes#&u8vector-sint-set!/le
                     _v2460_
                     _k2461_
                     _n2462_
                     '2)
                    (if (eq? 'native _$e2465_)
                        (std/misc/bytes#&u8vector-s16-set!/native
                         _v2460_
                         _k2461_
                         _n2462_)
                        (error '"Bad endianness" _endianness2463_))))))))
  (define std/misc/bytes#u8vector-s16-native-ref
    (lambda (_v2457_ _k2458_)
      (if (u8vector? _v2457_) '#!void (error '"Expected u8vector" _v2457_))
      (if (and (fixnum? _k2458_)
               (fx<= '0
                     _k2458_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2457_))
                          '1)))
          '#!void
          (error '"Bad index" _v2457_ _k2458_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2457_))
                          _k2458_)))
          '#!void
          (error '"Bad integer size" _v2457_ _k2458_ '2))
      (std/misc/bytes#&u8vector-s16-ref/native _v2457_ _k2458_)))
  (define std/misc/bytes#u8vector-s16-native-set!
    (lambda (_v2453_ _k2454_ _n2455_)
      (if (u8vector? _v2453_) '#!void (error '"Expected u8vector" _v2453_))
      (if (and (fixnum? _k2454_)
               (fx<= '0
                     _k2454_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2453_))
                          '1)))
          '#!void
          (error '"Bad index" _v2453_ _k2454_))
      (if (and (fixnum? '2)
               (fx<= '0
                     '2
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2453_))
                          _k2454_)))
          '#!void
          (error '"Bad integer size" _v2453_ _k2454_ '2))
      (std/misc/bytes#&u8vector-s16-set!/native _v2453_ _k2454_ _n2455_)))
  (define std/misc/bytes#u8vector-u32-ref
    (lambda (_v2446_ _k2447_ _endianness2448_)
      (if (u8vector? _v2446_) '#!void (error '"Expected u8vector" _v2446_))
      (if (and (fixnum? _k2447_)
               (fx<= '0
                     _k2447_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2446_))
                          '1)))
          '#!void
          (error '"Bad index" _v2446_ _k2447_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2446_))
                          _k2447_)))
          '#!void
          (error '"Bad integer size" _v2446_ _k2447_ '4))
      (if (eq? _endianness2448_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u32-ref/native _v2446_ _k2447_)
          (let ((_$e2450_ _endianness2448_))
            (if (eq? 'big _$e2450_)
                (std/misc/bytes#&u8vector-uint-ref/be _v2446_ _k2447_ '4)
                (if (eq? 'little _$e2450_)
                    (std/misc/bytes#&u8vector-uint-ref/le _v2446_ _k2447_ '4)
                    (if (eq? 'native _$e2450_)
                        (std/misc/bytes#&u8vector-u32-ref/native
                         _v2446_
                         _k2447_)
                        (error '"Bad endianness" _endianness2448_))))))))
  (define std/misc/bytes#u8vector-u32-set!
    (lambda (_v2438_ _k2439_ _n2440_ _endianness2441_)
      (if (u8vector? _v2438_) '#!void (error '"Expected u8vector" _v2438_))
      (if (and (fixnum? _k2439_)
               (fx<= '0
                     _k2439_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2438_))
                          '1)))
          '#!void
          (error '"Bad index" _v2438_ _k2439_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2438_))
                          _k2439_)))
          '#!void
          (error '"Bad integer size" _v2438_ _k2439_ '4))
      (if (eq? _endianness2441_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u32-set!/native _v2438_ _k2439_ _n2440_)
          (let ((_$e2443_ _endianness2441_))
            (if (eq? 'big _$e2443_)
                (std/misc/bytes#&u8vector-uint-set!/be
                 _v2438_
                 _k2439_
                 _n2440_
                 '4)
                (if (eq? 'little _$e2443_)
                    (std/misc/bytes#&u8vector-uint-set!/le
                     _v2438_
                     _k2439_
                     _n2440_
                     '4)
                    (if (eq? 'native _$e2443_)
                        (std/misc/bytes#&u8vector-u32-set!/native
                         _v2438_
                         _k2439_
                         _n2440_)
                        (error '"Bad endianness" _endianness2441_))))))))
  (define std/misc/bytes#u8vector-u32-native-ref
    (lambda (_v2435_ _k2436_)
      (if (u8vector? _v2435_) '#!void (error '"Expected u8vector" _v2435_))
      (if (and (fixnum? _k2436_)
               (fx<= '0
                     _k2436_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2435_))
                          '1)))
          '#!void
          (error '"Bad index" _v2435_ _k2436_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2435_))
                          _k2436_)))
          '#!void
          (error '"Bad integer size" _v2435_ _k2436_ '4))
      (std/misc/bytes#&u8vector-u32-ref/native _v2435_ _k2436_)))
  (define std/misc/bytes#u8vector-u32-native-set!
    (lambda (_v2431_ _k2432_ _n2433_)
      (if (u8vector? _v2431_) '#!void (error '"Expected u8vector" _v2431_))
      (if (and (fixnum? _k2432_)
               (fx<= '0
                     _k2432_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2431_))
                          '1)))
          '#!void
          (error '"Bad index" _v2431_ _k2432_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2431_))
                          _k2432_)))
          '#!void
          (error '"Bad integer size" _v2431_ _k2432_ '4))
      (std/misc/bytes#&u8vector-u32-set!/native _v2431_ _k2432_ _n2433_)))
  (define std/misc/bytes#u8vector-s32-ref
    (lambda (_v2424_ _k2425_ _endianness2426_)
      (if (u8vector? _v2424_) '#!void (error '"Expected u8vector" _v2424_))
      (if (and (fixnum? _k2425_)
               (fx<= '0
                     _k2425_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2424_))
                          '1)))
          '#!void
          (error '"Bad index" _v2424_ _k2425_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2424_))
                          _k2425_)))
          '#!void
          (error '"Bad integer size" _v2424_ _k2425_ '4))
      (if (eq? _endianness2426_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s32-ref/native _v2424_ _k2425_)
          (let ((_$e2428_ _endianness2426_))
            (if (eq? 'big _$e2428_)
                (std/misc/bytes#&u8vector-sint-ref/be _v2424_ _k2425_ '4)
                (if (eq? 'little _$e2428_)
                    (std/misc/bytes#&u8vector-sint-ref/le _v2424_ _k2425_ '4)
                    (if (eq? 'native _$e2428_)
                        (std/misc/bytes#&u8vector-s32-ref/native
                         _v2424_
                         _k2425_)
                        (error '"Bad endianness" _endianness2426_))))))))
  (define std/misc/bytes#u8vector-s32-set!
    (lambda (_v2416_ _k2417_ _n2418_ _endianness2419_)
      (if (u8vector? _v2416_) '#!void (error '"Expected u8vector" _v2416_))
      (if (and (fixnum? _k2417_)
               (fx<= '0
                     _k2417_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2416_))
                          '1)))
          '#!void
          (error '"Bad index" _v2416_ _k2417_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2416_))
                          _k2417_)))
          '#!void
          (error '"Bad integer size" _v2416_ _k2417_ '4))
      (if (eq? _endianness2419_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s32-set!/native _v2416_ _k2417_ _n2418_)
          (let ((_$e2421_ _endianness2419_))
            (if (eq? 'big _$e2421_)
                (std/misc/bytes#&u8vector-sint-set!/be
                 _v2416_
                 _k2417_
                 _n2418_
                 '4)
                (if (eq? 'little _$e2421_)
                    (std/misc/bytes#&u8vector-sint-set!/le
                     _v2416_
                     _k2417_
                     _n2418_
                     '4)
                    (if (eq? 'native _$e2421_)
                        (std/misc/bytes#&u8vector-s32-set!/native
                         _v2416_
                         _k2417_
                         _n2418_)
                        (error '"Bad endianness" _endianness2419_))))))))
  (define std/misc/bytes#u8vector-s32-native-ref
    (lambda (_v2413_ _k2414_)
      (if (u8vector? _v2413_) '#!void (error '"Expected u8vector" _v2413_))
      (if (and (fixnum? _k2414_)
               (fx<= '0
                     _k2414_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2413_))
                          '1)))
          '#!void
          (error '"Bad index" _v2413_ _k2414_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2413_))
                          _k2414_)))
          '#!void
          (error '"Bad integer size" _v2413_ _k2414_ '4))
      (std/misc/bytes#&u8vector-s32-ref/native _v2413_ _k2414_)))
  (define std/misc/bytes#u8vector-s32-native-set!
    (lambda (_v2409_ _k2410_ _n2411_)
      (if (u8vector? _v2409_) '#!void (error '"Expected u8vector" _v2409_))
      (if (and (fixnum? _k2410_)
               (fx<= '0
                     _k2410_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2409_))
                          '1)))
          '#!void
          (error '"Bad index" _v2409_ _k2410_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2409_))
                          _k2410_)))
          '#!void
          (error '"Bad integer size" _v2409_ _k2410_ '4))
      (std/misc/bytes#&u8vector-s32-set!/native _v2409_ _k2410_ _n2411_)))
  (define std/misc/bytes#u8vector-u64-ref
    (lambda (_v2402_ _k2403_ _endianness2404_)
      (if (u8vector? _v2402_) '#!void (error '"Expected u8vector" _v2402_))
      (if (and (fixnum? _k2403_)
               (fx<= '0
                     _k2403_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2402_))
                          '1)))
          '#!void
          (error '"Bad index" _v2402_ _k2403_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2402_))
                          _k2403_)))
          '#!void
          (error '"Bad integer size" _v2402_ _k2403_ '8))
      (if (eq? _endianness2404_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u64-ref/native _v2402_ _k2403_)
          (let ((_$e2406_ _endianness2404_))
            (if (eq? 'big _$e2406_)
                (std/misc/bytes#&u8vector-uint-ref/be _v2402_ _k2403_ '8)
                (if (eq? 'little _$e2406_)
                    (std/misc/bytes#&u8vector-uint-ref/le _v2402_ _k2403_ '8)
                    (if (eq? 'native _$e2406_)
                        (std/misc/bytes#&u8vector-u64-ref/native
                         _v2402_
                         _k2403_)
                        (error '"Bad endianness" _endianness2404_))))))))
  (define std/misc/bytes#u8vector-u64-set!
    (lambda (_v2394_ _k2395_ _n2396_ _endianness2397_)
      (if (u8vector? _v2394_) '#!void (error '"Expected u8vector" _v2394_))
      (if (and (fixnum? _k2395_)
               (fx<= '0
                     _k2395_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2394_))
                          '1)))
          '#!void
          (error '"Bad index" _v2394_ _k2395_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2394_))
                          _k2395_)))
          '#!void
          (error '"Bad integer size" _v2394_ _k2395_ '8))
      (if (eq? _endianness2397_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-u64-set!/native _v2394_ _k2395_ _n2396_)
          (let ((_$e2399_ _endianness2397_))
            (if (eq? 'big _$e2399_)
                (std/misc/bytes#&u8vector-uint-set!/be
                 _v2394_
                 _k2395_
                 _n2396_
                 '8)
                (if (eq? 'little _$e2399_)
                    (std/misc/bytes#&u8vector-uint-set!/le
                     _v2394_
                     _k2395_
                     _n2396_
                     '8)
                    (if (eq? 'native _$e2399_)
                        (std/misc/bytes#&u8vector-u64-set!/native
                         _v2394_
                         _k2395_
                         _n2396_)
                        (error '"Bad endianness" _endianness2397_))))))))
  (define std/misc/bytes#u8vector-u64-native-ref
    (lambda (_v2391_ _k2392_)
      (if (u8vector? _v2391_) '#!void (error '"Expected u8vector" _v2391_))
      (if (and (fixnum? _k2392_)
               (fx<= '0
                     _k2392_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2391_))
                          '1)))
          '#!void
          (error '"Bad index" _v2391_ _k2392_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2391_))
                          _k2392_)))
          '#!void
          (error '"Bad integer size" _v2391_ _k2392_ '8))
      (std/misc/bytes#&u8vector-u64-ref/native _v2391_ _k2392_)))
  (define std/misc/bytes#u8vector-u64-native-set!
    (lambda (_v2387_ _k2388_ _n2389_)
      (if (u8vector? _v2387_) '#!void (error '"Expected u8vector" _v2387_))
      (if (and (fixnum? _k2388_)
               (fx<= '0
                     _k2388_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2387_))
                          '1)))
          '#!void
          (error '"Bad index" _v2387_ _k2388_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2387_))
                          _k2388_)))
          '#!void
          (error '"Bad integer size" _v2387_ _k2388_ '8))
      (std/misc/bytes#&u8vector-u64-set!/native _v2387_ _k2388_ _n2389_)))
  (define std/misc/bytes#u8vector-s64-ref
    (lambda (_v2380_ _k2381_ _endianness2382_)
      (if (u8vector? _v2380_) '#!void (error '"Expected u8vector" _v2380_))
      (if (and (fixnum? _k2381_)
               (fx<= '0
                     _k2381_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2380_))
                          '1)))
          '#!void
          (error '"Bad index" _v2380_ _k2381_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2380_))
                          _k2381_)))
          '#!void
          (error '"Bad integer size" _v2380_ _k2381_ '8))
      (if (eq? _endianness2382_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s64-ref/native _v2380_ _k2381_)
          (let ((_$e2384_ _endianness2382_))
            (if (eq? 'big _$e2384_)
                (std/misc/bytes#&u8vector-sint-ref/be _v2380_ _k2381_ '8)
                (if (eq? 'little _$e2384_)
                    (std/misc/bytes#&u8vector-sint-ref/le _v2380_ _k2381_ '8)
                    (if (eq? 'native _$e2384_)
                        (std/misc/bytes#&u8vector-s64-ref/native
                         _v2380_
                         _k2381_)
                        (error '"Bad endianness" _endianness2382_))))))))
  (define std/misc/bytes#u8vector-s64-set!
    (lambda (_v2371_ _k2372_ _n2373_ _endianness2374_)
      (if (u8vector? _v2371_) '#!void (error '"Expected u8vector" _v2371_))
      (if (and (fixnum? _k2372_)
               (fx<= '0
                     _k2372_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2371_))
                          '1)))
          '#!void
          (error '"Bad index" _v2371_ _k2372_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2371_))
                          _k2372_)))
          '#!void
          (error '"Bad integer size" _v2371_ _k2372_ '8))
      (if (eq? _endianness2374_ std/misc/bytes#native-endianness)
          (std/misc/bytes#&u8vector-s64-set!/native _v2371_ _k2372_ _n2373_)
          (let ((_$e2377_ _endianness2374_))
            (if (eq? 'big _$e2377_)
                (std/misc/bytes#&u8vector-sint-set!/be
                 _v2371_
                 _k2372_
                 _n2373_
                 '8)
                (if (eq? 'little _$e2377_)
                    (std/misc/bytes#&u8vector-sint-set!/le
                     _v2371_
                     _k2372_
                     _n2373_
                     '8)
                    (if (eq? 'native _$e2377_)
                        (std/misc/bytes#&u8vector-s64-set!/native
                         _v2371_
                         _k2372_
                         _n2373_)
                        (error '"Bad endianness" _endianness2374_))))))))
  (define std/misc/bytes#u8vector-s64-native-ref
    (lambda (_v2368_ _k2369_)
      (if (u8vector? _v2368_) '#!void (error '"Expected u8vector" _v2368_))
      (if (and (fixnum? _k2369_)
               (fx<= '0
                     _k2369_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2368_))
                          '1)))
          '#!void
          (error '"Bad index" _v2368_ _k2369_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2368_))
                          _k2369_)))
          '#!void
          (error '"Bad integer size" _v2368_ _k2369_ '8))
      (std/misc/bytes#&u8vector-s64-ref/native _v2368_ _k2369_)))
  (define std/misc/bytes#u8vector-s64-native-set!
    (lambda (_v2361_ _k2363_ _n2365_)
      (if (u8vector? _v2361_) '#!void (error '"Expected u8vector" _v2361_))
      (if (and (fixnum? _k2363_)
               (fx<= '0
                     _k2363_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2361_))
                          '1)))
          '#!void
          (error '"Bad index" _v2361_ _k2363_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2361_))
                          _k2363_)))
          '#!void
          (error '"Bad integer size" _v2361_ _k2363_ '8))
      (std/misc/bytes#&u8vector-s64-set!/native _v2361_ _k2363_ _n2365_)))
  (define std/misc/bytes#u8vector-float-ref
    (lambda (_v2342_ _k2343_ _endianness2344_)
      (if (u8vector? _v2342_) '#!void (error '"Expected u8vector" _v2342_))
      (if (and (fixnum? _k2343_)
               (fx<= '0
                     _k2343_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2342_))
                          '1)))
          '#!void
          (error '"Bad index" _v2342_ _k2343_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2342_))
                          _k2343_)))
          '#!void
          (error '"Bad integer size" _v2342_ _k2343_ '4))
      (if (or (eq? _endianness2344_ std/misc/bytes#native-endianness)
              (eq? _endianness2344_ std/misc/bytes#native))
          (std/misc/bytes#&u8vector-float-ref/native _v2342_ _k2343_)
          (let ((_v*2349_ (make-u8vector '4)))
            (declare (fixnum) (not safe))
            (begin
              (let _$loop2353_ ((_i2356_ (- (+ _k2343_ '4) '1)) (_j2358_ '0))
                (if (= _j2358_ '4)
                    '#!void
                    (begin
                      (u8vector-set!
                       _v*2349_
                       _j2358_
                       (u8vector-ref _v2342_ _i2356_))
                      (_$loop2353_ (- _i2356_ '1) (+ _j2358_ '1)))))
              (std/misc/bytes#&u8vector-float-ref/native _v*2349_ '0))))))
  (define std/misc/bytes#u8vector-float-set!
    (lambda (_v2334_ _k2335_ _x2336_ _endianness2337_)
      (if (u8vector? _v2334_) '#!void (error '"Expected u8vector" _v2334_))
      (if (and (fixnum? _k2335_)
               (fx<= '0
                     _k2335_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2334_))
                          '1)))
          '#!void
          (error '"Bad index" _v2334_ _k2335_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2334_))
                          _k2335_)))
          '#!void
          (error '"Bad integer size" _v2334_ _k2335_ '4))
      (if (or (eq? _endianness2337_ std/misc/bytes#native-endianness)
              (eq? _endianness2337_ std/misc/bytes#native))
          (std/misc/bytes#&u8vector-float-set!/native _v2334_ _k2335_ _x2336_)
          (begin
            (std/misc/bytes#&u8vector-float-set!/native
             _v2334_
             _k2335_
             _x2336_)
            (std/misc/bytes#&u8vector-reverse! _v2334_ _k2335_ '4)))))
  (define std/misc/bytes#u8vector-float-native-ref
    (lambda (_v2331_ _k2332_)
      (if (u8vector? _v2331_) '#!void (error '"Expected u8vector" _v2331_))
      (if (and (fixnum? _k2332_)
               (fx<= '0
                     _k2332_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2331_))
                          '1)))
          '#!void
          (error '"Bad index" _v2331_ _k2332_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2331_))
                          _k2332_)))
          '#!void
          (error '"Bad integer size" _v2331_ _k2332_ '4))
      (std/misc/bytes#&u8vector-float-ref/native _v2331_ _k2332_)))
  (define std/misc/bytes#u8vector-float-native-set!
    (lambda (_v2327_ _k2328_ _x2329_)
      (if (u8vector? _v2327_) '#!void (error '"Expected u8vector" _v2327_))
      (if (and (fixnum? _k2328_)
               (fx<= '0
                     _k2328_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2327_))
                          '1)))
          '#!void
          (error '"Bad index" _v2327_ _k2328_))
      (if (and (fixnum? '4)
               (fx<= '0
                     '4
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2327_))
                          _k2328_)))
          '#!void
          (error '"Bad integer size" _v2327_ _k2328_ '4))
      (std/misc/bytes#&u8vector-float-set!/native _v2327_ _k2328_ _x2329_)))
  (define std/misc/bytes#u8vector-double-ref
    (lambda (_v2308_ _k2309_ _endianness2310_)
      (if (u8vector? _v2308_) '#!void (error '"Expected u8vector" _v2308_))
      (if (and (fixnum? _k2309_)
               (fx<= '0
                     _k2309_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2308_))
                          '1)))
          '#!void
          (error '"Bad index" _v2308_ _k2309_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2308_))
                          _k2309_)))
          '#!void
          (error '"Bad integer size" _v2308_ _k2309_ '8))
      (if (or (eq? _endianness2310_ std/misc/bytes#native-endianness)
              (eq? _endianness2310_ std/misc/bytes#native))
          (std/misc/bytes#&u8vector-double-ref/native _v2308_ _k2309_)
          (let ((_v*2315_ (make-u8vector '8)))
            (declare (fixnum) (not safe))
            (begin
              (let _$loop2319_ ((_i2322_ (- (+ _k2309_ '8) '1)) (_j2324_ '0))
                (if (= _j2324_ '8)
                    '#!void
                    (begin
                      (u8vector-set!
                       _v*2315_
                       _j2324_
                       (u8vector-ref _v2308_ _i2322_))
                      (_$loop2319_ (- _i2322_ '1) (+ _j2324_ '1)))))
              (std/misc/bytes#&u8vector-double-ref/native _v*2315_ '0))))))
  (define std/misc/bytes#u8vector-double-set!
    (lambda (_v2300_ _k2301_ _x2302_ _endianness2303_)
      (if (u8vector? _v2300_) '#!void (error '"Expected u8vector" _v2300_))
      (if (and (fixnum? _k2301_)
               (fx<= '0
                     _k2301_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2300_))
                          '1)))
          '#!void
          (error '"Bad index" _v2300_ _k2301_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2300_))
                          _k2301_)))
          '#!void
          (error '"Bad integer size" _v2300_ _k2301_ '8))
      (if (or (eq? _endianness2303_ std/misc/bytes#native-endianness)
              (eq? _endianness2303_ std/misc/bytes#native))
          (std/misc/bytes#&u8vector-double-set!/native _v2300_ _k2301_ _x2302_)
          (begin
            (std/misc/bytes#&u8vector-double-set!/native
             _v2300_
             _k2301_
             _x2302_)
            (std/misc/bytes#&u8vector-reverse! _v2300_ _k2301_ '8)))))
  (define std/misc/bytes#u8vector-double-native-ref
    (lambda (_v2297_ _k2298_)
      (if (u8vector? _v2297_) '#!void (error '"Expected u8vector" _v2297_))
      (if (and (fixnum? _k2298_)
               (fx<= '0
                     _k2298_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2297_))
                          '1)))
          '#!void
          (error '"Bad index" _v2297_ _k2298_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2297_))
                          _k2298_)))
          '#!void
          (error '"Bad integer size" _v2297_ _k2298_ '8))
      (std/misc/bytes#&u8vector-double-ref/native _v2297_ _k2298_)))
  (define std/misc/bytes#u8vector-double-native-set!
    (lambda (_v2293_ _k2294_ _x2295_)
      (if (u8vector? _v2293_) '#!void (error '"Expected u8vector" _v2293_))
      (if (and (fixnum? _k2294_)
               (fx<= '0
                     _k2294_
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2293_))
                          '1)))
          '#!void
          (error '"Bad index" _v2293_ _k2294_))
      (if (and (fixnum? '8)
               (fx<= '0
                     '8
                     (fx- (let ()
                            (declare (not safe))
                            (##u8vector-length _v2293_))
                          _k2294_)))
          '#!void
          (error '"Bad integer size" _v2293_ _k2294_ '8))
      (std/misc/bytes#&u8vector-double-set!/native _v2293_ _k2294_ _x2295_)))
  (define std/misc/bytes#u8vector-swap!
    (lambda (_v2287_ _j2288_ _k2289_)
      (if (u8vector? _v2287_) '#!void (error '"Expected u8vector" _v2287_))
      (let ((_len-12291_
             (fx- (let () (declare (not safe)) (##u8vector-length _v2287_))
                  '1)))
        (if (fx<= '0 _j2288_ _len-12291_)
            '#!void
            (error '"Index out of range" _v2287_ _j2288_))
        (if (fx<= '0 _k2289_ _len-12291_)
            '#!void
            (error '"Index out of range" _v2287_ _k2289_)))
      (std/misc/bytes#&u8vector-swap! _v2287_ _j2288_ _k2289_)))
  (define std/misc/bytes#&u8vector-swap!
    (lambda (_v2279_ _j2280_ _k2281_)
      (declare (not safe))
      (let ((_j-val2284_ (u8vector-ref _v2279_ _j2280_))
            (_k-val2285_ (u8vector-ref _v2279_ _k2281_)))
        (u8vector-set! _v2279_ _j2280_ _k-val2285_)
        (u8vector-set! _v2279_ _k2281_ _j-val2284_))))
  (define std/misc/bytes#u8vector-reverse!
    (lambda (_v2277_)
      (if (u8vector? _v2277_) '#!void (error '"Expected u8vector" _v2277_))
      (std/misc/bytes#&u8vector-reverse!
       _v2277_
       '0
       (u8vector-length _v2277_))))
  (define std/misc/bytes#&u8vector-reverse!
    (lambda (_v2266_ _k2267_ _size2268_)
      (declare (fixnum) (not safe))
      (let _$loop2271_ ((_left-index2274_ _k2267_)
                        (_right-index2275_ (- (+ _k2267_ _size2268_) '1)))
        (if (<= _right-index2275_ _left-index2274_)
            '#!void
            (begin
              (std/misc/bytes#&u8vector-swap!
               _v2266_
               _left-index2274_
               _right-index2275_)
              (_$loop2271_
               (+ _left-index2274_ '1)
               (- _right-index2275_ '1)))))))
  (define std/misc/bytes#u8vector-reverse
    (lambda (_v2251_)
      (declare (fixnum) (not safe))
      (begin
        (if (u8vector? _v2251_) '#!void (error '"Expected u8vector" _v2251_))
        (let* ((_len2254_ (u8vector-length _v2251_))
               (_len-12256_ (- _len2254_ '1))
               (_u2258_ (make-u8vector _len2254_)))
          (let _$loop2261_ ((_i2264_ _len-12256_))
            (if (= _i2264_ '-1)
                '#!void
                (begin
                  (u8vector-set!
                   _u2258_
                   (- _len-12256_ _i2264_)
                   (u8vector-ref _v2251_ _i2264_))
                  (_$loop2261_ (- _i2264_ '1)))))
          _u2258_))))
  (define std/misc/bytes#u8vector->bytestring__%
    (lambda (_v2222_ _delim2223_)
      (declare (fixnum) (not safe))
      (begin
        (if (u8vector? _v2222_) '#!void (error '"Expected u8vector" _v2222_))
        (if (or (not _delim2223_) (char? _delim2223_))
            '#!void
            (error '"Expected character or #f" _delim2223_))
        (let* ((_len2229_ (u8vector-length _v2222_))
               (_s2231_ (make-string
                         (+ _len2229_
                            _len2229_
                            (if (and (< '0 _len2229_) _delim2223_)
                                (- _len2229_ '1)
                                '0)))))
          (let _lp2234_ ((_i2236_ '0) (_j2237_ '0))
            (if (< _i2236_ _len2229_)
                (let ((_next2239_ (u8vector-ref _v2222_ _i2236_)))
                  (if (and (< '0 _i2236_) _delim2223_)
                      (string-set! _s2231_ (- _j2237_ '1) _delim2223_)
                      '#!void)
                  (string-set!
                   _s2231_
                   _j2237_
                   (char-upcase
                    (std/text/hex#hex (fxarithmetic-shift _next2239_ '-4))))
                  (string-set!
                   _s2231_
                   (+ _j2237_ '1)
                   (char-upcase (std/text/hex#hex (fxand _next2239_ '15))))
                  (_lp2234_
                   (+ _i2236_ '1)
                   (+ _j2237_ '2 (if _delim2223_ '1 '0))))
                '#!void))
          _s2231_))))
  (define std/misc/bytes#u8vector->bytestring__0
    (lambda (_v2244_)
      (let ((_delim2246_ '#\space))
        (std/misc/bytes#u8vector->bytestring__% _v2244_ _delim2246_))))
  (define std/misc/bytes#u8vector->bytestring
    (lambda _g6531_
      (let ((_g6530_ (let () (declare (not safe)) (##length _g6531_))))
        (cond ((let () (declare (not safe)) (##fx= _g6530_ 1))
               (apply std/misc/bytes#u8vector->bytestring__0 _g6531_))
              ((let () (declare (not safe)) (##fx= _g6530_ 2))
               (apply std/misc/bytes#u8vector->bytestring__% _g6531_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/bytes#u8vector->bytestring
                _g6531_))))))
  (define std/misc/bytes#bytestring->u8vector__%
    (lambda (_bs2197_ _delim2198_)
      (declare (fixnum) (not safe))
      (if _delim2198_
          (let ()
            (letrec* ((_invalid2202_
                       (lambda ()
                         (error '"Invalid bytestring" _bs2197_ _delim2198_)))
                      (_blen2203_ (string-length _bs2197_))
                      (_g6532_ (let ((_g6533_ (if (and (< '0 _blen2203_)
                                                       (not (zero? (modulo (+ _blen2203_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                      '1)
                                   '3))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (_invalid2202_)
                                                  '#!void)))
                                 #!void
                                 _g6533_))
                      (_parse-byte2204_
                       (lambda (_i2206_)
                         (letrec* ((_offset2208_ (* _i2206_ '3)))
                           (if (and (< '0 _offset2208_)
                                    (not (eq? _delim2198_
                                              (string-ref
                                               _bs2197_
                                               (- _offset2208_ '1)))))
                               (_invalid2202_)
                               '#!void)
                           (std/text/hex#hex-decode-byte
                            _bs2197_
                            _offset2208_)))))
              (std/misc/bytes#u8vector-init!
               (quotient (+ _blen2203_ '1) '3)
               _parse-byte2204_)))
          (std/text/hex#hex-decode__0 _bs2197_))))
  (define std/misc/bytes#bytestring->u8vector__0
    (lambda (_bs2214_)
      (let ((_delim2216_ '#\space))
        (std/misc/bytes#bytestring->u8vector__% _bs2214_ _delim2216_))))
  (define std/misc/bytes#bytestring->u8vector
    (lambda _g6536_
      (let ((_g6535_ (let () (declare (not safe)) (##length _g6536_))))
        (cond ((let () (declare (not safe)) (##fx= _g6535_ 1))
               (apply std/misc/bytes#bytestring->u8vector__0 _g6536_))
              ((let () (declare (not safe)) (##fx= _g6535_ 2))
               (apply std/misc/bytes#bytestring->u8vector__% _g6536_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/bytes#bytestring->u8vector
                _g6536_))))))
  (define std/misc/bytes#u8vector->uint__%
    (lambda (_v2180_ _endianness2181_)
      (if (u8vector? _v2180_) '#!void (error '"Expected u8vector" _v2180_))
      (let ((_$e2183_ _endianness2181_))
        (if (eq? 'big _$e2183_)
            (std/misc/bytes#&u8vector->uint/be _v2180_)
            (if (eq? 'little _$e2183_)
                (std/misc/bytes#&u8vector->uint/le _v2180_)
                (if (eq? 'native _$e2183_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&u8vector->uint/le _v2180_)
                        (std/misc/bytes#&u8vector->uint/be _v2180_))
                    (error '"Bad endianness" _endianness2181_)))))))
  (define std/misc/bytes#u8vector->uint__0
    (lambda (_v2189_)
      (let ((_endianness2191_ std/misc/bytes#big))
        (std/misc/bytes#u8vector->uint__% _v2189_ _endianness2191_))))
  (define std/misc/bytes#u8vector->uint
    (lambda _g6538_
      (let ((_g6537_ (let () (declare (not safe)) (##length _g6538_))))
        (cond ((let () (declare (not safe)) (##fx= _g6537_ 1))
               (apply std/misc/bytes#u8vector->uint__0 _g6538_))
              ((let () (declare (not safe)) (##fx= _g6537_ 2))
               (apply std/misc/bytes#u8vector->uint__% _g6538_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/bytes#u8vector->uint
                _g6538_))))))
  (define std/misc/bytes#&u8vector->uint/be
    (lambda (_v2169_)
      (declare (not safe))
      (let ((_len2172_ (u8vector-length _v2169_)))
        (let _lp2174_ ((_i2176_ '0) (_r2177_ '0))
          (if (fx< _i2176_ _len2172_)
              (_lp2174_
               (fx+ _i2176_ '1)
               (bitwise-ior
                (arithmetic-shift _r2177_ '8)
                (u8vector-ref _v2169_ _i2176_)))
              _r2177_)))))
  (define std/misc/bytes#&u8vector->uint/le
    (lambda (_v2159_)
      (declare (not safe))
      (let ((_len2162_ (u8vector-length _v2159_)))
        (let _lp2164_ ((_i2166_ (fx- _len2162_ '1)) (_r2167_ '0))
          (if (fx>= _i2166_ '0)
              (_lp2164_
               (fx- _i2166_ '1)
               (bitwise-ior
                (arithmetic-shift _r2167_ '8)
                (u8vector-ref _v2159_ _i2166_)))
              _r2167_)))))
  (define std/misc/bytes#uint->u8vector__%
    (lambda (_uint2143_ _endianness2144_)
      (if (and (exact-integer? _uint2143_) (>= _uint2143_ '0))
          '#!void
          (error '"Non-negative exact integer expected" _uint2143_))
      (let ((_$e2146_ _endianness2144_))
        (if (eq? 'big _$e2146_)
            (std/misc/bytes#&uint->u8vector/be _uint2143_)
            (if (eq? 'little _$e2146_)
                (std/misc/bytes#&uint->u8vector/le _uint2143_)
                (if (eq? 'native _$e2146_)
                    (if (eq? std/misc/bytes#native-endianness
                             std/misc/bytes#little)
                        (std/misc/bytes#&uint->u8vector/le _uint2143_)
                        (std/misc/bytes#&uint->u8vector/be _uint2143_))
                    (error '"Bad endianness" _endianness2144_)))))))
  (define std/misc/bytes#uint->u8vector__0
    (lambda (_uint2152_)
      (let ((_endianness2154_ std/misc/bytes#big))
        (std/misc/bytes#uint->u8vector__% _uint2152_ _endianness2154_))))
  (define std/misc/bytes#uint->u8vector
    (lambda _g6540_
      (let ((_g6539_ (let () (declare (not safe)) (##length _g6540_))))
        (cond ((let () (declare (not safe)) (##fx= _g6539_ 1))
               (apply std/misc/bytes#uint->u8vector__0 _g6540_))
              ((let () (declare (not safe)) (##fx= _g6539_ 2))
               (apply std/misc/bytes#uint->u8vector__% _g6540_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/bytes#uint->u8vector
                _g6540_))))))
  (define std/misc/bytes#&uint->u8vector/be
    (lambda (_uint2127_)
      (declare (not safe))
      (let* ((_bits2130_ (integer-length _uint2127_))
             (_bytes2132_
              (fx+ (fxquotient _bits2130_ '8)
                   (if (fx> (fxremainder _bits2130_ '8) '0) '1 '0)))
             (_res2134_ (make-u8vector _bytes2132_)))
        (let _lp2137_ ((_uint2139_ _uint2127_) (_i2140_ (fx- _bytes2132_ '1)))
          (if (> _uint2139_ '0)
              (begin
                (u8vector-set! _res2134_ _i2140_ (bitwise-and _uint2139_ '255))
                (_lp2137_ (arithmetic-shift _uint2139_ '-8) (fx- _i2140_ '1)))
              _res2134_)))))
  (define std/misc/bytes#&uint->u8vector/le
    (lambda (_uint2112_)
      (declare (not safe))
      (let* ((_bits2115_ (integer-length _uint2112_))
             (_bytes2117_
              (fx+ (fxquotient _bits2115_ '8)
                   (if (fx> (fxremainder _bits2115_ '8) '0) '1 '0)))
             (_res2119_ (make-u8vector _bytes2117_)))
        (let _lp2122_ ((_uint2124_ _uint2112_) (_i2125_ '0))
          (if (> _uint2124_ '0)
              (begin
                (u8vector-set! _res2119_ _i2125_ (bitwise-and _uint2124_ '255))
                (_lp2122_ (arithmetic-shift _uint2124_ '-8) (fx+ _i2125_ '1)))
              _res2119_)))))
  (define std/misc/bytes#u8vector-init!
    (lambda (_len2103_ _fun2104_)
      (declare (fixnum) (not safe))
      (letrec* ((_s2106_ (make-u8vector _len2103_)))
        (let _lp2108_ ((_i2110_ '0))
          (if (< _i2110_ _len2103_)
              (begin
                (u8vector-set! _s2106_ _i2110_ (_fun2104_ _i2110_))
                (_lp2108_ (+ _i2110_ '1)))
              '#!void))
        _s2106_)))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/misc/bytes#"
    &u8vector-double-set!/native
    &u8vector-double-ref/native
    &u8vector-float-set!/native
    &u8vector-float-ref/native
    &u8vector-s64-set!/native
    &u8vector-s64-ref/native
    &u8vector-u64-set!/native
    &u8vector-u64-ref/native
    &u8vector-s32-set!/native
    &u8vector-s32-ref/native
    &u8vector-u32-set!/native
    &u8vector-u32-ref/native
    &u8vector-s16-set!/native
    &u8vector-s16-ref/native
    &u8vector-u16-set!/native
    &u8vector-u16-ref/native
    native-endianness))
  (c-declare "#include <stdint.h>")
  (define native-endianness
    (if ((c-lambda
          ()
          scheme-object
          "#ifdef ___LITTLE_ENDIAN\n___return(___TRU);\n#else\n___return(___FAL);\n#endif"))
        'little
        'big))
  (define-c-lambda
   &u8vector-u16-ref/native
   (scheme-object int)
   unsigned-int16
   "uint16_t res = *(uint16_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-u16-set!/native
   (scheme-object int unsigned-int16)
   void
   "*(uint16_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-s16-ref/native
   (scheme-object int)
   int16
   "int16_t res = *(int16_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-s16-set!/native
   (scheme-object int int16)
   void
   "*(int16_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-u32-ref/native
   (scheme-object int)
   unsigned-int32
   "uint32_t res = *(uint32_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-u32-set!/native
   (scheme-object int unsigned-int32)
   void
   "*(uint32_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-s32-ref/native
   (scheme-object int)
   int32
   "int32_t res = *(int32_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-s32-set!/native
   (scheme-object int int32)
   void
   "*(int32_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-u64-ref/native
   (scheme-object int)
   unsigned-int64
   "uint64_t res = *(uint64_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-u64-set!/native
   (scheme-object int unsigned-int64)
   void
   "*(uint64_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-s64-ref/native
   (scheme-object int)
   int64
   "int64_t res = *(int64_t*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-s64-set!/native
   (scheme-object int int64)
   void
   "*(int64_t*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-float-ref/native
   (scheme-object int)
   float
   "float res = *(float*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-float-set!/native
   (scheme-object int float)
   void
   "*(float*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (define-c-lambda
   &u8vector-double-ref/native
   (scheme-object int)
   double
   "double res = *(double*)(U8_DATA(___arg1) + ___arg2); ___return(res);")
  (define-c-lambda
   &u8vector-double-set!/native
   (scheme-object int double)
   void
   "*(double*)(U8_DATA(___arg1) + ___arg2) = ___arg3; ___return;")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
