(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (fixnum))
  (define std/srfi/13#a:int (char->integer '#\a))
  (define std/srfi/13#z:int (char->integer '#\z))
  (define std/srfi/13#A:int (char->integer '#\A))
  (define std/srfi/13#Z:int (char->integer '#\Z))
  (define std/srfi/13#char-cased?
    (lambda (_char4091_)
      (let* ((_int4093_ (char->integer _char4091_))
             (_$e4095_
              (if (>= _int4093_ std/srfi/13#a:int)
                  (<= _int4093_ std/srfi/13#z:int)
                  '#f)))
        (if _$e4095_
            _$e4095_
            (if (>= _int4093_ std/srfi/13#A:int)
                (<= _int4093_ std/srfi/13#Z:int)
                '#f)))))
  (define std/srfi/13#char-titlecase char-upcase)
  (define std/srfi/13#substring/shared__%
    (lambda (_s4075_ _start4076_ _end4077_)
      (std/srfi/13#%substring/shared _s4075_ _start4076_ _end4077_)))
  (define std/srfi/13#substring/shared__0
    (lambda (_s4082_ _start4083_)
      (let ((_end4085_ (string-length _s4082_)))
        (std/srfi/13#%substring/shared _s4082_ _start4083_ _end4085_))))
  (define std/srfi/13#substring/shared
    (lambda _g7697_
      (let ((_g7696_ (let () (declare (not safe)) (##length _g7697_))))
        (cond ((let () (declare (not safe)) (##fx= _g7696_ 2))
               (apply std/srfi/13#substring/shared__0 _g7697_))
              ((let () (declare (not safe)) (##fx= _g7696_ 3))
               (apply std/srfi/13#%substring/shared _g7697_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#substring/shared
                _g7697_))))))
  (define std/srfi/13#%substring/shared
    (lambda (_s4070_ _start4071_ _end4072_)
      (if (and (zero? _start4071_) (= _end4072_ (string-length _s4070_)))
          _s4070_
          (substring _s4070_ _start4071_ _end4072_))))
  (define std/srfi/13#string-copy__%
    (lambda (_s4048_ _start4049_ _end4050_)
      (substring _s4048_ _start4049_ _end4050_)))
  (define std/srfi/13#string-copy__0
    (lambda (_s4055_)
      (let* ((_start4057_ '0) (_end4059_ (string-length _s4055_)))
        (substring _s4055_ _start4057_ _end4059_))))
  (define std/srfi/13#string-copy__1
    (lambda (_s4061_ _start4062_)
      (let ((_end4064_ (string-length _s4061_)))
        (substring _s4061_ _start4062_ _end4064_))))
  (define std/srfi/13#string-copy
    (lambda _g7699_
      (let ((_g7698_ (let () (declare (not safe)) (##length _g7699_))))
        (cond ((let () (declare (not safe)) (##fx= _g7698_ 1))
               (apply std/srfi/13#string-copy__0 _g7699_))
              ((let () (declare (not safe)) (##fx= _g7698_ 2))
               (apply std/srfi/13#string-copy__1 _g7699_))
              ((let () (declare (not safe)) (##fx= _g7698_ 3))
               (apply substring _g7699_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-copy
                _g7699_))))))
  (define std/srfi/13#string-map__%
    (lambda (_proc4014_ _s4015_ _start4016_ _end4017_)
      (let ((_r4019_ (make-string (- _end4017_ _start4016_))))
        (let _lp4021_ ((_i4023_ _start4016_) (_j4024_ '0))
          (if (< _i4023_ _end4017_)
              (begin
                (string-set!
                 _r4019_
                 _j4024_
                 (_proc4014_ (string-ref _s4015_ _i4023_)))
                (_lp4021_ (+ _i4023_ '1) (+ _j4024_ '1)))
              _r4019_)))))
  (define std/srfi/13#string-map__0
    (lambda (_proc4029_ _s4030_)
      (let* ((_start4032_ '0) (_end4034_ (string-length _s4030_)))
        (std/srfi/13#string-map__% _proc4029_ _s4030_ _start4032_ _end4034_))))
  (define std/srfi/13#string-map__1
    (lambda (_proc4036_ _s4037_ _start4038_)
      (let ((_end4040_ (string-length _s4037_)))
        (std/srfi/13#string-map__% _proc4036_ _s4037_ _start4038_ _end4040_))))
  (define std/srfi/13#string-map
    (lambda _g7701_
      (let ((_g7700_ (let () (declare (not safe)) (##length _g7701_))))
        (cond ((let () (declare (not safe)) (##fx= _g7700_ 2))
               (apply std/srfi/13#string-map__0 _g7701_))
              ((let () (declare (not safe)) (##fx= _g7700_ 3))
               (apply std/srfi/13#string-map__1 _g7701_))
              ((let () (declare (not safe)) (##fx= _g7700_ 4))
               (apply std/srfi/13#string-map__% _g7701_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-map
                _g7701_))))))
  (define std/srfi/13#%string-map
    (lambda (_proc3997_ _s3998_ _start3999_ _end4000_)
      (let* ((_len4002_ (- _end4000_ _start3999_))
             (_ans4004_ (make-string _len4002_)))
        (let _$loop4007_ ((_i4010_ (- _end4000_ '1))
                          (_j4011_ (- _len4002_ '1)))
          (if (< _j4011_ '0)
              '#!void
              (begin
                (string-set!
                 _ans4004_
                 _j4011_
                 (_proc3997_ (string-ref _s3998_ _i4010_)))
                (_$loop4007_ (- _i4010_ '1) (- _j4011_ '1)))))
        _ans4004_)))
  (define std/srfi/13#string-map!__%
    (lambda (_proc3967_ _s3968_ _start3969_ _end3970_)
      (let _lp3972_ ((_i3974_ _start3969_))
        (if (< _i3974_ _end3970_)
            (begin
              (string-set!
               _s3968_
               _i3974_
               (_proc3967_ (string-ref _s3968_ _i3974_)))
              (_lp3972_ (+ _i3974_ '1)))
            _s3968_))))
  (define std/srfi/13#string-map!__0
    (lambda (_proc3979_ _s3980_)
      (let* ((_start3982_ '0) (_end3984_ (string-length _s3980_)))
        (std/srfi/13#string-map!__%
         _proc3979_
         _s3980_
         _start3982_
         _end3984_))))
  (define std/srfi/13#string-map!__1
    (lambda (_proc3986_ _s3987_ _start3988_)
      (let ((_end3990_ (string-length _s3987_)))
        (std/srfi/13#string-map!__%
         _proc3986_
         _s3987_
         _start3988_
         _end3990_))))
  (define std/srfi/13#string-map!
    (lambda _g7703_
      (let ((_g7702_ (let () (declare (not safe)) (##length _g7703_))))
        (cond ((let () (declare (not safe)) (##fx= _g7702_ 2))
               (apply std/srfi/13#string-map!__0 _g7703_))
              ((let () (declare (not safe)) (##fx= _g7702_ 3))
               (apply std/srfi/13#string-map!__1 _g7703_))
              ((let () (declare (not safe)) (##fx= _g7702_ 4))
               (apply std/srfi/13#string-map!__% _g7703_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-map!
                _g7703_))))))
  (define std/srfi/13#%string-map!
    (lambda (_proc3956_ _s3957_ _start3958_ _end3959_)
      (let _$loop3961_ ((_i3964_ (- _end3959_ '1)))
        (if (< _i3964_ _start3958_)
            '#!void
            (begin
              (string-set!
               _s3957_
               _i3964_
               (_proc3956_ (string-ref _s3957_ _i3964_)))
              (_$loop3961_ (- _i3964_ '1)))))))
  (define std/srfi/13#string-fold__%
    (lambda (_kons3921_ _knil3922_ _s3923_ _start3924_ _end3925_)
      (let _lp3927_ ((_v3929_ _knil3922_) (_i3930_ _start3924_))
        (if (< _i3930_ _end3925_)
            (_lp3927_
             (_kons3921_ (string-ref _s3923_ _i3930_) _v3929_)
             (fx+ _i3930_ '1))
            _v3929_))))
  (define std/srfi/13#string-fold__0
    (lambda (_kons3935_ _knil3936_ _s3937_)
      (let* ((_start3939_ '0) (_end3941_ (string-length _s3937_)))
        (std/srfi/13#string-fold__%
         _kons3935_
         _knil3936_
         _s3937_
         _start3939_
         _end3941_))))
  (define std/srfi/13#string-fold__1
    (lambda (_kons3943_ _knil3944_ _s3945_ _start3946_)
      (let ((_end3948_ (string-length _s3945_)))
        (std/srfi/13#string-fold__%
         _kons3943_
         _knil3944_
         _s3945_
         _start3946_
         _end3948_))))
  (define std/srfi/13#string-fold
    (lambda _g7705_
      (let ((_g7704_ (let () (declare (not safe)) (##length _g7705_))))
        (cond ((let () (declare (not safe)) (##fx= _g7704_ 3))
               (apply std/srfi/13#string-fold__0 _g7705_))
              ((let () (declare (not safe)) (##fx= _g7704_ 4))
               (apply std/srfi/13#string-fold__1 _g7705_))
              ((let () (declare (not safe)) (##fx= _g7704_ 5))
               (apply std/srfi/13#string-fold__% _g7705_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-fold
                _g7705_))))))
  (define std/srfi/13#string-fold-right__%
    (lambda (_kons3885_ _knil3886_ _s3887_ _start3888_ _end3889_)
      (let _lp3891_ ((_v3893_ _knil3886_) (_i3894_ (- _end3889_ '1)))
        (if (>= _i3894_ _start3888_)
            (_lp3891_
             (_kons3885_ (string-ref _s3887_ _i3894_) _v3893_)
             (- _i3894_ '1))
            _v3893_))))
  (define std/srfi/13#string-fold-right__0
    (lambda (_kons3899_ _knil3900_ _s3901_)
      (let* ((_start3903_ '0) (_end3905_ (string-length _s3901_)))
        (std/srfi/13#string-fold-right__%
         _kons3899_
         _knil3900_
         _s3901_
         _start3903_
         _end3905_))))
  (define std/srfi/13#string-fold-right__1
    (lambda (_kons3907_ _knil3908_ _s3909_ _start3910_)
      (let ((_end3912_ (string-length _s3909_)))
        (std/srfi/13#string-fold-right__%
         _kons3907_
         _knil3908_
         _s3909_
         _start3910_
         _end3912_))))
  (define std/srfi/13#string-fold-right
    (lambda _g7707_
      (let ((_g7706_ (let () (declare (not safe)) (##length _g7707_))))
        (cond ((let () (declare (not safe)) (##fx= _g7706_ 3))
               (apply std/srfi/13#string-fold-right__0 _g7707_))
              ((let () (declare (not safe)) (##fx= _g7706_ 4))
               (apply std/srfi/13#string-fold-right__1 _g7707_))
              ((let () (declare (not safe)) (##fx= _g7706_ 5))
               (apply std/srfi/13#string-fold-right__% _g7707_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-fold-right
                _g7707_))))))
  (define std/srfi/13#string-unfold__%
    (lambda (_p3795_ _f3796_ _g3797_ _seed3798_ _base3799_ _make-final3800_)
      (let _lp3802_ ((_chunks3804_ '())
                     (_nchars3805_ '0)
                     (_chunk3806_ (make-string '40))
                     (_chunk-len3807_ '40)
                     (_i3808_ '0)
                     (_seed3809_ _seed3798_))
        (let _lp23811_ ((_i3813_ _i3808_) (_seed3814_ _seed3809_))
          (if (not (_p3795_ _seed3814_))
              (let ((_c3816_ (_f3796_ _seed3814_))
                    (_seed3817_ (_g3797_ _seed3814_)))
                (if (< _i3813_ _chunk-len3807_)
                    (begin
                      (string-set! _chunk3806_ _i3813_ _c3816_)
                      (_lp23811_ (+ _i3813_ '1) _seed3817_))
                    (let* ((_nchars23819_ (+ _chunk-len3807_ _nchars3805_))
                           (_chunk-len23821_ (min '4096 _nchars23819_))
                           (_new-chunk3823_ (make-string _chunk-len23821_)))
                      (string-set! _new-chunk3823_ '0 _c3816_)
                      (_lp3802_
                       (cons _chunk3806_ _chunks3804_)
                       (+ _nchars3805_ _chunk-len3807_)
                       _new-chunk3823_
                       _chunk-len23821_
                       '1
                       _seed3817_))))
              (let* ((_final3826_ (_make-final3800_ _seed3814_))
                     (_flen3828_ (string-length _final3826_))
                     (_base-len3830_ (string-length _base3799_))
                     (_j3832_ (+ _base-len3830_ _nchars3805_ _i3813_))
                     (_ans3834_ (make-string (+ _j3832_ _flen3828_))))
                (std/srfi/13#%string-copy!
                 _ans3834_
                 _j3832_
                 _final3826_
                 '0
                 _flen3828_)
                (let ((_j3837_ (- _j3832_ _i3813_)))
                  (std/srfi/13#%string-copy!
                   _ans3834_
                   _j3837_
                   _chunk3806_
                   '0
                   _i3813_)
                  (let _lp3839_ ((_j3841_ _j3837_) (_chunks3842_ _chunks3804_))
                    (if (pair? _chunks3842_)
                        (let* ((_chunk3844_ (car _chunks3842_))
                               (_chunks3846_ (cdr _chunks3842_))
                               (_chunk-len3848_ (string-length _chunk3844_))
                               (_j3850_ (- _j3841_ _chunk-len3848_)))
                          (std/srfi/13#%string-copy!
                           _ans3834_
                           _j3850_
                           _chunk3844_
                           '0
                           _chunk-len3848_)
                          (_lp3839_ _j3850_ _chunks3846_))
                        '#!void)))
                (std/srfi/13#%string-copy!
                 _ans3834_
                 '0
                 _base3799_
                 '0
                 _base-len3830_)
                _ans3834_))))))
  (define std/srfi/13#string-unfold__0
    (lambda (_p3856_ _f3857_ _g3858_ _seed3859_)
      (let* ((_base3861_ '"") (_make-final3865_ (lambda (_x3863_) '"")))
        (std/srfi/13#string-unfold__%
         _p3856_
         _f3857_
         _g3858_
         _seed3859_
         _base3861_
         _make-final3865_))))
  (define std/srfi/13#string-unfold__1
    (lambda (_p3867_ _f3868_ _g3869_ _seed3870_ _base3871_)
      (let ((_make-final3875_ (lambda (_x3873_) '"")))
        (std/srfi/13#string-unfold__%
         _p3867_
         _f3868_
         _g3869_
         _seed3870_
         _base3871_
         _make-final3875_))))
  (define std/srfi/13#string-unfold
    (lambda _g7709_
      (let ((_g7708_ (let () (declare (not safe)) (##length _g7709_))))
        (cond ((let () (declare (not safe)) (##fx= _g7708_ 4))
               (apply std/srfi/13#string-unfold__0 _g7709_))
              ((let () (declare (not safe)) (##fx= _g7708_ 5))
               (apply std/srfi/13#string-unfold__1 _g7709_))
              ((let () (declare (not safe)) (##fx= _g7708_ 6))
               (apply std/srfi/13#string-unfold__% _g7709_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-unfold
                _g7709_))))))
  (define std/srfi/13#string-unfold-right__%
    (lambda (_p3703_ _f3704_ _g3705_ _seed3706_ _base3707_ _make-final3708_)
      (let _lp3710_ ((_chunks3712_ '())
                     (_nchars3713_ '0)
                     (_chunk3714_ (make-string '40))
                     (_chunk-len3715_ '40)
                     (_i3716_ '40)
                     (_seed3717_ _seed3706_))
        (let _lp23719_ ((_i3721_ _i3716_) (_seed3722_ _seed3717_))
          (if (not (_p3703_ _seed3722_))
              (let ((_c3724_ (_f3704_ _seed3722_))
                    (_seed3725_ (_g3705_ _seed3722_)))
                (if (> _i3721_ '0)
                    (let ((_i3727_ (- _i3721_ '1)))
                      (string-set! _chunk3714_ _i3727_ _c3724_)
                      (_lp23719_ _i3727_ _seed3725_))
                    (let* ((_nchars23729_ (+ _chunk-len3715_ _nchars3713_))
                           (_chunk-len23731_ (min '4096 _nchars23729_))
                           (_new-chunk3733_ (make-string _chunk-len23731_))
                           (_i3735_ (- _chunk-len23731_ '1)))
                      (string-set! _new-chunk3733_ _i3735_ _c3724_)
                      (_lp3710_
                       (cons _chunk3714_ _chunks3712_)
                       (+ _nchars3713_ _chunk-len3715_)
                       _new-chunk3733_
                       _chunk-len23731_
                       _i3735_
                       _seed3725_))))
              (let* ((_final3738_ (_make-final3708_ _seed3722_))
                     (_flen3740_ (string-length _final3738_))
                     (_base-len3742_ (string-length _base3707_))
                     (_chunk-used3744_ (- _chunk-len3715_ _i3721_))
                     (_j3746_ (+ _base-len3742_ _nchars3713_ _chunk-used3744_))
                     (_ans3748_ (make-string (+ _j3746_ _flen3740_))))
                (std/srfi/13#%string-copy!
                 _ans3748_
                 '0
                 _final3738_
                 '0
                 _flen3740_)
                (std/srfi/13#%string-copy!
                 _ans3748_
                 _flen3740_
                 _chunk3714_
                 _i3721_
                 _chunk-len3715_)
                (let _lp3751_ ((_j3753_ (+ _flen3740_ _chunk-used3744_))
                               (_chunks3754_ _chunks3712_))
                  (if (pair? _chunks3754_)
                      (let* ((_chunk3756_ (car _chunks3754_))
                             (_chunks3758_ (cdr _chunks3754_))
                             (_chunk-len3760_ (string-length _chunk3756_)))
                        (std/srfi/13#%string-copy!
                         _ans3748_
                         _j3753_
                         _chunk3756_
                         '0
                         _chunk-len3760_)
                        (_lp3751_ (+ _j3753_ _chunk-len3760_) _chunks3758_))
                      (std/srfi/13#%string-copy!
                       _ans3748_
                       _j3753_
                       _base3707_
                       '0
                       _base-len3742_)))
                _ans3748_))))))
  (define std/srfi/13#string-unfold-right__0
    (lambda (_p3766_ _f3767_ _g3768_ _seed3769_)
      (let* ((_base3771_ '"") (_make-final3775_ (lambda (_x3773_) '"")))
        (std/srfi/13#string-unfold-right__%
         _p3766_
         _f3767_
         _g3768_
         _seed3769_
         _base3771_
         _make-final3775_))))
  (define std/srfi/13#string-unfold-right__1
    (lambda (_p3777_ _f3778_ _g3779_ _seed3780_ _base3781_)
      (let ((_make-final3785_ (lambda (_x3783_) '"")))
        (std/srfi/13#string-unfold-right__%
         _p3777_
         _f3778_
         _g3779_
         _seed3780_
         _base3781_
         _make-final3785_))))
  (define std/srfi/13#string-unfold-right
    (lambda _g7711_
      (let ((_g7710_ (let () (declare (not safe)) (##length _g7711_))))
        (cond ((let () (declare (not safe)) (##fx= _g7710_ 4))
               (apply std/srfi/13#string-unfold-right__0 _g7711_))
              ((let () (declare (not safe)) (##fx= _g7710_ 5))
               (apply std/srfi/13#string-unfold-right__1 _g7711_))
              ((let () (declare (not safe)) (##fx= _g7710_ 6))
               (apply std/srfi/13#string-unfold-right__% _g7711_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-unfold-right
                _g7711_))))))
  (define std/srfi/13#string-for-each__%
    (lambda (_proc3672_ _s3673_ _start3674_ _end3675_)
      (let _lp3677_ ((_i3679_ _start3674_))
        (if (< _i3679_ _end3675_)
            (begin
              (_proc3672_ (string-ref _s3673_ _i3679_))
              (_lp3677_ (+ _i3679_ '1)))
            '#!void))))
  (define std/srfi/13#string-for-each__0
    (lambda (_proc3684_ _s3685_)
      (let* ((_start3687_ '0) (_end3689_ (string-length _s3685_)))
        (std/srfi/13#string-for-each__%
         _proc3684_
         _s3685_
         _start3687_
         _end3689_))))
  (define std/srfi/13#string-for-each__1
    (lambda (_proc3691_ _s3692_ _start3693_)
      (let ((_end3695_ (string-length _s3692_)))
        (std/srfi/13#string-for-each__%
         _proc3691_
         _s3692_
         _start3693_
         _end3695_))))
  (define std/srfi/13#string-for-each
    (lambda _g7713_
      (let ((_g7712_ (let () (declare (not safe)) (##length _g7713_))))
        (cond ((let () (declare (not safe)) (##fx= _g7712_ 2))
               (apply std/srfi/13#string-for-each__0 _g7713_))
              ((let () (declare (not safe)) (##fx= _g7712_ 3))
               (apply std/srfi/13#string-for-each__1 _g7713_))
              ((let () (declare (not safe)) (##fx= _g7712_ 4))
               (apply std/srfi/13#string-for-each__% _g7713_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-for-each
                _g7713_))))))
  (define std/srfi/13#string-for-each-index__%
    (lambda (_proc3641_ _s3642_ _start3643_ _end3644_)
      (let _lp3646_ ((_i3648_ _start3643_))
        (if (< _i3648_ _end3644_)
            (begin (_proc3641_ _i3648_) (_lp3646_ (+ _i3648_ '1)))
            '#!void))))
  (define std/srfi/13#string-for-each-index__0
    (lambda (_proc3653_ _s3654_)
      (let* ((_start3656_ '0) (_end3658_ (string-length _s3654_)))
        (std/srfi/13#string-for-each-index__%
         _proc3653_
         _s3654_
         _start3656_
         _end3658_))))
  (define std/srfi/13#string-for-each-index__1
    (lambda (_proc3660_ _s3661_ _start3662_)
      (let ((_end3664_ (string-length _s3661_)))
        (std/srfi/13#string-for-each-index__%
         _proc3660_
         _s3661_
         _start3662_
         _end3664_))))
  (define std/srfi/13#string-for-each-index
    (lambda _g7715_
      (let ((_g7714_ (let () (declare (not safe)) (##length _g7715_))))
        (cond ((let () (declare (not safe)) (##fx= _g7714_ 2))
               (apply std/srfi/13#string-for-each-index__0 _g7715_))
              ((let () (declare (not safe)) (##fx= _g7714_ 3))
               (apply std/srfi/13#string-for-each-index__1 _g7715_))
              ((let () (declare (not safe)) (##fx= _g7714_ 4))
               (apply std/srfi/13#string-for-each-index__% _g7715_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-for-each-index
                _g7715_))))))
  (define std/srfi/13#string-every__%
    (lambda (_criterion3590_ _s3591_ _start3592_ _end3593_)
      (if (char? _criterion3590_)
          (let _lp3595_ ((_i3597_ _start3592_))
            (let ((_$e3599_ (>= _i3597_ _end3593_)))
              (if _$e3599_
                  _$e3599_
                  (if (char=? _criterion3590_ (string-ref _s3591_ _i3597_))
                      (_lp3595_ (+ _i3597_ '1))
                      '#f))))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion3590_
                 'std/srfi/14#:char-set))
              (let _lp3602_ ((_i3604_ _start3592_))
                (let ((_$e3606_ (>= _i3604_ _end3593_)))
                  (if _$e3606_
                      _$e3606_
                      (if (std/srfi/14#char-set-contains?
                           _criterion3590_
                           (string-ref _s3591_ _i3604_))
                          (_lp3602_ (+ _i3604_ '1))
                          '#f))))
              (if (procedure? _criterion3590_)
                  (let ((_$e3609_ (= _start3592_ _end3593_)))
                    (if _$e3609_
                        _$e3609_
                        (let _lp3612_ ((_i3614_ _start3592_))
                          (let ((_c3616_ (string-ref _s3591_ _i3614_))
                                (_i13617_ (+ _i3614_ '1)))
                            (if (= _i13617_ _end3593_)
                                (_criterion3590_ _c3616_)
                                (if (_criterion3590_ _c3616_)
                                    (_lp3612_ _i13617_)
                                    '#f))))))
                  (error '"Second param is neither char-set, char, or predicate procedure."
                         std/srfi/13#string-every
                         _criterion3590_))))))
  (define std/srfi/13#string-every__0
    (lambda (_criterion3622_ _s3623_)
      (let* ((_start3625_ '0) (_end3627_ (string-length _s3623_)))
        (std/srfi/13#string-every__%
         _criterion3622_
         _s3623_
         _start3625_
         _end3627_))))
  (define std/srfi/13#string-every__1
    (lambda (_criterion3629_ _s3630_ _start3631_)
      (let ((_end3633_ (string-length _s3630_)))
        (std/srfi/13#string-every__%
         _criterion3629_
         _s3630_
         _start3631_
         _end3633_))))
  (define std/srfi/13#string-every
    (lambda _g7717_
      (let ((_g7716_ (let () (declare (not safe)) (##length _g7717_))))
        (cond ((let () (declare (not safe)) (##fx= _g7716_ 2))
               (apply std/srfi/13#string-every__0 _g7717_))
              ((let () (declare (not safe)) (##fx= _g7716_ 3))
               (apply std/srfi/13#string-every__1 _g7717_))
              ((let () (declare (not safe)) (##fx= _g7716_ 4))
               (apply std/srfi/13#string-every__% _g7717_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-every
                _g7717_))))))
  (define std/srfi/13#string-any__%
    (lambda (_criterion3539_ _s3540_ _start3541_ _end3542_)
      (if (char? _criterion3539_)
          (let _lp3544_ ((_i3546_ _start3541_))
            (if (< _i3546_ _end3542_)
                (let ((_$e3548_
                       (char=? _criterion3539_ (string-ref _s3540_ _i3546_))))
                  (if _$e3548_ _$e3548_ (_lp3544_ (+ _i3546_ '1))))
                '#f))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion3539_
                 'std/srfi/14#:char-set))
              (let _lp3551_ ((_i3553_ _start3541_))
                (if (< _i3553_ _end3542_)
                    (let ((_$e3555_
                           (std/srfi/14#char-set-contains?
                            _criterion3539_
                            (string-ref _s3540_ _i3553_))))
                      (if _$e3555_ _$e3555_ (_lp3551_ (+ _i3553_ '1))))
                    '#f))
              (if (procedure? _criterion3539_)
                  (if (< _start3541_ _end3542_)
                      (let _lp3558_ ((_i3560_ _start3541_))
                        (let ((_c3562_ (string-ref _s3540_ _i3560_))
                              (_i13563_ (+ _i3560_ '1)))
                          (if (= _i13563_ _end3542_)
                              (_criterion3539_ _c3562_)
                              (let ((_$e3565_ (_criterion3539_ _c3562_)))
                                (if _$e3565_ _$e3565_ (_lp3558_ _i13563_))))))
                      '#f)
                  (error '"Second param is neither char-set, char, or predicate procedure."
                         std/srfi/13#string-any
                         _criterion3539_))))))
  (define std/srfi/13#string-any__0
    (lambda (_criterion3571_ _s3572_)
      (let* ((_start3574_ '0) (_end3576_ (string-length _s3572_)))
        (std/srfi/13#string-any__%
         _criterion3571_
         _s3572_
         _start3574_
         _end3576_))))
  (define std/srfi/13#string-any__1
    (lambda (_criterion3578_ _s3579_ _start3580_)
      (let ((_end3582_ (string-length _s3579_)))
        (std/srfi/13#string-any__%
         _criterion3578_
         _s3579_
         _start3580_
         _end3582_))))
  (define std/srfi/13#string-any
    (lambda _g7719_
      (let ((_g7718_ (let () (declare (not safe)) (##length _g7719_))))
        (cond ((let () (declare (not safe)) (##fx= _g7718_ 2))
               (apply std/srfi/13#string-any__0 _g7719_))
              ((let () (declare (not safe)) (##fx= _g7718_ 3))
               (apply std/srfi/13#string-any__1 _g7719_))
              ((let () (declare (not safe)) (##fx= _g7718_ 4))
               (apply std/srfi/13#string-any__% _g7719_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-any
                _g7719_))))))
  (define std/srfi/13#string-tabulate
    (lambda (_proc3528_ _len3529_)
      (let ((_s3531_ (make-string _len3529_)))
        (let _$loop3533_ ((_i3536_ (- _len3529_ '1)))
          (if (< _i3536_ '0)
              '#!void
              (begin
                (string-set! _s3531_ _i3536_ (_proc3528_ _i3536_))
                (_$loop3533_ (- _i3536_ '1)))))
        _s3531_)))
  (define std/srfi/13#%string-prefix-length
    (lambda (_s13508_ _start13509_ _end13510_ _s23511_ _start23512_ _end23513_)
      (let* ((_delta3515_
              (min (- _end13510_ _start13509_) (- _end23513_ _start23512_)))
             (_end13517_ (+ _start13509_ _delta3515_)))
        (if (and (eq? _s13508_ _s23511_) (= _start13509_ _start23512_))
            _delta3515_
            (let _lp3520_ ((_i3522_ _start13509_) (_j3523_ _start23512_))
              (if (or (>= _i3522_ _end13517_)
                      (not (char=? (string-ref _s13508_ _i3522_)
                                   (string-ref _s23511_ _j3523_))))
                  (- _i3522_ _start13509_)
                  (_lp3520_ (+ _i3522_ '1) (+ _j3523_ '1))))))))
  (define std/srfi/13#%string-suffix-length
    (lambda (_s13488_ _start13489_ _end13490_ _s23491_ _start23492_ _end23493_)
      (let* ((_delta3495_
              (min (- _end13490_ _start13489_) (- _end23493_ _start23492_)))
             (_start13497_ (- _end13490_ _delta3495_)))
        (if (and (eq? _s13488_ _s23491_) (= _end13490_ _end23493_))
            _delta3495_
            (let _lp3500_ ((_i3502_ (- _end13490_ '1))
                           (_j3503_ (- _end23493_ '1)))
              (if (or (< _i3502_ _start13497_)
                      (not (char=? (string-ref _s13488_ _i3502_)
                                   (string-ref _s23491_ _j3503_))))
                  (- (- _end13490_ _i3502_) '1)
                  (_lp3500_ (- _i3502_ '1) (- _j3503_ '1))))))))
  (define std/srfi/13#%string-prefix-length-ci
    (lambda (_s13468_ _start13469_ _end13470_ _s23471_ _start23472_ _end23473_)
      (let* ((_delta3475_
              (min (- _end13470_ _start13469_) (- _end23473_ _start23472_)))
             (_end13477_ (+ _start13469_ _delta3475_)))
        (if (and (eq? _s13468_ _s23471_) (= _start13469_ _start23472_))
            _delta3475_
            (let _lp3480_ ((_i3482_ _start13469_) (_j3483_ _start23472_))
              (if (or (>= _i3482_ _end13477_)
                      (not (char-ci=?
                            (string-ref _s13468_ _i3482_)
                            (string-ref _s23471_ _j3483_))))
                  (- _i3482_ _start13469_)
                  (_lp3480_ (+ _i3482_ '1) (+ _j3483_ '1))))))))
  (define std/srfi/13#%string-suffix-length-ci
    (lambda (_s13448_ _start13449_ _end13450_ _s23451_ _start23452_ _end23453_)
      (let* ((_delta3455_
              (min (- _end13450_ _start13449_) (- _end23453_ _start23452_)))
             (_start13457_ (- _end13450_ _delta3455_)))
        (if (and (eq? _s13448_ _s23451_) (= _end13450_ _end23453_))
            _delta3455_
            (let _lp3460_ ((_i3462_ (- _end13450_ '1))
                           (_j3463_ (- _end23453_ '1)))
              (if (or (< _i3462_ _start13457_)
                      (not (char-ci=?
                            (string-ref _s13448_ _i3462_)
                            (string-ref _s23451_ _j3463_))))
                  (- (- _end13450_ _i3462_) '1)
                  (_lp3460_ (- _i3462_ '1) (- _j3463_ '1))))))))
  (define std/srfi/13#string-prefix-length__%
    (lambda (_s13393_ _s23394_ _start13395_ _end13396_ _start23397_ _end23398_)
      (std/srfi/13#%string-prefix-length
       _s13393_
       _start13395_
       _end13396_
       _s23394_
       _start23397_
       _end23398_)))
  (define std/srfi/13#string-prefix-length__0
    (lambda (_s13403_ _s23404_)
      (let* ((_start13406_ '0)
             (_end13408_ (string-length _s13403_))
             (_start23410_ '0)
             (_end23412_ (string-length _s23404_)))
        (std/srfi/13#string-prefix-length__%
         _s13403_
         _s23404_
         _start13406_
         _end13408_
         _start23410_
         _end23412_))))
  (define std/srfi/13#string-prefix-length__1
    (lambda (_s13414_ _s23415_ _start13416_)
      (let* ((_end13418_ (string-length _s13414_))
             (_start23420_ '0)
             (_end23422_ (string-length _s23415_)))
        (std/srfi/13#string-prefix-length__%
         _s13414_
         _s23415_
         _start13416_
         _end13418_
         _start23420_
         _end23422_))))
  (define std/srfi/13#string-prefix-length__2
    (lambda (_s13424_ _s23425_ _start13426_ _end13427_)
      (let* ((_start23429_ '0) (_end23431_ (string-length _s23425_)))
        (std/srfi/13#string-prefix-length__%
         _s13424_
         _s23425_
         _start13426_
         _end13427_
         _start23429_
         _end23431_))))
  (define std/srfi/13#string-prefix-length__3
    (lambda (_s13433_ _s23434_ _start13435_ _end13436_ _start23437_)
      (let ((_end23439_ (string-length _s23434_)))
        (std/srfi/13#string-prefix-length__%
         _s13433_
         _s23434_
         _start13435_
         _end13436_
         _start23437_
         _end23439_))))
  (define std/srfi/13#string-prefix-length
    (lambda _g7721_
      (let ((_g7720_ (let () (declare (not safe)) (##length _g7721_))))
        (cond ((let () (declare (not safe)) (##fx= _g7720_ 2))
               (apply std/srfi/13#string-prefix-length__0 _g7721_))
              ((let () (declare (not safe)) (##fx= _g7720_ 3))
               (apply std/srfi/13#string-prefix-length__1 _g7721_))
              ((let () (declare (not safe)) (##fx= _g7720_ 4))
               (apply std/srfi/13#string-prefix-length__2 _g7721_))
              ((let () (declare (not safe)) (##fx= _g7720_ 5))
               (apply std/srfi/13#string-prefix-length__3 _g7721_))
              ((let () (declare (not safe)) (##fx= _g7720_ 6))
               (apply std/srfi/13#string-prefix-length__% _g7721_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-prefix-length
                _g7721_))))))
  (define std/srfi/13#string-suffix-length__%
    (lambda (_s13337_ _s23338_ _start13339_ _end13340_ _start23341_ _end23342_)
      (std/srfi/13#%string-suffix-length
       _s13337_
       _start13339_
       _end13340_
       _s23338_
       _start23341_
       _end23342_)))
  (define std/srfi/13#string-suffix-length__0
    (lambda (_s13347_ _s23348_)
      (let* ((_start13350_ '0)
             (_end13352_ (string-length _s13347_))
             (_start23354_ '0)
             (_end23356_ (string-length _s23348_)))
        (std/srfi/13#string-suffix-length__%
         _s13347_
         _s23348_
         _start13350_
         _end13352_
         _start23354_
         _end23356_))))
  (define std/srfi/13#string-suffix-length__1
    (lambda (_s13358_ _s23359_ _start13360_)
      (let* ((_end13362_ (string-length _s13358_))
             (_start23364_ '0)
             (_end23366_ (string-length _s23359_)))
        (std/srfi/13#string-suffix-length__%
         _s13358_
         _s23359_
         _start13360_
         _end13362_
         _start23364_
         _end23366_))))
  (define std/srfi/13#string-suffix-length__2
    (lambda (_s13368_ _s23369_ _start13370_ _end13371_)
      (let* ((_start23373_ '0) (_end23375_ (string-length _s23369_)))
        (std/srfi/13#string-suffix-length__%
         _s13368_
         _s23369_
         _start13370_
         _end13371_
         _start23373_
         _end23375_))))
  (define std/srfi/13#string-suffix-length__3
    (lambda (_s13377_ _s23378_ _start13379_ _end13380_ _start23381_)
      (let ((_end23383_ (string-length _s23378_)))
        (std/srfi/13#string-suffix-length__%
         _s13377_
         _s23378_
         _start13379_
         _end13380_
         _start23381_
         _end23383_))))
  (define std/srfi/13#string-suffix-length
    (lambda _g7723_
      (let ((_g7722_ (let () (declare (not safe)) (##length _g7723_))))
        (cond ((let () (declare (not safe)) (##fx= _g7722_ 2))
               (apply std/srfi/13#string-suffix-length__0 _g7723_))
              ((let () (declare (not safe)) (##fx= _g7722_ 3))
               (apply std/srfi/13#string-suffix-length__1 _g7723_))
              ((let () (declare (not safe)) (##fx= _g7722_ 4))
               (apply std/srfi/13#string-suffix-length__2 _g7723_))
              ((let () (declare (not safe)) (##fx= _g7722_ 5))
               (apply std/srfi/13#string-suffix-length__3 _g7723_))
              ((let () (declare (not safe)) (##fx= _g7722_ 6))
               (apply std/srfi/13#string-suffix-length__% _g7723_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-suffix-length
                _g7723_))))))
  (define std/srfi/13#string-prefix-length-ci__%
    (lambda (_s13281_ _s23282_ _start13283_ _end13284_ _start23285_ _end23286_)
      (std/srfi/13#%string-prefix-length-ci
       _s13281_
       _start13283_
       _end13284_
       _s23282_
       _start23285_
       _end23286_)))
  (define std/srfi/13#string-prefix-length-ci__0
    (lambda (_s13291_ _s23292_)
      (let* ((_start13294_ '0)
             (_end13296_ (string-length _s13291_))
             (_start23298_ '0)
             (_end23300_ (string-length _s23292_)))
        (std/srfi/13#string-prefix-length-ci__%
         _s13291_
         _s23292_
         _start13294_
         _end13296_
         _start23298_
         _end23300_))))
  (define std/srfi/13#string-prefix-length-ci__1
    (lambda (_s13302_ _s23303_ _start13304_)
      (let* ((_end13306_ (string-length _s13302_))
             (_start23308_ '0)
             (_end23310_ (string-length _s23303_)))
        (std/srfi/13#string-prefix-length-ci__%
         _s13302_
         _s23303_
         _start13304_
         _end13306_
         _start23308_
         _end23310_))))
  (define std/srfi/13#string-prefix-length-ci__2
    (lambda (_s13312_ _s23313_ _start13314_ _end13315_)
      (let* ((_start23317_ '0) (_end23319_ (string-length _s23313_)))
        (std/srfi/13#string-prefix-length-ci__%
         _s13312_
         _s23313_
         _start13314_
         _end13315_
         _start23317_
         _end23319_))))
  (define std/srfi/13#string-prefix-length-ci__3
    (lambda (_s13321_ _s23322_ _start13323_ _end13324_ _start23325_)
      (let ((_end23327_ (string-length _s23322_)))
        (std/srfi/13#string-prefix-length-ci__%
         _s13321_
         _s23322_
         _start13323_
         _end13324_
         _start23325_
         _end23327_))))
  (define std/srfi/13#string-prefix-length-ci
    (lambda _g7725_
      (let ((_g7724_ (let () (declare (not safe)) (##length _g7725_))))
        (cond ((let () (declare (not safe)) (##fx= _g7724_ 2))
               (apply std/srfi/13#string-prefix-length-ci__0 _g7725_))
              ((let () (declare (not safe)) (##fx= _g7724_ 3))
               (apply std/srfi/13#string-prefix-length-ci__1 _g7725_))
              ((let () (declare (not safe)) (##fx= _g7724_ 4))
               (apply std/srfi/13#string-prefix-length-ci__2 _g7725_))
              ((let () (declare (not safe)) (##fx= _g7724_ 5))
               (apply std/srfi/13#string-prefix-length-ci__3 _g7725_))
              ((let () (declare (not safe)) (##fx= _g7724_ 6))
               (apply std/srfi/13#string-prefix-length-ci__% _g7725_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-prefix-length-ci
                _g7725_))))))
  (define std/srfi/13#string-suffix-length-ci__%
    (lambda (_s13225_ _s23226_ _start13227_ _end13228_ _start23229_ _end23230_)
      (std/srfi/13#%string-suffix-length-ci
       _s13225_
       _start13227_
       _end13228_
       _s23226_
       _start23229_
       _end23230_)))
  (define std/srfi/13#string-suffix-length-ci__0
    (lambda (_s13235_ _s23236_)
      (let* ((_start13238_ '0)
             (_end13240_ (string-length _s13235_))
             (_start23242_ '0)
             (_end23244_ (string-length _s23236_)))
        (std/srfi/13#string-suffix-length-ci__%
         _s13235_
         _s23236_
         _start13238_
         _end13240_
         _start23242_
         _end23244_))))
  (define std/srfi/13#string-suffix-length-ci__1
    (lambda (_s13246_ _s23247_ _start13248_)
      (let* ((_end13250_ (string-length _s13246_))
             (_start23252_ '0)
             (_end23254_ (string-length _s23247_)))
        (std/srfi/13#string-suffix-length-ci__%
         _s13246_
         _s23247_
         _start13248_
         _end13250_
         _start23252_
         _end23254_))))
  (define std/srfi/13#string-suffix-length-ci__2
    (lambda (_s13256_ _s23257_ _start13258_ _end13259_)
      (let* ((_start23261_ '0) (_end23263_ (string-length _s23257_)))
        (std/srfi/13#string-suffix-length-ci__%
         _s13256_
         _s23257_
         _start13258_
         _end13259_
         _start23261_
         _end23263_))))
  (define std/srfi/13#string-suffix-length-ci__3
    (lambda (_s13265_ _s23266_ _start13267_ _end13268_ _start23269_)
      (let ((_end23271_ (string-length _s23266_)))
        (std/srfi/13#string-suffix-length-ci__%
         _s13265_
         _s23266_
         _start13267_
         _end13268_
         _start23269_
         _end23271_))))
  (define std/srfi/13#string-suffix-length-ci
    (lambda _g7727_
      (let ((_g7726_ (let () (declare (not safe)) (##length _g7727_))))
        (cond ((let () (declare (not safe)) (##fx= _g7726_ 2))
               (apply std/srfi/13#string-suffix-length-ci__0 _g7727_))
              ((let () (declare (not safe)) (##fx= _g7726_ 3))
               (apply std/srfi/13#string-suffix-length-ci__1 _g7727_))
              ((let () (declare (not safe)) (##fx= _g7726_ 4))
               (apply std/srfi/13#string-suffix-length-ci__2 _g7727_))
              ((let () (declare (not safe)) (##fx= _g7726_ 5))
               (apply std/srfi/13#string-suffix-length-ci__3 _g7727_))
              ((let () (declare (not safe)) (##fx= _g7726_ 6))
               (apply std/srfi/13#string-suffix-length-ci__% _g7727_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-suffix-length-ci
                _g7727_))))))
  (define std/srfi/13#string-prefix?__%
    (lambda (_s13169_ _s23170_ _start13171_ _end13172_ _start23173_ _end23174_)
      (std/srfi/13#%string-prefix?
       _s13169_
       _start13171_
       _end13172_
       _s23170_
       _start23173_
       _end23174_)))
  (define std/srfi/13#string-prefix?__0
    (lambda (_s13179_ _s23180_)
      (let* ((_start13182_ '0)
             (_end13184_ (string-length _s13179_))
             (_start23186_ '0)
             (_end23188_ (string-length _s23180_)))
        (std/srfi/13#string-prefix?__%
         _s13179_
         _s23180_
         _start13182_
         _end13184_
         _start23186_
         _end23188_))))
  (define std/srfi/13#string-prefix?__1
    (lambda (_s13190_ _s23191_ _start13192_)
      (let* ((_end13194_ (string-length _s13190_))
             (_start23196_ '0)
             (_end23198_ (string-length _s23191_)))
        (std/srfi/13#string-prefix?__%
         _s13190_
         _s23191_
         _start13192_
         _end13194_
         _start23196_
         _end23198_))))
  (define std/srfi/13#string-prefix?__2
    (lambda (_s13200_ _s23201_ _start13202_ _end13203_)
      (let* ((_start23205_ '0) (_end23207_ (string-length _s23201_)))
        (std/srfi/13#string-prefix?__%
         _s13200_
         _s23201_
         _start13202_
         _end13203_
         _start23205_
         _end23207_))))
  (define std/srfi/13#string-prefix?__3
    (lambda (_s13209_ _s23210_ _start13211_ _end13212_ _start23213_)
      (let ((_end23215_ (string-length _s23210_)))
        (std/srfi/13#string-prefix?__%
         _s13209_
         _s23210_
         _start13211_
         _end13212_
         _start23213_
         _end23215_))))
  (define std/srfi/13#string-prefix?
    (lambda _g7729_
      (let ((_g7728_ (let () (declare (not safe)) (##length _g7729_))))
        (cond ((let () (declare (not safe)) (##fx= _g7728_ 2))
               (apply std/srfi/13#string-prefix?__0 _g7729_))
              ((let () (declare (not safe)) (##fx= _g7728_ 3))
               (apply std/srfi/13#string-prefix?__1 _g7729_))
              ((let () (declare (not safe)) (##fx= _g7728_ 4))
               (apply std/srfi/13#string-prefix?__2 _g7729_))
              ((let () (declare (not safe)) (##fx= _g7728_ 5))
               (apply std/srfi/13#string-prefix?__3 _g7729_))
              ((let () (declare (not safe)) (##fx= _g7728_ 6))
               (apply std/srfi/13#string-prefix?__% _g7729_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-prefix?
                _g7729_))))))
  (define std/srfi/13#string-suffix?__%
    (lambda (_s13113_ _s23114_ _start13115_ _end13116_ _start23117_ _end23118_)
      (std/srfi/13#%string-suffix?
       _s13113_
       _start13115_
       _end13116_
       _s23114_
       _start23117_
       _end23118_)))
  (define std/srfi/13#string-suffix?__0
    (lambda (_s13123_ _s23124_)
      (let* ((_start13126_ '0)
             (_end13128_ (string-length _s13123_))
             (_start23130_ '0)
             (_end23132_ (string-length _s23124_)))
        (std/srfi/13#string-suffix?__%
         _s13123_
         _s23124_
         _start13126_
         _end13128_
         _start23130_
         _end23132_))))
  (define std/srfi/13#string-suffix?__1
    (lambda (_s13134_ _s23135_ _start13136_)
      (let* ((_end13138_ (string-length _s13134_))
             (_start23140_ '0)
             (_end23142_ (string-length _s23135_)))
        (std/srfi/13#string-suffix?__%
         _s13134_
         _s23135_
         _start13136_
         _end13138_
         _start23140_
         _end23142_))))
  (define std/srfi/13#string-suffix?__2
    (lambda (_s13144_ _s23145_ _start13146_ _end13147_)
      (let* ((_start23149_ '0) (_end23151_ (string-length _s23145_)))
        (std/srfi/13#string-suffix?__%
         _s13144_
         _s23145_
         _start13146_
         _end13147_
         _start23149_
         _end23151_))))
  (define std/srfi/13#string-suffix?__3
    (lambda (_s13153_ _s23154_ _start13155_ _end13156_ _start23157_)
      (let ((_end23159_ (string-length _s23154_)))
        (std/srfi/13#string-suffix?__%
         _s13153_
         _s23154_
         _start13155_
         _end13156_
         _start23157_
         _end23159_))))
  (define std/srfi/13#string-suffix?
    (lambda _g7731_
      (let ((_g7730_ (let () (declare (not safe)) (##length _g7731_))))
        (cond ((let () (declare (not safe)) (##fx= _g7730_ 2))
               (apply std/srfi/13#string-suffix?__0 _g7731_))
              ((let () (declare (not safe)) (##fx= _g7730_ 3))
               (apply std/srfi/13#string-suffix?__1 _g7731_))
              ((let () (declare (not safe)) (##fx= _g7730_ 4))
               (apply std/srfi/13#string-suffix?__2 _g7731_))
              ((let () (declare (not safe)) (##fx= _g7730_ 5))
               (apply std/srfi/13#string-suffix?__3 _g7731_))
              ((let () (declare (not safe)) (##fx= _g7730_ 6))
               (apply std/srfi/13#string-suffix?__% _g7731_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-suffix?
                _g7731_))))))
  (define std/srfi/13#string-prefix-ci?__%
    (lambda (_s13057_ _s23058_ _start13059_ _end13060_ _start23061_ _end23062_)
      (std/srfi/13#%string-prefix-ci?
       _s13057_
       _start13059_
       _end13060_
       _s23058_
       _start23061_
       _end23062_)))
  (define std/srfi/13#string-prefix-ci?__0
    (lambda (_s13067_ _s23068_)
      (let* ((_start13070_ '0)
             (_end13072_ (string-length _s13067_))
             (_start23074_ '0)
             (_end23076_ (string-length _s23068_)))
        (std/srfi/13#string-prefix-ci?__%
         _s13067_
         _s23068_
         _start13070_
         _end13072_
         _start23074_
         _end23076_))))
  (define std/srfi/13#string-prefix-ci?__1
    (lambda (_s13078_ _s23079_ _start13080_)
      (let* ((_end13082_ (string-length _s13078_))
             (_start23084_ '0)
             (_end23086_ (string-length _s23079_)))
        (std/srfi/13#string-prefix-ci?__%
         _s13078_
         _s23079_
         _start13080_
         _end13082_
         _start23084_
         _end23086_))))
  (define std/srfi/13#string-prefix-ci?__2
    (lambda (_s13088_ _s23089_ _start13090_ _end13091_)
      (let* ((_start23093_ '0) (_end23095_ (string-length _s23089_)))
        (std/srfi/13#string-prefix-ci?__%
         _s13088_
         _s23089_
         _start13090_
         _end13091_
         _start23093_
         _end23095_))))
  (define std/srfi/13#string-prefix-ci?__3
    (lambda (_s13097_ _s23098_ _start13099_ _end13100_ _start23101_)
      (let ((_end23103_ (string-length _s23098_)))
        (std/srfi/13#string-prefix-ci?__%
         _s13097_
         _s23098_
         _start13099_
         _end13100_
         _start23101_
         _end23103_))))
  (define std/srfi/13#string-prefix-ci?
    (lambda _g7733_
      (let ((_g7732_ (let () (declare (not safe)) (##length _g7733_))))
        (cond ((let () (declare (not safe)) (##fx= _g7732_ 2))
               (apply std/srfi/13#string-prefix-ci?__0 _g7733_))
              ((let () (declare (not safe)) (##fx= _g7732_ 3))
               (apply std/srfi/13#string-prefix-ci?__1 _g7733_))
              ((let () (declare (not safe)) (##fx= _g7732_ 4))
               (apply std/srfi/13#string-prefix-ci?__2 _g7733_))
              ((let () (declare (not safe)) (##fx= _g7732_ 5))
               (apply std/srfi/13#string-prefix-ci?__3 _g7733_))
              ((let () (declare (not safe)) (##fx= _g7732_ 6))
               (apply std/srfi/13#string-prefix-ci?__% _g7733_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-prefix-ci?
                _g7733_))))))
  (define std/srfi/13#string-suffix-ci?__%
    (lambda (_s13001_ _s23002_ _start13003_ _end13004_ _start23005_ _end23006_)
      (std/srfi/13#%string-suffix-ci?
       _s13001_
       _start13003_
       _end13004_
       _s23002_
       _start23005_
       _end23006_)))
  (define std/srfi/13#string-suffix-ci?__0
    (lambda (_s13011_ _s23012_)
      (let* ((_start13014_ '0)
             (_end13016_ (string-length _s13011_))
             (_start23018_ '0)
             (_end23020_ (string-length _s23012_)))
        (std/srfi/13#string-suffix-ci?__%
         _s13011_
         _s23012_
         _start13014_
         _end13016_
         _start23018_
         _end23020_))))
  (define std/srfi/13#string-suffix-ci?__1
    (lambda (_s13022_ _s23023_ _start13024_)
      (let* ((_end13026_ (string-length _s13022_))
             (_start23028_ '0)
             (_end23030_ (string-length _s23023_)))
        (std/srfi/13#string-suffix-ci?__%
         _s13022_
         _s23023_
         _start13024_
         _end13026_
         _start23028_
         _end23030_))))
  (define std/srfi/13#string-suffix-ci?__2
    (lambda (_s13032_ _s23033_ _start13034_ _end13035_)
      (let* ((_start23037_ '0) (_end23039_ (string-length _s23033_)))
        (std/srfi/13#string-suffix-ci?__%
         _s13032_
         _s23033_
         _start13034_
         _end13035_
         _start23037_
         _end23039_))))
  (define std/srfi/13#string-suffix-ci?__3
    (lambda (_s13041_ _s23042_ _start13043_ _end13044_ _start23045_)
      (let ((_end23047_ (string-length _s23042_)))
        (std/srfi/13#string-suffix-ci?__%
         _s13041_
         _s23042_
         _start13043_
         _end13044_
         _start23045_
         _end23047_))))
  (define std/srfi/13#string-suffix-ci?
    (lambda _g7735_
      (let ((_g7734_ (let () (declare (not safe)) (##length _g7735_))))
        (cond ((let () (declare (not safe)) (##fx= _g7734_ 2))
               (apply std/srfi/13#string-suffix-ci?__0 _g7735_))
              ((let () (declare (not safe)) (##fx= _g7734_ 3))
               (apply std/srfi/13#string-suffix-ci?__1 _g7735_))
              ((let () (declare (not safe)) (##fx= _g7734_ 4))
               (apply std/srfi/13#string-suffix-ci?__2 _g7735_))
              ((let () (declare (not safe)) (##fx= _g7734_ 5))
               (apply std/srfi/13#string-suffix-ci?__3 _g7735_))
              ((let () (declare (not safe)) (##fx= _g7734_ 6))
               (apply std/srfi/13#string-suffix-ci?__% _g7735_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-suffix-ci?
                _g7735_))))))
  (define std/srfi/13#%string-prefix?
    (lambda (_s12991_ _start12992_ _end12993_ _s22994_ _start22995_ _end22996_)
      (let ((_len12998_ (- _end12993_ _start12992_)))
        (if (<= _len12998_ (- _end22996_ _start22995_))
            (= (std/srfi/13#%string-prefix-length
                _s12991_
                _start12992_
                _end12993_
                _s22994_
                _start22995_
                _end22996_)
               _len12998_)
            '#f))))
  (define std/srfi/13#%string-suffix?
    (lambda (_s12982_ _start12983_ _end12984_ _s22985_ _start22986_ _end22987_)
      (let ((_len12989_ (- _end12984_ _start12983_)))
        (if (<= _len12989_ (- _end22987_ _start22986_))
            (= _len12989_
               (std/srfi/13#%string-suffix-length
                _s12982_
                _start12983_
                _end12984_
                _s22985_
                _start22986_
                _end22987_))
            '#f))))
  (define std/srfi/13#%string-prefix-ci?
    (lambda (_s12973_ _start12974_ _end12975_ _s22976_ _start22977_ _end22978_)
      (let ((_len12980_ (- _end12975_ _start12974_)))
        (if (<= _len12980_ (- _end22978_ _start22977_))
            (= _len12980_
               (std/srfi/13#%string-prefix-length-ci
                _s12973_
                _start12974_
                _end12975_
                _s22976_
                _start22977_
                _end22978_))
            '#f))))
  (define std/srfi/13#%string-suffix-ci?
    (lambda (_s12964_ _start12965_ _end12966_ _s22967_ _start22968_ _end22969_)
      (let ((_len12971_ (- _end12966_ _start12965_)))
        (if (<= _len12971_ (- _end22969_ _start22968_))
            (= _len12971_
               (std/srfi/13#%string-suffix-length-ci
                _s12964_
                _start12965_
                _end12966_
                _s22967_
                _start22968_
                _end22969_))
            '#f))))
  (define std/srfi/13#%string-compare
    (lambda (_s12949_
             _start12950_
             _end12951_
             _s22952_
             _start22953_
             _end22954_
             _proc<2955_
             _proc=2956_
             _proc>2957_)
      (let ((_size12959_ (- _end12951_ _start12950_))
            (_size22960_ (- _end22954_ _start22953_)))
        (let ((_match2962_
               (std/srfi/13#%string-prefix-length
                _s12949_
                _start12950_
                _end12951_
                _s22952_
                _start22953_
                _end22954_)))
          (if (= _match2962_ _size12959_)
              ((if (= _match2962_ _size22960_) _proc=2956_ _proc<2955_)
               _end12951_)
              ((if (= _match2962_ _size22960_)
                   _proc>2957_
                   (if (char<? (string-ref
                                _s12949_
                                (+ _start12950_ _match2962_))
                               (string-ref
                                _s22952_
                                (+ _start22953_ _match2962_)))
                       _proc<2955_
                       _proc>2957_))
               (+ _match2962_ _start12950_)))))))
  (define std/srfi/13#%string-compare-ci
    (lambda (_s12934_
             _start12935_
             _end12936_
             _s22937_
             _start22938_
             _end22939_
             _proc<2940_
             _proc=2941_
             _proc>2942_)
      (let ((_size12944_ (- _end12936_ _start12935_))
            (_size22945_ (- _end22939_ _start22938_)))
        (let ((_match2947_
               (std/srfi/13#%string-prefix-length-ci
                _s12934_
                _start12935_
                _end12936_
                _s22937_
                _start22938_
                _end22939_)))
          (if (= _match2947_ _size12944_)
              ((if (= _match2947_ _size22945_) _proc=2941_ _proc<2940_)
               _end12936_)
              ((if (= _match2947_ _size22945_)
                   _proc>2942_
                   (if (char-ci<?
                        (string-ref _s12934_ (+ _start12935_ _match2947_))
                        (string-ref _s22937_ (+ _start22938_ _match2947_)))
                       _proc<2940_
                       _proc>2942_))
               (+ _start12935_ _match2947_)))))))
  (define std/srfi/13#string-compare__%
    (lambda (_s12861_
             _s22862_
             _proc<2863_
             _proc=2864_
             _proc>2865_
             _start12866_
             _end12867_
             _start22868_
             _end22869_)
      (std/srfi/13#%string-compare
       _s12861_
       _start12866_
       _end12867_
       _s22862_
       _start22868_
       _end22869_
       _proc<2863_
       _proc=2864_
       _proc>2865_)))
  (define std/srfi/13#string-compare__0
    (lambda (_s12874_ _s22875_ _proc<2876_ _proc=2877_ _proc>2878_)
      (let* ((_start12880_ '0)
             (_end12882_ (string-length _s12874_))
             (_start22884_ '0)
             (_end22886_ (string-length _s22875_)))
        (std/srfi/13#string-compare__%
         _s12874_
         _s22875_
         _proc<2876_
         _proc=2877_
         _proc>2878_
         _start12880_
         _end12882_
         _start22884_
         _end22886_))))
  (define std/srfi/13#string-compare__1
    (lambda (_s12888_
             _s22889_
             _proc<2890_
             _proc=2891_
             _proc>2892_
             _start12893_)
      (let* ((_end12895_ (string-length _s12888_))
             (_start22897_ '0)
             (_end22899_ (string-length _s22889_)))
        (std/srfi/13#string-compare__%
         _s12888_
         _s22889_
         _proc<2890_
         _proc=2891_
         _proc>2892_
         _start12893_
         _end12895_
         _start22897_
         _end22899_))))
  (define std/srfi/13#string-compare__2
    (lambda (_s12901_
             _s22902_
             _proc<2903_
             _proc=2904_
             _proc>2905_
             _start12906_
             _end12907_)
      (let* ((_start22909_ '0) (_end22911_ (string-length _s22902_)))
        (std/srfi/13#string-compare__%
         _s12901_
         _s22902_
         _proc<2903_
         _proc=2904_
         _proc>2905_
         _start12906_
         _end12907_
         _start22909_
         _end22911_))))
  (define std/srfi/13#string-compare__3
    (lambda (_s12913_
             _s22914_
             _proc<2915_
             _proc=2916_
             _proc>2917_
             _start12918_
             _end12919_
             _start22920_)
      (let ((_end22922_ (string-length _s22914_)))
        (std/srfi/13#string-compare__%
         _s12913_
         _s22914_
         _proc<2915_
         _proc=2916_
         _proc>2917_
         _start12918_
         _end12919_
         _start22920_
         _end22922_))))
  (define std/srfi/13#string-compare
    (lambda _g7737_
      (let ((_g7736_ (let () (declare (not safe)) (##length _g7737_))))
        (cond ((let () (declare (not safe)) (##fx= _g7736_ 5))
               (apply std/srfi/13#string-compare__0 _g7737_))
              ((let () (declare (not safe)) (##fx= _g7736_ 6))
               (apply std/srfi/13#string-compare__1 _g7737_))
              ((let () (declare (not safe)) (##fx= _g7736_ 7))
               (apply std/srfi/13#string-compare__2 _g7737_))
              ((let () (declare (not safe)) (##fx= _g7736_ 8))
               (apply std/srfi/13#string-compare__3 _g7737_))
              ((let () (declare (not safe)) (##fx= _g7736_ 9))
               (apply std/srfi/13#string-compare__% _g7737_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-compare
                _g7737_))))))
  (define std/srfi/13#string-compare-ci__%
    (lambda (_s12787_
             _s22788_
             _proc<2789_
             _proc=2790_
             _proc>2791_
             _start12792_
             _end12793_
             _start22794_
             _end22795_)
      (std/srfi/13#%string-compare-ci
       _s12787_
       _start12792_
       _end12793_
       _s22788_
       _start22794_
       _end22795_
       _proc<2789_
       _proc=2790_
       _proc>2791_)))
  (define std/srfi/13#string-compare-ci__0
    (lambda (_s12800_ _s22801_ _proc<2802_ _proc=2803_ _proc>2804_)
      (let* ((_start12806_ '0)
             (_end12808_ (string-length _s12800_))
             (_start22810_ '0)
             (_end22812_ (string-length _s22801_)))
        (std/srfi/13#string-compare-ci__%
         _s12800_
         _s22801_
         _proc<2802_
         _proc=2803_
         _proc>2804_
         _start12806_
         _end12808_
         _start22810_
         _end22812_))))
  (define std/srfi/13#string-compare-ci__1
    (lambda (_s12814_
             _s22815_
             _proc<2816_
             _proc=2817_
             _proc>2818_
             _start12819_)
      (let* ((_end12821_ (string-length _s12814_))
             (_start22823_ '0)
             (_end22825_ (string-length _s22815_)))
        (std/srfi/13#string-compare-ci__%
         _s12814_
         _s22815_
         _proc<2816_
         _proc=2817_
         _proc>2818_
         _start12819_
         _end12821_
         _start22823_
         _end22825_))))
  (define std/srfi/13#string-compare-ci__2
    (lambda (_s12827_
             _s22828_
             _proc<2829_
             _proc=2830_
             _proc>2831_
             _start12832_
             _end12833_)
      (let* ((_start22835_ '0) (_end22837_ (string-length _s22828_)))
        (std/srfi/13#string-compare-ci__%
         _s12827_
         _s22828_
         _proc<2829_
         _proc=2830_
         _proc>2831_
         _start12832_
         _end12833_
         _start22835_
         _end22837_))))
  (define std/srfi/13#string-compare-ci__3
    (lambda (_s12839_
             _s22840_
             _proc<2841_
             _proc=2842_
             _proc>2843_
             _start12844_
             _end12845_
             _start22846_)
      (let ((_end22848_ (string-length _s22840_)))
        (std/srfi/13#string-compare-ci__%
         _s12839_
         _s22840_
         _proc<2841_
         _proc=2842_
         _proc>2843_
         _start12844_
         _end12845_
         _start22846_
         _end22848_))))
  (define std/srfi/13#string-compare-ci
    (lambda _g7739_
      (let ((_g7738_ (let () (declare (not safe)) (##length _g7739_))))
        (cond ((let () (declare (not safe)) (##fx= _g7738_ 5))
               (apply std/srfi/13#string-compare-ci__0 _g7739_))
              ((let () (declare (not safe)) (##fx= _g7738_ 6))
               (apply std/srfi/13#string-compare-ci__1 _g7739_))
              ((let () (declare (not safe)) (##fx= _g7738_ 7))
               (apply std/srfi/13#string-compare-ci__2 _g7739_))
              ((let () (declare (not safe)) (##fx= _g7738_ 8))
               (apply std/srfi/13#string-compare-ci__3 _g7739_))
              ((let () (declare (not safe)) (##fx= _g7738_ 9))
               (apply std/srfi/13#string-compare-ci__% _g7739_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-compare-ci
                _g7739_))))))
  (define std/srfi/13#string=__%
    (lambda (_s12724_ _s22725_ _start12726_ _end12727_ _start22728_ _end22729_)
      (if (= (- _end12727_ _start12726_) (- _end22729_ _start22728_))
          (let ((_$e2731_
                 (if (eq? _s12724_ _s22725_)
                     (= _start12726_ _start22728_)
                     '#f)))
            (if _$e2731_
                _$e2731_
                (std/srfi/13#%string-compare
                 _s12724_
                 _start12726_
                 _end12727_
                 _s22725_
                 _start22728_
                 _end22729_
                 (lambda (_i2734_) '#f)
                 values
                 (lambda (_i2736_) '#f))))
          '#f)))
  (define std/srfi/13#string=__0
    (lambda (_s12741_ _s22742_)
      (let* ((_start12744_ '0)
             (_end12746_ (string-length _s12741_))
             (_start22748_ '0)
             (_end22750_ (string-length _s22742_)))
        (std/srfi/13#string=__%
         _s12741_
         _s22742_
         _start12744_
         _end12746_
         _start22748_
         _end22750_))))
  (define std/srfi/13#string=__1
    (lambda (_s12752_ _s22753_ _start12754_)
      (let* ((_end12756_ (string-length _s12752_))
             (_start22758_ '0)
             (_end22760_ (string-length _s22753_)))
        (std/srfi/13#string=__%
         _s12752_
         _s22753_
         _start12754_
         _end12756_
         _start22758_
         _end22760_))))
  (define std/srfi/13#string=__2
    (lambda (_s12762_ _s22763_ _start12764_ _end12765_)
      (let* ((_start22767_ '0) (_end22769_ (string-length _s22763_)))
        (std/srfi/13#string=__%
         _s12762_
         _s22763_
         _start12764_
         _end12765_
         _start22767_
         _end22769_))))
  (define std/srfi/13#string=__3
    (lambda (_s12771_ _s22772_ _start12773_ _end12774_ _start22775_)
      (let ((_end22777_ (string-length _s22772_)))
        (std/srfi/13#string=__%
         _s12771_
         _s22772_
         _start12773_
         _end12774_
         _start22775_
         _end22777_))))
  (define std/srfi/13#string=
    (lambda _g7741_
      (let ((_g7740_ (let () (declare (not safe)) (##length _g7741_))))
        (cond ((let () (declare (not safe)) (##fx= _g7740_ 2))
               (apply std/srfi/13#string=__0 _g7741_))
              ((let () (declare (not safe)) (##fx= _g7740_ 3))
               (apply std/srfi/13#string=__1 _g7741_))
              ((let () (declare (not safe)) (##fx= _g7740_ 4))
               (apply std/srfi/13#string=__2 _g7741_))
              ((let () (declare (not safe)) (##fx= _g7740_ 5))
               (apply std/srfi/13#string=__3 _g7741_))
              ((let () (declare (not safe)) (##fx= _g7740_ 6))
               (apply std/srfi/13#string=__% _g7741_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string=
                _g7741_))))))
  (define std/srfi/13#string<>__%
    (lambda (_s12663_ _s22664_ _start12665_ _end12666_ _start22667_ _end22668_)
      (let ((_$e2670_
             (not (= (- _end12666_ _start12665_)
                     (- _end22668_ _start22667_)))))
        (if _$e2670_
            _$e2670_
            (if (not (and (eq? _s12663_ _s22664_)
                          (= _start12665_ _start22667_)))
                (std/srfi/13#%string-compare
                 _s12663_
                 _start12665_
                 _end12666_
                 _s22664_
                 _start22667_
                 _end22668_
                 values
                 (lambda (_i2673_) '#f)
                 values)
                '#f)))))
  (define std/srfi/13#string<>__0
    (lambda (_s12678_ _s22679_)
      (let* ((_start12681_ '0)
             (_end12683_ (string-length _s12678_))
             (_start22685_ '0)
             (_end22687_ (string-length _s22679_)))
        (std/srfi/13#string<>__%
         _s12678_
         _s22679_
         _start12681_
         _end12683_
         _start22685_
         _end22687_))))
  (define std/srfi/13#string<>__1
    (lambda (_s12689_ _s22690_ _start12691_)
      (let* ((_end12693_ (string-length _s12689_))
             (_start22695_ '0)
             (_end22697_ (string-length _s22690_)))
        (std/srfi/13#string<>__%
         _s12689_
         _s22690_
         _start12691_
         _end12693_
         _start22695_
         _end22697_))))
  (define std/srfi/13#string<>__2
    (lambda (_s12699_ _s22700_ _start12701_ _end12702_)
      (let* ((_start22704_ '0) (_end22706_ (string-length _s22700_)))
        (std/srfi/13#string<>__%
         _s12699_
         _s22700_
         _start12701_
         _end12702_
         _start22704_
         _end22706_))))
  (define std/srfi/13#string<>__3
    (lambda (_s12708_ _s22709_ _start12710_ _end12711_ _start22712_)
      (let ((_end22714_ (string-length _s22709_)))
        (std/srfi/13#string<>__%
         _s12708_
         _s22709_
         _start12710_
         _end12711_
         _start22712_
         _end22714_))))
  (define std/srfi/13#string<>
    (lambda _g7743_
      (let ((_g7742_ (let () (declare (not safe)) (##length _g7743_))))
        (cond ((let () (declare (not safe)) (##fx= _g7742_ 2))
               (apply std/srfi/13#string<>__0 _g7743_))
              ((let () (declare (not safe)) (##fx= _g7742_ 3))
               (apply std/srfi/13#string<>__1 _g7743_))
              ((let () (declare (not safe)) (##fx= _g7742_ 4))
               (apply std/srfi/13#string<>__2 _g7743_))
              ((let () (declare (not safe)) (##fx= _g7742_ 5))
               (apply std/srfi/13#string<>__3 _g7743_))
              ((let () (declare (not safe)) (##fx= _g7742_ 6))
               (apply std/srfi/13#string<>__% _g7743_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string<>
                _g7743_))))))
  (define std/srfi/13#string<__%
    (lambda (_s12603_ _s22604_ _start12605_ _end12606_ _start22607_ _end22608_)
      (if (and (eq? _s12603_ _s22604_) (= _start12605_ _start22607_))
          (< _end12606_ _end22608_)
          (std/srfi/13#%string-compare
           _s12603_
           _start12605_
           _end12606_
           _s22604_
           _start22607_
           _end22608_
           values
           (lambda (_i2610_) '#f)
           (lambda (_i2612_) '#f)))))
  (define std/srfi/13#string<__0
    (lambda (_s12617_ _s22618_)
      (let* ((_start12620_ '0)
             (_end12622_ (string-length _s12617_))
             (_start22624_ '0)
             (_end22626_ (string-length _s22618_)))
        (std/srfi/13#string<__%
         _s12617_
         _s22618_
         _start12620_
         _end12622_
         _start22624_
         _end22626_))))
  (define std/srfi/13#string<__1
    (lambda (_s12628_ _s22629_ _start12630_)
      (let* ((_end12632_ (string-length _s12628_))
             (_start22634_ '0)
             (_end22636_ (string-length _s22629_)))
        (std/srfi/13#string<__%
         _s12628_
         _s22629_
         _start12630_
         _end12632_
         _start22634_
         _end22636_))))
  (define std/srfi/13#string<__2
    (lambda (_s12638_ _s22639_ _start12640_ _end12641_)
      (let* ((_start22643_ '0) (_end22645_ (string-length _s22639_)))
        (std/srfi/13#string<__%
         _s12638_
         _s22639_
         _start12640_
         _end12641_
         _start22643_
         _end22645_))))
  (define std/srfi/13#string<__3
    (lambda (_s12647_ _s22648_ _start12649_ _end12650_ _start22651_)
      (let ((_end22653_ (string-length _s22648_)))
        (std/srfi/13#string<__%
         _s12647_
         _s22648_
         _start12649_
         _end12650_
         _start22651_
         _end22653_))))
  (define std/srfi/13#string<
    (lambda _g7745_
      (let ((_g7744_ (let () (declare (not safe)) (##length _g7745_))))
        (cond ((let () (declare (not safe)) (##fx= _g7744_ 2))
               (apply std/srfi/13#string<__0 _g7745_))
              ((let () (declare (not safe)) (##fx= _g7744_ 3))
               (apply std/srfi/13#string<__1 _g7745_))
              ((let () (declare (not safe)) (##fx= _g7744_ 4))
               (apply std/srfi/13#string<__2 _g7745_))
              ((let () (declare (not safe)) (##fx= _g7744_ 5))
               (apply std/srfi/13#string<__3 _g7745_))
              ((let () (declare (not safe)) (##fx= _g7744_ 6))
               (apply std/srfi/13#string<__% _g7745_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string<
                _g7745_))))))
  (define std/srfi/13#string>__%
    (lambda (_s12543_ _s22544_ _start12545_ _end12546_ _start22547_ _end22548_)
      (if (and (eq? _s12543_ _s22544_) (= _start12545_ _start22547_))
          (> _end12546_ _end22548_)
          (std/srfi/13#%string-compare
           _s12543_
           _start12545_
           _end12546_
           _s22544_
           _start22547_
           _end22548_
           (lambda (_i2550_) '#f)
           (lambda (_i2552_) '#f)
           values))))
  (define std/srfi/13#string>__0
    (lambda (_s12557_ _s22558_)
      (let* ((_start12560_ '0)
             (_end12562_ (string-length _s12557_))
             (_start22564_ '0)
             (_end22566_ (string-length _s22558_)))
        (std/srfi/13#string>__%
         _s12557_
         _s22558_
         _start12560_
         _end12562_
         _start22564_
         _end22566_))))
  (define std/srfi/13#string>__1
    (lambda (_s12568_ _s22569_ _start12570_)
      (let* ((_end12572_ (string-length _s12568_))
             (_start22574_ '0)
             (_end22576_ (string-length _s22569_)))
        (std/srfi/13#string>__%
         _s12568_
         _s22569_
         _start12570_
         _end12572_
         _start22574_
         _end22576_))))
  (define std/srfi/13#string>__2
    (lambda (_s12578_ _s22579_ _start12580_ _end12581_)
      (let* ((_start22583_ '0) (_end22585_ (string-length _s22579_)))
        (std/srfi/13#string>__%
         _s12578_
         _s22579_
         _start12580_
         _end12581_
         _start22583_
         _end22585_))))
  (define std/srfi/13#string>__3
    (lambda (_s12587_ _s22588_ _start12589_ _end12590_ _start22591_)
      (let ((_end22593_ (string-length _s22588_)))
        (std/srfi/13#string>__%
         _s12587_
         _s22588_
         _start12589_
         _end12590_
         _start22591_
         _end22593_))))
  (define std/srfi/13#string>
    (lambda _g7747_
      (let ((_g7746_ (let () (declare (not safe)) (##length _g7747_))))
        (cond ((let () (declare (not safe)) (##fx= _g7746_ 2))
               (apply std/srfi/13#string>__0 _g7747_))
              ((let () (declare (not safe)) (##fx= _g7746_ 3))
               (apply std/srfi/13#string>__1 _g7747_))
              ((let () (declare (not safe)) (##fx= _g7746_ 4))
               (apply std/srfi/13#string>__2 _g7747_))
              ((let () (declare (not safe)) (##fx= _g7746_ 5))
               (apply std/srfi/13#string>__3 _g7747_))
              ((let () (declare (not safe)) (##fx= _g7746_ 6))
               (apply std/srfi/13#string>__% _g7747_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string>
                _g7747_))))))
  (define std/srfi/13#string<=__%
    (lambda (_s12485_ _s22486_ _start12487_ _end12488_ _start22489_ _end22490_)
      (if (and (eq? _s12485_ _s22486_) (= _start12487_ _start22489_))
          (<= _end12488_ _end22490_)
          (std/srfi/13#%string-compare
           _s12485_
           _start12487_
           _end12488_
           _s22486_
           _start22489_
           _end22490_
           values
           values
           (lambda (_i2492_) '#f)))))
  (define std/srfi/13#string<=__0
    (lambda (_s12497_ _s22498_)
      (let* ((_start12500_ '0)
             (_end12502_ (string-length _s12497_))
             (_start22504_ '0)
             (_end22506_ (string-length _s22498_)))
        (std/srfi/13#string<=__%
         _s12497_
         _s22498_
         _start12500_
         _end12502_
         _start22504_
         _end22506_))))
  (define std/srfi/13#string<=__1
    (lambda (_s12508_ _s22509_ _start12510_)
      (let* ((_end12512_ (string-length _s12508_))
             (_start22514_ '0)
             (_end22516_ (string-length _s22509_)))
        (std/srfi/13#string<=__%
         _s12508_
         _s22509_
         _start12510_
         _end12512_
         _start22514_
         _end22516_))))
  (define std/srfi/13#string<=__2
    (lambda (_s12518_ _s22519_ _start12520_ _end12521_)
      (let* ((_start22523_ '0) (_end22525_ (string-length _s22519_)))
        (std/srfi/13#string<=__%
         _s12518_
         _s22519_
         _start12520_
         _end12521_
         _start22523_
         _end22525_))))
  (define std/srfi/13#string<=__3
    (lambda (_s12527_ _s22528_ _start12529_ _end12530_ _start22531_)
      (let ((_end22533_ (string-length _s22528_)))
        (std/srfi/13#string<=__%
         _s12527_
         _s22528_
         _start12529_
         _end12530_
         _start22531_
         _end22533_))))
  (define std/srfi/13#string<=
    (lambda _g7749_
      (let ((_g7748_ (let () (declare (not safe)) (##length _g7749_))))
        (cond ((let () (declare (not safe)) (##fx= _g7748_ 2))
               (apply std/srfi/13#string<=__0 _g7749_))
              ((let () (declare (not safe)) (##fx= _g7748_ 3))
               (apply std/srfi/13#string<=__1 _g7749_))
              ((let () (declare (not safe)) (##fx= _g7748_ 4))
               (apply std/srfi/13#string<=__2 _g7749_))
              ((let () (declare (not safe)) (##fx= _g7748_ 5))
               (apply std/srfi/13#string<=__3 _g7749_))
              ((let () (declare (not safe)) (##fx= _g7748_ 6))
               (apply std/srfi/13#string<=__% _g7749_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string<=
                _g7749_))))))
  (define std/srfi/13#string>=__%
    (lambda (_s12427_ _s22428_ _start12429_ _end12430_ _start22431_ _end22432_)
      (if (and (eq? _s12427_ _s22428_) (= _start12429_ _start22431_))
          (>= _end12430_ _end22432_)
          (std/srfi/13#%string-compare
           _s12427_
           _start12429_
           _end12430_
           _s22428_
           _start22431_
           _end22432_
           (lambda (_i2434_) '#f)
           values
           values))))
  (define std/srfi/13#string>=__0
    (lambda (_s12439_ _s22440_)
      (let* ((_start12442_ '0)
             (_end12444_ (string-length _s12439_))
             (_start22446_ '0)
             (_end22448_ (string-length _s22440_)))
        (std/srfi/13#string>=__%
         _s12439_
         _s22440_
         _start12442_
         _end12444_
         _start22446_
         _end22448_))))
  (define std/srfi/13#string>=__1
    (lambda (_s12450_ _s22451_ _start12452_)
      (let* ((_end12454_ (string-length _s12450_))
             (_start22456_ '0)
             (_end22458_ (string-length _s22451_)))
        (std/srfi/13#string>=__%
         _s12450_
         _s22451_
         _start12452_
         _end12454_
         _start22456_
         _end22458_))))
  (define std/srfi/13#string>=__2
    (lambda (_s12460_ _s22461_ _start12462_ _end12463_)
      (let* ((_start22465_ '0) (_end22467_ (string-length _s22461_)))
        (std/srfi/13#string>=__%
         _s12460_
         _s22461_
         _start12462_
         _end12463_
         _start22465_
         _end22467_))))
  (define std/srfi/13#string>=__3
    (lambda (_s12469_ _s22470_ _start12471_ _end12472_ _start22473_)
      (let ((_end22475_ (string-length _s22470_)))
        (std/srfi/13#string>=__%
         _s12469_
         _s22470_
         _start12471_
         _end12472_
         _start22473_
         _end22475_))))
  (define std/srfi/13#string>=
    (lambda _g7751_
      (let ((_g7750_ (let () (declare (not safe)) (##length _g7751_))))
        (cond ((let () (declare (not safe)) (##fx= _g7750_ 2))
               (apply std/srfi/13#string>=__0 _g7751_))
              ((let () (declare (not safe)) (##fx= _g7750_ 3))
               (apply std/srfi/13#string>=__1 _g7751_))
              ((let () (declare (not safe)) (##fx= _g7750_ 4))
               (apply std/srfi/13#string>=__2 _g7751_))
              ((let () (declare (not safe)) (##fx= _g7750_ 5))
               (apply std/srfi/13#string>=__3 _g7751_))
              ((let () (declare (not safe)) (##fx= _g7750_ 6))
               (apply std/srfi/13#string>=__% _g7751_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string>=
                _g7751_))))))
  (define std/srfi/13#string-ci=__%
    (lambda (_s12364_ _s22365_ _start12366_ _end12367_ _start22368_ _end22369_)
      (if (= (- _end12367_ _start12366_) (- _end22369_ _start22368_))
          (let ((_$e2371_
                 (if (eq? _s12364_ _s22365_)
                     (= _start12366_ _start22368_)
                     '#f)))
            (if _$e2371_
                _$e2371_
                (std/srfi/13#%string-compare-ci
                 _s12364_
                 _start12366_
                 _end12367_
                 _s22365_
                 _start22368_
                 _end22369_
                 (lambda (_i2374_) '#f)
                 values
                 (lambda (_i2376_) '#f))))
          '#f)))
  (define std/srfi/13#string-ci=__0
    (lambda (_s12381_ _s22382_)
      (let* ((_start12384_ '0)
             (_end12386_ (string-length _s12381_))
             (_start22388_ '0)
             (_end22390_ (string-length _s22382_)))
        (std/srfi/13#string-ci=__%
         _s12381_
         _s22382_
         _start12384_
         _end12386_
         _start22388_
         _end22390_))))
  (define std/srfi/13#string-ci=__1
    (lambda (_s12392_ _s22393_ _start12394_)
      (let* ((_end12396_ (string-length _s12392_))
             (_start22398_ '0)
             (_end22400_ (string-length _s22393_)))
        (std/srfi/13#string-ci=__%
         _s12392_
         _s22393_
         _start12394_
         _end12396_
         _start22398_
         _end22400_))))
  (define std/srfi/13#string-ci=__2
    (lambda (_s12402_ _s22403_ _start12404_ _end12405_)
      (let* ((_start22407_ '0) (_end22409_ (string-length _s22403_)))
        (std/srfi/13#string-ci=__%
         _s12402_
         _s22403_
         _start12404_
         _end12405_
         _start22407_
         _end22409_))))
  (define std/srfi/13#string-ci=__3
    (lambda (_s12411_ _s22412_ _start12413_ _end12414_ _start22415_)
      (let ((_end22417_ (string-length _s22412_)))
        (std/srfi/13#string-ci=__%
         _s12411_
         _s22412_
         _start12413_
         _end12414_
         _start22415_
         _end22417_))))
  (define std/srfi/13#string-ci=
    (lambda _g7753_
      (let ((_g7752_ (let () (declare (not safe)) (##length _g7753_))))
        (cond ((let () (declare (not safe)) (##fx= _g7752_ 2))
               (apply std/srfi/13#string-ci=__0 _g7753_))
              ((let () (declare (not safe)) (##fx= _g7752_ 3))
               (apply std/srfi/13#string-ci=__1 _g7753_))
              ((let () (declare (not safe)) (##fx= _g7752_ 4))
               (apply std/srfi/13#string-ci=__2 _g7753_))
              ((let () (declare (not safe)) (##fx= _g7752_ 5))
               (apply std/srfi/13#string-ci=__3 _g7753_))
              ((let () (declare (not safe)) (##fx= _g7752_ 6))
               (apply std/srfi/13#string-ci=__% _g7753_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci=
                _g7753_))))))
  (define std/srfi/13#string-ci<>__%
    (lambda (_s12303_ _s22304_ _start12305_ _end12306_ _start22307_ _end22308_)
      (let ((_$e2310_
             (not (= (- _end12306_ _start12305_)
                     (- _end22308_ _start22307_)))))
        (if _$e2310_
            _$e2310_
            (if (not (and (eq? _s12303_ _s22304_)
                          (= _start12305_ _start22307_)))
                (std/srfi/13#%string-compare-ci
                 _s12303_
                 _start12305_
                 _end12306_
                 _s22304_
                 _start22307_
                 _end22308_
                 values
                 (lambda (_i2313_) '#f)
                 values)
                '#f)))))
  (define std/srfi/13#string-ci<>__0
    (lambda (_s12318_ _s22319_)
      (let* ((_start12321_ '0)
             (_end12323_ (string-length _s12318_))
             (_start22325_ '0)
             (_end22327_ (string-length _s22319_)))
        (std/srfi/13#string-ci<>__%
         _s12318_
         _s22319_
         _start12321_
         _end12323_
         _start22325_
         _end22327_))))
  (define std/srfi/13#string-ci<>__1
    (lambda (_s12329_ _s22330_ _start12331_)
      (let* ((_end12333_ (string-length _s12329_))
             (_start22335_ '0)
             (_end22337_ (string-length _s22330_)))
        (std/srfi/13#string-ci<>__%
         _s12329_
         _s22330_
         _start12331_
         _end12333_
         _start22335_
         _end22337_))))
  (define std/srfi/13#string-ci<>__2
    (lambda (_s12339_ _s22340_ _start12341_ _end12342_)
      (let* ((_start22344_ '0) (_end22346_ (string-length _s22340_)))
        (std/srfi/13#string-ci<>__%
         _s12339_
         _s22340_
         _start12341_
         _end12342_
         _start22344_
         _end22346_))))
  (define std/srfi/13#string-ci<>__3
    (lambda (_s12348_ _s22349_ _start12350_ _end12351_ _start22352_)
      (let ((_end22354_ (string-length _s22349_)))
        (std/srfi/13#string-ci<>__%
         _s12348_
         _s22349_
         _start12350_
         _end12351_
         _start22352_
         _end22354_))))
  (define std/srfi/13#string-ci<>
    (lambda _g7755_
      (let ((_g7754_ (let () (declare (not safe)) (##length _g7755_))))
        (cond ((let () (declare (not safe)) (##fx= _g7754_ 2))
               (apply std/srfi/13#string-ci<>__0 _g7755_))
              ((let () (declare (not safe)) (##fx= _g7754_ 3))
               (apply std/srfi/13#string-ci<>__1 _g7755_))
              ((let () (declare (not safe)) (##fx= _g7754_ 4))
               (apply std/srfi/13#string-ci<>__2 _g7755_))
              ((let () (declare (not safe)) (##fx= _g7754_ 5))
               (apply std/srfi/13#string-ci<>__3 _g7755_))
              ((let () (declare (not safe)) (##fx= _g7754_ 6))
               (apply std/srfi/13#string-ci<>__% _g7755_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci<>
                _g7755_))))))
  (define std/srfi/13#string-ci<__%
    (lambda (_s12243_ _s22244_ _start12245_ _end12246_ _start22247_ _end22248_)
      (if (and (eq? _s12243_ _s22244_) (= _start12245_ _start22247_))
          (< _end12246_ _end22248_)
          (std/srfi/13#%string-compare-ci
           _s12243_
           _start12245_
           _end12246_
           _s22244_
           _start22247_
           _end22248_
           values
           (lambda (_i2250_) '#f)
           (lambda (_i2252_) '#f)))))
  (define std/srfi/13#string-ci<__0
    (lambda (_s12257_ _s22258_)
      (let* ((_start12260_ '0)
             (_end12262_ (string-length _s12257_))
             (_start22264_ '0)
             (_end22266_ (string-length _s22258_)))
        (std/srfi/13#string-ci<__%
         _s12257_
         _s22258_
         _start12260_
         _end12262_
         _start22264_
         _end22266_))))
  (define std/srfi/13#string-ci<__1
    (lambda (_s12268_ _s22269_ _start12270_)
      (let* ((_end12272_ (string-length _s12268_))
             (_start22274_ '0)
             (_end22276_ (string-length _s22269_)))
        (std/srfi/13#string-ci<__%
         _s12268_
         _s22269_
         _start12270_
         _end12272_
         _start22274_
         _end22276_))))
  (define std/srfi/13#string-ci<__2
    (lambda (_s12278_ _s22279_ _start12280_ _end12281_)
      (let* ((_start22283_ '0) (_end22285_ (string-length _s22279_)))
        (std/srfi/13#string-ci<__%
         _s12278_
         _s22279_
         _start12280_
         _end12281_
         _start22283_
         _end22285_))))
  (define std/srfi/13#string-ci<__3
    (lambda (_s12287_ _s22288_ _start12289_ _end12290_ _start22291_)
      (let ((_end22293_ (string-length _s22288_)))
        (std/srfi/13#string-ci<__%
         _s12287_
         _s22288_
         _start12289_
         _end12290_
         _start22291_
         _end22293_))))
  (define std/srfi/13#string-ci<
    (lambda _g7757_
      (let ((_g7756_ (let () (declare (not safe)) (##length _g7757_))))
        (cond ((let () (declare (not safe)) (##fx= _g7756_ 2))
               (apply std/srfi/13#string-ci<__0 _g7757_))
              ((let () (declare (not safe)) (##fx= _g7756_ 3))
               (apply std/srfi/13#string-ci<__1 _g7757_))
              ((let () (declare (not safe)) (##fx= _g7756_ 4))
               (apply std/srfi/13#string-ci<__2 _g7757_))
              ((let () (declare (not safe)) (##fx= _g7756_ 5))
               (apply std/srfi/13#string-ci<__3 _g7757_))
              ((let () (declare (not safe)) (##fx= _g7756_ 6))
               (apply std/srfi/13#string-ci<__% _g7757_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci<
                _g7757_))))))
  (define std/srfi/13#string-ci>__%
    (lambda (_s12183_ _s22184_ _start12185_ _end12186_ _start22187_ _end22188_)
      (if (and (eq? _s12183_ _s22184_) (= _start12185_ _start22187_))
          (> _end12186_ _end22188_)
          (std/srfi/13#%string-compare-ci
           _s12183_
           _start12185_
           _end12186_
           _s22184_
           _start22187_
           _end22188_
           (lambda (_i2190_) '#f)
           (lambda (_i2192_) '#f)
           values))))
  (define std/srfi/13#string-ci>__0
    (lambda (_s12197_ _s22198_)
      (let* ((_start12200_ '0)
             (_end12202_ (string-length _s12197_))
             (_start22204_ '0)
             (_end22206_ (string-length _s22198_)))
        (std/srfi/13#string-ci>__%
         _s12197_
         _s22198_
         _start12200_
         _end12202_
         _start22204_
         _end22206_))))
  (define std/srfi/13#string-ci>__1
    (lambda (_s12208_ _s22209_ _start12210_)
      (let* ((_end12212_ (string-length _s12208_))
             (_start22214_ '0)
             (_end22216_ (string-length _s22209_)))
        (std/srfi/13#string-ci>__%
         _s12208_
         _s22209_
         _start12210_
         _end12212_
         _start22214_
         _end22216_))))
  (define std/srfi/13#string-ci>__2
    (lambda (_s12218_ _s22219_ _start12220_ _end12221_)
      (let* ((_start22223_ '0) (_end22225_ (string-length _s22219_)))
        (std/srfi/13#string-ci>__%
         _s12218_
         _s22219_
         _start12220_
         _end12221_
         _start22223_
         _end22225_))))
  (define std/srfi/13#string-ci>__3
    (lambda (_s12227_ _s22228_ _start12229_ _end12230_ _start22231_)
      (let ((_end22233_ (string-length _s22228_)))
        (std/srfi/13#string-ci>__%
         _s12227_
         _s22228_
         _start12229_
         _end12230_
         _start22231_
         _end22233_))))
  (define std/srfi/13#string-ci>
    (lambda _g7759_
      (let ((_g7758_ (let () (declare (not safe)) (##length _g7759_))))
        (cond ((let () (declare (not safe)) (##fx= _g7758_ 2))
               (apply std/srfi/13#string-ci>__0 _g7759_))
              ((let () (declare (not safe)) (##fx= _g7758_ 3))
               (apply std/srfi/13#string-ci>__1 _g7759_))
              ((let () (declare (not safe)) (##fx= _g7758_ 4))
               (apply std/srfi/13#string-ci>__2 _g7759_))
              ((let () (declare (not safe)) (##fx= _g7758_ 5))
               (apply std/srfi/13#string-ci>__3 _g7759_))
              ((let () (declare (not safe)) (##fx= _g7758_ 6))
               (apply std/srfi/13#string-ci>__% _g7759_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci>
                _g7759_))))))
  (define std/srfi/13#string-ci<=__%
    (lambda (_s12125_ _s22126_ _start12127_ _end12128_ _start22129_ _end22130_)
      (if (and (eq? _s12125_ _s22126_) (= _start12127_ _start22129_))
          (<= _end12128_ _end22130_)
          (std/srfi/13#%string-compare-ci
           _s12125_
           _start12127_
           _end12128_
           _s22126_
           _start22129_
           _end22130_
           values
           values
           (lambda (_i2132_) '#f)))))
  (define std/srfi/13#string-ci<=__0
    (lambda (_s12137_ _s22138_)
      (let* ((_start12140_ '0)
             (_end12142_ (string-length _s12137_))
             (_start22144_ '0)
             (_end22146_ (string-length _s22138_)))
        (std/srfi/13#string-ci<=__%
         _s12137_
         _s22138_
         _start12140_
         _end12142_
         _start22144_
         _end22146_))))
  (define std/srfi/13#string-ci<=__1
    (lambda (_s12148_ _s22149_ _start12150_)
      (let* ((_end12152_ (string-length _s12148_))
             (_start22154_ '0)
             (_end22156_ (string-length _s22149_)))
        (std/srfi/13#string-ci<=__%
         _s12148_
         _s22149_
         _start12150_
         _end12152_
         _start22154_
         _end22156_))))
  (define std/srfi/13#string-ci<=__2
    (lambda (_s12158_ _s22159_ _start12160_ _end12161_)
      (let* ((_start22163_ '0) (_end22165_ (string-length _s22159_)))
        (std/srfi/13#string-ci<=__%
         _s12158_
         _s22159_
         _start12160_
         _end12161_
         _start22163_
         _end22165_))))
  (define std/srfi/13#string-ci<=__3
    (lambda (_s12167_ _s22168_ _start12169_ _end12170_ _start22171_)
      (let ((_end22173_ (string-length _s22168_)))
        (std/srfi/13#string-ci<=__%
         _s12167_
         _s22168_
         _start12169_
         _end12170_
         _start22171_
         _end22173_))))
  (define std/srfi/13#string-ci<=
    (lambda _g7761_
      (let ((_g7760_ (let () (declare (not safe)) (##length _g7761_))))
        (cond ((let () (declare (not safe)) (##fx= _g7760_ 2))
               (apply std/srfi/13#string-ci<=__0 _g7761_))
              ((let () (declare (not safe)) (##fx= _g7760_ 3))
               (apply std/srfi/13#string-ci<=__1 _g7761_))
              ((let () (declare (not safe)) (##fx= _g7760_ 4))
               (apply std/srfi/13#string-ci<=__2 _g7761_))
              ((let () (declare (not safe)) (##fx= _g7760_ 5))
               (apply std/srfi/13#string-ci<=__3 _g7761_))
              ((let () (declare (not safe)) (##fx= _g7760_ 6))
               (apply std/srfi/13#string-ci<=__% _g7761_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci<=
                _g7761_))))))
  (define std/srfi/13#string-ci>=__%
    (lambda (_s12067_ _s22068_ _start12069_ _end12070_ _start22071_ _end22072_)
      (if (and (eq? _s12067_ _s22068_) (= _start12069_ _start22071_))
          (>= _end12070_ _end22072_)
          (std/srfi/13#%string-compare-ci
           _s12067_
           _start12069_
           _end12070_
           _s22068_
           _start22071_
           _end22072_
           (lambda (_i2074_) '#f)
           values
           values))))
  (define std/srfi/13#string-ci>=__0
    (lambda (_s12079_ _s22080_)
      (let* ((_start12082_ '0)
             (_end12084_ (string-length _s12079_))
             (_start22086_ '0)
             (_end22088_ (string-length _s22080_)))
        (std/srfi/13#string-ci>=__%
         _s12079_
         _s22080_
         _start12082_
         _end12084_
         _start22086_
         _end22088_))))
  (define std/srfi/13#string-ci>=__1
    (lambda (_s12090_ _s22091_ _start12092_)
      (let* ((_end12094_ (string-length _s12090_))
             (_start22096_ '0)
             (_end22098_ (string-length _s22091_)))
        (std/srfi/13#string-ci>=__%
         _s12090_
         _s22091_
         _start12092_
         _end12094_
         _start22096_
         _end22098_))))
  (define std/srfi/13#string-ci>=__2
    (lambda (_s12100_ _s22101_ _start12102_ _end12103_)
      (let* ((_start22105_ '0) (_end22107_ (string-length _s22101_)))
        (std/srfi/13#string-ci>=__%
         _s12100_
         _s22101_
         _start12102_
         _end12103_
         _start22105_
         _end22107_))))
  (define std/srfi/13#string-ci>=__3
    (lambda (_s12109_ _s22110_ _start12111_ _end12112_ _start22113_)
      (let ((_end22115_ (string-length _s22110_)))
        (std/srfi/13#string-ci>=__%
         _s12109_
         _s22110_
         _start12111_
         _end12112_
         _start22113_
         _end22115_))))
  (define std/srfi/13#string-ci>=
    (lambda _g7763_
      (let ((_g7762_ (let () (declare (not safe)) (##length _g7763_))))
        (cond ((let () (declare (not safe)) (##fx= _g7762_ 2))
               (apply std/srfi/13#string-ci>=__0 _g7763_))
              ((let () (declare (not safe)) (##fx= _g7762_ 3))
               (apply std/srfi/13#string-ci>=__1 _g7763_))
              ((let () (declare (not safe)) (##fx= _g7762_ 4))
               (apply std/srfi/13#string-ci>=__2 _g7763_))
              ((let () (declare (not safe)) (##fx= _g7762_ 5))
               (apply std/srfi/13#string-ci>=__3 _g7763_))
              ((let () (declare (not safe)) (##fx= _g7762_ 6))
               (apply std/srfi/13#string-ci>=__% _g7763_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-ci>=
                _g7763_))))))
  (define std/srfi/13#%string-hash
    (lambda (_s2045_ _char->int2046_ _bound2047_ _start2048_ _end2049_)
      (let ((_iref2058_
             (lambda (_s2051_ _i2052_)
               (_char->int2046_ (string-ref _s2051_ _i2052_))))
            (_mask2059_
             (let _lp2054_ ((_i2056_ '65536))
               (if (>= _i2056_ _bound2047_)
                   (- _i2056_ '1)
                   (_lp2054_ (+ _i2056_ _i2056_))))))
        (let _lp2061_ ((_i2063_ _start2048_) (_ans2064_ '0))
          (if (>= _i2063_ _end2049_)
              (modulo _ans2064_ _bound2047_)
              (_lp2061_
               (+ _i2063_ '1)
               (bitwise-and
                _mask2059_
                (+ (* '37 _ans2064_) (_iref2058_ _s2045_ _i2063_)))))))))
  (define std/srfi/13#string-hash__%
    (lambda (_s2009_ _bound2010_ _start2011_ _end2012_)
      (let ((_bound2014_ (if (zero? _bound2010_) '4194304 _bound2010_)))
        (std/srfi/13#%string-hash
         _s2009_
         char->integer
         _bound2014_
         _start2011_
         _end2012_))))
  (define std/srfi/13#string-hash__0
    (lambda (_s2019_)
      (let* ((_bound2021_ '4194304)
             (_start2023_ '0)
             (_end2025_ (string-length _s2019_)))
        (std/srfi/13#string-hash__%
         _s2019_
         _bound2021_
         _start2023_
         _end2025_))))
  (define std/srfi/13#string-hash__1
    (lambda (_s2027_ _bound2028_)
      (let* ((_start2030_ '0) (_end2032_ (string-length _s2027_)))
        (std/srfi/13#string-hash__%
         _s2027_
         _bound2028_
         _start2030_
         _end2032_))))
  (define std/srfi/13#string-hash__2
    (lambda (_s2034_ _bound2035_ _start2036_)
      (let ((_end2038_ (string-length _s2034_)))
        (std/srfi/13#string-hash__%
         _s2034_
         _bound2035_
         _start2036_
         _end2038_))))
  (define std/srfi/13#string-hash
    (lambda _g7765_
      (let ((_g7764_ (let () (declare (not safe)) (##length _g7765_))))
        (cond ((let () (declare (not safe)) (##fx= _g7764_ 1))
               (apply std/srfi/13#string-hash__0 _g7765_))
              ((let () (declare (not safe)) (##fx= _g7764_ 2))
               (apply std/srfi/13#string-hash__1 _g7765_))
              ((let () (declare (not safe)) (##fx= _g7764_ 3))
               (apply std/srfi/13#string-hash__2 _g7765_))
              ((let () (declare (not safe)) (##fx= _g7764_ 4))
               (apply std/srfi/13#string-hash__% _g7765_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-hash
                _g7765_))))))
  (define std/srfi/13#string-hash-ci__%
    (lambda (_s1970_ _bound1971_ _start1972_ _end1973_)
      (let ((_bound1975_ (if (zero? _bound1971_) '4194304 _bound1971_)))
        (std/srfi/13#%string-hash
         _s1970_
         (lambda (_c1977_) (char->integer (char-downcase _c1977_)))
         _bound1975_
         _start1972_
         _end1973_))))
  (define std/srfi/13#string-hash-ci__0
    (lambda (_s1982_)
      (let* ((_bound1984_ '4194304)
             (_start1986_ '0)
             (_end1988_ (string-length _s1982_)))
        (std/srfi/13#string-hash-ci__%
         _s1982_
         _bound1984_
         _start1986_
         _end1988_))))
  (define std/srfi/13#string-hash-ci__1
    (lambda (_s1990_ _bound1991_)
      (let* ((_start1993_ '0) (_end1995_ (string-length _s1990_)))
        (std/srfi/13#string-hash-ci__%
         _s1990_
         _bound1991_
         _start1993_
         _end1995_))))
  (define std/srfi/13#string-hash-ci__2
    (lambda (_s1997_ _bound1998_ _start1999_)
      (let ((_end2001_ (string-length _s1997_)))
        (std/srfi/13#string-hash-ci__%
         _s1997_
         _bound1998_
         _start1999_
         _end2001_))))
  (define std/srfi/13#string-hash-ci
    (lambda _g7767_
      (let ((_g7766_ (let () (declare (not safe)) (##length _g7767_))))
        (cond ((let () (declare (not safe)) (##fx= _g7766_ 1))
               (apply std/srfi/13#string-hash-ci__0 _g7767_))
              ((let () (declare (not safe)) (##fx= _g7766_ 2))
               (apply std/srfi/13#string-hash-ci__1 _g7767_))
              ((let () (declare (not safe)) (##fx= _g7766_ 3))
               (apply std/srfi/13#string-hash-ci__2 _g7767_))
              ((let () (declare (not safe)) (##fx= _g7766_ 4))
               (apply std/srfi/13#string-hash-ci__% _g7767_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-hash-ci
                _g7767_))))))
  (define std/srfi/13#string-upcase__%
    (lambda (_s1947_ _start1948_ _end1949_)
      (std/srfi/13#%string-map char-upcase _s1947_ _start1948_ _end1949_)))
  (define std/srfi/13#string-upcase__0
    (lambda (_s1954_)
      (let* ((_start1956_ '0) (_end1958_ (string-length _s1954_)))
        (std/srfi/13#string-upcase__% _s1954_ _start1956_ _end1958_))))
  (define std/srfi/13#string-upcase__1
    (lambda (_s1960_ _start1961_)
      (let ((_end1963_ (string-length _s1960_)))
        (std/srfi/13#string-upcase__% _s1960_ _start1961_ _end1963_))))
  (define std/srfi/13#string-upcase
    (lambda _g7769_
      (let ((_g7768_ (let () (declare (not safe)) (##length _g7769_))))
        (cond ((let () (declare (not safe)) (##fx= _g7768_ 1))
               (apply std/srfi/13#string-upcase__0 _g7769_))
              ((let () (declare (not safe)) (##fx= _g7768_ 2))
               (apply std/srfi/13#string-upcase__1 _g7769_))
              ((let () (declare (not safe)) (##fx= _g7768_ 3))
               (apply std/srfi/13#string-upcase__% _g7769_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-upcase
                _g7769_))))))
  (define std/srfi/13#string-upcase!__%
    (lambda (_s1924_ _start1925_ _end1926_)
      (std/srfi/13#%string-map! char-upcase _s1924_ _start1925_ _end1926_)))
  (define std/srfi/13#string-upcase!__0
    (lambda (_s1931_)
      (let* ((_start1933_ '0) (_end1935_ (string-length _s1931_)))
        (std/srfi/13#string-upcase!__% _s1931_ _start1933_ _end1935_))))
  (define std/srfi/13#string-upcase!__1
    (lambda (_s1937_ _start1938_)
      (let ((_end1940_ (string-length _s1937_)))
        (std/srfi/13#string-upcase!__% _s1937_ _start1938_ _end1940_))))
  (define std/srfi/13#string-upcase!
    (lambda _g7771_
      (let ((_g7770_ (let () (declare (not safe)) (##length _g7771_))))
        (cond ((let () (declare (not safe)) (##fx= _g7770_ 1))
               (apply std/srfi/13#string-upcase!__0 _g7771_))
              ((let () (declare (not safe)) (##fx= _g7770_ 2))
               (apply std/srfi/13#string-upcase!__1 _g7771_))
              ((let () (declare (not safe)) (##fx= _g7770_ 3))
               (apply std/srfi/13#string-upcase!__% _g7771_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-upcase!
                _g7771_))))))
  (define std/srfi/13#string-downcase__%
    (lambda (_s1901_ _start1902_ _end1903_)
      (std/srfi/13#%string-map char-downcase _s1901_ _start1902_ _end1903_)))
  (define std/srfi/13#string-downcase__0
    (lambda (_s1908_)
      (let* ((_start1910_ '0) (_end1912_ (string-length _s1908_)))
        (std/srfi/13#string-downcase__% _s1908_ _start1910_ _end1912_))))
  (define std/srfi/13#string-downcase__1
    (lambda (_s1914_ _start1915_)
      (let ((_end1917_ (string-length _s1914_)))
        (std/srfi/13#string-downcase__% _s1914_ _start1915_ _end1917_))))
  (define std/srfi/13#string-downcase
    (lambda _g7773_
      (let ((_g7772_ (let () (declare (not safe)) (##length _g7773_))))
        (cond ((let () (declare (not safe)) (##fx= _g7772_ 1))
               (apply std/srfi/13#string-downcase__0 _g7773_))
              ((let () (declare (not safe)) (##fx= _g7772_ 2))
               (apply std/srfi/13#string-downcase__1 _g7773_))
              ((let () (declare (not safe)) (##fx= _g7772_ 3))
               (apply std/srfi/13#string-downcase__% _g7773_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-downcase
                _g7773_))))))
  (define std/srfi/13#string-downcase!__%
    (lambda (_s1878_ _start1879_ _end1880_)
      (std/srfi/13#%string-map! char-downcase _s1878_ _start1879_ _end1880_)))
  (define std/srfi/13#string-downcase!__0
    (lambda (_s1885_)
      (let* ((_start1887_ '0) (_end1889_ (string-length _s1885_)))
        (std/srfi/13#string-downcase!__% _s1885_ _start1887_ _end1889_))))
  (define std/srfi/13#string-downcase!__1
    (lambda (_s1891_ _start1892_)
      (let ((_end1894_ (string-length _s1891_)))
        (std/srfi/13#string-downcase!__% _s1891_ _start1892_ _end1894_))))
  (define std/srfi/13#string-downcase!
    (lambda _g7775_
      (let ((_g7774_ (let () (declare (not safe)) (##length _g7775_))))
        (cond ((let () (declare (not safe)) (##fx= _g7774_ 1))
               (apply std/srfi/13#string-downcase!__0 _g7775_))
              ((let () (declare (not safe)) (##fx= _g7774_ 2))
               (apply std/srfi/13#string-downcase!__1 _g7775_))
              ((let () (declare (not safe)) (##fx= _g7774_ 3))
               (apply std/srfi/13#string-downcase!__% _g7775_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-downcase!
                _g7775_))))))
  (define std/srfi/13#%string-titlecase!
    (lambda (_s1857_ _start1858_ _end1859_)
      (let _lp1861_ ((_i1863_ _start1858_))
        (let ((_$e1865_
               (std/srfi/13#string-index__%
                _s1857_
                std/srfi/13#char-cased?
                _i1863_
                _end1859_)))
          (if _$e1865_
              ((lambda (_i1868_)
                 (string-set!
                  _s1857_
                  _i1868_
                  (std/srfi/13#char-titlecase (string-ref _s1857_ _i1868_)))
                 (let* ((_i11870_ (+ _i1868_ '1))
                        (_$e1872_
                         (std/srfi/13#string-skip__%
                          _s1857_
                          std/srfi/13#char-cased?
                          _i11870_
                          _end1859_)))
                   (if _$e1872_
                       ((lambda (_j1875_)
                          (std/srfi/13#string-downcase!__%
                           _s1857_
                           _i11870_
                           _j1875_)
                          (_lp1861_ (+ _j1875_ '1)))
                        _$e1872_)
                       (std/srfi/13#string-downcase!__%
                        _s1857_
                        _i11870_
                        _end1859_))))
               _$e1865_)
              '#!void)))))
  (define std/srfi/13#string-titlecase!__%
    (lambda (_s1835_ _start1836_ _end1837_)
      (std/srfi/13#%string-titlecase! _s1835_ _start1836_ _end1837_)))
  (define std/srfi/13#string-titlecase!__0
    (lambda (_s1842_)
      (let* ((_start1844_ '0) (_end1846_ (string-length _s1842_)))
        (std/srfi/13#%string-titlecase! _s1842_ _start1844_ _end1846_))))
  (define std/srfi/13#string-titlecase!__1
    (lambda (_s1848_ _start1849_)
      (let ((_end1851_ (string-length _s1848_)))
        (std/srfi/13#%string-titlecase! _s1848_ _start1849_ _end1851_))))
  (define std/srfi/13#string-titlecase!
    (lambda _g7777_
      (let ((_g7776_ (let () (declare (not safe)) (##length _g7777_))))
        (cond ((let () (declare (not safe)) (##fx= _g7776_ 1))
               (apply std/srfi/13#string-titlecase!__0 _g7777_))
              ((let () (declare (not safe)) (##fx= _g7776_ 2))
               (apply std/srfi/13#string-titlecase!__1 _g7777_))
              ((let () (declare (not safe)) (##fx= _g7776_ 3))
               (apply std/srfi/13#%string-titlecase! _g7777_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-titlecase!
                _g7777_))))))
  (define std/srfi/13#string-titlecase__%
    (lambda (_s1810_ _start1811_ _end1812_)
      (let ((_ans1814_ (substring _s1810_ _start1811_ _end1812_)))
        (std/srfi/13#%string-titlecase! _ans1814_ '0 (- _end1812_ _start1811_))
        _ans1814_)))
  (define std/srfi/13#string-titlecase__0
    (lambda (_s1819_)
      (let* ((_start1821_ '0) (_end1823_ (string-length _s1819_)))
        (std/srfi/13#string-titlecase__% _s1819_ _start1821_ _end1823_))))
  (define std/srfi/13#string-titlecase__1
    (lambda (_s1825_ _start1826_)
      (let ((_end1828_ (string-length _s1825_)))
        (std/srfi/13#string-titlecase__% _s1825_ _start1826_ _end1828_))))
  (define std/srfi/13#string-titlecase
    (lambda _g7779_
      (let ((_g7778_ (let () (declare (not safe)) (##length _g7779_))))
        (cond ((let () (declare (not safe)) (##fx= _g7778_ 1))
               (apply std/srfi/13#string-titlecase__0 _g7779_))
              ((let () (declare (not safe)) (##fx= _g7778_ 2))
               (apply std/srfi/13#string-titlecase__1 _g7779_))
              ((let () (declare (not safe)) (##fx= _g7778_ 3))
               (apply std/srfi/13#string-titlecase__% _g7779_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-titlecase
                _g7779_))))))
  (define std/srfi/13#string-take
    (lambda (_s1806_ _n1807_)
      (std/srfi/13#%substring/shared _s1806_ '0 _n1807_)))
  (define std/srfi/13#string-take-right
    (lambda (_s1801_ _n1802_)
      (let ((_len1804_ (string-length _s1801_)))
        (std/srfi/13#%substring/shared
         _s1801_
         (- _len1804_ _n1802_)
         _len1804_))))
  (define std/srfi/13#string-drop
    (lambda (_s1796_ _n1797_)
      (let ((_len1799_ (string-length _s1796_)))
        (std/srfi/13#%substring/shared _s1796_ _n1797_ _len1799_))))
  (define std/srfi/13#string-drop-right
    (lambda (_s1791_ _n1792_)
      (let ((_len1794_ (string-length _s1791_)))
        (std/srfi/13#%substring/shared _s1791_ '0 (- _len1794_ _n1792_)))))
  (define std/srfi/13#string-trim__%
    (lambda (_s1752_ _criterion1753_ _start1754_ _end1755_)
      (let ((_$e1757_
             (std/srfi/13#string-skip__%
              _s1752_
              _criterion1753_
              _start1754_
              _end1755_)))
        (if _$e1757_
            ((lambda (_i1760_)
               (std/srfi/13#%substring/shared _s1752_ _i1760_ _end1755_))
             _$e1757_)
            '""))))
  (define std/srfi/13#string-trim__0
    (lambda (_s1765_)
      (let* ((_criterion1767_ std/srfi/14#char-set:whitespace)
             (_start1769_ '0)
             (_end1771_ (string-length _s1765_)))
        (std/srfi/13#string-trim__%
         _s1765_
         _criterion1767_
         _start1769_
         _end1771_))))
  (define std/srfi/13#string-trim__1
    (lambda (_s1773_ _criterion1774_)
      (let* ((_start1776_ '0) (_end1778_ (string-length _s1773_)))
        (std/srfi/13#string-trim__%
         _s1773_
         _criterion1774_
         _start1776_
         _end1778_))))
  (define std/srfi/13#string-trim__2
    (lambda (_s1780_ _criterion1781_ _start1782_)
      (let ((_end1784_ (string-length _s1780_)))
        (std/srfi/13#string-trim__%
         _s1780_
         _criterion1781_
         _start1782_
         _end1784_))))
  (define std/srfi/13#string-trim
    (lambda _g7781_
      (let ((_g7780_ (let () (declare (not safe)) (##length _g7781_))))
        (cond ((let () (declare (not safe)) (##fx= _g7780_ 1))
               (apply std/srfi/13#string-trim__0 _g7781_))
              ((let () (declare (not safe)) (##fx= _g7780_ 2))
               (apply std/srfi/13#string-trim__1 _g7781_))
              ((let () (declare (not safe)) (##fx= _g7780_ 3))
               (apply std/srfi/13#string-trim__2 _g7781_))
              ((let () (declare (not safe)) (##fx= _g7780_ 4))
               (apply std/srfi/13#string-trim__% _g7781_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-trim
                _g7781_))))))
  (define std/srfi/13#string-trim-right__%
    (lambda (_s1712_ _criterion1713_ _start1714_ _end1715_)
      (let ((_$e1717_
             (std/srfi/13#string-skip-right__%
              _s1712_
              _criterion1713_
              _start1714_
              _end1715_)))
        (if _$e1717_
            ((lambda (_i1720_)
               (std/srfi/13#%substring/shared
                _s1712_
                _start1714_
                (+ '1 _i1720_)))
             _$e1717_)
            '""))))
  (define std/srfi/13#string-trim-right__0
    (lambda (_s1725_)
      (let* ((_criterion1727_ std/srfi/14#char-set:whitespace)
             (_start1729_ '0)
             (_end1731_ (string-length _s1725_)))
        (std/srfi/13#string-trim-right__%
         _s1725_
         _criterion1727_
         _start1729_
         _end1731_))))
  (define std/srfi/13#string-trim-right__1
    (lambda (_s1733_ _criterion1734_)
      (let* ((_start1736_ '0) (_end1738_ (string-length _s1733_)))
        (std/srfi/13#string-trim-right__%
         _s1733_
         _criterion1734_
         _start1736_
         _end1738_))))
  (define std/srfi/13#string-trim-right__2
    (lambda (_s1740_ _criterion1741_ _start1742_)
      (let ((_end1744_ (string-length _s1740_)))
        (std/srfi/13#string-trim-right__%
         _s1740_
         _criterion1741_
         _start1742_
         _end1744_))))
  (define std/srfi/13#string-trim-right
    (lambda _g7783_
      (let ((_g7782_ (let () (declare (not safe)) (##length _g7783_))))
        (cond ((let () (declare (not safe)) (##fx= _g7782_ 1))
               (apply std/srfi/13#string-trim-right__0 _g7783_))
              ((let () (declare (not safe)) (##fx= _g7782_ 2))
               (apply std/srfi/13#string-trim-right__1 _g7783_))
              ((let () (declare (not safe)) (##fx= _g7782_ 3))
               (apply std/srfi/13#string-trim-right__2 _g7783_))
              ((let () (declare (not safe)) (##fx= _g7782_ 4))
               (apply std/srfi/13#string-trim-right__% _g7783_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-trim-right
                _g7783_))))))
  (define std/srfi/13#string-trim-both__%
    (lambda (_s1672_ _criterion1673_ _start1674_ _end1675_)
      (let ((_$e1677_
             (std/srfi/13#string-skip__%
              _s1672_
              _criterion1673_
              _start1674_
              _end1675_)))
        (if _$e1677_
            ((lambda (_i1680_)
               (std/srfi/13#%substring/shared
                _s1672_
                _i1680_
                (+ '1
                   (std/srfi/13#string-skip-right__%
                    _s1672_
                    _criterion1673_
                    _i1680_
                    _end1675_))))
             _$e1677_)
            '""))))
  (define std/srfi/13#string-trim-both__0
    (lambda (_s1685_)
      (let* ((_criterion1687_ std/srfi/14#char-set:whitespace)
             (_start1689_ '0)
             (_end1691_ (string-length _s1685_)))
        (std/srfi/13#string-trim-both__%
         _s1685_
         _criterion1687_
         _start1689_
         _end1691_))))
  (define std/srfi/13#string-trim-both__1
    (lambda (_s1693_ _criterion1694_)
      (let* ((_start1696_ '0) (_end1698_ (string-length _s1693_)))
        (std/srfi/13#string-trim-both__%
         _s1693_
         _criterion1694_
         _start1696_
         _end1698_))))
  (define std/srfi/13#string-trim-both__2
    (lambda (_s1700_ _criterion1701_ _start1702_)
      (let ((_end1704_ (string-length _s1700_)))
        (std/srfi/13#string-trim-both__%
         _s1700_
         _criterion1701_
         _start1702_
         _end1704_))))
  (define std/srfi/13#string-trim-both
    (lambda _g7785_
      (let ((_g7784_ (let () (declare (not safe)) (##length _g7785_))))
        (cond ((let () (declare (not safe)) (##fx= _g7784_ 1))
               (apply std/srfi/13#string-trim-both__0 _g7785_))
              ((let () (declare (not safe)) (##fx= _g7784_ 2))
               (apply std/srfi/13#string-trim-both__1 _g7785_))
              ((let () (declare (not safe)) (##fx= _g7784_ 3))
               (apply std/srfi/13#string-trim-both__2 _g7785_))
              ((let () (declare (not safe)) (##fx= _g7784_ 4))
               (apply std/srfi/13#string-trim-both__% _g7785_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-trim-both
                _g7785_))))))
  (define std/srfi/13#string-pad-right__%
    (lambda (_s1628_ _n1629_ _char1630_ _start1631_ _end1632_)
      (let ((_len1634_ (- _end1632_ _start1631_)))
        (if (<= _n1629_ _len1634_)
            (std/srfi/13#%substring/shared
             _s1628_
             _start1631_
             (+ _start1631_ _n1629_))
            (let ((_ans1636_ (make-string _n1629_ _char1630_)))
              (std/srfi/13#%string-copy!
               _ans1636_
               '0
               _s1628_
               _start1631_
               _end1632_)
              _ans1636_)))))
  (define std/srfi/13#string-pad-right__0
    (lambda (_s1641_ _n1642_)
      (let* ((_char1644_ '#\space)
             (_start1646_ '0)
             (_end1648_ (string-length _s1641_)))
        (std/srfi/13#string-pad-right__%
         _s1641_
         _n1642_
         _char1644_
         _start1646_
         _end1648_))))
  (define std/srfi/13#string-pad-right__1
    (lambda (_s1650_ _n1651_ _char1652_)
      (let* ((_start1654_ '0) (_end1656_ (string-length _s1650_)))
        (std/srfi/13#string-pad-right__%
         _s1650_
         _n1651_
         _char1652_
         _start1654_
         _end1656_))))
  (define std/srfi/13#string-pad-right__2
    (lambda (_s1658_ _n1659_ _char1660_ _start1661_)
      (let ((_end1663_ (string-length _s1658_)))
        (std/srfi/13#string-pad-right__%
         _s1658_
         _n1659_
         _char1660_
         _start1661_
         _end1663_))))
  (define std/srfi/13#string-pad-right
    (lambda _g7787_
      (let ((_g7786_ (let () (declare (not safe)) (##length _g7787_))))
        (cond ((let () (declare (not safe)) (##fx= _g7786_ 2))
               (apply std/srfi/13#string-pad-right__0 _g7787_))
              ((let () (declare (not safe)) (##fx= _g7786_ 3))
               (apply std/srfi/13#string-pad-right__1 _g7787_))
              ((let () (declare (not safe)) (##fx= _g7786_ 4))
               (apply std/srfi/13#string-pad-right__2 _g7787_))
              ((let () (declare (not safe)) (##fx= _g7786_ 5))
               (apply std/srfi/13#string-pad-right__% _g7787_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-pad-right
                _g7787_))))))
  (define std/srfi/13#string-pad__%
    (lambda (_s1584_ _n1585_ _char1586_ _start1587_ _end1588_)
      (let ((_len1590_ (- _end1588_ _start1587_)))
        (if (<= _n1585_ _len1590_)
            (std/srfi/13#%substring/shared
             _s1584_
             (- _end1588_ _n1585_)
             _end1588_)
            (let ((_ans1592_ (make-string _n1585_ _char1586_)))
              (std/srfi/13#%string-copy!
               _ans1592_
               (- _n1585_ _len1590_)
               _s1584_
               _start1587_
               _end1588_)
              _ans1592_)))))
  (define std/srfi/13#string-pad__0
    (lambda (_s1597_ _n1598_)
      (let* ((_char1600_ '#\space)
             (_start1602_ '0)
             (_end1604_ (string-length _s1597_)))
        (std/srfi/13#string-pad__%
         _s1597_
         _n1598_
         _char1600_
         _start1602_
         _end1604_))))
  (define std/srfi/13#string-pad__1
    (lambda (_s1606_ _n1607_ _char1608_)
      (let* ((_start1610_ '0) (_end1612_ (string-length _s1606_)))
        (std/srfi/13#string-pad__%
         _s1606_
         _n1607_
         _char1608_
         _start1610_
         _end1612_))))
  (define std/srfi/13#string-pad__2
    (lambda (_s1614_ _n1615_ _char1616_ _start1617_)
      (let ((_end1619_ (string-length _s1614_)))
        (std/srfi/13#string-pad__%
         _s1614_
         _n1615_
         _char1616_
         _start1617_
         _end1619_))))
  (define std/srfi/13#string-pad
    (lambda _g7789_
      (let ((_g7788_ (let () (declare (not safe)) (##length _g7789_))))
        (cond ((let () (declare (not safe)) (##fx= _g7788_ 2))
               (apply std/srfi/13#string-pad__0 _g7789_))
              ((let () (declare (not safe)) (##fx= _g7788_ 3))
               (apply std/srfi/13#string-pad__1 _g7789_))
              ((let () (declare (not safe)) (##fx= _g7788_ 4))
               (apply std/srfi/13#string-pad__2 _g7789_))
              ((let () (declare (not safe)) (##fx= _g7788_ 5))
               (apply std/srfi/13#string-pad__% _g7789_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-pad
                _g7789_))))))
  (define std/srfi/13#string-delete__%
    (lambda (_criterion1534_ _s1535_ _start1536_ _end1537_)
      (if (procedure? _criterion1534_)
          (let* ((_slen1539_ (- _end1537_ _start1536_))
                 (_temp1541_ (make-string _slen1539_))
                 (_ans-len1546_
                  (std/srfi/13#string-fold__%
                   (lambda (_c1543_ _i1544_)
                     (if (_criterion1534_ _c1543_)
                         _i1544_
                         (begin
                           (string-set! _temp1541_ _i1544_ _c1543_)
                           (+ _i1544_ '1))))
                   '0
                   _s1535_
                   _start1536_
                   _end1537_)))
            (if (= _ans-len1546_ _slen1539_)
                _temp1541_
                (substring _temp1541_ '0 _ans-len1546_)))
          (let* ((_cset1549_
                  (if (let ()
                        (declare (not safe))
                        (##structure-instance-of?
                         _criterion1534_
                         'std/srfi/14#:char-set))
                      _criterion1534_
                      (if (char? _criterion1534_)
                          (std/srfi/14#char-set _criterion1534_)
                          (error '"string-delete criterion not predicate, char or char-set"
                                 _criterion1534_))))
                 (_len1554_
                  (std/srfi/13#string-fold__%
                   (lambda (_c1551_ _i1552_)
                     (if (std/srfi/14#char-set-contains? _cset1549_ _c1551_)
                         _i1552_
                         (+ _i1552_ '1)))
                   '0
                   _s1535_
                   _start1536_
                   _end1537_))
                 (_ans1556_ (make-string _len1554_)))
            (std/srfi/13#string-fold__%
             (lambda (_c1559_ _i1560_)
               (if (std/srfi/14#char-set-contains? _cset1549_ _c1559_)
                   _i1560_
                   (begin
                     (string-set! _ans1556_ _i1560_ _c1559_)
                     (+ _i1560_ '1))))
             '0
             _s1535_
             _start1536_
             _end1537_)
            _ans1556_))))
  (define std/srfi/13#string-delete__0
    (lambda (_criterion1565_ _s1566_)
      (let* ((_start1568_ '0) (_end1570_ (string-length _s1566_)))
        (std/srfi/13#string-delete__%
         _criterion1565_
         _s1566_
         _start1568_
         _end1570_))))
  (define std/srfi/13#string-delete__1
    (lambda (_criterion1572_ _s1573_ _start1574_)
      (let ((_end1576_ (string-length _s1573_)))
        (std/srfi/13#string-delete__%
         _criterion1572_
         _s1573_
         _start1574_
         _end1576_))))
  (define std/srfi/13#string-delete
    (lambda _g7791_
      (let ((_g7790_ (let () (declare (not safe)) (##length _g7791_))))
        (cond ((let () (declare (not safe)) (##fx= _g7790_ 2))
               (apply std/srfi/13#string-delete__0 _g7791_))
              ((let () (declare (not safe)) (##fx= _g7790_ 3))
               (apply std/srfi/13#string-delete__1 _g7791_))
              ((let () (declare (not safe)) (##fx= _g7790_ 4))
               (apply std/srfi/13#string-delete__% _g7791_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-delete
                _g7791_))))))
  (define std/srfi/13#string-filter__%
    (lambda (_criterion1484_ _s1485_ _start1486_ _end1487_)
      (if (procedure? _criterion1484_)
          (let* ((_slen1489_ (- _end1487_ _start1486_))
                 (_temp1491_ (make-string _slen1489_))
                 (_ans-len1496_
                  (std/srfi/13#string-fold__%
                   (lambda (_c1493_ _i1494_)
                     (if (_criterion1484_ _c1493_)
                         (begin
                           (string-set! _temp1491_ _i1494_ _c1493_)
                           (+ _i1494_ '1))
                         _i1494_))
                   '0
                   _s1485_
                   _start1486_
                   _end1487_)))
            (if (= _ans-len1496_ _slen1489_)
                _temp1491_
                (substring _temp1491_ '0 _ans-len1496_)))
          (let* ((_cset1499_
                  (if (let ()
                        (declare (not safe))
                        (##structure-instance-of?
                         _criterion1484_
                         'std/srfi/14#:char-set))
                      _criterion1484_
                      (if (char? _criterion1484_)
                          (std/srfi/14#char-set _criterion1484_)
                          (error '"string-delete criterion not predicate, char or char-set"
                                 _criterion1484_))))
                 (_len1504_
                  (std/srfi/13#string-fold__%
                   (lambda (_c1501_ _i1502_)
                     (if (std/srfi/14#char-set-contains? _cset1499_ _c1501_)
                         (+ _i1502_ '1)
                         _i1502_))
                   '0
                   _s1485_
                   _start1486_
                   _end1487_))
                 (_ans1506_ (make-string _len1504_)))
            (std/srfi/13#string-fold__%
             (lambda (_c1509_ _i1510_)
               (if (std/srfi/14#char-set-contains? _cset1499_ _c1509_)
                   (begin
                     (string-set! _ans1506_ _i1510_ _c1509_)
                     (+ _i1510_ '1))
                   _i1510_))
             '0
             _s1485_
             _start1486_
             _end1487_)
            _ans1506_))))
  (define std/srfi/13#string-filter__0
    (lambda (_criterion1515_ _s1516_)
      (let* ((_start1518_ '0) (_end1520_ (string-length _s1516_)))
        (std/srfi/13#string-filter__%
         _criterion1515_
         _s1516_
         _start1518_
         _end1520_))))
  (define std/srfi/13#string-filter__1
    (lambda (_criterion1522_ _s1523_ _start1524_)
      (let ((_end1526_ (string-length _s1523_)))
        (std/srfi/13#string-filter__%
         _criterion1522_
         _s1523_
         _start1524_
         _end1526_))))
  (define std/srfi/13#string-filter
    (lambda _g7793_
      (let ((_g7792_ (let () (declare (not safe)) (##length _g7793_))))
        (cond ((let () (declare (not safe)) (##fx= _g7792_ 2))
               (apply std/srfi/13#string-filter__0 _g7793_))
              ((let () (declare (not safe)) (##fx= _g7792_ 3))
               (apply std/srfi/13#string-filter__1 _g7793_))
              ((let () (declare (not safe)) (##fx= _g7792_ 4))
               (apply std/srfi/13#string-filter__% _g7793_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-filter
                _g7793_))))))
  (define std/srfi/13#string-index__%
    (lambda (_str1445_ _criterion1446_ _start1447_ _end1448_)
      (if (char? _criterion1446_)
          (let _lp1450_ ((_i1452_ _start1447_))
            (if (< _i1452_ _end1448_)
                (if (char=? _criterion1446_ (string-ref _str1445_ _i1452_))
                    _i1452_
                    (_lp1450_ (+ _i1452_ '1)))
                '#f))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion1446_
                 'std/srfi/14#:char-set))
              (let _lp1454_ ((_i1456_ _start1447_))
                (if (< _i1456_ _end1448_)
                    (if (std/srfi/14#char-set-contains?
                         _criterion1446_
                         (string-ref _str1445_ _i1456_))
                        _i1456_
                        (_lp1454_ (+ _i1456_ '1)))
                    '#f))
              (if (procedure? _criterion1446_)
                  (let _lp1458_ ((_i1460_ _start1447_))
                    (if (< _i1460_ _end1448_)
                        (if (_criterion1446_ (string-ref _str1445_ _i1460_))
                            _i1460_
                            (_lp1458_ (+ _i1460_ '1)))
                        '#f))
                  (error '"Second param is neither char-set, char, or predicate procedure."
                         std/srfi/13#string-index
                         _criterion1446_))))))
  (define std/srfi/13#string-index__0
    (lambda (_str1465_ _criterion1466_)
      (let* ((_start1468_ '0) (_end1470_ (string-length _str1465_)))
        (std/srfi/13#string-index__%
         _str1465_
         _criterion1466_
         _start1468_
         _end1470_))))
  (define std/srfi/13#string-index__1
    (lambda (_str1472_ _criterion1473_ _start1474_)
      (let ((_end1476_ (string-length _str1472_)))
        (std/srfi/13#string-index__%
         _str1472_
         _criterion1473_
         _start1474_
         _end1476_))))
  (define std/srfi/13#string-index
    (lambda _g7795_
      (let ((_g7794_ (let () (declare (not safe)) (##length _g7795_))))
        (cond ((let () (declare (not safe)) (##fx= _g7794_ 2))
               (apply std/srfi/13#string-index__0 _g7795_))
              ((let () (declare (not safe)) (##fx= _g7794_ 3))
               (apply std/srfi/13#string-index__1 _g7795_))
              ((let () (declare (not safe)) (##fx= _g7794_ 4))
               (apply std/srfi/13#string-index__% _g7795_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-index
                _g7795_))))))
  (define std/srfi/13#string-index-right__%
    (lambda (_str1406_ _criterion1407_ _start1408_ _end1409_)
      (if (char? _criterion1407_)
          (let _lp1411_ ((_i1413_ (- _end1409_ '1)))
            (if (>= _i1413_ _start1408_)
                (if (char=? _criterion1407_ (string-ref _str1406_ _i1413_))
                    _i1413_
                    (_lp1411_ (- _i1413_ '1)))
                '#f))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion1407_
                 'std/srfi/14#:char-set))
              (let _lp1415_ ((_i1417_ (- _end1409_ '1)))
                (if (>= _i1417_ _start1408_)
                    (if (std/srfi/14#char-set-contains?
                         _criterion1407_
                         (string-ref _str1406_ _i1417_))
                        _i1417_
                        (_lp1415_ (- _i1417_ '1)))
                    '#f))
              (if (procedure? _criterion1407_)
                  (let _lp1419_ ((_i1421_ (- _end1409_ '1)))
                    (if (>= _i1421_ _start1408_)
                        (if (_criterion1407_ (string-ref _str1406_ _i1421_))
                            _i1421_
                            (_lp1419_ (- _i1421_ '1)))
                        '#f))
                  (error '"Second param is neither char-set, char, or predicate procedure."
                         std/srfi/13#string-index-right
                         _criterion1407_))))))
  (define std/srfi/13#string-index-right__0
    (lambda (_str1426_ _criterion1427_)
      (let* ((_start1429_ '0) (_end1431_ (string-length _str1426_)))
        (std/srfi/13#string-index-right__%
         _str1426_
         _criterion1427_
         _start1429_
         _end1431_))))
  (define std/srfi/13#string-index-right__1
    (lambda (_str1433_ _criterion1434_ _start1435_)
      (let ((_end1437_ (string-length _str1433_)))
        (std/srfi/13#string-index-right__%
         _str1433_
         _criterion1434_
         _start1435_
         _end1437_))))
  (define std/srfi/13#string-index-right
    (lambda _g7797_
      (let ((_g7796_ (let () (declare (not safe)) (##length _g7797_))))
        (cond ((let () (declare (not safe)) (##fx= _g7796_ 2))
               (apply std/srfi/13#string-index-right__0 _g7797_))
              ((let () (declare (not safe)) (##fx= _g7796_ 3))
               (apply std/srfi/13#string-index-right__1 _g7797_))
              ((let () (declare (not safe)) (##fx= _g7796_ 4))
               (apply std/srfi/13#string-index-right__% _g7797_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-index-right
                _g7797_))))))
  (define std/srfi/13#string-skip__%
    (lambda (_str1367_ _criterion1368_ _start1369_ _end1370_)
      (if (char? _criterion1368_)
          (let _lp1372_ ((_i1374_ _start1369_))
            (if (< _i1374_ _end1370_)
                (if (char=? _criterion1368_ (string-ref _str1367_ _i1374_))
                    (_lp1372_ (+ _i1374_ '1))
                    _i1374_)
                '#f))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion1368_
                 'std/srfi/14#:char-set))
              (let _lp1376_ ((_i1378_ _start1369_))
                (if (< _i1378_ _end1370_)
                    (if (std/srfi/14#char-set-contains?
                         _criterion1368_
                         (string-ref _str1367_ _i1378_))
                        (_lp1376_ (+ _i1378_ '1))
                        _i1378_)
                    '#f))
              (if (procedure? _criterion1368_)
                  (let _lp1380_ ((_i1382_ _start1369_))
                    (if (< _i1382_ _end1370_)
                        (if (_criterion1368_ (string-ref _str1367_ _i1382_))
                            (_lp1380_ (+ _i1382_ '1))
                            _i1382_)
                        '#f))
                  (error '"Second param is neither char-set, char, or predicate procedure."
                         std/srfi/13#string-skip
                         _criterion1368_))))))
  (define std/srfi/13#string-skip__0
    (lambda (_str1387_ _criterion1388_)
      (let* ((_start1390_ '0) (_end1392_ (string-length _str1387_)))
        (std/srfi/13#string-skip__%
         _str1387_
         _criterion1388_
         _start1390_
         _end1392_))))
  (define std/srfi/13#string-skip__1
    (lambda (_str1394_ _criterion1395_ _start1396_)
      (let ((_end1398_ (string-length _str1394_)))
        (std/srfi/13#string-skip__%
         _str1394_
         _criterion1395_
         _start1396_
         _end1398_))))
  (define std/srfi/13#string-skip
    (lambda _g7799_
      (let ((_g7798_ (let () (declare (not safe)) (##length _g7799_))))
        (cond ((let () (declare (not safe)) (##fx= _g7798_ 2))
               (apply std/srfi/13#string-skip__0 _g7799_))
              ((let () (declare (not safe)) (##fx= _g7798_ 3))
               (apply std/srfi/13#string-skip__1 _g7799_))
              ((let () (declare (not safe)) (##fx= _g7798_ 4))
               (apply std/srfi/13#string-skip__% _g7799_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-skip
                _g7799_))))))
  (define std/srfi/13#string-skip-right__%
    (lambda (_str1328_ _criterion1329_ _start1330_ _end1331_)
      (if (char? _criterion1329_)
          (let _lp1333_ ((_i1335_ (- _end1331_ '1)))
            (if (>= _i1335_ _start1330_)
                (if (char=? _criterion1329_ (string-ref _str1328_ _i1335_))
                    (_lp1333_ (- _i1335_ '1))
                    _i1335_)
                '#f))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion1329_
                 'std/srfi/14#:char-set))
              (let _lp1337_ ((_i1339_ (- _end1331_ '1)))
                (if (>= _i1339_ _start1330_)
                    (if (std/srfi/14#char-set-contains?
                         _criterion1329_
                         (string-ref _str1328_ _i1339_))
                        (_lp1337_ (- _i1339_ '1))
                        _i1339_)
                    '#f))
              (if (procedure? _criterion1329_)
                  (let _lp1341_ ((_i1343_ (- _end1331_ '1)))
                    (if (>= _i1343_ _start1330_)
                        (if (_criterion1329_ (string-ref _str1328_ _i1343_))
                            (_lp1341_ (- _i1343_ '1))
                            _i1343_)
                        '#f))
                  (error '"CRITERION param is neither char-set or char."
                         std/srfi/13#string-skip-right
                         _criterion1329_))))))
  (define std/srfi/13#string-skip-right__0
    (lambda (_str1348_ _criterion1349_)
      (let* ((_start1351_ '0) (_end1353_ (string-length _str1348_)))
        (std/srfi/13#string-skip-right__%
         _str1348_
         _criterion1349_
         _start1351_
         _end1353_))))
  (define std/srfi/13#string-skip-right__1
    (lambda (_str1355_ _criterion1356_ _start1357_)
      (let ((_end1359_ (string-length _str1355_)))
        (std/srfi/13#string-skip-right__%
         _str1355_
         _criterion1356_
         _start1357_
         _end1359_))))
  (define std/srfi/13#string-skip-right
    (lambda _g7801_
      (let ((_g7800_ (let () (declare (not safe)) (##length _g7801_))))
        (cond ((let () (declare (not safe)) (##fx= _g7800_ 2))
               (apply std/srfi/13#string-skip-right__0 _g7801_))
              ((let () (declare (not safe)) (##fx= _g7800_ 3))
               (apply std/srfi/13#string-skip-right__1 _g7801_))
              ((let () (declare (not safe)) (##fx= _g7800_ 4))
               (apply std/srfi/13#string-skip-right__% _g7801_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-skip-right
                _g7801_))))))
  (define std/srfi/13#string-count__%
    (lambda (_s1283_ _criterion1284_ _start1285_ _end1286_)
      (if (char? _criterion1284_)
          (let _$loop1288_ ((_i1291_ _start1285_) (_count1292_ '0))
            (if (>= _i1291_ _end1286_)
                _count1292_
                (_$loop1288_
                 (+ _i1291_ '1)
                 (if (char=? _criterion1284_ (string-ref _s1283_ _i1291_))
                     (+ _count1292_ '1)
                     _count1292_))))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of?
                 _criterion1284_
                 'std/srfi/14#:char-set))
              (let _$loop1294_ ((_i1297_ _start1285_) (_count1298_ '0))
                (if (>= _i1297_ _end1286_)
                    _count1298_
                    (_$loop1294_
                     (+ _i1297_ '1)
                     (if (std/srfi/14#char-set-contains?
                          _criterion1284_
                          (string-ref _s1283_ _i1297_))
                         (+ _count1298_ '1)
                         _count1298_))))
              (if (procedure? _criterion1284_)
                  (let _$loop1300_ ((_i1303_ _start1285_) (_count1304_ '0))
                    (if (>= _i1303_ _end1286_)
                        _count1304_
                        (_$loop1300_
                         (+ _i1303_ '1)
                         (if (_criterion1284_ (string-ref _s1283_ _i1303_))
                             (+ _count1304_ '1)
                             _count1304_))))
                  (error '"CRITERION param is neither char-set or char."
                         std/srfi/13#string-count
                         _criterion1284_))))))
  (define std/srfi/13#string-count__0
    (lambda (_s1309_ _criterion1310_)
      (let* ((_start1312_ '0) (_end1314_ (string-length _s1309_)))
        (std/srfi/13#string-count__%
         _s1309_
         _criterion1310_
         _start1312_
         _end1314_))))
  (define std/srfi/13#string-count__1
    (lambda (_s1316_ _criterion1317_ _start1318_)
      (let ((_end1320_ (string-length _s1316_)))
        (std/srfi/13#string-count__%
         _s1316_
         _criterion1317_
         _start1318_
         _end1320_))))
  (define std/srfi/13#string-count
    (lambda _g7803_
      (let ((_g7802_ (let () (declare (not safe)) (##length _g7803_))))
        (cond ((let () (declare (not safe)) (##fx= _g7802_ 2))
               (apply std/srfi/13#string-count__0 _g7803_))
              ((let () (declare (not safe)) (##fx= _g7802_ 3))
               (apply std/srfi/13#string-count__1 _g7803_))
              ((let () (declare (not safe)) (##fx= _g7802_ 4))
               (apply std/srfi/13#string-count__% _g7803_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-count
                _g7803_))))))
  (define std/srfi/13#string-fill!__%
    (lambda (_s1251_ _char1252_ _start1253_ _end1254_)
      (let _$loop1256_ ((_i1259_ (- _end1254_ '1)))
        (if (< _i1259_ _start1253_)
            '#!void
            (begin
              (string-set! _s1251_ _i1259_ _char1252_)
              (_$loop1256_ (- _i1259_ '1)))))))
  (define std/srfi/13#string-fill!__0
    (lambda (_s1264_ _char1265_)
      (let* ((_start1267_ '0) (_end1269_ (string-length _s1264_)))
        (std/srfi/13#string-fill!__%
         _s1264_
         _char1265_
         _start1267_
         _end1269_))))
  (define std/srfi/13#string-fill!__1
    (lambda (_s1271_ _char1272_ _start1273_)
      (let ((_end1275_ (string-length _s1271_)))
        (std/srfi/13#string-fill!__%
         _s1271_
         _char1272_
         _start1273_
         _end1275_))))
  (define std/srfi/13#string-fill!
    (lambda _g7805_
      (let ((_g7804_ (let () (declare (not safe)) (##length _g7805_))))
        (cond ((let () (declare (not safe)) (##fx= _g7804_ 2))
               (apply std/srfi/13#string-fill!__0 _g7805_))
              ((let () (declare (not safe)) (##fx= _g7804_ 3))
               (apply std/srfi/13#string-fill!__1 _g7805_))
              ((let () (declare (not safe)) (##fx= _g7804_ 4))
               (apply std/srfi/13#string-fill!__% _g7805_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-fill!
                _g7805_))))))
  (define std/srfi/13#string-copy!__%
    (lambda (_to1220_ _tstart1221_ _from1222_ _fstart1223_ _fend1224_)
      (std/srfi/13#%string-copy!
       _to1220_
       _tstart1221_
       _from1222_
       _fstart1223_
       _fend1224_)))
  (define std/srfi/13#string-copy!__0
    (lambda (_to1229_ _tstart1230_ _from1231_)
      (let* ((_fstart1233_ '0) (_fend1235_ (string-length _from1231_)))
        (std/srfi/13#%string-copy!
         _to1229_
         _tstart1230_
         _from1231_
         _fstart1233_
         _fend1235_))))
  (define std/srfi/13#string-copy!__1
    (lambda (_to1237_ _tstart1238_ _from1239_ _fstart1240_)
      (let ((_fend1242_ (string-length _from1239_)))
        (std/srfi/13#%string-copy!
         _to1237_
         _tstart1238_
         _from1239_
         _fstart1240_
         _fend1242_))))
  (define std/srfi/13#string-copy!
    (lambda _g7807_
      (let ((_g7806_ (let () (declare (not safe)) (##length _g7807_))))
        (cond ((let () (declare (not safe)) (##fx= _g7806_ 3))
               (apply std/srfi/13#string-copy!__0 _g7807_))
              ((let () (declare (not safe)) (##fx= _g7806_ 4))
               (apply std/srfi/13#string-copy!__1 _g7807_))
              ((let () (declare (not safe)) (##fx= _g7806_ 5))
               (apply std/srfi/13#%string-copy! _g7807_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-copy!
                _g7807_))))))
  (define std/srfi/13#%string-copy!
    (lambda (_to1201_ _tstart1202_ _from1203_ _fstart1204_ _fend1205_)
      (if (> _fstart1204_ _tstart1202_)
          (let _$loop1207_ ((_i1210_ _fstart1204_) (_j1211_ _tstart1202_))
            (if (>= _i1210_ _fend1205_)
                '#!void
                (begin
                  (string-set!
                   _to1201_
                   _j1211_
                   (string-ref _from1203_ _i1210_))
                  (_$loop1207_ (+ _i1210_ '1) (+ _j1211_ '1)))))
          (let _$loop1213_ ((_i1216_ (- _fend1205_ '1))
                            (_j1217_ (+ '-1
                                        _tstart1202_
                                        (- _fend1205_ _fstart1204_))))
            (if (< _i1216_ _fstart1204_)
                '#!void
                (begin
                  (string-set!
                   _to1201_
                   _j1217_
                   (string-ref _from1203_ _i1216_))
                  (_$loop1213_ (- _i1216_ '1) (- _j1217_ '1))))))))
  (define std/srfi/13#string-contains__%
    (lambda (_text1146_
             _pattern1147_
             _t-start1148_
             _t-end1149_
             _p-start1150_
             _p-end1151_)
      (std/srfi/13#%kmp-search
       _pattern1147_
       _text1146_
       char=?
       _p-start1150_
       _p-end1151_
       _t-start1148_
       _t-end1149_)))
  (define std/srfi/13#string-contains__0
    (lambda (_text1156_ _pattern1157_)
      (let* ((_t-start1159_ '0)
             (_t-end1161_ (string-length _text1156_))
             (_p-start1163_ '0)
             (_p-end1165_ (string-length _pattern1157_)))
        (std/srfi/13#string-contains__%
         _text1156_
         _pattern1157_
         _t-start1159_
         _t-end1161_
         _p-start1163_
         _p-end1165_))))
  (define std/srfi/13#string-contains__1
    (lambda (_text1167_ _pattern1168_ _t-start1169_)
      (let* ((_t-end1171_ (string-length _text1167_))
             (_p-start1173_ '0)
             (_p-end1175_ (string-length _pattern1168_)))
        (std/srfi/13#string-contains__%
         _text1167_
         _pattern1168_
         _t-start1169_
         _t-end1171_
         _p-start1173_
         _p-end1175_))))
  (define std/srfi/13#string-contains__2
    (lambda (_text1177_ _pattern1178_ _t-start1179_ _t-end1180_)
      (let* ((_p-start1182_ '0) (_p-end1184_ (string-length _pattern1178_)))
        (std/srfi/13#string-contains__%
         _text1177_
         _pattern1178_
         _t-start1179_
         _t-end1180_
         _p-start1182_
         _p-end1184_))))
  (define std/srfi/13#string-contains__3
    (lambda (_text1186_ _pattern1187_ _t-start1188_ _t-end1189_ _p-start1190_)
      (let ((_p-end1192_ (string-length _pattern1187_)))
        (std/srfi/13#string-contains__%
         _text1186_
         _pattern1187_
         _t-start1188_
         _t-end1189_
         _p-start1190_
         _p-end1192_))))
  (define std/srfi/13#string-contains
    (lambda _g7809_
      (let ((_g7808_ (let () (declare (not safe)) (##length _g7809_))))
        (cond ((let () (declare (not safe)) (##fx= _g7808_ 2))
               (apply std/srfi/13#string-contains__0 _g7809_))
              ((let () (declare (not safe)) (##fx= _g7808_ 3))
               (apply std/srfi/13#string-contains__1 _g7809_))
              ((let () (declare (not safe)) (##fx= _g7808_ 4))
               (apply std/srfi/13#string-contains__2 _g7809_))
              ((let () (declare (not safe)) (##fx= _g7808_ 5))
               (apply std/srfi/13#string-contains__3 _g7809_))
              ((let () (declare (not safe)) (##fx= _g7808_ 6))
               (apply std/srfi/13#string-contains__% _g7809_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-contains
                _g7809_))))))
  (define std/srfi/13#string-contains-ci__%
    (lambda (_text1090_
             _pattern1091_
             _t-start1092_
             _t-end1093_
             _p-start1094_
             _p-end1095_)
      (std/srfi/13#%kmp-search
       _pattern1091_
       _text1090_
       char-ci=?
       _p-start1094_
       _p-end1095_
       _t-start1092_
       _t-end1093_)))
  (define std/srfi/13#string-contains-ci__0
    (lambda (_text1100_ _pattern1101_)
      (let* ((_t-start1103_ '0)
             (_t-end1105_ (string-length _text1100_))
             (_p-start1107_ '0)
             (_p-end1109_ (string-length _pattern1101_)))
        (std/srfi/13#string-contains-ci__%
         _text1100_
         _pattern1101_
         _t-start1103_
         _t-end1105_
         _p-start1107_
         _p-end1109_))))
  (define std/srfi/13#string-contains-ci__1
    (lambda (_text1111_ _pattern1112_ _t-start1113_)
      (let* ((_t-end1115_ (string-length _text1111_))
             (_p-start1117_ '0)
             (_p-end1119_ (string-length _pattern1112_)))
        (std/srfi/13#string-contains-ci__%
         _text1111_
         _pattern1112_
         _t-start1113_
         _t-end1115_
         _p-start1117_
         _p-end1119_))))
  (define std/srfi/13#string-contains-ci__2
    (lambda (_text1121_ _pattern1122_ _t-start1123_ _t-end1124_)
      (let* ((_p-start1126_ '0) (_p-end1128_ (string-length _pattern1122_)))
        (std/srfi/13#string-contains-ci__%
         _text1121_
         _pattern1122_
         _t-start1123_
         _t-end1124_
         _p-start1126_
         _p-end1128_))))
  (define std/srfi/13#string-contains-ci__3
    (lambda (_text1130_ _pattern1131_ _t-start1132_ _t-end1133_ _p-start1134_)
      (let ((_p-end1136_ (string-length _pattern1131_)))
        (std/srfi/13#string-contains-ci__%
         _text1130_
         _pattern1131_
         _t-start1132_
         _t-end1133_
         _p-start1134_
         _p-end1136_))))
  (define std/srfi/13#string-contains-ci
    (lambda _g7811_
      (let ((_g7810_ (let () (declare (not safe)) (##length _g7811_))))
        (cond ((let () (declare (not safe)) (##fx= _g7810_ 2))
               (apply std/srfi/13#string-contains-ci__0 _g7811_))
              ((let () (declare (not safe)) (##fx= _g7810_ 3))
               (apply std/srfi/13#string-contains-ci__1 _g7811_))
              ((let () (declare (not safe)) (##fx= _g7810_ 4))
               (apply std/srfi/13#string-contains-ci__2 _g7811_))
              ((let () (declare (not safe)) (##fx= _g7810_ 5))
               (apply std/srfi/13#string-contains-ci__3 _g7811_))
              ((let () (declare (not safe)) (##fx= _g7810_ 6))
               (apply std/srfi/13#string-contains-ci__% _g7811_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-contains-ci
                _g7811_))))))
  (define std/srfi/13#%kmp-search
    (lambda (_pattern1069_
             _text1070_
             _c=1071_
             _p-start1072_
             _p-end1073_
             _t-start1074_
             _t-end1075_)
      (let ((_plen1077_ (- _p-end1073_ _p-start1072_))
            (_rv1078_
             (std/srfi/13#make-kmp-restart-vector__%
              _pattern1069_
              _c=1071_
              _p-start1072_
              _p-end1073_)))
        (let _lp1080_ ((_ti1082_ _t-start1074_)
                       (_pi1083_ '0)
                       (_tj1084_ (- _t-end1075_ _t-start1074_))
                       (_pj1085_ _plen1077_))
          (if (= _pi1083_ _plen1077_)
              (- _ti1082_ _plen1077_)
              (if (<= _pj1085_ _tj1084_)
                  (if (_c=1071_
                       (string-ref _text1070_ _ti1082_)
                       (string-ref _pattern1069_ (+ _p-start1072_ _pi1083_)))
                      (_lp1080_
                       (+ '1 _ti1082_)
                       (+ '1 _pi1083_)
                       (- _tj1084_ '1)
                       (- _pj1085_ '1))
                      (let ((_pi1087_ (vector-ref _rv1078_ _pi1083_)))
                        (if (= _pi1087_ '-1)
                            (_lp1080_
                             (+ _ti1082_ '1)
                             '0
                             (- _tj1084_ '1)
                             _plen1077_)
                            (_lp1080_
                             _ti1082_
                             _pi1087_
                             _tj1084_
                             (- _plen1077_ _pi1087_)))))
                  '#f))))))
  (define std/srfi/13#make-kmp-restart-vector__%
    (lambda (_pattern1010_ _c=1011_ _start1012_ _end1013_)
      (let* ((_rvlen1015_ (- _end1013_ _start1012_))
             (_rv1017_ (make-vector _rvlen1015_ '-1)))
        (if (> _rvlen1015_ '0)
            (let ((_rvlen-11020_ (- _rvlen1015_ '1))
                  (_c01021_ (string-ref _pattern1010_ _start1012_)))
              (let _lp11023_ ((_i1025_ '0) (_j1026_ '-1) (_k1027_ _start1012_))
                (if (< _i1025_ _rvlen-11020_)
                    (let _lp21029_ ((_j1031_ _j1026_))
                      (if (= _j1031_ '-1)
                          (let ((_i11033_ (+ '1 _i1025_)))
                            (if (not (_c=1011_
                                      (string-ref _pattern1010_ (+ _k1027_ '1))
                                      _c01021_))
                                (vector-set! _rv1017_ _i11033_ '0)
                                '#!void)
                            (_lp11023_ _i11033_ '0 (+ _k1027_ '1)))
                          (if (_c=1011_
                               (string-ref _pattern1010_ _k1027_)
                               (string-ref
                                _pattern1010_
                                (+ _j1031_ _start1012_)))
                              (let* ((_i11035_ (+ '1 _i1025_))
                                     (_j11037_ (+ '1 _j1031_)))
                                (vector-set! _rv1017_ _i11035_ _j11037_)
                                (_lp11023_ _i11035_ _j11037_ (+ _k1027_ '1)))
                              (_lp21029_ (vector-ref _rv1017_ _j1031_)))))
                    '#!void)))
            '#!void)
        _rv1017_)))
  (define std/srfi/13#make-kmp-restart-vector__0
    (lambda (_pattern1043_)
      (let* ((_c=1045_ char=?)
             (_start1047_ '0)
             (_end1049_ (string-length _pattern1043_)))
        (std/srfi/13#make-kmp-restart-vector__%
         _pattern1043_
         _c=1045_
         _start1047_
         _end1049_))))
  (define std/srfi/13#make-kmp-restart-vector__1
    (lambda (_pattern1051_ _c=1052_)
      (let* ((_start1054_ '0) (_end1056_ (string-length _pattern1051_)))
        (std/srfi/13#make-kmp-restart-vector__%
         _pattern1051_
         _c=1052_
         _start1054_
         _end1056_))))
  (define std/srfi/13#make-kmp-restart-vector__2
    (lambda (_pattern1058_ _c=1059_ _start1060_)
      (let ((_end1062_ (string-length _pattern1058_)))
        (std/srfi/13#make-kmp-restart-vector__%
         _pattern1058_
         _c=1059_
         _start1060_
         _end1062_))))
  (define std/srfi/13#make-kmp-restart-vector
    (lambda _g7813_
      (let ((_g7812_ (let () (declare (not safe)) (##length _g7813_))))
        (cond ((let () (declare (not safe)) (##fx= _g7812_ 1))
               (apply std/srfi/13#make-kmp-restart-vector__0 _g7813_))
              ((let () (declare (not safe)) (##fx= _g7812_ 2))
               (apply std/srfi/13#make-kmp-restart-vector__1 _g7813_))
              ((let () (declare (not safe)) (##fx= _g7812_ 3))
               (apply std/srfi/13#make-kmp-restart-vector__2 _g7813_))
              ((let () (declare (not safe)) (##fx= _g7812_ 4))
               (apply std/srfi/13#make-kmp-restart-vector__% _g7813_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#make-kmp-restart-vector
                _g7813_))))))
  (define std/srfi/13#kmp-step
    (lambda (_pat996_ _rv997_ _c998_ _i999_ _c=1000_ _p-start1001_)
      (let _lp1003_ ((_i1005_ _i999_))
        (if (_c=1000_ _c998_ (string-ref _pat996_ (+ _i1005_ _p-start1001_)))
            (+ _i1005_ '1)
            (let ((_i1007_ (vector-ref _rv997_ _i1005_)))
              (if (= _i1007_ '-1) '0 (_lp1003_ _i1007_)))))))
  (define std/srfi/13#string-kmp-partial-search__%
    (lambda (_pat914_
             _rv915_
             _s916_
             _i917_
             _c=918_
             _p-start919_
             _s-start920_
             _s-end921_)
      (let ((_patlen923_ (vector-length _rv915_)))
        (let _lp925_ ((_si927_ _s-start920_) (_vi928_ _i917_))
          (if (= _vi928_ _patlen923_)
              (- _si927_)
              (if (= _si927_ _s-end921_)
                  _vi928_
                  (let ((_c930_ (string-ref _s916_ _si927_)))
                    (_lp925_ (+ _si927_ '1)
                             (let _lp2932_ ((_vi934_ _vi928_))
                               (if (_c=918_ _c930_
                                            (string-ref
                                             _pat914_
                                             (+ _vi934_ _p-start919_)))
                                   (+ _vi934_ '1)
                                   (let ((_vi936_ (vector-ref
                                                   _rv915_
                                                   _vi934_)))
                                     (if (= _vi936_ '-1)
                                         '0
                                         (_lp2932_ _vi936_)))))))))))))
  (define std/srfi/13#string-kmp-partial-search__0
    (lambda (_pat941_ _rv942_ _s943_ _i944_)
      (let* ((_c=946_ char=?)
             (_p-start948_ '0)
             (_s-start950_ '0)
             (_s-end952_ (string-length _s943_)))
        (std/srfi/13#string-kmp-partial-search__%
         _pat941_
         _rv942_
         _s943_
         _i944_
         _c=946_
         _p-start948_
         _s-start950_
         _s-end952_))))
  (define std/srfi/13#string-kmp-partial-search__1
    (lambda (_pat954_ _rv955_ _s956_ _i957_ _c=958_)
      (let* ((_p-start960_ '0)
             (_s-start962_ '0)
             (_s-end964_ (string-length _s956_)))
        (std/srfi/13#string-kmp-partial-search__%
         _pat954_
         _rv955_
         _s956_
         _i957_
         _c=958_
         _p-start960_
         _s-start962_
         _s-end964_))))
  (define std/srfi/13#string-kmp-partial-search__2
    (lambda (_pat966_ _rv967_ _s968_ _i969_ _c=970_ _p-start971_)
      (let* ((_s-start973_ '0) (_s-end975_ (string-length _s968_)))
        (std/srfi/13#string-kmp-partial-search__%
         _pat966_
         _rv967_
         _s968_
         _i969_
         _c=970_
         _p-start971_
         _s-start973_
         _s-end975_))))
  (define std/srfi/13#string-kmp-partial-search__3
    (lambda (_pat977_ _rv978_ _s979_ _i980_ _c=981_ _p-start982_ _s-start983_)
      (let ((_s-end985_ (string-length _s979_)))
        (std/srfi/13#string-kmp-partial-search__%
         _pat977_
         _rv978_
         _s979_
         _i980_
         _c=981_
         _p-start982_
         _s-start983_
         _s-end985_))))
  (define std/srfi/13#string-kmp-partial-search
    (lambda _g7815_
      (let ((_g7814_ (let () (declare (not safe)) (##length _g7815_))))
        (cond ((let () (declare (not safe)) (##fx= _g7814_ 4))
               (apply std/srfi/13#string-kmp-partial-search__0 _g7815_))
              ((let () (declare (not safe)) (##fx= _g7814_ 5))
               (apply std/srfi/13#string-kmp-partial-search__1 _g7815_))
              ((let () (declare (not safe)) (##fx= _g7814_ 6))
               (apply std/srfi/13#string-kmp-partial-search__2 _g7815_))
              ((let () (declare (not safe)) (##fx= _g7814_ 7))
               (apply std/srfi/13#string-kmp-partial-search__3 _g7815_))
              ((let () (declare (not safe)) (##fx= _g7814_ 8))
               (apply std/srfi/13#string-kmp-partial-search__% _g7815_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-kmp-partial-search
                _g7815_))))))
  (define std/srfi/13#string-null?
    (lambda (_s911_) (zero? (string-length _s911_))))
  (define std/srfi/13#string-reverse__%
    (lambda (_s878_ _start879_ _end880_)
      (let* ((_len882_ (- _end880_ _start879_))
             (_ans884_ (make-string _len882_)))
        (let _$loop887_ ((_i890_ _start879_) (_j891_ (- _len882_ '1)))
          (if (< _j891_ '0)
              '#!void
              (begin
                (string-set! _ans884_ _j891_ (string-ref _s878_ _i890_))
                (_$loop887_ (+ _i890_ '1) (- _j891_ '1)))))
        _ans884_)))
  (define std/srfi/13#string-reverse__0
    (lambda (_s896_)
      (let* ((_start898_ '0) (_end900_ (string-length _s896_)))
        (std/srfi/13#string-reverse__% _s896_ _start898_ _end900_))))
  (define std/srfi/13#string-reverse__1
    (lambda (_s902_ _start903_)
      (let ((_end905_ (string-length _s902_)))
        (std/srfi/13#string-reverse__% _s902_ _start903_ _end905_))))
  (define std/srfi/13#string-reverse
    (lambda _g7817_
      (let ((_g7816_ (let () (declare (not safe)) (##length _g7817_))))
        (cond ((let () (declare (not safe)) (##fx= _g7816_ 1))
               (apply std/srfi/13#string-reverse__0 _g7817_))
              ((let () (declare (not safe)) (##fx= _g7816_ 2))
               (apply std/srfi/13#string-reverse__1 _g7817_))
              ((let () (declare (not safe)) (##fx= _g7816_ 3))
               (apply std/srfi/13#string-reverse__% _g7817_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-reverse
                _g7817_))))))
  (define std/srfi/13#string-reverse!__%
    (lambda (_s847_ _start848_ _end849_)
      (let _$loop851_ ((_i854_ (- _end849_ '1)) (_j855_ _start848_))
        (if (<= _i854_ _j855_)
            '#!void
            (begin
              (let ((_ci857_ (string-ref _s847_ _i854_)))
                (string-set! _s847_ _i854_ (string-ref _s847_ _j855_))
                (string-set! _s847_ _j855_ _ci857_))
              (_$loop851_ (- _i854_ '1) (+ _j855_ '1)))))))
  (define std/srfi/13#string-reverse!__0
    (lambda (_s862_)
      (let* ((_start864_ '0) (_end866_ (string-length _s862_)))
        (std/srfi/13#string-reverse!__% _s862_ _start864_ _end866_))))
  (define std/srfi/13#string-reverse!__1
    (lambda (_s868_ _start869_)
      (let ((_end871_ (string-length _s868_)))
        (std/srfi/13#string-reverse!__% _s868_ _start869_ _end871_))))
  (define std/srfi/13#string-reverse!
    (lambda _g7819_
      (let ((_g7818_ (let () (declare (not safe)) (##length _g7819_))))
        (cond ((let () (declare (not safe)) (##fx= _g7818_ 1))
               (apply std/srfi/13#string-reverse!__0 _g7819_))
              ((let () (declare (not safe)) (##fx= _g7818_ 2))
               (apply std/srfi/13#string-reverse!__1 _g7819_))
              ((let () (declare (not safe)) (##fx= _g7818_ 3))
               (apply std/srfi/13#string-reverse!__% _g7819_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-reverse!
                _g7819_))))))
  (define std/srfi/13#reverse-list->string
    (lambda (_clist833_)
      (let* ((_len835_ (length _clist833_)) (_s837_ (make-string _len835_)))
        (let _$loop840_ ((_i843_ (- _len835_ '1)) (_clist844_ _clist833_))
          (if (not (pair? _clist844_))
              '#!void
              (begin
                (string-set! _s837_ _i843_ (car _clist844_))
                (_$loop840_ (- _i843_ '1) (cdr _clist844_)))))
        _s837_)))
  (define std/srfi/13#string->list__%
    (lambda (_s805_ _start806_ _end807_)
      (let _$loop809_ ((_i812_ (- _end807_ '1)) (_ans813_ '()))
        (if (< _i812_ _start806_)
            _ans813_
            (_$loop809_
             (- _i812_ '1)
             (cons (string-ref _s805_ _i812_) _ans813_))))))
  (define std/srfi/13#string->list__0
    (lambda (_s818_)
      (let* ((_start820_ '0) (_end822_ (string-length _s818_)))
        (std/srfi/13#string->list__% _s818_ _start820_ _end822_))))
  (define std/srfi/13#string->list__1
    (lambda (_s824_ _start825_)
      (let ((_end827_ (string-length _s824_)))
        (std/srfi/13#string->list__% _s824_ _start825_ _end827_))))
  (define std/srfi/13#string->list
    (lambda _g7821_
      (let ((_g7820_ (let () (declare (not safe)) (##length _g7821_))))
        (cond ((let () (declare (not safe)) (##fx= _g7820_ 1))
               (apply std/srfi/13#string->list__0 _g7821_))
              ((let () (declare (not safe)) (##fx= _g7820_ 2))
               (apply std/srfi/13#string->list__1 _g7821_))
              ((let () (declare (not safe)) (##fx= _g7820_ 3))
               (apply std/srfi/13#string->list__% _g7821_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string->list
                _g7821_))))))
  (define std/srfi/13#string-append/shared
    (lambda _strings802_ (std/srfi/13#string-concatenate/shared _strings802_)))
  (define std/srfi/13#string-concatenate/shared
    (lambda (_strings772_)
      (let _lp774_ ((_strings776_ _strings772_)
                    (_nchars777_ '0)
                    (_first778_ '#f))
        (if (pair? _strings776_)
            (let* ((_string780_ (car _strings776_))
                   (_tail782_ (cdr _strings776_))
                   (_slen784_ (string-length _string780_)))
              (if (zero? _slen784_)
                  (_lp774_ _tail782_ _nchars777_ _first778_)
                  (_lp774_ _tail782_
                           (+ _nchars777_ _slen784_)
                           (let ((_$e787_ _first778_))
                             (if _$e787_ _$e787_ _strings776_)))))
            (if (zero? _nchars777_)
                '""
                (if (= _nchars777_ (string-length (car _first778_)))
                    (car _first778_)
                    (let ((_ans790_ (make-string _nchars777_)))
                      (let _lp792_ ((_strings794_ _first778_) (_i795_ '0))
                        (if (pair? _strings794_)
                            (let* ((_s797_ (car _strings794_))
                                   (_slen799_ (string-length _s797_)))
                              (std/srfi/13#%string-copy!
                               _ans790_
                               _i795_
                               _s797_
                               '0
                               _slen799_)
                              (_lp792_ (cdr _strings794_)
                                       (+ _i795_ _slen799_)))
                            '#!void))
                      _ans790_)))))))
  (define std/srfi/13#string-concatenate
    (lambda (_strings749_)
      (let* ((_total757_
              (let _$loop751_ ((_strings754_ _strings749_) (_i755_ '0))
                (if (not (pair? _strings754_))
                    _i755_
                    (_$loop751_
                     (cdr _strings754_)
                     (+ _i755_ (string-length (car _strings754_)))))))
             (_ans759_ (make-string _total757_)))
        (let _lp762_ ((_i764_ '0) (_strings765_ _strings749_))
          (if (pair? _strings765_)
              (let* ((_s767_ (car _strings765_))
                     (_slen769_ (string-length _s767_)))
                (std/srfi/13#%string-copy! _ans759_ _i764_ _s767_ '0 _slen769_)
                (_lp762_ (+ _i764_ _slen769_) (cdr _strings765_)))
              '#!void))
        _ans759_)))
  (define std/srfi/13#string-concatenate-reverse__%
    (lambda (_string-list720_ _final721_ _end722_)
      (let ((_len729_
             (let _lp724_ ((_sum726_ '0) (_lis727_ _string-list720_))
               (if (pair? _lis727_)
                   (_lp724_ (+ _sum726_ (string-length (car _lis727_)))
                            (cdr _lis727_))
                   _sum726_))))
        (std/srfi/13#%finish-string-concatenate-reverse
         _len729_
         _string-list720_
         _final721_
         _end722_))))
  (define std/srfi/13#string-concatenate-reverse__0
    (lambda (_string-list734_)
      (let* ((_final736_ '"") (_end738_ (string-length _final736_)))
        (std/srfi/13#string-concatenate-reverse__%
         _string-list734_
         _final736_
         _end738_))))
  (define std/srfi/13#string-concatenate-reverse__1
    (lambda (_string-list740_ _final741_)
      (let ((_end743_ (string-length _final741_)))
        (std/srfi/13#string-concatenate-reverse__%
         _string-list740_
         _final741_
         _end743_))))
  (define std/srfi/13#string-concatenate-reverse
    (lambda _g7823_
      (let ((_g7822_ (let () (declare (not safe)) (##length _g7823_))))
        (cond ((let () (declare (not safe)) (##fx= _g7822_ 1))
               (apply std/srfi/13#string-concatenate-reverse__0 _g7823_))
              ((let () (declare (not safe)) (##fx= _g7822_ 2))
               (apply std/srfi/13#string-concatenate-reverse__1 _g7823_))
              ((let () (declare (not safe)) (##fx= _g7822_ 3))
               (apply std/srfi/13#string-concatenate-reverse__% _g7823_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-concatenate-reverse
                _g7823_))))))
  (define std/srfi/13#string-concatenate-reverse/shared__%
    (lambda (_string-list686_ _final687_ _end688_)
      (let _lp690_ ((_len692_ '0)
                    (_nzlist693_ '#f)
                    (_lis694_ _string-list686_))
        (if (pair? _lis694_)
            (let ((_slen696_ (string-length (car _lis694_))))
              (_lp690_ (+ _len692_ _slen696_)
                       (if (or _nzlist693_ (zero? _slen696_))
                           _nzlist693_
                           _lis694_)
                       (cdr _lis694_)))
            (if (zero? _len692_)
                (std/srfi/13#%substring/shared _final687_ '0 _end688_)
                (if (and (zero? _end688_)
                         (= _len692_ (string-length (car _nzlist693_))))
                    (car _nzlist693_)
                    (std/srfi/13#%finish-string-concatenate-reverse
                     _len692_
                     _nzlist693_
                     _final687_
                     _end688_)))))))
  (define std/srfi/13#string-concatenate-reverse/shared__0
    (lambda (_string-list704_)
      (let* ((_final706_ '"") (_end708_ (string-length _final706_)))
        (std/srfi/13#string-concatenate-reverse/shared__%
         _string-list704_
         _final706_
         _end708_))))
  (define std/srfi/13#string-concatenate-reverse/shared__1
    (lambda (_string-list710_ _final711_)
      (let ((_end713_ (string-length _final711_)))
        (std/srfi/13#string-concatenate-reverse/shared__%
         _string-list710_
         _final711_
         _end713_))))
  (define std/srfi/13#string-concatenate-reverse/shared
    (lambda _g7825_
      (let ((_g7824_ (let () (declare (not safe)) (##length _g7825_))))
        (cond ((let () (declare (not safe)) (##fx= _g7824_ 1))
               (apply std/srfi/13#string-concatenate-reverse/shared__0
                      _g7825_))
              ((let () (declare (not safe)) (##fx= _g7824_ 2))
               (apply std/srfi/13#string-concatenate-reverse/shared__1
                      _g7825_))
              ((let () (declare (not safe)) (##fx= _g7824_ 3))
               (apply std/srfi/13#string-concatenate-reverse/shared__%
                      _g7825_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-concatenate-reverse/shared
                _g7825_))))))
  (define std/srfi/13#%finish-string-concatenate-reverse
    (lambda (_len664_ _string-list665_ _final666_ _end667_)
      (let ((_ans669_ (make-string (+ _end667_ _len664_))))
        (std/srfi/13#%string-copy! _ans669_ _len664_ _final666_ '0 _end667_)
        (let _lp671_ ((_i673_ _len664_) (_lis674_ _string-list665_))
          (if (pair? _lis674_)
              (let* ((_s676_ (car _lis674_))
                     (_lis678_ (cdr _lis674_))
                     (_slen680_ (string-length _s676_))
                     (_i682_ (- _i673_ _slen680_)))
                (std/srfi/13#%string-copy! _ans669_ _i682_ _s676_ '0 _slen680_)
                (_lp671_ _i682_ _lis678_))
              '#!void))
        _ans669_)))
  (define std/srfi/13#string-replace__%
    (lambda (_s1621_ _s2622_ _start1623_ _end1624_ _start2625_ _end2626_)
      (let* ((_slen1628_ (string-length _s1621_))
             (_sublen2630_ (- _end2626_ _start2625_))
             (_alen632_
              (+ (- _slen1628_ (- _end1624_ _start1623_)) _sublen2630_))
             (_ans634_ (make-string _alen632_)))
        (std/srfi/13#%string-copy! _ans634_ '0 _s1621_ '0 _start1623_)
        (std/srfi/13#%string-copy!
         _ans634_
         _start1623_
         _s2622_
         _start2625_
         _end2626_)
        (std/srfi/13#%string-copy!
         _ans634_
         (+ _start1623_ _sublen2630_)
         _s1621_
         _end1624_
         _slen1628_)
        _ans634_)))
  (define std/srfi/13#string-replace__0
    (lambda (_s1640_ _s2641_ _start1642_ _end1643_)
      (let* ((_start2645_ '0) (_end2647_ (string-length _s2641_)))
        (std/srfi/13#string-replace__%
         _s1640_
         _s2641_
         _start1642_
         _end1643_
         _start2645_
         _end2647_))))
  (define std/srfi/13#string-replace__1
    (lambda (_s1649_ _s2650_ _start1651_ _end1652_ _start2653_)
      (let ((_end2655_ (string-length _s2650_)))
        (std/srfi/13#string-replace__%
         _s1649_
         _s2650_
         _start1651_
         _end1652_
         _start2653_
         _end2655_))))
  (define std/srfi/13#string-replace
    (lambda _g7827_
      (let ((_g7826_ (let () (declare (not safe)) (##length _g7827_))))
        (cond ((let () (declare (not safe)) (##fx= _g7826_ 4))
               (apply std/srfi/13#string-replace__0 _g7827_))
              ((let () (declare (not safe)) (##fx= _g7826_ 5))
               (apply std/srfi/13#string-replace__1 _g7827_))
              ((let () (declare (not safe)) (##fx= _g7826_ 6))
               (apply std/srfi/13#string-replace__% _g7827_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-replace
                _g7827_))))))
  (define std/srfi/13#string-tokenize__%
    (lambda (_s569_ _token-chars570_ _start571_ _end572_)
      (let _lp574_ ((_i576_ _end572_) (_ans577_ '()))
        (let ((_$e579_ (if (< _start571_ _i576_)
                           (std/srfi/13#string-index-right__%
                            _s569_
                            _token-chars570_
                            _start571_
                            _i576_)
                           '#f)))
          (if _$e579_
              ((lambda (_tend-1582_)
                 (let* ((_tend584_ (+ '1 _tend-1582_))
                        (_$e586_ (std/srfi/13#string-skip-right__%
                                  _s569_
                                  _token-chars570_
                                  _start571_
                                  _tend-1582_)))
                   (if _$e586_
                       ((lambda (_tstart-1589_)
                          (_lp574_ _tstart-1589_
                                   (cons (substring
                                          _s569_
                                          (+ '1 _tstart-1589_)
                                          _tend584_)
                                         _ans577_)))
                        _$e586_)
                       (cons (substring _s569_ _start571_ _tend584_)
                             _ans577_))))
               _$e579_)
              _ans577_)))))
  (define std/srfi/13#string-tokenize__0
    (lambda (_s594_)
      (let* ((_token-chars596_ std/srfi/14#char-set:graphic)
             (_start598_ '0)
             (_end600_ (string-length _s594_)))
        (std/srfi/13#string-tokenize__%
         _s594_
         _token-chars596_
         _start598_
         _end600_))))
  (define std/srfi/13#string-tokenize__1
    (lambda (_s602_ _token-chars603_)
      (let* ((_start605_ '0) (_end607_ (string-length _s602_)))
        (std/srfi/13#string-tokenize__%
         _s602_
         _token-chars603_
         _start605_
         _end607_))))
  (define std/srfi/13#string-tokenize__2
    (lambda (_s609_ _token-chars610_ _start611_)
      (let ((_end613_ (string-length _s609_)))
        (std/srfi/13#string-tokenize__%
         _s609_
         _token-chars610_
         _start611_
         _end613_))))
  (define std/srfi/13#string-tokenize
    (lambda _g7829_
      (let ((_g7828_ (let () (declare (not safe)) (##length _g7829_))))
        (cond ((let () (declare (not safe)) (##fx= _g7828_ 1))
               (apply std/srfi/13#string-tokenize__0 _g7829_))
              ((let () (declare (not safe)) (##fx= _g7828_ 2))
               (apply std/srfi/13#string-tokenize__1 _g7829_))
              ((let () (declare (not safe)) (##fx= _g7828_ 3))
               (apply std/srfi/13#string-tokenize__2 _g7829_))
              ((let () (declare (not safe)) (##fx= _g7828_ 4))
               (apply std/srfi/13#string-tokenize__% _g7829_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-tokenize
                _g7829_))))))
  (define std/srfi/13#xsubstring__%
    (lambda (_s524_ _from525_ _to526_ _start527_ _end528_)
      (let ((_slen530_ (- _end528_ _start527_))
            (_anslen531_ (- _to526_ _from525_)))
        (if (zero? _anslen531_)
            '""
            (if (zero? _slen530_)
                (error '"Cannot replicate empty (sub)string"
                       std/srfi/13#xsubstring
                       _s524_
                       _from525_
                       _to526_
                       _start527_
                       _end528_)
                (if (= '1 _slen530_)
                    (make-string _anslen531_ (string-ref _s524_ _start527_))
                    (if (= (floor (/ _from525_ _slen530_))
                           (floor (/ _to526_ _slen530_)))
                        (substring
                         _s524_
                         (+ _start527_ (modulo _from525_ _slen530_))
                         (+ _start527_ (modulo _to526_ _slen530_)))
                        (let ((_ans533_ (make-string _anslen531_)))
                          (std/srfi/13#%multispan-repcopy!
                           _ans533_
                           '0
                           _s524_
                           _from525_
                           _to526_
                           _start527_
                           _end528_)
                          _ans533_))))))))
  (define std/srfi/13#xsubstring__0
    (lambda (_s538_ _from539_)
      (let* ((_to541_ (+ _from539_ (string-length _s538_)))
             (_start543_ '0)
             (_end545_ (string-length _s538_)))
        (std/srfi/13#xsubstring__%
         _s538_
         _from539_
         _to541_
         _start543_
         _end545_))))
  (define std/srfi/13#xsubstring__1
    (lambda (_s547_ _from548_ _to549_)
      (let* ((_start551_ '0) (_end553_ (string-length _s547_)))
        (std/srfi/13#xsubstring__%
         _s547_
         _from548_
         _to549_
         _start551_
         _end553_))))
  (define std/srfi/13#xsubstring__2
    (lambda (_s555_ _from556_ _to557_ _start558_)
      (let ((_end560_ (string-length _s555_)))
        (std/srfi/13#xsubstring__%
         _s555_
         _from556_
         _to557_
         _start558_
         _end560_))))
  (define std/srfi/13#xsubstring
    (lambda _g7831_
      (let ((_g7830_ (let () (declare (not safe)) (##length _g7831_))))
        (cond ((let () (declare (not safe)) (##fx= _g7830_ 2))
               (apply std/srfi/13#xsubstring__0 _g7831_))
              ((let () (declare (not safe)) (##fx= _g7830_ 3))
               (apply std/srfi/13#xsubstring__1 _g7831_))
              ((let () (declare (not safe)) (##fx= _g7830_ 4))
               (apply std/srfi/13#xsubstring__2 _g7831_))
              ((let () (declare (not safe)) (##fx= _g7830_ 5))
               (apply std/srfi/13#xsubstring__% _g7831_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#xsubstring
                _g7831_))))))
  (define std/srfi/13#string-xcopy!__%
    (lambda (_target464_
             _tstart465_
             _s466_
             _sfrom467_
             _sto468_
             _start469_
             _end470_)
      (let* ((_tocopy472_ (- _sto468_ _sfrom467_))
             (_tend474_ (+ _tstart465_ _tocopy472_))
             (_slen476_ (- _end470_ _start469_)))
        (let ((_$e479_ (zero? _tocopy472_)))
          (if _$e479_
              _$e479_
              (if (zero? _slen476_)
                  (error '"Cannot replicate empty (sub)string"
                         std/srfi/13#string-xcopy!
                         _target464_
                         _tstart465_
                         _s466_
                         _sfrom467_
                         _sto468_
                         _start469_
                         _end470_)
                  (if (= '1 _slen476_)
                      (std/srfi/13#string-fill!__%
                       _target464_
                       (string-ref _s466_ _start469_)
                       _tstart465_
                       _tend474_)
                      (if (= (floor (/ _sfrom467_ _slen476_))
                             (floor (/ _sto468_ _slen476_)))
                          (std/srfi/13#%string-copy!
                           _target464_
                           _tstart465_
                           _s466_
                           (+ _start469_ (modulo _sfrom467_ _slen476_))
                           (+ _start469_ (modulo _sto468_ _slen476_)))
                          (std/srfi/13#%multispan-repcopy!
                           _target464_
                           _tstart465_
                           _s466_
                           _sfrom467_
                           _sto468_
                           _start469_
                           _end470_)))))))))
  (define std/srfi/13#string-xcopy!__0
    (lambda (_target485_ _tstart486_ _s487_ _sfrom488_)
      (let* ((_sto490_ (+ _sfrom488_ (string-length _s487_)))
             (_start492_ '0)
             (_end494_ (string-length _s487_)))
        (std/srfi/13#string-xcopy!__%
         _target485_
         _tstart486_
         _s487_
         _sfrom488_
         _sto490_
         _start492_
         _end494_))))
  (define std/srfi/13#string-xcopy!__1
    (lambda (_target496_ _tstart497_ _s498_ _sfrom499_ _sto500_)
      (let* ((_start502_ '0) (_end504_ (string-length _s498_)))
        (std/srfi/13#string-xcopy!__%
         _target496_
         _tstart497_
         _s498_
         _sfrom499_
         _sto500_
         _start502_
         _end504_))))
  (define std/srfi/13#string-xcopy!__2
    (lambda (_target506_ _tstart507_ _s508_ _sfrom509_ _sto510_ _start511_)
      (let ((_end513_ (string-length _s508_)))
        (std/srfi/13#string-xcopy!__%
         _target506_
         _tstart507_
         _s508_
         _sfrom509_
         _sto510_
         _start511_
         _end513_))))
  (define std/srfi/13#string-xcopy!
    (lambda _g7833_
      (let ((_g7832_ (let () (declare (not safe)) (##length _g7833_))))
        (cond ((let () (declare (not safe)) (##fx= _g7832_ 4))
               (apply std/srfi/13#string-xcopy!__0 _g7833_))
              ((let () (declare (not safe)) (##fx= _g7832_ 5))
               (apply std/srfi/13#string-xcopy!__1 _g7833_))
              ((let () (declare (not safe)) (##fx= _g7832_ 6))
               (apply std/srfi/13#string-xcopy!__2 _g7833_))
              ((let () (declare (not safe)) (##fx= _g7832_ 7))
               (apply std/srfi/13#string-xcopy!__% _g7833_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-xcopy!
                _g7833_))))))
  (define std/srfi/13#%multispan-repcopy!
    (lambda (_target435_
             _tstart436_
             _s437_
             _sfrom438_
             _sto439_
             _start440_
             _end441_)
      (let* ((_slen443_ (- _end441_ _start440_))
             (_i0445_ (+ _start440_ (modulo _sfrom438_ _slen443_)))
             (_total-chars447_ (- _sto439_ _sfrom438_)))
        (std/srfi/13#%string-copy!
         _target435_
         _tstart436_
         _s437_
         _i0445_
         _end441_)
        (let* ((_ncopied450_ (- _end441_ _i0445_))
               (_nleft452_ (- _total-chars447_ _ncopied450_))
               (_nspans454_ (quotient _nleft452_ _slen443_)))
          (let _$loop457_ ((_i460_ (+ _tstart436_ _ncopied450_))
                           (_nspans461_ _nspans454_))
            (if (zero? _nspans461_)
                (std/srfi/13#%string-copy!
                 _target435_
                 _i460_
                 _s437_
                 _start440_
                 (+ _start440_ (- _total-chars447_ (- _i460_ _tstart436_))))
                (begin
                  (std/srfi/13#%string-copy!
                   _target435_
                   _i460_
                   _s437_
                   _start440_
                   _end441_)
                  (_$loop457_ (+ _i460_ _slen443_) (- _nspans461_ '1)))))))))
  (define std/srfi/13#string-join__%
    (lambda (_strings398_ _delim399_ _grammar400_)
      (let ((_buildit409_
             (lambda (_lis402_ _final403_)
               (let _recur405_ ((_lis407_ _lis402_))
                 (if (pair? _lis407_)
                     (cons _delim399_
                           (cons (car _lis407_) (_recur405_ (cdr _lis407_))))
                     _final403_)))))
        (if (pair? _strings398_)
            (std/srfi/13#string-concatenate
             (let ((_$e411_ _grammar400_))
               (if (or (eq? 'infix _$e411_) (eq? 'strict-infix _$e411_))
                   (cons (car _strings398_)
                         (_buildit409_ (cdr _strings398_) '()))
                   (if (eq? 'prefix _$e411_)
                       (_buildit409_ _strings398_ '())
                       (if (eq? 'suffix _$e411_)
                           (cons (car _strings398_)
                                 (_buildit409_
                                  (cdr _strings398_)
                                  (list _delim399_)))
                           (error '"Illegal join grammar"
                                  _grammar400_
                                  std/srfi/13#string-join))))))
            (if (not (null? _strings398_))
                (error '"STRINGS parameter not list."
                       _strings398_
                       std/srfi/13#string-join)
                (if (eq? _grammar400_ 'strict-infix)
                    (error '"Empty list cannot be joined with STRICT-INFIX grammar."
                           std/srfi/13#string-join)
                    '""))))))
  (define std/srfi/13#string-join__0
    (lambda (_strings420_)
      (let* ((_delim422_ '" ") (_grammar424_ 'infix))
        (std/srfi/13#string-join__% _strings420_ _delim422_ _grammar424_))))
  (define std/srfi/13#string-join__1
    (lambda (_strings426_ _delim427_)
      (let ((_grammar429_ 'infix))
        (std/srfi/13#string-join__% _strings426_ _delim427_ _grammar429_))))
  (define std/srfi/13#string-join
    (lambda _g7835_
      (let ((_g7834_ (let () (declare (not safe)) (##length _g7835_))))
        (cond ((let () (declare (not safe)) (##fx= _g7834_ 1))
               (apply std/srfi/13#string-join__0 _g7835_))
              ((let () (declare (not safe)) (##fx= _g7834_ 2))
               (apply std/srfi/13#string-join__1 _g7835_))
              ((let () (declare (not safe)) (##fx= _g7834_ 3))
               (apply std/srfi/13#string-join__% _g7835_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/13#string-join
                _g7835_)))))))
