##################################################################
#
# arirang v2.02
#
# arirang script file format
# by pilot 
#
##################################################################
# arirang script easy, flexible, available many functions
# of Ruby
#
# structure like below
# <arirang>
#   connect ------
#    |            |
#   send          |
#    |     -------| --- Ruby http://www.ruby-lang.org
#   recv          |  
#    |            |
#   print  -------
# </arirang>
#
###################################################################
# class Arirang
# two global variable ($ari_host, $ari_sport)
# three instant variables (@ari_port, @ari_recvsize, @ari_recvflag)
# two methods (baedal, asadal)
# four arirang functions (ariconnect, arisend, ariclose, ariprint)
###################################################################
#
=begin
###################################################################
# arirang script must to require at least 3 defines 
# class Arirang, methods baedal, asadal
# 
class Arirang         #define class - class name must to be Arirang

#@ari_port = 80       # tcp port
#@ari_recvsize = 1024 # socket receive buffer size
#@ari_recvflag = 3 # socket receive flags
                   # 1 MSG_OOB         process out-of-band data
                   # 2 MSG_PEEK        peek at incoming message
                   # 3 MSG_WAITALL     wait for full request or error
                   # 4 MSG_DONTWAIT    don't block


    def baedal
        #
        # arirang script information function
        #
    end

    def asadal
        #
        # main part of arirang script
        #
        # available arirang functions 
        #   ariconnect       - socket connect
        #   arisend(string)  - socket send string (string not NULL)
        #                    - string size unlimited 
        #                    - arisend return to recv buf.
        #   ariclose         - socket close
        #   ariprint(string) - print string
        # available arirang variable
        #   $ari_host - host/ip 
        #   $ari_sport - scan port
    end

end

###################################################################
=end
###################################################################
#
#
# arirang script(-R option) run with -t -X -S -h -f -s -e -P
#                               not  -w -r 
# 
# if you make arirang script, please e-mail to me.
# 
################################################################### 

class Arirang

#@ari_port = 80
#@ari_recvsize = 1024
#@ari_recvflag = 3

    def baedal
        ari_title  = "arirang script example\n"
        ari_desc   = "send arirang to http webserver\n"
        #ari_author = "\n"
        #ari_license = "\n"

        puts "title: #{ari_title}"
        puts "desc: #{ari_desc}"
        #puts "author: #{ari_author}"
        #puts "license: #{ari_license}"
    end

    def asadal
        buf = "GET /arirang HTTP/1.0\r\n\r\n"
        ariconnect
        resp = arisend(buf)
        z = "#{$ari_host} - #{$ari_sport}/tcp - arirang url request\n" 
        ariprint(z)
        ariprint(resp)
    end

end

###################################################################
