/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.DepthFirstSearch;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.action.DatabaseConnectionManagerAction;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.DataMover;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.SQLPowerUtils;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DataMoverPanel {
    private JPanel panel;
    private JTree sourceTree;
    private JTree destTree;
    private SQLObjectRoot treeRoot;
    private JCheckBox truncateDestinationTableBox;
    private ArchitectSwingSession session;
    private final TreeSelectionListener dbTreeListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            boolean buttonEnabled = DataMoverPanel.this.okAction.isEnabled();
            boolean sourceValid = DataMoverPanel.this.isSourceTreeSelectionValid();
            boolean destValid = DataMoverPanel.this.isDestTreeSelectionValid();
            if (!buttonEnabled && sourceValid && destValid) {
                DataMoverPanel.this.okAction.setEnabled(true);
            } else if (!(!buttonEnabled || sourceValid && destValid)) {
                DataMoverPanel.this.okAction.setEnabled(false);
            }
        }
    };
    private Action okAction = new AbstractAction(Messages.getString("DataMoverPanel.okButton")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DataMoverPanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                DataMoverPanel.this.doDataMove();
            }
            catch (Exception ex) {
                ASUtils.showExceptionDialog(DataMoverPanel.this.session, Messages.getString("DataMoverPanel.failedToMoveData"), ex);
            }
            finally {
                DataMoverPanel.this.panel.setCursor(null);
            }
        }
    };
    private Action cancelAction = new AbstractAction(Messages.getString("DataMoverPanel.cancelButton")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Window w = SPSUtils.getWindowInHierarchy((Component)DataMoverPanel.this.panel);
                if (w != null) {
                    w.dispose();
                }
            }
            catch (Exception ex) {
                ASUtils.showExceptionDialog(DataMoverPanel.this.session, Messages.getString("DataMoverPanel.failedToMoveData"), ex);
            }
        }
    };

    public DataMoverPanel(ArchitectSwingSession session) throws SQLObjectException {
        this.session = session;
        this.setupDBTrees();
        this.okAction.setEnabled(false);
        this.sourceTree = new JTree();
        DBTreeModel sourceTreeModel = new DBTreeModel(this.treeRoot, this.sourceTree);
        this.sourceTree.setModel(sourceTreeModel);
        this.sourceTree.setRootVisible(false);
        this.sourceTree.setShowsRootHandles(true);
        this.sourceTree.setCellRenderer(new DBTreeCellRenderer());
        this.sourceTree.addTreeSelectionListener(this.dbTreeListener);
        this.destTree = new JTree();
        DBTreeModel destTreeModel = new DBTreeModel(this.treeRoot, this.sourceTree);
        this.destTree.setModel(destTreeModel);
        this.destTree.setRootVisible(false);
        this.destTree.setShowsRootHandles(true);
        this.destTree.setCellRenderer(new DBTreeCellRenderer());
        this.destTree.addTreeSelectionListener(this.dbTreeListener);
        PanelBuilder pb = new PanelBuilder(new FormLayout("pref:grow,8dlu,pref:grow", "pref,4dlu,fill:pref:grow,4dlu,pref,4dlu,pref"));
        pb.getLayout().addGroupedColumn(1);
        pb.getLayout().addGroupedColumn(3);
        CellConstraints cc = new CellConstraints();
        pb.addLabel(Messages.getString("DataMoverPanel.sourceLabel"), cc.xy(1, 1));
        pb.addLabel(Messages.getString("DataMoverPanel.destinationLabel"), cc.xy(3, 1));
        pb.add((Component)new JScrollPane(this.sourceTree), cc.xy(1, 3));
        pb.add((Component)new JScrollPane(this.destTree), cc.xy(3, 3));
        session.getDataSources().addDatabaseListChangeListener(new DatabaseListChangeListener(){

            public void databaseAdded(DatabaseListChangeEvent e) {
                try {
                    DataMoverPanel.this.setupDBTrees();
                }
                catch (SQLObjectException ex) {
                    SPSUtils.showExceptionDialogNoReport((Component)DataMoverPanel.this.panel, (String)Messages.getString("DataMoverPanel.couldNotFindDB"), (Throwable)ex);
                }
            }

            public void databaseRemoved(DatabaseListChangeEvent e) {
                try {
                    DataMoverPanel.this.setupDBTrees();
                }
                catch (SQLObjectException ex) {
                    SPSUtils.showExceptionDialogNoReport((Component)DataMoverPanel.this.panel, (String)Messages.getString("DataMoverPanel.couldNotFindDB"), (Throwable)ex);
                }
            }
        });
        pb.add((Component)new JButton(new DatabaseConnectionManagerAction(session)), cc.xy(1, 5));
        this.truncateDestinationTableBox = new JCheckBox(Messages.getString("DataMoverPanel.truncateDestinationTableOption"));
        pb.add((Component)this.truncateDestinationTableBox, cc.xy(3, 5));
        pb.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)new JButton(this.okAction), (JButton)new JButton(this.cancelAction)), cc.xyw(1, 7, 3));
        pb.setDefaultDialogBorder();
        this.panel = pb.getPanel();
    }

    private void setupDBTrees() throws SQLObjectException {
        try {
            if (this.treeRoot == null) {
                this.treeRoot = new SQLObjectRoot();
                ArchitectProject treeProject = new ArchitectProject(this.treeRoot);
                treeProject.setSession(this.session);
                this.treeRoot.begin("Setting up database trees in data mover panel.");
            } else {
                this.treeRoot.begin("Setting up database trees in data mover panel.");
                for (int i = this.treeRoot.getChildCount() - 1; i >= 0; --i) {
                    this.treeRoot.removeChild((SPObject)this.treeRoot.getChild(i));
                }
            }
            for (JDBCDataSource ds : this.session.getDataSources().getConnections()) {
                this.treeRoot.addChild((SQLObject)new SQLDatabase(ds));
            }
            this.treeRoot.commit();
        }
        catch (IllegalArgumentException e) {
            this.treeRoot.rollback("Could not set up database trees.");
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            this.treeRoot.rollback("Could not set up database trees.");
            throw new RuntimeException(e);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void doDataMove() throws SQLException, SQLObjectException {
        TreePath[] sourcePaths = this.sourceTree.getSelectionPaths();
        int tableCount = 0;
        int rowCount = 0;
        ArrayList<SQLTable> sourceTables = new ArrayList<SQLTable>();
        for (TreePath sourcePath : sourcePaths) {
            sourceTables.add((SQLTable)sourcePath.getLastPathComponent());
        }
        DepthFirstSearch dfs = new DepthFirstSearch(sourceTables);
        for (SQLTable sourceTable : dfs.getFinishOrder()) {
            int thisCount = this.moveSingleTable(sourceTable);
            if (thisCount == -1) {
                int choice = JOptionPane.showConfirmDialog(this.panel, Messages.getString("DataMoverPanel.continueCopyingRemainingTablesOption"));
                if (choice == 0) continue;
                break;
            }
            ++tableCount;
            rowCount += thisCount;
        }
        JOptionPane.showMessageDialog(this.panel, Messages.getString("DataMoverPanel.dataCopyResults", String.valueOf(tableCount), String.valueOf(rowCount)));
    }

    private int moveSingleTable(SQLTable sourceTable) throws SQLException, SQLObjectException {
        SQLDatabase sourceDB = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sourceTable, SQLDatabase.class);
        TreePath destPath = this.destTree.getSelectionPath();
        SQLObject destObject = (SQLObject)destPath.getLastPathComponent();
        SQLDatabase destDB = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)destObject, SQLDatabase.class);
        String destCatalogName = null;
        String destSchemaName = null;
        String destTableName = sourceTable.getName();
        List ancestorList = SQLObjectUtils.ancestorList((SQLObject)destObject);
        for (SQLObject ancestor : ancestorList) {
            if (ancestor instanceof SQLTable) {
                destTableName = ancestor.getName();
            }
            if (ancestor instanceof SQLCatalog) {
                destCatalogName = ancestor.getName();
            }
            if (!(ancestor instanceof SQLSchema)) continue;
            destSchemaName = ancestor.getName();
        }
        boolean needToCreate = false;
        SQLTable destTable = destDB.getTableByName(destCatalogName, destSchemaName, destTableName);
        if (destTable == null) {
            needToCreate = true;
            destTable = SQLObjectUtils.addSimulatedTable((SQLDatabase)destDB, (String)destCatalogName, (String)destSchemaName, (String)destTableName);
            for (SQLColumn srcCol : sourceTable.getColumns()) {
                destTable.addColumn(new SQLColumn(srcCol));
            }
            for (SQLColumn srcCol : sourceTable.getColumns()) {
                SQLColumn destCol = destTable.getColumnByName(srcCol.getName());
                destTable.getPrimaryKeyIndex().addIndexColumn(destCol);
            }
        }
        Connection sourceCon = null;
        Connection destCon = null;
        try {
            int count;
            sourceCon = sourceDB.getConnection();
            destCon = destDB.getConnection();
            String sourceQuoteString = sourceCon.getMetaData().getIdentifierQuoteString();
            String destQuoteString = destCon.getMetaData().getIdentifierQuoteString();
            String sourceQualifiedName = DDLUtils.toQualifiedName(sourceTable.getCatalogName(), sourceTable.getSchemaName(), sourceTable.getName(), sourceQuoteString, sourceQuoteString);
            String destQualifiedName = DDLUtils.toQualifiedName(destTable.getCatalogName(), destTable.getSchemaName(), destTable.getName(), destQuoteString, destQuoteString);
            if (needToCreate) {
                if (destTable.getColumns().isEmpty()) {
                    int choice = JOptionPane.showOptionDialog(this.panel, Messages.getString("DataMoverPanel.sourceTableHasNoColumns", sourceQualifiedName), "Unsupported Source Table Structure", 2, 2, null, new String[]{"Skip", "Abort"}, "Skip");
                    if (choice == 0) {
                        int n = 0;
                        return n;
                    }
                    int n = -1;
                    return n;
                }
                int choice = JOptionPane.showConfirmDialog(this.panel, Messages.getString("DataMoverPanel.destinationTableDoesNotExist", destQualifiedName));
                if (choice != 0) {
                    int n = -1;
                    return n;
                }
                for (SQLColumn destCol : destTable.getColumns()) {
                    int choice2;
                    if (destCol.getDefaultValue() == null || (choice2 = JOptionPane.showOptionDialog(this.panel, Messages.getString("DataMoverPanel.sourceColumnHasDefault", sourceQualifiedName + "." + destCol.getName(), destCol.getDefaultValue()), "Source Table Structure Question", 2, 2, null, new String[]{"Retain Default", "Change Default To Null"}, "Skip")) != 1) continue;
                    destCol.setDefaultValue(null);
                }
                DDLGenerator ddlg = DDLUtils.createDDLGenerator(destDB.getDataSource());
                ddlg.generateDDLStatements(Collections.singletonList(destTable));
                Statement stmt = null;
                String sql = null;
                try {
                    stmt = destCon.createStatement();
                    for (DDLStatement ddlstmt : ddlg.getDdlStatements()) {
                        sql = ddlstmt.getSQLText();
                        stmt.executeUpdate(sql);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("DDL statement failed: " + sql, ex);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            DataMover mover = new DataMover(destCon, sourceCon);
            mover.setCreatingDestinationTable(false);
            mover.setTruncatingDestinationTable(this.truncateDestinationTableBox.isSelected());
            mover.setDebug(true);
            int n = count = mover.copyTable(destQualifiedName, sourceQualifiedName);
            return n;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Couldn't create DDL Generator", ex);
        }
        finally {
            sourceCon.close();
            destCon.close();
        }
    }

    private boolean isSourceTreeSelectionValid() {
        if (this.sourceTree.isSelectionEmpty()) {
            return false;
        }
        for (TreePath path : this.sourceTree.getSelectionPaths()) {
            if (path.getLastPathComponent() instanceof SQLTable) continue;
            return false;
        }
        return true;
    }

    private boolean isDestTreeSelectionValid() {
        return !this.destTree.isSelectionEmpty();
    }
}

