/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;

final class UDTTDSHeader {
    private int maxLen;
    private String databaseName;
    private String schemaName;
    private String typeName;
    private String assemblyQualifiedName;

    final int getMaxLen() {
        return this.maxLen;
    }

    UDTTDSHeader() {
    }

    UDTTDSHeader(byte[] byArray, int n) throws SQLServerException {
        this.readUDTTDSHeader(byArray, n);
    }

    int readUDTTDSHeader(byte[] byArray, int n) throws SQLServerException {
        int n2 = 0;
        this.maxLen = Util.readShort(byArray, n);
        int n3 = byArray[n + (n2 += 2)] & 0xFF;
        ++n2;
        if (n3 > 0) {
            Util.checkSingleByteLength(n3 * 2);
            this.databaseName = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        n3 = byArray[n + n2] & 0xFF;
        ++n2;
        if (n3 > 0) {
            Util.checkSingleByteLength(n3 * 2);
            this.schemaName = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        n3 = byArray[n + n2] & 0xFF;
        ++n2;
        if (n3 > 0) {
            Util.checkSingleByteLength(n3 * 2);
            this.typeName = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        n3 = Util.readShort(byArray, n + n2);
        n2 += 2;
        if (n3 > 0) {
            Util.checkDoubleByteLength(n3 * 2);
            this.assemblyQualifiedName = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        return n2;
    }

    int writeUDTTDSHeader(byte[] byArray, int n) throws SQLServerException {
        int n2;
        int n3 = 0;
        if (null == this.databaseName) {
            byArray[n + n3] = 0;
            ++n3;
        } else {
            n2 = this.databaseName.length();
            Util.checkSingleByteLength(n2);
            byArray[n + n3] = (byte)n2;
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.databaseName);
        }
        if (null == this.schemaName) {
            byArray[n + n3] = 0;
            ++n3;
        } else {
            n2 = this.schemaName.length();
            Util.checkSingleByteLength(n2);
            byArray[n + n3] = (byte)n2;
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.schemaName);
        }
        if (null == this.typeName) {
            byArray[n + n3] = 0;
            ++n3;
        } else {
            n2 = this.typeName.length();
            Util.checkSingleByteLength(n2);
            byArray[n + n3] = (byte)n2;
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.typeName);
        }
        if (null == this.assemblyQualifiedName) {
            byArray[n + n3] = 0;
            byArray[n + ++n3] = 0;
            ++n3;
        } else {
            n2 = this.assemblyQualifiedName.length();
            Util.checkDoubleByteLength(n2);
            byArray[n + n3] = (byte)(n2 & 0xFF);
            byArray[n + ++n3] = (byte)(n2 >> 8 & 0xFF);
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.assemblyQualifiedName);
        }
        return n3;
    }

    String getDatabaseName() {
        return this.databaseName;
    }

    String getSchemaName() {
        return this.schemaName;
    }

    String getTypeName() {
        return this.typeName;
    }

    String getAssemblyQualifiedName() {
        return this.assemblyQualifiedName;
    }
}

