/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import org.gradle.internal.build.event.types.AbstractOperationResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFailureResult;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

class ClientForwardingBuildOperationListener
implements BuildOperationListener {
    private final ProgressEventConsumer eventConsumer;

    ClientForwardingBuildOperationListener(ProgressEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        this.eventConsumer.started((InternalOperationStartedProgressEvent)new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), this.toBuildOperationDescriptor(buildOperation)));
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent result) {
        this.eventConsumer.finished((InternalOperationFinishedProgressEvent)new DefaultOperationFinishedProgressEvent(result.getEndTime(), this.toBuildOperationDescriptor(buildOperation), ClientForwardingBuildOperationListener.toOperationResult(result)));
    }

    private DefaultOperationDescriptor toBuildOperationDescriptor(BuildOperationDescriptor buildOperation) {
        OperationIdentifier id = buildOperation.getId();
        String name = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        OperationIdentifier parentId = buildOperation.getParentId();
        return new DefaultOperationDescriptor((Object)id, name, displayName, (Object)parentId);
    }

    static AbstractOperationResult toOperationResult(OperationFinishEvent result) {
        Throwable failure = result.getFailure();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (failure != null) {
            return new DefaultFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)));
        }
        return new DefaultSuccessResult(startTime, endTime);
    }
}

