/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public final class ShapeClipper {
    private static final int LEFT = 0;
    private static final int TOP = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;

    private ShapeClipper() {
    }

    public static Path2D.Double clipShape(Shape shape, Rectangle2D clippingRect) {
        Path2D.Double result = new Path2D.Double();
        boolean hasData = false;
        int num = 0;
        double minY = Double.POSITIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        PathIterator pit = shape.getPathIterator(null);
        double[] points = new double[512];
        double[] res = new double[6];
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            if (num > 0 && (type == 4 || type == 0 || pit.isDone())) {
                boolean hasPath = ShapeClipper.addToResult(result, points, num, new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY), clippingRect);
                hasData |= hasPath;
                if (hasPath && type == 4) {
                    result.closePath();
                }
                num = 0;
                minY = Double.POSITIVE_INFINITY;
                minX = Double.POSITIVE_INFINITY;
                maxY = Double.NEGATIVE_INFINITY;
                maxX = Double.NEGATIVE_INFINITY;
            }
            double x = res[0];
            double y = res[1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (type == 1 || type == 0) {
                if (num + 2 >= points.length) {
                    points = Arrays.copyOf(points, points.length * 2);
                }
                points[num++] = x;
                points[num++] = y;
            }
            pit.next();
        }
        if (num > 2) {
            hasData |= ShapeClipper.addToResult(result, points, num, new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY), clippingRect);
        }
        return hasData ? result : null;
    }

    private static boolean addToResult(Path2D.Double result, double[] points, int num, Rectangle2D bbox, Rectangle2D clippingRect) {
        Path2D.Double segment = null;
        segment = clippingRect.contains(bbox) ? ShapeClipper.pointsToPath2D(points, num) : ShapeClipper.clipSinglePathWithSutherlandHodgman(points, num, bbox, clippingRect);
        if (segment != null) {
            result.append(segment, false);
            return true;
        }
        return false;
    }

    private static Path2D.Double pointsToPath2D(double[] points, int num) {
        if (num < 2) {
            return null;
        }
        if (Double.compare(points[0], points[num - 2]) == 0 && Double.compare(points[1], points[num - 1]) == 0) {
            num -= 2;
        }
        if (num < 6) {
            return null;
        }
        Path2D.Double path = new Path2D.Double();
        double lastX = points[0];
        double lastY = points[1];
        path.moveTo(lastX, lastY);
        int numOut = 1;
        for (int i = 2; i < num; i += 2) {
            double x = points[i];
            double y = points[i + 1];
            if (Double.compare(x, lastX) == 0 && Double.compare(y, lastY) == 0) continue;
            path.lineTo(x, y);
            lastX = x;
            lastY = y;
            ++numOut;
        }
        if (numOut < 3) {
            return null;
        }
        return path;
    }

    private static Path2D.Double clipSinglePathWithSutherlandHodgman(double[] points, int num, Rectangle2D bbox, Rectangle2D clippingRect) {
        if (num <= 2 || !bbox.intersects(clippingRect)) {
            return null;
        }
        int countVals = num;
        if (Double.compare(points[0], points[num - 2]) == 0 && Double.compare(points[1], points[num - 1]) == 0) {
            countVals -= 2;
        }
        double[] outputList = points;
        double leftX = clippingRect.getMinX();
        double rightX = clippingRect.getMaxX();
        double lowerY = clippingRect.getMinY();
        double upperY = clippingRect.getMaxY();
        boolean eIsIn = false;
        boolean sIsIn = false;
        for (int side = 0; side <= 3; ++side) {
            boolean skipTestForThisSide;
            if (countVals < 6) {
                return null;
            }
            switch (side) {
                case 0: {
                    skipTestForThisSide = bbox.getMinX() >= leftX;
                    break;
                }
                case 1: {
                    skipTestForThisSide = bbox.getMaxY() < upperY;
                    break;
                }
                case 2: {
                    skipTestForThisSide = bbox.getMaxX() < rightX;
                    break;
                }
                default: {
                    boolean bl = skipTestForThisSide = bbox.getMinY() >= lowerY;
                }
            }
            if (skipTestForThisSide) continue;
            double[] input = outputList;
            outputList = new double[countVals + 16];
            double sx = 0.0;
            double sy = 0.0;
            double px = 0.0;
            double py = 0.0;
            int posIn = countVals - 2;
            int posOut = 0;
            for (int i = 0; i < countVals + 2; i += 2) {
                if (posIn >= countVals) {
                    posIn = 0;
                }
                double ex = input[posIn++];
                double ey = input[posIn++];
                switch (side) {
                    case 0: {
                        eIsIn = ex >= leftX;
                        break;
                    }
                    case 1: {
                        eIsIn = ey < upperY;
                        break;
                    }
                    case 2: {
                        eIsIn = ex < rightX;
                        break;
                    }
                    default: {
                        boolean bl = eIsIn = ey >= lowerY;
                    }
                }
                if (i > 0) {
                    if (eIsIn != sIsIn) {
                        boolean isNotZero = Math.abs(ex - sx) > 1.0E-12;
                        double slope = isNotZero ? (ey - sy) / (ex - sx) : 1.0;
                        switch (side) {
                            case 0: {
                                px = leftX;
                                py = slope * (leftX - sx) + sy;
                                break;
                            }
                            case 2: {
                                px = rightX;
                                py = slope * (rightX - sx) + sy;
                                break;
                            }
                            case 1: {
                                px = isNotZero ? sx + (upperY - sy) / slope : sx;
                                py = upperY;
                                break;
                            }
                            default: {
                                px = isNotZero ? sx + (lowerY - sy) / slope : sx;
                                py = lowerY;
                            }
                        }
                    }
                    int toAdd = 0;
                    if (eIsIn) {
                        if (!sIsIn) {
                            toAdd += 2;
                        }
                        toAdd += 2;
                    } else if (sIsIn) {
                        toAdd += 2;
                    }
                    if (posOut + toAdd >= outputList.length) {
                        outputList = Arrays.copyOf(outputList, outputList.length * 2);
                    }
                    if (eIsIn) {
                        if (!sIsIn) {
                            outputList[posOut++] = px;
                            outputList[posOut++] = py;
                        }
                        outputList[posOut++] = ex;
                        outputList[posOut++] = ey;
                    } else if (sIsIn) {
                        outputList[posOut++] = px;
                        outputList[posOut++] = py;
                    }
                }
                sx = ex;
                sy = ey;
                sIsIn = eIsIn;
            }
            countVals = posOut;
        }
        return ShapeClipper.pointsToPath2D(outputList, countVals);
    }
}

