#ifndef OSMIUM_GEOM_RELATIONS_HPP
#define OSMIUM_GEOM_RELATIONS_HPP

/*

This file is part of Osmium (https://osmcode.org/libosmium).

Copyright 2013-2021 Jochen Topf <jochen@topf.org> and others (see README).

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#include <osmium/osm/box.hpp>
#include <osmium/osm/location.hpp>

namespace osmium {

    namespace geom {

        /**
         * Check whether one geometry contains another.
         */
        inline bool contains(const osmium::Box& lhs, const osmium::Box& rhs) noexcept {
            return ((lhs.bottom_left().x() >= rhs.bottom_left().x()) &&
                    (lhs.top_right().x()   <= rhs.top_right().x())   &&
                    (lhs.bottom_left().y() >= rhs.bottom_left().y()) &&
                    (lhs.top_right().y()   <= rhs.top_right().y()));
        }

        /**
         * Check whether one geometry overlaps another.
         */
        inline bool overlaps(const osmium::Box& lhs, const osmium::Box& rhs) noexcept {
            return ((lhs.bottom_left().x() <= rhs.top_right().x()) &&
                    (lhs.bottom_left().y() <= rhs.top_right().y()) &&
                    (rhs.bottom_left().x() <= lhs.top_right().x()) &&
                    (rhs.bottom_left().y() <= lhs.top_right().y()));
        }

    } // namespace geom

} // namespace osmium

#endif // OSMIUM_GEOM_RELATIONS_HPP
