/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;

public enum UserFieldDataType {
    FT_TEXT(new String[]{"TEXT", "ENTERPRISE_TEXT"}),
    FT_START_DATE(new String[]{"START"}),
    FT_END_DATE(new String[]{"FINISH"}),
    FT_FLOAT_2_DECIMALS(new String[]{"NUMBER", "ENTERPRISE_NUMBER"}),
    FT_INT(new String[]{"NUMBER", "ENTERPRISE_NUMBER"}),
    FT_STATICTYPE(new String[]{"TEXT", "ENTERPRISE_TEXT"}),
    FT_MONEY(new String[]{"COST", "ENTERPRISE_COST"});

    private final String[] m_defaultFieldNames;
    private static final Map<FieldTypeClass, String> SUBJECT_AREA_MAP;

    private UserFieldDataType(String[] stringArray) {
        this.m_defaultFieldNames = stringArray;
    }

    public String[] getDefaultFieldNames() {
        return (String[])this.m_defaultFieldNames.clone();
    }

    public static String inferUserFieldDataType(DataType dataType) {
        switch (dataType) {
            case BINARY: 
            case STRING: 
            case DURATION: {
                return "Text";
            }
            case DATE: {
                return "Start Date";
            }
            case NUMERIC: {
                return "Double";
            }
            case BOOLEAN: 
            case INTEGER: 
            case SHORT: {
                return "Integer";
            }
            case CURRENCY: {
                return "Cost";
            }
        }
        throw new RuntimeException("Unconvertible data type: " + dataType);
    }

    public static String inferUserFieldSubjectArea(FieldType fieldType) {
        String string = SUBJECT_AREA_MAP.get((Object)fieldType.getFieldTypeClass());
        if (string == null) {
            throw new RuntimeException("Unrecognized field type: " + fieldType);
        }
        return string;
    }

    static {
        SUBJECT_AREA_MAP = new HashMap<FieldTypeClass, String>();
        SUBJECT_AREA_MAP.put(FieldTypeClass.TASK, "Activity");
        SUBJECT_AREA_MAP.put(FieldTypeClass.RESOURCE, "Resource");
        SUBJECT_AREA_MAP.put(FieldTypeClass.PROJECT, "Project");
        SUBJECT_AREA_MAP.put(FieldTypeClass.ASSIGNMENT, "Assignment");
        SUBJECT_AREA_MAP.put(FieldTypeClass.CONSTRAINT, "Constraint");
    }
}

