# PyMETAR - a module to fetch and parse METAR reports

**NOTE:** If you're looking for information regarding Python 2 and PyMETAR, see
the end of this document.

The National Oceanic and Atmospheric Administration (NOAA, http://www.noaa.gov/)
provides easy access to the weather reports generated by a large number of
weather stations (mostly at airports) worldwide. Those reports are called METAR
reports and are delivered as plain text files that look like this:

```
Duesseldorf, Germany (EDDL) 51-18N 006-46E 41M
Jul 26, 2002 - 03:50 AM EST / 2002.07.26 0850 UTC
Wind: from the SW (220 degrees) at 9 MPH (8 KT):0
Visibility: 3 mile(s):0
Sky conditions: mostly cloudy
Weather: mist
Temperature: 60 F (16 C)
Dew Point: 57 F (14 C)
Relative Humidity: 87%
Pressure (altimeter): 30.00 in. Hg (1016 hPa)
ob: EDDL 260850Z 22008KT 5000 BR SCT006 BKN012 16/14 Q1016 BECMG BKN015
cycle: 9
```

While this is convenient if you just want to quickly look up the data, there's
some effort involved in parsing all of this into a format that is digestible by
a program. Plus, you have to remember the base URL of the reports and fetch the
file.

This is what this library does. All you have to do is find the station you're
interested in at http://www.aviationweather.gov/metar and feed the 4-letter
station code to the MetarReport class.

On the user end, the library provides a large number of methods to fetch the
parsed information in a plethora of formats. Those functions are described in
the file `librarydoc.txt` which was in turn generated using PyDoc.

PyMETAR uses `urllib2` (and its successors), which in turn makes it easy to honor
the environment variable `http_proxy`. This simplifies use of a proxy
tremendously. Thanks go to Davide Di Blasi for both suggesting and implementing
this. The environment variable is easy to use: just set it to:

```
http://username:password@proxy.yourdomain.com:port 
```

You can also specify a proxy (with the same syntax) as an argument to the
fetching function. This is sometimes easier when using PyMETAR in a web
application environment (such as ZopeWeatherApplet by Jerome Alet). See
`librarydoc.txt` for details on how to accomplish that. 

You can also use IPs instead of hostnames, of course. When in doubt, ask your
proxy admin.

Due to some peculiarities in the METAR format, I can not rule out the
possibility that the library barfs on some less common types of reports. If you
encounter such a report, please save it and the error messages you get as
completely as possible and send them to me at `klausman-pymetar@schwarzvogel.de`
--- Thanks a lot!

Of course you may send all the other bugs you encounter to me, too. As this is a
Python library, chances are that you are Python programmer and can provide a
patch. If you do so, please, by all means use spaces for indentation, four per
level, that makes merging the patch a lot easier.

## Python 2, 3, PyPy, PyPy3 and so on

This version of PyMETAR supports Python 3.x and PyPy3 only. The last version to
have Python2 as its main target was v0.21.

Compatibility with PyPy (2.x), Jython and other interpreters not mentioned
above is unknown.

I maintain a branch (called Python2) on git which is the state of Pymetar as it
was for the last version supporting Python 2. That branch is in maintenance
mode, i.e. it will only receive fixes for security issues or bugs that can be
fixed without too much fuss. That branch will go away in 2020.

[0] http://python-future.org/
