/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.extension.history.HistoryTable;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.view.DeselectableButtonGroup;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTable;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class LogPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LogPanel.class);
    private JScrollPane scrollLog = null;
    private HistoryTable historyReferencesTable = null;
    private JPanel historyPanel = null;
    private JToolBar panelToolbar = null;
    private JButton filterButton = null;
    private JLabel filterStatus = null;
    private ZapToggleButton scopeButton = null;
    private ExtensionHistory extension = null;
    private ZapToggleButton linkWithSitesTreeButton;
    private LinkWithSitesTreeSelectionListener linkWithSitesTreeSelectionListener;
    private DeselectableButtonGroup historyListFiltersButtonGroup;
    private TableExportButton<HistoryReferencesTable> exportButton;
    private final ViewDelegate view;

    @Deprecated
    public LogPanel() {
        this(View.getSingleton());
    }

    public LogPanel(ViewDelegate view) {
        this.view = view;
        this.initialize();
    }

    private void initialize() {
        this.historyListFiltersButtonGroup = new DeselectableButtonGroup();
        this.setLayout(new BorderLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(600, 200);
        }
        this.add((Component)this.getHistoryPanel(), "Center");
        this.setDefaultAccelerator(this.view.getMenuShortcutKeyStroke(72, 64, false));
        this.setMnemonic(Constant.messages.getChar("history.panel.mnemonic"));
    }

    @Override
    public void tabSelected() {
        this.getHistoryReferenceTable().requestFocusInWindow();
    }

    void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    private JScrollPane getScrollLog() {
        if (this.scrollLog == null) {
            this.scrollLog = new JScrollPane();
            this.scrollLog.setViewportView((Component)((Object)this.getHistoryReferenceTable()));
            this.scrollLog.setName("scrollLog");
        }
        return this.scrollLog;
    }

    private JPanel getHistoryPanel() {
        if (this.historyPanel == null) {
            this.historyPanel = new JPanel();
            this.historyPanel.setLayout(new GridBagLayout());
            this.historyPanel.setName("History Panel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.historyPanel.add((Component)this.getPanelToolbar(), gridBagConstraints1);
            this.historyPanel.add((Component)this.getScrollLog(), gridBagConstraints2);
        }
        return this.historyPanel;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("History Toolbar");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.anchor = 17;
            this.panelToolbar.add((Component)this.getScopeButton(), gbc);
            ++gbc.gridx;
            this.panelToolbar.add((Component)this.getLinkWithSitesTreeButton(), gbc);
            ++gbc.gridx;
            this.panelToolbar.add((Component)this.getFilterButton(), gbc);
            this.filterStatus = new JLabel(Constant.messages.getString("history.filter.label.filter") + " " + Constant.messages.getString("history.filter.label.off"));
            ++gbc.gridx;
            this.panelToolbar.add((Component)this.filterStatus, gbc);
            ++gbc.gridx;
            this.panelToolbar.add(this.getExportButton(), gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 13;
            gbc.fill = 2;
            this.panelToolbar.add((Component)new JLabel(), gbc);
        }
        return this.panelToolbar;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/054.png")));
            this.filterButton.setToolTipText(Constant.messages.getString("history.filter.button.filter"));
            DisplayUtils.scaleIcon(this.filterButton);
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.extension.showFilterPlusDialog();
                }
            });
        }
        return this.filterButton;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.extension.setShowJustInScope(LogPanel.this.scopeButton.isSelected());
                }
            });
            this.historyListFiltersButtonGroup.add(this.scopeButton);
        }
        return this.scopeButton;
    }

    private JToggleButton getLinkWithSitesTreeButton() {
        if (this.linkWithSitesTreeButton == null) {
            this.linkWithSitesTreeButton = new ZapToggleButton();
            this.linkWithSitesTreeButton.setIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/earth-grey.png")));
            this.linkWithSitesTreeButton.setToolTipText(Constant.messages.getString("history.linkWithSitesSelection.unselected.button.tooltip"));
            this.linkWithSitesTreeButton.setSelectedIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/094.png")));
            this.linkWithSitesTreeButton.setSelectedToolTipText(Constant.messages.getString("history.linkWithSitesSelection.selected.button.tooltip"));
            DisplayUtils.scaleIcon(this.linkWithSitesTreeButton);
            this.linkWithSitesTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.setLinkWithSitesTreeSelection(LogPanel.this.linkWithSitesTreeButton.isSelected());
                }
            });
            this.historyListFiltersButtonGroup.add(this.linkWithSitesTreeButton);
        }
        return this.linkWithSitesTreeButton;
    }

    private TableExportButton<HistoryReferencesTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<HistoryReferencesTable>(this.getHistoryReferenceTable());
        }
        return this.exportButton;
    }

    public void setLinkWithSitesTreeSelection(boolean enabled) {
        this.linkWithSitesTreeButton.setSelected(enabled);
        JTree sitesTree = this.view.getSiteTreePanel().getTreeSite();
        String baseUri = null;
        if (enabled) {
            TreePath selectionPath = sitesTree.getSelectionPath();
            if (selectionPath != null) {
                baseUri = LogPanel.getLinkWithSitesTreeBaseUri((SiteNode)selectionPath.getLastPathComponent());
            }
            sitesTree.addTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        } else {
            sitesTree.removeTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        }
        this.extension.setLinkWithSitesTree(enabled, baseUri);
    }

    private static String getLinkWithSitesTreeBaseUri(SiteNode siteNode) {
        HistoryReference historyReference;
        if (!siteNode.isRoot() && (historyReference = siteNode.getHistoryReference()) != null) {
            return historyReference.getURI().toString();
        }
        return null;
    }

    protected HistoryReferencesTable getHistoryReferenceTable() {
        if (this.historyReferencesTable == null) {
            this.historyReferencesTable = new HistoryTable();
            this.historyReferencesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                        LogPanel.this.view.getRequestPanel().setTabFocus();
                        return;
                    }
                }
            });
            String deleteHrefKey = "zap.delete.href";
            this.historyReferencesTable.getInputMap().put(this.view.getDefaultDeleteKeyStroke(), deleteHrefKey);
            this.historyReferencesTable.getActionMap().put(deleteHrefKey, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.extension.purgeHistory(LogPanel.this.historyReferencesTable.getSelectedHistoryReferences());
                }
            });
        }
        return this.historyReferencesTable;
    }

    protected void display(HistoryReference historyRef) {
        this.getHistoryReferenceTable().selectHistoryReference(historyRef.getHistoryId());
    }

    @Deprecated
    public void clearDisplayQueue() {
    }

    @Deprecated
    public void setDisplayPanel(HttpPanel requestPanel, HttpPanel responsePanel) {
    }

    public void setFilterStatus(HistoryFilter filter) {
        this.filterStatus.setText(filter.toShortString());
        this.filterStatus.setToolTipText(filter.toLongString());
    }

    private LinkWithSitesTreeSelectionListener getLinkWithSitesTreeSelectionListener() {
        if (this.linkWithSitesTreeSelectionListener == null) {
            this.linkWithSitesTreeSelectionListener = new LinkWithSitesTreeSelectionListener();
        }
        return this.linkWithSitesTreeSelectionListener;
    }

    public HistoryReference getSelectedHistoryReference() {
        return this.getHistoryReferenceTable().getSelectedHistoryReference();
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.getHistoryReferenceTable().getSelectedHistoryReferences();
    }

    public void setModel(HistoryReferencesTableModel<DefaultHistoryReferencesTableEntry> historyTableModel) {
        this.getHistoryReferenceTable().setModel(historyTableModel);
    }

    void setDisplaySelectedMessage(boolean display) {
        this.historyReferencesTable.setDisplaySelectedMessage(display);
    }

    private class LinkWithSitesTreeSelectionListener
    implements TreeSelectionListener {
        private LinkWithSitesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            LogPanel.this.extension.updateLinkWithSitesTreeBaseUri(LogPanel.getLinkWithSitesTreeBaseUri((SiteNode)e.getPath().getLastPathComponent()));
        }
    }
}

