/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.hex;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.AbstractByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelListener;
import org.zaproxy.zap.extension.httppanel.view.hex.HttpPanelHexModel;
import org.zaproxy.zap.utils.DisplayUtils;

public class HttpPanelHexView
implements HttpPanelView,
HttpPanelViewModelListener {
    public static final String NAME = "HttpPanelHexView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.hex.name");
    private HttpPanelHexModel httpPanelHexModel = null;
    private JTable hexTableBody = null;
    private JScrollPane scrollHexTableBody = null;
    private boolean isEditable = false;
    private AbstractByteHttpPanelViewModel model;

    public HttpPanelHexView(AbstractByteHttpPanelViewModel model, boolean isEditable) {
        this.model = model;
        this.getHttpPanelHexModel().setEditable(isEditable);
        this.model.addHttpPanelViewModelListener(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "";
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public JScrollPane getPane() {
        if (this.scrollHexTableBody == null) {
            this.scrollHexTableBody = new JScrollPane();
            this.scrollHexTableBody.setName(CAPTION_NAME);
            this.scrollHexTableBody.setViewportView(this.getHexTableBody());
        }
        return this.scrollHexTableBody;
    }

    private JTable getHexTableBody() {
        if (this.hexTableBody == null) {
            int i;
            this.hexTableBody = new JTable();
            this.hexTableBody.setName("");
            this.hexTableBody.setModel(this.getHttpPanelHexModel());
            this.hexTableBody.setGridColor(Color.gray);
            this.hexTableBody.setIntercellSpacing(new Dimension(1, 1));
            this.hexTableBody.setRowHeight(DisplayUtils.getScaledSize(18));
            this.hexTableBody.setAutoResizeMode(0);
            this.hexTableBody.getColumnModel().getColumn(0).setPreferredWidth(100);
            for (i = 1; i <= 17; ++i) {
                this.hexTableBody.getColumnModel().getColumn(i).setPreferredWidth(30);
            }
            for (i = 17; i <= this.hexTableBody.getColumnModel().getColumnCount() - 1; ++i) {
                this.hexTableBody.getColumnModel().getColumn(i).setPreferredWidth(25);
            }
            this.hexTableBody.setCellSelectionEnabled(true);
            this.hexTableBody.setSelectionMode(0);
        }
        return this.hexTableBody;
    }

    private HttpPanelHexModel getHttpPanelHexModel() {
        if (this.httpPanelHexModel == null) {
            this.httpPanelHexModel = new HttpPanelHexModel();
        }
        return this.httpPanelHexModel;
    }

    @Override
    public boolean isEnabled(Message aMessage) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return this.getHttpPanelHexModel().hasChanged();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.getHttpPanelHexModel().setEditable(editable);
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent e) {
        this.getHttpPanelHexModel().setData(this.model.getData());
    }

    @Override
    public void save() {
        this.model.setData(this.getHttpPanelHexModel().getData());
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.hexTableBody.requestFocusInWindow();
        }
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }
}

