# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 13.0.0.  Any changes made here will be lost!

sub TODO_FAILING_BREAKS { 0 }

use strict;
use warnings;

use feature 'signatures';

no warnings 'experimental::signatures';
no warnings 'experimental::uniprop_wildcards';

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($pass, @msg) {
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($expected, $ord, $regex, $warning_type='') {
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parentheses in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($regex) {
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}\p{WB=ZWJ}]/';
if (! defined $WB_Extend_or_Format_re) {
    $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';
}

sub _test_break($template, $break_type) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $line   = (caller 1)[2];   # Line number
    my $comment = "";

    if ($template =~ / ( .*? ) \s* \# (.*) /x) {
        $template = $1;
        $comment = $2;

        # Replace leading spaces with a single one.
        $comment =~ s/ ^ \s* / # /x;
    }

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(&POSIX::LC_CTYPE, $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched_text;
            my $matched = $string =~ qr/$pattern/;
            if ($matched) {
                $matched_text = "matched";
            }
            else {
                $matched_text = "failed to match";
                print "not ";

                if (TODO_FAILING_BREAKS) {
                    $comment = " # $comment" unless $comment =~ / ^ \s* \# /x;
                    $comment =~ s/#/# TODO/;
                }
            }
            print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$pattern/$display_upgrade; line $line $display_locale$comment\n";

            # Only print the comment on the first use of this line
            $comment = "";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched_text = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$B_pattern/$display_upgrade; line $line $display_locale";
                print " # TODO" if TODO_FAILING_BREAKS && ! $matched;
                print "\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests -";
                print " # TODO" if TODO_FAILING_BREAKS;
                print " In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line";
            print " # TODO" if TODO_FAILING_BREAKS;
            print "\n";
        }
    }

    return;
}

sub Test_GCB($t) {
    _test_break($t, 'gcb');
}

sub Test_LB($t) {
    _test_break($t, 'lb');
}

sub Test_SB($t) {
    _test_break($t, 'sb');
}

sub Test_WB($t) {
    _test_break($t, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

if (!$::TESTCHUNK or $::TESTCHUNK == 1) {
    Error('\p{Script=InGreek}');    # Bug #69018
    Test_GCB("1100 $nobreak 1161");  # Bug #70940
    Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
    Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
    Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
    Error('\p{InKana}');    # 'Kana' is not a block so InKana shouldn't compile
    
    # Make sure this gets tested; it was not part of the official test suite at
    # the time this was added.  Note that this is as it would appear in the
    # official suite, and gets modified to check for the perl tailoring by
    # Test_WB()
    Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
    Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
    Expect(1, ord(" "), '\p{gc=:(?aa)s:}', "");     # /aa is valid
    Expect(1, ord(" "), '\p{gc=:(?-s)s:}', "");     # /-s is valid
    ;
    Error('\p{_perllb}');
    Error('\P{_perllb}');
    Error('\p{_perlscx}');
    Error('\P{_perlscx}');
    Error('\p{age}');
    Error('\P{age}');
    Error('\p{Age=_V1_1/a/}');
    Error('\P{Age=_V1_1/a/}');
    Expect(1, 65533, '\p{Age=:\AV1_1\z:}', "");;
    Expect(0, 65536, '\p{Age=:\AV1_1\z:}', "");;
    Expect(1, 65533, '\p{Age=v11}', "");
    Expect(0, 65533, '\p{^Age=v11}', "");
    Expect(0, 65533, '\P{Age=v11}', "");
    Expect(1, 65533, '\P{^Age=v11}', "");
    Expect(0, 65536, '\p{Age=v11}', "");
    Expect(1, 65536, '\p{^Age=v11}', "");
    Expect(1, 65536, '\P{Age=v11}', "");
    Expect(0, 65536, '\P{^Age=v11}', "");
    Expect(1, 65533, '\p{Age=:\Av11\z:}', "");;
    Expect(0, 65536, '\p{Age=:\Av11\z:}', "");;
    Expect(1, 65533, '\p{Age=	v1_1}', "");
    Expect(0, 65533, '\p{^Age=	v1_1}', "");
    Expect(0, 65533, '\P{Age=	v1_1}', "");
    Expect(1, 65533, '\P{^Age=	v1_1}', "");
    Expect(0, 65536, '\p{Age=	v1_1}', "");
    Expect(1, 65536, '\p{^Age=	v1_1}', "");
    Expect(1, 65536, '\P{Age=	v1_1}', "");
    Expect(0, 65536, '\P{^Age=	v1_1}', "");
    Error('\p{Is_Age=:=	 000000001.1}');
    Error('\P{Is_Age=:=	 000000001.1}');
    Expect(1, 65533, '\p{Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\p{^Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\P{Is_Age=+0_1.1}', "");
    Expect(1, 65533, '\P{^Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\p{Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\p{^Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\P{Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\P{^Is_Age=+0_1.1}', "");
    Error('\p{Age=		v10_0:=}');
    Error('\P{Age=		v10_0:=}');
    Expect(1, 191456, '\p{Age=:\AV10_0\z:}', "");;
    Expect(0, 191457, '\p{Age=:\AV10_0\z:}', "");;
    Expect(1, 191456, '\p{Age=v100}', "");
    Expect(0, 191456, '\p{^Age=v100}', "");
    Expect(0, 191456, '\P{Age=v100}', "");
    Expect(1, 191456, '\P{^Age=v100}', "");
    Expect(0, 191457, '\p{Age=v100}', "");
    Expect(1, 191457, '\p{^Age=v100}', "");
    Expect(1, 191457, '\P{Age=v100}', "");
    Expect(0, 191457, '\P{^Age=v100}', "");
    Expect(1, 191456, '\p{Age=:\Av100\z:}', "");;
    Expect(0, 191457, '\p{Age=:\Av100\z:}', "");;
    Expect(1, 191456, '\p{Age=	-V10_0}', "");
    Expect(0, 191456, '\p{^Age=	-V10_0}', "");
    Expect(0, 191456, '\P{Age=	-V10_0}', "");
    Expect(1, 191456, '\P{^Age=	-V10_0}', "");
    Expect(0, 191457, '\p{Age=	-V10_0}', "");
    Expect(1, 191457, '\p{^Age=	-V10_0}', "");
    Expect(1, 191457, '\P{Age=	-V10_0}', "");
    Expect(0, 191457, '\P{^Age=	-V10_0}', "");
    Error('\p{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Error('\P{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Expect(1, 191456, '\p{Is_Age=0000010.0}', "");
    Expect(0, 191456, '\p{^Is_Age=0000010.0}', "");
    Expect(0, 191456, '\P{Is_Age=0000010.0}', "");
    Expect(1, 191456, '\P{^Is_Age=0000010.0}', "");
    Expect(0, 191457, '\p{Is_Age=0000010.0}', "");
    Expect(1, 191457, '\p{^Is_Age=0000010.0}', "");
    Expect(1, 191457, '\P{Is_Age=0000010.0}', "");
    Expect(0, 191457, '\P{^Is_Age=0000010.0}', "");
    Error('\p{Age=/a/V11_0}');
    Error('\P{Age=/a/V11_0}');
    Expect(1, 129645, '\p{Age=:\AV11_0\z:}', "");;
    Expect(0, 129646, '\p{Age=:\AV11_0\z:}', "");;
    Expect(1, 129645, '\p{Age=v110}', "");
    Expect(0, 129645, '\p{^Age=v110}', "");
    Expect(0, 129645, '\P{Age=v110}', "");
    Expect(1, 129645, '\P{^Age=v110}', "");
    Expect(0, 129646, '\p{Age=v110}', "");
    Expect(1, 129646, '\p{^Age=v110}', "");
    Expect(1, 129646, '\P{Age=v110}', "");
    Expect(0, 129646, '\P{^Age=v110}', "");
    Expect(1, 129645, '\p{Age=:\Av110\z:}', "");;
    Expect(0, 129646, '\p{Age=:\Av110\z:}', "");;
    Expect(1, 129645, '\p{Age= _V11_0}', "");
    Expect(0, 129645, '\p{^Age= _V11_0}', "");
    Expect(0, 129645, '\P{Age= _V11_0}', "");
    Expect(1, 129645, '\P{^Age= _V11_0}', "");
    Expect(0, 129646, '\p{Age= _V11_0}', "");
    Expect(1, 129646, '\p{^Age= _V11_0}', "");
    Expect(1, 129646, '\P{Age= _V11_0}', "");
    Expect(0, 129646, '\P{^Age= _V11_0}', "");
    Error('\p{Is_Age=_ +0000011.0:=}');
    Error('\P{Is_Age=_ +0000011.0:=}');
    Expect(1, 129645, '\p{Is_Age=1_1.0}', "");
    Expect(0, 129645, '\p{^Is_Age=1_1.0}', "");
    Expect(0, 129645, '\P{Is_Age=1_1.0}', "");
    Expect(1, 129645, '\P{^Is_Age=1_1.0}', "");
    Expect(0, 129646, '\p{Is_Age=1_1.0}', "");
    Expect(1, 129646, '\p{^Is_Age=1_1.0}', "");
    Expect(1, 129646, '\P{Is_Age=1_1.0}', "");
    Expect(0, 129646, '\P{^Is_Age=1_1.0}', "");
    Error('\p{Age= V12_0:=}');
    Error('\P{Age= V12_0:=}');
    Expect(1, 129685, '\p{Age=:\AV12_0\z:}', "");;
    Expect(0, 129686, '\p{Age=:\AV12_0\z:}', "");;
    Expect(1, 129685, '\p{Age=v120}', "");
    Expect(0, 129685, '\p{^Age=v120}', "");
    Expect(0, 129685, '\P{Age=v120}', "");
    Expect(1, 129685, '\P{^Age=v120}', "");
    Expect(0, 129686, '\p{Age=v120}', "");
    Expect(1, 129686, '\p{^Age=v120}', "");
    Expect(1, 129686, '\P{Age=v120}', "");
    Expect(0, 129686, '\P{^Age=v120}', "");
    Expect(1, 129685, '\p{Age=:\Av120\z:}', "");;
    Expect(0, 129686, '\p{Age=:\Av120\z:}', "");;
    Expect(1, 129685, '\p{Age= _V12_0}', "");
    Expect(0, 129685, '\p{^Age= _V12_0}', "");
    Expect(0, 129685, '\P{Age= _V12_0}', "");
    Expect(1, 129685, '\P{^Age= _V12_0}', "");
    Expect(0, 129686, '\p{Age= _V12_0}', "");
    Expect(1, 129686, '\p{^Age= _V12_0}', "");
    Expect(1, 129686, '\P{Age= _V12_0}', "");
    Expect(0, 129686, '\P{^Age= _V12_0}', "");
    Error('\p{Is_Age=/a/		0000000012.0}');
    Error('\P{Is_Age=/a/		0000000012.0}');
    Expect(1, 129685, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129685, '\P{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\P{^Is_Age=00_00_01_2.0}', "");
    Error('\p{Age=_V12_1/a/}');
    Error('\P{Age=_V12_1/a/}');
    Expect(1, 13055, '\p{Age=:\AV12_1\z:}', "");;
    Expect(0, 13056, '\p{Age=:\AV12_1\z:}', "");;
    Expect(1, 13055, '\p{Age=v121}', "");
    Expect(0, 13055, '\p{^Age=v121}', "");
    Expect(0, 13055, '\P{Age=v121}', "");
    Expect(1, 13055, '\P{^Age=v121}', "");
    Expect(0, 13056, '\p{Age=v121}', "");
    Expect(1, 13056, '\p{^Age=v121}', "");
    Expect(1, 13056, '\P{Age=v121}', "");
    Expect(0, 13056, '\P{^Age=v121}', "");
    Expect(1, 13055, '\p{Age=:\Av121\z:}', "");;
    Expect(0, 13056, '\p{Age=:\Av121\z:}', "");;
    Expect(1, 13055, '\p{Age= 	V12_1}', "");
    Expect(0, 13055, '\p{^Age= 	V12_1}', "");
    Expect(0, 13055, '\P{Age= 	V12_1}', "");
    Expect(1, 13055, '\P{^Age= 	V12_1}', "");
    Expect(0, 13056, '\p{Age= 	V12_1}', "");
    Expect(1, 13056, '\p{^Age= 	V12_1}', "");
    Expect(1, 13056, '\P{Age= 	V12_1}', "");
    Expect(0, 13056, '\P{^Age= 	V12_1}', "");
    Error('\p{Is_Age=:=-+012.1}');
    Error('\P{Is_Age=:=-+012.1}');
    Expect(1, 13055, '\p{Is_Age=000000012.1}', "");
    Expect(0, 13055, '\p{^Is_Age=000000012.1}', "");
    Expect(0, 13055, '\P{Is_Age=000000012.1}', "");
    Expect(1, 13055, '\P{^Is_Age=000000012.1}', "");
    Expect(0, 13056, '\p{Is_Age=000000012.1}', "");
    Expect(1, 13056, '\p{^Is_Age=000000012.1}', "");
    Expect(1, 13056, '\P{Is_Age=000000012.1}', "");
    Expect(0, 13056, '\P{^Is_Age=000000012.1}', "");
    Error('\p{Age=--V13_0/a/}');
    Error('\P{Age=--V13_0/a/}');
    Expect(1, 201546, '\p{Age=:\AV13_0\z:}', "");;
    Expect(0, 201547, '\p{Age=:\AV13_0\z:}', "");;
    Expect(1, 201546, '\p{Age=v130}', "");
    Expect(0, 201546, '\p{^Age=v130}', "");
    Expect(0, 201546, '\P{Age=v130}', "");
    Expect(1, 201546, '\P{^Age=v130}', "");
    Expect(0, 201547, '\p{Age=v130}', "");
    Expect(1, 201547, '\p{^Age=v130}', "");
    Expect(1, 201547, '\P{Age=v130}', "");
    Expect(0, 201547, '\P{^Age=v130}', "");
    Expect(1, 201546, '\p{Age=:\Av130\z:}', "");;
    Expect(0, 201547, '\p{Age=:\Av130\z:}', "");;
    Expect(1, 201546, '\p{Age= V13_0}', "");
    Expect(0, 201546, '\p{^Age= V13_0}', "");
    Expect(0, 201546, '\P{Age= V13_0}', "");
    Expect(1, 201546, '\P{^Age= V13_0}', "");
    Expect(0, 201547, '\p{Age= V13_0}', "");
    Expect(1, 201547, '\p{^Age= V13_0}', "");
    Expect(1, 201547, '\P{Age= V13_0}', "");
    Expect(0, 201547, '\P{^Age= V13_0}', "");
    Error('\p{Is_Age=	01_3.0/a/}');
    Error('\P{Is_Age=	01_3.0/a/}');
    Expect(1, 201546, '\p{Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\p{^Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\P{Is_Age=+00000013.0}', "");
    Expect(1, 201546, '\P{^Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\p{Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\p{^Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\P{Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\P{^Is_Age=+00000013.0}', "");
    Error('\p{Age=	V2_0/a/}');
    Error('\P{Age=	V2_0/a/}');
    Expect(1, 983040, '\p{Age=:\AV2_0\z:}', "");;
    Expect(0, 983037, '\p{Age=:\AV2_0\z:}', "");;
    Expect(1, 983040, '\p{Age=v20}', "");
    Expect(0, 983040, '\p{^Age=v20}', "");
    Expect(0, 983040, '\P{Age=v20}', "");
    Expect(1, 983040, '\P{^Age=v20}', "");
    Expect(0, 983037, '\p{Age=v20}', "");
    Expect(1, 983037, '\p{^Age=v20}', "");
    Expect(1, 983037, '\P{Age=v20}', "");
    Expect(0, 983037, '\P{^Age=v20}', "");
    Expect(1, 983040, '\p{Age=:\Av20\z:}', "");;
    Expect(0, 983037, '\p{Age=:\Av20\z:}', "");;
    Expect(1, 983040, '\p{Age=  V2_0}', "");
    Expect(0, 983040, '\p{^Age=  V2_0}', "");
    Expect(0, 983040, '\P{Age=  V2_0}', "");
    Expect(1, 983040, '\P{^Age=  V2_0}', "");
    Expect(0, 983037, '\p{Age=  V2_0}', "");
    Expect(1, 983037, '\p{^Age=  V2_0}', "");
    Expect(1, 983037, '\P{Age=  V2_0}', "");
    Expect(0, 983037, '\P{^Age=  V2_0}', "");
    Error('\p{Is_Age=:=	-+0000002.0}');
    Error('\P{Is_Age=:=	-+0000002.0}');
    Expect(1, 983040, '\p{Is_Age=00_00_00_2.0}', "");
    Expect(0, 983040, '\p{^Is_Age=00_00_00_2.0}', "");
    Expect(0, 983040, '\P{Is_Age=00_00_00_2.0}', "");
    Expect(1, 983040, '\P{^Is_Age=00_00_00_2.0}', "");
    Expect(0, 983037, '\p{Is_Age=00_00_00_2.0}', "");
    Expect(1, 983037, '\p{^Is_Age=00_00_00_2.0}', "");
    Expect(1, 983037, '\P{Is_Age=00_00_00_2.0}', "");
    Expect(0, 983037, '\P{^Is_Age=00_00_00_2.0}', "");
    Error('\p{Age= :=V2_1}');
    Error('\P{Age= :=V2_1}');
    Expect(1, 65532, '\p{Age=:\AV2_1\z:}', "");;
    Expect(0, 65533, '\p{Age=:\AV2_1\z:}', "");;
    Expect(1, 65532, '\p{Age=v21}', "");
    Expect(0, 65532, '\p{^Age=v21}', "");
    Expect(0, 65532, '\P{Age=v21}', "");
    Expect(1, 65532, '\P{^Age=v21}', "");
    Expect(0, 65533, '\p{Age=v21}', "");
    Expect(1, 65533, '\p{^Age=v21}', "");
    Expect(1, 65533, '\P{Age=v21}', "");
    Expect(0, 65533, '\P{^Age=v21}', "");
    Expect(1, 65532, '\p{Age=:\Av21\z:}', "");;
    Expect(0, 65533, '\p{Age=:\Av21\z:}', "");;
    Expect(1, 65532, '\p{Age=V2_1}', "");
    Expect(0, 65532, '\p{^Age=V2_1}', "");
    Expect(0, 65532, '\P{Age=V2_1}', "");
    Expect(1, 65532, '\P{^Age=V2_1}', "");
    Expect(0, 65533, '\p{Age=V2_1}', "");
    Expect(1, 65533, '\p{^Age=V2_1}', "");
    Expect(1, 65533, '\P{Age=V2_1}', "");
    Expect(0, 65533, '\P{^Age=V2_1}', "");
    Error('\p{Is_Age=/a/ -+0000002.1}');
    Error('\P{Is_Age=/a/ -+0000002.1}');
    Expect(1, 65532, '\p{Is_Age=2.1}', "");
    Expect(0, 65532, '\p{^Is_Age=2.1}', "");
    Expect(0, 65532, '\P{Is_Age=2.1}', "");
    Expect(1, 65532, '\P{^Is_Age=2.1}', "");
    Expect(0, 65533, '\p{Is_Age=2.1}', "");
    Expect(1, 65533, '\p{^Is_Age=2.1}', "");
    Expect(1, 65533, '\P{Is_Age=2.1}', "");
    Expect(0, 65533, '\P{^Is_Age=2.1}', "");
    Error('\p{Age: := _V3_0}');
    Error('\P{Age: := _V3_0}');
    Expect(1, 65531, '\p{Age=:\AV3_0\z:}', "");;
    Expect(0, 65532, '\p{Age=:\AV3_0\z:}', "");;
    Expect(1, 65531, '\p{Age=v30}', "");
    Expect(0, 65531, '\p{^Age=v30}', "");
    Expect(0, 65531, '\P{Age=v30}', "");
    Expect(1, 65531, '\P{^Age=v30}', "");
    Expect(0, 65532, '\p{Age=v30}', "");
    Expect(1, 65532, '\p{^Age=v30}', "");
    Expect(1, 65532, '\P{Age=v30}', "");
    Expect(0, 65532, '\P{^Age=v30}', "");
    Expect(1, 65531, '\p{Age=:\Av30\z:}', "");;
    Expect(0, 65532, '\p{Age=:\Av30\z:}', "");;
    Expect(1, 65531, '\p{Age=	_V3_0}', "");
    Expect(0, 65531, '\p{^Age=	_V3_0}', "");
    Expect(0, 65531, '\P{Age=	_V3_0}', "");
    Expect(1, 65531, '\P{^Age=	_V3_0}', "");
    Expect(0, 65532, '\p{Age=	_V3_0}', "");
    Expect(1, 65532, '\p{^Age=	_V3_0}', "");
    Expect(1, 65532, '\P{Age=	_V3_0}', "");
    Expect(0, 65532, '\P{^Age=	_V3_0}', "");
    Error('\p{Is_Age=:=  003.0}');
    Error('\P{Is_Age=:=  003.0}');
    Expect(1, 65531, '\p{Is_Age=+003.0}', "");
    Expect(0, 65531, '\p{^Is_Age=+003.0}', "");
    Expect(0, 65531, '\P{Is_Age=+003.0}', "");
    Expect(1, 65531, '\P{^Is_Age=+003.0}', "");
    Expect(0, 65532, '\p{Is_Age=+003.0}', "");
    Expect(1, 65532, '\p{^Is_Age=+003.0}', "");
    Expect(1, 65532, '\P{Is_Age=+003.0}', "");
    Expect(0, 65532, '\P{^Is_Age=+003.0}', "");
    Error('\p{Age=-/a/v3_1}');
    Error('\P{Age=-/a/v3_1}');
    Expect(1, 917631, '\p{Age=:\AV3_1\z:}', "");;
    Expect(0, 917632, '\p{Age=:\AV3_1\z:}', "");;
    Expect(1, 917631, '\p{Age=v31}', "");
    Expect(0, 917631, '\p{^Age=v31}', "");
    Expect(0, 917631, '\P{Age=v31}', "");
    Expect(1, 917631, '\P{^Age=v31}', "");
    Expect(0, 917632, '\p{Age=v31}', "");
    Expect(1, 917632, '\p{^Age=v31}', "");
    Expect(1, 917632, '\P{Age=v31}', "");
    Expect(0, 917632, '\P{^Age=v31}', "");
    Expect(1, 917631, '\p{Age=:\Av31\z:}', "");;
    Expect(0, 917632, '\p{Age=:\Av31\z:}', "");;
    Expect(1, 917631, '\p{Age=	V3_1}', "");
    Expect(0, 917631, '\p{^Age=	V3_1}', "");
    Expect(0, 917631, '\P{Age=	V3_1}', "");
    Expect(1, 917631, '\P{^Age=	V3_1}', "");
    Expect(0, 917632, '\p{Age=	V3_1}', "");
    Expect(1, 917632, '\p{^Age=	V3_1}', "");
    Expect(1, 917632, '\P{Age=	V3_1}', "");
    Expect(0, 917632, '\P{^Age=	V3_1}', "");
    Error('\p{Is_Age=:= 3.1}');
    Error('\P{Is_Age=:= 3.1}');
    Expect(1, 917631, '\p{Is_Age=3.1}', "");
    Expect(0, 917631, '\p{^Is_Age=3.1}', "");
    Expect(0, 917631, '\P{Is_Age=3.1}', "");
    Expect(1, 917631, '\P{^Is_Age=3.1}', "");
    Expect(0, 917632, '\p{Is_Age=3.1}', "");
    Expect(1, 917632, '\p{^Is_Age=3.1}', "");
    Expect(1, 917632, '\P{Is_Age=3.1}', "");
    Expect(0, 917632, '\P{^Is_Age=3.1}', "");
    Error('\p{Age=-/a/V3_2}');
    Error('\P{Age=-/a/V3_2}');
    Expect(1, 65376, '\p{Age=:\AV3_2\z:}', "");;
    Expect(0, 65377, '\p{Age=:\AV3_2\z:}', "");;
    Expect(1, 65376, '\p{Age=v32}', "");
    Expect(0, 65376, '\p{^Age=v32}', "");
    Expect(0, 65376, '\P{Age=v32}', "");
    Expect(1, 65376, '\P{^Age=v32}', "");
    Expect(0, 65377, '\p{Age=v32}', "");
    Expect(1, 65377, '\p{^Age=v32}', "");
    Expect(1, 65377, '\P{Age=v32}', "");
    Expect(0, 65377, '\P{^Age=v32}', "");
    Expect(1, 65376, '\p{Age=:\Av32\z:}', "");;
    Expect(0, 65377, '\p{Age=:\Av32\z:}', "");;
    Expect(1, 65376, '\p{Age=		V3_2}', "");
    Expect(0, 65376, '\p{^Age=		V3_2}', "");
    Expect(0, 65376, '\P{Age=		V3_2}', "");
    Expect(1, 65376, '\P{^Age=		V3_2}', "");
    Expect(0, 65377, '\p{Age=		V3_2}', "");
    Expect(1, 65377, '\p{^Age=		V3_2}', "");
    Expect(1, 65377, '\P{Age=		V3_2}', "");
    Expect(0, 65377, '\P{^Age=		V3_2}', "");
    Error('\p{Is_Age=:=- 0003.2}');
    Error('\P{Is_Age=:=- 0003.2}');
    Expect(1, 65376, '\p{Is_Age=+000003.2}', "");
    Expect(0, 65376, '\p{^Is_Age=+000003.2}', "");
    Expect(0, 65376, '\P{Is_Age=+000003.2}', "");
    Expect(1, 65376, '\P{^Is_Age=+000003.2}', "");
    Expect(0, 65377, '\p{Is_Age=+000003.2}', "");
    Expect(1, 65377, '\p{^Is_Age=+000003.2}', "");
    Expect(1, 65377, '\P{Is_Age=+000003.2}', "");
    Expect(0, 65377, '\P{^Is_Age=+000003.2}', "");
    Error('\p{Age=/a/__V4_0}');
    Error('\P{Age=/a/__V4_0}');
    Expect(1, 917999, '\p{Age=:\AV4_0\z:}', "");;
    Expect(0, 918000, '\p{Age=:\AV4_0\z:}', "");;
    Expect(1, 917999, '\p{Age=v40}', "");
    Expect(0, 917999, '\p{^Age=v40}', "");
    Expect(0, 917999, '\P{Age=v40}', "");
    Expect(1, 917999, '\P{^Age=v40}', "");
    Expect(0, 918000, '\p{Age=v40}', "");
    Expect(1, 918000, '\p{^Age=v40}', "");
    Expect(1, 918000, '\P{Age=v40}', "");
    Expect(0, 918000, '\P{^Age=v40}', "");
    Expect(1, 917999, '\p{Age=:\Av40\z:}', "");;
    Expect(0, 918000, '\p{Age=:\Av40\z:}', "");;
    Expect(1, 917999, '\p{Age=_	v4_0}', "");
    Expect(0, 917999, '\p{^Age=_	v4_0}', "");
    Expect(0, 917999, '\P{Age=_	v4_0}', "");
    Expect(1, 917999, '\P{^Age=_	v4_0}', "");
    Expect(0, 918000, '\p{Age=_	v4_0}', "");
    Expect(1, 918000, '\p{^Age=_	v4_0}', "");
    Expect(1, 918000, '\P{Age=_	v4_0}', "");
    Expect(0, 918000, '\P{^Age=_	v4_0}', "");
    Error('\p{Is_Age=:=-	0_0_04.0}');
    Error('\P{Is_Age=:=-	0_0_04.0}');
    Expect(1, 917999, '\p{Is_Age=+0000_4.0}', "");
    Expect(0, 917999, '\p{^Is_Age=+0000_4.0}', "");
    Expect(0, 917999, '\P{Is_Age=+0000_4.0}', "");
    Expect(1, 917999, '\P{^Is_Age=+0000_4.0}', "");
    Expect(0, 918000, '\p{Is_Age=+0000_4.0}', "");
    Expect(1, 918000, '\p{^Is_Age=+0000_4.0}', "");
    Expect(1, 918000, '\P{Is_Age=+0000_4.0}', "");
    Expect(0, 918000, '\P{^Is_Age=+0000_4.0}', "");
    Error('\p{Age=:=V4_1}');
    Error('\P{Age=:=V4_1}');
    Expect(1, 120485, '\p{Age=:\AV4_1\z:}', "");;
    Expect(0, 120486, '\p{Age=:\AV4_1\z:}', "");;
    Expect(1, 120485, '\p{Age:	v41}', "");
    Expect(0, 120485, '\p{^Age:	v41}', "");
    Expect(0, 120485, '\P{Age:	v41}', "");
    Expect(1, 120485, '\P{^Age:	v41}', "");
    Expect(0, 120486, '\p{Age:	v41}', "");
    Expect(1, 120486, '\p{^Age:	v41}', "");
    Expect(1, 120486, '\P{Age:	v41}', "");
    Expect(0, 120486, '\P{^Age:	v41}', "");
    Expect(1, 120485, '\p{Age=:\Av41\z:}', "");;
    Expect(0, 120486, '\p{Age=:\Av41\z:}', "");;
    Expect(1, 120485, '\p{Age= -v4_1}', "");
    Expect(0, 120485, '\p{^Age= -v4_1}', "");
    Expect(0, 120485, '\P{Age= -v4_1}', "");
    Expect(1, 120485, '\P{^Age= -v4_1}', "");
    Expect(0, 120486, '\p{Age= -v4_1}', "");
    Expect(1, 120486, '\p{^Age= -v4_1}', "");
    Expect(1, 120486, '\P{Age= -v4_1}', "");
    Expect(0, 120486, '\P{^Age= -v4_1}', "");
    Error('\p{Is_Age=_0_4.1:=}');
    Error('\P{Is_Age=_0_4.1:=}');
    Expect(1, 120485, '\p{Is_Age=+00004.1}', "");
    Expect(0, 120485, '\p{^Is_Age=+00004.1}', "");
    Expect(0, 120485, '\P{Is_Age=+00004.1}', "");
    Expect(1, 120485, '\P{^Is_Age=+00004.1}', "");
    Expect(0, 120486, '\p{Is_Age=+00004.1}', "");
    Expect(1, 120486, '\p{^Is_Age=+00004.1}', "");
    Expect(1, 120486, '\P{Is_Age=+00004.1}', "");
    Expect(0, 120486, '\P{^Is_Age=+00004.1}', "");
    Error('\p{Age=:=_V5_0}');
    Error('\P{Age=:=_V5_0}');
    Expect(1, 120779, '\p{Age=:\AV5_0\z:}', "");;
    Expect(0, 120780, '\p{Age=:\AV5_0\z:}', "");;
    Expect(1, 120779, '\p{Age:	v50}', "");
    Expect(0, 120779, '\p{^Age:	v50}', "");
    Expect(0, 120779, '\P{Age:	v50}', "");
    Expect(1, 120779, '\P{^Age:	v50}', "");
    Expect(0, 120780, '\p{Age:	v50}', "");
    Expect(1, 120780, '\p{^Age:	v50}', "");
    Expect(1, 120780, '\P{Age:	v50}', "");
    Expect(0, 120780, '\P{^Age:	v50}', "");
    Expect(1, 120779, '\p{Age=:\Av50\z:}', "");;
    Expect(0, 120780, '\p{Age=:\Av50\z:}', "");;
    Expect(1, 120779, '\p{Age=		v5_0}', "");
    Expect(0, 120779, '\p{^Age=		v5_0}', "");
    Expect(0, 120779, '\P{Age=		v5_0}', "");
    Expect(1, 120779, '\P{^Age=		v5_0}', "");
    Expect(0, 120780, '\p{Age=		v5_0}', "");
    Expect(1, 120780, '\p{^Age=		v5_0}', "");
    Expect(1, 120780, '\P{Age=		v5_0}', "");
    Expect(0, 120780, '\P{^Age=		v5_0}', "");
    Error('\p{Is_Age=:=00_5.0}');
    Error('\P{Is_Age=:=00_5.0}');
    Expect(1, 120779, '\p{Is_Age=00_00_5.0}', "");
    Expect(0, 120779, '\p{^Is_Age=00_00_5.0}', "");
    Expect(0, 120779, '\P{Is_Age=00_00_5.0}', "");
    Expect(1, 120779, '\P{^Is_Age=00_00_5.0}', "");
    Expect(0, 120780, '\p{Is_Age=00_00_5.0}', "");
    Expect(1, 120780, '\p{^Is_Age=00_00_5.0}', "");
    Expect(1, 120780, '\P{Is_Age=00_00_5.0}', "");
    Expect(0, 120780, '\P{^Is_Age=00_00_5.0}', "");
    Error('\p{Age:/a/_V5_1}');
    Error('\P{Age:/a/_V5_1}');
    Expect(1, 127123, '\p{Age=:\AV5_1\z:}', "");;
    Expect(0, 127124, '\p{Age=:\AV5_1\z:}', "");;
    Expect(1, 127123, '\p{Age=v51}', "");
    Expect(0, 127123, '\p{^Age=v51}', "");
    Expect(0, 127123, '\P{Age=v51}', "");
    Expect(1, 127123, '\P{^Age=v51}', "");
    Expect(0, 127124, '\p{Age=v51}', "");
    Expect(1, 127124, '\p{^Age=v51}', "");
    Expect(1, 127124, '\P{Age=v51}', "");
    Expect(0, 127124, '\P{^Age=v51}', "");
    Expect(1, 127123, '\p{Age=:\Av51\z:}', "");;
    Expect(0, 127124, '\p{Age=:\Av51\z:}', "");;
    Expect(1, 127123, '\p{Age=	-V5_1}', "");
    Expect(0, 127123, '\p{^Age=	-V5_1}', "");
    Expect(0, 127123, '\P{Age=	-V5_1}', "");
    Expect(1, 127123, '\P{^Age=	-V5_1}', "");
    Expect(0, 127124, '\p{Age=	-V5_1}', "");
    Expect(1, 127124, '\p{^Age=	-V5_1}', "");
    Expect(1, 127124, '\P{Age=	-V5_1}', "");
    Expect(0, 127124, '\P{^Age=	-V5_1}', "");
    Error('\p{Is_Age=/a/-_+0_5.1}');
    Error('\P{Is_Age=/a/-_+0_5.1}');
    Expect(1, 127123, '\p{Is_Age=+00_00_00_005.1}', "");
    Expect(0, 127123, '\p{^Is_Age=+00_00_00_005.1}', "");
    Expect(0, 127123, '\P{Is_Age=+00_00_00_005.1}', "");
    Expect(1, 127123, '\P{^Is_Age=+00_00_00_005.1}', "");
    Expect(0, 127124, '\p{Is_Age=+00_00_00_005.1}', "");
    Expect(1, 127124, '\p{^Is_Age=+00_00_00_005.1}', "");
    Expect(1, 127124, '\P{Is_Age=+00_00_00_005.1}', "");
    Expect(0, 127124, '\P{^Is_Age=+00_00_00_005.1}', "");
    Error('\p{Age=V5_2:=}');
    Error('\P{Age=V5_2:=}');
    Expect(1, 177972, '\p{Age=:\AV5_2\z:}', "");;
    Expect(0, 177973, '\p{Age=:\AV5_2\z:}', "");;
    Expect(1, 177972, '\p{Age=v52}', "");
    Expect(0, 177972, '\p{^Age=v52}', "");
    Expect(0, 177972, '\P{Age=v52}', "");
    Expect(1, 177972, '\P{^Age=v52}', "");
    Expect(0, 177973, '\p{Age=v52}', "");
    Expect(1, 177973, '\p{^Age=v52}', "");
    Expect(1, 177973, '\P{Age=v52}', "");
    Expect(0, 177973, '\P{^Age=v52}', "");
    Expect(1, 177972, '\p{Age=:\Av52\z:}', "");;
    Expect(0, 177973, '\p{Age=:\Av52\z:}', "");;
    Expect(1, 177972, '\p{Age=	V5_2}', "");
    Expect(0, 177972, '\p{^Age=	V5_2}', "");
    Expect(0, 177972, '\P{Age=	V5_2}', "");
    Expect(1, 177972, '\P{^Age=	V5_2}', "");
    Expect(0, 177973, '\p{Age=	V5_2}', "");
    Expect(1, 177973, '\p{^Age=	V5_2}', "");
    Expect(1, 177973, '\P{Age=	V5_2}', "");
    Expect(0, 177973, '\P{^Age=	V5_2}', "");
    Error('\p{Is_Age=/a/		5.2}');
    Error('\P{Is_Age=/a/		5.2}');
    Expect(1, 177972, '\p{Is_Age=0_0_0_05.2}', "");
    Expect(0, 177972, '\p{^Is_Age=0_0_0_05.2}', "");
    Expect(0, 177972, '\P{Is_Age=0_0_0_05.2}', "");
    Expect(1, 177972, '\P{^Is_Age=0_0_0_05.2}', "");
    Expect(0, 177973, '\p{Is_Age=0_0_0_05.2}', "");
    Expect(1, 177973, '\p{^Is_Age=0_0_0_05.2}', "");
    Expect(1, 177973, '\P{Is_Age=0_0_0_05.2}', "");
    Expect(0, 177973, '\P{^Is_Age=0_0_0_05.2}', "");
    Error('\p{Age=	:=V6_0}');
    Error('\P{Age=	:=V6_0}');
    Expect(1, 178205, '\p{Age=:\AV6_0\z:}', "");;
    Expect(0, 178206, '\p{Age=:\AV6_0\z:}', "");;
    Expect(1, 178205, '\p{Age: v60}', "");
    Expect(0, 178205, '\p{^Age: v60}', "");
    Expect(0, 178205, '\P{Age: v60}', "");
    Expect(1, 178205, '\P{^Age: v60}', "");
    Expect(0, 178206, '\p{Age: v60}', "");
    Expect(1, 178206, '\p{^Age: v60}', "");
    Expect(1, 178206, '\P{Age: v60}', "");
    Expect(0, 178206, '\P{^Age: v60}', "");
    Expect(1, 178205, '\p{Age=:\Av60\z:}', "");;
    Expect(0, 178206, '\p{Age=:\Av60\z:}', "");;
    Expect(1, 178205, '\p{Age= _V6_0}', "");
    Expect(0, 178205, '\p{^Age= _V6_0}', "");
    Expect(0, 178205, '\P{Age= _V6_0}', "");
    Expect(1, 178205, '\P{^Age= _V6_0}', "");
    Expect(0, 178206, '\p{Age= _V6_0}', "");
    Expect(1, 178206, '\p{^Age= _V6_0}', "");
    Expect(1, 178206, '\P{Age= _V6_0}', "");
    Expect(0, 178206, '\P{^Age= _V6_0}', "");
    Error('\p{Is_Age=_+000006.0:=}');
    Error('\P{Is_Age=_+000006.0:=}');
    Expect(1, 178205, '\p{Is_Age=+0000000006.0}', "");
    Expect(0, 178205, '\p{^Is_Age=+0000000006.0}', "");
    Expect(0, 178205, '\P{Is_Age=+0000000006.0}', "");
    Expect(1, 178205, '\P{^Is_Age=+0000000006.0}', "");
    Expect(0, 178206, '\p{Is_Age=+0000000006.0}', "");
    Expect(1, 178206, '\p{^Is_Age=+0000000006.0}', "");
    Expect(1, 178206, '\P{Is_Age=+0000000006.0}', "");
    Expect(0, 178206, '\P{^Is_Age=+0000000006.0}', "");
    Error('\p{Age:		/a/V6_1}');
    Error('\P{Age:		/a/V6_1}');
    Expect(1, 128564, '\p{Age=:\AV6_1\z:}', "");;
    Expect(0, 128565, '\p{Age=:\AV6_1\z:}', "");;
    Expect(1, 128564, '\p{Age=v61}', "");
    Expect(0, 128564, '\p{^Age=v61}', "");
    Expect(0, 128564, '\P{Age=v61}', "");
    Expect(1, 128564, '\P{^Age=v61}', "");
    Expect(0, 128565, '\p{Age=v61}', "");
    Expect(1, 128565, '\p{^Age=v61}', "");
    Expect(1, 128565, '\P{Age=v61}', "");
    Expect(0, 128565, '\P{^Age=v61}', "");
    Expect(1, 128564, '\p{Age=:\Av61\z:}', "");;
    Expect(0, 128565, '\p{Age=:\Av61\z:}', "");;
    Expect(1, 128564, '\p{Age=_ v6_1}', "");
    Expect(0, 128564, '\p{^Age=_ v6_1}', "");
    Expect(0, 128564, '\P{Age=_ v6_1}', "");
    Expect(1, 128564, '\P{^Age=_ v6_1}', "");
    Expect(0, 128565, '\p{Age=_ v6_1}', "");
    Expect(1, 128565, '\p{^Age=_ v6_1}', "");
    Expect(1, 128565, '\P{Age=_ v6_1}', "");
    Expect(0, 128565, '\P{^Age=_ v6_1}', "");
    Error('\p{Is_Age=- +00_6.1:=}');
    Error('\P{Is_Age=- +00_6.1:=}');
    Expect(1, 128564, '\p{Is_Age:	0_6.1}', "");
    Expect(0, 128564, '\p{^Is_Age:	0_6.1}', "");
    Expect(0, 128564, '\P{Is_Age:	0_6.1}', "");
    Expect(1, 128564, '\P{^Is_Age:	0_6.1}', "");
    Expect(0, 128565, '\p{Is_Age:	0_6.1}', "");
    Expect(1, 128565, '\p{^Is_Age:	0_6.1}', "");
    Expect(1, 128565, '\P{Is_Age:	0_6.1}', "");
    Expect(0, 128565, '\P{^Is_Age:	0_6.1}', "");
    Error('\p{Age=/a/V6_2}');
    Error('\P{Age=/a/V6_2}');
    Expect(1, 8378, '\p{Age=:\AV6_2\z:}', "");;
    Expect(0, 8379, '\p{Age=:\AV6_2\z:}', "");;
    Expect(1, 8378, '\p{Age=v62}', "");
    Expect(0, 8378, '\p{^Age=v62}', "");
    Expect(0, 8378, '\P{Age=v62}', "");
    Expect(1, 8378, '\P{^Age=v62}', "");
    Expect(0, 8379, '\p{Age=v62}', "");
    Expect(1, 8379, '\p{^Age=v62}', "");
    Expect(1, 8379, '\P{Age=v62}', "");
    Expect(0, 8379, '\P{^Age=v62}', "");
    Expect(1, 8378, '\p{Age=:\Av62\z:}', "");;
    Expect(0, 8379, '\p{Age=:\Av62\z:}', "");;
    Expect(1, 8378, '\p{Age=_V6_2}', "");
    Expect(0, 8378, '\p{^Age=_V6_2}', "");
    Expect(0, 8378, '\P{Age=_V6_2}', "");
    Expect(1, 8378, '\P{^Age=_V6_2}', "");
    Expect(0, 8379, '\p{Age=_V6_2}', "");
    Expect(1, 8379, '\p{^Age=_V6_2}', "");
    Expect(1, 8379, '\P{Age=_V6_2}', "");
    Expect(0, 8379, '\P{^Age=_V6_2}', "");
    Error('\p{Is_Age= 00000000_6.2:=}');
    Error('\P{Is_Age= 00000000_6.2:=}');
    Expect(1, 8378, '\p{Is_Age=+0_6.2}', "");
    Expect(0, 8378, '\p{^Is_Age=+0_6.2}', "");
    Expect(0, 8378, '\P{Is_Age=+0_6.2}', "");
    Expect(1, 8378, '\P{^Is_Age=+0_6.2}', "");
    Expect(0, 8379, '\p{Is_Age=+0_6.2}', "");
    Expect(1, 8379, '\p{^Is_Age=+0_6.2}', "");
    Expect(1, 8379, '\P{Is_Age=+0_6.2}', "");
    Expect(0, 8379, '\P{^Is_Age=+0_6.2}', "");
    Error('\p{Age=:=_v6_3}');
    Error('\P{Age=:=_v6_3}');
    Expect(1, 8297, '\p{Age=:\AV6_3\z:}', "");;
    Expect(0, 8298, '\p{Age=:\AV6_3\z:}', "");;
    Expect(1, 8297, '\p{Age=v63}', "");
    Expect(0, 8297, '\p{^Age=v63}', "");
    Expect(0, 8297, '\P{Age=v63}', "");
    Expect(1, 8297, '\P{^Age=v63}', "");
    Expect(0, 8298, '\p{Age=v63}', "");
    Expect(1, 8298, '\p{^Age=v63}', "");
    Expect(1, 8298, '\P{Age=v63}', "");
    Expect(0, 8298, '\P{^Age=v63}', "");
    Expect(1, 8297, '\p{Age=:\Av63\z:}', "");;
    Expect(0, 8298, '\p{Age=:\Av63\z:}', "");;
    Expect(1, 8297, '\p{Age=-V6_3}', "");
    Expect(0, 8297, '\p{^Age=-V6_3}', "");
    Expect(0, 8297, '\P{Age=-V6_3}', "");
    Expect(1, 8297, '\P{^Age=-V6_3}', "");
    Expect(0, 8298, '\p{Age=-V6_3}', "");
    Expect(1, 8298, '\p{^Age=-V6_3}', "");
    Expect(1, 8298, '\P{Age=-V6_3}', "");
    Expect(0, 8298, '\P{^Age=-V6_3}', "");
    Error('\p{Is_Age=_	0_6.3/a/}');
    Error('\P{Is_Age=_	0_6.3/a/}');
    Expect(1, 8297, '\p{Is_Age=00_00_00_00_6.3}', "");
    Expect(0, 8297, '\p{^Is_Age=00_00_00_00_6.3}', "");
    Expect(0, 8297, '\P{Is_Age=00_00_00_00_6.3}', "");
    Expect(1, 8297, '\P{^Is_Age=00_00_00_00_6.3}', "");
    Expect(0, 8298, '\p{Is_Age=00_00_00_00_6.3}', "");
    Expect(1, 8298, '\p{^Is_Age=00_00_00_00_6.3}', "");
    Expect(1, 8298, '\P{Is_Age=00_00_00_00_6.3}', "");
    Expect(0, 8298, '\P{^Is_Age=00_00_00_00_6.3}', "");
    Error('\p{Age=-	v7_0/a/}');
    Error('\P{Age=-	v7_0/a/}');
    Expect(1, 129197, '\p{Age=:\AV7_0\z:}', "");;
    Expect(0, 129198, '\p{Age=:\AV7_0\z:}', "");;
    Expect(1, 129197, '\p{Age=v70}', "");
    Expect(0, 129197, '\p{^Age=v70}', "");
    Expect(0, 129197, '\P{Age=v70}', "");
    Expect(1, 129197, '\P{^Age=v70}', "");
    Expect(0, 129198, '\p{Age=v70}', "");
    Expect(1, 129198, '\p{^Age=v70}', "");
    Expect(1, 129198, '\P{Age=v70}', "");
    Expect(0, 129198, '\P{^Age=v70}', "");
    Expect(1, 129197, '\p{Age=:\Av70\z:}', "");;
    Expect(0, 129198, '\p{Age=:\Av70\z:}', "");;
    Expect(1, 129197, '\p{Age=  V7_0}', "");
    Expect(0, 129197, '\p{^Age=  V7_0}', "");
    Expect(0, 129197, '\P{Age=  V7_0}', "");
    Expect(1, 129197, '\P{^Age=  V7_0}', "");
    Expect(0, 129198, '\p{Age=  V7_0}', "");
    Expect(1, 129198, '\p{^Age=  V7_0}', "");
    Expect(1, 129198, '\P{Age=  V7_0}', "");
    Expect(0, 129198, '\P{^Age=  V7_0}', "");
    Error('\p{Is_Age=_/a/007.0}');
    Error('\P{Is_Age=_/a/007.0}');
    Expect(1, 129197, '\p{Is_Age=00000000_7.0}', "");
    Expect(0, 129197, '\p{^Is_Age=00000000_7.0}', "");
    Expect(0, 129197, '\P{Is_Age=00000000_7.0}', "");
    Expect(1, 129197, '\P{^Is_Age=00000000_7.0}', "");
    Expect(0, 129198, '\p{Is_Age=00000000_7.0}', "");
    Expect(1, 129198, '\p{^Is_Age=00000000_7.0}', "");
    Expect(1, 129198, '\P{Is_Age=00000000_7.0}', "");
    Expect(0, 129198, '\P{^Is_Age=00000000_7.0}', "");
    Error('\p{Age=/a/- V8_0}');
    Error('\P{Age=/a/- V8_0}');
    Expect(1, 183969, '\p{Age=:\AV8_0\z:}', "");;
    Expect(0, 183970, '\p{Age=:\AV8_0\z:}', "");;
    Expect(1, 183969, '\p{Age=v80}', "");
    Expect(0, 183969, '\p{^Age=v80}', "");
    Expect(0, 183969, '\P{Age=v80}', "");
    Expect(1, 183969, '\P{^Age=v80}', "");
    Expect(0, 183970, '\p{Age=v80}', "");
    Expect(1, 183970, '\p{^Age=v80}', "");
    Expect(1, 183970, '\P{Age=v80}', "");
    Expect(0, 183970, '\P{^Age=v80}', "");
    Expect(1, 183969, '\p{Age=:\Av80\z:}', "");;
    Expect(0, 183970, '\p{Age=:\Av80\z:}', "");;
    Expect(1, 183969, '\p{Age=_	v8_0}', "");
    Expect(0, 183969, '\p{^Age=_	v8_0}', "");
    Expect(0, 183969, '\P{Age=_	v8_0}', "");
    Expect(1, 183969, '\P{^Age=_	v8_0}', "");
    Expect(0, 183970, '\p{Age=_	v8_0}', "");
    Expect(1, 183970, '\p{^Age=_	v8_0}', "");
    Expect(1, 183970, '\P{Age=_	v8_0}', "");
    Expect(0, 183970, '\P{^Age=_	v8_0}', "");
    Error('\p{Is_Age=:= _0000008.0}');
    Error('\P{Is_Age=:= _0000008.0}');
    Expect(1, 183969, '\p{Is_Age=+0000_0000_08.0}', "");
    Expect(0, 183969, '\p{^Is_Age=+0000_0000_08.0}', "");
    Expect(0, 183969, '\P{Is_Age=+0000_0000_08.0}', "");
    Expect(1, 183969, '\P{^Is_Age=+0000_0000_08.0}', "");
    Expect(0, 183970, '\p{Is_Age=+0000_0000_08.0}', "");
    Expect(1, 183970, '\p{^Is_Age=+0000_0000_08.0}', "");
    Expect(1, 183970, '\P{Is_Age=+0000_0000_08.0}', "");
    Expect(0, 183970, '\P{^Is_Age=+0000_0000_08.0}', "");
    Error('\p{Age= /a/v9_0}');
    Error('\P{Age= /a/v9_0}');
    Expect(1, 129425, '\p{Age=:\AV9_0\z:}', "");;
    Expect(0, 129426, '\p{Age=:\AV9_0\z:}', "");;
    Expect(1, 129425, '\p{Age=v90}', "");
    Expect(0, 129425, '\p{^Age=v90}', "");
    Expect(0, 129425, '\P{Age=v90}', "");
    Expect(1, 129425, '\P{^Age=v90}', "");
    Expect(0, 129426, '\p{Age=v90}', "");
    Expect(1, 129426, '\p{^Age=v90}', "");
    Expect(1, 129426, '\P{Age=v90}', "");
    Expect(0, 129426, '\P{^Age=v90}', "");
    Expect(1, 129425, '\p{Age=:\Av90\z:}', "");;
    Expect(0, 129426, '\p{Age=:\Av90\z:}', "");;
    Expect(1, 129425, '\p{Age=	 V9_0}', "");
    Expect(0, 129425, '\p{^Age=	 V9_0}', "");
    Expect(0, 129425, '\P{Age=	 V9_0}', "");
    Expect(1, 129425, '\P{^Age=	 V9_0}', "");
    Expect(0, 129426, '\p{Age=	 V9_0}', "");
    Expect(1, 129426, '\p{^Age=	 V9_0}', "");
    Expect(1, 129426, '\P{Age=	 V9_0}', "");
    Expect(0, 129426, '\P{^Age=	 V9_0}', "");
    Error('\p{Is_Age= :=0009.0}');
    Error('\P{Is_Age= :=0009.0}');
    Expect(1, 129425, '\p{Is_Age=00000009.0}', "");
    Expect(0, 129425, '\p{^Is_Age=00000009.0}', "");
    Expect(0, 129425, '\P{Is_Age=00000009.0}', "");
    Expect(1, 129425, '\P{^Is_Age=00000009.0}', "");
    Expect(0, 129426, '\p{Is_Age=00000009.0}', "");
    Expect(1, 129426, '\p{^Is_Age=00000009.0}', "");
    Expect(1, 129426, '\P{Is_Age=00000009.0}', "");
    Expect(0, 129426, '\P{^Is_Age=00000009.0}', "");
    Error('\p{Age=/a/ 	UNASSIGNED}');
    Error('\P{Age=/a/ 	UNASSIGNED}');
    Expect(1, 983037, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=unassigned}', "");
    Expect(0, 983037, '\p{^Age=unassigned}', "");
    Expect(0, 983037, '\P{Age=unassigned}', "");
    Expect(1, 983037, '\P{^Age=unassigned}', "");
    Expect(0, 983040, '\p{Age=unassigned}', "");
    Expect(1, 983040, '\p{^Age=unassigned}', "");
    Expect(1, 983040, '\P{Age=unassigned}', "");
    Expect(0, 983040, '\P{^Age=unassigned}', "");
    Expect(1, 983037, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=		unassigned}', "");
    Expect(0, 983037, '\p{^Age=		unassigned}', "");
    Expect(0, 983037, '\P{Age=		unassigned}', "");
    Expect(1, 983037, '\P{^Age=		unassigned}', "");
    Expect(0, 983040, '\p{Age=		unassigned}', "");
    Expect(1, 983040, '\p{^Age=		unassigned}', "");
    Expect(1, 983040, '\P{Age=		unassigned}', "");
    Expect(0, 983040, '\P{^Age=		unassigned}', "");
    Error('\p{Is_Age:	/a/NA}');
    Error('\P{Is_Age:	/a/NA}');
    Expect(1, 983037, '\p{Is_Age=na}', "");
    Expect(0, 983037, '\p{^Is_Age=na}', "");
    Expect(0, 983037, '\P{Is_Age=na}', "");
    Expect(1, 983037, '\P{^Is_Age=na}', "");
    Expect(0, 983040, '\p{Is_Age=na}', "");
    Expect(1, 983040, '\p{^Is_Age=na}', "");
    Expect(1, 983040, '\P{Is_Age=na}', "");
    Expect(0, 983040, '\P{^Is_Age=na}', "");
    Expect(1, 983037, '\p{Is_Age= NA}', "");
    Expect(0, 983037, '\p{^Is_Age= NA}', "");
    Expect(0, 983037, '\P{Is_Age= NA}', "");
    Expect(1, 983037, '\P{^Is_Age= NA}', "");
    Expect(0, 983040, '\p{Is_Age= NA}', "");
    Expect(1, 983040, '\p{^Is_Age= NA}', "");
    Expect(1, 983040, '\P{Is_Age= NA}', "");
    Expect(0, 983040, '\P{^Is_Age= NA}', "");
    Error('\p{ASCII_Hex_Digit=:=-No}');
    Error('\P{ASCII_Hex_Digit=:=-No}');
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit= -NO}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit= -NO}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit= -NO}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit= -NO}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit= -NO}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit= -NO}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit= -NO}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit= -NO}', "");
    Error('\p{AHex: /a/N}');
    Error('\P{AHex: /a/N}');
    Expect(1, 103, '\p{AHex=:\AN\z:}', "");;
    Expect(0, 102, '\p{AHex=:\AN\z:}', "");;
    Expect(1, 103, '\p{AHex=n}', "");
    Expect(0, 103, '\p{^AHex=n}', "");
    Expect(0, 103, '\P{AHex=n}', "");
    Expect(1, 103, '\P{^AHex=n}', "");
    Expect(0, 102, '\p{AHex=n}', "");
    Expect(1, 102, '\p{^AHex=n}', "");
    Expect(1, 102, '\P{AHex=n}', "");
    Expect(0, 102, '\P{^AHex=n}', "");
    Expect(1, 103, '\p{AHex=:\An\z:}', "");;
    Expect(0, 102, '\p{AHex=:\An\z:}', "");;
    Expect(1, 103, '\p{AHex=-n}', "");
    Expect(0, 103, '\p{^AHex=-n}', "");
    Expect(0, 103, '\P{AHex=-n}', "");
    Expect(1, 103, '\P{^AHex=-n}', "");
    Expect(0, 102, '\p{AHex=-n}', "");
    Expect(1, 102, '\p{^AHex=-n}', "");
    Expect(1, 102, '\P{AHex=-n}', "");
    Expect(0, 102, '\P{^AHex=-n}', "");
    Error('\p{Is_ASCII_Hex_Digit=:= F}');
    Error('\P{Is_ASCII_Hex_Digit=:= F}');
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=-f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=-f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=-f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=-f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=-f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=-f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=-f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=-f}', "");
    Error('\p{Is_AHex=-/a/FALSE}');
    Error('\P{Is_AHex=-/a/FALSE}');
    Expect(1, 103, '\p{Is_AHex=false}', "");
    Expect(0, 103, '\p{^Is_AHex=false}', "");
    Expect(0, 103, '\P{Is_AHex=false}', "");
    Expect(1, 103, '\P{^Is_AHex=false}', "");
    Expect(0, 102, '\p{Is_AHex=false}', "");
    Expect(1, 102, '\p{^Is_AHex=false}', "");
    Expect(1, 102, '\P{Is_AHex=false}', "");
    Expect(0, 102, '\P{^Is_AHex=false}', "");
    Expect(1, 103, '\p{Is_AHex=- False}', "");
    Expect(0, 103, '\p{^Is_AHex=- False}', "");
    Expect(0, 103, '\P{Is_AHex=- False}', "");
    Expect(1, 103, '\P{^Is_AHex=- False}', "");
    Expect(0, 102, '\p{Is_AHex=- False}', "");
    Expect(1, 102, '\p{^Is_AHex=- False}', "");
    Expect(1, 102, '\P{Is_AHex=- False}', "");
    Expect(0, 102, '\P{^Is_AHex=- False}', "");
    Error('\p{ASCII_Hex_Digit=:=_yes}');
    Error('\P{ASCII_Hex_Digit=:=_yes}');
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=-_yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=-_yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=-_yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=-_yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=-_yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=-_yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=-_yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=-_yes}', "");
    Error('\p{AHex=/a/	Y}');
    Error('\P{AHex=/a/	Y}');
    Expect(1, 102, '\p{AHex=:\AY\z:}', "");;
    Expect(0, 103, '\p{AHex=:\AY\z:}', "");;
    Expect(1, 102, '\p{AHex=y}', "");
    Expect(0, 102, '\p{^AHex=y}', "");
    Expect(0, 102, '\P{AHex=y}', "");
    Expect(1, 102, '\P{^AHex=y}', "");
    Expect(0, 103, '\p{AHex=y}', "");
    Expect(1, 103, '\p{^AHex=y}', "");
    Expect(1, 103, '\P{AHex=y}', "");
    Expect(0, 103, '\P{^AHex=y}', "");
    Expect(1, 102, '\p{AHex=:\Ay\z:}', "");;
    Expect(0, 103, '\p{AHex=:\Ay\z:}', "");;
    Expect(1, 102, '\p{AHex: 		y}', "");
    Expect(0, 102, '\p{^AHex: 		y}', "");
    Expect(0, 102, '\P{AHex: 		y}', "");
    Expect(1, 102, '\P{^AHex: 		y}', "");
    Expect(0, 103, '\p{AHex: 		y}', "");
    Expect(1, 103, '\p{^AHex: 		y}', "");
    Expect(1, 103, '\P{AHex: 		y}', "");
    Expect(0, 103, '\P{^AHex: 		y}', "");
    Error('\p{Is_ASCII_Hex_Digit=__T:=}');
    Error('\P{Is_ASCII_Hex_Digit=__T:=}');
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=_-T}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=_-T}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=_-T}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=_-T}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=_-T}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=_-T}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=_-T}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=_-T}', "");
    Error('\p{Is_AHex=-/a/True}');
    Error('\P{Is_AHex=-/a/True}');
    Expect(1, 102, '\p{Is_AHex=true}', "");
    Expect(0, 102, '\p{^Is_AHex=true}', "");
    Expect(0, 102, '\P{Is_AHex=true}', "");
    Expect(1, 102, '\P{^Is_AHex=true}', "");
    Expect(0, 103, '\p{Is_AHex=true}', "");
    Expect(1, 103, '\p{^Is_AHex=true}', "");
    Expect(1, 103, '\P{Is_AHex=true}', "");
    Expect(0, 103, '\P{^Is_AHex=true}', "");
    Expect(1, 102, '\p{Is_AHex= _true}', "");
    Expect(0, 102, '\p{^Is_AHex= _true}', "");
    Expect(0, 102, '\P{Is_AHex= _true}', "");
    Expect(1, 102, '\P{^Is_AHex= _true}', "");
    Expect(0, 103, '\p{Is_AHex= _true}', "");
    Expect(1, 103, '\p{^Is_AHex= _true}', "");
    Expect(1, 103, '\P{Is_AHex= _true}', "");
    Expect(0, 103, '\P{^Is_AHex= _true}', "");
    Error('\p{Alphabetic=-No:=}');
    Error('\P{Alphabetic=-No:=}');
    Expect(1, 201547, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(0, 201546, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(1, 201547, '\p{Alphabetic=no}', "");
    Expect(0, 201547, '\p{^Alphabetic=no}', "");
    Expect(0, 201547, '\P{Alphabetic=no}', "");
    Expect(1, 201547, '\P{^Alphabetic=no}', "");
    Expect(0, 201546, '\p{Alphabetic=no}', "");
    Expect(1, 201546, '\p{^Alphabetic=no}', "");
    Expect(1, 201546, '\P{Alphabetic=no}', "");
    Expect(0, 201546, '\P{^Alphabetic=no}', "");
    Expect(1, 201547, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(0, 201546, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(1, 201547, '\p{Alphabetic=	 No}', "");
    Expect(0, 201547, '\p{^Alphabetic=	 No}', "");
    Expect(0, 201547, '\P{Alphabetic=	 No}', "");
    Expect(1, 201547, '\P{^Alphabetic=	 No}', "");
    Expect(0, 201546, '\p{Alphabetic=	 No}', "");
    Expect(1, 201546, '\p{^Alphabetic=	 No}', "");
    Expect(1, 201546, '\P{Alphabetic=	 No}', "");
    Expect(0, 201546, '\P{^Alphabetic=	 No}', "");
    Error('\p{Alpha=		N:=}');
    Error('\P{Alpha=		N:=}');
    Expect(1, 201547, '\p{Alpha=:\AN\z:}', "");;
    Expect(0, 201546, '\p{Alpha=:\AN\z:}', "");;
    Expect(1, 201547, '\p{Alpha=n}', "");
    Expect(0, 201547, '\p{^Alpha=n}', "");
    Expect(0, 201547, '\P{Alpha=n}', "");
    Expect(1, 201547, '\P{^Alpha=n}', "");
    Expect(0, 201546, '\p{Alpha=n}', "");
    Expect(1, 201546, '\p{^Alpha=n}', "");
    Expect(1, 201546, '\P{Alpha=n}', "");
    Expect(0, 201546, '\P{^Alpha=n}', "");
    Expect(1, 201547, '\p{Alpha=:\An\z:}', "");;
    Expect(0, 201546, '\p{Alpha=:\An\z:}', "");;
    Expect(1, 201547, '\p{Alpha=	-N}', "");
    Expect(0, 201547, '\p{^Alpha=	-N}', "");
    Expect(0, 201547, '\P{Alpha=	-N}', "");
    Expect(1, 201547, '\P{^Alpha=	-N}', "");
    Expect(0, 201546, '\p{Alpha=	-N}', "");
    Expect(1, 201546, '\p{^Alpha=	-N}', "");
    Expect(1, 201546, '\P{Alpha=	-N}', "");
    Expect(0, 201546, '\P{^Alpha=	-N}', "");
    Error('\p{Is_Alphabetic=/a/	_f}');
    Error('\P{Is_Alphabetic=/a/	_f}');
    Expect(1, 201547, '\p{Is_Alphabetic=f}', "");
    Expect(0, 201547, '\p{^Is_Alphabetic=f}', "");
    Expect(0, 201547, '\P{Is_Alphabetic=f}', "");
    Expect(1, 201547, '\P{^Is_Alphabetic=f}', "");
    Expect(0, 201546, '\p{Is_Alphabetic=f}', "");
    Expect(1, 201546, '\p{^Is_Alphabetic=f}', "");
    Expect(1, 201546, '\P{Is_Alphabetic=f}', "");
    Expect(0, 201546, '\P{^Is_Alphabetic=f}', "");
    Expect(1, 201547, '\p{Is_Alphabetic=_F}', "");
    Expect(0, 201547, '\p{^Is_Alphabetic=_F}', "");
    Expect(0, 201547, '\P{Is_Alphabetic=_F}', "");
    Expect(1, 201547, '\P{^Is_Alphabetic=_F}', "");
    Expect(0, 201546, '\p{Is_Alphabetic=_F}', "");
    Expect(1, 201546, '\p{^Is_Alphabetic=_F}', "");
    Expect(1, 201546, '\P{Is_Alphabetic=_F}', "");
    Expect(0, 201546, '\P{^Is_Alphabetic=_F}', "");
    Error('\p{Is_Alpha=/a/--false}');
    Error('\P{Is_Alpha=/a/--false}');
    Expect(1, 201547, '\p{Is_Alpha=false}', "");
    Expect(0, 201547, '\p{^Is_Alpha=false}', "");
    Expect(0, 201547, '\P{Is_Alpha=false}', "");
    Expect(1, 201547, '\P{^Is_Alpha=false}', "");
    Expect(0, 201546, '\p{Is_Alpha=false}', "");
    Expect(1, 201546, '\p{^Is_Alpha=false}', "");
    Expect(1, 201546, '\P{Is_Alpha=false}', "");
    Expect(0, 201546, '\P{^Is_Alpha=false}', "");
    Expect(1, 201547, '\p{Is_Alpha=-False}', "");
    Expect(0, 201547, '\p{^Is_Alpha=-False}', "");
    Expect(0, 201547, '\P{Is_Alpha=-False}', "");
    Expect(1, 201547, '\P{^Is_Alpha=-False}', "");
    Expect(0, 201546, '\p{Is_Alpha=-False}', "");
    Expect(1, 201546, '\p{^Is_Alpha=-False}', "");
    Expect(1, 201546, '\P{Is_Alpha=-False}', "");
    Expect(0, 201546, '\P{^Is_Alpha=-False}', "");
    Error('\p{Alphabetic=	Yes/a/}');
    Error('\P{Alphabetic=	Yes/a/}');
    Expect(1, 201546, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(0, 201547, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(1, 201546, '\p{Alphabetic=yes}', "");
    Expect(0, 201546, '\p{^Alphabetic=yes}', "");
    Expect(0, 201546, '\P{Alphabetic=yes}', "");
    Expect(1, 201546, '\P{^Alphabetic=yes}', "");
    Expect(0, 201547, '\p{Alphabetic=yes}', "");
    Expect(1, 201547, '\p{^Alphabetic=yes}', "");
    Expect(1, 201547, '\P{Alphabetic=yes}', "");
    Expect(0, 201547, '\P{^Alphabetic=yes}', "");
    Expect(1, 201546, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(0, 201547, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(1, 201546, '\p{Alphabetic: YES}', "");
    Expect(0, 201546, '\p{^Alphabetic: YES}', "");
    Expect(0, 201546, '\P{Alphabetic: YES}', "");
    Expect(1, 201546, '\P{^Alphabetic: YES}', "");
    Expect(0, 201547, '\p{Alphabetic: YES}', "");
    Expect(1, 201547, '\p{^Alphabetic: YES}', "");
    Expect(1, 201547, '\P{Alphabetic: YES}', "");
    Expect(0, 201547, '\P{^Alphabetic: YES}', "");
    Error('\p{Alpha=	_Y:=}');
    Error('\P{Alpha=	_Y:=}');
    Expect(1, 201546, '\p{Alpha=:\AY\z:}', "");;
    Expect(0, 201547, '\p{Alpha=:\AY\z:}', "");;
    Expect(1, 201546, '\p{Alpha:	y}', "");
    Expect(0, 201546, '\p{^Alpha:	y}', "");
    Expect(0, 201546, '\P{Alpha:	y}', "");
    Expect(1, 201546, '\P{^Alpha:	y}', "");
    Expect(0, 201547, '\p{Alpha:	y}', "");
    Expect(1, 201547, '\p{^Alpha:	y}', "");
    Expect(1, 201547, '\P{Alpha:	y}', "");
    Expect(0, 201547, '\P{^Alpha:	y}', "");
    Expect(1, 201546, '\p{Alpha=:\Ay\z:}', "");;
    Expect(0, 201547, '\p{Alpha=:\Ay\z:}', "");;
    Expect(1, 201546, '\p{Alpha=	_Y}', "");
    Expect(0, 201546, '\p{^Alpha=	_Y}', "");
    Expect(0, 201546, '\P{Alpha=	_Y}', "");
    Expect(1, 201546, '\P{^Alpha=	_Y}', "");
    Expect(0, 201547, '\p{Alpha=	_Y}', "");
    Expect(1, 201547, '\p{^Alpha=	_Y}', "");
    Expect(1, 201547, '\P{Alpha=	_Y}', "");
    Expect(0, 201547, '\P{^Alpha=	_Y}', "");
    Error('\p{Is_Alphabetic=/a/_T}');
    Error('\P{Is_Alphabetic=/a/_T}');
    Expect(1, 201546, '\p{Is_Alphabetic=t}', "");
    Expect(0, 201546, '\p{^Is_Alphabetic=t}', "");
    Expect(0, 201546, '\P{Is_Alphabetic=t}', "");
    Expect(1, 201546, '\P{^Is_Alphabetic=t}', "");
    Expect(0, 201547, '\p{Is_Alphabetic=t}', "");
    Expect(1, 201547, '\p{^Is_Alphabetic=t}', "");
    Expect(1, 201547, '\P{Is_Alphabetic=t}', "");
    Expect(0, 201547, '\P{^Is_Alphabetic=t}', "");
    Expect(1, 201546, '\p{Is_Alphabetic=	_T}', "");
    Expect(0, 201546, '\p{^Is_Alphabetic=	_T}', "");
    Expect(0, 201546, '\P{Is_Alphabetic=	_T}', "");
    Expect(1, 201546, '\P{^Is_Alphabetic=	_T}', "");
    Expect(0, 201547, '\p{Is_Alphabetic=	_T}', "");
    Expect(1, 201547, '\p{^Is_Alphabetic=	_T}', "");
    Expect(1, 201547, '\P{Is_Alphabetic=	_T}', "");
    Expect(0, 201547, '\P{^Is_Alphabetic=	_T}', "");
    Error('\p{Is_Alpha=:=--TRUE}');
    Error('\P{Is_Alpha=:=--TRUE}');
    Expect(1, 201546, '\p{Is_Alpha=true}', "");
    Expect(0, 201546, '\p{^Is_Alpha=true}', "");
    Expect(0, 201546, '\P{Is_Alpha=true}', "");
    Expect(1, 201546, '\P{^Is_Alpha=true}', "");
    Expect(0, 201547, '\p{Is_Alpha=true}', "");
    Expect(1, 201547, '\p{^Is_Alpha=true}', "");
    Expect(1, 201547, '\P{Is_Alpha=true}', "");
    Expect(0, 201547, '\P{^Is_Alpha=true}', "");
    Expect(1, 201546, '\p{Is_Alpha:    -True}', "");
    Expect(0, 201546, '\p{^Is_Alpha:    -True}', "");
    Expect(0, 201546, '\P{Is_Alpha:    -True}', "");
    Expect(1, 201546, '\P{^Is_Alpha:    -True}', "");
    Expect(0, 201547, '\p{Is_Alpha:    -True}', "");
    Expect(1, 201547, '\p{^Is_Alpha:    -True}', "");
    Expect(1, 201547, '\P{Is_Alpha:    -True}', "");
    Expect(0, 201547, '\P{^Is_Alpha:    -True}', "");
    Error('\p{bidiclass}');
    Error('\P{bidiclass}');
    Error('\p{bc}');
    Error('\P{bc}');
    Error('\p{Bidi_Class=	:=ARABIC_Letter}');
    Error('\P{Bidi_Class=	:=ARABIC_Letter}');
    Expect(1, 126719, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class= -arabic_letter}', "");
    Expect(0, 126719, '\p{^Bidi_Class= -arabic_letter}', "");
    Expect(0, 126719, '\P{Bidi_Class= -arabic_letter}', "");
    Expect(1, 126719, '\P{^Bidi_Class= -arabic_letter}', "");
    Expect(0, 126720, '\p{Bidi_Class= -arabic_letter}', "");
    Expect(1, 126720, '\p{^Bidi_Class= -arabic_letter}', "");
    Expect(1, 126720, '\P{Bidi_Class= -arabic_letter}', "");
    Expect(0, 126720, '\P{^Bidi_Class= -arabic_letter}', "");
    Error('\p{Bc= AL/a/}');
    Error('\P{Bc= AL/a/}');
    Expect(1, 126719, '\p{Bc=:\AAL\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\AAL\z:}', "");;
    Expect(1, 126719, '\p{Bc=al}', "");
    Expect(0, 126719, '\p{^Bc=al}', "");
    Expect(0, 126719, '\P{Bc=al}', "");
    Expect(1, 126719, '\P{^Bc=al}', "");
    Expect(0, 126720, '\p{Bc=al}', "");
    Expect(1, 126720, '\p{^Bc=al}', "");
    Expect(1, 126720, '\P{Bc=al}', "");
    Expect(0, 126720, '\P{^Bc=al}', "");
    Expect(1, 126719, '\p{Bc=:\Aal\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\Aal\z:}', "");;
    Expect(1, 126719, '\p{Bc=- al}', "");
    Expect(0, 126719, '\p{^Bc=- al}', "");
    Expect(0, 126719, '\P{Bc=- al}', "");
    Expect(1, 126719, '\P{^Bc=- al}', "");
    Expect(0, 126720, '\p{Bc=- al}', "");
    Expect(1, 126720, '\p{^Bc=- al}', "");
    Expect(1, 126720, '\P{Bc=- al}', "");
    Expect(0, 126720, '\P{^Bc=- al}', "");
    Error('\p{Is_Bidi_Class=:=	 ARABIC_letter}');
    Error('\P{Is_Bidi_Class=:=	 ARABIC_letter}');
    Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class= 	ARABIC_Letter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class= 	ARABIC_Letter}', "");
    Error('\p{Is_Bc=:=-AL}');
    Error('\P{Is_Bc=:=-AL}');
    Expect(1, 126719, '\p{Is_Bc=al}', "");
    Expect(0, 126719, '\p{^Is_Bc=al}', "");
    Expect(0, 126719, '\P{Is_Bc=al}', "");
    Expect(1, 126719, '\P{^Is_Bc=al}', "");
    Expect(0, 126720, '\p{Is_Bc=al}', "");
    Expect(1, 126720, '\p{^Is_Bc=al}', "");
    Expect(1, 126720, '\P{Is_Bc=al}', "");
    Expect(0, 126720, '\P{^Is_Bc=al}', "");
    Expect(1, 126719, '\p{Is_Bc:  	al}', "");
    Expect(0, 126719, '\p{^Is_Bc:  	al}', "");
    Expect(0, 126719, '\P{Is_Bc:  	al}', "");
    Expect(1, 126719, '\P{^Is_Bc:  	al}', "");
    Expect(0, 126720, '\p{Is_Bc:  	al}', "");
    Expect(1, 126720, '\p{^Is_Bc:  	al}', "");
    Expect(1, 126720, '\P{Is_Bc:  	al}', "");
    Expect(0, 126720, '\P{^Is_Bc:  	al}', "");
    Error('\p{Bidi_Class=_ arabic_NUMBER/a/}');
    Error('\P{Bidi_Class=_ arabic_NUMBER/a/}');
    Expect(1, 69246, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=arabic_Number}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabic_Number}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabic_Number}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabic_Number}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabic_Number}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabic_Number}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabic_Number}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabic_Number}', "");
    Error('\p{Bc=-	AN/a/}');
    Error('\P{Bc=-	AN/a/}');
    Expect(1, 69246, '\p{Bc=:\AAN\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\AAN\z:}', "");;
    Expect(1, 69246, '\p{Bc=an}', "");
    Expect(0, 69246, '\p{^Bc=an}', "");
    Expect(0, 69246, '\P{Bc=an}', "");
    Expect(1, 69246, '\P{^Bc=an}', "");
    Expect(0, 69247, '\p{Bc=an}', "");
    Expect(1, 69247, '\p{^Bc=an}', "");
    Expect(1, 69247, '\P{Bc=an}', "");
    Expect(0, 69247, '\P{^Bc=an}', "");
    Expect(1, 69246, '\p{Bc=:\Aan\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\Aan\z:}', "");;
    Expect(1, 69246, '\p{Bc:   __an}', "");
    Expect(0, 69246, '\p{^Bc:   __an}', "");
    Expect(0, 69246, '\P{Bc:   __an}', "");
    Expect(1, 69246, '\P{^Bc:   __an}', "");
    Expect(0, 69247, '\p{Bc:   __an}', "");
    Expect(1, 69247, '\p{^Bc:   __an}', "");
    Expect(1, 69247, '\P{Bc:   __an}', "");
    Expect(0, 69247, '\P{^Bc:   __an}', "");
    Error('\p{Is_Bidi_Class=/a/_ arabic_Number}');
    Error('\P{Is_Bidi_Class=/a/_ arabic_Number}');
    Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Is_Bidi_Class:   -arabic_Number}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class:   -arabic_Number}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class:   -arabic_Number}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class:   -arabic_Number}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class:   -arabic_Number}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class:   -arabic_Number}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class:   -arabic_Number}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class:   -arabic_Number}', "");
    Error('\p{Is_Bc=	/a/an}');
    Error('\P{Is_Bc=	/a/an}');
    Expect(1, 69246, '\p{Is_Bc=an}', "");
    Expect(0, 69246, '\p{^Is_Bc=an}', "");
    Expect(0, 69246, '\P{Is_Bc=an}', "");
    Expect(1, 69246, '\P{^Is_Bc=an}', "");
    Expect(0, 69247, '\p{Is_Bc=an}', "");
    Expect(1, 69247, '\p{^Is_Bc=an}', "");
    Expect(1, 69247, '\P{Is_Bc=an}', "");
    Expect(0, 69247, '\P{^Is_Bc=an}', "");
    Expect(1, 69246, '\p{Is_Bc=_AN}', "");
    Expect(0, 69246, '\p{^Is_Bc=_AN}', "");
    Expect(0, 69246, '\P{Is_Bc=_AN}', "");
    Expect(1, 69246, '\P{^Is_Bc=_AN}', "");
    Expect(0, 69247, '\p{Is_Bc=_AN}', "");
    Expect(1, 69247, '\p{^Is_Bc=_AN}', "");
    Expect(1, 69247, '\P{Is_Bc=_AN}', "");
    Expect(0, 69247, '\P{^Is_Bc=_AN}', "");
    Error('\p{Bidi_Class=/a/  Paragraph_Separator}');
    Error('\P{Bidi_Class=/a/  Paragraph_Separator}');
    Expect(1, 8233, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class:   		Paragraph_separator}', "");
    Expect(0, 8233, '\p{^Bidi_Class:   		Paragraph_separator}', "");
    Expect(0, 8233, '\P{Bidi_Class:   		Paragraph_separator}', "");
    Expect(1, 8233, '\P{^Bidi_Class:   		Paragraph_separator}', "");
    Expect(0, 8234, '\p{Bidi_Class:   		Paragraph_separator}', "");
    Expect(1, 8234, '\p{^Bidi_Class:   		Paragraph_separator}', "");
    Expect(1, 8234, '\P{Bidi_Class:   		Paragraph_separator}', "");
    Expect(0, 8234, '\P{^Bidi_Class:   		Paragraph_separator}', "");
    Error('\p{Bc=/a/B}');
    Error('\P{Bc=/a/B}');
    Expect(1, 8233, '\p{Bc=:\AB\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\AB\z:}', "");;
    Expect(1, 8233, '\p{Bc=b}', "");
    Expect(0, 8233, '\p{^Bc=b}', "");
    Expect(0, 8233, '\P{Bc=b}', "");
    Expect(1, 8233, '\P{^Bc=b}', "");
    Expect(0, 8234, '\p{Bc=b}', "");
    Expect(1, 8234, '\p{^Bc=b}', "");
    Expect(1, 8234, '\P{Bc=b}', "");
    Expect(0, 8234, '\P{^Bc=b}', "");
    Expect(1, 8233, '\p{Bc=:\Ab\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\Ab\z:}', "");;
    Expect(1, 8233, '\p{Bc=	B}', "");
    Expect(0, 8233, '\p{^Bc=	B}', "");
    Expect(0, 8233, '\P{Bc=	B}', "");
    Expect(1, 8233, '\P{^Bc=	B}', "");
    Expect(0, 8234, '\p{Bc=	B}', "");
    Expect(1, 8234, '\p{^Bc=	B}', "");
    Expect(1, 8234, '\P{Bc=	B}', "");
    Expect(0, 8234, '\P{^Bc=	B}', "");
    Error('\p{Is_Bidi_Class=_Paragraph_SEPARATOR/a/}');
    Error('\P{Is_Bidi_Class=_Paragraph_SEPARATOR/a/}');
    Expect(1, 8233, '\p{Is_Bidi_Class: paragraphseparator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class: paragraphseparator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class: paragraphseparator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class: paragraphseparator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class: paragraphseparator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class: paragraphseparator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class: paragraphseparator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class: paragraphseparator}', "");
    Expect(1, 8233, '\p{Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=PARAGRAPH_separator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=PARAGRAPH_separator}', "");
    Error('\p{Is_Bc=:=  B}');
    Error('\P{Is_Bc=:=  B}');
    Expect(1, 8233, '\p{Is_Bc=b}', "");
    Expect(0, 8233, '\p{^Is_Bc=b}', "");
    Expect(0, 8233, '\P{Is_Bc=b}', "");
    Expect(1, 8233, '\P{^Is_Bc=b}', "");
    Expect(0, 8234, '\p{Is_Bc=b}', "");
    Expect(1, 8234, '\p{^Is_Bc=b}', "");
    Expect(1, 8234, '\P{Is_Bc=b}', "");
    Expect(0, 8234, '\P{^Is_Bc=b}', "");
    Expect(1, 8233, '\p{Is_Bc=_B}', "");
    Expect(0, 8233, '\p{^Is_Bc=_B}', "");
    Expect(0, 8233, '\P{Is_Bc=_B}', "");
    Expect(1, 8233, '\P{^Is_Bc=_B}', "");
    Expect(0, 8234, '\p{Is_Bc=_B}', "");
    Expect(1, 8234, '\p{^Is_Bc=_B}', "");
    Expect(1, 8234, '\P{Is_Bc=_B}', "");
    Expect(0, 8234, '\P{^Is_Bc=_B}', "");
    Error('\p{Bidi_Class=:=__boundary_NEUTRAL}');
    Error('\P{Bidi_Class=:=__boundary_NEUTRAL}');
    Expect(1, 921599, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=	 BOUNDARY_Neutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=	 BOUNDARY_Neutral}', "");
    Error('\p{Bc= /a/BN}');
    Error('\P{Bc= /a/BN}');
    Expect(1, 921599, '\p{Bc=:\ABN\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\ABN\z:}', "");;
    Expect(1, 921599, '\p{Bc=bn}', "");
    Expect(0, 921599, '\p{^Bc=bn}', "");
    Expect(0, 921599, '\P{Bc=bn}', "");
    Expect(1, 921599, '\P{^Bc=bn}', "");
    Expect(0, 1114109, '\p{Bc=bn}', "");
    Expect(1, 1114109, '\p{^Bc=bn}', "");
    Expect(1, 1114109, '\P{Bc=bn}', "");
    Expect(0, 1114109, '\P{^Bc=bn}', "");
    Expect(1, 921599, '\p{Bc=:\Abn\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\Abn\z:}', "");;
    Expect(1, 921599, '\p{Bc=-BN}', "");
    Expect(0, 921599, '\p{^Bc=-BN}', "");
    Expect(0, 921599, '\P{Bc=-BN}', "");
    Expect(1, 921599, '\P{^Bc=-BN}', "");
    Expect(0, 1114109, '\p{Bc=-BN}', "");
    Expect(1, 1114109, '\p{^Bc=-BN}', "");
    Expect(1, 1114109, '\P{Bc=-BN}', "");
    Expect(0, 1114109, '\P{^Bc=-BN}', "");
    Error('\p{Is_Bidi_Class= Boundary_Neutral:=}');
    Error('\P{Is_Bidi_Class= Boundary_Neutral:=}');
    Expect(1, 921599, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=	boundary_Neutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=	boundary_Neutral}', "");
    Error('\p{Is_Bc=-:=BN}');
    Error('\P{Is_Bc=-:=BN}');
    Expect(1, 921599, '\p{Is_Bc=bn}', "");
    Expect(0, 921599, '\p{^Is_Bc=bn}', "");
    Expect(0, 921599, '\P{Is_Bc=bn}', "");
    Expect(1, 921599, '\P{^Is_Bc=bn}', "");
    Expect(0, 1114109, '\p{Is_Bc=bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
    Expect(1, 1114109, '\P{Is_Bc=bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
    Expect(1, 921599, '\p{Is_Bc= -BN}', "");
    Expect(0, 921599, '\p{^Is_Bc= -BN}', "");
    Expect(0, 921599, '\P{Is_Bc= -BN}', "");
    Expect(1, 921599, '\P{^Is_Bc= -BN}', "");
    Expect(0, 1114109, '\p{Is_Bc= -BN}', "");
    Expect(1, 1114109, '\p{^Is_Bc= -BN}', "");
    Expect(1, 1114109, '\P{Is_Bc= -BN}', "");
    Expect(0, 1114109, '\P{^Is_Bc= -BN}', "");
    Error('\p{Bidi_Class=-:=Common_Separator}');
    Error('\P{Bidi_Class=-:=Common_Separator}');
    Expect(1, 65306, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class:   --Common_Separator}', "");
    Expect(0, 65306, '\p{^Bidi_Class:   --Common_Separator}', "");
    Expect(0, 65306, '\P{Bidi_Class:   --Common_Separator}', "");
    Expect(1, 65306, '\P{^Bidi_Class:   --Common_Separator}', "");
    Expect(0, 65307, '\p{Bidi_Class:   --Common_Separator}', "");
    Expect(1, 65307, '\p{^Bidi_Class:   --Common_Separator}', "");
    Expect(1, 65307, '\P{Bidi_Class:   --Common_Separator}', "");
    Expect(0, 65307, '\P{^Bidi_Class:   --Common_Separator}', "");
    Error('\p{Bc=	CS:=}');
    Error('\P{Bc=	CS:=}');
    Expect(1, 65306, '\p{Bc=:\ACS\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\ACS\z:}', "");;
    Expect(1, 65306, '\p{Bc:cs}', "");
    Expect(0, 65306, '\p{^Bc:cs}', "");
    Expect(0, 65306, '\P{Bc:cs}', "");
    Expect(1, 65306, '\P{^Bc:cs}', "");
    Expect(0, 65307, '\p{Bc:cs}', "");
    Expect(1, 65307, '\p{^Bc:cs}', "");
    Expect(1, 65307, '\P{Bc:cs}', "");
    Expect(0, 65307, '\P{^Bc:cs}', "");
    Expect(1, 65306, '\p{Bc=:\Acs\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\Acs\z:}', "");;
    Error('\p{Is_Bidi_Class=/a/ _Common_separator}');
    Error('\P{Is_Bidi_Class=/a/ _Common_separator}');
    Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Is_Bidi_Class=- Common_separator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=- Common_separator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=- Common_separator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=- Common_separator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=- Common_separator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=- Common_separator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=- Common_separator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=- Common_separator}', "");
    Error('\p{Is_Bc=_CS:=}');
    Error('\P{Is_Bc=_CS:=}');
    Expect(1, 65306, '\p{Is_Bc=cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=cs}', "");
    Expect(0, 65306, '\P{Is_Bc=cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=cs}', "");
    Expect(0, 65307, '\p{Is_Bc=cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=cs}', "");
    Expect(1, 65307, '\P{Is_Bc=cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=cs}', "");
    Expect(1, 65306, '\p{Is_Bc=_cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=_cs}', "");
    Expect(0, 65306, '\P{Is_Bc=_cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=_cs}', "");
    Expect(0, 65307, '\p{Is_Bc=_cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=_cs}', "");
    Expect(1, 65307, '\P{Is_Bc=_cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=_cs}', "");
    Error('\p{Bidi_Class=-/a/European_NUMBER}');
    Error('\P{Bidi_Class=-/a/European_NUMBER}');
    Expect(1, 130041, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\p{^Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\P{Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\P{^Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\p{Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\p{^Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\P{Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\P{^Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 130041, '\p{^Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 130041, '\P{Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 130041, '\P{^Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 130042, '\p{Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 130042, '\p{^Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(1, 130042, '\P{Bidi_Class=_-EUROPEAN_Number}', "");
    Expect(0, 130042, '\P{^Bidi_Class=_-EUROPEAN_Number}', "");
    Error('\p{Bc=--en/a/}');
    Error('\P{Bc=--en/a/}');
    Expect(1, 130041, '\p{Bc=:\AEN\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\AEN\z:}', "");;
    Expect(1, 130041, '\p{Bc=en}', "");
    Expect(0, 130041, '\p{^Bc=en}', "");
    Expect(0, 130041, '\P{Bc=en}', "");
    Expect(1, 130041, '\P{^Bc=en}', "");
    Expect(0, 130042, '\p{Bc=en}', "");
    Expect(1, 130042, '\p{^Bc=en}', "");
    Expect(1, 130042, '\P{Bc=en}', "");
    Expect(0, 130042, '\P{^Bc=en}', "");
    Expect(1, 130041, '\p{Bc=:\Aen\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\Aen\z:}', "");;
    Expect(1, 130041, '\p{Bc=	EN}', "");
    Expect(0, 130041, '\p{^Bc=	EN}', "");
    Expect(0, 130041, '\P{Bc=	EN}', "");
    Expect(1, 130041, '\P{^Bc=	EN}', "");
    Expect(0, 130042, '\p{Bc=	EN}', "");
    Expect(1, 130042, '\p{^Bc=	EN}', "");
    Expect(1, 130042, '\P{Bc=	EN}', "");
    Expect(0, 130042, '\P{^Bc=	EN}', "");
    Error('\p{Is_Bidi_Class=	-European_number:=}');
    Error('\P{Is_Bidi_Class=	-European_number:=}');
    Expect(1, 130041, '\p{Is_Bidi_Class:europeannumber}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class:europeannumber}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class:europeannumber}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class:europeannumber}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class:europeannumber}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class:europeannumber}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class:europeannumber}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class:europeannumber}', "");
    Expect(1, 130041, '\p{Is_Bidi_Class=- European_Number}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class=- European_Number}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class=- European_Number}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class=- European_Number}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class=- European_Number}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class=- European_Number}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class=- European_Number}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class=- European_Number}', "");
    Error('\p{Is_Bc=	/a/EN}');
    Error('\P{Is_Bc=	/a/EN}');
    Expect(1, 130041, '\p{Is_Bc=en}', "");
    Expect(0, 130041, '\p{^Is_Bc=en}', "");
    Expect(0, 130041, '\P{Is_Bc=en}', "");
    Expect(1, 130041, '\P{^Is_Bc=en}', "");
    Expect(0, 130042, '\p{Is_Bc=en}', "");
    Expect(1, 130042, '\p{^Is_Bc=en}', "");
    Expect(1, 130042, '\P{Is_Bc=en}', "");
    Expect(0, 130042, '\P{^Is_Bc=en}', "");
    Expect(1, 130041, '\p{Is_Bc=_-EN}', "");
    Expect(0, 130041, '\p{^Is_Bc=_-EN}', "");
    Expect(0, 130041, '\P{Is_Bc=_-EN}', "");
    Expect(1, 130041, '\P{^Is_Bc=_-EN}', "");
    Expect(0, 130042, '\p{Is_Bc=_-EN}', "");
    Expect(1, 130042, '\p{^Is_Bc=_-EN}', "");
    Expect(1, 130042, '\P{Is_Bc=_-EN}', "");
    Expect(0, 130042, '\P{^Is_Bc=_-EN}', "");
    Error('\p{Bidi_Class=/a/_-European_Separator}');
    Error('\P{Bidi_Class=/a/_-European_Separator}');
    Expect(1, 65293, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=	-european_separator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=	-european_separator}', "");
    Expect(0, 65293, '\P{Bidi_Class=	-european_separator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=	-european_separator}', "");
    Expect(0, 65294, '\p{Bidi_Class=	-european_separator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=	-european_separator}', "");
    Expect(1, 65294, '\P{Bidi_Class=	-european_separator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=	-european_separator}', "");
    Error('\p{Bc:-:=ES}');
    Error('\P{Bc:-:=ES}');
    Expect(1, 65293, '\p{Bc=:\AES\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\AES\z:}', "");;
    Expect(1, 65293, '\p{Bc=es}', "");
    Expect(0, 65293, '\p{^Bc=es}', "");
    Expect(0, 65293, '\P{Bc=es}', "");
    Expect(1, 65293, '\P{^Bc=es}', "");
    Expect(0, 65294, '\p{Bc=es}', "");
    Expect(1, 65294, '\p{^Bc=es}', "");
    Expect(1, 65294, '\P{Bc=es}', "");
    Expect(0, 65294, '\P{^Bc=es}', "");
    Expect(1, 65293, '\p{Bc=:\Aes\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\Aes\z:}', "");;
    Expect(1, 65293, '\p{Bc=	_ES}', "");
    Expect(0, 65293, '\p{^Bc=	_ES}', "");
    Expect(0, 65293, '\P{Bc=	_ES}', "");
    Expect(1, 65293, '\P{^Bc=	_ES}', "");
    Expect(0, 65294, '\p{Bc=	_ES}', "");
    Expect(1, 65294, '\p{^Bc=	_ES}', "");
    Expect(1, 65294, '\P{Bc=	_ES}', "");
    Expect(0, 65294, '\P{^Bc=	_ES}', "");
    Error('\p{Is_Bidi_Class=/a/__EUROPEAN_separator}');
    Error('\P{Is_Bidi_Class=/a/__EUROPEAN_separator}');
    Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Is_Bidi_Class=	 european_separator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=	 european_separator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=	 european_separator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=	 european_separator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=	 european_separator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=	 european_separator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=	 european_separator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=	 european_separator}', "");
    Error('\p{Is_Bc=_:=ES}');
    Error('\P{Is_Bc=_:=ES}');
    Expect(1, 65293, '\p{Is_Bc:   es}', "");
    Expect(0, 65293, '\p{^Is_Bc:   es}', "");
    Expect(0, 65293, '\P{Is_Bc:   es}', "");
    Expect(1, 65293, '\P{^Is_Bc:   es}', "");
    Expect(0, 65294, '\p{Is_Bc:   es}', "");
    Expect(1, 65294, '\p{^Is_Bc:   es}', "");
    Expect(1, 65294, '\P{Is_Bc:   es}', "");
    Expect(0, 65294, '\P{^Is_Bc:   es}', "");
    Expect(1, 65293, '\p{Is_Bc= _ES}', "");
    Expect(0, 65293, '\p{^Is_Bc= _ES}', "");
    Expect(0, 65293, '\P{Is_Bc= _ES}', "");
    Expect(1, 65293, '\P{^Is_Bc= _ES}', "");
    Expect(0, 65294, '\p{Is_Bc= _ES}', "");
    Expect(1, 65294, '\p{^Is_Bc= _ES}', "");
    Expect(1, 65294, '\P{Is_Bc= _ES}', "");
    Expect(0, 65294, '\P{^Is_Bc= _ES}', "");
    Error('\p{Bidi_Class= :=European_terminator}');
    Error('\P{Bidi_Class= :=European_terminator}');
    Expect(1, 123647, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=-	European_Terminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=-	European_Terminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=-	European_Terminator}', "");
    Error('\p{Bc=	ET/a/}');
    Error('\P{Bc=	ET/a/}');
    Expect(1, 123647, '\p{Bc=:\AET\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\AET\z:}', "");;
    Expect(1, 123647, '\p{Bc=et}', "");
    Expect(0, 123647, '\p{^Bc=et}', "");
    Expect(0, 123647, '\P{Bc=et}', "");
    Expect(1, 123647, '\P{^Bc=et}', "");
    Expect(0, 123648, '\p{Bc=et}', "");
    Expect(1, 123648, '\p{^Bc=et}', "");
    Expect(1, 123648, '\P{Bc=et}', "");
    Expect(0, 123648, '\P{^Bc=et}', "");
    Expect(1, 123647, '\p{Bc=:\Aet\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\Aet\z:}', "");;
    Expect(1, 123647, '\p{Bc=  et}', "");
    Expect(0, 123647, '\p{^Bc=  et}', "");
    Expect(0, 123647, '\P{Bc=  et}', "");
    Expect(1, 123647, '\P{^Bc=  et}', "");
    Expect(0, 123648, '\p{Bc=  et}', "");
    Expect(1, 123648, '\p{^Bc=  et}', "");
    Expect(1, 123648, '\P{Bc=  et}', "");
    Expect(0, 123648, '\P{^Bc=  et}', "");
    Error('\p{Is_Bidi_Class=:=	european_Terminator}');
    Error('\P{Is_Bidi_Class=:=	european_Terminator}');
    Expect(1, 123647, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Is_Bidi_Class=-European_Terminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=-European_Terminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=-European_Terminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=-European_Terminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=-European_Terminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=-European_Terminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=-European_Terminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=-European_Terminator}', "");
    Error('\p{Is_Bc=/a/	ET}');
    Error('\P{Is_Bc=/a/	ET}');
    Expect(1, 123647, '\p{Is_Bc=et}', "");
    Expect(0, 123647, '\p{^Is_Bc=et}', "");
    Expect(0, 123647, '\P{Is_Bc=et}', "");
    Expect(1, 123647, '\P{^Is_Bc=et}', "");
    Expect(0, 123648, '\p{Is_Bc=et}', "");
    Expect(1, 123648, '\p{^Is_Bc=et}', "");
    Expect(1, 123648, '\P{Is_Bc=et}', "");
    Expect(0, 123648, '\P{^Is_Bc=et}', "");
    Expect(1, 123647, '\p{Is_Bc=- ET}', "");
    Expect(0, 123647, '\p{^Is_Bc=- ET}', "");
    Expect(0, 123647, '\P{Is_Bc=- ET}', "");
    Expect(1, 123647, '\P{^Is_Bc=- ET}', "");
    Expect(0, 123648, '\p{Is_Bc=- ET}', "");
    Expect(1, 123648, '\p{^Is_Bc=- ET}', "");
    Expect(1, 123648, '\P{Is_Bc=- ET}', "");
    Expect(0, 123648, '\P{^Is_Bc=- ET}', "");
    Error('\p{Bidi_Class=-First_STRONG_Isolate:=}');
    Error('\P{Bidi_Class=-First_STRONG_Isolate:=}');
    Expect(1, 8296, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=_first_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=_first_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=_first_Strong_Isolate}', "");
    Error('\p{Bc=	:=FSI}');
    Error('\P{Bc=	:=FSI}');
    Expect(1, 8296, '\p{Bc=:\AFSI\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\AFSI\z:}', "");;
    Expect(1, 8296, '\p{Bc=fsi}', "");
    Expect(0, 8296, '\p{^Bc=fsi}', "");
    Expect(0, 8296, '\P{Bc=fsi}', "");
    Expect(1, 8296, '\P{^Bc=fsi}', "");
    Expect(0, 8297, '\p{Bc=fsi}', "");
    Expect(1, 8297, '\p{^Bc=fsi}', "");
    Expect(1, 8297, '\P{Bc=fsi}', "");
    Expect(0, 8297, '\P{^Bc=fsi}', "");
    Expect(1, 8296, '\p{Bc=:\Afsi\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\Afsi\z:}', "");;
    Expect(1, 8296, '\p{Bc=_-FSI}', "");
    Expect(0, 8296, '\p{^Bc=_-FSI}', "");
    Expect(0, 8296, '\P{Bc=_-FSI}', "");
    Expect(1, 8296, '\P{^Bc=_-FSI}', "");
    Expect(0, 8297, '\p{Bc=_-FSI}', "");
    Expect(1, 8297, '\p{^Bc=_-FSI}', "");
    Expect(1, 8297, '\P{Bc=_-FSI}', "");
    Expect(0, 8297, '\P{^Bc=_-FSI}', "");
    Error('\p{Is_Bidi_Class= 	FIRST_Strong_Isolate/a/}');
    Error('\P{Is_Bidi_Class= 	FIRST_Strong_Isolate/a/}');
    Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=- First_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=- First_Strong_Isolate}', "");
    Error('\p{Is_Bc=_ FSI:=}');
    Error('\P{Is_Bc=_ FSI:=}');
    Expect(1, 8296, '\p{Is_Bc=fsi}', "");
    Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
    Expect(0, 8296, '\P{Is_Bc=fsi}', "");
    Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
    Expect(0, 8297, '\p{Is_Bc=fsi}', "");
    Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
    Expect(1, 8297, '\P{Is_Bc=fsi}', "");
    Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
    Expect(1, 8296, '\p{Is_Bc=	 FSI}', "");
    Expect(0, 8296, '\p{^Is_Bc=	 FSI}', "");
    Expect(0, 8296, '\P{Is_Bc=	 FSI}', "");
    Expect(1, 8296, '\P{^Is_Bc=	 FSI}', "");
    Expect(0, 8297, '\p{Is_Bc=	 FSI}', "");
    Expect(1, 8297, '\p{^Is_Bc=	 FSI}', "");
    Expect(1, 8297, '\P{Is_Bc=	 FSI}', "");
    Expect(0, 8297, '\P{^Is_Bc=	 FSI}', "");
    Error('\p{Bidi_Class=/a/-_Left_to_Right}');
    Error('\P{Bidi_Class=/a/-_Left_to_Right}');
    Expect(1, 1114109, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 1114109, '\p{^Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 1114109, '\P{Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 1114109, '\P{^Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 921599, '\p{Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 921599, '\p{^Bidi_Class: _-LEFT_To_right}', "");
    Expect(1, 921599, '\P{Bidi_Class: _-LEFT_To_right}', "");
    Expect(0, 921599, '\P{^Bidi_Class: _-LEFT_To_right}', "");
    Error('\p{Bc:_/a/l}');
    Error('\P{Bc:_/a/l}');
    Expect(1, 1114109, '\p{Bc=:\AL\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\AL\z:}', "");;
    Expect(1, 1114109, '\p{Bc=l}', "");
    Expect(0, 1114109, '\p{^Bc=l}', "");
    Expect(0, 1114109, '\P{Bc=l}', "");
    Expect(1, 1114109, '\P{^Bc=l}', "");
    Expect(0, 921599, '\p{Bc=l}', "");
    Expect(1, 921599, '\p{^Bc=l}', "");
    Expect(1, 921599, '\P{Bc=l}', "");
    Expect(0, 921599, '\P{^Bc=l}', "");
    Expect(1, 1114109, '\p{Bc=:\Al\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\Al\z:}', "");;
    Expect(1, 1114109, '\p{Bc= _L}', "");
    Expect(0, 1114109, '\p{^Bc= _L}', "");
    Expect(0, 1114109, '\P{Bc= _L}', "");
    Expect(1, 1114109, '\P{^Bc= _L}', "");
    Expect(0, 921599, '\p{Bc= _L}', "");
    Expect(1, 921599, '\p{^Bc= _L}', "");
    Expect(1, 921599, '\P{Bc= _L}', "");
    Expect(0, 921599, '\P{^Bc= _L}', "");
    Error('\p{Is_Bidi_Class= /a/left_to_right}');
    Error('\P{Is_Bidi_Class= /a/left_to_right}');
    Expect(1, 1114109, '\p{Is_Bidi_Class:lefttoright}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class:lefttoright}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class:lefttoright}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class:lefttoright}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class:lefttoright}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class:lefttoright}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class:lefttoright}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class:lefttoright}', "");
    Expect(1, 1114109, '\p{Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class:   LEFT_to_RIGHT}', "");
    Error('\p{Is_Bc=-:=l}');
    Error('\P{Is_Bc=-:=l}');
    Expect(1, 1114109, '\p{Is_Bc: l}', "");
    Expect(0, 1114109, '\p{^Is_Bc: l}', "");
    Expect(0, 1114109, '\P{Is_Bc: l}', "");
    Expect(1, 1114109, '\P{^Is_Bc: l}', "");
    Expect(0, 921599, '\p{Is_Bc: l}', "");
    Expect(1, 921599, '\p{^Is_Bc: l}', "");
    Expect(1, 921599, '\P{Is_Bc: l}', "");
    Expect(0, 921599, '\P{^Is_Bc: l}', "");
    Expect(1, 1114109, '\p{Is_Bc=-l}', "");
    Expect(0, 1114109, '\p{^Is_Bc=-l}', "");
    Expect(0, 1114109, '\P{Is_Bc=-l}', "");
    Expect(1, 1114109, '\P{^Is_Bc=-l}', "");
    Expect(0, 921599, '\p{Is_Bc=-l}', "");
    Expect(1, 921599, '\p{^Is_Bc=-l}', "");
    Expect(1, 921599, '\P{Is_Bc=-l}', "");
    Expect(0, 921599, '\P{^Is_Bc=-l}', "");
    Error('\p{Bidi_Class: -left_TO_right_embedding:=}');
    Error('\P{Bidi_Class: -left_TO_right_embedding:=}');
    Expect(1, 8234, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class: lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class: lefttorightembedding}', "");
    Expect(0, 8234, '\P{Bidi_Class: lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class: lefttorightembedding}', "");
    Expect(0, 8235, '\p{Bidi_Class: lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class: lefttorightembedding}', "");
    Expect(1, 8235, '\P{Bidi_Class: lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class: lefttorightembedding}', "");
    Expect(1, 8234, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=--Left_To_right_embedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=--Left_To_right_embedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=--Left_To_right_embedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=--Left_To_right_embedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=--Left_To_right_embedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=--Left_To_right_embedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=--Left_To_right_embedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=--Left_To_right_embedding}', "");
    Error('\p{Bc=-/a/LRE}');
    Error('\P{Bc=-/a/LRE}');
    Expect(1, 8234, '\p{Bc=:\ALRE\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\ALRE\z:}', "");;
    Expect(1, 8234, '\p{Bc=lre}', "");
    Expect(0, 8234, '\p{^Bc=lre}', "");
    Expect(0, 8234, '\P{Bc=lre}', "");
    Expect(1, 8234, '\P{^Bc=lre}', "");
    Expect(0, 8235, '\p{Bc=lre}', "");
    Expect(1, 8235, '\p{^Bc=lre}', "");
    Expect(1, 8235, '\P{Bc=lre}', "");
    Expect(0, 8235, '\P{^Bc=lre}', "");
    Expect(1, 8234, '\p{Bc=:\Alre\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\Alre\z:}', "");;
    Expect(1, 8234, '\p{Bc=-	lre}', "");
    Expect(0, 8234, '\p{^Bc=-	lre}', "");
    Expect(0, 8234, '\P{Bc=-	lre}', "");
    Expect(1, 8234, '\P{^Bc=-	lre}', "");
    Expect(0, 8235, '\p{Bc=-	lre}', "");
    Expect(1, 8235, '\p{^Bc=-	lre}', "");
    Expect(1, 8235, '\P{Bc=-	lre}', "");
    Expect(0, 8235, '\P{^Bc=-	lre}', "");
    Error('\p{Is_Bidi_Class=LEFT_to_RIGHT_EMBEDDING:=}');
    Error('\P{Is_Bidi_Class=LEFT_to_RIGHT_EMBEDDING:=}');
    Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=  Left_To_RIGHT_EMBEDDING}', "");
    Error('\p{Is_Bc=-LRE/a/}');
    Error('\P{Is_Bc=-LRE/a/}');
    Expect(1, 8234, '\p{Is_Bc=lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=lre}', "");
    Expect(0, 8234, '\P{Is_Bc=lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=lre}', "");
    Expect(0, 8235, '\p{Is_Bc=lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=lre}', "");
    Expect(1, 8235, '\P{Is_Bc=lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=lre}', "");
    Expect(1, 8234, '\p{Is_Bc=-	LRE}', "");
    Expect(0, 8234, '\p{^Is_Bc=-	LRE}', "");
    Expect(0, 8234, '\P{Is_Bc=-	LRE}', "");
    Expect(1, 8234, '\P{^Is_Bc=-	LRE}', "");
    Expect(0, 8235, '\p{Is_Bc=-	LRE}', "");
    Expect(1, 8235, '\p{^Is_Bc=-	LRE}', "");
    Expect(1, 8235, '\P{Is_Bc=-	LRE}', "");
    Expect(0, 8235, '\P{^Is_Bc=-	LRE}', "");
    Error('\p{Bidi_Class=/a/ -left_To_RIGHT_ISOLATE}');
    Error('\P{Bidi_Class=/a/ -left_To_RIGHT_ISOLATE}');
    Expect(1, 8294, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(0, 8294, '\P{Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(0, 8295, '\p{Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(1, 8295, '\P{Bidi_Class:  _Left_TO_Right_isolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class:  _Left_TO_Right_isolate}', "");
    Error('\p{Bc= :=LRI}');
    Error('\P{Bc= :=LRI}');
    Expect(1, 8294, '\p{Bc=:\ALRI\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\ALRI\z:}', "");;
    Expect(1, 8294, '\p{Bc=lri}', "");
    Expect(0, 8294, '\p{^Bc=lri}', "");
    Expect(0, 8294, '\P{Bc=lri}', "");
    Expect(1, 8294, '\P{^Bc=lri}', "");
    Expect(0, 8295, '\p{Bc=lri}', "");
    Expect(1, 8295, '\p{^Bc=lri}', "");
    Expect(1, 8295, '\P{Bc=lri}', "");
    Expect(0, 8295, '\P{^Bc=lri}', "");
    Expect(1, 8294, '\p{Bc=:\Alri\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\Alri\z:}', "");;
    Expect(1, 8294, '\p{Bc=-lri}', "");
    Expect(0, 8294, '\p{^Bc=-lri}', "");
    Expect(0, 8294, '\P{Bc=-lri}', "");
    Expect(1, 8294, '\P{^Bc=-lri}', "");
    Expect(0, 8295, '\p{Bc=-lri}', "");
    Expect(1, 8295, '\p{^Bc=-lri}', "");
    Expect(1, 8295, '\P{Bc=-lri}', "");
    Expect(0, 8295, '\P{^Bc=-lri}', "");
    Error('\p{Is_Bidi_Class:	/a/_Left_To_Right_Isolate}');
    Error('\P{Is_Bidi_Class:	/a/_Left_To_Right_Isolate}');
    Expect(1, 8294, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=_	left_TO_right_ISOLATE}', "");
    Error('\p{Is_Bc=_/a/lri}');
    Error('\P{Is_Bc=_/a/lri}');
    Expect(1, 8294, '\p{Is_Bc=lri}', "");
    Expect(0, 8294, '\p{^Is_Bc=lri}', "");
    Expect(0, 8294, '\P{Is_Bc=lri}', "");
    Expect(1, 8294, '\P{^Is_Bc=lri}', "");
    Expect(0, 8295, '\p{Is_Bc=lri}', "");
    Expect(1, 8295, '\p{^Is_Bc=lri}', "");
    Expect(1, 8295, '\P{Is_Bc=lri}', "");
    Expect(0, 8295, '\P{^Is_Bc=lri}', "");
    Expect(1, 8294, '\p{Is_Bc=		lri}', "");
    Expect(0, 8294, '\p{^Is_Bc=		lri}', "");
    Expect(0, 8294, '\P{Is_Bc=		lri}', "");
    Expect(1, 8294, '\P{^Is_Bc=		lri}', "");
    Expect(0, 8295, '\p{Is_Bc=		lri}', "");
    Expect(1, 8295, '\p{^Is_Bc=		lri}', "");
    Expect(1, 8295, '\P{Is_Bc=		lri}', "");
    Expect(0, 8295, '\P{^Is_Bc=		lri}', "");
    Error('\p{Bidi_Class=_-LEFT_TO_right_OVERRIDE:=}');
    Error('\P{Bidi_Class=_-LEFT_TO_right_OVERRIDE:=}');
    Expect(1, 8237, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(0, 8237, '\p{^Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(0, 8237, '\P{Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(1, 8237, '\P{^Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(0, 8238, '\p{Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(1, 8238, '\p{^Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(1, 8238, '\P{Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Expect(0, 8238, '\P{^Bidi_Class=_	LEFT_TO_RIGHT_OVERRIDE}', "");
    Error('\p{Bc= /a/LRO}');
    Error('\P{Bc= /a/LRO}');
    Expect(1, 8237, '\p{Bc=:\ALRO\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\ALRO\z:}', "");;
    Expect(1, 8237, '\p{Bc=lro}', "");
    Expect(0, 8237, '\p{^Bc=lro}', "");
    Expect(0, 8237, '\P{Bc=lro}', "");
    Expect(1, 8237, '\P{^Bc=lro}', "");
    Expect(0, 8238, '\p{Bc=lro}', "");
    Expect(1, 8238, '\p{^Bc=lro}', "");
    Expect(1, 8238, '\P{Bc=lro}', "");
    Expect(0, 8238, '\P{^Bc=lro}', "");
    Expect(1, 8237, '\p{Bc=:\Alro\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\Alro\z:}', "");;
    Expect(1, 8237, '\p{Bc=-_LRO}', "");
    Expect(0, 8237, '\p{^Bc=-_LRO}', "");
    Expect(0, 8237, '\P{Bc=-_LRO}', "");
    Expect(1, 8237, '\P{^Bc=-_LRO}', "");
    Expect(0, 8238, '\p{Bc=-_LRO}', "");
    Expect(1, 8238, '\p{^Bc=-_LRO}', "");
    Expect(1, 8238, '\P{Bc=-_LRO}', "");
    Expect(0, 8238, '\P{^Bc=-_LRO}', "");
    Error('\p{Is_Bidi_Class=-:=Left_To_Right_override}');
    Error('\P{Is_Bidi_Class=-:=Left_To_Right_override}');
    Expect(1, 8237, '\p{Is_Bidi_Class: lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class: lefttorightoverride}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class: lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class: lefttorightoverride}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class: lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class: lefttorightoverride}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class: lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class: lefttorightoverride}', "");
    Expect(1, 8237, '\p{Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=	-LEFT_to_Right_OVERRIDE}', "");
    Error('\p{Is_Bc= -lro:=}');
    Error('\P{Is_Bc= -lro:=}');
    Expect(1, 8237, '\p{Is_Bc=lro}', "");
    Expect(0, 8237, '\p{^Is_Bc=lro}', "");
    Expect(0, 8237, '\P{Is_Bc=lro}', "");
    Expect(1, 8237, '\P{^Is_Bc=lro}', "");
    Expect(0, 8238, '\p{Is_Bc=lro}', "");
    Expect(1, 8238, '\p{^Is_Bc=lro}', "");
    Expect(1, 8238, '\P{Is_Bc=lro}', "");
    Expect(0, 8238, '\P{^Is_Bc=lro}', "");
    Expect(1, 8237, '\p{Is_Bc:	 	lro}', "");
    Expect(0, 8237, '\p{^Is_Bc:	 	lro}', "");
    Expect(0, 8237, '\P{Is_Bc:	 	lro}', "");
    Expect(1, 8237, '\P{^Is_Bc:	 	lro}', "");
    Expect(0, 8238, '\p{Is_Bc:	 	lro}', "");
    Expect(1, 8238, '\p{^Is_Bc:	 	lro}', "");
    Expect(1, 8238, '\P{Is_Bc:	 	lro}', "");
    Expect(0, 8238, '\P{^Is_Bc:	 	lro}', "");
    Error('\p{Bidi_Class=	_Nonspacing_mark:=}');
    Error('\P{Bidi_Class=	_Nonspacing_mark:=}');
    Expect(1, 917999, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=	Nonspacing_MARK}', "");
    Expect(0, 917999, '\p{^Bidi_Class=	Nonspacing_MARK}', "");
    Expect(0, 917999, '\P{Bidi_Class=	Nonspacing_MARK}', "");
    Expect(1, 917999, '\P{^Bidi_Class=	Nonspacing_MARK}', "");
    Expect(0, 918000, '\p{Bidi_Class=	Nonspacing_MARK}', "");
    Expect(1, 918000, '\p{^Bidi_Class=	Nonspacing_MARK}', "");
    Expect(1, 918000, '\P{Bidi_Class=	Nonspacing_MARK}', "");
    Expect(0, 918000, '\P{^Bidi_Class=	Nonspacing_MARK}', "");
    Error('\p{Bc:/a/_NSM}');
    Error('\P{Bc:/a/_NSM}');
    Expect(1, 917999, '\p{Bc=:\ANSM\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\ANSM\z:}', "");;
    Expect(1, 917999, '\p{Bc=nsm}', "");
    Expect(0, 917999, '\p{^Bc=nsm}', "");
    Expect(0, 917999, '\P{Bc=nsm}', "");
    Expect(1, 917999, '\P{^Bc=nsm}', "");
    Expect(0, 918000, '\p{Bc=nsm}', "");
    Expect(1, 918000, '\p{^Bc=nsm}', "");
    Expect(1, 918000, '\P{Bc=nsm}', "");
    Expect(0, 918000, '\P{^Bc=nsm}', "");
    Expect(1, 917999, '\p{Bc=:\Ansm\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\Ansm\z:}', "");;
    Expect(1, 917999, '\p{Bc=_	NSM}', "");
    Expect(0, 917999, '\p{^Bc=_	NSM}', "");
    Expect(0, 917999, '\P{Bc=_	NSM}', "");
    Expect(1, 917999, '\P{^Bc=_	NSM}', "");
    Expect(0, 918000, '\p{Bc=_	NSM}', "");
    Expect(1, 918000, '\p{^Bc=_	NSM}', "");
    Expect(1, 918000, '\P{Bc=_	NSM}', "");
    Expect(0, 918000, '\P{^Bc=_	NSM}', "");
    Error('\p{Is_Bidi_Class=:=NONSPACING_mark}');
    Error('\P{Is_Bidi_Class=:=NONSPACING_mark}');
    Expect(1, 917999, '\p{Is_Bidi_Class:   nonspacingmark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class:   nonspacingmark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class:   nonspacingmark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class:   nonspacingmark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class:   nonspacingmark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class:   nonspacingmark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class:   nonspacingmark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class:   nonspacingmark}', "");
    Expect(1, 917999, '\p{Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class=  NONSPACING_mark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class=  NONSPACING_mark}', "");
    Error('\p{Is_Bc=	NSM/a/}');
    Error('\P{Is_Bc=	NSM/a/}');
    Expect(1, 917999, '\p{Is_Bc=nsm}', "");
    Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
    Expect(0, 917999, '\P{Is_Bc=nsm}', "");
    Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
    Expect(0, 918000, '\p{Is_Bc=nsm}', "");
    Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
    Expect(1, 918000, '\P{Is_Bc=nsm}', "");
    Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
    Expect(1, 917999, '\p{Is_Bc=-NSM}', "");
    Expect(0, 917999, '\p{^Is_Bc=-NSM}', "");
    Expect(0, 917999, '\P{Is_Bc=-NSM}', "");
    Expect(1, 917999, '\P{^Is_Bc=-NSM}', "");
    Expect(0, 918000, '\p{Is_Bc=-NSM}', "");
    Expect(1, 918000, '\p{^Is_Bc=-NSM}', "");
    Expect(1, 918000, '\P{Is_Bc=-NSM}', "");
    Expect(0, 918000, '\P{^Is_Bc=-NSM}', "");
    Error('\p{Bidi_Class=-	OTHER_Neutral/a/}');
    Error('\P{Bidi_Class=-	OTHER_Neutral/a/}');
    Expect(1, 129994, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\P{Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\p{Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\P{Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class=	 Other_neutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class=	 Other_neutral}', "");
    Expect(0, 129994, '\P{Bidi_Class=	 Other_neutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class=	 Other_neutral}', "");
    Expect(0, 129995, '\p{Bidi_Class=	 Other_neutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class=	 Other_neutral}', "");
    Expect(1, 129995, '\P{Bidi_Class=	 Other_neutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class=	 Other_neutral}', "");
    Error('\p{Bc=/a/ -ON}');
    Error('\P{Bc=/a/ -ON}');
    Expect(1, 129994, '\p{Bc=:\AON\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\AON\z:}', "");;
    Expect(1, 129994, '\p{Bc=on}', "");
    Expect(0, 129994, '\p{^Bc=on}', "");
    Expect(0, 129994, '\P{Bc=on}', "");
    Expect(1, 129994, '\P{^Bc=on}', "");
    Expect(0, 129995, '\p{Bc=on}', "");
    Expect(1, 129995, '\p{^Bc=on}', "");
    Expect(1, 129995, '\P{Bc=on}', "");
    Expect(0, 129995, '\P{^Bc=on}', "");
    Expect(1, 129994, '\p{Bc=:\Aon\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\Aon\z:}', "");;
    Expect(1, 129994, '\p{Bc=	ON}', "");
    Expect(0, 129994, '\p{^Bc=	ON}', "");
    Expect(0, 129994, '\P{Bc=	ON}', "");
    Expect(1, 129994, '\P{^Bc=	ON}', "");
    Expect(0, 129995, '\p{Bc=	ON}', "");
    Expect(1, 129995, '\p{^Bc=	ON}', "");
    Expect(1, 129995, '\P{Bc=	ON}', "");
    Expect(0, 129995, '\P{^Bc=	ON}', "");
    Error('\p{Is_Bidi_Class=	-OTHER_Neutral/a/}');
    Error('\P{Is_Bidi_Class=	-OTHER_Neutral/a/}');
    Expect(1, 129994, '\p{Is_Bidi_Class:   otherneutral}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class:   otherneutral}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class:   otherneutral}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class:   otherneutral}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class:   otherneutral}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class:   otherneutral}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class:   otherneutral}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class:   otherneutral}', "");
    Expect(1, 129994, '\p{Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class=other_NEUTRAL}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class=other_NEUTRAL}', "");
    Error('\p{Is_Bc= 	ON:=}');
    Error('\P{Is_Bc= 	ON:=}');
    Expect(1, 129994, '\p{Is_Bc:on}', "");
    Expect(0, 129994, '\p{^Is_Bc:on}', "");
    Expect(0, 129994, '\P{Is_Bc:on}', "");
    Expect(1, 129994, '\P{^Is_Bc:on}', "");
    Expect(0, 129995, '\p{Is_Bc:on}', "");
    Expect(1, 129995, '\p{^Is_Bc:on}', "");
    Expect(1, 129995, '\P{Is_Bc:on}', "");
    Expect(0, 129995, '\P{^Is_Bc:on}', "");
    Expect(1, 129994, '\p{Is_Bc:   _ON}', "");
    Expect(0, 129994, '\p{^Is_Bc:   _ON}', "");
    Expect(0, 129994, '\P{Is_Bc:   _ON}', "");
    Expect(1, 129994, '\P{^Is_Bc:   _ON}', "");
    Expect(0, 129995, '\p{Is_Bc:   _ON}', "");
    Expect(1, 129995, '\p{^Is_Bc:   _ON}', "");
    Expect(1, 129995, '\P{Is_Bc:   _ON}', "");
    Expect(0, 129995, '\P{^Is_Bc:   _ON}', "");
    Error('\p{Bidi_Class=_/a/Pop_Directional_FORMAT}');
    Error('\P{Bidi_Class=_/a/Pop_Directional_FORMAT}');
    Expect(1, 8236, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(0, 8236, '\p{^Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(0, 8236, '\P{Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(1, 8236, '\P{^Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(0, 8237, '\p{Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(1, 8237, '\p{^Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(1, 8237, '\P{Bidi_Class:  	pop_Directional_FORMAT}', "");
    Expect(0, 8237, '\P{^Bidi_Class:  	pop_Directional_FORMAT}', "");
    Error('\p{Bc=	/a/PDF}');
    Error('\P{Bc=	/a/PDF}');
    Expect(1, 8236, '\p{Bc=:\APDF\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\APDF\z:}', "");;
    Expect(1, 8236, '\p{Bc:	pdf}', "");
    Expect(0, 8236, '\p{^Bc:	pdf}', "");
    Expect(0, 8236, '\P{Bc:	pdf}', "");
    Expect(1, 8236, '\P{^Bc:	pdf}', "");
    Expect(0, 8237, '\p{Bc:	pdf}', "");
    Expect(1, 8237, '\p{^Bc:	pdf}', "");
    Expect(1, 8237, '\P{Bc:	pdf}', "");
    Expect(0, 8237, '\P{^Bc:	pdf}', "");
    Expect(1, 8236, '\p{Bc=:\Apdf\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\Apdf\z:}', "");;
    Expect(1, 8236, '\p{Bc=		pdf}', "");
    Expect(0, 8236, '\p{^Bc=		pdf}', "");
    Expect(0, 8236, '\P{Bc=		pdf}', "");
    Expect(1, 8236, '\P{^Bc=		pdf}', "");
    Expect(0, 8237, '\p{Bc=		pdf}', "");
    Expect(1, 8237, '\p{^Bc=		pdf}', "");
    Expect(1, 8237, '\P{Bc=		pdf}', "");
    Expect(0, 8237, '\P{^Bc=		pdf}', "");
    Error('\p{Is_Bidi_Class=-_Pop_directional_format/a/}');
    Error('\P{Is_Bidi_Class=-_Pop_directional_format/a/}');
    Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=_POP_Directional_FORMAT}', "");
    Error('\p{Is_Bc:   		pdf:=}');
    Error('\P{Is_Bc:   		pdf:=}');
    Expect(1, 8236, '\p{Is_Bc=pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
    Expect(1, 8236, '\p{Is_Bc=  pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=  pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=  pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=  pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=  pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=  pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=  pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=  pdf}', "");
    Error('\p{Bidi_Class=/a/Pop_Directional_Isolate}');
    Error('\P{Bidi_Class=/a/Pop_Directional_Isolate}');
    Expect(1, 8297, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=	pop_Directional_isolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=	pop_Directional_isolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=	pop_Directional_isolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=	pop_Directional_isolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=	pop_Directional_isolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=	pop_Directional_isolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=	pop_Directional_isolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=	pop_Directional_isolate}', "");
    Error('\p{Bc=/a/ _PDI}');
    Error('\P{Bc=/a/ _PDI}');
    Expect(1, 8297, '\p{Bc=:\APDI\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\APDI\z:}', "");;
    Expect(1, 8297, '\p{Bc=pdi}', "");
    Expect(0, 8297, '\p{^Bc=pdi}', "");
    Expect(0, 8297, '\P{Bc=pdi}', "");
    Expect(1, 8297, '\P{^Bc=pdi}', "");
    Expect(0, 8298, '\p{Bc=pdi}', "");
    Expect(1, 8298, '\p{^Bc=pdi}', "");
    Expect(1, 8298, '\P{Bc=pdi}', "");
    Expect(0, 8298, '\P{^Bc=pdi}', "");
    Expect(1, 8297, '\p{Bc=:\Apdi\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\Apdi\z:}', "");;
    Expect(1, 8297, '\p{Bc= PDI}', "");
    Expect(0, 8297, '\p{^Bc= PDI}', "");
    Expect(0, 8297, '\P{Bc= PDI}', "");
    Expect(1, 8297, '\P{^Bc= PDI}', "");
    Expect(0, 8298, '\p{Bc= PDI}', "");
    Expect(1, 8298, '\p{^Bc= PDI}', "");
    Expect(1, 8298, '\P{Bc= PDI}', "");
    Expect(0, 8298, '\P{^Bc= PDI}', "");
    Error('\p{Is_Bidi_Class=:=_POP_directional_ISOLATE}');
    Error('\P{Is_Bidi_Class=:=_POP_directional_ISOLATE}');
    Expect(1, 8297, '\p{Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class:	popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=		pop_Directional_Isolate}', "");
    Error('\p{Is_Bc:		:=PDI}');
    Error('\P{Is_Bc:		:=PDI}');
    Expect(1, 8297, '\p{Is_Bc=pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
    Expect(0, 8297, '\P{Is_Bc=pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
    Expect(0, 8298, '\p{Is_Bc=pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
    Expect(1, 8298, '\P{Is_Bc=pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
    Expect(1, 8297, '\p{Is_Bc= PDI}', "");
    Expect(0, 8297, '\p{^Is_Bc= PDI}', "");
    Expect(0, 8297, '\P{Is_Bc= PDI}', "");
    Expect(1, 8297, '\P{^Is_Bc= PDI}', "");
    Expect(0, 8298, '\p{Is_Bc= PDI}', "");
    Expect(1, 8298, '\p{^Is_Bc= PDI}', "");
    Expect(1, 8298, '\P{Is_Bc= PDI}', "");
    Expect(0, 8298, '\P{^Is_Bc= PDI}', "");
    Error('\p{Bidi_Class=	:=Right_To_LEFT}');
    Error('\P{Bidi_Class=	:=Right_To_LEFT}');
    Expect(1, 126975, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class:			RIGHT_To_Left}', "");
    Expect(0, 126975, '\p{^Bidi_Class:			RIGHT_To_Left}', "");
    Expect(0, 126975, '\P{Bidi_Class:			RIGHT_To_Left}', "");
    Expect(1, 126975, '\P{^Bidi_Class:			RIGHT_To_Left}', "");
    Expect(0, 126976, '\p{Bidi_Class:			RIGHT_To_Left}', "");
    Expect(1, 126976, '\p{^Bidi_Class:			RIGHT_To_Left}', "");
    Expect(1, 126976, '\P{Bidi_Class:			RIGHT_To_Left}', "");
    Expect(0, 126976, '\P{^Bidi_Class:			RIGHT_To_Left}', "");
    Error('\p{Bc=	:=R}');
    Error('\P{Bc=	:=R}');
    Expect(1, 126975, '\p{Bc=:\AR\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\AR\z:}', "");;
    Expect(1, 126975, '\p{Bc=r}', "");
    Expect(0, 126975, '\p{^Bc=r}', "");
    Expect(0, 126975, '\P{Bc=r}', "");
    Expect(1, 126975, '\P{^Bc=r}', "");
    Expect(0, 126976, '\p{Bc=r}', "");
    Expect(1, 126976, '\p{^Bc=r}', "");
    Expect(1, 126976, '\P{Bc=r}', "");
    Expect(0, 126976, '\P{^Bc=r}', "");
    Expect(1, 126975, '\p{Bc=:\Ar\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\Ar\z:}', "");;
    Expect(1, 126975, '\p{Bc= R}', "");
    Expect(0, 126975, '\p{^Bc= R}', "");
    Expect(0, 126975, '\P{Bc= R}', "");
    Expect(1, 126975, '\P{^Bc= R}', "");
    Expect(0, 126976, '\p{Bc= R}', "");
    Expect(1, 126976, '\p{^Bc= R}', "");
    Expect(1, 126976, '\P{Bc= R}', "");
    Expect(0, 126976, '\P{^Bc= R}', "");
    Error('\p{Is_Bidi_Class=:=_right_TO_Left}');
    Error('\P{Is_Bidi_Class=:=_right_TO_Left}');
    Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=	 Right_To_LEFT}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=	 Right_To_LEFT}', "");
    Error('\p{Is_Bc=:= 	R}');
    Error('\P{Is_Bc=:= 	R}');
    Expect(1, 126975, '\p{Is_Bc=r}', "");
    Expect(0, 126975, '\p{^Is_Bc=r}', "");
    Expect(0, 126975, '\P{Is_Bc=r}', "");
    Expect(1, 126975, '\P{^Is_Bc=r}', "");
    Expect(0, 126976, '\p{Is_Bc=r}', "");
    Expect(1, 126976, '\p{^Is_Bc=r}', "");
    Expect(1, 126976, '\P{Is_Bc=r}', "");
    Expect(0, 126976, '\P{^Is_Bc=r}', "");
    Expect(1, 126975, '\p{Is_Bc=- R}', "");
    Expect(0, 126975, '\p{^Is_Bc=- R}', "");
    Expect(0, 126975, '\P{Is_Bc=- R}', "");
    Expect(1, 126975, '\P{^Is_Bc=- R}', "");
    Expect(0, 126976, '\p{Is_Bc=- R}', "");
    Expect(1, 126976, '\p{^Is_Bc=- R}', "");
    Expect(1, 126976, '\P{Is_Bc=- R}', "");
    Expect(0, 126976, '\P{^Is_Bc=- R}', "");
    Error('\p{Bidi_Class= :=right_To_Left_EMBEDDING}');
    Error('\P{Bidi_Class= :=right_To_Left_EMBEDDING}');
    Expect(1, 8235, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(0, 8235, '\p{^Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(0, 8235, '\P{Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(1, 8235, '\P{^Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(0, 8236, '\p{Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(1, 8236, '\p{^Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(1, 8236, '\P{Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Expect(0, 8236, '\P{^Bidi_Class=	 RIGHT_to_left_EMBEDDING}', "");
    Error('\p{Bc=/a/-RLE}');
    Error('\P{Bc=/a/-RLE}');
    Expect(1, 8235, '\p{Bc=:\ARLE\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\ARLE\z:}', "");;
    Expect(1, 8235, '\p{Bc=rle}', "");
    Expect(0, 8235, '\p{^Bc=rle}', "");
    Expect(0, 8235, '\P{Bc=rle}', "");
    Expect(1, 8235, '\P{^Bc=rle}', "");
    Expect(0, 8236, '\p{Bc=rle}', "");
    Expect(1, 8236, '\p{^Bc=rle}', "");
    Expect(1, 8236, '\P{Bc=rle}', "");
    Expect(0, 8236, '\P{^Bc=rle}', "");
    Expect(1, 8235, '\p{Bc=:\Arle\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\Arle\z:}', "");;
    Expect(1, 8235, '\p{Bc=	 RLE}', "");
    Expect(0, 8235, '\p{^Bc=	 RLE}', "");
    Expect(0, 8235, '\P{Bc=	 RLE}', "");
    Expect(1, 8235, '\P{^Bc=	 RLE}', "");
    Expect(0, 8236, '\p{Bc=	 RLE}', "");
    Expect(1, 8236, '\p{^Bc=	 RLE}', "");
    Expect(1, 8236, '\P{Bc=	 RLE}', "");
    Expect(0, 8236, '\P{^Bc=	 RLE}', "");
    Error('\p{Is_Bidi_Class: _	Right_To_left_EMBEDDING:=}');
    Error('\P{Is_Bidi_Class: _	Right_To_left_EMBEDDING:=}');
    Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=--right_To_Left_embedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=--right_To_Left_embedding}', "");
    Error('\p{Is_Bc=-RLE:=}');
    Error('\P{Is_Bc=-RLE:=}');
    Expect(1, 8235, '\p{Is_Bc=rle}', "");
    Expect(0, 8235, '\p{^Is_Bc=rle}', "");
    Expect(0, 8235, '\P{Is_Bc=rle}', "");
    Expect(1, 8235, '\P{^Is_Bc=rle}', "");
    Expect(0, 8236, '\p{Is_Bc=rle}', "");
    Expect(1, 8236, '\p{^Is_Bc=rle}', "");
    Expect(1, 8236, '\P{Is_Bc=rle}', "");
    Expect(0, 8236, '\P{^Is_Bc=rle}', "");
    Expect(1, 8235, '\p{Is_Bc=_-RLE}', "");
    Expect(0, 8235, '\p{^Is_Bc=_-RLE}', "");
    Expect(0, 8235, '\P{Is_Bc=_-RLE}', "");
    Expect(1, 8235, '\P{^Is_Bc=_-RLE}', "");
    Expect(0, 8236, '\p{Is_Bc=_-RLE}', "");
    Expect(1, 8236, '\p{^Is_Bc=_-RLE}', "");
    Expect(1, 8236, '\P{Is_Bc=_-RLE}', "");
    Expect(0, 8236, '\P{^Is_Bc=_-RLE}', "");
    Error('\p{Bidi_Class::=--RIGHT_To_left_Isolate}');
    Error('\P{Bidi_Class::=--RIGHT_To_left_Isolate}');
    Expect(1, 8295, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=	_right_to_left_Isolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=	_right_to_left_Isolate}', "");
    Error('\p{Bc::=	rli}');
    Error('\P{Bc::=	rli}');
    Expect(1, 8295, '\p{Bc=:\ARLI\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\ARLI\z:}', "");;
    Expect(1, 8295, '\p{Bc: rli}', "");
    Expect(0, 8295, '\p{^Bc: rli}', "");
    Expect(0, 8295, '\P{Bc: rli}', "");
    Expect(1, 8295, '\P{^Bc: rli}', "");
    Expect(0, 8296, '\p{Bc: rli}', "");
    Expect(1, 8296, '\p{^Bc: rli}', "");
    Expect(1, 8296, '\P{Bc: rli}', "");
    Expect(0, 8296, '\P{^Bc: rli}', "");
    Expect(1, 8295, '\p{Bc=:\Arli\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\Arli\z:}', "");;
    Expect(1, 8295, '\p{Bc= RLI}', "");
    Expect(0, 8295, '\p{^Bc= RLI}', "");
    Expect(0, 8295, '\P{Bc= RLI}', "");
    Expect(1, 8295, '\P{^Bc= RLI}', "");
    Expect(0, 8296, '\p{Bc= RLI}', "");
    Expect(1, 8296, '\p{^Bc= RLI}', "");
    Expect(1, 8296, '\P{Bc= RLI}', "");
    Expect(0, 8296, '\P{^Bc= RLI}', "");
    Error('\p{Is_Bidi_Class=-:=right_To_Left_Isolate}');
    Error('\P{Is_Bidi_Class=-:=right_To_Left_Isolate}');
    Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=_Right_To_Left_isolate}', "");
    Error('\p{Is_Bc= /a/RLI}');
    Error('\P{Is_Bc= /a/RLI}');
    Expect(1, 8295, '\p{Is_Bc=rli}', "");
    Expect(0, 8295, '\p{^Is_Bc=rli}', "");
    Expect(0, 8295, '\P{Is_Bc=rli}', "");
    Expect(1, 8295, '\P{^Is_Bc=rli}', "");
    Expect(0, 8296, '\p{Is_Bc=rli}', "");
    Expect(1, 8296, '\p{^Is_Bc=rli}', "");
    Expect(1, 8296, '\P{Is_Bc=rli}', "");
    Expect(0, 8296, '\P{^Is_Bc=rli}', "");
    Expect(1, 8295, '\p{Is_Bc=_-RLI}', "");
    Expect(0, 8295, '\p{^Is_Bc=_-RLI}', "");
    Expect(0, 8295, '\P{Is_Bc=_-RLI}', "");
    Expect(1, 8295, '\P{^Is_Bc=_-RLI}', "");
    Expect(0, 8296, '\p{Is_Bc=_-RLI}', "");
    Expect(1, 8296, '\p{^Is_Bc=_-RLI}', "");
    Expect(1, 8296, '\P{Is_Bc=_-RLI}', "");
    Expect(0, 8296, '\P{^Is_Bc=_-RLI}', "");
    Error('\p{Bidi_Class=	/a/right_to_Left_Override}');
    Error('\P{Bidi_Class=	/a/right_to_Left_Override}');
    Expect(1, 8238, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=	_Right_To_left_override}', "");
    Expect(0, 8238, '\p{^Bidi_Class=	_Right_To_left_override}', "");
    Expect(0, 8238, '\P{Bidi_Class=	_Right_To_left_override}', "");
    Expect(1, 8238, '\P{^Bidi_Class=	_Right_To_left_override}', "");
    Expect(0, 8239, '\p{Bidi_Class=	_Right_To_left_override}', "");
    Expect(1, 8239, '\p{^Bidi_Class=	_Right_To_left_override}', "");
    Expect(1, 8239, '\P{Bidi_Class=	_Right_To_left_override}', "");
    Expect(0, 8239, '\P{^Bidi_Class=	_Right_To_left_override}', "");
    Error('\p{Bc=__rlo/a/}');
    Error('\P{Bc=__rlo/a/}');
    Expect(1, 8238, '\p{Bc=:\ARLO\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\ARLO\z:}', "");;
    Expect(1, 8238, '\p{Bc=rlo}', "");
    Expect(0, 8238, '\p{^Bc=rlo}', "");
    Expect(0, 8238, '\P{Bc=rlo}', "");
    Expect(1, 8238, '\P{^Bc=rlo}', "");
    Expect(0, 8239, '\p{Bc=rlo}', "");
    Expect(1, 8239, '\p{^Bc=rlo}', "");
    Expect(1, 8239, '\P{Bc=rlo}', "");
    Expect(0, 8239, '\P{^Bc=rlo}', "");
    Expect(1, 8238, '\p{Bc=:\Arlo\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\Arlo\z:}', "");;
    Expect(1, 8238, '\p{Bc=	 rlo}', "");
    Expect(0, 8238, '\p{^Bc=	 rlo}', "");
    Expect(0, 8238, '\P{Bc=	 rlo}', "");
    Expect(1, 8238, '\P{^Bc=	 rlo}', "");
    Expect(0, 8239, '\p{Bc=	 rlo}', "");
    Expect(1, 8239, '\p{^Bc=	 rlo}', "");
    Expect(1, 8239, '\P{Bc=	 rlo}', "");
    Expect(0, 8239, '\P{^Bc=	 rlo}', "");
    Error('\p{Is_Bidi_Class=	 Right_To_Left_OVERRIDE/a/}');
    Error('\P{Is_Bidi_Class=	 Right_To_Left_OVERRIDE/a/}');
    Expect(1, 8238, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Is_Bidi_Class: -right_to_left_override}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class: -right_to_left_override}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class: -right_to_left_override}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class: -right_to_left_override}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class: -right_to_left_override}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class: -right_to_left_override}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class: -right_to_left_override}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class: -right_to_left_override}', "");
    Error('\p{Is_Bc=:=_	RLO}');
    Error('\P{Is_Bc=:=_	RLO}');
    Expect(1, 8238, '\p{Is_Bc=rlo}', "");
    Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
    Expect(0, 8238, '\P{Is_Bc=rlo}', "");
    Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
    Expect(0, 8239, '\p{Is_Bc=rlo}', "");
    Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
    Expect(1, 8239, '\P{Is_Bc=rlo}', "");
    Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
    Expect(1, 8238, '\p{Is_Bc=-RLO}', "");
    Expect(0, 8238, '\p{^Is_Bc=-RLO}', "");
    Expect(0, 8238, '\P{Is_Bc=-RLO}', "");
    Expect(1, 8238, '\P{^Is_Bc=-RLO}', "");
    Expect(0, 8239, '\p{Is_Bc=-RLO}', "");
    Expect(1, 8239, '\p{^Is_Bc=-RLO}', "");
    Expect(1, 8239, '\P{Is_Bc=-RLO}', "");
    Expect(0, 8239, '\P{^Is_Bc=-RLO}', "");
    Error('\p{Bidi_Class=__Segment_Separator/a/}');
    Error('\P{Bidi_Class=__Segment_Separator/a/}');
    Expect(1, 31, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class:   segmentseparator}', "");
    Expect(0, 31, '\p{^Bidi_Class:   segmentseparator}', "");
    Expect(0, 31, '\P{Bidi_Class:   segmentseparator}', "");
    Expect(1, 31, '\P{^Bidi_Class:   segmentseparator}', "");
    Expect(0, 32, '\p{Bidi_Class:   segmentseparator}', "");
    Expect(1, 32, '\p{^Bidi_Class:   segmentseparator}', "");
    Expect(1, 32, '\P{Bidi_Class:   segmentseparator}', "");
    Expect(0, 32, '\P{^Bidi_Class:   segmentseparator}', "");
    Expect(1, 31, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(0, 31, '\p{^Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(0, 31, '\P{Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(1, 31, '\P{^Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(0, 32, '\p{Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(1, 32, '\p{^Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(1, 32, '\P{Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Expect(0, 32, '\P{^Bidi_Class= 	SEGMENT_SEPARATOR}', "");
    Error('\p{Bc:- S/a/}');
    Error('\P{Bc:- S/a/}');
    Expect(1, 31, '\p{Bc=:\AS\z:}', "");;
    Expect(0, 32, '\p{Bc=:\AS\z:}', "");;
    Expect(1, 31, '\p{Bc=s}', "");
    Expect(0, 31, '\p{^Bc=s}', "");
    Expect(0, 31, '\P{Bc=s}', "");
    Expect(1, 31, '\P{^Bc=s}', "");
    Expect(0, 32, '\p{Bc=s}', "");
    Expect(1, 32, '\p{^Bc=s}', "");
    Expect(1, 32, '\P{Bc=s}', "");
    Expect(0, 32, '\P{^Bc=s}', "");
    Expect(1, 31, '\p{Bc=:\As\z:}', "");;
    Expect(0, 32, '\p{Bc=:\As\z:}', "");;
    Expect(1, 31, '\p{Bc=_S}', "");
    Expect(0, 31, '\p{^Bc=_S}', "");
    Expect(0, 31, '\P{Bc=_S}', "");
    Expect(1, 31, '\P{^Bc=_S}', "");
    Expect(0, 32, '\p{Bc=_S}', "");
    Expect(1, 32, '\p{^Bc=_S}', "");
    Expect(1, 32, '\P{Bc=_S}', "");
    Expect(0, 32, '\P{^Bc=_S}', "");
    Error('\p{Is_Bidi_Class=_	segment_Separator/a/}');
    Error('\P{Is_Bidi_Class=_	segment_Separator/a/}');
    Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(0, 31, '\P{Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(0, 32, '\p{Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(1, 32, '\P{Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class= _Segment_SEPARATOR}', "");
    Error('\p{Is_Bc=:=- S}');
    Error('\P{Is_Bc=:=- S}');
    Expect(1, 31, '\p{Is_Bc=s}', "");
    Expect(0, 31, '\p{^Is_Bc=s}', "");
    Expect(0, 31, '\P{Is_Bc=s}', "");
    Expect(1, 31, '\P{^Is_Bc=s}', "");
    Expect(0, 32, '\p{Is_Bc=s}', "");
    Expect(1, 32, '\p{^Is_Bc=s}', "");
    Expect(1, 32, '\P{Is_Bc=s}', "");
    Expect(0, 32, '\P{^Is_Bc=s}', "");
    Expect(1, 31, '\p{Is_Bc=__S}', "");
    Expect(0, 31, '\p{^Is_Bc=__S}', "");
    Expect(0, 31, '\P{Is_Bc=__S}', "");
    Expect(1, 31, '\P{^Is_Bc=__S}', "");
    Expect(0, 32, '\p{Is_Bc=__S}', "");
    Expect(1, 32, '\p{^Is_Bc=__S}', "");
    Expect(1, 32, '\P{Is_Bc=__S}', "");
    Expect(0, 32, '\P{^Is_Bc=__S}', "");
    Error('\p{Bidi_Class: :=-white_SPACE}');
    Error('\P{Bidi_Class: :=-white_SPACE}');
    Expect(1, 12288, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=	white_Space}', "");
    Expect(0, 12288, '\p{^Bidi_Class=	white_Space}', "");
    Expect(0, 12288, '\P{Bidi_Class=	white_Space}', "");
    Expect(1, 12288, '\P{^Bidi_Class=	white_Space}', "");
    Expect(0, 12289, '\p{Bidi_Class=	white_Space}', "");
    Expect(1, 12289, '\p{^Bidi_Class=	white_Space}', "");
    Expect(1, 12289, '\P{Bidi_Class=	white_Space}', "");
    Expect(0, 12289, '\P{^Bidi_Class=	white_Space}', "");
    Error('\p{Bc=	 WS/a/}');
    Error('\P{Bc=	 WS/a/}');
    Expect(1, 12288, '\p{Bc=:\AWS\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\AWS\z:}', "");;
    Expect(1, 12288, '\p{Bc=ws}', "");
    Expect(0, 12288, '\p{^Bc=ws}', "");
    Expect(0, 12288, '\P{Bc=ws}', "");
    Expect(1, 12288, '\P{^Bc=ws}', "");
    Expect(0, 12289, '\p{Bc=ws}', "");
    Expect(1, 12289, '\p{^Bc=ws}', "");
    Expect(1, 12289, '\P{Bc=ws}', "");
    Expect(0, 12289, '\P{^Bc=ws}', "");
    Expect(1, 12288, '\p{Bc=:\Aws\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\Aws\z:}', "");;
    Expect(1, 12288, '\p{Bc=WS}', "");
    Expect(0, 12288, '\p{^Bc=WS}', "");
    Expect(0, 12288, '\P{Bc=WS}', "");
    Expect(1, 12288, '\P{^Bc=WS}', "");
    Expect(0, 12289, '\p{Bc=WS}', "");
    Expect(1, 12289, '\p{^Bc=WS}', "");
    Expect(1, 12289, '\P{Bc=WS}', "");
    Expect(0, 12289, '\P{^Bc=WS}', "");
    Error('\p{Is_Bidi_Class=	White_Space:=}');
    Error('\P{Is_Bidi_Class=	White_Space:=}');
    Expect(1, 12288, '\p{Is_Bidi_Class:   whitespace}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class:   whitespace}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class:   whitespace}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class:   whitespace}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class:   whitespace}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class:   whitespace}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class:   whitespace}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class:   whitespace}', "");
    Expect(1, 12288, '\p{Is_Bidi_Class=-white_Space}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=-white_Space}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=-white_Space}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=-white_Space}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=-white_Space}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=-white_Space}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=-white_Space}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=-white_Space}', "");
    Error('\p{Is_Bc:	 WS/a/}');
    Error('\P{Is_Bc:	 WS/a/}');
    Expect(1, 12288, '\p{Is_Bc=ws}', "");
    Expect(0, 12288, '\p{^Is_Bc=ws}', "");
    Expect(0, 12288, '\P{Is_Bc=ws}', "");
    Expect(1, 12288, '\P{^Is_Bc=ws}', "");
    Expect(0, 12289, '\p{Is_Bc=ws}', "");
    Expect(1, 12289, '\p{^Is_Bc=ws}', "");
    Expect(1, 12289, '\P{Is_Bc=ws}', "");
    Expect(0, 12289, '\P{^Is_Bc=ws}', "");
    Expect(1, 12288, '\p{Is_Bc=_-WS}', "");
    Expect(0, 12288, '\p{^Is_Bc=_-WS}', "");
    Expect(0, 12288, '\P{Is_Bc=_-WS}', "");
    Expect(1, 12288, '\P{^Is_Bc=_-WS}', "");
    Expect(0, 12289, '\p{Is_Bc=_-WS}', "");
    Expect(1, 12289, '\p{^Is_Bc=_-WS}', "");
    Expect(1, 12289, '\P{Is_Bc=_-WS}', "");
    Expect(0, 12289, '\P{^Is_Bc=_-WS}', "");
    Error('\p{Bidi_Control=:=  No}');
    Error('\P{Bidi_Control=:=  No}');
    Expect(1, 8298, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=no}', "");
    Expect(0, 8298, '\p{^Bidi_Control=no}', "");
    Expect(0, 8298, '\P{Bidi_Control=no}', "");
    Expect(1, 8298, '\P{^Bidi_Control=no}', "");
    Expect(0, 8297, '\p{Bidi_Control=no}', "");
    Expect(1, 8297, '\p{^Bidi_Control=no}', "");
    Expect(1, 8297, '\P{Bidi_Control=no}', "");
    Expect(0, 8297, '\P{^Bidi_Control=no}', "");
    Expect(1, 8298, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=--No}', "");
    Expect(0, 8298, '\p{^Bidi_Control=--No}', "");
    Expect(0, 8298, '\P{Bidi_Control=--No}', "");
    Expect(1, 8298, '\P{^Bidi_Control=--No}', "");
    Expect(0, 8297, '\p{Bidi_Control=--No}', "");
    Expect(1, 8297, '\p{^Bidi_Control=--No}', "");
    Expect(1, 8297, '\P{Bidi_Control=--No}', "");
    Expect(0, 8297, '\P{^Bidi_Control=--No}', "");
    Error('\p{Bidi_C=:= -N}');
    Error('\P{Bidi_C=:= -N}');
    Expect(1, 8298, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C=n}', "");
    Expect(0, 8298, '\p{^Bidi_C=n}', "");
    Expect(0, 8298, '\P{Bidi_C=n}', "");
    Expect(1, 8298, '\P{^Bidi_C=n}', "");
    Expect(0, 8297, '\p{Bidi_C=n}', "");
    Expect(1, 8297, '\p{^Bidi_C=n}', "");
    Expect(1, 8297, '\P{Bidi_C=n}', "");
    Expect(0, 8297, '\P{^Bidi_C=n}', "");
    Expect(1, 8298, '\p{Bidi_C=:\An\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\An\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C=N}', "");
    Expect(0, 8298, '\p{^Bidi_C=N}', "");
    Expect(0, 8298, '\P{Bidi_C=N}', "");
    Expect(1, 8298, '\P{^Bidi_C=N}', "");
    Expect(0, 8297, '\p{Bidi_C=N}', "");
    Expect(1, 8297, '\p{^Bidi_C=N}', "");
    Expect(1, 8297, '\P{Bidi_C=N}', "");
    Expect(0, 8297, '\P{^Bidi_C=N}', "");
    Error('\p{Is_Bidi_Control= /a/F}');
    Error('\P{Is_Bidi_Control= /a/F}');
    Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\p{Is_Bidi_Control=_F}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=_F}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=_F}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=_F}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=_F}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=_F}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=_F}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=_F}', "");
    Error('\p{Is_Bidi_C=-_False:=}');
    Error('\P{Is_Bidi_C=-_False:=}');
    Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
    Expect(1, 8298, '\p{Is_Bidi_C= FALSE}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C= FALSE}', "");
    Expect(0, 8298, '\P{Is_Bidi_C= FALSE}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C= FALSE}', "");
    Expect(0, 8297, '\p{Is_Bidi_C= FALSE}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C= FALSE}', "");
    Expect(1, 8297, '\P{Is_Bidi_C= FALSE}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C= FALSE}', "");
    Error('\p{Bidi_Control=:= _YES}');
    Error('\P{Bidi_Control=:= _YES}');
    Expect(1, 8297, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control:   yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control:   yes}', "");
    Expect(0, 8297, '\P{Bidi_Control:   yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control:   yes}', "");
    Expect(0, 8298, '\p{Bidi_Control:   yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control:   yes}', "");
    Expect(1, 8298, '\P{Bidi_Control:   yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control:   yes}', "");
    Expect(1, 8297, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=	-Yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=	-Yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=	-Yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=	-Yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=	-Yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=	-Yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=	-Yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=	-Yes}', "");
    Error('\p{Bidi_C=:=y}');
    Error('\P{Bidi_C=:=y}');
    Expect(1, 8297, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C=y}', "");
    Expect(0, 8297, '\p{^Bidi_C=y}', "");
    Expect(0, 8297, '\P{Bidi_C=y}', "");
    Expect(1, 8297, '\P{^Bidi_C=y}', "");
    Expect(0, 8298, '\p{Bidi_C=y}', "");
    Expect(1, 8298, '\p{^Bidi_C=y}', "");
    Expect(1, 8298, '\P{Bidi_C=y}', "");
    Expect(0, 8298, '\P{^Bidi_C=y}', "");
    Expect(1, 8297, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C= Y}', "");
    Expect(0, 8297, '\p{^Bidi_C= Y}', "");
    Expect(0, 8297, '\P{Bidi_C= Y}', "");
    Expect(1, 8297, '\P{^Bidi_C= Y}', "");
    Expect(0, 8298, '\p{Bidi_C= Y}', "");
    Expect(1, 8298, '\p{^Bidi_C= Y}', "");
    Expect(1, 8298, '\P{Bidi_C= Y}', "");
    Expect(0, 8298, '\P{^Bidi_C= Y}', "");
    Error('\p{Is_Bidi_Control=	_T:=}');
    Error('\P{Is_Bidi_Control=	_T:=}');
    Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\p{Is_Bidi_Control= -T}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control= -T}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control= -T}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control= -T}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control= -T}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control= -T}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control= -T}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control= -T}', "");
    Error('\p{Is_Bidi_C=/a/--True}');
    Error('\P{Is_Bidi_C=/a/--True}');
    Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
    Expect(1, 8297, '\p{Is_Bidi_C=	_True}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=	_True}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=	_True}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=	_True}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=	_True}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=	_True}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=	_True}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=	_True}', "");
    Error('\p{Bidi_Mirrored=:=No}');
    Error('\P{Bidi_Mirrored=:=No}');
    Expect(1, 120772, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=_NO}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=_NO}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=_NO}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=_NO}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=_NO}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=_NO}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=_NO}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=_NO}', "");
    Error('\p{Bidi_M=/a/_ N}');
    Error('\P{Bidi_M=/a/_ N}');
    Expect(1, 120772, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=n}', "");
    Expect(0, 120772, '\p{^Bidi_M=n}', "");
    Expect(0, 120772, '\P{Bidi_M=n}', "");
    Expect(1, 120772, '\P{^Bidi_M=n}', "");
    Expect(0, 120771, '\p{Bidi_M=n}', "");
    Expect(1, 120771, '\p{^Bidi_M=n}', "");
    Expect(1, 120771, '\P{Bidi_M=n}', "");
    Expect(0, 120771, '\P{^Bidi_M=n}', "");
    Expect(1, 120772, '\p{Bidi_M=:\An\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\An\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=--N}', "");
    Expect(0, 120772, '\p{^Bidi_M=--N}', "");
    Expect(0, 120772, '\P{Bidi_M=--N}', "");
    Expect(1, 120772, '\P{^Bidi_M=--N}', "");
    Expect(0, 120771, '\p{Bidi_M=--N}', "");
    Expect(1, 120771, '\p{^Bidi_M=--N}', "");
    Expect(1, 120771, '\P{Bidi_M=--N}', "");
    Expect(0, 120771, '\P{^Bidi_M=--N}', "");
    Error('\p{Is_Bidi_Mirrored=:=-	F}');
    Error('\P{Is_Bidi_Mirrored=:=-	F}');
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=f}', "");
    Expect(1, 120772, '\p{Is_Bidi_Mirrored=- F}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored=- F}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored=- F}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored=- F}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored=- F}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored=- F}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored=- F}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored=- F}', "");
    Error('\p{Is_Bidi_M=_/a/FALSE}');
    Error('\P{Is_Bidi_M=_/a/FALSE}');
    Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
    Expect(1, 120772, '\p{Is_Bidi_M=	-False}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=	-False}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=	-False}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=	-False}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=	-False}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=	-False}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=	-False}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=	-False}', "");
    Error('\p{Bidi_Mirrored=	 Yes/a/}');
    Error('\P{Bidi_Mirrored=	 Yes/a/}');
    Expect(1, 120771, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=	_Yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=	_Yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=	_Yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=	_Yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=	_Yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=	_Yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=	_Yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=	_Yes}', "");
    Error('\p{Bidi_M=/a/ _Y}');
    Error('\P{Bidi_M=/a/ _Y}');
    Expect(1, 120771, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=y}', "");
    Expect(0, 120771, '\p{^Bidi_M=y}', "");
    Expect(0, 120771, '\P{Bidi_M=y}', "");
    Expect(1, 120771, '\P{^Bidi_M=y}', "");
    Expect(0, 120772, '\p{Bidi_M=y}', "");
    Expect(1, 120772, '\p{^Bidi_M=y}', "");
    Expect(1, 120772, '\P{Bidi_M=y}', "");
    Expect(0, 120772, '\P{^Bidi_M=y}', "");
    Expect(1, 120771, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=- Y}', "");
    Expect(0, 120771, '\p{^Bidi_M=- Y}', "");
    Expect(0, 120771, '\P{Bidi_M=- Y}', "");
    Expect(1, 120771, '\P{^Bidi_M=- Y}', "");
    Expect(0, 120772, '\p{Bidi_M=- Y}', "");
    Expect(1, 120772, '\p{^Bidi_M=- Y}', "");
    Expect(1, 120772, '\P{Bidi_M=- Y}', "");
    Expect(0, 120772, '\P{^Bidi_M=- Y}', "");
    Error('\p{Is_Bidi_Mirrored=:=T}');
    Error('\P{Is_Bidi_Mirrored=:=T}');
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=	-t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=	-t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=	-t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=	-t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=	-t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=	-t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=	-t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=	-t}', "");
    Error('\p{Is_Bidi_M=		True:=}');
    Error('\P{Is_Bidi_M=		True:=}');
    Expect(1, 120771, '\p{Is_Bidi_M:   true}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M:   true}', "");
    Expect(0, 120771, '\P{Is_Bidi_M:   true}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M:   true}', "");
    Expect(0, 120772, '\p{Is_Bidi_M:   true}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M:   true}', "");
    Expect(1, 120772, '\P{Is_Bidi_M:   true}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M:   true}', "");
    Expect(1, 120771, '\p{Is_Bidi_M=		True}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=		True}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=		True}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=		True}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=		True}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=		True}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=		True}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=		True}', "");
    Error('\p{block}');
    Error('\P{block}');
    Error('\p{blk}');
    Error('\P{blk}');
    Error('\p{Block=	/a/adlam}');
    Error('\P{Block=	/a/adlam}');
    Expect(1, 125279, '\p{Block=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Block:adlam}', "");
    Expect(0, 125279, '\p{^Block:adlam}', "");
    Expect(0, 125279, '\P{Block:adlam}', "");
    Expect(1, 125279, '\P{^Block:adlam}', "");
    Expect(0, 125280, '\p{Block:adlam}', "");
    Expect(1, 125280, '\p{^Block:adlam}', "");
    Expect(1, 125280, '\P{Block:adlam}', "");
    Expect(0, 125280, '\P{^Block:adlam}', "");
    Expect(1, 125279, '\p{Block=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Block=__Adlam}', "");
    Expect(0, 125279, '\p{^Block=__Adlam}', "");
    Expect(0, 125279, '\P{Block=__Adlam}', "");
    Expect(1, 125279, '\P{^Block=__Adlam}', "");
    Expect(0, 125280, '\p{Block=__Adlam}', "");
    Expect(1, 125280, '\p{^Block=__Adlam}', "");
    Expect(1, 125280, '\P{Block=__Adlam}', "");
    Expect(0, 125280, '\P{^Block=__Adlam}', "");
    Error('\p{Blk=:=_ adlam}');
    Error('\P{Blk=:=_ adlam}');
    Expect(1, 125279, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=adlam}', "");
    Expect(0, 125279, '\p{^Blk=adlam}', "");
    Expect(0, 125279, '\P{Blk=adlam}', "");
    Expect(1, 125279, '\P{^Blk=adlam}', "");
    Expect(0, 125280, '\p{Blk=adlam}', "");
    Expect(1, 125280, '\p{^Blk=adlam}', "");
    Expect(1, 125280, '\P{Blk=adlam}', "");
    Expect(0, 125280, '\P{^Blk=adlam}', "");
    Expect(1, 125279, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=	_ADLAM}', "");
    Expect(0, 125279, '\p{^Blk=	_ADLAM}', "");
    Expect(0, 125279, '\P{Blk=	_ADLAM}', "");
    Expect(1, 125279, '\P{^Blk=	_ADLAM}', "");
    Expect(0, 125280, '\p{Blk=	_ADLAM}', "");
    Expect(1, 125280, '\p{^Blk=	_ADLAM}', "");
    Expect(1, 125280, '\P{Blk=	_ADLAM}', "");
    Expect(0, 125280, '\P{^Blk=	_ADLAM}', "");
    Error('\p{Is_Block:   -	adlam/a/}');
    Error('\P{Is_Block:   -	adlam/a/}');
    Expect(1, 125279, '\p{Is_Block=adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=adlam}', "");
    Expect(0, 125279, '\P{Is_Block=adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=adlam}', "");
    Expect(0, 125280, '\p{Is_Block=adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=adlam}', "");
    Expect(1, 125280, '\P{Is_Block=adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=adlam}', "");
    Expect(1, 125279, '\p{Is_Block=	adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=	adlam}', "");
    Expect(0, 125279, '\P{Is_Block=	adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=	adlam}', "");
    Expect(0, 125280, '\p{Is_Block=	adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=	adlam}', "");
    Expect(1, 125280, '\P{Is_Block=	adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=	adlam}', "");
    Error('\p{Is_Blk= _Adlam:=}');
    Error('\P{Is_Blk= _Adlam:=}');
    Expect(1, 125279, '\p{Is_Blk=adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=adlam}', "");
    Expect(1, 125279, '\p{Is_Blk=_-Adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=_-Adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=_-Adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=_-Adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=_-Adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=_-Adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=_-Adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=_-Adlam}', "");
    Error('\p{Block=/a/ -AEGEAN_numbers}');
    Error('\P{Block=/a/ -AEGEAN_numbers}');
    Expect(1, 65855, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Block=		aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Block=		aegean_Numbers}', "");
    Expect(0, 65855, '\P{Block=		aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Block=		aegean_Numbers}', "");
    Expect(0, 65856, '\p{Block=		aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Block=		aegean_Numbers}', "");
    Expect(1, 65856, '\P{Block=		aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Block=		aegean_Numbers}', "");
    Error('\p{Blk=_:=aegean_Numbers}');
    Error('\P{Blk=_:=aegean_Numbers}');
    Expect(1, 65855, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Blk:	 Aegean_NUMBERS}', "");
    Expect(0, 65855, '\p{^Blk:	 Aegean_NUMBERS}', "");
    Expect(0, 65855, '\P{Blk:	 Aegean_NUMBERS}', "");
    Expect(1, 65855, '\P{^Blk:	 Aegean_NUMBERS}', "");
    Expect(0, 65856, '\p{Blk:	 Aegean_NUMBERS}', "");
    Expect(1, 65856, '\p{^Blk:	 Aegean_NUMBERS}', "");
    Expect(1, 65856, '\P{Blk:	 Aegean_NUMBERS}', "");
    Expect(0, 65856, '\P{^Blk:	 Aegean_NUMBERS}', "");
    Error('\p{Is_Block=_-Aegean_NUMBERS/a/}');
    Error('\P{Is_Block=_-Aegean_NUMBERS/a/}');
    Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Block= Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Is_Block= Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Is_Block= Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Is_Block= Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Is_Block= Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Is_Block= Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Is_Block= Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Is_Block= Aegean_Numbers}', "");
    Error('\p{Is_Blk=-_aegean_Numbers/a/}');
    Error('\P{Is_Blk=-_aegean_Numbers/a/}');
    Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(0, 65855, '\p{^Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(0, 65855, '\P{Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(1, 65855, '\P{^Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(0, 65856, '\p{Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(1, 65856, '\p{^Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(1, 65856, '\P{Is_Blk=_	Aegean_NUMBERS}', "");
    Expect(0, 65856, '\P{^Is_Blk=_	Aegean_NUMBERS}', "");
    Error('\p{Block=-_AHOM:=}');
    Error('\P{Block=-_AHOM:=}');
    Expect(1, 71487, '\p{Block=:\AAhom\z:}', "");;
    Expect(0, 71488, '\p{Block=:\AAhom\z:}', "");;
    Expect(1, 71487, '\p{Block=ahom}', "");
    Expect(0, 71487, '\p{^Block=ahom}', "");
    Expect(0, 71487, '\P{Block=ahom}', "");
    Expect(1, 71487, '\P{^Block=ahom}', "");
    Expect(0, 71488, '\p{Block=ahom}', "");
    Expect(1, 71488, '\p{^Block=ahom}', "");
    Expect(1, 71488, '\P{Block=ahom}', "");
    Expect(0, 71488, '\P{^Block=ahom}', "");
    Expect(1, 71487, '\p{Block=:\Aahom\z:}', "");;
    Expect(0, 71488, '\p{Block=:\Aahom\z:}', "");;
    Expect(1, 71487, '\p{Block=	Ahom}', "");
    Expect(0, 71487, '\p{^Block=	Ahom}', "");
    Expect(0, 71487, '\P{Block=	Ahom}', "");
    Expect(1, 71487, '\P{^Block=	Ahom}', "");
    Expect(0, 71488, '\p{Block=	Ahom}', "");
    Expect(1, 71488, '\p{^Block=	Ahom}', "");
    Expect(1, 71488, '\P{Block=	Ahom}', "");
    Expect(0, 71488, '\P{^Block=	Ahom}', "");
    Error('\p{Blk::=-ahom}');
    Error('\P{Blk::=-ahom}');
    Expect(1, 71487, '\p{Blk=:\AAhom\z:}', "");;
    Expect(0, 71488, '\p{Blk=:\AAhom\z:}', "");;
    Expect(1, 71487, '\p{Blk=ahom}', "");
    Expect(0, 71487, '\p{^Blk=ahom}', "");
    Expect(0, 71487, '\P{Blk=ahom}', "");
    Expect(1, 71487, '\P{^Blk=ahom}', "");
    Expect(0, 71488, '\p{Blk=ahom}', "");
    Expect(1, 71488, '\p{^Blk=ahom}', "");
    Expect(1, 71488, '\P{Blk=ahom}', "");
    Expect(0, 71488, '\P{^Blk=ahom}', "");
    Expect(1, 71487, '\p{Blk=:\Aahom\z:}', "");;
    Expect(0, 71488, '\p{Blk=:\Aahom\z:}', "");;
    Expect(1, 71487, '\p{Blk=-	ahom}', "");
    Expect(0, 71487, '\p{^Blk=-	ahom}', "");
    Expect(0, 71487, '\P{Blk=-	ahom}', "");
    Expect(1, 71487, '\P{^Blk=-	ahom}', "");
    Expect(0, 71488, '\p{Blk=-	ahom}', "");
    Expect(1, 71488, '\p{^Blk=-	ahom}', "");
    Expect(1, 71488, '\P{Blk=-	ahom}', "");
    Expect(0, 71488, '\P{^Blk=-	ahom}', "");
    Error('\p{Is_Block=	ahom/a/}');
    Error('\P{Is_Block=	ahom/a/}');
    Expect(1, 71487, '\p{Is_Block=ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=ahom}', "");
    Expect(0, 71487, '\P{Is_Block=ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=ahom}', "");
    Expect(0, 71488, '\p{Is_Block=ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=ahom}', "");
    Expect(1, 71488, '\P{Is_Block=ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=ahom}', "");
    Expect(1, 71487, '\p{Is_Block=	Ahom}', "");
    Expect(0, 71487, '\p{^Is_Block=	Ahom}', "");
    Expect(0, 71487, '\P{Is_Block=	Ahom}', "");
    Expect(1, 71487, '\P{^Is_Block=	Ahom}', "");
    Expect(0, 71488, '\p{Is_Block=	Ahom}', "");
    Expect(1, 71488, '\p{^Is_Block=	Ahom}', "");
    Expect(1, 71488, '\P{Is_Block=	Ahom}', "");
    Expect(0, 71488, '\P{^Is_Block=	Ahom}', "");
    Error('\p{Is_Blk=_:=AHOM}');
    Error('\P{Is_Blk=_:=AHOM}');
    Expect(1, 71487, '\p{Is_Blk=ahom}', "");
    Expect(0, 71487, '\p{^Is_Blk=ahom}', "");
    Expect(0, 71487, '\P{Is_Blk=ahom}', "");
    Expect(1, 71487, '\P{^Is_Blk=ahom}', "");
    Expect(0, 71488, '\p{Is_Blk=ahom}', "");
    Expect(1, 71488, '\p{^Is_Blk=ahom}', "");
    Expect(1, 71488, '\P{Is_Blk=ahom}', "");
    Expect(0, 71488, '\P{^Is_Blk=ahom}', "");
    Error('\p{Block=		alchemical_Symbols/a/}');
    Error('\P{Block=		alchemical_Symbols/a/}');
    Expect(1, 128895, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(1, 128895, '\p{Block=_ ALCHEMICAL_symbols}', "");
    Expect(0, 128895, '\p{^Block=_ ALCHEMICAL_symbols}', "");
    Expect(0, 128895, '\P{Block=_ ALCHEMICAL_symbols}', "");
    Expect(1, 128895, '\P{^Block=_ ALCHEMICAL_symbols}', "");
    Expect(0, 128896, '\p{Block=_ ALCHEMICAL_symbols}', "");
    Expect(1, 128896, '\p{^Block=_ ALCHEMICAL_symbols}', "");
    Expect(1, 128896, '\P{Block=_ ALCHEMICAL_symbols}', "");
    Expect(0, 128896, '\P{^Block=_ ALCHEMICAL_symbols}', "");
    Error('\p{Blk=:=-Alchemical}');
    Error('\P{Blk=:=-Alchemical}');
    Expect(1, 128895, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Blk=alchemical}', "");
    Expect(0, 128895, '\P{Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Blk=alchemical}', "");
    Expect(0, 128896, '\p{Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Blk=alchemical}', "");
    Expect(1, 128896, '\P{Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Blk=alchemical}', "");
    Expect(1, 128895, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=  ALCHEMICAL}', "");
    Expect(0, 128895, '\p{^Blk=  ALCHEMICAL}', "");
    Expect(0, 128895, '\P{Blk=  ALCHEMICAL}', "");
    Expect(1, 128895, '\P{^Blk=  ALCHEMICAL}', "");
    Expect(0, 128896, '\p{Blk=  ALCHEMICAL}', "");
    Expect(1, 128896, '\p{^Blk=  ALCHEMICAL}', "");
    Expect(1, 128896, '\P{Blk=  ALCHEMICAL}', "");
    Expect(0, 128896, '\P{^Blk=  ALCHEMICAL}', "");
    Error('\p{Is_Block: /a/_-ALCHEMICAL_symbols}');
    Error('\P{Is_Block: /a/_-ALCHEMICAL_symbols}');
    Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Is_Block=- Alchemical_Symbols}', "");
    Expect(0, 128895, '\p{^Is_Block=- Alchemical_Symbols}', "");
    Expect(0, 128895, '\P{Is_Block=- Alchemical_Symbols}', "");
    Expect(1, 128895, '\P{^Is_Block=- Alchemical_Symbols}', "");
    Expect(0, 128896, '\p{Is_Block=- Alchemical_Symbols}', "");
    Expect(1, 128896, '\p{^Is_Block=- Alchemical_Symbols}', "");
    Expect(1, 128896, '\P{Is_Block=- Alchemical_Symbols}', "");
    Expect(0, 128896, '\P{^Is_Block=- Alchemical_Symbols}', "");
    Error('\p{Is_Blk:/a/ -Alchemical}');
    Error('\P{Is_Blk:/a/ -Alchemical}');
    Expect(1, 128895, '\p{Is_Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=alchemical}', "");
    Expect(1, 128895, '\p{Is_Blk= _Alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk= _Alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk= _Alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk= _Alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk= _Alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk= _Alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk= _Alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk= _Alchemical}', "");
    Error('\p{Block=/a/- Alphabetic_presentation_Forms}');
    Error('\P{Block=/a/- Alphabetic_presentation_Forms}');
    Expect(1, 64335, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(1, 64335, '\p{Block=	-Alphabetic_presentation_Forms}', "");
    Expect(0, 64335, '\p{^Block=	-Alphabetic_presentation_Forms}', "");
    Expect(0, 64335, '\P{Block=	-Alphabetic_presentation_Forms}', "");
    Expect(1, 64335, '\P{^Block=	-Alphabetic_presentation_Forms}', "");
    Expect(0, 64336, '\p{Block=	-Alphabetic_presentation_Forms}', "");
    Expect(1, 64336, '\p{^Block=	-Alphabetic_presentation_Forms}', "");
    Expect(1, 64336, '\P{Block=	-Alphabetic_presentation_Forms}', "");
    Expect(0, 64336, '\P{^Block=	-Alphabetic_presentation_Forms}', "");
    Error('\p{Blk: - Alphabetic_pf:=}');
    Error('\P{Blk: - Alphabetic_pf:=}');
    Expect(1, 64335, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(1, 64335, '\p{Blk=		Alphabetic_pf}', "");
    Expect(0, 64335, '\p{^Blk=		Alphabetic_pf}', "");
    Expect(0, 64335, '\P{Blk=		Alphabetic_pf}', "");
    Expect(1, 64335, '\P{^Blk=		Alphabetic_pf}', "");
    Expect(0, 64336, '\p{Blk=		Alphabetic_pf}', "");
    Expect(1, 64336, '\p{^Blk=		Alphabetic_pf}', "");
    Expect(1, 64336, '\P{Blk=		Alphabetic_pf}', "");
    Expect(0, 64336, '\P{^Blk=		Alphabetic_pf}', "");
    Error('\p{Is_Block=:=		Alphabetic_Presentation_FORMS}');
    Error('\P{Is_Block=:=		Alphabetic_Presentation_FORMS}');
    Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(0, 64335, '\p{^Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(0, 64335, '\P{Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(1, 64335, '\P{^Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(0, 64336, '\p{Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(1, 64336, '\p{^Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(1, 64336, '\P{Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Expect(0, 64336, '\P{^Is_Block:    	Alphabetic_PRESENTATION_Forms}', "");
    Error('\p{Is_Blk=- Alphabetic_PF:=}');
    Error('\P{Is_Blk=- Alphabetic_PF:=}');
    Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Is_Blk=		Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Is_Blk=		Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Is_Blk=		Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Is_Blk=		Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Is_Blk=		Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Is_Blk=		Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Is_Blk=		Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Is_Blk=		Alphabetic_PF}', "");
    Error('\p{Block= :=Anatolian_Hieroglyphs}');
    Error('\P{Block= :=Anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\p{^Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83583, '\P{Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83583, '\P{^Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\p{Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\p{^Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(1, 83584, '\P{Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Expect(0, 83584, '\P{^Block= -ANATOLIAN_HIEROGLYPHS}', "");
    Error('\p{Blk=:= _anatolian_HIEROGLYPHS}');
    Error('\P{Blk=:= _anatolian_HIEROGLYPHS}');
    Expect(1, 83583, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(0, 83583, '\p{^Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(0, 83583, '\P{Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(1, 83583, '\P{^Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(0, 83584, '\p{Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(1, 83584, '\p{^Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(1, 83584, '\P{Blk=_	Anatolian_HIEROGLYPHS}', "");
    Expect(0, 83584, '\P{^Blk=_	Anatolian_HIEROGLYPHS}', "");
    Error('\p{Is_Block:/a/ -Anatolian_Hieroglyphs}');
    Error('\P{Is_Block:/a/ -Anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=_Anatolian_hieroglyphs}', "");
    Error('\p{Is_Blk:		/a/anatolian_Hieroglyphs}');
    Error('\P{Is_Blk:		/a/anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=	_Anatolian_Hieroglyphs}', "");
    Error('\p{Block=:=_ Ancient_Greek_MUSICAL_Notation}');
    Error('\P{Block=:=_ Ancient_Greek_MUSICAL_Notation}');
    Expect(1, 119375, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(1, 119375, '\p{Block:  Ancient_Greek_musical_notation}', "");
    Expect(0, 119375, '\p{^Block:  Ancient_Greek_musical_notation}', "");
    Expect(0, 119375, '\P{Block:  Ancient_Greek_musical_notation}', "");
    Expect(1, 119375, '\P{^Block:  Ancient_Greek_musical_notation}', "");
    Expect(0, 119376, '\p{Block:  Ancient_Greek_musical_notation}', "");
    Expect(1, 119376, '\p{^Block:  Ancient_Greek_musical_notation}', "");
    Expect(1, 119376, '\P{Block:  Ancient_Greek_musical_notation}', "");
    Expect(0, 119376, '\P{^Block:  Ancient_Greek_musical_notation}', "");
    Error('\p{Blk=/a/	ancient_greek_music}');
    Error('\P{Blk=/a/	ancient_greek_music}');
    Expect(1, 119375, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(1, 119375, '\p{Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(0, 119375, '\p{^Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(0, 119375, '\P{Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(1, 119375, '\P{^Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(0, 119376, '\p{Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(1, 119376, '\p{^Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(1, 119376, '\P{Blk=	-ANCIENT_Greek_MUSIC}', "");
    Expect(0, 119376, '\P{^Blk=	-ANCIENT_Greek_MUSIC}', "");
    Error('\p{Is_Block=/a/_	Ancient_Greek_MUSICAL_Notation}');
    Error('\P{Is_Block=/a/_	Ancient_Greek_MUSICAL_Notation}');
    Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\p{^Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\P{Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119375, '\P{^Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\p{Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\p{^Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\P{Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\P{^Is_Block= -Ancient_Greek_Musical_NOTATION}', "");
    Error('\p{Is_Blk=		Ancient_greek_MUSIC/a/}');
    Error('\P{Is_Blk=		Ancient_greek_MUSIC/a/}');
    Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Is_Blk=	Ancient_greek_music}', "");
    Expect(0, 119375, '\p{^Is_Blk=	Ancient_greek_music}', "");
    Expect(0, 119375, '\P{Is_Blk=	Ancient_greek_music}', "");
    Expect(1, 119375, '\P{^Is_Blk=	Ancient_greek_music}', "");
    Expect(0, 119376, '\p{Is_Blk=	Ancient_greek_music}', "");
    Expect(1, 119376, '\p{^Is_Blk=	Ancient_greek_music}', "");
    Expect(1, 119376, '\P{Is_Blk=	Ancient_greek_music}', "");
    Expect(0, 119376, '\P{^Is_Blk=	Ancient_greek_music}', "");
    Error('\p{Block=:= _ANCIENT_Greek_Numbers}');
    Error('\P{Block=:= _ANCIENT_Greek_Numbers}');
    Expect(1, 65935, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Block: ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Block: ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Block: ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Block: ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Block: ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Block: ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Block: ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Block: ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Block= _Ancient_greek_Numbers}', "");
    Expect(0, 65935, '\p{^Block= _Ancient_greek_Numbers}', "");
    Expect(0, 65935, '\P{Block= _Ancient_greek_Numbers}', "");
    Expect(1, 65935, '\P{^Block= _Ancient_greek_Numbers}', "");
    Expect(0, 65936, '\p{Block= _Ancient_greek_Numbers}', "");
    Expect(1, 65936, '\p{^Block= _Ancient_greek_Numbers}', "");
    Expect(1, 65936, '\P{Block= _Ancient_greek_Numbers}', "");
    Expect(0, 65936, '\P{^Block= _Ancient_greek_Numbers}', "");
    Error('\p{Blk=/a/	 ANCIENT_greek_Numbers}');
    Error('\P{Blk=/a/	 ANCIENT_greek_Numbers}');
    Expect(1, 65935, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\p{^Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(0, 65935, '\P{Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(1, 65935, '\P{^Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\p{Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\p{^Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(1, 65936, '\P{Blk=__Ancient_Greek_NUMBERS}', "");
    Expect(0, 65936, '\P{^Blk=__Ancient_Greek_NUMBERS}', "");
    Error('\p{Is_Block=:=	ANCIENT_GREEK_Numbers}');
    Error('\P{Is_Block=:=	ANCIENT_GREEK_Numbers}');
    Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Block= ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Block= ancient_Greek_Numbers}', "");
    Expect(0, 65935, '\P{Is_Block= ancient_Greek_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Block= ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\p{Is_Block= ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Block= ancient_Greek_Numbers}', "");
    Expect(1, 65936, '\P{Is_Block= ancient_Greek_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Block= ancient_Greek_Numbers}', "");
    Error('\p{Is_Blk=	:=Ancient_Greek_Numbers}');
    Error('\P{Is_Blk=	:=Ancient_Greek_Numbers}');
    Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Blk=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Blk=Ancient_Greek_numbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=Ancient_Greek_numbers}', "");
    Expect(0, 65935, '\P{Is_Blk=Ancient_Greek_numbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=Ancient_Greek_numbers}', "");
    Expect(0, 65936, '\p{Is_Blk=Ancient_Greek_numbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=Ancient_Greek_numbers}', "");
    Expect(1, 65936, '\P{Is_Blk=Ancient_Greek_numbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=Ancient_Greek_numbers}', "");
    Error('\p{Block=:= 	Ancient_Symbols}');
    Error('\P{Block=:= 	Ancient_Symbols}');
    Expect(1, 65999, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Block=__ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Block=__ancient_Symbols}', "");
    Expect(0, 65999, '\P{Block=__ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Block=__ancient_Symbols}', "");
    Expect(0, 66000, '\p{Block=__ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Block=__ancient_Symbols}', "");
    Expect(1, 66000, '\P{Block=__ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Block=__ancient_Symbols}', "");
    Error('\p{Blk=-/a/ANCIENT_Symbols}');
    Error('\P{Blk=-/a/ANCIENT_Symbols}');
    Expect(1, 65999, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Blk:   ancientsymbols}', "");
    Expect(0, 65999, '\p{^Blk:   ancientsymbols}', "");
    Expect(0, 65999, '\P{Blk:   ancientsymbols}', "");
    Expect(1, 65999, '\P{^Blk:   ancientsymbols}', "");
    Expect(0, 66000, '\p{Blk:   ancientsymbols}', "");
    Expect(1, 66000, '\p{^Blk:   ancientsymbols}', "");
    Expect(1, 66000, '\P{Blk:   ancientsymbols}', "");
    Expect(0, 66000, '\P{^Blk:   ancientsymbols}', "");
    Expect(1, 65999, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=-Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Blk=-Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Blk=-Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Blk=-Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Blk=-Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Blk=-Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Blk=-Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Blk=-Ancient_Symbols}', "");
    Error('\p{Is_Block=_:=Ancient_SYMBOLS}');
    Error('\P{Is_Block=_:=Ancient_SYMBOLS}');
    Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Block=_Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Block=_Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Is_Block=_Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Block=_Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Is_Block=_Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Block=_Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Is_Block=_Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Block=_Ancient_Symbols}', "");
    Error('\p{Is_Blk=_-Ancient_SYMBOLS:=}');
    Error('\P{Is_Blk=_-Ancient_SYMBOLS:=}');
    Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Blk:_ Ancient_symbols}', "");
    Expect(0, 65999, '\p{^Is_Blk:_ Ancient_symbols}', "");
    Expect(0, 65999, '\P{Is_Blk:_ Ancient_symbols}', "");
    Expect(1, 65999, '\P{^Is_Blk:_ Ancient_symbols}', "");
    Expect(0, 66000, '\p{Is_Blk:_ Ancient_symbols}', "");
    Expect(1, 66000, '\p{^Is_Blk:_ Ancient_symbols}', "");
    Expect(1, 66000, '\P{Is_Blk:_ Ancient_symbols}', "");
    Expect(0, 66000, '\P{^Is_Blk:_ Ancient_symbols}', "");
    Error('\p{Block=  arabic/a/}');
    Error('\P{Block=  arabic/a/}');
    Expect(1, 1791, '\p{Block=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Block=arabic}', "");
    Expect(0, 1791, '\p{^Block=arabic}', "");
    Expect(0, 1791, '\P{Block=arabic}', "");
    Expect(1, 1791, '\P{^Block=arabic}', "");
    Expect(0, 1792, '\p{Block=arabic}', "");
    Expect(1, 1792, '\p{^Block=arabic}', "");
    Expect(1, 1792, '\P{Block=arabic}', "");
    Expect(0, 1792, '\P{^Block=arabic}', "");
    Expect(1, 1791, '\p{Block=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Block:_Arabic}', "");
    Expect(0, 1791, '\p{^Block:_Arabic}', "");
    Expect(0, 1791, '\P{Block:_Arabic}', "");
    Expect(1, 1791, '\P{^Block:_Arabic}', "");
    Expect(0, 1792, '\p{Block:_Arabic}', "");
    Expect(1, 1792, '\p{^Block:_Arabic}', "");
    Expect(1, 1792, '\P{Block:_Arabic}', "");
    Expect(0, 1792, '\P{^Block:_Arabic}', "");
    Error('\p{Blk=/a/	Arabic}');
    Error('\P{Blk=/a/	Arabic}');
    Expect(1, 1791, '\p{Blk=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=arabic}', "");
    Expect(0, 1791, '\p{^Blk=arabic}', "");
    Expect(0, 1791, '\P{Blk=arabic}', "");
    Expect(1, 1791, '\P{^Blk=arabic}', "");
    Expect(0, 1792, '\p{Blk=arabic}', "");
    Expect(1, 1792, '\p{^Blk=arabic}', "");
    Expect(1, 1792, '\P{Blk=arabic}', "");
    Expect(0, 1792, '\P{^Blk=arabic}', "");
    Expect(1, 1791, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=-Arabic}', "");
    Expect(0, 1791, '\p{^Blk=-Arabic}', "");
    Expect(0, 1791, '\P{Blk=-Arabic}', "");
    Expect(1, 1791, '\P{^Blk=-Arabic}', "");
    Expect(0, 1792, '\p{Blk=-Arabic}', "");
    Expect(1, 1792, '\p{^Blk=-Arabic}', "");
    Expect(1, 1792, '\P{Blk=-Arabic}', "");
    Expect(0, 1792, '\P{^Blk=-Arabic}', "");
    Error('\p{Is_Block=/a/-	Arabic}');
    Error('\P{Is_Block=/a/-	Arabic}');
    Expect(1, 1791, '\p{Is_Block:arabic}', "");
    Expect(0, 1791, '\p{^Is_Block:arabic}', "");
    Expect(0, 1791, '\P{Is_Block:arabic}', "");
    Expect(1, 1791, '\P{^Is_Block:arabic}', "");
    Expect(0, 1792, '\p{Is_Block:arabic}', "");
    Expect(1, 1792, '\p{^Is_Block:arabic}', "");
    Expect(1, 1792, '\P{Is_Block:arabic}', "");
    Expect(0, 1792, '\P{^Is_Block:arabic}', "");
    Expect(1, 1791, '\p{Is_Block=_Arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=_Arabic}', "");
    Expect(0, 1791, '\P{Is_Block=_Arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=_Arabic}', "");
    Expect(0, 1792, '\p{Is_Block=_Arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=_Arabic}', "");
    Expect(1, 1792, '\P{Is_Block=_Arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=_Arabic}', "");
    Error('\p{Is_Blk=_Arabic:=}');
    Error('\P{Is_Blk=_Arabic:=}');
    Expect(1, 1791, '\p{Is_Blk=arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
    Expect(1, 1791, '\p{Is_Blk=Arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=Arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=Arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=Arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=Arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=Arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=Arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=Arabic}', "");
    Error('\p{Block=_Arabic_Extended_A/a/}');
    Error('\P{Block=_Arabic_Extended_A/a/}');
    Expect(1, 2303, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(0, 2304, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(1, 2303, '\p{Block: arabicextendeda}', "");
    Expect(0, 2303, '\p{^Block: arabicextendeda}', "");
    Expect(0, 2303, '\P{Block: arabicextendeda}', "");
    Expect(1, 2303, '\P{^Block: arabicextendeda}', "");
    Expect(0, 2304, '\p{Block: arabicextendeda}', "");
    Expect(1, 2304, '\p{^Block: arabicextendeda}', "");
    Expect(1, 2304, '\P{Block: arabicextendeda}', "");
    Expect(0, 2304, '\P{^Block: arabicextendeda}', "");
    Expect(1, 2303, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(0, 2304, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(1, 2303, '\p{Block=	_Arabic_extended_A}', "");
    Expect(0, 2303, '\p{^Block=	_Arabic_extended_A}', "");
    Expect(0, 2303, '\P{Block=	_Arabic_extended_A}', "");
    Expect(1, 2303, '\P{^Block=	_Arabic_extended_A}', "");
    Expect(0, 2304, '\p{Block=	_Arabic_extended_A}', "");
    Expect(1, 2304, '\p{^Block=	_Arabic_extended_A}', "");
    Expect(1, 2304, '\P{Block=	_Arabic_extended_A}', "");
    Expect(0, 2304, '\P{^Block=	_Arabic_extended_A}', "");
    Error('\p{Blk=:=	_ARABIC_ext_A}');
    Error('\P{Blk=:=	_ARABIC_ext_A}');
    Expect(1, 2303, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(1, 2303, '\p{Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(1, 2303, '\p{Blk=_	Arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Blk=_	Arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Blk=_	Arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Blk=_	Arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Blk=_	Arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Blk=_	Arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Blk=_	Arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Blk=_	Arabic_Ext_A}', "");
    Error('\p{Is_Block:    :=Arabic_Extended_A}');
    Error('\P{Is_Block:    :=Arabic_Extended_A}');
    Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Is_Block= Arabic_extended_A}', "");
    Expect(0, 2303, '\p{^Is_Block= Arabic_extended_A}', "");
    Expect(0, 2303, '\P{Is_Block= Arabic_extended_A}', "");
    Expect(1, 2303, '\P{^Is_Block= Arabic_extended_A}', "");
    Expect(0, 2304, '\p{Is_Block= Arabic_extended_A}', "");
    Expect(1, 2304, '\p{^Is_Block= Arabic_extended_A}', "");
    Expect(1, 2304, '\P{Is_Block= Arabic_extended_A}', "");
    Expect(0, 2304, '\P{^Is_Block= Arabic_extended_A}', "");
    Error('\p{Is_Blk=:=-Arabic_ext_A}');
    Error('\P{Is_Blk=:=-Arabic_ext_A}');
    Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Is_Blk=_ Arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Is_Blk=_ Arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Is_Blk=_ Arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Is_Blk=_ Arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Is_Blk=_ Arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Is_Blk=_ Arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Is_Blk=_ Arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Is_Blk=_ Arabic_Ext_A}', "");
    Error('\p{Block=- Arabic_mathematical_Alphabetic_SYMBOLS:=}');
    Error('\P{Block=- Arabic_mathematical_Alphabetic_SYMBOLS:=}');
    Expect(1, 126719, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(1, 126719, '\p{Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126719, '\p{^Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126719, '\P{Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126719, '\P{^Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126720, '\p{Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126720, '\p{^Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(1, 126720, '\P{Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Expect(0, 126720, '\P{^Block=-arabic_Mathematical_Alphabetic_symbols}', "");
    Error('\p{Blk=-:=ARABIC_math}');
    Error('\P{Blk=-:=ARABIC_math}');
    Expect(1, 126719, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(1, 126719, '\p{Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(1, 126719, '\p{Blk=__Arabic_math}', "");
    Expect(0, 126719, '\p{^Blk=__Arabic_math}', "");
    Expect(0, 126719, '\P{Blk=__Arabic_math}', "");
    Expect(1, 126719, '\P{^Blk=__Arabic_math}', "");
    Expect(0, 126720, '\p{Blk=__Arabic_math}', "");
    Expect(1, 126720, '\p{^Blk=__Arabic_math}', "");
    Expect(1, 126720, '\P{Blk=__Arabic_math}', "");
    Expect(0, 126720, '\P{^Blk=__Arabic_math}', "");
    Error('\p{Is_Block=/a/	 Arabic_Mathematical_Alphabetic_Symbols}');
    Error('\P{Is_Block=/a/	 Arabic_Mathematical_Alphabetic_Symbols}');
    Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\p{^Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\P{Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126719, '\P{^Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\p{Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\p{^Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\P{Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\P{^Is_Block=-_Arabic_Mathematical_ALPHABETIC_symbols}', "");
    Error('\p{Is_Blk=/a/	ARABIC_Math}');
    Error('\P{Is_Blk=/a/	ARABIC_Math}');
    Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Is_Blk:_	arabic_MATH}', "");
    Expect(0, 126719, '\p{^Is_Blk:_	arabic_MATH}', "");
    Expect(0, 126719, '\P{Is_Blk:_	arabic_MATH}', "");
    Expect(1, 126719, '\P{^Is_Blk:_	arabic_MATH}', "");
    Expect(0, 126720, '\p{Is_Blk:_	arabic_MATH}', "");
    Expect(1, 126720, '\p{^Is_Blk:_	arabic_MATH}', "");
    Expect(1, 126720, '\P{Is_Blk:_	arabic_MATH}', "");
    Expect(0, 126720, '\P{^Is_Blk:_	arabic_MATH}', "");
    Error('\p{Block=_/a/Arabic_PRESENTATION_FORMS_A}');
    Error('\P{Block=_/a/Arabic_PRESENTATION_FORMS_A}');
    Expect(1, 65023, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(0, 65024, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(0, 65024, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(1, 65023, '\p{Block=	 Arabic_Presentation_forms_A}', "");
    Expect(0, 65023, '\p{^Block=	 Arabic_Presentation_forms_A}', "");
    Expect(0, 65023, '\P{Block=	 Arabic_Presentation_forms_A}', "");
    Expect(1, 65023, '\P{^Block=	 Arabic_Presentation_forms_A}', "");
    Expect(0, 65024, '\p{Block=	 Arabic_Presentation_forms_A}', "");
    Expect(1, 65024, '\p{^Block=	 Arabic_Presentation_forms_A}', "");
    Expect(1, 65024, '\P{Block=	 Arabic_Presentation_forms_A}', "");
    Expect(0, 65024, '\P{^Block=	 Arabic_Presentation_forms_A}', "");
    Error('\p{Blk=_/a/ARABIC_PF_A}');
    Error('\P{Blk=_/a/ARABIC_PF_A}');
    Expect(1, 65023, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(1, 65023, '\p{Blk: arabicpfa}', "");
    Expect(0, 65023, '\p{^Blk: arabicpfa}', "");
    Expect(0, 65023, '\P{Blk: arabicpfa}', "");
    Expect(1, 65023, '\P{^Blk: arabicpfa}', "");
    Expect(0, 65024, '\p{Blk: arabicpfa}', "");
    Expect(1, 65024, '\p{^Blk: arabicpfa}', "");
    Expect(1, 65024, '\P{Blk: arabicpfa}', "");
    Expect(0, 65024, '\P{^Blk: arabicpfa}', "");
    Expect(1, 65023, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(1, 65023, '\p{Blk=__Arabic_PF_a}', "");
    Expect(0, 65023, '\p{^Blk=__Arabic_PF_a}', "");
    Expect(0, 65023, '\P{Blk=__Arabic_PF_a}', "");
    Expect(1, 65023, '\P{^Blk=__Arabic_PF_a}', "");
    Expect(0, 65024, '\p{Blk=__Arabic_PF_a}', "");
    Expect(1, 65024, '\p{^Blk=__Arabic_PF_a}', "");
    Expect(1, 65024, '\P{Blk=__Arabic_PF_a}', "");
    Expect(0, 65024, '\P{^Blk=__Arabic_PF_a}', "");
    Error('\p{Is_Block=- ARABIC_presentation_FORMS_A/a/}');
    Error('\P{Is_Block=- ARABIC_presentation_FORMS_A/a/}');
    Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(0, 65023, '\p{^Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(0, 65023, '\P{Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(1, 65023, '\P{^Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(0, 65024, '\p{Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(1, 65024, '\p{^Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(1, 65024, '\P{Is_Block= _Arabic_presentation_Forms_A}', "");
    Expect(0, 65024, '\P{^Is_Block= _Arabic_presentation_Forms_A}', "");
    Error('\p{Is_Blk=-arabic_PF_A/a/}');
    Error('\P{Is_Blk=-arabic_PF_A/a/}');
    Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Is_Blk=_ Arabic_pf_A}', "");
    Expect(0, 65023, '\p{^Is_Blk=_ Arabic_pf_A}', "");
    Expect(0, 65023, '\P{Is_Blk=_ Arabic_pf_A}', "");
    Expect(1, 65023, '\P{^Is_Blk=_ Arabic_pf_A}', "");
    Expect(0, 65024, '\p{Is_Blk=_ Arabic_pf_A}', "");
    Expect(1, 65024, '\p{^Is_Blk=_ Arabic_pf_A}', "");
    Expect(1, 65024, '\P{Is_Blk=_ Arabic_pf_A}', "");
    Expect(0, 65024, '\P{^Is_Blk=_ Arabic_pf_A}', "");
    Error('\p{Block=_	arabic_Presentation_Forms_B/a/}');
    Error('\P{Block=_	arabic_Presentation_Forms_B/a/}');
    Expect(1, 65279, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(0, 65280, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(0, 65280, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(1, 65279, '\p{Block:   _Arabic_presentation_Forms_B}', "");
    Expect(0, 65279, '\p{^Block:   _Arabic_presentation_Forms_B}', "");
    Expect(0, 65279, '\P{Block:   _Arabic_presentation_Forms_B}', "");
    Expect(1, 65279, '\P{^Block:   _Arabic_presentation_Forms_B}', "");
    Expect(0, 65280, '\p{Block:   _Arabic_presentation_Forms_B}', "");
    Expect(1, 65280, '\p{^Block:   _Arabic_presentation_Forms_B}', "");
    Expect(1, 65280, '\P{Block:   _Arabic_presentation_Forms_B}', "");
    Expect(0, 65280, '\P{^Block:   _Arabic_presentation_Forms_B}', "");
    Error('\p{Blk=/a/Arabic_PF_B}');
    Error('\P{Blk=/a/Arabic_PF_B}');
    Expect(1, 65279, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(1, 65279, '\p{Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(1, 65279, '\p{Blk=--ARABIC_pf_B}', "");
    Expect(0, 65279, '\p{^Blk=--ARABIC_pf_B}', "");
    Expect(0, 65279, '\P{Blk=--ARABIC_pf_B}', "");
    Expect(1, 65279, '\P{^Blk=--ARABIC_pf_B}', "");
    Expect(0, 65280, '\p{Blk=--ARABIC_pf_B}', "");
    Expect(1, 65280, '\p{^Blk=--ARABIC_pf_B}', "");
    Expect(1, 65280, '\P{Blk=--ARABIC_pf_B}', "");
    Expect(0, 65280, '\P{^Blk=--ARABIC_pf_B}', "");
    Error('\p{Is_Block=-Arabic_Presentation_Forms_B:=}');
    Error('\P{Is_Block=-Arabic_Presentation_Forms_B:=}');
    Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(0, 65279, '\p{^Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(0, 65279, '\P{Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(1, 65279, '\P{^Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(0, 65280, '\p{Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(1, 65280, '\p{^Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(1, 65280, '\P{Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Expect(0, 65280, '\P{^Is_Block=--Arabic_PRESENTATION_FORMS_b}', "");
    Error('\p{Is_Blk=/a/-arabic_pf_b}');
    Error('\P{Is_Blk=/a/-arabic_pf_b}');
    Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Is_Blk=-_arabic_PF_B}', "");
    Expect(0, 65279, '\p{^Is_Blk=-_arabic_PF_B}', "");
    Expect(0, 65279, '\P{Is_Blk=-_arabic_PF_B}', "");
    Expect(1, 65279, '\P{^Is_Blk=-_arabic_PF_B}', "");
    Expect(0, 65280, '\p{Is_Blk=-_arabic_PF_B}', "");
    Expect(1, 65280, '\p{^Is_Blk=-_arabic_PF_B}', "");
    Expect(1, 65280, '\P{Is_Blk=-_arabic_PF_B}', "");
    Expect(0, 65280, '\P{^Is_Blk=-_arabic_PF_B}', "");
    Error('\p{Block=	:=arabic_Supplement}');
    Error('\P{Block=	:=arabic_Supplement}');
    Expect(1, 1919, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(1, 1919, '\p{Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(1, 1919, '\p{Block=_	arabic_supplement}', "");
    Expect(0, 1919, '\p{^Block=_	arabic_supplement}', "");
    Expect(0, 1919, '\P{Block=_	arabic_supplement}', "");
    Expect(1, 1919, '\P{^Block=_	arabic_supplement}', "");
    Expect(0, 1920, '\p{Block=_	arabic_supplement}', "");
    Expect(1, 1920, '\p{^Block=_	arabic_supplement}', "");
    Expect(1, 1920, '\P{Block=_	arabic_supplement}', "");
    Expect(0, 1920, '\P{^Block=_	arabic_supplement}', "");
    Error('\p{Blk=:=_Arabic_Sup}');
    Error('\P{Blk=:=_Arabic_Sup}');
    Expect(1, 1919, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(1, 1919, '\p{Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(1, 1919, '\p{Blk=	-Arabic_sup}', "");
    Expect(0, 1919, '\p{^Blk=	-Arabic_sup}', "");
    Expect(0, 1919, '\P{Blk=	-Arabic_sup}', "");
    Expect(1, 1919, '\P{^Blk=	-Arabic_sup}', "");
    Expect(0, 1920, '\p{Blk=	-Arabic_sup}', "");
    Expect(1, 1920, '\p{^Blk=	-Arabic_sup}', "");
    Expect(1, 1920, '\P{Blk=	-Arabic_sup}', "");
    Expect(0, 1920, '\P{^Blk=	-Arabic_sup}', "");
    Error('\p{Is_Block=-:=Arabic_SUPPLEMENT}');
    Error('\P{Is_Block=-:=Arabic_SUPPLEMENT}');
    Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(0, 1919, '\p{^Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(0, 1919, '\P{Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(1, 1919, '\P{^Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(0, 1920, '\p{Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(1, 1920, '\p{^Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(1, 1920, '\P{Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Expect(0, 1920, '\P{^Is_Block=_ ARABIC_SUPPLEMENT}', "");
    Error('\p{Is_Blk=:=	 arabic_SUP}');
    Error('\P{Is_Blk=:=	 arabic_SUP}');
    Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Is_Blk=		Arabic_sup}', "");
    Expect(0, 1919, '\p{^Is_Blk=		Arabic_sup}', "");
    Expect(0, 1919, '\P{Is_Blk=		Arabic_sup}', "");
    Expect(1, 1919, '\P{^Is_Blk=		Arabic_sup}', "");
    Expect(0, 1920, '\p{Is_Blk=		Arabic_sup}', "");
    Expect(1, 1920, '\p{^Is_Blk=		Arabic_sup}', "");
    Expect(1, 1920, '\P{Is_Blk=		Arabic_sup}', "");
    Expect(0, 1920, '\P{^Is_Blk=		Arabic_sup}', "");
    Error('\p{Block= ARMENIAN:=}');
    Error('\P{Block= ARMENIAN:=}');
    Expect(1, 1423, '\p{Block=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=armenian}', "");
    Expect(0, 1423, '\p{^Block=armenian}', "");
    Expect(0, 1423, '\P{Block=armenian}', "");
    Expect(1, 1423, '\P{^Block=armenian}', "");
    Expect(0, 1424, '\p{Block=armenian}', "");
    Expect(1, 1424, '\p{^Block=armenian}', "");
    Expect(1, 1424, '\P{Block=armenian}', "");
    Expect(0, 1424, '\P{^Block=armenian}', "");
    Expect(1, 1423, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=		Armenian}', "");
    Expect(0, 1423, '\p{^Block=		Armenian}', "");
    Expect(0, 1423, '\P{Block=		Armenian}', "");
    Expect(1, 1423, '\P{^Block=		Armenian}', "");
    Expect(0, 1424, '\p{Block=		Armenian}', "");
    Expect(1, 1424, '\p{^Block=		Armenian}', "");
    Expect(1, 1424, '\P{Block=		Armenian}', "");
    Expect(0, 1424, '\P{^Block=		Armenian}', "");
    Error('\p{Blk=/a/ ARMENIAN}');
    Error('\P{Blk=/a/ ARMENIAN}');
    Expect(1, 1423, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=armenian}', "");
    Expect(0, 1423, '\p{^Blk=armenian}', "");
    Expect(0, 1423, '\P{Blk=armenian}', "");
    Expect(1, 1423, '\P{^Blk=armenian}', "");
    Expect(0, 1424, '\p{Blk=armenian}', "");
    Expect(1, 1424, '\p{^Blk=armenian}', "");
    Expect(1, 1424, '\P{Blk=armenian}', "");
    Expect(0, 1424, '\P{^Blk=armenian}', "");
    Expect(1, 1423, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=- Armenian}', "");
    Expect(0, 1423, '\p{^Blk=- Armenian}', "");
    Expect(0, 1423, '\P{Blk=- Armenian}', "");
    Expect(1, 1423, '\P{^Blk=- Armenian}', "");
    Expect(0, 1424, '\p{Blk=- Armenian}', "");
    Expect(1, 1424, '\p{^Blk=- Armenian}', "");
    Expect(1, 1424, '\P{Blk=- Armenian}', "");
    Expect(0, 1424, '\P{^Blk=- Armenian}', "");
    Error('\p{Is_Block=/a/- Armenian}');
    Error('\P{Is_Block=/a/- Armenian}');
    Expect(1, 1423, '\p{Is_Block=armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=armenian}', "");
    Expect(0, 1423, '\P{Is_Block=armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=armenian}', "");
    Expect(0, 1424, '\p{Is_Block=armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=armenian}', "");
    Expect(1, 1424, '\P{Is_Block=armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=armenian}', "");
    Expect(1, 1423, '\p{Is_Block=_ARMENIAN}', "");
    Expect(0, 1423, '\p{^Is_Block=_ARMENIAN}', "");
    Expect(0, 1423, '\P{Is_Block=_ARMENIAN}', "");
    Expect(1, 1423, '\P{^Is_Block=_ARMENIAN}', "");
    Expect(0, 1424, '\p{Is_Block=_ARMENIAN}', "");
    Expect(1, 1424, '\p{^Is_Block=_ARMENIAN}', "");
    Expect(1, 1424, '\P{Is_Block=_ARMENIAN}', "");
    Expect(0, 1424, '\P{^Is_Block=_ARMENIAN}', "");
    Error('\p{Is_Blk=:=	 Armenian}');
    Error('\P{Is_Blk=:=	 Armenian}');
    Expect(1, 1423, '\p{Is_Blk=armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
    Expect(0, 1423, '\P{Is_Blk=armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
    Expect(0, 1424, '\p{Is_Blk=armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk=armenian}', "");
    Expect(1, 1424, '\P{Is_Blk=armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk=armenian}', "");
    Expect(1, 1423, '\p{Is_Blk= -Armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk= -Armenian}', "");
    Expect(0, 1423, '\P{Is_Blk= -Armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk= -Armenian}', "");
    Expect(0, 1424, '\p{Is_Blk= -Armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk= -Armenian}', "");
    Expect(1, 1424, '\P{Is_Blk= -Armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk= -Armenian}', "");
    Error('\p{Block= -arrows:=}');
    Error('\P{Block= -arrows:=}');
    Expect(1, 8703, '\p{Block=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Block=arrows}', "");
    Expect(0, 8703, '\p{^Block=arrows}', "");
    Expect(0, 8703, '\P{Block=arrows}', "");
    Expect(1, 8703, '\P{^Block=arrows}', "");
    Expect(0, 8704, '\p{Block=arrows}', "");
    Expect(1, 8704, '\p{^Block=arrows}', "");
    Expect(1, 8704, '\P{Block=arrows}', "");
    Expect(0, 8704, '\P{^Block=arrows}', "");
    Expect(1, 8703, '\p{Block=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Block=_Arrows}', "");
    Expect(0, 8703, '\p{^Block=_Arrows}', "");
    Expect(0, 8703, '\P{Block=_Arrows}', "");
    Expect(1, 8703, '\P{^Block=_Arrows}', "");
    Expect(0, 8704, '\p{Block=_Arrows}', "");
    Expect(1, 8704, '\p{^Block=_Arrows}', "");
    Expect(1, 8704, '\P{Block=_Arrows}', "");
    Expect(0, 8704, '\P{^Block=_Arrows}', "");
    Error('\p{Blk=/a/	Arrows}');
    Error('\P{Blk=/a/	Arrows}');
    Expect(1, 8703, '\p{Blk=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=arrows}', "");
    Expect(0, 8703, '\p{^Blk=arrows}', "");
    Expect(0, 8703, '\P{Blk=arrows}', "");
    Expect(1, 8703, '\P{^Blk=arrows}', "");
    Expect(0, 8704, '\p{Blk=arrows}', "");
    Expect(1, 8704, '\p{^Blk=arrows}', "");
    Expect(1, 8704, '\P{Blk=arrows}', "");
    Expect(0, 8704, '\P{^Blk=arrows}', "");
    Expect(1, 8703, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=		Arrows}', "");
    Expect(0, 8703, '\p{^Blk=		Arrows}', "");
    Expect(0, 8703, '\P{Blk=		Arrows}', "");
    Expect(1, 8703, '\P{^Blk=		Arrows}', "");
    Expect(0, 8704, '\p{Blk=		Arrows}', "");
    Expect(1, 8704, '\p{^Blk=		Arrows}', "");
    Expect(1, 8704, '\P{Blk=		Arrows}', "");
    Expect(0, 8704, '\P{^Blk=		Arrows}', "");
    Error('\p{Is_Block=	ARROWS:=}');
    Error('\P{Is_Block=	ARROWS:=}');
    Expect(1, 8703, '\p{Is_Block=arrows}', "");
    Expect(0, 8703, '\p{^Is_Block=arrows}', "");
    Expect(0, 8703, '\P{Is_Block=arrows}', "");
    Expect(1, 8703, '\P{^Is_Block=arrows}', "");
    Expect(0, 8704, '\p{Is_Block=arrows}', "");
    Expect(1, 8704, '\p{^Is_Block=arrows}', "");
    Expect(1, 8704, '\P{Is_Block=arrows}', "");
    Expect(0, 8704, '\P{^Is_Block=arrows}', "");
    Expect(1, 8703, '\p{Is_Block= -Arrows}', "");
    Expect(0, 8703, '\p{^Is_Block= -Arrows}', "");
    Expect(0, 8703, '\P{Is_Block= -Arrows}', "");
    Expect(1, 8703, '\P{^Is_Block= -Arrows}', "");
    Expect(0, 8704, '\p{Is_Block= -Arrows}', "");
    Expect(1, 8704, '\p{^Is_Block= -Arrows}', "");
    Expect(1, 8704, '\P{Is_Block= -Arrows}', "");
    Expect(0, 8704, '\P{^Is_Block= -Arrows}', "");
    Error('\p{Is_Blk=:=_ Arrows}');
    Error('\P{Is_Blk=:=_ Arrows}');
    Expect(1, 8703, '\p{Is_Blk=arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
    Expect(1, 8703, '\p{Is_Blk=-Arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=-Arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=-Arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=-Arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=-Arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=-Arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=-Arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=-Arrows}', "");
    Error('\p{Block:	__BASIC_LATIN:=}');
    Error('\P{Block:	__BASIC_LATIN:=}');
    Expect(1, 127, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(0, 128, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(1, 127, '\p{Block=basiclatin}', "");
    Expect(0, 127, '\p{^Block=basiclatin}', "");
    Expect(0, 127, '\P{Block=basiclatin}', "");
    Expect(1, 127, '\P{^Block=basiclatin}', "");
    Expect(0, 128, '\p{Block=basiclatin}', "");
    Expect(1, 128, '\p{^Block=basiclatin}', "");
    Expect(1, 128, '\P{Block=basiclatin}', "");
    Expect(0, 128, '\P{^Block=basiclatin}', "");
    Expect(1, 127, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(0, 128, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(1, 127, '\p{Block:   __Basic_Latin}', "");
    Expect(0, 127, '\p{^Block:   __Basic_Latin}', "");
    Expect(0, 127, '\P{Block:   __Basic_Latin}', "");
    Expect(1, 127, '\P{^Block:   __Basic_Latin}', "");
    Expect(0, 128, '\p{Block:   __Basic_Latin}', "");
    Expect(1, 128, '\p{^Block:   __Basic_Latin}', "");
    Expect(1, 128, '\P{Block:   __Basic_Latin}', "");
    Expect(0, 128, '\P{^Block:   __Basic_Latin}', "");
    Error('\p{Blk= /a/ascii}');
    Error('\P{Blk= /a/ascii}');
    Expect(1, 127, '\p{Blk=:\AASCII\z:}', "");;
    Expect(0, 128, '\p{Blk=:\AASCII\z:}', "");;
    Expect(1, 127, '\p{Blk=ascii}', "");
    Expect(0, 127, '\p{^Blk=ascii}', "");
    Expect(0, 127, '\P{Blk=ascii}', "");
    Expect(1, 127, '\P{^Blk=ascii}', "");
    Expect(0, 128, '\p{Blk=ascii}', "");
    Expect(1, 128, '\p{^Blk=ascii}', "");
    Expect(1, 128, '\P{Blk=ascii}', "");
    Expect(0, 128, '\P{^Blk=ascii}', "");
    Expect(1, 127, '\p{Blk=:\Aascii\z:}', "");;
    Expect(0, 128, '\p{Blk=:\Aascii\z:}', "");;
    Expect(1, 127, '\p{Blk=	 ascii}', "");
    Expect(0, 127, '\p{^Blk=	 ascii}', "");
    Expect(0, 127, '\P{Blk=	 ascii}', "");
    Expect(1, 127, '\P{^Blk=	 ascii}', "");
    Expect(0, 128, '\p{Blk=	 ascii}', "");
    Expect(1, 128, '\p{^Blk=	 ascii}', "");
    Expect(1, 128, '\P{Blk=	 ascii}', "");
    Expect(0, 128, '\P{^Blk=	 ascii}', "");
    Error('\p{Is_Block=/a/-Basic_Latin}');
    Error('\P{Is_Block=/a/-Basic_Latin}');
    Expect(1, 127, '\p{Is_Block=basiclatin}', "");
    Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
    Expect(0, 127, '\P{Is_Block=basiclatin}', "");
    Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
    Expect(0, 128, '\p{Is_Block=basiclatin}', "");
    Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
    Expect(1, 128, '\P{Is_Block=basiclatin}', "");
    Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
    Expect(1, 127, '\p{Is_Block=-	Basic_LATIN}', "");
    Expect(0, 127, '\p{^Is_Block=-	Basic_LATIN}', "");
    Expect(0, 127, '\P{Is_Block=-	Basic_LATIN}', "");
    Expect(1, 127, '\P{^Is_Block=-	Basic_LATIN}', "");
    Expect(0, 128, '\p{Is_Block=-	Basic_LATIN}', "");
    Expect(1, 128, '\p{^Is_Block=-	Basic_LATIN}', "");
    Expect(1, 128, '\P{Is_Block=-	Basic_LATIN}', "");
    Expect(0, 128, '\P{^Is_Block=-	Basic_LATIN}', "");
    Error('\p{Is_Blk=/a/_	ASCII}');
    Error('\P{Is_Blk=/a/_	ASCII}');
    Expect(1, 127, '\p{Is_Blk=ascii}', "");
    Expect(0, 127, '\p{^Is_Blk=ascii}', "");
    Expect(0, 127, '\P{Is_Blk=ascii}', "");
    Expect(1, 127, '\P{^Is_Blk=ascii}', "");
    Expect(0, 128, '\p{Is_Blk=ascii}', "");
    Expect(1, 128, '\p{^Is_Blk=ascii}', "");
    Expect(1, 128, '\P{Is_Blk=ascii}', "");
    Expect(0, 128, '\P{^Is_Blk=ascii}', "");
    Expect(1, 127, '\p{Is_Blk= -ASCII}', "");
    Expect(0, 127, '\p{^Is_Blk= -ASCII}', "");
    Expect(0, 127, '\P{Is_Blk= -ASCII}', "");
    Expect(1, 127, '\P{^Is_Blk= -ASCII}', "");
    Expect(0, 128, '\p{Is_Blk= -ASCII}', "");
    Expect(1, 128, '\p{^Is_Blk= -ASCII}', "");
    Expect(1, 128, '\P{Is_Blk= -ASCII}', "");
    Expect(0, 128, '\P{^Is_Blk= -ASCII}', "");
    Error('\p{Block=:=__Avestan}');
    Error('\P{Block=:=__Avestan}');
    Expect(1, 68415, '\p{Block=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Block=avestan}', "");
    Expect(0, 68415, '\p{^Block=avestan}', "");
    Expect(0, 68415, '\P{Block=avestan}', "");
    Expect(1, 68415, '\P{^Block=avestan}', "");
    Expect(0, 68416, '\p{Block=avestan}', "");
    Expect(1, 68416, '\p{^Block=avestan}', "");
    Expect(1, 68416, '\P{Block=avestan}', "");
    Expect(0, 68416, '\P{^Block=avestan}', "");
    Expect(1, 68415, '\p{Block=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Block=	_Avestan}', "");
    Expect(0, 68415, '\p{^Block=	_Avestan}', "");
    Expect(0, 68415, '\P{Block=	_Avestan}', "");
    Expect(1, 68415, '\P{^Block=	_Avestan}', "");
    Expect(0, 68416, '\p{Block=	_Avestan}', "");
    Expect(1, 68416, '\p{^Block=	_Avestan}', "");
    Expect(1, 68416, '\P{Block=	_Avestan}', "");
    Expect(0, 68416, '\P{^Block=	_Avestan}', "");
    Error('\p{Blk=	_Avestan/a/}');
    Error('\P{Blk=	_Avestan/a/}');
    Expect(1, 68415, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=avestan}', "");
    Expect(0, 68415, '\p{^Blk=avestan}', "");
    Expect(0, 68415, '\P{Blk=avestan}', "");
    Expect(1, 68415, '\P{^Blk=avestan}', "");
    Expect(0, 68416, '\p{Blk=avestan}', "");
    Expect(1, 68416, '\p{^Blk=avestan}', "");
    Expect(1, 68416, '\P{Blk=avestan}', "");
    Expect(0, 68416, '\P{^Blk=avestan}', "");
    Expect(1, 68415, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Blk= Avestan}', "");
    Expect(0, 68415, '\p{^Blk= Avestan}', "");
    Expect(0, 68415, '\P{Blk= Avestan}', "");
    Expect(1, 68415, '\P{^Blk= Avestan}', "");
    Expect(0, 68416, '\p{Blk= Avestan}', "");
    Expect(1, 68416, '\p{^Blk= Avestan}', "");
    Expect(1, 68416, '\P{Blk= Avestan}', "");
    Expect(0, 68416, '\P{^Blk= Avestan}', "");
    Error('\p{Is_Block=-/a/Avestan}');
    Error('\P{Is_Block=-/a/Avestan}');
    Expect(1, 68415, '\p{Is_Block=avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=avestan}', "");
    Expect(0, 68415, '\P{Is_Block=avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=avestan}', "");
    Expect(0, 68416, '\p{Is_Block=avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=avestan}', "");
    Expect(1, 68416, '\P{Is_Block=avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=avestan}', "");
    Expect(1, 68415, '\p{Is_Block=-Avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=-Avestan}', "");
    Expect(0, 68415, '\P{Is_Block=-Avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=-Avestan}', "");
    Expect(0, 68416, '\p{Is_Block=-Avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=-Avestan}', "");
    Expect(1, 68416, '\P{Is_Block=-Avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=-Avestan}', "");
    Error('\p{Is_Blk:  :=Avestan}');
    Error('\P{Is_Blk:  :=Avestan}');
    Expect(1, 68415, '\p{Is_Blk=avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
    Expect(0, 68415, '\P{Is_Blk=avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
    Expect(0, 68416, '\p{Is_Blk=avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk=avestan}', "");
    Expect(1, 68416, '\P{Is_Blk=avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk=avestan}', "");
    Expect(1, 68415, '\p{Is_Blk=_Avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk=_Avestan}', "");
    Expect(0, 68415, '\P{Is_Blk=_Avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk=_Avestan}', "");
    Expect(0, 68416, '\p{Is_Blk=_Avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk=_Avestan}', "");
    Expect(1, 68416, '\P{Is_Blk=_Avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk=_Avestan}', "");
    Error('\p{Block=:=	balinese}');
    Error('\P{Block=:=	balinese}');
    Expect(1, 7039, '\p{Block=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Block:balinese}', "");
    Expect(0, 7039, '\p{^Block:balinese}', "");
    Expect(0, 7039, '\P{Block:balinese}', "");
    Expect(1, 7039, '\P{^Block:balinese}', "");
    Expect(0, 7040, '\p{Block:balinese}', "");
    Expect(1, 7040, '\p{^Block:balinese}', "");
    Expect(1, 7040, '\P{Block:balinese}', "");
    Expect(0, 7040, '\P{^Block:balinese}', "");
    Expect(1, 7039, '\p{Block=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=-	Balinese}', "");
    Expect(0, 7039, '\p{^Block=-	Balinese}', "");
    Expect(0, 7039, '\P{Block=-	Balinese}', "");
    Expect(1, 7039, '\P{^Block=-	Balinese}', "");
    Expect(0, 7040, '\p{Block=-	Balinese}', "");
    Expect(1, 7040, '\p{^Block=-	Balinese}', "");
    Expect(1, 7040, '\P{Block=-	Balinese}', "");
    Expect(0, 7040, '\P{^Block=-	Balinese}', "");
    Error('\p{Blk=-:=Balinese}');
    Error('\P{Blk=-:=Balinese}');
    Expect(1, 7039, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=balinese}', "");
    Expect(0, 7039, '\p{^Blk=balinese}', "");
    Expect(0, 7039, '\P{Blk=balinese}', "");
    Expect(1, 7039, '\P{^Blk=balinese}', "");
    Expect(0, 7040, '\p{Blk=balinese}', "");
    Expect(1, 7040, '\p{^Blk=balinese}', "");
    Expect(1, 7040, '\P{Blk=balinese}', "");
    Expect(0, 7040, '\P{^Blk=balinese}', "");
    Expect(1, 7039, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=-	BALINESE}', "");
    Expect(0, 7039, '\p{^Blk=-	BALINESE}', "");
    Expect(0, 7039, '\P{Blk=-	BALINESE}', "");
    Expect(1, 7039, '\P{^Blk=-	BALINESE}', "");
    Expect(0, 7040, '\p{Blk=-	BALINESE}', "");
    Expect(1, 7040, '\p{^Blk=-	BALINESE}', "");
    Expect(1, 7040, '\P{Blk=-	BALINESE}', "");
    Expect(0, 7040, '\P{^Blk=-	BALINESE}', "");
    Error('\p{Is_Block: -:=BALINESE}');
    Error('\P{Is_Block: -:=BALINESE}');
    Expect(1, 7039, '\p{Is_Block=balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=balinese}', "");
    Expect(0, 7039, '\P{Is_Block=balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=balinese}', "");
    Expect(0, 7040, '\p{Is_Block=balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=balinese}', "");
    Expect(1, 7040, '\P{Is_Block=balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=balinese}', "");
    Expect(1, 7039, '\p{Is_Block=_BALINESE}', "");
    Expect(0, 7039, '\p{^Is_Block=_BALINESE}', "");
    Expect(0, 7039, '\P{Is_Block=_BALINESE}', "");
    Expect(1, 7039, '\P{^Is_Block=_BALINESE}', "");
    Expect(0, 7040, '\p{Is_Block=_BALINESE}', "");
    Expect(1, 7040, '\p{^Is_Block=_BALINESE}', "");
    Expect(1, 7040, '\P{Is_Block=_BALINESE}', "");
    Expect(0, 7040, '\P{^Is_Block=_BALINESE}', "");
    Error('\p{Is_Blk=		Balinese:=}');
    Error('\P{Is_Blk=		Balinese:=}');
    Expect(1, 7039, '\p{Is_Blk=balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
    Expect(1, 7039, '\p{Is_Blk=_	BALINESE}', "");
    Expect(0, 7039, '\p{^Is_Blk=_	BALINESE}', "");
    Expect(0, 7039, '\P{Is_Blk=_	BALINESE}', "");
    Expect(1, 7039, '\P{^Is_Blk=_	BALINESE}', "");
    Expect(0, 7040, '\p{Is_Blk=_	BALINESE}', "");
    Expect(1, 7040, '\p{^Is_Blk=_	BALINESE}', "");
    Expect(1, 7040, '\P{Is_Blk=_	BALINESE}', "");
    Expect(0, 7040, '\P{^Is_Blk=_	BALINESE}', "");
    Error('\p{Block=-BAMUM:=}');
    Error('\P{Block=-BAMUM:=}');
    Expect(1, 42751, '\p{Block=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Block=bamum}', "");
    Expect(0, 42751, '\p{^Block=bamum}', "");
    Expect(0, 42751, '\P{Block=bamum}', "");
    Expect(1, 42751, '\P{^Block=bamum}', "");
    Expect(0, 42752, '\p{Block=bamum}', "");
    Expect(1, 42752, '\p{^Block=bamum}', "");
    Expect(1, 42752, '\P{Block=bamum}', "");
    Expect(0, 42752, '\P{^Block=bamum}', "");
    Expect(1, 42751, '\p{Block=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Block=	Bamum}', "");
    Expect(0, 42751, '\p{^Block=	Bamum}', "");
    Expect(0, 42751, '\P{Block=	Bamum}', "");
    Expect(1, 42751, '\P{^Block=	Bamum}', "");
    Expect(0, 42752, '\p{Block=	Bamum}', "");
    Expect(1, 42752, '\p{^Block=	Bamum}', "");
    Expect(1, 42752, '\P{Block=	Bamum}', "");
    Expect(0, 42752, '\P{^Block=	Bamum}', "");
    Error('\p{Blk=/a/_bamum}');
    Error('\P{Blk=/a/_bamum}');
    Expect(1, 42751, '\p{Blk=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=bamum}', "");
    Expect(0, 42751, '\p{^Blk=bamum}', "");
    Expect(0, 42751, '\P{Blk=bamum}', "");
    Expect(1, 42751, '\P{^Blk=bamum}', "");
    Expect(0, 42752, '\p{Blk=bamum}', "");
    Expect(1, 42752, '\p{^Blk=bamum}', "");
    Expect(1, 42752, '\P{Blk=bamum}', "");
    Expect(0, 42752, '\P{^Blk=bamum}', "");
    Expect(1, 42751, '\p{Blk=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Blk:	-BAMUM}', "");
    Expect(0, 42751, '\p{^Blk:	-BAMUM}', "");
    Expect(0, 42751, '\P{Blk:	-BAMUM}', "");
    Expect(1, 42751, '\P{^Blk:	-BAMUM}', "");
    Expect(0, 42752, '\p{Blk:	-BAMUM}', "");
    Expect(1, 42752, '\p{^Blk:	-BAMUM}', "");
    Expect(1, 42752, '\P{Blk:	-BAMUM}', "");
    Expect(0, 42752, '\P{^Blk:	-BAMUM}', "");
    Error('\p{Is_Block=:=_Bamum}');
    Error('\P{Is_Block=:=_Bamum}');
    Expect(1, 42751, '\p{Is_Block=bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=bamum}', "");
    Expect(0, 42751, '\P{Is_Block=bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=bamum}', "");
    Expect(0, 42752, '\p{Is_Block=bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=bamum}', "");
    Expect(1, 42752, '\P{Is_Block=bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=bamum}', "");
    Expect(1, 42751, '\p{Is_Block:- bamum}', "");
    Expect(0, 42751, '\p{^Is_Block:- bamum}', "");
    Expect(0, 42751, '\P{Is_Block:- bamum}', "");
    Expect(1, 42751, '\P{^Is_Block:- bamum}', "");
    Expect(0, 42752, '\p{Is_Block:- bamum}', "");
    Expect(1, 42752, '\p{^Is_Block:- bamum}', "");
    Expect(1, 42752, '\P{Is_Block:- bamum}', "");
    Expect(0, 42752, '\P{^Is_Block:- bamum}', "");
    Error('\p{Is_Blk= _BAMUM/a/}');
    Error('\P{Is_Blk= _BAMUM/a/}');
    Expect(1, 42751, '\p{Is_Blk=bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
    Expect(1, 42751, '\p{Is_Blk=	-Bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=	-Bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=	-Bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=	-Bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=	-Bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=	-Bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=	-Bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=	-Bamum}', "");
    Error('\p{Block=_ Bamum_Supplement/a/}');
    Error('\P{Block=_ Bamum_Supplement/a/}');
    Expect(1, 92735, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(1, 92735, '\p{Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(1, 92735, '\p{Block=-	Bamum_Supplement}', "");
    Expect(0, 92735, '\p{^Block=-	Bamum_Supplement}', "");
    Expect(0, 92735, '\P{Block=-	Bamum_Supplement}', "");
    Expect(1, 92735, '\P{^Block=-	Bamum_Supplement}', "");
    Expect(0, 92736, '\p{Block=-	Bamum_Supplement}', "");
    Expect(1, 92736, '\p{^Block=-	Bamum_Supplement}', "");
    Expect(1, 92736, '\P{Block=-	Bamum_Supplement}', "");
    Expect(0, 92736, '\P{^Block=-	Bamum_Supplement}', "");
    Error('\p{Blk=/a/BAMUM_SUP}');
    Error('\P{Blk=/a/BAMUM_SUP}');
    Expect(1, 92735, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(1, 92735, '\p{Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(1, 92735, '\p{Blk=_ Bamum_Sup}', "");
    Expect(0, 92735, '\p{^Blk=_ Bamum_Sup}', "");
    Expect(0, 92735, '\P{Blk=_ Bamum_Sup}', "");
    Expect(1, 92735, '\P{^Blk=_ Bamum_Sup}', "");
    Expect(0, 92736, '\p{Blk=_ Bamum_Sup}', "");
    Expect(1, 92736, '\p{^Blk=_ Bamum_Sup}', "");
    Expect(1, 92736, '\P{Blk=_ Bamum_Sup}', "");
    Expect(0, 92736, '\P{^Blk=_ Bamum_Sup}', "");
    Error('\p{Is_Block=/a/ bamum_Supplement}');
    Error('\P{Is_Block=/a/ bamum_Supplement}');
    Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(0, 92735, '\p{^Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(0, 92735, '\P{Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(1, 92735, '\P{^Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(0, 92736, '\p{Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(1, 92736, '\p{^Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(1, 92736, '\P{Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Expect(0, 92736, '\P{^Is_Block: _ BAMUM_SUPPLEMENT}', "");
    Error('\p{Is_Blk=-:=Bamum_sup}');
    Error('\P{Is_Blk=-:=Bamum_sup}');
    Expect(1, 92735, '\p{Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Is_Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Is_Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Is_Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Is_Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Is_Blk=-Bamum_Sup}', "");
    Expect(0, 92735, '\p{^Is_Blk=-Bamum_Sup}', "");
    Expect(0, 92735, '\P{Is_Blk=-Bamum_Sup}', "");
    Expect(1, 92735, '\P{^Is_Blk=-Bamum_Sup}', "");
    Expect(0, 92736, '\p{Is_Blk=-Bamum_Sup}', "");
    Expect(1, 92736, '\p{^Is_Blk=-Bamum_Sup}', "");
    Expect(1, 92736, '\P{Is_Blk=-Bamum_Sup}', "");
    Expect(0, 92736, '\P{^Is_Blk=-Bamum_Sup}', "");
    Error('\p{Block=/a/Bassa_Vah}');
    Error('\P{Block=/a/Bassa_Vah}');
    Expect(1, 92927, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Block:   bassavah}', "");
    Expect(0, 92927, '\p{^Block:   bassavah}', "");
    Expect(0, 92927, '\P{Block:   bassavah}', "");
    Expect(1, 92927, '\P{^Block:   bassavah}', "");
    Expect(0, 92928, '\p{Block:   bassavah}', "");
    Expect(1, 92928, '\p{^Block:   bassavah}', "");
    Expect(1, 92928, '\P{Block:   bassavah}', "");
    Expect(0, 92928, '\P{^Block:   bassavah}', "");
    Expect(1, 92927, '\p{Block=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Block:   -	Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Block:   -	Bassa_Vah}', "");
    Expect(0, 92927, '\P{Block:   -	Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Block:   -	Bassa_Vah}', "");
    Expect(0, 92928, '\p{Block:   -	Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Block:   -	Bassa_Vah}', "");
    Expect(1, 92928, '\P{Block:   -	Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Block:   -	Bassa_Vah}', "");
    Error('\p{Blk= 	BASSA_VAH/a/}');
    Error('\P{Blk= 	BASSA_VAH/a/}');
    Expect(1, 92927, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Blk: bassavah}', "");
    Expect(0, 92927, '\p{^Blk: bassavah}', "");
    Expect(0, 92927, '\P{Blk: bassavah}', "");
    Expect(1, 92927, '\P{^Blk: bassavah}', "");
    Expect(0, 92928, '\p{Blk: bassavah}', "");
    Expect(1, 92928, '\p{^Blk: bassavah}', "");
    Expect(1, 92928, '\P{Blk: bassavah}', "");
    Expect(0, 92928, '\P{^Blk: bassavah}', "");
    Expect(1, 92927, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Blk:__bassa_VAH}', "");
    Expect(0, 92927, '\p{^Blk:__bassa_VAH}', "");
    Expect(0, 92927, '\P{Blk:__bassa_VAH}', "");
    Expect(1, 92927, '\P{^Blk:__bassa_VAH}', "");
    Expect(0, 92928, '\p{Blk:__bassa_VAH}', "");
    Expect(1, 92928, '\p{^Blk:__bassa_VAH}', "");
    Expect(1, 92928, '\P{Blk:__bassa_VAH}', "");
    Expect(0, 92928, '\P{^Blk:__bassa_VAH}', "");
    Error('\p{Is_Block=/a/ BASSA_Vah}');
    Error('\P{Is_Block=/a/ BASSA_Vah}');
    Expect(1, 92927, '\p{Is_Block=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
    Expect(0, 92927, '\P{Is_Block=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
    Expect(0, 92928, '\p{Is_Block=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
    Expect(1, 92928, '\P{Is_Block=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
    Expect(1, 92927, '\p{Is_Block= Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Is_Block= Bassa_Vah}', "");
    Expect(0, 92927, '\P{Is_Block= Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Is_Block= Bassa_Vah}', "");
    Expect(0, 92928, '\p{Is_Block= Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Is_Block= Bassa_Vah}', "");
    Expect(1, 92928, '\P{Is_Block= Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Is_Block= Bassa_Vah}', "");
    Error('\p{Is_Blk=  Bassa_Vah/a/}');
    Error('\P{Is_Blk=  Bassa_Vah/a/}');
    Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
    Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
    Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
    Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
    Expect(1, 92927, '\p{Is_Blk= bassa_vah}', "");
    Expect(0, 92927, '\p{^Is_Blk= bassa_vah}', "");
    Expect(0, 92927, '\P{Is_Blk= bassa_vah}', "");
    Expect(1, 92927, '\P{^Is_Blk= bassa_vah}', "");
    Expect(0, 92928, '\p{Is_Blk= bassa_vah}', "");
    Expect(1, 92928, '\p{^Is_Blk= bassa_vah}', "");
    Expect(1, 92928, '\P{Is_Blk= bassa_vah}', "");
    Expect(0, 92928, '\P{^Is_Blk= bassa_vah}', "");
    Error('\p{Block=:=		batak}');
    Error('\P{Block=:=		batak}');
    Expect(1, 7167, '\p{Block=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Block=batak}', "");
    Expect(0, 7167, '\p{^Block=batak}', "");
    Expect(0, 7167, '\P{Block=batak}', "");
    Expect(1, 7167, '\P{^Block=batak}', "");
    Expect(0, 7168, '\p{Block=batak}', "");
    Expect(1, 7168, '\p{^Block=batak}', "");
    Expect(1, 7168, '\P{Block=batak}', "");
    Expect(0, 7168, '\P{^Block=batak}', "");
    Expect(1, 7167, '\p{Block=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Block= Batak}', "");
    Expect(0, 7167, '\p{^Block= Batak}', "");
    Expect(0, 7167, '\P{Block= Batak}', "");
    Expect(1, 7167, '\P{^Block= Batak}', "");
    Expect(0, 7168, '\p{Block= Batak}', "");
    Expect(1, 7168, '\p{^Block= Batak}', "");
    Expect(1, 7168, '\P{Block= Batak}', "");
    Expect(0, 7168, '\P{^Block= Batak}', "");
    Error('\p{Blk= /a/batak}');
    Error('\P{Blk= /a/batak}');
    Expect(1, 7167, '\p{Blk=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Blk=batak}', "");
    Expect(0, 7167, '\p{^Blk=batak}', "");
    Expect(0, 7167, '\P{Blk=batak}', "");
    Expect(1, 7167, '\P{^Blk=batak}', "");
    Expect(0, 7168, '\p{Blk=batak}', "");
    Expect(1, 7168, '\p{^Blk=batak}', "");
    Expect(1, 7168, '\P{Blk=batak}', "");
    Expect(0, 7168, '\P{^Blk=batak}', "");
    Expect(1, 7167, '\p{Blk=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Blk= BATAK}', "");
    Expect(0, 7167, '\p{^Blk= BATAK}', "");
    Expect(0, 7167, '\P{Blk= BATAK}', "");
    Expect(1, 7167, '\P{^Blk= BATAK}', "");
    Expect(0, 7168, '\p{Blk= BATAK}', "");
    Expect(1, 7168, '\p{^Blk= BATAK}', "");
    Expect(1, 7168, '\P{Blk= BATAK}', "");
    Expect(0, 7168, '\P{^Blk= BATAK}', "");
    Error('\p{Is_Block=:= 	Batak}');
    Error('\P{Is_Block=:= 	Batak}');
    Expect(1, 7167, '\p{Is_Block=batak}', "");
    Expect(0, 7167, '\p{^Is_Block=batak}', "");
    Expect(0, 7167, '\P{Is_Block=batak}', "");
    Expect(1, 7167, '\P{^Is_Block=batak}', "");
    Expect(0, 7168, '\p{Is_Block=batak}', "");
    Expect(1, 7168, '\p{^Is_Block=batak}', "");
    Expect(1, 7168, '\P{Is_Block=batak}', "");
    Expect(0, 7168, '\P{^Is_Block=batak}', "");
    Expect(1, 7167, '\p{Is_Block=_-BATAK}', "");
    Expect(0, 7167, '\p{^Is_Block=_-BATAK}', "");
    Expect(0, 7167, '\P{Is_Block=_-BATAK}', "");
    Expect(1, 7167, '\P{^Is_Block=_-BATAK}', "");
    Expect(0, 7168, '\p{Is_Block=_-BATAK}', "");
    Expect(1, 7168, '\p{^Is_Block=_-BATAK}', "");
    Expect(1, 7168, '\P{Is_Block=_-BATAK}', "");
    Expect(0, 7168, '\P{^Is_Block=_-BATAK}', "");
    Error('\p{Is_Blk:  	Batak/a/}');
    Error('\P{Is_Blk:  	Batak/a/}');
    Expect(1, 7167, '\p{Is_Blk=batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=batak}', "");
    Expect(0, 7167, '\P{Is_Blk=batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=batak}', "");
    Expect(0, 7168, '\p{Is_Blk=batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=batak}', "");
    Expect(1, 7168, '\P{Is_Blk=batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=batak}', "");
    Expect(1, 7167, '\p{Is_Blk= 	BATAK}', "");
    Expect(0, 7167, '\p{^Is_Blk= 	BATAK}', "");
    Expect(0, 7167, '\P{Is_Blk= 	BATAK}', "");
    Expect(1, 7167, '\P{^Is_Blk= 	BATAK}', "");
    Expect(0, 7168, '\p{Is_Blk= 	BATAK}', "");
    Expect(1, 7168, '\p{^Is_Blk= 	BATAK}', "");
    Expect(1, 7168, '\P{Is_Blk= 	BATAK}', "");
    Expect(0, 7168, '\P{^Is_Blk= 	BATAK}', "");
    Error('\p{Block=-bengali/a/}');
    Error('\P{Block=-bengali/a/}');
    Expect(1, 2559, '\p{Block=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Block=bengali}', "");
    Expect(0, 2559, '\p{^Block=bengali}', "");
    Expect(0, 2559, '\P{Block=bengali}', "");
    Expect(1, 2559, '\P{^Block=bengali}', "");
    Expect(0, 2560, '\p{Block=bengali}', "");
    Expect(1, 2560, '\p{^Block=bengali}', "");
    Expect(1, 2560, '\P{Block=bengali}', "");
    Expect(0, 2560, '\P{^Block=bengali}', "");
    Expect(1, 2559, '\p{Block=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Block=__Bengali}', "");
    Expect(0, 2559, '\p{^Block=__Bengali}', "");
    Expect(0, 2559, '\P{Block=__Bengali}', "");
    Expect(1, 2559, '\P{^Block=__Bengali}', "");
    Expect(0, 2560, '\p{Block=__Bengali}', "");
    Expect(1, 2560, '\p{^Block=__Bengali}', "");
    Expect(1, 2560, '\P{Block=__Bengali}', "");
    Expect(0, 2560, '\P{^Block=__Bengali}', "");
    Error('\p{Blk=-:=Bengali}');
    Error('\P{Blk=-:=Bengali}');
    Expect(1, 2559, '\p{Blk=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=bengali}', "");
    Expect(0, 2559, '\p{^Blk=bengali}', "");
    Expect(0, 2559, '\P{Blk=bengali}', "");
    Expect(1, 2559, '\P{^Blk=bengali}', "");
    Expect(0, 2560, '\p{Blk=bengali}', "");
    Expect(1, 2560, '\p{^Blk=bengali}', "");
    Expect(1, 2560, '\P{Blk=bengali}', "");
    Expect(0, 2560, '\P{^Blk=bengali}', "");
    Expect(1, 2559, '\p{Blk=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Blk: - Bengali}', "");
    Expect(0, 2559, '\p{^Blk: - Bengali}', "");
    Expect(0, 2559, '\P{Blk: - Bengali}', "");
    Expect(1, 2559, '\P{^Blk: - Bengali}', "");
    Expect(0, 2560, '\p{Blk: - Bengali}', "");
    Expect(1, 2560, '\p{^Blk: - Bengali}', "");
    Expect(1, 2560, '\P{Blk: - Bengali}', "");
    Expect(0, 2560, '\P{^Blk: - Bengali}', "");
    Error('\p{Is_Block=-_bengali/a/}');
    Error('\P{Is_Block=-_bengali/a/}');
    Expect(1, 2559, '\p{Is_Block:   bengali}', "");
    Expect(0, 2559, '\p{^Is_Block:   bengali}', "");
    Expect(0, 2559, '\P{Is_Block:   bengali}', "");
    Expect(1, 2559, '\P{^Is_Block:   bengali}', "");
    Expect(0, 2560, '\p{Is_Block:   bengali}', "");
    Expect(1, 2560, '\p{^Is_Block:   bengali}', "");
    Expect(1, 2560, '\P{Is_Block:   bengali}', "");
    Expect(0, 2560, '\P{^Is_Block:   bengali}', "");
    Expect(1, 2559, '\p{Is_Block=Bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=Bengali}', "");
    Expect(0, 2559, '\P{Is_Block=Bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=Bengali}', "");
    Expect(0, 2560, '\p{Is_Block=Bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=Bengali}', "");
    Expect(1, 2560, '\P{Is_Block=Bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=Bengali}', "");
    Error('\p{Is_Blk=_/a/Bengali}');
    Error('\P{Is_Blk=_/a/Bengali}');
    Expect(1, 2559, '\p{Is_Blk=bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=bengali}', "");
    Expect(1, 2559, '\p{Is_Blk=	_Bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=	_Bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=	_Bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=	_Bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=	_Bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=	_Bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=	_Bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=	_Bengali}', "");
    Error('\p{Block=-/a/BHAIKSUKI}');
    Error('\P{Block=-/a/BHAIKSUKI}');
    Expect(1, 72815, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=	Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=	Bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=	Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=	Bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=	Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=	Bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=	Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=	Bhaiksuki}', "");
    Error('\p{Blk:	:=-bhaiksuki}');
    Error('\P{Blk:	:=-bhaiksuki}');
    Expect(1, 72815, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=-	BHAIKSUKI}', "");
    Expect(0, 72815, '\p{^Blk=-	BHAIKSUKI}', "");
    Expect(0, 72815, '\P{Blk=-	BHAIKSUKI}', "");
    Expect(1, 72815, '\P{^Blk=-	BHAIKSUKI}', "");
    Expect(0, 72816, '\p{Blk=-	BHAIKSUKI}', "");
    Expect(1, 72816, '\p{^Blk=-	BHAIKSUKI}', "");
    Expect(1, 72816, '\P{Blk=-	BHAIKSUKI}', "");
    Expect(0, 72816, '\P{^Blk=-	BHAIKSUKI}', "");
    Error('\p{Is_Block=/a/_	bhaiksuki}');
    Error('\P{Is_Block=/a/_	bhaiksuki}');
    Expect(1, 72815, '\p{Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Block=- Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=- Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=- Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=- Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=- Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=- Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=- Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=- Bhaiksuki}', "");
    Error('\p{Is_Blk=/a/_ Bhaiksuki}');
    Error('\P{Is_Blk=/a/_ Bhaiksuki}');
    Expect(1, 72815, '\p{Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Blk= -Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk= -Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk= -Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk= -Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk= -Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk= -Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk= -Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk= -Bhaiksuki}', "");
    Error('\p{Block=__Block_Elements/a/}');
    Error('\P{Block=__Block_Elements/a/}');
    Expect(1, 9631, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Block=blockelements}', "");
    Expect(0, 9631, '\p{^Block=blockelements}', "");
    Expect(0, 9631, '\P{Block=blockelements}', "");
    Expect(1, 9631, '\P{^Block=blockelements}', "");
    Expect(0, 9632, '\p{Block=blockelements}', "");
    Expect(1, 9632, '\p{^Block=blockelements}', "");
    Expect(1, 9632, '\P{Block=blockelements}', "");
    Expect(0, 9632, '\P{^Block=blockelements}', "");
    Expect(1, 9631, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Block: -Block_ELEMENTS}', "");
    Expect(0, 9631, '\p{^Block: -Block_ELEMENTS}', "");
    Expect(0, 9631, '\P{Block: -Block_ELEMENTS}', "");
    Expect(1, 9631, '\P{^Block: -Block_ELEMENTS}', "");
    Expect(0, 9632, '\p{Block: -Block_ELEMENTS}', "");
    Expect(1, 9632, '\p{^Block: -Block_ELEMENTS}', "");
    Expect(1, 9632, '\P{Block: -Block_ELEMENTS}', "");
    Expect(0, 9632, '\P{^Block: -Block_ELEMENTS}', "");
    Error('\p{Blk=:=__block_Elements}');
    Error('\P{Blk=:=__block_Elements}');
    Expect(1, 9631, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Blk=blockelements}', "");
    Expect(0, 9631, '\P{Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Blk=blockelements}', "");
    Expect(0, 9632, '\p{Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Blk=blockelements}', "");
    Expect(1, 9632, '\P{Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Blk=blockelements}', "");
    Expect(1, 9631, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Blk= block_Elements}', "");
    Expect(0, 9631, '\p{^Blk= block_Elements}', "");
    Expect(0, 9631, '\P{Blk= block_Elements}', "");
    Expect(1, 9631, '\P{^Blk= block_Elements}', "");
    Expect(0, 9632, '\p{Blk= block_Elements}', "");
    Expect(1, 9632, '\p{^Blk= block_Elements}', "");
    Expect(1, 9632, '\P{Blk= block_Elements}', "");
    Expect(0, 9632, '\P{^Blk= block_Elements}', "");
    Error('\p{Is_Block=/a/--BLOCK_Elements}');
    Error('\P{Is_Block=/a/--BLOCK_Elements}');
    Expect(1, 9631, '\p{Is_Block=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
    Expect(0, 9631, '\P{Is_Block=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
    Expect(0, 9632, '\p{Is_Block=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
    Expect(1, 9632, '\P{Is_Block=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
    Expect(1, 9631, '\p{Is_Block=_Block_Elements}', "");
    Expect(0, 9631, '\p{^Is_Block=_Block_Elements}', "");
    Expect(0, 9631, '\P{Is_Block=_Block_Elements}', "");
    Expect(1, 9631, '\P{^Is_Block=_Block_Elements}', "");
    Expect(0, 9632, '\p{Is_Block=_Block_Elements}', "");
    Expect(1, 9632, '\p{^Is_Block=_Block_Elements}', "");
    Expect(1, 9632, '\P{Is_Block=_Block_Elements}', "");
    Expect(0, 9632, '\P{^Is_Block=_Block_Elements}', "");
    Error('\p{Is_Blk= :=block_Elements}');
    Error('\P{Is_Blk= :=block_Elements}');
    Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
    Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
    Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
    Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
    Expect(1, 9631, '\p{Is_Blk=Block_ELEMENTS}', "");
    Expect(0, 9631, '\p{^Is_Blk=Block_ELEMENTS}', "");
    Expect(0, 9631, '\P{Is_Blk=Block_ELEMENTS}', "");
    Expect(1, 9631, '\P{^Is_Blk=Block_ELEMENTS}', "");
    Expect(0, 9632, '\p{Is_Blk=Block_ELEMENTS}', "");
    Expect(1, 9632, '\p{^Is_Blk=Block_ELEMENTS}', "");
    Expect(1, 9632, '\P{Is_Blk=Block_ELEMENTS}', "");
    Expect(0, 9632, '\P{^Is_Blk=Block_ELEMENTS}', "");
    Error('\p{Block=:=	Bopomofo}');
    Error('\P{Block=:=	Bopomofo}');
    Expect(1, 12591, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Block=bopomofo}', "");
    Expect(0, 12591, '\P{Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Block=bopomofo}', "");
    Expect(0, 12592, '\p{Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Block=bopomofo}', "");
    Expect(1, 12592, '\P{Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Block=bopomofo}', "");
    Expect(1, 12591, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block:	__BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Block:	__BOPOMOFO}', "");
    Expect(0, 12591, '\P{Block:	__BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Block:	__BOPOMOFO}', "");
    Expect(0, 12592, '\p{Block:	__BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Block:	__BOPOMOFO}', "");
    Expect(1, 12592, '\P{Block:	__BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Block:	__BOPOMOFO}', "");
    Error('\p{Blk=_	Bopomofo/a/}');
    Error('\P{Blk=_	Bopomofo/a/}');
    Expect(1, 12591, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk:-_Bopomofo}', "");
    Expect(0, 12591, '\p{^Blk:-_Bopomofo}', "");
    Expect(0, 12591, '\P{Blk:-_Bopomofo}', "");
    Expect(1, 12591, '\P{^Blk:-_Bopomofo}', "");
    Expect(0, 12592, '\p{Blk:-_Bopomofo}', "");
    Expect(1, 12592, '\p{^Blk:-_Bopomofo}', "");
    Expect(1, 12592, '\P{Blk:-_Bopomofo}', "");
    Expect(0, 12592, '\P{^Blk:-_Bopomofo}', "");
    Error('\p{Is_Block=_ bopomofo:=}');
    Error('\P{Is_Block=_ bopomofo:=}');
    Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Block=  Bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block=  Bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block=  Bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block=  Bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block=  Bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block=  Bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block=  Bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block=  Bopomofo}', "");
    Error('\p{Is_Blk=__Bopomofo:=}');
    Error('\P{Is_Blk=__Bopomofo:=}');
    Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Is_Blk=-bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=-bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=-bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=-bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=-bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=-bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=-bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=-bopomofo}', "");
    Error('\p{Block=-/a/bopomofo_extended}');
    Error('\P{Block=-/a/bopomofo_extended}');
    Expect(1, 12735, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(1, 12735, '\p{Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(1, 12735, '\p{Block=--bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Block=--bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Block=--bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Block=--bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Block=--bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Block=--bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Block=--bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Block=--bopomofo_Extended}', "");
    Error('\p{Blk= bopomofo_Ext:=}');
    Error('\P{Blk= bopomofo_Ext:=}');
    Expect(1, 12735, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(1, 12735, '\p{Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(1, 12735, '\p{Blk=	BOPOMOFO_EXT}', "");
    Expect(0, 12735, '\p{^Blk=	BOPOMOFO_EXT}', "");
    Expect(0, 12735, '\P{Blk=	BOPOMOFO_EXT}', "");
    Expect(1, 12735, '\P{^Blk=	BOPOMOFO_EXT}', "");
    Expect(0, 12736, '\p{Blk=	BOPOMOFO_EXT}', "");
    Expect(1, 12736, '\p{^Blk=	BOPOMOFO_EXT}', "");
    Expect(1, 12736, '\P{Blk=	BOPOMOFO_EXT}', "");
    Expect(0, 12736, '\P{^Blk=	BOPOMOFO_EXT}', "");
    Error('\p{Is_Block=/a/ Bopomofo_extended}');
    Error('\P{Is_Block=/a/ Bopomofo_extended}');
    Expect(1, 12735, '\p{Is_Block:   bopomofoextended}', "");
    Expect(0, 12735, '\p{^Is_Block:   bopomofoextended}', "");
    Expect(0, 12735, '\P{Is_Block:   bopomofoextended}', "");
    Expect(1, 12735, '\P{^Is_Block:   bopomofoextended}', "");
    Expect(0, 12736, '\p{Is_Block:   bopomofoextended}', "");
    Expect(1, 12736, '\p{^Is_Block:   bopomofoextended}', "");
    Expect(1, 12736, '\P{Is_Block:   bopomofoextended}', "");
    Expect(0, 12736, '\P{^Is_Block:   bopomofoextended}', "");
    Expect(1, 12735, '\p{Is_Block=	 Bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Is_Block=	 Bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Is_Block=	 Bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Is_Block=	 Bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Is_Block=	 Bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Is_Block=	 Bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Is_Block=	 Bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Is_Block=	 Bopomofo_Extended}', "");
    Error('\p{Is_Blk=/a/ _Bopomofo_Ext}');
    Error('\P{Is_Blk=/a/ _Bopomofo_Ext}');
    Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Is_Blk=	bopomofo_ext}', "");
    Expect(0, 12735, '\p{^Is_Blk=	bopomofo_ext}', "");
    Expect(0, 12735, '\P{Is_Blk=	bopomofo_ext}', "");
    Expect(1, 12735, '\P{^Is_Blk=	bopomofo_ext}', "");
    Expect(0, 12736, '\p{Is_Blk=	bopomofo_ext}', "");
    Expect(1, 12736, '\p{^Is_Blk=	bopomofo_ext}', "");
    Expect(1, 12736, '\P{Is_Blk=	bopomofo_ext}', "");
    Expect(0, 12736, '\P{^Is_Blk=	bopomofo_ext}', "");
    Error('\p{Block=_BOX_Drawing/a/}');
    Error('\P{Block=_BOX_Drawing/a/}');
    Expect(1, 9599, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Block:boxdrawing}', "");
    Expect(0, 9599, '\p{^Block:boxdrawing}', "");
    Expect(0, 9599, '\P{Block:boxdrawing}', "");
    Expect(1, 9599, '\P{^Block:boxdrawing}', "");
    Expect(0, 9600, '\p{Block:boxdrawing}', "");
    Expect(1, 9600, '\p{^Block:boxdrawing}', "");
    Expect(1, 9600, '\P{Block:boxdrawing}', "");
    Expect(0, 9600, '\P{^Block:boxdrawing}', "");
    Expect(1, 9599, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Block= 	Box_Drawing}', "");
    Expect(0, 9599, '\p{^Block= 	Box_Drawing}', "");
    Expect(0, 9599, '\P{Block= 	Box_Drawing}', "");
    Expect(1, 9599, '\P{^Block= 	Box_Drawing}', "");
    Expect(0, 9600, '\p{Block= 	Box_Drawing}', "");
    Expect(1, 9600, '\p{^Block= 	Box_Drawing}', "");
    Expect(1, 9600, '\P{Block= 	Box_Drawing}', "");
    Expect(0, 9600, '\P{^Block= 	Box_Drawing}', "");
    Error('\p{Blk=  box_drawing:=}');
    Error('\P{Blk=  box_drawing:=}');
    Expect(1, 9599, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=_ Box_DRAWING}', "");
    Expect(0, 9599, '\p{^Blk=_ Box_DRAWING}', "");
    Expect(0, 9599, '\P{Blk=_ Box_DRAWING}', "");
    Expect(1, 9599, '\P{^Blk=_ Box_DRAWING}', "");
    Expect(0, 9600, '\p{Blk=_ Box_DRAWING}', "");
    Expect(1, 9600, '\p{^Blk=_ Box_DRAWING}', "");
    Expect(1, 9600, '\P{Blk=_ Box_DRAWING}', "");
    Expect(0, 9600, '\P{^Blk=_ Box_DRAWING}', "");
    Error('\p{Is_Block=-BOX_drawing/a/}');
    Error('\P{Is_Block=-BOX_drawing/a/}');
    Expect(1, 9599, '\p{Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Block=_BOX_DRAWING}', "");
    Expect(0, 9599, '\p{^Is_Block=_BOX_DRAWING}', "");
    Expect(0, 9599, '\P{Is_Block=_BOX_DRAWING}', "");
    Expect(1, 9599, '\P{^Is_Block=_BOX_DRAWING}', "");
    Expect(0, 9600, '\p{Is_Block=_BOX_DRAWING}', "");
    Expect(1, 9600, '\p{^Is_Block=_BOX_DRAWING}', "");
    Expect(1, 9600, '\P{Is_Block=_BOX_DRAWING}', "");
    Expect(0, 9600, '\P{^Is_Block=_BOX_DRAWING}', "");
    Error('\p{Is_Blk=-/a/box_DRAWING}');
    Error('\P{Is_Blk=-/a/box_DRAWING}');
    Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Blk=	-Box_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=	-Box_Drawing}', "");
    Expect(0, 9599, '\P{Is_Blk=	-Box_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=	-Box_Drawing}', "");
    Expect(0, 9600, '\p{Is_Blk=	-Box_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=	-Box_Drawing}', "");
    Expect(1, 9600, '\P{Is_Blk=	-Box_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=	-Box_Drawing}', "");
    Error('\p{Block=_/a/Brahmi}');
    Error('\P{Block=_/a/Brahmi}');
    Expect(1, 69759, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=brahmi}', "");
    Expect(0, 69759, '\p{^Block=brahmi}', "");
    Expect(0, 69759, '\P{Block=brahmi}', "");
    Expect(1, 69759, '\P{^Block=brahmi}', "");
    Expect(0, 69760, '\p{Block=brahmi}', "");
    Expect(1, 69760, '\p{^Block=brahmi}', "");
    Expect(1, 69760, '\P{Block=brahmi}', "");
    Expect(0, 69760, '\P{^Block=brahmi}', "");
    Expect(1, 69759, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=	_Brahmi}', "");
    Expect(0, 69759, '\p{^Block=	_Brahmi}', "");
    Expect(0, 69759, '\P{Block=	_Brahmi}', "");
    Expect(1, 69759, '\P{^Block=	_Brahmi}', "");
    Expect(0, 69760, '\p{Block=	_Brahmi}', "");
    Expect(1, 69760, '\p{^Block=	_Brahmi}', "");
    Expect(1, 69760, '\P{Block=	_Brahmi}', "");
    Expect(0, 69760, '\P{^Block=	_Brahmi}', "");
    Error('\p{Blk=/a/-Brahmi}');
    Error('\P{Blk=/a/-Brahmi}');
    Expect(1, 69759, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Blk=brahmi}', "");
    Expect(0, 69759, '\P{Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Blk=brahmi}', "");
    Expect(0, 69760, '\p{Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Blk=brahmi}', "");
    Expect(1, 69760, '\P{Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Blk=brahmi}', "");
    Expect(1, 69759, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk=	brahmi}', "");
    Expect(0, 69759, '\p{^Blk=	brahmi}', "");
    Expect(0, 69759, '\P{Blk=	brahmi}', "");
    Expect(1, 69759, '\P{^Blk=	brahmi}', "");
    Expect(0, 69760, '\p{Blk=	brahmi}', "");
    Expect(1, 69760, '\p{^Blk=	brahmi}', "");
    Expect(1, 69760, '\P{Blk=	brahmi}', "");
    Expect(0, 69760, '\P{^Blk=	brahmi}', "");
    Error('\p{Is_Block=_:=Brahmi}');
    Error('\P{Is_Block=_:=Brahmi}');
    Expect(1, 69759, '\p{Is_Block=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
    Expect(1, 69759, '\p{Is_Block: _ Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block: _ Brahmi}', "");
    Expect(0, 69759, '\P{Is_Block: _ Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block: _ Brahmi}', "");
    Expect(0, 69760, '\p{Is_Block: _ Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block: _ Brahmi}', "");
    Expect(1, 69760, '\P{Is_Block: _ Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block: _ Brahmi}', "");
    Error('\p{Is_Blk=:=_-Brahmi}');
    Error('\P{Is_Blk=:=_-Brahmi}');
    Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
    Expect(1, 69759, '\p{Is_Blk=- Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=- Brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=- Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=- Brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=- Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=- Brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=- Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=- Brahmi}', "");
    Error('\p{Block:  -braille_patterns/a/}');
    Error('\P{Block:  -braille_patterns/a/}');
    Expect(1, 10495, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(1, 10495, '\p{Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(1, 10495, '\p{Block=--braille_Patterns}', "");
    Expect(0, 10495, '\p{^Block=--braille_Patterns}', "");
    Expect(0, 10495, '\P{Block=--braille_Patterns}', "");
    Expect(1, 10495, '\P{^Block=--braille_Patterns}', "");
    Expect(0, 10496, '\p{Block=--braille_Patterns}', "");
    Expect(1, 10496, '\p{^Block=--braille_Patterns}', "");
    Expect(1, 10496, '\P{Block=--braille_Patterns}', "");
    Expect(0, 10496, '\P{^Block=--braille_Patterns}', "");
    Error('\p{Blk=  Braille/a/}');
    Error('\P{Blk=  Braille/a/}');
    Expect(1, 10495, '\p{Blk=:\ABraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\ABraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=braille}', "");
    Expect(0, 10495, '\p{^Blk=braille}', "");
    Expect(0, 10495, '\P{Blk=braille}', "");
    Expect(1, 10495, '\P{^Blk=braille}', "");
    Expect(0, 10496, '\p{Blk=braille}', "");
    Expect(1, 10496, '\p{^Blk=braille}', "");
    Expect(1, 10496, '\P{Blk=braille}', "");
    Expect(0, 10496, '\P{^Blk=braille}', "");
    Expect(1, 10495, '\p{Blk=:\Abraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\Abraille\z:}', "");;
    Expect(1, 10495, '\p{Blk= BRAILLE}', "");
    Expect(0, 10495, '\p{^Blk= BRAILLE}', "");
    Expect(0, 10495, '\P{Blk= BRAILLE}', "");
    Expect(1, 10495, '\P{^Blk= BRAILLE}', "");
    Expect(0, 10496, '\p{Blk= BRAILLE}', "");
    Expect(1, 10496, '\p{^Blk= BRAILLE}', "");
    Expect(1, 10496, '\P{Blk= BRAILLE}', "");
    Expect(0, 10496, '\P{^Blk= BRAILLE}', "");
    Error('\p{Is_Block=:=	 Braille_patterns}');
    Error('\P{Is_Block=:=	 Braille_patterns}');
    Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Is_Block= _braille_PATTERNS}', "");
    Expect(0, 10495, '\p{^Is_Block= _braille_PATTERNS}', "");
    Expect(0, 10495, '\P{Is_Block= _braille_PATTERNS}', "");
    Expect(1, 10495, '\P{^Is_Block= _braille_PATTERNS}', "");
    Expect(0, 10496, '\p{Is_Block= _braille_PATTERNS}', "");
    Expect(1, 10496, '\p{^Is_Block= _braille_PATTERNS}', "");
    Expect(1, 10496, '\P{Is_Block= _braille_PATTERNS}', "");
    Expect(0, 10496, '\P{^Is_Block= _braille_PATTERNS}', "");
    Error('\p{Is_Blk=:=-braille}');
    Error('\P{Is_Blk=:=-braille}');
    Expect(1, 10495, '\p{Is_Blk=braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=braille}', "");
    Expect(0, 10495, '\P{Is_Blk=braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=braille}', "");
    Expect(0, 10496, '\p{Is_Blk=braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=braille}', "");
    Expect(1, 10496, '\P{Is_Blk=braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=braille}', "");
    Expect(1, 10495, '\p{Is_Blk= braille}', "");
    Expect(0, 10495, '\p{^Is_Blk= braille}', "");
    Expect(0, 10495, '\P{Is_Blk= braille}', "");
    Expect(1, 10495, '\P{^Is_Blk= braille}', "");
    Expect(0, 10496, '\p{Is_Blk= braille}', "");
    Expect(1, 10496, '\p{^Is_Blk= braille}', "");
    Expect(1, 10496, '\P{Is_Blk= braille}', "");
    Expect(0, 10496, '\P{^Is_Blk= braille}', "");
    Error('\p{Block: :=	BUGINESE}');
    Error('\P{Block: :=	BUGINESE}');
    Expect(1, 6687, '\p{Block=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=buginese}', "");
    Expect(0, 6687, '\p{^Block=buginese}', "");
    Expect(0, 6687, '\P{Block=buginese}', "");
    Expect(1, 6687, '\P{^Block=buginese}', "");
    Expect(0, 6688, '\p{Block=buginese}', "");
    Expect(1, 6688, '\p{^Block=buginese}', "");
    Expect(1, 6688, '\P{Block=buginese}', "");
    Expect(0, 6688, '\P{^Block=buginese}', "");
    Expect(1, 6687, '\p{Block=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=- buginese}', "");
    Expect(0, 6687, '\p{^Block=- buginese}', "");
    Expect(0, 6687, '\P{Block=- buginese}', "");
    Expect(1, 6687, '\P{^Block=- buginese}', "");
    Expect(0, 6688, '\p{Block=- buginese}', "");
    Expect(1, 6688, '\p{^Block=- buginese}', "");
    Expect(1, 6688, '\P{Block=- buginese}', "");
    Expect(0, 6688, '\P{^Block=- buginese}', "");
    Error('\p{Blk= Buginese/a/}');
    Error('\P{Blk= Buginese/a/}');
    Expect(1, 6687, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=buginese}', "");
    Expect(0, 6687, '\p{^Blk=buginese}', "");
    Expect(0, 6687, '\P{Blk=buginese}', "");
    Expect(1, 6687, '\P{^Blk=buginese}', "");
    Expect(0, 6688, '\p{Blk=buginese}', "");
    Expect(1, 6688, '\p{^Blk=buginese}', "");
    Expect(1, 6688, '\P{Blk=buginese}', "");
    Expect(0, 6688, '\P{^Blk=buginese}', "");
    Expect(1, 6687, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=--Buginese}', "");
    Expect(0, 6687, '\p{^Blk=--Buginese}', "");
    Expect(0, 6687, '\P{Blk=--Buginese}', "");
    Expect(1, 6687, '\P{^Blk=--Buginese}', "");
    Expect(0, 6688, '\p{Blk=--Buginese}', "");
    Expect(1, 6688, '\p{^Blk=--Buginese}', "");
    Expect(1, 6688, '\P{Blk=--Buginese}', "");
    Expect(0, 6688, '\P{^Blk=--Buginese}', "");
    Error('\p{Is_Block=:=-	Buginese}');
    Error('\P{Is_Block=:=-	Buginese}');
    Expect(1, 6687, '\p{Is_Block=buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=buginese}', "");
    Expect(0, 6687, '\P{Is_Block=buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=buginese}', "");
    Expect(0, 6688, '\p{Is_Block=buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=buginese}', "");
    Expect(1, 6688, '\P{Is_Block=buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=buginese}', "");
    Expect(1, 6687, '\p{Is_Block=-Buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=-Buginese}', "");
    Expect(0, 6687, '\P{Is_Block=-Buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=-Buginese}', "");
    Expect(0, 6688, '\p{Is_Block=-Buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=-Buginese}', "");
    Expect(1, 6688, '\P{Is_Block=-Buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=-Buginese}', "");
    Error('\p{Is_Blk=_buginese/a/}');
    Error('\P{Is_Blk=_buginese/a/}');
    Expect(1, 6687, '\p{Is_Blk=buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
    Expect(1, 6687, '\p{Is_Blk: _Buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk: _Buginese}', "");
    Expect(0, 6687, '\P{Is_Blk: _Buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk: _Buginese}', "");
    Expect(0, 6688, '\p{Is_Blk: _Buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk: _Buginese}', "");
    Expect(1, 6688, '\P{Is_Blk: _Buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk: _Buginese}', "");
    Error('\p{Block=/a/ 	Buhid}');
    Error('\P{Block=/a/ 	Buhid}');
    Expect(1, 5983, '\p{Block=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=buhid}', "");
    Expect(0, 5983, '\p{^Block=buhid}', "");
    Expect(0, 5983, '\P{Block=buhid}', "");
    Expect(1, 5983, '\P{^Block=buhid}', "");
    Expect(0, 5984, '\p{Block=buhid}', "");
    Expect(1, 5984, '\p{^Block=buhid}', "");
    Expect(1, 5984, '\P{Block=buhid}', "");
    Expect(0, 5984, '\P{^Block=buhid}', "");
    Expect(1, 5983, '\p{Block=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=BUHID}', "");
    Expect(0, 5983, '\p{^Block=BUHID}', "");
    Expect(0, 5983, '\P{Block=BUHID}', "");
    Expect(1, 5983, '\P{^Block=BUHID}', "");
    Expect(0, 5984, '\p{Block=BUHID}', "");
    Expect(1, 5984, '\p{^Block=BUHID}', "");
    Expect(1, 5984, '\P{Block=BUHID}', "");
    Expect(0, 5984, '\P{^Block=BUHID}', "");
    Error('\p{Blk=/a/	 buhid}');
    Error('\P{Blk=/a/	 buhid}');
    Expect(1, 5983, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=buhid}', "");
    Expect(0, 5983, '\p{^Blk=buhid}', "");
    Expect(0, 5983, '\P{Blk=buhid}', "");
    Expect(1, 5983, '\P{^Blk=buhid}', "");
    Expect(0, 5984, '\p{Blk=buhid}', "");
    Expect(1, 5984, '\p{^Blk=buhid}', "");
    Expect(1, 5984, '\P{Blk=buhid}', "");
    Expect(0, 5984, '\P{^Blk=buhid}', "");
    Expect(1, 5983, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk= Buhid}', "");
    Expect(0, 5983, '\p{^Blk= Buhid}', "");
    Expect(0, 5983, '\P{Blk= Buhid}', "");
    Expect(1, 5983, '\P{^Blk= Buhid}', "");
    Expect(0, 5984, '\p{Blk= Buhid}', "");
    Expect(1, 5984, '\p{^Blk= Buhid}', "");
    Expect(1, 5984, '\P{Blk= Buhid}', "");
    Expect(0, 5984, '\P{^Blk= Buhid}', "");
    Error('\p{Is_Block=/a/-	BUHID}');
    Error('\P{Is_Block=/a/-	BUHID}');
    Expect(1, 5983, '\p{Is_Block=buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=buhid}', "");
    Expect(0, 5983, '\P{Is_Block=buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=buhid}', "");
    Expect(0, 5984, '\p{Is_Block=buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=buhid}', "");
    Expect(1, 5984, '\P{Is_Block=buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=buhid}', "");
    Expect(1, 5983, '\p{Is_Block=_-BUHID}', "");
    Expect(0, 5983, '\p{^Is_Block=_-BUHID}', "");
    Expect(0, 5983, '\P{Is_Block=_-BUHID}', "");
    Expect(1, 5983, '\P{^Is_Block=_-BUHID}', "");
    Expect(0, 5984, '\p{Is_Block=_-BUHID}', "");
    Expect(1, 5984, '\p{^Is_Block=_-BUHID}', "");
    Expect(1, 5984, '\P{Is_Block=_-BUHID}', "");
    Expect(0, 5984, '\P{^Is_Block=_-BUHID}', "");
    Error('\p{Is_Blk= Buhid/a/}');
    Error('\P{Is_Blk= Buhid/a/}');
    Expect(1, 5983, '\p{Is_Blk=buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
    Expect(1, 5983, '\p{Is_Blk:	 BUHID}', "");
    Expect(0, 5983, '\p{^Is_Blk:	 BUHID}', "");
    Expect(0, 5983, '\P{Is_Blk:	 BUHID}', "");
    Expect(1, 5983, '\P{^Is_Blk:	 BUHID}', "");
    Expect(0, 5984, '\p{Is_Blk:	 BUHID}', "");
    Expect(1, 5984, '\p{^Is_Blk:	 BUHID}', "");
    Expect(1, 5984, '\P{Is_Blk:	 BUHID}', "");
    Expect(0, 5984, '\P{^Is_Blk:	 BUHID}', "");
    Error('\p{Block=  Byzantine_Musical_symbols/a/}');
    Error('\P{Block=  Byzantine_Musical_symbols/a/}');
    Expect(1, 119039, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(1, 119039, '\p{Block:byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Block:byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Block:byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Block:byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Block:byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Block:byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Block:byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Block:byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(1, 119039, '\p{Block:		Byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\p{^Block:		Byzantine_Musical_Symbols}', "");
    Expect(0, 119039, '\P{Block:		Byzantine_Musical_Symbols}', "");
    Expect(1, 119039, '\P{^Block:		Byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\p{Block:		Byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\p{^Block:		Byzantine_Musical_Symbols}', "");
    Expect(1, 119040, '\P{Block:		Byzantine_Musical_Symbols}', "");
    Expect(0, 119040, '\P{^Block:		Byzantine_Musical_Symbols}', "");
    Error('\p{Blk=_Byzantine_music/a/}');
    Error('\P{Blk=_Byzantine_music/a/}');
    Expect(1, 119039, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(1, 119039, '\p{Blk= byzantine_music}', "");
    Expect(0, 119039, '\p{^Blk= byzantine_music}', "");
    Expect(0, 119039, '\P{Blk= byzantine_music}', "");
    Expect(1, 119039, '\P{^Blk= byzantine_music}', "");
    Expect(0, 119040, '\p{Blk= byzantine_music}', "");
    Expect(1, 119040, '\p{^Blk= byzantine_music}', "");
    Expect(1, 119040, '\P{Blk= byzantine_music}', "");
    Expect(0, 119040, '\P{^Blk= byzantine_music}', "");
    Error('\p{Is_Block=/a/	-Byzantine_Musical_Symbols}');
    Error('\P{Is_Block=/a/	-Byzantine_Musical_Symbols}');
    Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\p{^Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119039, '\P{Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119039, '\P{^Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\p{Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\p{^Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(1, 119040, '\P{Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Expect(0, 119040, '\P{^Is_Block=		Byzantine_Musical_SYMBOLS}', "");
    Error('\p{Is_Blk=_	byzantine_Music:=}');
    Error('\P{Is_Blk=_	byzantine_Music:=}');
    Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Is_Blk=byzantine_MUSIC}', "");
    Expect(0, 119039, '\p{^Is_Blk=byzantine_MUSIC}', "");
    Expect(0, 119039, '\P{Is_Blk=byzantine_MUSIC}', "");
    Expect(1, 119039, '\P{^Is_Blk=byzantine_MUSIC}', "");
    Expect(0, 119040, '\p{Is_Blk=byzantine_MUSIC}', "");
    Expect(1, 119040, '\p{^Is_Blk=byzantine_MUSIC}', "");
    Expect(1, 119040, '\P{Is_Blk=byzantine_MUSIC}', "");
    Expect(0, 119040, '\P{^Is_Blk=byzantine_MUSIC}', "");
    Error('\p{Block=_/a/Carian}');
    Error('\P{Block=_/a/Carian}');
    Expect(1, 66271, '\p{Block=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Block=carian}', "");
    Expect(0, 66271, '\p{^Block=carian}', "");
    Expect(0, 66271, '\P{Block=carian}', "");
    Expect(1, 66271, '\P{^Block=carian}', "");
    Expect(0, 66272, '\p{Block=carian}', "");
    Expect(1, 66272, '\p{^Block=carian}', "");
    Expect(1, 66272, '\P{Block=carian}', "");
    Expect(0, 66272, '\P{^Block=carian}', "");
    Expect(1, 66271, '\p{Block=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Block=_-CARIAN}', "");
    Expect(0, 66271, '\p{^Block=_-CARIAN}', "");
    Expect(0, 66271, '\P{Block=_-CARIAN}', "");
    Expect(1, 66271, '\P{^Block=_-CARIAN}', "");
    Expect(0, 66272, '\p{Block=_-CARIAN}', "");
    Expect(1, 66272, '\p{^Block=_-CARIAN}', "");
    Expect(1, 66272, '\P{Block=_-CARIAN}', "");
    Expect(0, 66272, '\P{^Block=_-CARIAN}', "");
    Error('\p{Blk=_:=CARIAN}');
    Error('\P{Blk=_:=CARIAN}');
    Expect(1, 66271, '\p{Blk=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=carian}', "");
    Expect(0, 66271, '\p{^Blk=carian}', "");
    Expect(0, 66271, '\P{Blk=carian}', "");
    Expect(1, 66271, '\P{^Blk=carian}', "");
    Expect(0, 66272, '\p{Blk=carian}', "");
    Expect(1, 66272, '\p{^Blk=carian}', "");
    Expect(1, 66272, '\P{Blk=carian}', "");
    Expect(0, 66272, '\P{^Blk=carian}', "");
    Expect(1, 66271, '\p{Blk=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Blk: _	Carian}', "");
    Expect(0, 66271, '\p{^Blk: _	Carian}', "");
    Expect(0, 66271, '\P{Blk: _	Carian}', "");
    Expect(1, 66271, '\P{^Blk: _	Carian}', "");
    Expect(0, 66272, '\p{Blk: _	Carian}', "");
    Expect(1, 66272, '\p{^Blk: _	Carian}', "");
    Expect(1, 66272, '\P{Blk: _	Carian}', "");
    Expect(0, 66272, '\P{^Blk: _	Carian}', "");
    Error('\p{Is_Block=-/a/CARIAN}');
    Error('\P{Is_Block=-/a/CARIAN}');
    Expect(1, 66271, '\p{Is_Block=carian}', "");
    Expect(0, 66271, '\p{^Is_Block=carian}', "");
    Expect(0, 66271, '\P{Is_Block=carian}', "");
    Expect(1, 66271, '\P{^Is_Block=carian}', "");
    Expect(0, 66272, '\p{Is_Block=carian}', "");
    Expect(1, 66272, '\p{^Is_Block=carian}', "");
    Expect(1, 66272, '\P{Is_Block=carian}', "");
    Expect(0, 66272, '\P{^Is_Block=carian}', "");
    Expect(1, 66271, '\p{Is_Block:CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Block:CARIAN}', "");
    Expect(0, 66271, '\P{Is_Block:CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Block:CARIAN}', "");
    Expect(0, 66272, '\p{Is_Block:CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Block:CARIAN}', "");
    Expect(1, 66272, '\P{Is_Block:CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Block:CARIAN}', "");
    Error('\p{Is_Blk: Carian:=}');
    Error('\P{Is_Blk: Carian:=}');
    Expect(1, 66271, '\p{Is_Blk=carian}', "");
    Expect(0, 66271, '\p{^Is_Blk=carian}', "");
    Expect(0, 66271, '\P{Is_Blk=carian}', "");
    Expect(1, 66271, '\P{^Is_Blk=carian}', "");
    Expect(0, 66272, '\p{Is_Blk=carian}', "");
    Expect(1, 66272, '\p{^Is_Blk=carian}', "");
    Expect(1, 66272, '\P{Is_Blk=carian}', "");
    Expect(0, 66272, '\P{^Is_Blk=carian}', "");
    Expect(1, 66271, '\p{Is_Blk=_-CARIAN}', "");
    Expect(0, 66271, '\p{^Is_Blk=_-CARIAN}', "");
    Expect(0, 66271, '\P{Is_Blk=_-CARIAN}', "");
    Expect(1, 66271, '\P{^Is_Blk=_-CARIAN}', "");
    Expect(0, 66272, '\p{Is_Blk=_-CARIAN}', "");
    Expect(1, 66272, '\p{^Is_Blk=_-CARIAN}', "");
    Expect(1, 66272, '\P{Is_Blk=_-CARIAN}', "");
    Expect(0, 66272, '\P{^Is_Blk=_-CARIAN}', "");
    Error('\p{Block: :=	 Caucasian_Albanian}');
    Error('\P{Block: :=	 Caucasian_Albanian}');
    Expect(1, 66927, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Block=_-caucasian_Albanian}', "");
    Expect(0, 66927, '\p{^Block=_-caucasian_Albanian}', "");
    Expect(0, 66927, '\P{Block=_-caucasian_Albanian}', "");
    Expect(1, 66927, '\P{^Block=_-caucasian_Albanian}', "");
    Expect(0, 66928, '\p{Block=_-caucasian_Albanian}', "");
    Expect(1, 66928, '\p{^Block=_-caucasian_Albanian}', "");
    Expect(1, 66928, '\P{Block=_-caucasian_Albanian}', "");
    Expect(0, 66928, '\P{^Block=_-caucasian_Albanian}', "");
    Error('\p{Blk:		 Caucasian_Albanian:=}');
    Error('\P{Blk:		 Caucasian_Albanian:=}');
    Expect(1, 66927, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Blk:	- Caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Blk:	- Caucasian_albanian}', "");
    Expect(0, 66927, '\P{Blk:	- Caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Blk:	- Caucasian_albanian}', "");
    Expect(0, 66928, '\p{Blk:	- Caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Blk:	- Caucasian_albanian}', "");
    Expect(1, 66928, '\P{Blk:	- Caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Blk:	- Caucasian_albanian}', "");
    Error('\p{Is_Block=:= -CAUCASIAN_ALBANIAN}');
    Error('\P{Is_Block=:= -CAUCASIAN_ALBANIAN}');
    Expect(1, 66927, '\p{Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Block:    caucasian_Albanian}', "");
    Expect(0, 66927, '\p{^Is_Block:    caucasian_Albanian}', "");
    Expect(0, 66927, '\P{Is_Block:    caucasian_Albanian}', "");
    Expect(1, 66927, '\P{^Is_Block:    caucasian_Albanian}', "");
    Expect(0, 66928, '\p{Is_Block:    caucasian_Albanian}', "");
    Expect(1, 66928, '\p{^Is_Block:    caucasian_Albanian}', "");
    Expect(1, 66928, '\P{Is_Block:    caucasian_Albanian}', "");
    Expect(0, 66928, '\P{^Is_Block:    caucasian_Albanian}', "");
    Error('\p{Is_Blk= :=caucasian_albanian}');
    Error('\P{Is_Blk= :=caucasian_albanian}');
    Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(0, 66927, '\p{^Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(0, 66927, '\P{Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(1, 66927, '\P{^Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(0, 66928, '\p{Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(1, 66928, '\p{^Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(1, 66928, '\P{Is_Blk= -CAUCASIAN_Albanian}', "");
    Expect(0, 66928, '\P{^Is_Blk= -CAUCASIAN_Albanian}', "");
    Error('\p{Block: _/a/chakma}');
    Error('\P{Block: _/a/chakma}');
    Expect(1, 69967, '\p{Block=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Block=chakma}', "");
    Expect(0, 69967, '\p{^Block=chakma}', "");
    Expect(0, 69967, '\P{Block=chakma}', "");
    Expect(1, 69967, '\P{^Block=chakma}', "");
    Expect(0, 69968, '\p{Block=chakma}', "");
    Expect(1, 69968, '\p{^Block=chakma}', "");
    Expect(1, 69968, '\P{Block=chakma}', "");
    Expect(0, 69968, '\P{^Block=chakma}', "");
    Expect(1, 69967, '\p{Block=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Block=- Chakma}', "");
    Expect(0, 69967, '\p{^Block=- Chakma}', "");
    Expect(0, 69967, '\P{Block=- Chakma}', "");
    Expect(1, 69967, '\P{^Block=- Chakma}', "");
    Expect(0, 69968, '\p{Block=- Chakma}', "");
    Expect(1, 69968, '\p{^Block=- Chakma}', "");
    Expect(1, 69968, '\P{Block=- Chakma}', "");
    Expect(0, 69968, '\P{^Block=- Chakma}', "");
    Error('\p{Blk=CHAKMA/a/}');
    Error('\P{Blk=CHAKMA/a/}');
    Expect(1, 69967, '\p{Blk=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=chakma}', "");
    Expect(0, 69967, '\p{^Blk=chakma}', "");
    Expect(0, 69967, '\P{Blk=chakma}', "");
    Expect(1, 69967, '\P{^Blk=chakma}', "");
    Expect(0, 69968, '\p{Blk=chakma}', "");
    Expect(1, 69968, '\p{^Blk=chakma}', "");
    Expect(1, 69968, '\P{Blk=chakma}', "");
    Expect(0, 69968, '\P{^Blk=chakma}', "");
    Expect(1, 69967, '\p{Blk=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=	 CHAKMA}', "");
    Expect(0, 69967, '\p{^Blk=	 CHAKMA}', "");
    Expect(0, 69967, '\P{Blk=	 CHAKMA}', "");
    Expect(1, 69967, '\P{^Blk=	 CHAKMA}', "");
    Expect(0, 69968, '\p{Blk=	 CHAKMA}', "");
    Expect(1, 69968, '\p{^Blk=	 CHAKMA}', "");
    Expect(1, 69968, '\P{Blk=	 CHAKMA}', "");
    Expect(0, 69968, '\P{^Blk=	 CHAKMA}', "");
    Error('\p{Is_Block=_chakma/a/}');
    Error('\P{Is_Block=_chakma/a/}');
    Expect(1, 69967, '\p{Is_Block=chakma}', "");
    Expect(0, 69967, '\p{^Is_Block=chakma}', "");
    Expect(0, 69967, '\P{Is_Block=chakma}', "");
    Expect(1, 69967, '\P{^Is_Block=chakma}', "");
    Expect(0, 69968, '\p{Is_Block=chakma}', "");
    Expect(1, 69968, '\p{^Is_Block=chakma}', "");
    Expect(1, 69968, '\P{Is_Block=chakma}', "");
    Expect(0, 69968, '\P{^Is_Block=chakma}', "");
    Expect(1, 69967, '\p{Is_Block:   CHAKMA}', "");
    Expect(0, 69967, '\p{^Is_Block:   CHAKMA}', "");
    Expect(0, 69967, '\P{Is_Block:   CHAKMA}', "");
    Expect(1, 69967, '\P{^Is_Block:   CHAKMA}', "");
    Expect(0, 69968, '\p{Is_Block:   CHAKMA}', "");
    Expect(1, 69968, '\p{^Is_Block:   CHAKMA}', "");
    Expect(1, 69968, '\P{Is_Block:   CHAKMA}', "");
    Expect(0, 69968, '\P{^Is_Block:   CHAKMA}', "");
    Error('\p{Is_Blk=/a/	chakma}');
    Error('\P{Is_Blk=/a/	chakma}');
    Expect(1, 69967, '\p{Is_Blk=chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
    Expect(1, 69967, '\p{Is_Blk= _CHAKMA}', "");
    Expect(0, 69967, '\p{^Is_Blk= _CHAKMA}', "");
    Expect(0, 69967, '\P{Is_Blk= _CHAKMA}', "");
    Expect(1, 69967, '\P{^Is_Blk= _CHAKMA}', "");
    Expect(0, 69968, '\p{Is_Blk= _CHAKMA}', "");
    Expect(1, 69968, '\p{^Is_Blk= _CHAKMA}', "");
    Expect(1, 69968, '\P{Is_Blk= _CHAKMA}', "");
    Expect(0, 69968, '\P{^Is_Blk= _CHAKMA}', "");
    Error('\p{Block=		cham:=}');
    Error('\P{Block=		cham:=}');
    Expect(1, 43615, '\p{Block=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Block=cham}', "");
    Expect(0, 43615, '\p{^Block=cham}', "");
    Expect(0, 43615, '\P{Block=cham}', "");
    Expect(1, 43615, '\P{^Block=cham}', "");
    Expect(0, 43616, '\p{Block=cham}', "");
    Expect(1, 43616, '\p{^Block=cham}', "");
    Expect(1, 43616, '\P{Block=cham}', "");
    Expect(0, 43616, '\P{^Block=cham}', "");
    Expect(1, 43615, '\p{Block=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Block= _CHAM}', "");
    Expect(0, 43615, '\p{^Block= _CHAM}', "");
    Expect(0, 43615, '\P{Block= _CHAM}', "");
    Expect(1, 43615, '\P{^Block= _CHAM}', "");
    Expect(0, 43616, '\p{Block= _CHAM}', "");
    Expect(1, 43616, '\p{^Block= _CHAM}', "");
    Expect(1, 43616, '\P{Block= _CHAM}', "");
    Expect(0, 43616, '\P{^Block= _CHAM}', "");
    Error('\p{Blk:   :=-	Cham}');
    Error('\P{Blk:   :=-	Cham}');
    Expect(1, 43615, '\p{Blk=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Blk=cham}', "");
    Expect(0, 43615, '\p{^Blk=cham}', "");
    Expect(0, 43615, '\P{Blk=cham}', "");
    Expect(1, 43615, '\P{^Blk=cham}', "");
    Expect(0, 43616, '\p{Blk=cham}', "");
    Expect(1, 43616, '\p{^Blk=cham}', "");
    Expect(1, 43616, '\P{Blk=cham}', "");
    Expect(0, 43616, '\P{^Blk=cham}', "");
    Expect(1, 43615, '\p{Blk=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Blk=-CHAM}', "");
    Expect(0, 43615, '\p{^Blk=-CHAM}', "");
    Expect(0, 43615, '\P{Blk=-CHAM}', "");
    Expect(1, 43615, '\P{^Blk=-CHAM}', "");
    Expect(0, 43616, '\p{Blk=-CHAM}', "");
    Expect(1, 43616, '\p{^Blk=-CHAM}', "");
    Expect(1, 43616, '\P{Blk=-CHAM}', "");
    Expect(0, 43616, '\P{^Blk=-CHAM}', "");
    Error('\p{Is_Block:/a/-CHAM}');
    Error('\P{Is_Block:/a/-CHAM}');
    Expect(1, 43615, '\p{Is_Block=cham}', "");
    Expect(0, 43615, '\p{^Is_Block=cham}', "");
    Expect(0, 43615, '\P{Is_Block=cham}', "");
    Expect(1, 43615, '\P{^Is_Block=cham}', "");
    Expect(0, 43616, '\p{Is_Block=cham}', "");
    Expect(1, 43616, '\p{^Is_Block=cham}', "");
    Expect(1, 43616, '\P{Is_Block=cham}', "");
    Expect(0, 43616, '\P{^Is_Block=cham}', "");
    Expect(1, 43615, '\p{Is_Block=-	Cham}', "");
    Expect(0, 43615, '\p{^Is_Block=-	Cham}', "");
    Expect(0, 43615, '\P{Is_Block=-	Cham}', "");
    Expect(1, 43615, '\P{^Is_Block=-	Cham}', "");
    Expect(0, 43616, '\p{Is_Block=-	Cham}', "");
    Expect(1, 43616, '\p{^Is_Block=-	Cham}', "");
    Expect(1, 43616, '\P{Is_Block=-	Cham}', "");
    Expect(0, 43616, '\P{^Is_Block=-	Cham}', "");
    Error('\p{Is_Blk= -cham/a/}');
    Error('\P{Is_Blk= -cham/a/}');
    Expect(1, 43615, '\p{Is_Blk=cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=cham}', "");
    Expect(0, 43615, '\P{Is_Blk=cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=cham}', "");
    Expect(0, 43616, '\p{Is_Blk=cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=cham}', "");
    Expect(1, 43616, '\P{Is_Blk=cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=cham}', "");
    Expect(1, 43615, '\p{Is_Blk=-Cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=-Cham}', "");
    Expect(0, 43615, '\P{Is_Blk=-Cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=-Cham}', "");
    Expect(0, 43616, '\p{Is_Blk=-Cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=-Cham}', "");
    Expect(1, 43616, '\P{Is_Blk=-Cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=-Cham}', "");
    Error('\p{Block=- Cherokee:=}');
    Error('\P{Block=- Cherokee:=}');
    Expect(1, 5119, '\p{Block=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=cherokee}', "");
    Expect(0, 5119, '\p{^Block=cherokee}', "");
    Expect(0, 5119, '\P{Block=cherokee}', "");
    Expect(1, 5119, '\P{^Block=cherokee}', "");
    Expect(0, 5120, '\p{Block=cherokee}', "");
    Expect(1, 5120, '\p{^Block=cherokee}', "");
    Expect(1, 5120, '\P{Block=cherokee}', "");
    Expect(0, 5120, '\P{^Block=cherokee}', "");
    Expect(1, 5119, '\p{Block=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=-	Cherokee}', "");
    Expect(0, 5119, '\p{^Block=-	Cherokee}', "");
    Expect(0, 5119, '\P{Block=-	Cherokee}', "");
    Expect(1, 5119, '\P{^Block=-	Cherokee}', "");
    Expect(0, 5120, '\p{Block=-	Cherokee}', "");
    Expect(1, 5120, '\p{^Block=-	Cherokee}', "");
    Expect(1, 5120, '\P{Block=-	Cherokee}', "");
    Expect(0, 5120, '\P{^Block=-	Cherokee}', "");
    Error('\p{Blk=:=CHEROKEE}');
    Error('\P{Blk=:=CHEROKEE}');
    Expect(1, 5119, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Blk=cherokee}', "");
    Expect(0, 5119, '\P{Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Blk=cherokee}', "");
    Expect(0, 5120, '\p{Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Blk=cherokee}', "");
    Expect(1, 5120, '\P{Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Blk=cherokee}', "");
    Expect(1, 5119, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=_Cherokee}', "");
    Expect(0, 5119, '\p{^Blk=_Cherokee}', "");
    Expect(0, 5119, '\P{Blk=_Cherokee}', "");
    Expect(1, 5119, '\P{^Blk=_Cherokee}', "");
    Expect(0, 5120, '\p{Blk=_Cherokee}', "");
    Expect(1, 5120, '\p{^Blk=_Cherokee}', "");
    Expect(1, 5120, '\P{Blk=_Cherokee}', "");
    Expect(0, 5120, '\P{^Blk=_Cherokee}', "");
    Error('\p{Is_Block=/a/--cherokee}');
    Error('\P{Is_Block=/a/--cherokee}');
    Expect(1, 5119, '\p{Is_Block=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
    Expect(1, 5119, '\p{Is_Block= _Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block= _Cherokee}', "");
    Expect(0, 5119, '\P{Is_Block= _Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block= _Cherokee}', "");
    Expect(0, 5120, '\p{Is_Block= _Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block= _Cherokee}', "");
    Expect(1, 5120, '\P{Is_Block= _Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block= _Cherokee}', "");
    Error('\p{Is_Blk: -Cherokee/a/}');
    Error('\P{Is_Blk: -Cherokee/a/}');
    Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk=cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk=cherokee}', "");
    Expect(1, 5119, '\p{Is_Blk:  -Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk:  -Cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk:  -Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk:  -Cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk:  -Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk:  -Cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk:  -Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk:  -Cherokee}', "");
    Error('\p{Block=__cherokee_supplement/a/}');
    Error('\P{Block=__cherokee_supplement/a/}');
    Expect(1, 43967, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(1, 43967, '\p{Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(1, 43967, '\p{Block=CHEROKEE_supplement}', "");
    Expect(0, 43967, '\p{^Block=CHEROKEE_supplement}', "");
    Expect(0, 43967, '\P{Block=CHEROKEE_supplement}', "");
    Expect(1, 43967, '\P{^Block=CHEROKEE_supplement}', "");
    Expect(0, 43968, '\p{Block=CHEROKEE_supplement}', "");
    Expect(1, 43968, '\p{^Block=CHEROKEE_supplement}', "");
    Expect(1, 43968, '\P{Block=CHEROKEE_supplement}', "");
    Expect(0, 43968, '\P{^Block=CHEROKEE_supplement}', "");
    Error('\p{Blk=	/a/CHEROKEE_sup}');
    Error('\P{Blk=	/a/CHEROKEE_sup}');
    Expect(1, 43967, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(1, 43967, '\p{Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(1, 43967, '\p{Blk=_	Cherokee_SUP}', "");
    Expect(0, 43967, '\p{^Blk=_	Cherokee_SUP}', "");
    Expect(0, 43967, '\P{Blk=_	Cherokee_SUP}', "");
    Expect(1, 43967, '\P{^Blk=_	Cherokee_SUP}', "");
    Expect(0, 43968, '\p{Blk=_	Cherokee_SUP}', "");
    Expect(1, 43968, '\p{^Blk=_	Cherokee_SUP}', "");
    Expect(1, 43968, '\P{Blk=_	Cherokee_SUP}', "");
    Expect(0, 43968, '\P{^Blk=_	Cherokee_SUP}', "");
    Error('\p{Is_Block=- CHEROKEE_SUPPLEMENT/a/}');
    Error('\P{Is_Block=- CHEROKEE_SUPPLEMENT/a/}');
    Expect(1, 43967, '\p{Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Is_Block=CHEROKEE_Supplement}', "");
    Expect(0, 43967, '\p{^Is_Block=CHEROKEE_Supplement}', "");
    Expect(0, 43967, '\P{Is_Block=CHEROKEE_Supplement}', "");
    Expect(1, 43967, '\P{^Is_Block=CHEROKEE_Supplement}', "");
    Expect(0, 43968, '\p{Is_Block=CHEROKEE_Supplement}', "");
    Expect(1, 43968, '\p{^Is_Block=CHEROKEE_Supplement}', "");
    Expect(1, 43968, '\P{Is_Block=CHEROKEE_Supplement}', "");
    Expect(0, 43968, '\P{^Is_Block=CHEROKEE_Supplement}', "");
    Error('\p{Is_Blk=	/a/Cherokee_Sup}');
    Error('\P{Is_Blk=	/a/Cherokee_Sup}');
    Expect(1, 43967, '\p{Is_Blk:cherokeesup}', "");
    Expect(0, 43967, '\p{^Is_Blk:cherokeesup}', "");
    Expect(0, 43967, '\P{Is_Blk:cherokeesup}', "");
    Expect(1, 43967, '\P{^Is_Blk:cherokeesup}', "");
    Expect(0, 43968, '\p{Is_Blk:cherokeesup}', "");
    Expect(1, 43968, '\p{^Is_Blk:cherokeesup}', "");
    Expect(1, 43968, '\P{Is_Blk:cherokeesup}', "");
    Expect(0, 43968, '\P{^Is_Blk:cherokeesup}', "");
    Expect(1, 43967, '\p{Is_Blk=	Cherokee_SUP}', "");
    Expect(0, 43967, '\p{^Is_Blk=	Cherokee_SUP}', "");
    Expect(0, 43967, '\P{Is_Blk=	Cherokee_SUP}', "");
    Expect(1, 43967, '\P{^Is_Blk=	Cherokee_SUP}', "");
    Expect(0, 43968, '\p{Is_Blk=	Cherokee_SUP}', "");
    Expect(1, 43968, '\p{^Is_Blk=	Cherokee_SUP}', "");
    Expect(1, 43968, '\P{Is_Blk=	Cherokee_SUP}', "");
    Expect(0, 43968, '\P{^Is_Blk=	Cherokee_SUP}', "");
    Error('\p{Block=	:=chess_SYMBOLS}');
    Error('\P{Block=	:=chess_SYMBOLS}');
    Expect(1, 129647, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Block= _CHESS_Symbols}', "");
    Expect(0, 129647, '\p{^Block= _CHESS_Symbols}', "");
    Expect(0, 129647, '\P{Block= _CHESS_Symbols}', "");
    Expect(1, 129647, '\P{^Block= _CHESS_Symbols}', "");
    Expect(0, 129648, '\p{Block= _CHESS_Symbols}', "");
    Expect(1, 129648, '\p{^Block= _CHESS_Symbols}', "");
    Expect(1, 129648, '\P{Block= _CHESS_Symbols}', "");
    Expect(0, 129648, '\P{^Block= _CHESS_Symbols}', "");
    Error('\p{Blk=-:=Chess_Symbols}');
    Error('\P{Blk=-:=Chess_Symbols}');
    Expect(1, 129647, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=__Chess_Symbols}', "");
    Expect(0, 129647, '\p{^Blk=__Chess_Symbols}', "");
    Expect(0, 129647, '\P{Blk=__Chess_Symbols}', "");
    Expect(1, 129647, '\P{^Blk=__Chess_Symbols}', "");
    Expect(0, 129648, '\p{Blk=__Chess_Symbols}', "");
    Expect(1, 129648, '\p{^Blk=__Chess_Symbols}', "");
    Expect(1, 129648, '\P{Blk=__Chess_Symbols}', "");
    Expect(0, 129648, '\P{^Blk=__Chess_Symbols}', "");
    Error('\p{Is_Block=_:=Chess_symbols}');
    Error('\P{Is_Block=_:=Chess_symbols}');
    Expect(1, 129647, '\p{Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Block= 	Chess_symbols}', "");
    Expect(0, 129647, '\p{^Is_Block= 	Chess_symbols}', "");
    Expect(0, 129647, '\P{Is_Block= 	Chess_symbols}', "");
    Expect(1, 129647, '\P{^Is_Block= 	Chess_symbols}', "");
    Expect(0, 129648, '\p{Is_Block= 	Chess_symbols}', "");
    Expect(1, 129648, '\p{^Is_Block= 	Chess_symbols}', "");
    Expect(1, 129648, '\P{Is_Block= 	Chess_symbols}', "");
    Expect(0, 129648, '\P{^Is_Block= 	Chess_symbols}', "");
    Error('\p{Is_Blk=/a/_	CHESS_Symbols}');
    Error('\P{Is_Blk=/a/_	CHESS_Symbols}');
    Expect(1, 129647, '\p{Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Blk=_	Chess_symbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=_	Chess_symbols}', "");
    Expect(0, 129647, '\P{Is_Blk=_	Chess_symbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=_	Chess_symbols}', "");
    Expect(0, 129648, '\p{Is_Blk=_	Chess_symbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=_	Chess_symbols}', "");
    Expect(1, 129648, '\P{Is_Blk=_	Chess_symbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=_	Chess_symbols}', "");
    Error('\p{Block=/a/- Chorasmian}');
    Error('\P{Block=/a/- Chorasmian}');
    Expect(1, 69599, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Block=chorasmian}', "");
    Expect(0, 69599, '\P{Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Block=chorasmian}', "");
    Expect(0, 69600, '\p{Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Block=chorasmian}', "");
    Expect(1, 69600, '\P{Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Block=chorasmian}', "");
    Expect(1, 69599, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block: _	Chorasmian}', "");
    Expect(0, 69599, '\p{^Block: _	Chorasmian}', "");
    Expect(0, 69599, '\P{Block: _	Chorasmian}', "");
    Expect(1, 69599, '\P{^Block: _	Chorasmian}', "");
    Expect(0, 69600, '\p{Block: _	Chorasmian}', "");
    Expect(1, 69600, '\p{^Block: _	Chorasmian}', "");
    Expect(1, 69600, '\P{Block: _	Chorasmian}', "");
    Expect(0, 69600, '\P{^Block: _	Chorasmian}', "");
    Error('\p{Blk=:=	_Chorasmian}');
    Error('\P{Blk=:=	_Chorasmian}');
    Expect(1, 69599, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=chorasmian}', "");
    Expect(0, 69599, '\p{^Blk=chorasmian}', "");
    Expect(0, 69599, '\P{Blk=chorasmian}', "");
    Expect(1, 69599, '\P{^Blk=chorasmian}', "");
    Expect(0, 69600, '\p{Blk=chorasmian}', "");
    Expect(1, 69600, '\p{^Blk=chorasmian}', "");
    Expect(1, 69600, '\P{Blk=chorasmian}', "");
    Expect(0, 69600, '\P{^Blk=chorasmian}', "");
    Expect(1, 69599, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=_	chorasmian}', "");
    Expect(0, 69599, '\p{^Blk=_	chorasmian}', "");
    Expect(0, 69599, '\P{Blk=_	chorasmian}', "");
    Expect(1, 69599, '\P{^Blk=_	chorasmian}', "");
    Expect(0, 69600, '\p{Blk=_	chorasmian}', "");
    Expect(1, 69600, '\p{^Blk=_	chorasmian}', "");
    Expect(1, 69600, '\P{Blk=_	chorasmian}', "");
    Expect(0, 69600, '\P{^Blk=_	chorasmian}', "");
    Error('\p{Is_Block=_:=chorasmian}');
    Error('\P{Is_Block=_:=chorasmian}');
    Expect(1, 69599, '\p{Is_Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block=chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block=chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block=chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block=chorasmian}', "");
    Expect(1, 69599, '\p{Is_Block=		chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block=		chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block=		chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block=		chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block=		chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block=		chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block=		chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block=		chorasmian}', "");
    Error('\p{Is_Blk=/a/CHORASMIAN}');
    Error('\P{Is_Blk=/a/CHORASMIAN}');
    Expect(1, 69599, '\p{Is_Blk=chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk=chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk=chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk=chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk=chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk=chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk=chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk=chorasmian}', "");
    Expect(1, 69599, '\p{Is_Blk=_Chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk=_Chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk=_Chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk=_Chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk=_Chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk=_Chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk=_Chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk=_Chorasmian}', "");
    Error('\p{Block=-cjk_UNIFIED_Ideographs:=}');
    Error('\P{Block=-cjk_UNIFIED_Ideographs:=}');
    Expect(1, 40959, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=--CJK_unified_Ideographs}', "");
    Expect(0, 40959, '\p{^Block=--CJK_unified_Ideographs}', "");
    Expect(0, 40959, '\P{Block=--CJK_unified_Ideographs}', "");
    Expect(1, 40959, '\P{^Block=--CJK_unified_Ideographs}', "");
    Expect(0, 40960, '\p{Block=--CJK_unified_Ideographs}', "");
    Expect(1, 40960, '\p{^Block=--CJK_unified_Ideographs}', "");
    Expect(1, 40960, '\P{Block=--CJK_unified_Ideographs}', "");
    Expect(0, 40960, '\P{^Block=--CJK_unified_Ideographs}', "");
    Error('\p{Blk=_:=CJK}');
    Error('\P{Blk=_:=CJK}');
    Expect(1, 40959, '\p{Blk=:\ACJK\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\ACJK\z:}', "");;
    Expect(1, 40959, '\p{Blk=cjk}', "");
    Expect(0, 40959, '\p{^Blk=cjk}', "");
    Expect(0, 40959, '\P{Blk=cjk}', "");
    Expect(1, 40959, '\P{^Blk=cjk}', "");
    Expect(0, 40960, '\p{Blk=cjk}', "");
    Expect(1, 40960, '\p{^Blk=cjk}', "");
    Expect(1, 40960, '\P{Blk=cjk}', "");
    Expect(0, 40960, '\P{^Blk=cjk}', "");
    Expect(1, 40959, '\p{Blk=:\Acjk\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\Acjk\z:}', "");;
    Expect(1, 40959, '\p{Blk=_-CJK}', "");
    Expect(0, 40959, '\p{^Blk=_-CJK}', "");
    Expect(0, 40959, '\P{Blk=_-CJK}', "");
    Expect(1, 40959, '\P{^Blk=_-CJK}', "");
    Expect(0, 40960, '\p{Blk=_-CJK}', "");
    Expect(1, 40960, '\p{^Blk=_-CJK}', "");
    Expect(1, 40960, '\P{Blk=_-CJK}', "");
    Expect(0, 40960, '\P{^Blk=_-CJK}', "");
    Error('\p{Is_Block=/a/	CJK_Unified_IDEOGRAPHS}');
    Error('\P{Is_Block=/a/	CJK_Unified_IDEOGRAPHS}');
    Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40959, '\P{Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40960, '\p{Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40960, '\P{Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=  cjk_UNIFIED_Ideographs}', "");
    Error('\p{Is_Blk=-CJK/a/}');
    Error('\P{Is_Blk=-CJK/a/}');
    Expect(1, 40959, '\p{Is_Blk=cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk=cjk}', "");
    Expect(0, 40959, '\P{Is_Blk=cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk=cjk}', "");
    Expect(0, 40960, '\p{Is_Blk=cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk=cjk}', "");
    Expect(1, 40960, '\P{Is_Blk=cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk=cjk}', "");
    Expect(1, 40959, '\p{Is_Blk=-CJK}', "");
    Expect(0, 40959, '\p{^Is_Blk=-CJK}', "");
    Expect(0, 40959, '\P{Is_Blk=-CJK}', "");
    Expect(1, 40959, '\P{^Is_Blk=-CJK}', "");
    Expect(0, 40960, '\p{Is_Blk=-CJK}', "");
    Expect(1, 40960, '\p{^Is_Blk=-CJK}', "");
    Expect(1, 40960, '\P{Is_Blk=-CJK}', "");
    Expect(0, 40960, '\P{^Is_Blk=-CJK}', "");
    Error('\p{Block=/a/ -CJK_COMPATIBILITY}');
    Error('\P{Block=/a/ -CJK_COMPATIBILITY}');
    Expect(1, 13311, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(1, 13311, '\p{Block:    	cjk_Compatibility}', "");
    Expect(0, 13311, '\p{^Block:    	cjk_Compatibility}', "");
    Expect(0, 13311, '\P{Block:    	cjk_Compatibility}', "");
    Expect(1, 13311, '\P{^Block:    	cjk_Compatibility}', "");
    Expect(0, 13312, '\p{Block:    	cjk_Compatibility}', "");
    Expect(1, 13312, '\p{^Block:    	cjk_Compatibility}', "");
    Expect(1, 13312, '\P{Block:    	cjk_Compatibility}', "");
    Expect(0, 13312, '\P{^Block:    	cjk_Compatibility}', "");
    Error('\p{Blk: /a/CJK_compat}');
    Error('\P{Blk: /a/CJK_compat}');
    Expect(1, 13311, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(1, 13311, '\p{Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(1, 13311, '\p{Blk= CJK_Compat}', "");
    Expect(0, 13311, '\p{^Blk= CJK_Compat}', "");
    Expect(0, 13311, '\P{Blk= CJK_Compat}', "");
    Expect(1, 13311, '\P{^Blk= CJK_Compat}', "");
    Expect(0, 13312, '\p{Blk= CJK_Compat}', "");
    Expect(1, 13312, '\p{^Blk= CJK_Compat}', "");
    Expect(1, 13312, '\P{Blk= CJK_Compat}', "");
    Expect(0, 13312, '\P{^Blk= CJK_Compat}', "");
    Error('\p{Is_Block=:= cjk_Compatibility}');
    Error('\P{Is_Block=:= cjk_Compatibility}');
    Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Is_Block=	 CJK_Compatibility}', "");
    Expect(0, 13311, '\p{^Is_Block=	 CJK_Compatibility}', "");
    Expect(0, 13311, '\P{Is_Block=	 CJK_Compatibility}', "");
    Expect(1, 13311, '\P{^Is_Block=	 CJK_Compatibility}', "");
    Expect(0, 13312, '\p{Is_Block=	 CJK_Compatibility}', "");
    Expect(1, 13312, '\p{^Is_Block=	 CJK_Compatibility}', "");
    Expect(1, 13312, '\P{Is_Block=	 CJK_Compatibility}', "");
    Expect(0, 13312, '\P{^Is_Block=	 CJK_Compatibility}', "");
    Error('\p{Is_Blk=/a/--CJK_COMPAT}');
    Error('\P{Is_Blk=/a/--CJK_COMPAT}');
    Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Is_Blk=_cjk_compat}', "");
    Expect(0, 13311, '\p{^Is_Blk=_cjk_compat}', "");
    Expect(0, 13311, '\P{Is_Blk=_cjk_compat}', "");
    Expect(1, 13311, '\P{^Is_Blk=_cjk_compat}', "");
    Expect(0, 13312, '\p{Is_Blk=_cjk_compat}', "");
    Expect(1, 13312, '\p{^Is_Blk=_cjk_compat}', "");
    Expect(1, 13312, '\P{Is_Blk=_cjk_compat}', "");
    Expect(0, 13312, '\P{^Is_Blk=_cjk_compat}', "");
    Error('\p{Block=		CJK_compatibility_FORMS/a/}');
    Error('\P{Block=		CJK_compatibility_FORMS/a/}');
    Expect(1, 65103, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(1, 65103, '\p{Block= 	CJK_Compatibility_forms}', "");
    Expect(0, 65103, '\p{^Block= 	CJK_Compatibility_forms}', "");
    Expect(0, 65103, '\P{Block= 	CJK_Compatibility_forms}', "");
    Expect(1, 65103, '\P{^Block= 	CJK_Compatibility_forms}', "");
    Expect(0, 65104, '\p{Block= 	CJK_Compatibility_forms}', "");
    Expect(1, 65104, '\p{^Block= 	CJK_Compatibility_forms}', "");
    Expect(1, 65104, '\P{Block= 	CJK_Compatibility_forms}', "");
    Expect(0, 65104, '\P{^Block= 	CJK_Compatibility_forms}', "");
    Error('\p{Blk=:= cjk_Compat_Forms}');
    Error('\P{Blk=:= cjk_Compat_Forms}');
    Expect(1, 65103, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(1, 65103, '\p{Blk:    CJK_compat_FORMS}', "");
    Expect(0, 65103, '\p{^Blk:    CJK_compat_FORMS}', "");
    Expect(0, 65103, '\P{Blk:    CJK_compat_FORMS}', "");
    Expect(1, 65103, '\P{^Blk:    CJK_compat_FORMS}', "");
    Expect(0, 65104, '\p{Blk:    CJK_compat_FORMS}', "");
    Expect(1, 65104, '\p{^Blk:    CJK_compat_FORMS}', "");
    Expect(1, 65104, '\P{Blk:    CJK_compat_FORMS}', "");
    Expect(0, 65104, '\P{^Blk:    CJK_compat_FORMS}', "");
    Error('\p{Is_Block=	 CJK_Compatibility_Forms/a/}');
    Error('\P{Is_Block=	 CJK_Compatibility_Forms/a/}');
    Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65103, '\p{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65103, '\P{Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65103, '\P{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65104, '\p{Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65104, '\p{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65104, '\P{Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65104, '\P{^Is_Block=		CJK_compatibility_forms}', "");
    Error('\p{Is_Blk=/a/ -CJK_Compat_forms}');
    Error('\P{Is_Blk=/a/ -CJK_Compat_forms}');
    Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Is_Blk=--CJK_Compat_Forms}', "");
    Expect(0, 65103, '\p{^Is_Blk=--CJK_Compat_Forms}', "");
    Expect(0, 65103, '\P{Is_Blk=--CJK_Compat_Forms}', "");
    Expect(1, 65103, '\P{^Is_Blk=--CJK_Compat_Forms}', "");
    Expect(0, 65104, '\p{Is_Blk=--CJK_Compat_Forms}', "");
    Expect(1, 65104, '\p{^Is_Blk=--CJK_Compat_Forms}', "");
    Expect(1, 65104, '\P{Is_Blk=--CJK_Compat_Forms}', "");
    Expect(0, 65104, '\P{^Is_Blk=--CJK_Compat_Forms}', "");
    Error('\p{Block=/a/	CJK_Compatibility_ideographs}');
    Error('\P{Block=/a/	CJK_Compatibility_ideographs}');
    Expect(1, 64255, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=--CJK_Compatibility_ideographs}', "");
    Expect(0, 64255, '\p{^Block=--CJK_Compatibility_ideographs}', "");
    Expect(0, 64255, '\P{Block=--CJK_Compatibility_ideographs}', "");
    Expect(1, 64255, '\P{^Block=--CJK_Compatibility_ideographs}', "");
    Expect(0, 64256, '\p{Block=--CJK_Compatibility_ideographs}', "");
    Expect(1, 64256, '\p{^Block=--CJK_Compatibility_ideographs}', "");
    Expect(1, 64256, '\P{Block=--CJK_Compatibility_ideographs}', "");
    Expect(0, 64256, '\P{^Block=--CJK_Compatibility_ideographs}', "");
    Error('\p{Blk: :=-	cjk_Compat_Ideographs}');
    Error('\P{Blk: :=-	cjk_Compat_Ideographs}');
    Expect(1, 64255, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=- cjk_compat_ideographs}', "");
    Expect(0, 64255, '\p{^Blk=- cjk_compat_ideographs}', "");
    Expect(0, 64255, '\P{Blk=- cjk_compat_ideographs}', "");
    Expect(1, 64255, '\P{^Blk=- cjk_compat_ideographs}', "");
    Expect(0, 64256, '\p{Blk=- cjk_compat_ideographs}', "");
    Expect(1, 64256, '\p{^Blk=- cjk_compat_ideographs}', "");
    Expect(1, 64256, '\P{Blk=- cjk_compat_ideographs}', "");
    Expect(0, 64256, '\P{^Blk=- cjk_compat_ideographs}', "");
    Error('\p{Is_Block= CJK_COMPATIBILITY_ideographs:=}');
    Error('\P{Is_Block= CJK_COMPATIBILITY_ideographs:=}');
    Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(0, 64255, '\p{^Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(0, 64255, '\P{Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(1, 64255, '\P{^Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(0, 64256, '\p{Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(1, 64256, '\p{^Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(1, 64256, '\P{Is_Block= 	CJK_compatibility_Ideographs}', "");
    Expect(0, 64256, '\P{^Is_Block= 	CJK_compatibility_Ideographs}', "");
    Error('\p{Is_Blk=/a/-	CJK_Compat_ideographs}');
    Error('\P{Is_Blk=/a/-	CJK_Compat_ideographs}');
    Expect(1, 64255, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=-CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=-CJK_Compat_Ideographs}', "");
    Error('\p{Block=	CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT:=}');
    Error('\P{Block=	CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT:=}');
    Expect(1, 195103, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(1, 195103, '\p{Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(0, 195103, '\p{^Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(0, 195103, '\P{Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(1, 195103, '\P{^Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(0, 195104, '\p{Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(1, 195104, '\p{^Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(1, 195104, '\P{Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Expect(0, 195104, '\P{^Block=CJK_COMPATIBILITY_ideographs_Supplement}', "");
    Error('\p{Blk=__CJK_compat_Ideographs_sup/a/}');
    Error('\P{Blk=__CJK_compat_Ideographs_sup/a/}');
    Expect(1, 195103, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(1, 195103, '\p{Blk:cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Blk:cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Blk:cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Blk:cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Blk:cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Blk:cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Blk:cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Blk:cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(1, 195103, '\p{Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195103, '\p{^Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195103, '\P{Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195103, '\P{^Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195104, '\p{Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195104, '\p{^Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(1, 195104, '\P{Blk=__cjk_compat_Ideographs_Sup}', "");
    Expect(0, 195104, '\P{^Blk=__cjk_compat_Ideographs_Sup}', "");
    Error('\p{Is_Block=_:=cjk_compatibility_IDEOGRAPHS_supplement}');
    Error('\P{Is_Block=_:=cjk_compatibility_IDEOGRAPHS_supplement}');
    Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195103, '\p{^Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195103, '\P{Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195103, '\P{^Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195104, '\p{Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195104, '\p{^Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(1, 195104, '\P{Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Expect(0, 195104, '\P{^Is_Block:	 -CJK_compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
    Error('\p{Is_Blk=/a/ 	CJK_Compat_ideographs_Sup}');
    Error('\P{Is_Blk=/a/ 	CJK_Compat_ideographs_Sup}');
    Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195103, '\p{^Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195103, '\P{Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195103, '\P{^Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195104, '\p{Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195104, '\p{^Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(1, 195104, '\P{Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Expect(0, 195104, '\P{^Is_Blk= CJK_COMPAT_Ideographs_Sup}', "");
    Error('\p{Block=	/a/cjk_Unified_ideographs_EXTENSION_A}');
    Error('\P{Block=	/a/cjk_Unified_ideographs_EXTENSION_A}');
    Expect(1, 19903, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(0, 19904, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(0, 19904, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(1, 19903, '\p{Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(0, 19903, '\p{^Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(0, 19903, '\P{Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(1, 19903, '\P{^Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(0, 19904, '\p{Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(1, 19904, '\p{^Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(1, 19904, '\P{Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Expect(0, 19904, '\P{^Block=	-CJK_unified_Ideographs_Extension_A}', "");
    Error('\p{Blk=/a/_	CJK_ext_A}');
    Error('\P{Blk=/a/_	CJK_ext_A}');
    Expect(1, 19903, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(1, 19903, '\p{Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(1, 19903, '\p{Blk=- CJK_Ext_a}', "");
    Expect(0, 19903, '\p{^Blk=- CJK_Ext_a}', "");
    Expect(0, 19903, '\P{Blk=- CJK_Ext_a}', "");
    Expect(1, 19903, '\P{^Blk=- CJK_Ext_a}', "");
    Expect(0, 19904, '\p{Blk=- CJK_Ext_a}', "");
    Expect(1, 19904, '\p{^Blk=- CJK_Ext_a}', "");
    Expect(1, 19904, '\P{Blk=- CJK_Ext_a}', "");
    Expect(0, 19904, '\P{^Blk=- CJK_Ext_a}', "");
    Error('\p{Is_Block=-:=CJK_Unified_Ideographs_Extension_a}');
    Error('\P{Is_Block=-:=CJK_Unified_Ideographs_Extension_a}');
    Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(0, 19903, '\p{^Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(0, 19903, '\P{Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(1, 19903, '\P{^Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(0, 19904, '\p{Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(1, 19904, '\p{^Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(1, 19904, '\P{Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Expect(0, 19904, '\P{^Is_Block= -CJK_unified_IDEOGRAPHS_Extension_a}', "");
    Error('\p{Is_Blk=/a/_CJK_EXT_A}');
    Error('\P{Is_Blk=/a/_CJK_EXT_A}');
    Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Is_Blk:--CJK_EXT_A}', "");
    Expect(0, 19903, '\p{^Is_Blk:--CJK_EXT_A}', "");
    Expect(0, 19903, '\P{Is_Blk:--CJK_EXT_A}', "");
    Expect(1, 19903, '\P{^Is_Blk:--CJK_EXT_A}', "");
    Expect(0, 19904, '\p{Is_Blk:--CJK_EXT_A}', "");
    Expect(1, 19904, '\p{^Is_Blk:--CJK_EXT_A}', "");
    Expect(1, 19904, '\P{Is_Blk:--CJK_EXT_A}', "");
    Expect(0, 19904, '\P{^Is_Blk:--CJK_EXT_A}', "");
    Error('\p{Block=_CJK_UNIFIED_ideographs_extension_B/a/}');
    Error('\P{Block=_CJK_UNIFIED_ideographs_extension_B/a/}');
    Expect(1, 173791, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(0, 173792, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(0, 173792, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(1, 173791, '\p{Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\p{^Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\P{Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173791, '\P{^Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\p{Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\p{^Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\P{Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\P{^Block=--CJK_Unified_Ideographs_Extension_B}', "");
    Error('\p{Blk=_CJK_Ext_B/a/}');
    Error('\P{Blk=_CJK_Ext_B/a/}');
    Expect(1, 173791, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(1, 173791, '\p{Blk:cjkextb}', "");
    Expect(0, 173791, '\p{^Blk:cjkextb}', "");
    Expect(0, 173791, '\P{Blk:cjkextb}', "");
    Expect(1, 173791, '\P{^Blk:cjkextb}', "");
    Expect(0, 173792, '\p{Blk:cjkextb}', "");
    Expect(1, 173792, '\p{^Blk:cjkextb}', "");
    Expect(1, 173792, '\P{Blk:cjkextb}', "");
    Expect(0, 173792, '\P{^Blk:cjkextb}', "");
    Expect(1, 173791, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(1, 173791, '\p{Blk:	-CJK_ext_B}', "");
    Expect(0, 173791, '\p{^Blk:	-CJK_ext_B}', "");
    Expect(0, 173791, '\P{Blk:	-CJK_ext_B}', "");
    Expect(1, 173791, '\P{^Blk:	-CJK_ext_B}', "");
    Expect(0, 173792, '\p{Blk:	-CJK_ext_B}', "");
    Expect(1, 173792, '\p{^Blk:	-CJK_ext_B}', "");
    Expect(1, 173792, '\P{Blk:	-CJK_ext_B}', "");
    Expect(0, 173792, '\P{^Blk:	-CJK_ext_B}', "");
    Error('\p{Is_Block: -cjk_unified_IDEOGRAPHS_Extension_B:=}');
    Error('\P{Is_Block: -cjk_unified_IDEOGRAPHS_Extension_B:=}');
    Expect(1, 173791, '\p{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Is_Block:	cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(0, 173791, '\p{^Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(0, 173791, '\P{Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(1, 173791, '\P{^Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(0, 173792, '\p{Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(1, 173792, '\p{^Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(1, 173792, '\P{Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Expect(0, 173792, '\P{^Is_Block=-cjk_UNIFIED_Ideographs_extension_b}', "");
    Error('\p{Is_Blk=:=--CJK_EXT_B}');
    Error('\P{Is_Blk=:=--CJK_EXT_B}');
    Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Is_Blk= _CJK_ext_B}', "");
    Expect(0, 173791, '\p{^Is_Blk= _CJK_ext_B}', "");
    Expect(0, 173791, '\P{Is_Blk= _CJK_ext_B}', "");
    Expect(1, 173791, '\P{^Is_Blk= _CJK_ext_B}', "");
    Expect(0, 173792, '\p{Is_Blk= _CJK_ext_B}', "");
    Expect(1, 173792, '\p{^Is_Blk= _CJK_ext_B}', "");
    Expect(1, 173792, '\P{Is_Blk= _CJK_ext_B}', "");
    Expect(0, 173792, '\P{^Is_Blk= _CJK_ext_B}', "");
    Error('\p{Block=	-CJK_unified_IDEOGRAPHS_EXTENSION_c:=}');
    Error('\P{Block=	-CJK_unified_IDEOGRAPHS_EXTENSION_c:=}');
    Expect(1, 177983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(0, 177984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(0, 177984, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(1, 177983, '\p{Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(0, 177983, '\p{^Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(0, 177983, '\P{Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(1, 177983, '\P{^Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(0, 177984, '\p{Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(1, 177984, '\p{^Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(1, 177984, '\P{Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Expect(0, 177984, '\P{^Block=_-CJK_Unified_Ideographs_extension_c}', "");
    Error('\p{Blk=_:=CJK_Ext_c}');
    Error('\P{Blk=_:=CJK_Ext_c}');
    Expect(1, 177983, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(1, 177983, '\p{Blk:cjkextc}', "");
    Expect(0, 177983, '\p{^Blk:cjkextc}', "");
    Expect(0, 177983, '\P{Blk:cjkextc}', "");
    Expect(1, 177983, '\P{^Blk:cjkextc}', "");
    Expect(0, 177984, '\p{Blk:cjkextc}', "");
    Expect(1, 177984, '\p{^Blk:cjkextc}', "");
    Expect(1, 177984, '\P{Blk:cjkextc}', "");
    Expect(0, 177984, '\P{^Blk:cjkextc}', "");
    Expect(1, 177983, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(1, 177983, '\p{Blk=_cjk_ext_c}', "");
    Expect(0, 177983, '\p{^Blk=_cjk_ext_c}', "");
    Expect(0, 177983, '\P{Blk=_cjk_ext_c}', "");
    Expect(1, 177983, '\P{^Blk=_cjk_ext_c}', "");
    Expect(0, 177984, '\p{Blk=_cjk_ext_c}', "");
    Expect(1, 177984, '\p{^Blk=_cjk_ext_c}', "");
    Expect(1, 177984, '\P{Blk=_cjk_ext_c}', "");
    Expect(0, 177984, '\P{^Blk=_cjk_ext_c}', "");
    Error('\p{Is_Block=/a/ 	CJK_UNIFIED_Ideographs_Extension_C}');
    Error('\P{Is_Block=/a/ 	CJK_UNIFIED_Ideographs_Extension_C}');
    Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(0, 177983, '\p{^Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(0, 177983, '\P{Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(1, 177983, '\P{^Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(0, 177984, '\p{Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(1, 177984, '\p{^Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(1, 177984, '\P{Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Expect(0, 177984, '\P{^Is_Block:    _cjk_unified_Ideographs_Extension_c}', "");
    Error('\p{Is_Blk= 	CJK_Ext_C:=}');
    Error('\P{Is_Blk= 	CJK_Ext_C:=}');
    Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Is_Blk=	CJK_ext_c}', "");
    Expect(0, 177983, '\p{^Is_Blk=	CJK_ext_c}', "");
    Expect(0, 177983, '\P{Is_Blk=	CJK_ext_c}', "");
    Expect(1, 177983, '\P{^Is_Blk=	CJK_ext_c}', "");
    Expect(0, 177984, '\p{Is_Blk=	CJK_ext_c}', "");
    Expect(1, 177984, '\p{^Is_Blk=	CJK_ext_c}', "");
    Expect(1, 177984, '\P{Is_Blk=	CJK_ext_c}', "");
    Expect(0, 177984, '\P{^Is_Blk=	CJK_ext_c}', "");
    Error('\p{Block=/a/- CJK_Unified_Ideographs_EXTENSION_d}');
    Error('\P{Block=/a/- CJK_Unified_Ideographs_EXTENSION_d}');
    Expect(1, 178207, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(0, 178208, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(0, 178208, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(1, 178207, '\p{Block=CJK_unified_ideographs_extension_D}', "");
    Expect(0, 178207, '\p{^Block=CJK_unified_ideographs_extension_D}', "");
    Expect(0, 178207, '\P{Block=CJK_unified_ideographs_extension_D}', "");
    Expect(1, 178207, '\P{^Block=CJK_unified_ideographs_extension_D}', "");
    Expect(0, 178208, '\p{Block=CJK_unified_ideographs_extension_D}', "");
    Expect(1, 178208, '\p{^Block=CJK_unified_ideographs_extension_D}', "");
    Expect(1, 178208, '\P{Block=CJK_unified_ideographs_extension_D}', "");
    Expect(0, 178208, '\P{^Block=CJK_unified_ideographs_extension_D}', "");
    Error('\p{Blk=		CJK_ext_D:=}');
    Error('\P{Blk=		CJK_ext_D:=}');
    Expect(1, 178207, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(1, 178207, '\p{Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(1, 178207, '\p{Blk=--CJK_Ext_D}', "");
    Expect(0, 178207, '\p{^Blk=--CJK_Ext_D}', "");
    Expect(0, 178207, '\P{Blk=--CJK_Ext_D}', "");
    Expect(1, 178207, '\P{^Blk=--CJK_Ext_D}', "");
    Expect(0, 178208, '\p{Blk=--CJK_Ext_D}', "");
    Expect(1, 178208, '\p{^Blk=--CJK_Ext_D}', "");
    Expect(1, 178208, '\P{Blk=--CJK_Ext_D}', "");
    Expect(0, 178208, '\P{^Blk=--CJK_Ext_D}', "");
    Error('\p{Is_Block=		CJK_unified_IDEOGRAPHS_extension_D:=}');
    Error('\P{Is_Block=		CJK_unified_IDEOGRAPHS_extension_D:=}');
    Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\p{^Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(0, 178207, '\P{Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(1, 178207, '\P{^Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\p{Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\p{^Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(1, 178208, '\P{Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Expect(0, 178208, '\P{^Is_Block=		CJK_unified_ideographs_EXTENSION_D}', "");
    Error('\p{Is_Blk=/a/CJK_EXT_D}');
    Error('\P{Is_Blk=/a/CJK_EXT_D}');
    Expect(1, 178207, '\p{Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Is_Blk= 	CJK_EXT_d}', "");
    Expect(0, 178207, '\p{^Is_Blk= 	CJK_EXT_d}', "");
    Expect(0, 178207, '\P{Is_Blk= 	CJK_EXT_d}', "");
    Expect(1, 178207, '\P{^Is_Blk= 	CJK_EXT_d}', "");
    Expect(0, 178208, '\p{Is_Blk= 	CJK_EXT_d}', "");
    Expect(1, 178208, '\p{^Is_Blk= 	CJK_EXT_d}', "");
    Expect(1, 178208, '\P{Is_Blk= 	CJK_EXT_d}', "");
    Expect(0, 178208, '\P{^Is_Blk= 	CJK_EXT_d}', "");
    Error('\p{Block=_:=CJK_Unified_Ideographs_Extension_E}');
    Error('\P{Block=_:=CJK_Unified_Ideographs_Extension_E}');
    Expect(1, 183983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(0, 183984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(1, 183983, '\p{Block: cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Block: cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Block: cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Block: cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Block: cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Block: cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Block: cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Block: cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(0, 183984, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(1, 183983, '\p{Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(0, 183983, '\p{^Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(0, 183983, '\P{Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(1, 183983, '\P{^Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(0, 183984, '\p{Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(1, 183984, '\p{^Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(1, 183984, '\P{Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Expect(0, 183984, '\P{^Block:- CJK_UNIFIED_IDEOGRAPHS_EXTENSION_e}', "");
    Error('\p{Blk=:=--CJK_Ext_e}');
    Error('\P{Blk=:=--CJK_Ext_e}');
    Expect(1, 183983, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(1, 183983, '\p{Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(1, 183983, '\p{Blk=-CJK_Ext_E}', "");
    Expect(0, 183983, '\p{^Blk=-CJK_Ext_E}', "");
    Expect(0, 183983, '\P{Blk=-CJK_Ext_E}', "");
    Expect(1, 183983, '\P{^Blk=-CJK_Ext_E}', "");
    Expect(0, 183984, '\p{Blk=-CJK_Ext_E}', "");
    Expect(1, 183984, '\p{^Blk=-CJK_Ext_E}', "");
    Expect(1, 183984, '\P{Blk=-CJK_Ext_E}', "");
    Expect(0, 183984, '\P{^Blk=-CJK_Ext_E}', "");
    Error('\p{Is_Block=:=__CJK_Unified_Ideographs_EXTENSION_E}');
    Error('\P{Is_Block=:=__CJK_Unified_Ideographs_EXTENSION_E}');
    Expect(1, 183983, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\p{^Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\P{Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(1, 183983, '\P{^Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\p{Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\p{^Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\P{Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\P{^Is_Block=--CJK_UNIFIED_ideographs_EXTENSION_E}', "");
    Error('\p{Is_Blk= :=CJK_EXT_E}');
    Error('\P{Is_Blk= :=CJK_EXT_E}');
    Expect(1, 183983, '\p{Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Is_Blk=-	CJK_EXT_E}', "");
    Expect(0, 183983, '\p{^Is_Blk=-	CJK_EXT_E}', "");
    Expect(0, 183983, '\P{Is_Blk=-	CJK_EXT_E}', "");
    Expect(1, 183983, '\P{^Is_Blk=-	CJK_EXT_E}', "");
    Expect(0, 183984, '\p{Is_Blk=-	CJK_EXT_E}', "");
    Expect(1, 183984, '\p{^Is_Blk=-	CJK_EXT_E}', "");
    Expect(1, 183984, '\P{Is_Blk=-	CJK_EXT_E}', "");
    Expect(0, 183984, '\P{^Is_Blk=-	CJK_EXT_E}', "");
    Error('\p{Block=	/a/CJK_UNIFIED_Ideographs_Extension_F}');
    Error('\P{Block=	/a/CJK_UNIFIED_Ideographs_Extension_F}');
    Expect(1, 191471, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(0, 191472, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(1, 191471, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(0, 191472, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(1, 191471, '\p{Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(0, 191471, '\p{^Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(0, 191471, '\P{Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(1, 191471, '\P{^Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(0, 191472, '\p{Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(1, 191472, '\p{^Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(1, 191472, '\P{Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Expect(0, 191472, '\P{^Block:   -_CJK_UNIFIED_Ideographs_Extension_F}', "");
    Error('\p{Blk: _	CJK_Ext_f/a/}');
    Error('\P{Blk: _	CJK_Ext_f/a/}');
    Expect(1, 191471, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(1, 191471, '\p{Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(1, 191471, '\p{Blk=	cjk_Ext_F}', "");
    Expect(0, 191471, '\p{^Blk=	cjk_Ext_F}', "");
    Expect(0, 191471, '\P{Blk=	cjk_Ext_F}', "");
    Expect(1, 191471, '\P{^Blk=	cjk_Ext_F}', "");
    Expect(0, 191472, '\p{Blk=	cjk_Ext_F}', "");
    Expect(1, 191472, '\p{^Blk=	cjk_Ext_F}', "");
    Expect(1, 191472, '\P{Blk=	cjk_Ext_F}', "");
    Expect(0, 191472, '\P{^Blk=	cjk_Ext_F}', "");
    Error('\p{Is_Block=cjk_unified_IDEOGRAPHS_extension_f:=}');
    Error('\P{Is_Block=cjk_unified_IDEOGRAPHS_extension_f:=}');
    Expect(1, 191471, '\p{Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Is_Block:   cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\p{^Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\P{Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(1, 191471, '\P{^Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\p{Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\p{^Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\P{Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\P{^Is_Block:	_CJK_Unified_Ideographs_extension_F}', "");
    Error('\p{Is_Blk=/a/CJK_EXT_F}');
    Error('\P{Is_Blk=/a/CJK_EXT_F}');
    Expect(1, 191471, '\p{Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Is_Blk=-_CJK_Ext_f}', "");
    Expect(0, 191471, '\p{^Is_Blk=-_CJK_Ext_f}', "");
    Expect(0, 191471, '\P{Is_Blk=-_CJK_Ext_f}', "");
    Expect(1, 191471, '\P{^Is_Blk=-_CJK_Ext_f}', "");
    Expect(0, 191472, '\p{Is_Blk=-_CJK_Ext_f}', "");
    Expect(1, 191472, '\p{^Is_Blk=-_CJK_Ext_f}', "");
    Expect(1, 191472, '\P{Is_Blk=-_CJK_Ext_f}', "");
    Expect(0, 191472, '\P{^Is_Blk=-_CJK_Ext_f}', "");
    Error('\p{Block=:=_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_g}');
    Error('\P{Block=:=_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_g}');
    Expect(1, 201551, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(0, 201552, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(1, 201551, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(0, 201552, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(1, 201551, '\p{Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(0, 201551, '\p{^Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(0, 201551, '\P{Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(1, 201551, '\P{^Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(0, 201552, '\p{Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(1, 201552, '\p{^Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(1, 201552, '\P{Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Expect(0, 201552, '\P{^Block=CJK_Unified_IDEOGRAPHS_extension_G}', "");
    Error('\p{Blk=/a/ -CJK_EXT_G}');
    Error('\P{Blk=/a/ -CJK_EXT_G}');
    Expect(1, 201551, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(1, 201551, '\p{Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(1, 201551, '\p{Blk= CJK_ext_G}', "");
    Expect(0, 201551, '\p{^Blk= CJK_ext_G}', "");
    Expect(0, 201551, '\P{Blk= CJK_ext_G}', "");
    Expect(1, 201551, '\P{^Blk= CJK_ext_G}', "");
    Expect(0, 201552, '\p{Blk= CJK_ext_G}', "");
    Expect(1, 201552, '\p{^Blk= CJK_ext_G}', "");
    Expect(1, 201552, '\P{Blk= CJK_ext_G}', "");
    Expect(0, 201552, '\P{^Blk= CJK_ext_G}', "");
    Error('\p{Is_Block=:=	_CJK_Unified_Ideographs_Extension_G}');
    Error('\P{Is_Block=:=	_CJK_Unified_Ideographs_Extension_G}');
    Expect(1, 201551, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(0, 201551, '\p{^Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(0, 201551, '\P{Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(1, 201551, '\P{^Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(0, 201552, '\p{Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(1, 201552, '\p{^Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(1, 201552, '\P{Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Expect(0, 201552, '\P{^Is_Block=	-CJK_Unified_Ideographs_Extension_G}', "");
    Error('\p{Is_Blk= -CJK_Ext_G:=}');
    Error('\P{Is_Blk= -CJK_Ext_G:=}');
    Expect(1, 201551, '\p{Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Is_Blk= -CJK_EXT_G}', "");
    Expect(0, 201551, '\p{^Is_Blk= -CJK_EXT_G}', "");
    Expect(0, 201551, '\P{Is_Blk= -CJK_EXT_G}', "");
    Expect(1, 201551, '\P{^Is_Blk= -CJK_EXT_G}', "");
    Expect(0, 201552, '\p{Is_Blk= -CJK_EXT_G}', "");
    Expect(1, 201552, '\p{^Is_Blk= -CJK_EXT_G}', "");
    Expect(1, 201552, '\P{Is_Blk= -CJK_EXT_G}', "");
    Expect(0, 201552, '\P{^Is_Blk= -CJK_EXT_G}', "");
    Error('\p{Block=_-CJK_radicals_supplement:=}');
    Error('\P{Block=_-CJK_radicals_supplement:=}');
    Expect(1, 12031, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(1, 12031, '\p{Block:-CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\p{^Block:-CJK_Radicals_Supplement}', "");
    Expect(0, 12031, '\P{Block:-CJK_Radicals_Supplement}', "");
    Expect(1, 12031, '\P{^Block:-CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\p{Block:-CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\p{^Block:-CJK_Radicals_Supplement}', "");
    Expect(1, 12032, '\P{Block:-CJK_Radicals_Supplement}', "");
    Expect(0, 12032, '\P{^Block:-CJK_Radicals_Supplement}', "");
    Error('\p{Blk:__cjk_radicals_sup/a/}');
    Error('\P{Blk:__cjk_radicals_sup/a/}');
    Expect(1, 12031, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(1, 12031, '\p{Blk:  CJK_radicals_Sup}', "");
    Expect(0, 12031, '\p{^Blk:  CJK_radicals_Sup}', "");
    Expect(0, 12031, '\P{Blk:  CJK_radicals_Sup}', "");
    Expect(1, 12031, '\P{^Blk:  CJK_radicals_Sup}', "");
    Expect(0, 12032, '\p{Blk:  CJK_radicals_Sup}', "");
    Expect(1, 12032, '\p{^Blk:  CJK_radicals_Sup}', "");
    Expect(1, 12032, '\P{Blk:  CJK_radicals_Sup}', "");
    Expect(0, 12032, '\P{^Blk:  CJK_radicals_Sup}', "");
    Error('\p{Is_Block=	 cjk_Radicals_SUPPLEMENT:=}');
    Error('\P{Is_Block=	 cjk_Radicals_SUPPLEMENT:=}');
    Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\p{^Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\P{Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(1, 12031, '\P{^Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\p{Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\p{^Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\P{Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\P{^Is_Block=-	cjk_Radicals_SUPPLEMENT}', "");
    Error('\p{Is_Blk=:=-_cjk_radicals_sup}');
    Error('\P{Is_Blk=:=-_cjk_radicals_sup}');
    Expect(1, 12031, '\p{Is_Blk:   cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Is_Blk:   cjkradicalssup}', "");
    Expect(0, 12031, '\P{Is_Blk:   cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Is_Blk:   cjkradicalssup}', "");
    Expect(0, 12032, '\p{Is_Blk:   cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Is_Blk:   cjkradicalssup}', "");
    Expect(1, 12032, '\P{Is_Blk:   cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Is_Blk:   cjkradicalssup}', "");
    Expect(1, 12031, '\p{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12031, '\p{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12031, '\P{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12031, '\P{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12032, '\p{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12032, '\p{^Is_Blk= cjk_Radicals_Sup}', "");
    Expect(1, 12032, '\P{Is_Blk= cjk_Radicals_Sup}', "");
    Expect(0, 12032, '\P{^Is_Blk= cjk_Radicals_Sup}', "");
    Error('\p{Block=- CJK_Strokes:=}');
    Error('\P{Block=- CJK_Strokes:=}');
    Expect(1, 12783, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Block=-_CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Block=-_CJK_Strokes}', "");
    Expect(0, 12783, '\P{Block=-_CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Block=-_CJK_Strokes}', "");
    Expect(0, 12784, '\p{Block=-_CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Block=-_CJK_Strokes}', "");
    Expect(1, 12784, '\P{Block=-_CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Block=-_CJK_Strokes}', "");
    Error('\p{Blk=_:=CJK_STROKES}');
    Error('\P{Blk=_:=CJK_STROKES}');
    Expect(1, 12783, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Blk= CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Blk= CJK_Strokes}', "");
    Expect(0, 12783, '\P{Blk= CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Blk= CJK_Strokes}', "");
    Expect(0, 12784, '\p{Blk= CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Blk= CJK_Strokes}', "");
    Expect(1, 12784, '\P{Blk= CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Blk= CJK_Strokes}', "");
    Error('\p{Is_Block=  cjk_STROKES:=}');
    Error('\P{Is_Block=  cjk_STROKES:=}');
    Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Block=	CJK_strokes}', "");
    Expect(0, 12783, '\p{^Is_Block=	CJK_strokes}', "");
    Expect(0, 12783, '\P{Is_Block=	CJK_strokes}', "");
    Expect(1, 12783, '\P{^Is_Block=	CJK_strokes}', "");
    Expect(0, 12784, '\p{Is_Block=	CJK_strokes}', "");
    Expect(1, 12784, '\p{^Is_Block=	CJK_strokes}', "");
    Expect(1, 12784, '\P{Is_Block=	CJK_strokes}', "");
    Expect(0, 12784, '\P{^Is_Block=	CJK_strokes}', "");
    Error('\p{Is_Blk=  CJK_STROKES:=}');
    Error('\P{Is_Blk=  CJK_STROKES:=}');
    Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Blk=__cjk_strokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=__cjk_strokes}', "");
    Expect(0, 12783, '\P{Is_Blk=__cjk_strokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=__cjk_strokes}', "");
    Expect(0, 12784, '\p{Is_Blk=__cjk_strokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=__cjk_strokes}', "");
    Expect(1, 12784, '\P{Is_Blk=__cjk_strokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=__cjk_strokes}', "");
    Error('\p{Block=-CJK_Symbols_And_PUNCTUATION/a/}');
    Error('\P{Block=-CJK_Symbols_And_PUNCTUATION/a/}');
    Expect(1, 12351, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=  CJK_symbols_And_Punctuation}', "");
    Expect(0, 12351, '\p{^Block=  CJK_symbols_And_Punctuation}', "");
    Expect(0, 12351, '\P{Block=  CJK_symbols_And_Punctuation}', "");
    Expect(1, 12351, '\P{^Block=  CJK_symbols_And_Punctuation}', "");
    Expect(0, 12352, '\p{Block=  CJK_symbols_And_Punctuation}', "");
    Expect(1, 12352, '\p{^Block=  CJK_symbols_And_Punctuation}', "");
    Expect(1, 12352, '\P{Block=  CJK_symbols_And_Punctuation}', "");
    Expect(0, 12352, '\P{^Block=  CJK_symbols_And_Punctuation}', "");
    Error('\p{Blk=/a/		CJK_SYMBOLS}');
    Error('\P{Blk=/a/		CJK_SYMBOLS}');
    Expect(1, 12351, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(1, 12351, '\p{Blk:		 cjk_Symbols}', "");
    Expect(0, 12351, '\p{^Blk:		 cjk_Symbols}', "");
    Expect(0, 12351, '\P{Blk:		 cjk_Symbols}', "");
    Expect(1, 12351, '\P{^Blk:		 cjk_Symbols}', "");
    Expect(0, 12352, '\p{Blk:		 cjk_Symbols}', "");
    Expect(1, 12352, '\p{^Blk:		 cjk_Symbols}', "");
    Expect(1, 12352, '\P{Blk:		 cjk_Symbols}', "");
    Expect(0, 12352, '\P{^Blk:		 cjk_Symbols}', "");
    Error('\p{Is_Block=-/a/CJK_Symbols_and_Punctuation}');
    Error('\P{Is_Block=-/a/CJK_Symbols_and_Punctuation}');
    Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12351, '\P{Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12352, '\p{Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(1, 12352, '\P{Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=	CJK_Symbols_and_Punctuation}', "");
    Error('\p{Is_Blk:	:=_-cjk_symbols}');
    Error('\P{Is_Blk:	:=_-cjk_symbols}');
    Expect(1, 12351, '\p{Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(0, 12351, '\p{^Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(0, 12351, '\P{Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(1, 12351, '\P{^Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(0, 12352, '\p{Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(1, 12352, '\p{^Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(1, 12352, '\P{Is_Blk=	_CJK_SYMBOLS}', "");
    Expect(0, 12352, '\P{^Is_Blk=	_CJK_SYMBOLS}', "");
    Error('\p{Block=_hangul_Compatibility_Jamo:=}');
    Error('\P{Block=_hangul_Compatibility_Jamo:=}');
    Expect(1, 12687, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(1, 12687, '\p{Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\p{^Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\P{Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12687, '\P{^Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\p{Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\p{^Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\P{Block=-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\P{^Block=-hangul_COMPATIBILITY_Jamo}', "");
    Error('\p{Blk=:=COMPAT_JAMO}');
    Error('\P{Blk=:=COMPAT_JAMO}');
    Expect(1, 12687, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=-COMPAT_JAMO}', "");
    Expect(0, 12687, '\p{^Blk=-COMPAT_JAMO}', "");
    Expect(0, 12687, '\P{Blk=-COMPAT_JAMO}', "");
    Expect(1, 12687, '\P{^Blk=-COMPAT_JAMO}', "");
    Expect(0, 12688, '\p{Blk=-COMPAT_JAMO}', "");
    Expect(1, 12688, '\p{^Blk=-COMPAT_JAMO}', "");
    Expect(1, 12688, '\P{Blk=-COMPAT_JAMO}', "");
    Expect(0, 12688, '\P{^Blk=-COMPAT_JAMO}', "");
    Error('\p{Is_Block=-HANGUL_Compatibility_jamo:=}');
    Error('\P{Is_Block=-HANGUL_Compatibility_jamo:=}');
    Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\p{^Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12687, '\P{Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12687, '\P{^Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\p{Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\p{^Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(1, 12688, '\P{Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Expect(0, 12688, '\P{^Is_Block:-hangul_COMPATIBILITY_Jamo}', "");
    Error('\p{Is_Blk=/a/		Compat_jamo}');
    Error('\P{Is_Blk=/a/		Compat_jamo}');
    Expect(1, 12687, '\p{Is_Blk:   compatjamo}', "");
    Expect(0, 12687, '\p{^Is_Blk:   compatjamo}', "");
    Expect(0, 12687, '\P{Is_Blk:   compatjamo}', "");
    Expect(1, 12687, '\P{^Is_Blk:   compatjamo}', "");
    Expect(0, 12688, '\p{Is_Blk:   compatjamo}', "");
    Expect(1, 12688, '\p{^Is_Blk:   compatjamo}', "");
    Expect(1, 12688, '\P{Is_Blk:   compatjamo}', "");
    Expect(0, 12688, '\P{^Is_Blk:   compatjamo}', "");
    Expect(1, 12687, '\p{Is_Blk=Compat_Jamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=Compat_Jamo}', "");
    Expect(0, 12687, '\P{Is_Blk=Compat_Jamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=Compat_Jamo}', "");
    Expect(0, 12688, '\p{Is_Blk=Compat_Jamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=Compat_Jamo}', "");
    Expect(1, 12688, '\P{Is_Blk=Compat_Jamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=Compat_Jamo}', "");
    Error('\p{Block=:=_ Control_pictures}');
    Error('\P{Block=:=_ Control_pictures}');
    Expect(1, 9279, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Block=controlpictures}', "");
    Expect(0, 9279, '\P{Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Block=controlpictures}', "");
    Expect(0, 9280, '\p{Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Block=controlpictures}', "");
    Expect(1, 9280, '\P{Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Block=controlpictures}', "");
    Expect(1, 9279, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Block=_Control_Pictures}', "");
    Expect(0, 9279, '\p{^Block=_Control_Pictures}', "");
    Expect(0, 9279, '\P{Block=_Control_Pictures}', "");
    Expect(1, 9279, '\P{^Block=_Control_Pictures}', "");
    Expect(0, 9280, '\p{Block=_Control_Pictures}', "");
    Expect(1, 9280, '\p{^Block=_Control_Pictures}', "");
    Expect(1, 9280, '\P{Block=_Control_Pictures}', "");
    Expect(0, 9280, '\P{^Block=_Control_Pictures}', "");
    Error('\p{Blk=_-Control_PICTURES/a/}');
    Error('\P{Blk=_-Control_PICTURES/a/}');
    Expect(1, 9279, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Blk:controlpictures}', "");
    Expect(0, 9279, '\p{^Blk:controlpictures}', "");
    Expect(0, 9279, '\P{Blk:controlpictures}', "");
    Expect(1, 9279, '\P{^Blk:controlpictures}', "");
    Expect(0, 9280, '\p{Blk:controlpictures}', "");
    Expect(1, 9280, '\p{^Blk:controlpictures}', "");
    Expect(1, 9280, '\P{Blk:controlpictures}', "");
    Expect(0, 9280, '\P{^Blk:controlpictures}', "");
    Expect(1, 9279, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=	Control_Pictures}', "");
    Expect(0, 9279, '\p{^Blk=	Control_Pictures}', "");
    Expect(0, 9279, '\P{Blk=	Control_Pictures}', "");
    Expect(1, 9279, '\P{^Blk=	Control_Pictures}', "");
    Expect(0, 9280, '\p{Blk=	Control_Pictures}', "");
    Expect(1, 9280, '\p{^Blk=	Control_Pictures}', "");
    Expect(1, 9280, '\P{Blk=	Control_Pictures}', "");
    Expect(0, 9280, '\P{^Blk=	Control_Pictures}', "");
    Error('\p{Is_Block=-Control_Pictures:=}');
    Error('\P{Is_Block=-Control_Pictures:=}');
    Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Block=	_Control_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Block=	_Control_Pictures}', "");
    Expect(0, 9279, '\P{Is_Block=	_Control_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Block=	_Control_Pictures}', "");
    Expect(0, 9280, '\p{Is_Block=	_Control_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Block=	_Control_Pictures}', "");
    Expect(1, 9280, '\P{Is_Block=	_Control_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Block=	_Control_Pictures}', "");
    Error('\p{Is_Blk=	-CONTROL_PICTURES:=}');
    Error('\P{Is_Blk=	-CONTROL_PICTURES:=}');
    Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Blk= Control_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Blk= Control_Pictures}', "");
    Expect(0, 9279, '\P{Is_Blk= Control_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Blk= Control_Pictures}', "");
    Expect(0, 9280, '\p{Is_Blk= Control_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Blk= Control_Pictures}', "");
    Expect(1, 9280, '\P{Is_Blk= Control_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Blk= Control_Pictures}', "");
    Error('\p{Block=_/a/coptic}');
    Error('\P{Block=_/a/coptic}');
    Expect(1, 11519, '\p{Block=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=coptic}', "");
    Expect(0, 11519, '\p{^Block=coptic}', "");
    Expect(0, 11519, '\P{Block=coptic}', "");
    Expect(1, 11519, '\P{^Block=coptic}', "");
    Expect(0, 11520, '\p{Block=coptic}', "");
    Expect(1, 11520, '\p{^Block=coptic}', "");
    Expect(1, 11520, '\P{Block=coptic}', "");
    Expect(0, 11520, '\P{^Block=coptic}', "");
    Expect(1, 11519, '\p{Block=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=-Coptic}', "");
    Expect(0, 11519, '\p{^Block=-Coptic}', "");
    Expect(0, 11519, '\P{Block=-Coptic}', "");
    Expect(1, 11519, '\P{^Block=-Coptic}', "");
    Expect(0, 11520, '\p{Block=-Coptic}', "");
    Expect(1, 11520, '\p{^Block=-Coptic}', "");
    Expect(1, 11520, '\P{Block=-Coptic}', "");
    Expect(0, 11520, '\P{^Block=-Coptic}', "");
    Error('\p{Blk=:=	Coptic}');
    Error('\P{Blk=:=	Coptic}');
    Expect(1, 11519, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=coptic}', "");
    Expect(0, 11519, '\p{^Blk=coptic}', "");
    Expect(0, 11519, '\P{Blk=coptic}', "");
    Expect(1, 11519, '\P{^Blk=coptic}', "");
    Expect(0, 11520, '\p{Blk=coptic}', "");
    Expect(1, 11520, '\p{^Blk=coptic}', "");
    Expect(1, 11520, '\P{Blk=coptic}', "");
    Expect(0, 11520, '\P{^Blk=coptic}', "");
    Expect(1, 11519, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=	 Coptic}', "");
    Expect(0, 11519, '\p{^Blk=	 Coptic}', "");
    Expect(0, 11519, '\P{Blk=	 Coptic}', "");
    Expect(1, 11519, '\P{^Blk=	 Coptic}', "");
    Expect(0, 11520, '\p{Blk=	 Coptic}', "");
    Expect(1, 11520, '\p{^Blk=	 Coptic}', "");
    Expect(1, 11520, '\P{Blk=	 Coptic}', "");
    Expect(0, 11520, '\P{^Blk=	 Coptic}', "");
    Error('\p{Is_Block=:=  Coptic}');
    Error('\P{Is_Block=:=  Coptic}');
    Expect(1, 11519, '\p{Is_Block=coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=coptic}', "");
    Expect(0, 11519, '\P{Is_Block=coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=coptic}', "");
    Expect(0, 11520, '\p{Is_Block=coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=coptic}', "");
    Expect(1, 11520, '\P{Is_Block=coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=coptic}', "");
    Expect(1, 11519, '\p{Is_Block= _Coptic}', "");
    Expect(0, 11519, '\p{^Is_Block= _Coptic}', "");
    Expect(0, 11519, '\P{Is_Block= _Coptic}', "");
    Expect(1, 11519, '\P{^Is_Block= _Coptic}', "");
    Expect(0, 11520, '\p{Is_Block= _Coptic}', "");
    Expect(1, 11520, '\p{^Is_Block= _Coptic}', "");
    Expect(1, 11520, '\P{Is_Block= _Coptic}', "");
    Expect(0, 11520, '\P{^Is_Block= _Coptic}', "");
    Error('\p{Is_Blk=/a/coptic}');
    Error('\P{Is_Blk=/a/coptic}');
    Expect(1, 11519, '\p{Is_Blk=coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
    Expect(1, 11519, '\p{Is_Blk=_Coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=_Coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=_Coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=_Coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=_Coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=_Coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=_Coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=_Coptic}', "");
    Error('\p{Block=:=-	COPTIC_Epact_NUMBERS}');
    Error('\P{Block=:=-	COPTIC_Epact_NUMBERS}');
    Expect(1, 66303, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Block=__Coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Block=__Coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Block=__Coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Block=__Coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Block=__Coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Block=__Coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Block=__Coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Block=__Coptic_Epact_Numbers}', "");
    Error('\p{Blk=-/a/Coptic_Epact_NUMBERS}');
    Error('\P{Blk=-/a/Coptic_Epact_NUMBERS}');
    Expect(1, 66303, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=--COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Blk=--COPTIC_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Blk=--COPTIC_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Blk=--COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Blk=--COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Blk=--COPTIC_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Blk=--COPTIC_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Blk=--COPTIC_Epact_Numbers}', "");
    Error('\p{Is_Block=_-coptic_Epact_Numbers:=}');
    Error('\P{Is_Block=_-coptic_Epact_Numbers:=}');
    Expect(1, 66303, '\p{Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\p{^Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\P{Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(1, 66303, '\P{^Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\p{Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\p{^Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\P{Is_Block=- Coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\P{^Is_Block=- Coptic_Epact_NUMBERS}', "");
    Error('\p{Is_Blk=/a/	coptic_Epact_Numbers}');
    Error('\P{Is_Blk=/a/	coptic_Epact_Numbers}');
    Expect(1, 66303, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(0, 66303, '\P{Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(0, 66304, '\p{Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(1, 66304, '\P{Is_Blk=	COPTIC_EPACT_numbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=	COPTIC_EPACT_numbers}', "");
    Error('\p{Block=:=counting_Rod_NUMERALS}');
    Error('\P{Block=:=counting_Rod_NUMERALS}');
    Expect(1, 119679, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(1, 119679, '\p{Block=--Counting_ROD_numerals}', "");
    Expect(0, 119679, '\p{^Block=--Counting_ROD_numerals}', "");
    Expect(0, 119679, '\P{Block=--Counting_ROD_numerals}', "");
    Expect(1, 119679, '\P{^Block=--Counting_ROD_numerals}', "");
    Expect(0, 119680, '\p{Block=--Counting_ROD_numerals}', "");
    Expect(1, 119680, '\p{^Block=--Counting_ROD_numerals}', "");
    Expect(1, 119680, '\P{Block=--Counting_ROD_numerals}', "");
    Expect(0, 119680, '\P{^Block=--Counting_ROD_numerals}', "");
    Error('\p{Blk= /a/counting_rod}');
    Error('\P{Blk= /a/counting_rod}');
    Expect(1, 119679, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(1, 119679, '\p{Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Blk=countingrod}', "");
    Expect(0, 119679, '\P{Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Blk=countingrod}', "");
    Expect(0, 119680, '\p{Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Blk=countingrod}', "");
    Expect(1, 119680, '\P{Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Blk=countingrod}', "");
    Expect(1, 119679, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(1, 119679, '\p{Blk=	Counting_Rod}', "");
    Expect(0, 119679, '\p{^Blk=	Counting_Rod}', "");
    Expect(0, 119679, '\P{Blk=	Counting_Rod}', "");
    Expect(1, 119679, '\P{^Blk=	Counting_Rod}', "");
    Expect(0, 119680, '\p{Blk=	Counting_Rod}', "");
    Expect(1, 119680, '\p{^Blk=	Counting_Rod}', "");
    Expect(1, 119680, '\P{Blk=	Counting_Rod}', "");
    Expect(0, 119680, '\P{^Blk=	Counting_Rod}', "");
    Error('\p{Is_Block=--counting_ROD_Numerals:=}');
    Error('\P{Is_Block=--counting_ROD_Numerals:=}');
    Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(0, 119679, '\p{^Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(0, 119679, '\P{Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(1, 119679, '\P{^Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(0, 119680, '\p{Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(1, 119680, '\p{^Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(1, 119680, '\P{Is_Block=	_COUNTING_rod_Numerals}', "");
    Expect(0, 119680, '\P{^Is_Block=	_COUNTING_rod_Numerals}', "");
    Error('\p{Is_Blk=_/a/counting_Rod}');
    Error('\P{Is_Blk=_/a/counting_Rod}');
    Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
    Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
    Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
    Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
    Expect(1, 119679, '\p{Is_Blk=	COUNTING_Rod}', "");
    Expect(0, 119679, '\p{^Is_Blk=	COUNTING_Rod}', "");
    Expect(0, 119679, '\P{Is_Blk=	COUNTING_Rod}', "");
    Expect(1, 119679, '\P{^Is_Blk=	COUNTING_Rod}', "");
    Expect(0, 119680, '\p{Is_Blk=	COUNTING_Rod}', "");
    Expect(1, 119680, '\p{^Is_Blk=	COUNTING_Rod}', "");
    Expect(1, 119680, '\P{Is_Blk=	COUNTING_Rod}', "");
    Expect(0, 119680, '\P{^Is_Blk=	COUNTING_Rod}', "");
    Error('\p{Block: :=		CUNEIFORM}');
    Error('\P{Block: :=		CUNEIFORM}');
    Expect(1, 74751, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Block=cuneiform}', "");
    Expect(0, 74751, '\P{Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Block=cuneiform}', "");
    Expect(0, 74752, '\p{Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Block=cuneiform}', "");
    Expect(1, 74752, '\P{Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Block=cuneiform}', "");
    Expect(1, 74751, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block= Cuneiform}', "");
    Expect(0, 74751, '\p{^Block= Cuneiform}', "");
    Expect(0, 74751, '\P{Block= Cuneiform}', "");
    Expect(1, 74751, '\P{^Block= Cuneiform}', "");
    Expect(0, 74752, '\p{Block= Cuneiform}', "");
    Expect(1, 74752, '\p{^Block= Cuneiform}', "");
    Expect(1, 74752, '\P{Block= Cuneiform}', "");
    Expect(0, 74752, '\P{^Block= Cuneiform}', "");
    Error('\p{Blk:   /a/Cuneiform}');
    Error('\P{Blk:   /a/Cuneiform}');
    Expect(1, 74751, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk: cuneiform}', "");
    Expect(0, 74751, '\p{^Blk: cuneiform}', "");
    Expect(0, 74751, '\P{Blk: cuneiform}', "");
    Expect(1, 74751, '\P{^Blk: cuneiform}', "");
    Expect(0, 74752, '\p{Blk: cuneiform}', "");
    Expect(1, 74752, '\p{^Blk: cuneiform}', "");
    Expect(1, 74752, '\P{Blk: cuneiform}', "");
    Expect(0, 74752, '\P{^Blk: cuneiform}', "");
    Expect(1, 74751, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=  Cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=  Cuneiform}', "");
    Expect(0, 74751, '\P{Blk=  Cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=  Cuneiform}', "");
    Expect(0, 74752, '\p{Blk=  Cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=  Cuneiform}', "");
    Expect(1, 74752, '\P{Blk=  Cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=  Cuneiform}', "");
    Error('\p{Is_Block: := CUNEIFORM}');
    Error('\P{Is_Block: := CUNEIFORM}');
    Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Block= 	Cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block= 	Cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block= 	Cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block= 	Cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block= 	Cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block= 	Cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block= 	Cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block= 	Cuneiform}', "");
    Error('\p{Is_Blk=/a/-	Cuneiform}');
    Error('\P{Is_Blk=/a/-	Cuneiform}');
    Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Blk:   _cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk:   _cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk:   _cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk:   _cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk:   _cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk:   _cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk:   _cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk:   _cuneiform}', "");
    Error('\p{Block=:=--Cuneiform_Numbers_And_Punctuation}');
    Error('\P{Block=:=--Cuneiform_Numbers_And_Punctuation}');
    Expect(1, 74879, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(0, 74879, '\p{^Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(0, 74879, '\P{Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(1, 74879, '\P{^Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(0, 74880, '\p{Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(1, 74880, '\p{^Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(1, 74880, '\P{Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Expect(0, 74880, '\P{^Block=-CUNEIFORM_Numbers_and_Punctuation}', "");
    Error('\p{Blk=_:=Cuneiform_NUMBERS}');
    Error('\P{Blk=_:=Cuneiform_NUMBERS}');
    Expect(1, 74879, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=-CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\p{^Blk=-CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\P{Blk=-CUNEIFORM_Numbers}', "");
    Expect(1, 74879, '\P{^Blk=-CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\p{Blk=-CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\p{^Blk=-CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\P{Blk=-CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\P{^Blk=-CUNEIFORM_Numbers}', "");
    Error('\p{Is_Block:	/a/		CUNEIFORM_Numbers_AND_Punctuation}');
    Error('\P{Is_Block:	/a/		CUNEIFORM_Numbers_AND_Punctuation}');
    Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(0, 74879, '\P{Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(0, 74880, '\p{Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(1, 74880, '\P{Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=_-Cuneiform_NUMBERS_and_punctuation}', "");
    Error('\p{Is_Blk=/a/-CUNEIFORM_NUMBERS}');
    Error('\P{Is_Blk=/a/-CUNEIFORM_NUMBERS}');
    Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\P{Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\p{Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\P{Is_Blk=_CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=_CUNEIFORM_Numbers}', "");
    Error('\p{Block=:=_-CURRENCY_SYMBOLS}');
    Error('\P{Block=:=_-CURRENCY_SYMBOLS}');
    Expect(1, 8399, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Block:currencysymbols}', "");
    Expect(0, 8399, '\p{^Block:currencysymbols}', "");
    Expect(0, 8399, '\P{Block:currencysymbols}', "");
    Expect(1, 8399, '\P{^Block:currencysymbols}', "");
    Expect(0, 8400, '\p{Block:currencysymbols}', "");
    Expect(1, 8400, '\p{^Block:currencysymbols}', "");
    Expect(1, 8400, '\P{Block:currencysymbols}', "");
    Expect(0, 8400, '\P{^Block:currencysymbols}', "");
    Expect(1, 8399, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Block=--currency_SYMBOLS}', "");
    Expect(0, 8399, '\p{^Block=--currency_SYMBOLS}', "");
    Expect(0, 8399, '\P{Block=--currency_SYMBOLS}', "");
    Expect(1, 8399, '\P{^Block=--currency_SYMBOLS}', "");
    Expect(0, 8400, '\p{Block=--currency_SYMBOLS}', "");
    Expect(1, 8400, '\p{^Block=--currency_SYMBOLS}', "");
    Expect(1, 8400, '\P{Block=--currency_SYMBOLS}', "");
    Expect(0, 8400, '\P{^Block=--currency_SYMBOLS}', "");
    Error('\p{Blk=	:=CURRENCY_Symbols}');
    Error('\P{Blk=	:=CURRENCY_Symbols}');
    Expect(1, 8399, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=		CURRENCY_symbols}', "");
    Expect(0, 8399, '\p{^Blk=		CURRENCY_symbols}', "");
    Expect(0, 8399, '\P{Blk=		CURRENCY_symbols}', "");
    Expect(1, 8399, '\P{^Blk=		CURRENCY_symbols}', "");
    Expect(0, 8400, '\p{Blk=		CURRENCY_symbols}', "");
    Expect(1, 8400, '\p{^Blk=		CURRENCY_symbols}', "");
    Expect(1, 8400, '\P{Blk=		CURRENCY_symbols}', "");
    Expect(0, 8400, '\P{^Blk=		CURRENCY_symbols}', "");
    Error('\p{Is_Block=	 CURRENCY_Symbols:=}');
    Error('\P{Is_Block=	 CURRENCY_Symbols:=}');
    Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Block= currency_symbols}', "");
    Expect(0, 8399, '\p{^Is_Block= currency_symbols}', "");
    Expect(0, 8399, '\P{Is_Block= currency_symbols}', "");
    Expect(1, 8399, '\P{^Is_Block= currency_symbols}', "");
    Expect(0, 8400, '\p{Is_Block= currency_symbols}', "");
    Expect(1, 8400, '\p{^Is_Block= currency_symbols}', "");
    Expect(1, 8400, '\P{Is_Block= currency_symbols}', "");
    Expect(0, 8400, '\P{^Is_Block= currency_symbols}', "");
    Error('\p{Is_Blk=:=--currency_symbols}');
    Error('\P{Is_Blk=:=--currency_symbols}');
    Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(0, 8399, '\p{^Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(0, 8399, '\P{Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(1, 8399, '\P{^Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(0, 8400, '\p{Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(1, 8400, '\p{^Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(1, 8400, '\P{Is_Blk=	_Currency_SYMBOLS}', "");
    Expect(0, 8400, '\P{^Is_Blk=	_Currency_SYMBOLS}', "");
    Error('\p{Block=_	Cypriot_Syllabary/a/}');
    Error('\P{Block=_	Cypriot_Syllabary/a/}');
    Expect(1, 67647, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=--CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\p{^Block=--CYPRIOT_syllabary}', "");
    Expect(0, 67647, '\P{Block=--CYPRIOT_syllabary}', "");
    Expect(1, 67647, '\P{^Block=--CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\p{Block=--CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\p{^Block=--CYPRIOT_syllabary}', "");
    Expect(1, 67648, '\P{Block=--CYPRIOT_syllabary}', "");
    Expect(0, 67648, '\P{^Block=--CYPRIOT_syllabary}', "");
    Error('\p{Blk=	_Cypriot_SYLLABARY/a/}');
    Error('\P{Blk=	_Cypriot_SYLLABARY/a/}');
    Expect(1, 67647, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk:	- CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\p{^Blk:	- CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\P{Blk:	- CYPRIOT_Syllabary}', "");
    Expect(1, 67647, '\P{^Blk:	- CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\p{Blk:	- CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\p{^Blk:	- CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\P{Blk:	- CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\P{^Blk:	- CYPRIOT_Syllabary}', "");
    Error('\p{Is_Block=-:=cypriot_syllabary}');
    Error('\P{Is_Block=-:=cypriot_syllabary}');
    Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\p{^Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\P{Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(1, 67647, '\P{^Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\p{Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\p{^Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\P{Is_Block=__CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\P{^Is_Block=__CYPRIOT_SYLLABARY}', "");
    Error('\p{Is_Blk=_/a/Cypriot_syllabary}');
    Error('\P{Is_Blk=_/a/Cypriot_syllabary}');
    Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\p{^Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\P{Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(1, 67647, '\P{^Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\p{Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\p{^Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\P{Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\P{^Is_Blk=	 CYPRIOT_SYLLABARY}', "");
    Error('\p{Block=_cyrillic:=}');
    Error('\P{Block=_cyrillic:=}');
    Expect(1, 1279, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Block=cyrillic}', "");
    Expect(0, 1279, '\P{Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Block=cyrillic}', "");
    Expect(0, 1280, '\p{Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Block=cyrillic}', "");
    Expect(1, 1280, '\P{Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Block=cyrillic}', "");
    Expect(1, 1279, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=_CYRILLIC}', "");
    Expect(0, 1279, '\p{^Block=_CYRILLIC}', "");
    Expect(0, 1279, '\P{Block=_CYRILLIC}', "");
    Expect(1, 1279, '\P{^Block=_CYRILLIC}', "");
    Expect(0, 1280, '\p{Block=_CYRILLIC}', "");
    Expect(1, 1280, '\p{^Block=_CYRILLIC}', "");
    Expect(1, 1280, '\P{Block=_CYRILLIC}', "");
    Expect(0, 1280, '\P{^Block=_CYRILLIC}', "");
    Error('\p{Blk=:= Cyrillic}');
    Error('\P{Blk=:= Cyrillic}');
    Expect(1, 1279, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk:   cyrillic}', "");
    Expect(0, 1279, '\p{^Blk:   cyrillic}', "");
    Expect(0, 1279, '\P{Blk:   cyrillic}', "");
    Expect(1, 1279, '\P{^Blk:   cyrillic}', "");
    Expect(0, 1280, '\p{Blk:   cyrillic}', "");
    Expect(1, 1280, '\p{^Blk:   cyrillic}', "");
    Expect(1, 1280, '\P{Blk:   cyrillic}', "");
    Expect(0, 1280, '\P{^Blk:   cyrillic}', "");
    Expect(1, 1279, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk=--cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=--cyrillic}', "");
    Expect(0, 1279, '\P{Blk=--cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=--cyrillic}', "");
    Expect(0, 1280, '\p{Blk=--cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=--cyrillic}', "");
    Expect(1, 1280, '\P{Blk=--cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=--cyrillic}', "");
    Error('\p{Is_Block=-	Cyrillic/a/}');
    Error('\P{Is_Block=-	Cyrillic/a/}');
    Expect(1, 1279, '\p{Is_Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Block=	_Cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=	_Cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=	_Cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=	_Cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=	_Cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=	_Cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=	_Cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=	_Cyrillic}', "");
    Error('\p{Is_Blk=:= _CYRILLIC}');
    Error('\P{Is_Blk=:= _CYRILLIC}');
    Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Blk:    	CYRILLIC}', "");
    Expect(0, 1279, '\p{^Is_Blk:    	CYRILLIC}', "");
    Expect(0, 1279, '\P{Is_Blk:    	CYRILLIC}', "");
    Expect(1, 1279, '\P{^Is_Blk:    	CYRILLIC}', "");
    Expect(0, 1280, '\p{Is_Blk:    	CYRILLIC}', "");
    Expect(1, 1280, '\p{^Is_Blk:    	CYRILLIC}', "");
    Expect(1, 1280, '\P{Is_Blk:    	CYRILLIC}', "");
    Expect(0, 1280, '\P{^Is_Blk:    	CYRILLIC}', "");
    Error('\p{Block:   :=		Cyrillic_EXTENDED_A}');
    Error('\P{Block:   :=		Cyrillic_EXTENDED_A}');
    Expect(1, 11775, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(0, 11776, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(0, 11776, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(1, 11775, '\p{Block=_cyrillic_EXTENDED_A}', "");
    Expect(0, 11775, '\p{^Block=_cyrillic_EXTENDED_A}', "");
    Expect(0, 11775, '\P{Block=_cyrillic_EXTENDED_A}', "");
    Expect(1, 11775, '\P{^Block=_cyrillic_EXTENDED_A}', "");
    Expect(0, 11776, '\p{Block=_cyrillic_EXTENDED_A}', "");
    Expect(1, 11776, '\p{^Block=_cyrillic_EXTENDED_A}', "");
    Expect(1, 11776, '\P{Block=_cyrillic_EXTENDED_A}', "");
    Expect(0, 11776, '\P{^Block=_cyrillic_EXTENDED_A}', "");
    Error('\p{Blk=_Cyrillic_Ext_A/a/}');
    Error('\P{Blk=_Cyrillic_Ext_A/a/}');
    Expect(1, 11775, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(1, 11775, '\p{Blk= 	cyrillic_EXT_a}', "");
    Expect(0, 11775, '\p{^Blk= 	cyrillic_EXT_a}', "");
    Expect(0, 11775, '\P{Blk= 	cyrillic_EXT_a}', "");
    Expect(1, 11775, '\P{^Blk= 	cyrillic_EXT_a}', "");
    Expect(0, 11776, '\p{Blk= 	cyrillic_EXT_a}', "");
    Expect(1, 11776, '\p{^Blk= 	cyrillic_EXT_a}', "");
    Expect(1, 11776, '\P{Blk= 	cyrillic_EXT_a}', "");
    Expect(0, 11776, '\P{^Blk= 	cyrillic_EXT_a}', "");
    Error('\p{Is_Block=:=	 cyrillic_Extended_a}');
    Error('\P{Is_Block=:=	 cyrillic_Extended_a}');
    Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Is_Block= -cyrillic_Extended_A}', "");
    Expect(0, 11775, '\p{^Is_Block= -cyrillic_Extended_A}', "");
    Expect(0, 11775, '\P{Is_Block= -cyrillic_Extended_A}', "");
    Expect(1, 11775, '\P{^Is_Block= -cyrillic_Extended_A}', "");
    Expect(0, 11776, '\p{Is_Block= -cyrillic_Extended_A}', "");
    Expect(1, 11776, '\p{^Is_Block= -cyrillic_Extended_A}', "");
    Expect(1, 11776, '\P{Is_Block= -cyrillic_Extended_A}', "");
    Expect(0, 11776, '\P{^Is_Block= -cyrillic_Extended_A}', "");
    Error('\p{Is_Blk= CYRILLIC_Ext_A:=}');
    Error('\P{Is_Blk= CYRILLIC_Ext_A:=}');
    Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\p{^Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\P{Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(1, 11775, '\P{^Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\p{Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\p{^Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\P{Is_Blk=_Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\P{^Is_Blk=_Cyrillic_Ext_A}', "");
    Error('\p{Block=/a/	 CYRILLIC_Extended_B}');
    Error('\P{Block=/a/	 CYRILLIC_Extended_B}');
    Expect(1, 42655, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(0, 42656, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(1, 42655, '\p{Block: cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Block: cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Block: cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Block: cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Block: cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Block: cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Block: cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Block: cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(0, 42656, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(1, 42655, '\p{Block= cyrillic_Extended_B}', "");
    Expect(0, 42655, '\p{^Block= cyrillic_Extended_B}', "");
    Expect(0, 42655, '\P{Block= cyrillic_Extended_B}', "");
    Expect(1, 42655, '\P{^Block= cyrillic_Extended_B}', "");
    Expect(0, 42656, '\p{Block= cyrillic_Extended_B}', "");
    Expect(1, 42656, '\p{^Block= cyrillic_Extended_B}', "");
    Expect(1, 42656, '\P{Block= cyrillic_Extended_B}', "");
    Expect(0, 42656, '\P{^Block= cyrillic_Extended_B}', "");
    Error('\p{Blk=:=Cyrillic_EXT_B}');
    Error('\P{Blk=:=Cyrillic_EXT_B}');
    Expect(1, 42655, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(1, 42655, '\p{Blk=	-CYRILLIC_ext_b}', "");
    Expect(0, 42655, '\p{^Blk=	-CYRILLIC_ext_b}', "");
    Expect(0, 42655, '\P{Blk=	-CYRILLIC_ext_b}', "");
    Expect(1, 42655, '\P{^Blk=	-CYRILLIC_ext_b}', "");
    Expect(0, 42656, '\p{Blk=	-CYRILLIC_ext_b}', "");
    Expect(1, 42656, '\p{^Blk=	-CYRILLIC_ext_b}', "");
    Expect(1, 42656, '\P{Blk=	-CYRILLIC_ext_b}', "");
    Expect(0, 42656, '\P{^Blk=	-CYRILLIC_ext_b}', "");
    Error('\p{Is_Block=_/a/cyrillic_Extended_B}');
    Error('\P{Is_Block=_/a/cyrillic_Extended_B}');
    Expect(1, 42655, '\p{Is_Block:	cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Is_Block:	cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Is_Block:	cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Is_Block:	cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Is_Block:	cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Is_Block:	cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Is_Block:	cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Is_Block:	cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(0, 42655, '\p{^Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(0, 42655, '\P{Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(1, 42655, '\P{^Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(0, 42656, '\p{Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(1, 42656, '\p{^Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(1, 42656, '\P{Is_Block=-	Cyrillic_Extended_b}', "");
    Expect(0, 42656, '\P{^Is_Block=-	Cyrillic_Extended_b}', "");
    Error('\p{Is_Blk=	_Cyrillic_EXT_B:=}');
    Error('\P{Is_Blk=	_Cyrillic_EXT_B:=}');
    Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Is_Blk= Cyrillic_Ext_B}', "");
    Expect(0, 42655, '\p{^Is_Blk= Cyrillic_Ext_B}', "");
    Expect(0, 42655, '\P{Is_Blk= Cyrillic_Ext_B}', "");
    Expect(1, 42655, '\P{^Is_Blk= Cyrillic_Ext_B}', "");
    Expect(0, 42656, '\p{Is_Blk= Cyrillic_Ext_B}', "");
    Expect(1, 42656, '\p{^Is_Blk= Cyrillic_Ext_B}', "");
    Expect(1, 42656, '\P{Is_Blk= Cyrillic_Ext_B}', "");
    Expect(0, 42656, '\P{^Is_Blk= Cyrillic_Ext_B}', "");
    Error('\p{Block=:=cyrillic_Extended_C}');
    Error('\P{Block=:=cyrillic_Extended_C}');
    Expect(1, 7311, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(0, 7312, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(1, 7311, '\p{Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(0, 7312, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(1, 7311, '\p{Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(0, 7311, '\p{^Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(0, 7311, '\P{Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(1, 7311, '\P{^Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(0, 7312, '\p{Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(1, 7312, '\p{^Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(1, 7312, '\P{Block=	_CYRILLIC_EXTENDED_c}', "");
    Expect(0, 7312, '\P{^Block=	_CYRILLIC_EXTENDED_c}', "");
    Error('\p{Blk=:= -Cyrillic_Ext_C}');
    Error('\P{Blk=:= -Cyrillic_Ext_C}');
    Expect(1, 7311, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(1, 7311, '\p{Blk:   cyrillicextc}', "");
    Expect(0, 7311, '\p{^Blk:   cyrillicextc}', "");
    Expect(0, 7311, '\P{Blk:   cyrillicextc}', "");
    Expect(1, 7311, '\P{^Blk:   cyrillicextc}', "");
    Expect(0, 7312, '\p{Blk:   cyrillicextc}', "");
    Expect(1, 7312, '\p{^Blk:   cyrillicextc}', "");
    Expect(1, 7312, '\P{Blk:   cyrillicextc}', "");
    Expect(0, 7312, '\P{^Blk:   cyrillicextc}', "");
    Expect(1, 7311, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(1, 7311, '\p{Blk=		Cyrillic_EXT_c}', "");
    Expect(0, 7311, '\p{^Blk=		Cyrillic_EXT_c}', "");
    Expect(0, 7311, '\P{Blk=		Cyrillic_EXT_c}', "");
    Expect(1, 7311, '\P{^Blk=		Cyrillic_EXT_c}', "");
    Expect(0, 7312, '\p{Blk=		Cyrillic_EXT_c}', "");
    Expect(1, 7312, '\p{^Blk=		Cyrillic_EXT_c}', "");
    Expect(1, 7312, '\P{Blk=		Cyrillic_EXT_c}', "");
    Expect(0, 7312, '\P{^Blk=		Cyrillic_EXT_c}', "");
    Error('\p{Is_Block=-:=Cyrillic_Extended_C}');
    Error('\P{Is_Block=-:=Cyrillic_Extended_C}');
    Expect(1, 7311, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Is_Block=- Cyrillic_Extended_c}', "");
    Expect(0, 7311, '\p{^Is_Block=- Cyrillic_Extended_c}', "");
    Expect(0, 7311, '\P{Is_Block=- Cyrillic_Extended_c}', "");
    Expect(1, 7311, '\P{^Is_Block=- Cyrillic_Extended_c}', "");
    Expect(0, 7312, '\p{Is_Block=- Cyrillic_Extended_c}', "");
    Expect(1, 7312, '\p{^Is_Block=- Cyrillic_Extended_c}', "");
    Expect(1, 7312, '\P{Is_Block=- Cyrillic_Extended_c}', "");
    Expect(0, 7312, '\P{^Is_Block=- Cyrillic_Extended_c}', "");
    Error('\p{Is_Blk=/a/ -CYRILLIC_Ext_C}');
    Error('\P{Is_Blk=/a/ -CYRILLIC_Ext_C}');
    Expect(1, 7311, '\p{Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Is_Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Is_Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\p{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7311, '\P{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7311, '\P{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\p{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\p{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(1, 7312, '\P{Is_Blk=_-CYRILLIC_Ext_C}', "");
    Expect(0, 7312, '\P{^Is_Blk=_-CYRILLIC_Ext_C}', "");
    Error('\p{Block=:=	Cyrillic_supplement}');
    Error('\P{Block=:=	Cyrillic_supplement}');
    Expect(1, 1327, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(1, 1327, '\p{Block: - CYRILLIC_Supplement}', "");
    Expect(0, 1327, '\p{^Block: - CYRILLIC_Supplement}', "");
    Expect(0, 1327, '\P{Block: - CYRILLIC_Supplement}', "");
    Expect(1, 1327, '\P{^Block: - CYRILLIC_Supplement}', "");
    Expect(0, 1328, '\p{Block: - CYRILLIC_Supplement}', "");
    Expect(1, 1328, '\p{^Block: - CYRILLIC_Supplement}', "");
    Expect(1, 1328, '\P{Block: - CYRILLIC_Supplement}', "");
    Expect(0, 1328, '\P{^Block: - CYRILLIC_Supplement}', "");
    Error('\p{Blk=/a/Cyrillic_sup}');
    Error('\P{Blk=/a/Cyrillic_sup}');
    Expect(1, 1327, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(1, 1327, '\p{Blk=cyrillicsup}', "");
    Expect(0, 1327, '\p{^Blk=cyrillicsup}', "");
    Expect(0, 1327, '\P{Blk=cyrillicsup}', "");
    Expect(1, 1327, '\P{^Blk=cyrillicsup}', "");
    Expect(0, 1328, '\p{Blk=cyrillicsup}', "");
    Expect(1, 1328, '\p{^Blk=cyrillicsup}', "");
    Expect(1, 1328, '\P{Blk=cyrillicsup}', "");
    Expect(0, 1328, '\P{^Blk=cyrillicsup}', "");
    Expect(1, 1327, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(1, 1327, '\p{Blk= _Cyrillic_Sup}', "");
    Expect(0, 1327, '\p{^Blk= _Cyrillic_Sup}', "");
    Expect(0, 1327, '\P{Blk= _Cyrillic_Sup}', "");
    Expect(1, 1327, '\P{^Blk= _Cyrillic_Sup}', "");
    Expect(0, 1328, '\p{Blk= _Cyrillic_Sup}', "");
    Expect(1, 1328, '\p{^Blk= _Cyrillic_Sup}', "");
    Expect(1, 1328, '\P{Blk= _Cyrillic_Sup}', "");
    Expect(0, 1328, '\P{^Blk= _Cyrillic_Sup}', "");
    Error('\p{Is_Block=	/a/cyrillic_Supplementary}');
    Error('\P{Is_Block=	/a/cyrillic_Supplementary}');
    Expect(1, 1327, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\p{Is_Block=__cyrillic_supplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=__cyrillic_supplementary}', "");
    Expect(0, 1327, '\P{Is_Block=__cyrillic_supplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=__cyrillic_supplementary}', "");
    Expect(0, 1328, '\p{Is_Block=__cyrillic_supplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=__cyrillic_supplementary}', "");
    Expect(1, 1328, '\P{Is_Block=__cyrillic_supplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=__cyrillic_supplementary}', "");
    Error('\p{Is_Blk=/a/CYRILLIC_SUPPLEMENT}');
    Error('\P{Is_Blk=/a/CYRILLIC_SUPPLEMENT}');
    Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(0, 1327, '\P{Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(0, 1328, '\p{Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(1, 1328, '\P{Is_Blk=-	Cyrillic_Supplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=-	Cyrillic_Supplement}', "");
    Error('\p{Block=-	Deseret/a/}');
    Error('\P{Block=-	Deseret/a/}');
    Expect(1, 66639, '\p{Block=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=deseret}', "");
    Expect(0, 66639, '\p{^Block=deseret}', "");
    Expect(0, 66639, '\P{Block=deseret}', "");
    Expect(1, 66639, '\P{^Block=deseret}', "");
    Expect(0, 66640, '\p{Block=deseret}', "");
    Expect(1, 66640, '\p{^Block=deseret}', "");
    Expect(1, 66640, '\P{Block=deseret}', "");
    Expect(0, 66640, '\P{^Block=deseret}', "");
    Expect(1, 66639, '\p{Block=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=	-deseret}', "");
    Expect(0, 66639, '\p{^Block=	-deseret}', "");
    Expect(0, 66639, '\P{Block=	-deseret}', "");
    Expect(1, 66639, '\P{^Block=	-deseret}', "");
    Expect(0, 66640, '\p{Block=	-deseret}', "");
    Expect(1, 66640, '\p{^Block=	-deseret}', "");
    Expect(1, 66640, '\P{Block=	-deseret}', "");
    Expect(0, 66640, '\P{^Block=	-deseret}', "");
    Error('\p{Blk=:=_ deseret}');
    Error('\P{Blk=:=_ deseret}');
    Expect(1, 66639, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=deseret}', "");
    Expect(0, 66639, '\p{^Blk=deseret}', "");
    Expect(0, 66639, '\P{Blk=deseret}', "");
    Expect(1, 66639, '\P{^Blk=deseret}', "");
    Expect(0, 66640, '\p{Blk=deseret}', "");
    Expect(1, 66640, '\p{^Blk=deseret}', "");
    Expect(1, 66640, '\P{Blk=deseret}', "");
    Expect(0, 66640, '\P{^Blk=deseret}', "");
    Expect(1, 66639, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk= Deseret}', "");
    Expect(0, 66639, '\p{^Blk= Deseret}', "");
    Expect(0, 66639, '\P{Blk= Deseret}', "");
    Expect(1, 66639, '\P{^Blk= Deseret}', "");
    Expect(0, 66640, '\p{Blk= Deseret}', "");
    Expect(1, 66640, '\p{^Blk= Deseret}', "");
    Expect(1, 66640, '\P{Blk= Deseret}', "");
    Expect(0, 66640, '\P{^Blk= Deseret}', "");
    Error('\p{Is_Block=	/a/deseret}');
    Error('\P{Is_Block=	/a/deseret}');
    Expect(1, 66639, '\p{Is_Block=deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=deseret}', "");
    Expect(0, 66639, '\P{Is_Block=deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=deseret}', "");
    Expect(0, 66640, '\p{Is_Block=deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=deseret}', "");
    Expect(1, 66640, '\P{Is_Block=deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=deseret}', "");
    Expect(1, 66639, '\p{Is_Block=	 deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=	 deseret}', "");
    Expect(0, 66639, '\P{Is_Block=	 deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=	 deseret}', "");
    Expect(0, 66640, '\p{Is_Block=	 deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=	 deseret}', "");
    Expect(1, 66640, '\P{Is_Block=	 deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=	 deseret}', "");
    Error('\p{Is_Blk=:=-	Deseret}');
    Error('\P{Is_Blk=:=-	Deseret}');
    Expect(1, 66639, '\p{Is_Blk: deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk: deseret}', "");
    Expect(0, 66639, '\P{Is_Blk: deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk: deseret}', "");
    Expect(0, 66640, '\p{Is_Blk: deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk: deseret}', "");
    Expect(1, 66640, '\P{Is_Blk: deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk: deseret}', "");
    Expect(1, 66639, '\p{Is_Blk=_	Deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=_	Deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=_	Deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=_	Deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=_	Deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=_	Deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=_	Deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=_	Deseret}', "");
    Error('\p{Block= /a/Devanagari}');
    Error('\P{Block= /a/Devanagari}');
    Expect(1, 2431, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block:	devanagari}', "");
    Expect(0, 2431, '\p{^Block:	devanagari}', "");
    Expect(0, 2431, '\P{Block:	devanagari}', "");
    Expect(1, 2431, '\P{^Block:	devanagari}', "");
    Expect(0, 2432, '\p{Block:	devanagari}', "");
    Expect(1, 2432, '\p{^Block:	devanagari}', "");
    Expect(1, 2432, '\P{Block:	devanagari}', "");
    Expect(0, 2432, '\P{^Block:	devanagari}', "");
    Expect(1, 2431, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block=__Devanagari}', "");
    Expect(0, 2431, '\p{^Block=__Devanagari}', "");
    Expect(0, 2431, '\P{Block=__Devanagari}', "");
    Expect(1, 2431, '\P{^Block=__Devanagari}', "");
    Expect(0, 2432, '\p{Block=__Devanagari}', "");
    Expect(1, 2432, '\p{^Block=__Devanagari}', "");
    Expect(1, 2432, '\P{Block=__Devanagari}', "");
    Expect(0, 2432, '\P{^Block=__Devanagari}', "");
    Error('\p{Blk=:=Devanagari}');
    Error('\P{Blk=:=Devanagari}');
    Expect(1, 2431, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Blk=devanagari}', "");
    Expect(0, 2431, '\P{Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Blk=devanagari}', "");
    Expect(0, 2432, '\p{Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Blk=devanagari}', "");
    Expect(1, 2432, '\P{Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Blk=devanagari}', "");
    Expect(1, 2431, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk= -Devanagari}', "");
    Expect(0, 2431, '\p{^Blk= -Devanagari}', "");
    Expect(0, 2431, '\P{Blk= -Devanagari}', "");
    Expect(1, 2431, '\P{^Blk= -Devanagari}', "");
    Expect(0, 2432, '\p{Blk= -Devanagari}', "");
    Expect(1, 2432, '\p{^Blk= -Devanagari}', "");
    Expect(1, 2432, '\P{Blk= -Devanagari}', "");
    Expect(0, 2432, '\P{^Blk= -Devanagari}', "");
    Error('\p{Is_Block=/a/ _Devanagari}');
    Error('\P{Is_Block=/a/ _Devanagari}');
    Expect(1, 2431, '\p{Is_Block=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
    Expect(1, 2431, '\p{Is_Block=-_Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=-_Devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=-_Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=-_Devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=-_Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=-_Devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=-_Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=-_Devanagari}', "");
    Error('\p{Is_Blk:   _Devanagari:=}');
    Error('\P{Is_Blk:   _Devanagari:=}');
    Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
    Expect(1, 2431, '\p{Is_Blk=  Devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=  Devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=  Devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=  Devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=  Devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=  Devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=  Devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=  Devanagari}', "");
    Error('\p{Block=:=_	devanagari_Extended}');
    Error('\P{Block=:=_	devanagari_Extended}');
    Expect(1, 43263, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(1, 43263, '\p{Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(1, 43263, '\p{Block=		devanagari_EXTENDED}', "");
    Expect(0, 43263, '\p{^Block=		devanagari_EXTENDED}', "");
    Expect(0, 43263, '\P{Block=		devanagari_EXTENDED}', "");
    Expect(1, 43263, '\P{^Block=		devanagari_EXTENDED}', "");
    Expect(0, 43264, '\p{Block=		devanagari_EXTENDED}', "");
    Expect(1, 43264, '\p{^Block=		devanagari_EXTENDED}', "");
    Expect(1, 43264, '\P{Block=		devanagari_EXTENDED}', "");
    Expect(0, 43264, '\P{^Block=		devanagari_EXTENDED}', "");
    Error('\p{Blk: -:=DEVANAGARI_Ext}');
    Error('\P{Blk: -:=DEVANAGARI_Ext}');
    Expect(1, 43263, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(1, 43263, '\p{Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(1, 43263, '\p{Blk=  Devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Blk=  Devanagari_Ext}', "");
    Expect(0, 43263, '\P{Blk=  Devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Blk=  Devanagari_Ext}', "");
    Expect(0, 43264, '\p{Blk=  Devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Blk=  Devanagari_Ext}', "");
    Expect(1, 43264, '\P{Blk=  Devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Blk=  Devanagari_Ext}', "");
    Error('\p{Is_Block:_/a/Devanagari_extended}');
    Error('\P{Is_Block:_/a/Devanagari_extended}');
    Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Is_Block=_ Devanagari_Extended}', "");
    Expect(0, 43263, '\p{^Is_Block=_ Devanagari_Extended}', "");
    Expect(0, 43263, '\P{Is_Block=_ Devanagari_Extended}', "");
    Expect(1, 43263, '\P{^Is_Block=_ Devanagari_Extended}', "");
    Expect(0, 43264, '\p{Is_Block=_ Devanagari_Extended}', "");
    Expect(1, 43264, '\p{^Is_Block=_ Devanagari_Extended}', "");
    Expect(1, 43264, '\P{Is_Block=_ Devanagari_Extended}', "");
    Expect(0, 43264, '\P{^Is_Block=_ Devanagari_Extended}', "");
    Error('\p{Is_Blk=-:=devanagari_Ext}');
    Error('\P{Is_Blk=-:=devanagari_Ext}');
    Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Is_Blk= 	Devanagari_Ext}', "");
    Expect(0, 43263, '\p{^Is_Blk= 	Devanagari_Ext}', "");
    Expect(0, 43263, '\P{Is_Blk= 	Devanagari_Ext}', "");
    Expect(1, 43263, '\P{^Is_Blk= 	Devanagari_Ext}', "");
    Expect(0, 43264, '\p{Is_Blk= 	Devanagari_Ext}', "");
    Expect(1, 43264, '\p{^Is_Blk= 	Devanagari_Ext}', "");
    Expect(1, 43264, '\P{Is_Blk= 	Devanagari_Ext}', "");
    Expect(0, 43264, '\P{^Is_Blk= 	Devanagari_Ext}', "");
    Error('\p{Block=combining_diacritical_MARKS/a/}');
    Error('\P{Block=combining_diacritical_MARKS/a/}');
    Expect(1, 879, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(0, 880, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(0, 880, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(1, 879, '\p{Block=	_COMBINING_diacritical_marks}', "");
    Expect(0, 879, '\p{^Block=	_COMBINING_diacritical_marks}', "");
    Expect(0, 879, '\P{Block=	_COMBINING_diacritical_marks}', "");
    Expect(1, 879, '\P{^Block=	_COMBINING_diacritical_marks}', "");
    Expect(0, 880, '\p{Block=	_COMBINING_diacritical_marks}', "");
    Expect(1, 880, '\p{^Block=	_COMBINING_diacritical_marks}', "");
    Expect(1, 880, '\P{Block=	_COMBINING_diacritical_marks}', "");
    Expect(0, 880, '\P{^Block=	_COMBINING_diacritical_marks}', "");
    Error('\p{Blk=	 Diacriticals/a/}');
    Error('\P{Blk=	 Diacriticals/a/}');
    Expect(1, 879, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk:	diacriticals}', "");
    Expect(0, 879, '\p{^Blk:	diacriticals}', "");
    Expect(0, 879, '\P{Blk:	diacriticals}', "");
    Expect(1, 879, '\P{^Blk:	diacriticals}', "");
    Expect(0, 880, '\p{Blk:	diacriticals}', "");
    Expect(1, 880, '\p{^Blk:	diacriticals}', "");
    Expect(1, 880, '\P{Blk:	diacriticals}', "");
    Expect(0, 880, '\P{^Blk:	diacriticals}', "");
    Expect(1, 879, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk=	-diacriticals}', "");
    Expect(0, 879, '\p{^Blk=	-diacriticals}', "");
    Expect(0, 879, '\P{Blk=	-diacriticals}', "");
    Expect(1, 879, '\P{^Blk=	-diacriticals}', "");
    Expect(0, 880, '\p{Blk=	-diacriticals}', "");
    Expect(1, 880, '\p{^Blk=	-diacriticals}', "");
    Expect(1, 880, '\P{Blk=	-diacriticals}', "");
    Expect(0, 880, '\P{^Blk=	-diacriticals}', "");
    Error('\p{Is_Block=- Combining_diacritical_Marks:=}');
    Error('\P{Is_Block=- Combining_diacritical_Marks:=}');
    Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\p{^Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(0, 879, '\P{Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(1, 879, '\P{^Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\p{Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\p{^Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(1, 880, '\P{Is_Block=	Combining_Diacritical_Marks}', "");
    Expect(0, 880, '\P{^Is_Block=	Combining_Diacritical_Marks}', "");
    Error('\p{Is_Blk=- DIACRITICALS:=}');
    Error('\P{Is_Blk=- DIACRITICALS:=}');
    Expect(1, 879, '\p{Is_Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=diacriticals}', "");
    Expect(1, 879, '\p{Is_Blk=Diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=Diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=Diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=Diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=Diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=Diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=Diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=Diacriticals}', "");
    Error('\p{Block=:= 	Combining_diacritical_Marks_EXTENDED}');
    Error('\P{Block=:= 	Combining_diacritical_Marks_EXTENDED}');
    Expect(1, 6911, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(1, 6911, '\p{Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(0, 6911, '\p{^Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(0, 6911, '\P{Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(1, 6911, '\P{^Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(0, 6912, '\p{Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(1, 6912, '\p{^Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(1, 6912, '\P{Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Expect(0, 6912, '\P{^Block= 	COMBINING_Diacritical_marks_Extended}', "");
    Error('\p{Blk=/a/_-DIACRITICALS_ext}');
    Error('\P{Blk=/a/_-DIACRITICALS_ext}');
    Expect(1, 6911, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(1, 6911, '\p{Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(1, 6911, '\p{Blk=  diacriticals_ext}', "");
    Expect(0, 6911, '\p{^Blk=  diacriticals_ext}', "");
    Expect(0, 6911, '\P{Blk=  diacriticals_ext}', "");
    Expect(1, 6911, '\P{^Blk=  diacriticals_ext}', "");
    Expect(0, 6912, '\p{Blk=  diacriticals_ext}', "");
    Expect(1, 6912, '\p{^Blk=  diacriticals_ext}', "");
    Expect(1, 6912, '\P{Blk=  diacriticals_ext}', "");
    Expect(0, 6912, '\P{^Blk=  diacriticals_ext}', "");
    Error('\p{Is_Block=:=	COMBINING_DIACRITICAL_Marks_EXTENDED}');
    Error('\P{Is_Block=:=	COMBINING_DIACRITICAL_Marks_EXTENDED}');
    Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(0, 6911, '\p{^Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(0, 6911, '\P{Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(1, 6911, '\P{^Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(0, 6912, '\p{Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(1, 6912, '\p{^Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(1, 6912, '\P{Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Expect(0, 6912, '\P{^Is_Block=-combining_Diacritical_Marks_Extended}', "");
    Error('\p{Is_Blk=:=-DIACRITICALS_ext}');
    Error('\P{Is_Blk=:=-DIACRITICALS_ext}');
    Expect(1, 6911, '\p{Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(0, 6911, '\p{^Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(0, 6911, '\P{Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(1, 6911, '\P{^Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(0, 6912, '\p{Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(1, 6912, '\p{^Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(1, 6912, '\P{Is_Blk:_ DIACRITICALS_EXT}', "");
    Expect(0, 6912, '\P{^Is_Blk:_ DIACRITICALS_EXT}', "");
    Error('\p{Block=	COMBINING_Diacritical_Marks_For_SYMBOLS/a/}');
    Error('\P{Block=	COMBINING_Diacritical_Marks_For_SYMBOLS/a/}');
    Expect(1, 8447, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Block:combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(0, 8447, '\p{^Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(0, 8447, '\P{Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(1, 8447, '\P{^Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(0, 8448, '\p{Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(1, 8448, '\p{^Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(1, 8448, '\P{Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Expect(0, 8448, '\P{^Block=  COMBINING_DIACRITICAL_MARKS_For_SYMBOLS}', "");
    Error('\p{Blk: -DIACRITICALS_FOR_Symbols:=}');
    Error('\P{Blk: -DIACRITICALS_FOR_Symbols:=}');
    Expect(1, 8447, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=__Diacriticals_for_Symbols}', "");
    Expect(0, 8447, '\p{^Blk=__Diacriticals_for_Symbols}', "");
    Expect(0, 8447, '\P{Blk=__Diacriticals_for_Symbols}', "");
    Expect(1, 8447, '\P{^Blk=__Diacriticals_for_Symbols}', "");
    Expect(0, 8448, '\p{Blk=__Diacriticals_for_Symbols}', "");
    Expect(1, 8448, '\p{^Blk=__Diacriticals_for_Symbols}', "");
    Expect(1, 8448, '\P{Blk=__Diacriticals_for_Symbols}', "");
    Expect(0, 8448, '\P{^Blk=__Diacriticals_for_Symbols}', "");
    Error('\p{Is_Block=:= combining_Marks_For_SYMBOLS}');
    Error('\P{Is_Block=:= combining_Marks_For_SYMBOLS}');
    Expect(1, 8447, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(0, 8447, '\p{^Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(0, 8447, '\P{Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(1, 8447, '\P{^Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(0, 8448, '\p{Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(1, 8448, '\p{^Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(1, 8448, '\P{Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Expect(0, 8448, '\P{^Is_Block=-	COMBINING_MARKS_For_symbols}', "");
    Error('\p{Is_Blk=:= _Combining_Diacritical_Marks_FOR_symbols}');
    Error('\P{Is_Blk=:= _Combining_Diacritical_Marks_FOR_symbols}');
    Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(0, 8447, '\P{Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(0, 8448, '\p{Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(1, 8448, '\P{Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=	 Combining_Diacritical_Marks_for_Symbols}', "");
    Error('\p{Block:		:=COMBINING_diacritical_marks_Supplement}');
    Error('\P{Block:		:=COMBINING_diacritical_marks_Supplement}');
    Expect(1, 7679, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(1, 7679, '\p{Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(0, 7679, '\p{^Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(0, 7679, '\P{Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(1, 7679, '\P{^Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(0, 7680, '\p{Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(1, 7680, '\p{^Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(1, 7680, '\P{Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Expect(0, 7680, '\P{^Block:   COMBINING_Diacritical_Marks_SUPPLEMENT}', "");
    Error('\p{Blk=_DIACRITICALS_Sup:=}');
    Error('\P{Blk=_DIACRITICALS_Sup:=}');
    Expect(1, 7679, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(1, 7679, '\p{Blk=	-Diacriticals_Sup}', "");
    Expect(0, 7679, '\p{^Blk=	-Diacriticals_Sup}', "");
    Expect(0, 7679, '\P{Blk=	-Diacriticals_Sup}', "");
    Expect(1, 7679, '\P{^Blk=	-Diacriticals_Sup}', "");
    Expect(0, 7680, '\p{Blk=	-Diacriticals_Sup}', "");
    Expect(1, 7680, '\p{^Blk=	-Diacriticals_Sup}', "");
    Expect(1, 7680, '\P{Blk=	-Diacriticals_Sup}', "");
    Expect(0, 7680, '\P{^Blk=	-Diacriticals_Sup}', "");
    Error('\p{Is_Block=-_COMBINING_diacritical_marks_Supplement:=}');
    Error('\P{Is_Block=-_COMBINING_diacritical_marks_Supplement:=}');
    Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\p{^Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\P{Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(1, 7679, '\P{^Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\p{Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\p{^Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\P{Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\P{^Is_Block=	Combining_diacritical_Marks_Supplement}', "");
    Error('\p{Is_Blk:   /a/diacriticals_sup}');
    Error('\P{Is_Blk:   /a/diacriticals_sup}');
    Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(0, 7679, '\p{^Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(0, 7679, '\P{Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(1, 7679, '\P{^Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(0, 7680, '\p{Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(1, 7680, '\p{^Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(1, 7680, '\P{Is_Blk=_ DIACRITICALS_sup}', "");
    Expect(0, 7680, '\P{^Is_Blk=_ DIACRITICALS_sup}', "");
    Error('\p{Block=--DINGBATS/a/}');
    Error('\P{Block=--DINGBATS/a/}');
    Expect(1, 10175, '\p{Block=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=dingbats}', "");
    Expect(0, 10175, '\p{^Block=dingbats}', "");
    Expect(0, 10175, '\P{Block=dingbats}', "");
    Expect(1, 10175, '\P{^Block=dingbats}', "");
    Expect(0, 10176, '\p{Block=dingbats}', "");
    Expect(1, 10176, '\p{^Block=dingbats}', "");
    Expect(1, 10176, '\P{Block=dingbats}', "");
    Expect(0, 10176, '\P{^Block=dingbats}', "");
    Expect(1, 10175, '\p{Block=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=	Dingbats}', "");
    Expect(0, 10175, '\p{^Block=	Dingbats}', "");
    Expect(0, 10175, '\P{Block=	Dingbats}', "");
    Expect(1, 10175, '\P{^Block=	Dingbats}', "");
    Expect(0, 10176, '\p{Block=	Dingbats}', "");
    Expect(1, 10176, '\p{^Block=	Dingbats}', "");
    Expect(1, 10176, '\P{Block=	Dingbats}', "");
    Expect(0, 10176, '\P{^Block=	Dingbats}', "");
    Error('\p{Blk= :=Dingbats}');
    Error('\P{Blk= :=Dingbats}');
    Expect(1, 10175, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Blk=dingbats}', "");
    Expect(0, 10175, '\P{Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Blk=dingbats}', "");
    Expect(0, 10176, '\p{Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Blk=dingbats}', "");
    Expect(1, 10176, '\P{Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Blk=dingbats}', "");
    Expect(1, 10175, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=- DINGBATS}', "");
    Expect(0, 10175, '\p{^Blk=- DINGBATS}', "");
    Expect(0, 10175, '\P{Blk=- DINGBATS}', "");
    Expect(1, 10175, '\P{^Blk=- DINGBATS}', "");
    Expect(0, 10176, '\p{Blk=- DINGBATS}', "");
    Expect(1, 10176, '\p{^Blk=- DINGBATS}', "");
    Expect(1, 10176, '\P{Blk=- DINGBATS}', "");
    Expect(0, 10176, '\P{^Blk=- DINGBATS}', "");
    Error('\p{Is_Block=	Dingbats:=}');
    Error('\P{Is_Block=	Dingbats:=}');
    Expect(1, 10175, '\p{Is_Block=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=dingbats}', "");
    Expect(1, 10175, '\p{Is_Block=-_Dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=-_Dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=-_Dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=-_Dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=-_Dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=-_Dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=-_Dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=-_Dingbats}', "");
    Error('\p{Is_Blk=/a/	dingbats}');
    Error('\P{Is_Blk=/a/	dingbats}');
    Expect(1, 10175, '\p{Is_Blk:dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk:dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk:dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk:dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk:dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk:dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk:dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk:dingbats}', "");
    Expect(1, 10175, '\p{Is_Blk=Dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=Dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=Dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=Dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=Dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=Dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=Dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=Dingbats}', "");
    Error('\p{Block=:= _Dives_Akuru}');
    Error('\P{Block=:= _Dives_Akuru}');
    Expect(1, 72031, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Block=divesakuru}', "");
    Expect(0, 72031, '\p{^Block=divesakuru}', "");
    Expect(0, 72031, '\P{Block=divesakuru}', "");
    Expect(1, 72031, '\P{^Block=divesakuru}', "");
    Expect(0, 72032, '\p{Block=divesakuru}', "");
    Expect(1, 72032, '\p{^Block=divesakuru}', "");
    Expect(1, 72032, '\P{Block=divesakuru}', "");
    Expect(0, 72032, '\P{^Block=divesakuru}', "");
    Expect(1, 72031, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Block=--dives_Akuru}', "");
    Expect(0, 72031, '\p{^Block=--dives_Akuru}', "");
    Expect(0, 72031, '\P{Block=--dives_Akuru}', "");
    Expect(1, 72031, '\P{^Block=--dives_Akuru}', "");
    Expect(0, 72032, '\p{Block=--dives_Akuru}', "");
    Expect(1, 72032, '\p{^Block=--dives_Akuru}', "");
    Expect(1, 72032, '\P{Block=--dives_Akuru}', "");
    Expect(0, 72032, '\P{^Block=--dives_Akuru}', "");
    Error('\p{Blk=/a/ -Dives_Akuru}');
    Error('\P{Blk=/a/ -Dives_Akuru}');
    Expect(1, 72031, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Blk=Dives_AKURU}', "");
    Expect(0, 72031, '\p{^Blk=Dives_AKURU}', "");
    Expect(0, 72031, '\P{Blk=Dives_AKURU}', "");
    Expect(1, 72031, '\P{^Blk=Dives_AKURU}', "");
    Expect(0, 72032, '\p{Blk=Dives_AKURU}', "");
    Expect(1, 72032, '\p{^Blk=Dives_AKURU}', "");
    Expect(1, 72032, '\P{Blk=Dives_AKURU}', "");
    Expect(0, 72032, '\P{^Blk=Dives_AKURU}', "");
    Error('\p{Is_Block=-DIVES_Akuru/a/}');
    Error('\P{Is_Block=-DIVES_Akuru/a/}');
    Expect(1, 72031, '\p{Is_Block=divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Block=divesakuru}', "");
    Expect(0, 72031, '\P{Is_Block=divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Block=divesakuru}', "");
    Expect(0, 72032, '\p{Is_Block=divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Block=divesakuru}', "");
    Expect(1, 72032, '\P{Is_Block=divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Block=divesakuru}', "");
    Expect(1, 72031, '\p{Is_Block= _Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Is_Block= _Dives_Akuru}', "");
    Expect(0, 72031, '\P{Is_Block= _Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Is_Block= _Dives_Akuru}', "");
    Expect(0, 72032, '\p{Is_Block= _Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Is_Block= _Dives_Akuru}', "");
    Expect(1, 72032, '\P{Is_Block= _Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Is_Block= _Dives_Akuru}', "");
    Error('\p{Is_Blk=:=	Dives_akuru}');
    Error('\P{Is_Blk=:=	Dives_akuru}');
    Expect(1, 72031, '\p{Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Is_Blk= _dives_AKURU}', "");
    Expect(0, 72031, '\p{^Is_Blk= _dives_AKURU}', "");
    Expect(0, 72031, '\P{Is_Blk= _dives_AKURU}', "");
    Expect(1, 72031, '\P{^Is_Blk= _dives_AKURU}', "");
    Expect(0, 72032, '\p{Is_Blk= _dives_AKURU}', "");
    Expect(1, 72032, '\p{^Is_Blk= _dives_AKURU}', "");
    Expect(1, 72032, '\P{Is_Blk= _dives_AKURU}', "");
    Expect(0, 72032, '\P{^Is_Blk= _dives_AKURU}', "");
    Error('\p{Block=:=_ dogra}');
    Error('\P{Block=:=_ dogra}');
    Expect(1, 71759, '\p{Block=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Block=dogra}', "");
    Expect(0, 71759, '\p{^Block=dogra}', "");
    Expect(0, 71759, '\P{Block=dogra}', "");
    Expect(1, 71759, '\P{^Block=dogra}', "");
    Expect(0, 71760, '\p{Block=dogra}', "");
    Expect(1, 71760, '\p{^Block=dogra}', "");
    Expect(1, 71760, '\P{Block=dogra}', "");
    Expect(0, 71760, '\P{^Block=dogra}', "");
    Expect(1, 71759, '\p{Block=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Block=- dogra}', "");
    Expect(0, 71759, '\p{^Block=- dogra}', "");
    Expect(0, 71759, '\P{Block=- dogra}', "");
    Expect(1, 71759, '\P{^Block=- dogra}', "");
    Expect(0, 71760, '\p{Block=- dogra}', "");
    Expect(1, 71760, '\p{^Block=- dogra}', "");
    Expect(1, 71760, '\P{Block=- dogra}', "");
    Expect(0, 71760, '\P{^Block=- dogra}', "");
    Error('\p{Blk=-:=Dogra}');
    Error('\P{Blk=-:=Dogra}');
    Expect(1, 71759, '\p{Blk=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=dogra}', "");
    Expect(0, 71759, '\p{^Blk=dogra}', "");
    Expect(0, 71759, '\P{Blk=dogra}', "");
    Expect(1, 71759, '\P{^Blk=dogra}', "");
    Expect(0, 71760, '\p{Blk=dogra}', "");
    Expect(1, 71760, '\p{^Blk=dogra}', "");
    Expect(1, 71760, '\P{Blk=dogra}', "");
    Expect(0, 71760, '\P{^Blk=dogra}', "");
    Expect(1, 71759, '\p{Blk=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=__Dogra}', "");
    Expect(0, 71759, '\p{^Blk=__Dogra}', "");
    Expect(0, 71759, '\P{Blk=__Dogra}', "");
    Expect(1, 71759, '\P{^Blk=__Dogra}', "");
    Expect(0, 71760, '\p{Blk=__Dogra}', "");
    Expect(1, 71760, '\p{^Blk=__Dogra}', "");
    Expect(1, 71760, '\P{Blk=__Dogra}', "");
    Expect(0, 71760, '\P{^Blk=__Dogra}', "");
    Error('\p{Is_Block=	/a/dogra}');
    Error('\P{Is_Block=	/a/dogra}');
    Expect(1, 71759, '\p{Is_Block:   dogra}', "");
    Expect(0, 71759, '\p{^Is_Block:   dogra}', "");
    Expect(0, 71759, '\P{Is_Block:   dogra}', "");
    Expect(1, 71759, '\P{^Is_Block:   dogra}', "");
    Expect(0, 71760, '\p{Is_Block:   dogra}', "");
    Expect(1, 71760, '\p{^Is_Block:   dogra}', "");
    Expect(1, 71760, '\P{Is_Block:   dogra}', "");
    Expect(0, 71760, '\P{^Is_Block:   dogra}', "");
    Expect(1, 71759, '\p{Is_Block=_	Dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=_	Dogra}', "");
    Expect(0, 71759, '\P{Is_Block=_	Dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=_	Dogra}', "");
    Expect(0, 71760, '\p{Is_Block=_	Dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=_	Dogra}', "");
    Expect(1, 71760, '\P{Is_Block=_	Dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=_	Dogra}', "");
    Error('\p{Is_Blk=/a/-_Dogra}');
    Error('\P{Is_Blk=/a/-_Dogra}');
    Expect(1, 71759, '\p{Is_Blk: dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk: dogra}', "");
    Expect(0, 71759, '\P{Is_Blk: dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk: dogra}', "");
    Expect(0, 71760, '\p{Is_Blk: dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk: dogra}', "");
    Expect(1, 71760, '\P{Is_Blk: dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk: dogra}', "");
    Expect(1, 71759, '\p{Is_Blk=_Dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=_Dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=_Dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=_Dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=_Dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=_Dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=_Dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=_Dogra}', "");
    Error('\p{Block= :=Domino_Tiles}');
    Error('\P{Block= :=Domino_Tiles}');
    Expect(1, 127135, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(1, 127135, '\p{Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Block=dominotiles}', "");
    Expect(0, 127135, '\P{Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Block=dominotiles}', "");
    Expect(0, 127136, '\p{Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Block=dominotiles}', "");
    Expect(1, 127136, '\P{Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Block=dominotiles}', "");
    Expect(1, 127135, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(1, 127135, '\p{Block=	-domino_TILES}', "");
    Expect(0, 127135, '\p{^Block=	-domino_TILES}', "");
    Expect(0, 127135, '\P{Block=	-domino_TILES}', "");
    Expect(1, 127135, '\P{^Block=	-domino_TILES}', "");
    Expect(0, 127136, '\p{Block=	-domino_TILES}', "");
    Expect(1, 127136, '\p{^Block=	-domino_TILES}', "");
    Expect(1, 127136, '\P{Block=	-domino_TILES}', "");
    Expect(0, 127136, '\P{^Block=	-domino_TILES}', "");
    Error('\p{Blk=:=	Domino}');
    Error('\P{Blk=:=	Domino}');
    Expect(1, 127135, '\p{Blk=:\ADomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\ADomino\z:}', "");;
    Expect(1, 127135, '\p{Blk=domino}', "");
    Expect(0, 127135, '\p{^Blk=domino}', "");
    Expect(0, 127135, '\P{Blk=domino}', "");
    Expect(1, 127135, '\P{^Blk=domino}', "");
    Expect(0, 127136, '\p{Blk=domino}', "");
    Expect(1, 127136, '\p{^Blk=domino}', "");
    Expect(1, 127136, '\P{Blk=domino}', "");
    Expect(0, 127136, '\P{^Blk=domino}', "");
    Expect(1, 127135, '\p{Blk=:\Adomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\Adomino\z:}', "");;
    Expect(1, 127135, '\p{Blk=	Domino}', "");
    Expect(0, 127135, '\p{^Blk=	Domino}', "");
    Expect(0, 127135, '\P{Blk=	Domino}', "");
    Expect(1, 127135, '\P{^Blk=	Domino}', "");
    Expect(0, 127136, '\p{Blk=	Domino}', "");
    Expect(1, 127136, '\p{^Blk=	Domino}', "");
    Expect(1, 127136, '\P{Blk=	Domino}', "");
    Expect(0, 127136, '\P{^Blk=	Domino}', "");
    Error('\p{Is_Block=:=	 DOMINO_TILES}');
    Error('\P{Is_Block=:=	 DOMINO_TILES}');
    Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
    Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
    Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
    Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
    Expect(1, 127135, '\p{Is_Block=-DOMINO_TILES}', "");
    Expect(0, 127135, '\p{^Is_Block=-DOMINO_TILES}', "");
    Expect(0, 127135, '\P{Is_Block=-DOMINO_TILES}', "");
    Expect(1, 127135, '\P{^Is_Block=-DOMINO_TILES}', "");
    Expect(0, 127136, '\p{Is_Block=-DOMINO_TILES}', "");
    Expect(1, 127136, '\p{^Is_Block=-DOMINO_TILES}', "");
    Expect(1, 127136, '\P{Is_Block=-DOMINO_TILES}', "");
    Expect(0, 127136, '\P{^Is_Block=-DOMINO_TILES}', "");
    Error('\p{Is_Blk=:=domino}');
    Error('\P{Is_Blk=:=domino}');
    Expect(1, 127135, '\p{Is_Blk=domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=domino}', "");
    Expect(0, 127135, '\P{Is_Blk=domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=domino}', "");
    Expect(0, 127136, '\p{Is_Blk=domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=domino}', "");
    Expect(1, 127136, '\P{Is_Blk=domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=domino}', "");
    Expect(1, 127135, '\p{Is_Blk=_-Domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=_-Domino}', "");
    Expect(0, 127135, '\P{Is_Blk=_-Domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=_-Domino}', "");
    Expect(0, 127136, '\p{Is_Blk=_-Domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=_-Domino}', "");
    Expect(1, 127136, '\P{Is_Blk=_-Domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=_-Domino}', "");
    Error('\p{Block= Duployan:=}');
    Error('\P{Block= Duployan:=}');
    Expect(1, 113823, '\p{Block=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Block=duployan}', "");
    Expect(0, 113823, '\p{^Block=duployan}', "");
    Expect(0, 113823, '\P{Block=duployan}', "");
    Expect(1, 113823, '\P{^Block=duployan}', "");
    Expect(0, 113824, '\p{Block=duployan}', "");
    Expect(1, 113824, '\p{^Block=duployan}', "");
    Expect(1, 113824, '\P{Block=duployan}', "");
    Expect(0, 113824, '\P{^Block=duployan}', "");
    Expect(1, 113823, '\p{Block=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Block= Duployan}', "");
    Expect(0, 113823, '\p{^Block= Duployan}', "");
    Expect(0, 113823, '\P{Block= Duployan}', "");
    Expect(1, 113823, '\P{^Block= Duployan}', "");
    Expect(0, 113824, '\p{Block= Duployan}', "");
    Expect(1, 113824, '\p{^Block= Duployan}', "");
    Expect(1, 113824, '\P{Block= Duployan}', "");
    Expect(0, 113824, '\P{^Block= Duployan}', "");
    Error('\p{Blk: --duployan:=}');
    Error('\P{Blk: --duployan:=}');
    Expect(1, 113823, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=duployan}', "");
    Expect(0, 113823, '\p{^Blk=duployan}', "");
    Expect(0, 113823, '\P{Blk=duployan}', "");
    Expect(1, 113823, '\P{^Blk=duployan}', "");
    Expect(0, 113824, '\p{Blk=duployan}', "");
    Expect(1, 113824, '\p{^Blk=duployan}', "");
    Expect(1, 113824, '\P{Blk=duployan}', "");
    Expect(0, 113824, '\P{^Blk=duployan}', "");
    Expect(1, 113823, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=	 duployan}', "");
    Expect(0, 113823, '\p{^Blk=	 duployan}', "");
    Expect(0, 113823, '\P{Blk=	 duployan}', "");
    Expect(1, 113823, '\P{^Blk=	 duployan}', "");
    Expect(0, 113824, '\p{Blk=	 duployan}', "");
    Expect(1, 113824, '\p{^Blk=	 duployan}', "");
    Expect(1, 113824, '\P{Blk=	 duployan}', "");
    Expect(0, 113824, '\P{^Blk=	 duployan}', "");
    Error('\p{Is_Block=/a/--Duployan}');
    Error('\P{Is_Block=/a/--Duployan}');
    Expect(1, 113823, '\p{Is_Block:	duployan}', "");
    Expect(0, 113823, '\p{^Is_Block:	duployan}', "");
    Expect(0, 113823, '\P{Is_Block:	duployan}', "");
    Expect(1, 113823, '\P{^Is_Block:	duployan}', "");
    Expect(0, 113824, '\p{Is_Block:	duployan}', "");
    Expect(1, 113824, '\p{^Is_Block:	duployan}', "");
    Expect(1, 113824, '\P{Is_Block:	duployan}', "");
    Expect(0, 113824, '\P{^Is_Block:	duployan}', "");
    Expect(1, 113823, '\p{Is_Block=-DUPLOYAN}', "");
    Expect(0, 113823, '\p{^Is_Block=-DUPLOYAN}', "");
    Expect(0, 113823, '\P{Is_Block=-DUPLOYAN}', "");
    Expect(1, 113823, '\P{^Is_Block=-DUPLOYAN}', "");
    Expect(0, 113824, '\p{Is_Block=-DUPLOYAN}', "");
    Expect(1, 113824, '\p{^Is_Block=-DUPLOYAN}', "");
    Expect(1, 113824, '\P{Is_Block=-DUPLOYAN}', "");
    Expect(0, 113824, '\P{^Is_Block=-DUPLOYAN}', "");
    Error('\p{Is_Blk=	/a/DUPLOYAN}');
    Error('\P{Is_Blk=	/a/DUPLOYAN}');
    Expect(1, 113823, '\p{Is_Blk=duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk=duployan}', "");
    Expect(0, 113823, '\P{Is_Blk=duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk=duployan}', "");
    Expect(0, 113824, '\p{Is_Blk=duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk=duployan}', "");
    Expect(1, 113824, '\P{Is_Blk=duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk=duployan}', "");
    Expect(1, 113823, '\p{Is_Blk= _Duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk= _Duployan}', "");
    Expect(0, 113823, '\P{Is_Blk= _Duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk= _Duployan}', "");
    Expect(0, 113824, '\p{Is_Blk= _Duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk= _Duployan}', "");
    Expect(1, 113824, '\P{Is_Blk= _Duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk= _Duployan}', "");
    Error('\p{Block=-	early_Dynastic_Cuneiform/a/}');
    Error('\P{Block=-	early_Dynastic_Cuneiform/a/}');
    Expect(1, 75087, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=  early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Block=  early_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Block=  early_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Block=  early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Block=  early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Block=  early_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Block=  early_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Block=  early_Dynastic_Cuneiform}', "");
    Error('\p{Blk=/a/- EARLY_dynastic_Cuneiform}');
    Error('\P{Blk=/a/- EARLY_dynastic_Cuneiform}');
    Expect(1, 75087, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=_ early_dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Blk=_ early_dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Blk=_ early_dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Blk=_ early_dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Blk=_ early_dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Blk=_ early_dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Blk=_ early_dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Blk=_ early_dynastic_Cuneiform}', "");
    Error('\p{Is_Block=		Early_Dynastic_CUNEIFORM:=}');
    Error('\P{Is_Block=		Early_Dynastic_CUNEIFORM:=}');
    Expect(1, 75087, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=__early_DYNASTIC_cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=__early_DYNASTIC_cuneiform}', "");
    Error('\p{Is_Blk=/a/ early_Dynastic_Cuneiform}');
    Error('\P{Is_Blk=/a/ early_Dynastic_Cuneiform}');
    Expect(1, 75087, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=__Early_Dynastic_cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=__Early_Dynastic_cuneiform}', "");
    Error('\p{Block= 	Egyptian_HIEROGLYPH_Format_Controls:=}');
    Error('\P{Block= 	Egyptian_HIEROGLYPH_Format_Controls:=}');
    Expect(1, 78911, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\p{^Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\P{Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78911, '\P{^Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\p{Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\p{^Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\P{Block=-Egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\P{^Block=-Egyptian_hieroglyph_Format_controls}', "");
    Error('\p{Blk=	:=Egyptian_HIEROGLYPH_format_controls}');
    Error('\P{Blk=	:=Egyptian_HIEROGLYPH_format_controls}');
    Expect(1, 78911, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(0, 78911, '\p{^Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(0, 78911, '\P{Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(1, 78911, '\P{^Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(0, 78912, '\p{Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(1, 78912, '\p{^Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(1, 78912, '\P{Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Expect(0, 78912, '\P{^Blk=_EGYPTIAN_Hieroglyph_format_controls}', "");
    Error('\p{Is_Block=	_Egyptian_Hieroglyph_Format_controls/a/}');
    Error('\P{Is_Block=	_Egyptian_Hieroglyph_Format_controls/a/}');
    Expect(1, 78911, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\p{^Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\P{Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78911, '\P{^Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\p{Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\p{^Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\P{Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\P{^Is_Block:		egyptian_hieroglyph_Format_controls}', "");
    Error('\p{Is_Blk=	:=Egyptian_hieroglyph_format_Controls}');
    Error('\P{Is_Blk=	:=Egyptian_hieroglyph_format_Controls}');
    Expect(1, 78911, '\p{Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Blk:	egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78911, '\p{^Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78911, '\P{Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78911, '\P{^Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78912, '\p{Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78912, '\p{^Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(1, 78912, '\P{Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Expect(0, 78912, '\P{^Is_Blk=  Egyptian_Hieroglyph_format_CONTROLS}', "");
    Error('\p{Block: 	egyptian_Hieroglyphs:=}');
    Error('\P{Block: 	egyptian_Hieroglyphs:=}');
    Expect(1, 78895, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=	Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Block=	Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=	Egyptian_Hieroglyphs}', "");
    Error('\p{Blk=/a/--egyptian_Hieroglyphs}');
    Error('\P{Blk=/a/--egyptian_Hieroglyphs}');
    Expect(1, 78895, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk= _Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk= _Egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\P{Blk= _Egyptian_hieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk= _Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\p{Blk= _Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk= _Egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\P{Blk= _Egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk= _Egyptian_hieroglyphs}', "");
    Error('\p{Is_Block=:=		Egyptian_HIEROGLYPHS}');
    Error('\P{Is_Block=:=		Egyptian_HIEROGLYPHS}');
    Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=-_Egyptian_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=-_Egyptian_Hieroglyphs}', "");
    Error('\p{Is_Blk:   -Egyptian_HIEROGLYPHS/a/}');
    Error('\P{Is_Blk:   -Egyptian_HIEROGLYPHS/a/}');
    Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\p{^Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\P{Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78895, '\P{^Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\p{Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\p{^Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\P{Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\P{^Is_Blk=	Egyptian_HIEROGLYPHS}', "");
    Error('\p{Block:Elbasan/a/}');
    Error('\P{Block:Elbasan/a/}');
    Expect(1, 66863, '\p{Block=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Block=elbasan}', "");
    Expect(0, 66863, '\p{^Block=elbasan}', "");
    Expect(0, 66863, '\P{Block=elbasan}', "");
    Expect(1, 66863, '\P{^Block=elbasan}', "");
    Expect(0, 66864, '\p{Block=elbasan}', "");
    Expect(1, 66864, '\p{^Block=elbasan}', "");
    Expect(1, 66864, '\P{Block=elbasan}', "");
    Expect(0, 66864, '\P{^Block=elbasan}', "");
    Expect(1, 66863, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Block: _Elbasan}', "");
    Expect(0, 66863, '\p{^Block: _Elbasan}', "");
    Expect(0, 66863, '\P{Block: _Elbasan}', "");
    Expect(1, 66863, '\P{^Block: _Elbasan}', "");
    Expect(0, 66864, '\p{Block: _Elbasan}', "");
    Expect(1, 66864, '\p{^Block: _Elbasan}', "");
    Expect(1, 66864, '\P{Block: _Elbasan}', "");
    Expect(0, 66864, '\P{^Block: _Elbasan}', "");
    Error('\p{Blk: /a/-ELBASAN}');
    Error('\P{Blk: /a/-ELBASAN}');
    Expect(1, 66863, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Blk=elbasan}', "");
    Expect(0, 66863, '\P{Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Blk=elbasan}', "");
    Expect(0, 66864, '\p{Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Blk=elbasan}', "");
    Expect(1, 66864, '\P{Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Blk=elbasan}', "");
    Expect(1, 66863, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk= 	Elbasan}', "");
    Expect(0, 66863, '\p{^Blk= 	Elbasan}', "");
    Expect(0, 66863, '\P{Blk= 	Elbasan}', "");
    Expect(1, 66863, '\P{^Blk= 	Elbasan}', "");
    Expect(0, 66864, '\p{Blk= 	Elbasan}', "");
    Expect(1, 66864, '\p{^Blk= 	Elbasan}', "");
    Expect(1, 66864, '\P{Blk= 	Elbasan}', "");
    Expect(0, 66864, '\P{^Blk= 	Elbasan}', "");
    Error('\p{Is_Block:-/a/Elbasan}');
    Error('\P{Is_Block:-/a/Elbasan}');
    Expect(1, 66863, '\p{Is_Block=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
    Expect(1, 66863, '\p{Is_Block= 	Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block= 	Elbasan}', "");
    Expect(0, 66863, '\P{Is_Block= 	Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block= 	Elbasan}', "");
    Expect(0, 66864, '\p{Is_Block= 	Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block= 	Elbasan}', "");
    Expect(1, 66864, '\P{Is_Block= 	Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block= 	Elbasan}', "");
    Error('\p{Is_Blk=/a/elbasan}');
    Error('\P{Is_Blk=/a/elbasan}');
    Expect(1, 66863, '\p{Is_Blk: elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk: elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk: elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk: elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk: elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk: elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk: elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk: elbasan}', "");
    Expect(1, 66863, '\p{Is_Blk=-elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=-elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=-elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=-elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=-elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=-elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=-elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=-elbasan}', "");
    Error('\p{Block:_Elymaic:=}');
    Error('\P{Block:_Elymaic:=}');
    Expect(1, 69631, '\p{Block=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Block=elymaic}', "");
    Expect(0, 69631, '\p{^Block=elymaic}', "");
    Expect(0, 69631, '\P{Block=elymaic}', "");
    Expect(1, 69631, '\P{^Block=elymaic}', "");
    Expect(0, 69632, '\p{Block=elymaic}', "");
    Expect(1, 69632, '\p{^Block=elymaic}', "");
    Expect(1, 69632, '\P{Block=elymaic}', "");
    Expect(0, 69632, '\P{^Block=elymaic}', "");
    Expect(1, 69631, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Block=-elymaic}', "");
    Expect(0, 69631, '\p{^Block=-elymaic}', "");
    Expect(0, 69631, '\P{Block=-elymaic}', "");
    Expect(1, 69631, '\P{^Block=-elymaic}', "");
    Expect(0, 69632, '\p{Block=-elymaic}', "");
    Expect(1, 69632, '\p{^Block=-elymaic}', "");
    Expect(1, 69632, '\P{Block=-elymaic}', "");
    Expect(0, 69632, '\P{^Block=-elymaic}', "");
    Error('\p{Blk=:=Elymaic}');
    Error('\P{Blk=:=Elymaic}');
    Expect(1, 69631, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Blk=elymaic}', "");
    Expect(0, 69631, '\P{Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Blk=elymaic}', "");
    Expect(0, 69632, '\p{Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Blk=elymaic}', "");
    Expect(1, 69632, '\P{Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Blk=elymaic}', "");
    Expect(1, 69631, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=_-ELYMAIC}', "");
    Expect(0, 69631, '\p{^Blk=_-ELYMAIC}', "");
    Expect(0, 69631, '\P{Blk=_-ELYMAIC}', "");
    Expect(1, 69631, '\P{^Blk=_-ELYMAIC}', "");
    Expect(0, 69632, '\p{Blk=_-ELYMAIC}', "");
    Expect(1, 69632, '\p{^Blk=_-ELYMAIC}', "");
    Expect(1, 69632, '\P{Blk=_-ELYMAIC}', "");
    Expect(0, 69632, '\P{^Blk=_-ELYMAIC}', "");
    Error('\p{Is_Block=/a/_-Elymaic}');
    Error('\P{Is_Block=/a/_-Elymaic}');
    Expect(1, 69631, '\p{Is_Block:   elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block:   elymaic}', "");
    Expect(0, 69631, '\P{Is_Block:   elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block:   elymaic}', "");
    Expect(0, 69632, '\p{Is_Block:   elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block:   elymaic}', "");
    Expect(1, 69632, '\P{Is_Block:   elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block:   elymaic}', "");
    Expect(1, 69631, '\p{Is_Block=	 Elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block=	 Elymaic}', "");
    Expect(0, 69631, '\P{Is_Block=	 Elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block=	 Elymaic}', "");
    Expect(0, 69632, '\p{Is_Block=	 Elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block=	 Elymaic}', "");
    Expect(1, 69632, '\P{Is_Block=	 Elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block=	 Elymaic}', "");
    Error('\p{Is_Blk=:=	_Elymaic}');
    Error('\P{Is_Blk=:=	_Elymaic}');
    Expect(1, 69631, '\p{Is_Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk=elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk=elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk=elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk=elymaic}', "");
    Expect(1, 69631, '\p{Is_Blk= elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk= elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk= elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk= elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk= elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk= elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk= elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk= elymaic}', "");
    Error('\p{Block= 	emoticons/a/}');
    Error('\P{Block= 	emoticons/a/}');
    Expect(1, 128591, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=emoticons}', "");
    Expect(0, 128591, '\p{^Block=emoticons}', "");
    Expect(0, 128591, '\P{Block=emoticons}', "");
    Expect(1, 128591, '\P{^Block=emoticons}', "");
    Expect(0, 128592, '\p{Block=emoticons}', "");
    Expect(1, 128592, '\p{^Block=emoticons}', "");
    Expect(1, 128592, '\P{Block=emoticons}', "");
    Expect(0, 128592, '\P{^Block=emoticons}', "");
    Expect(1, 128591, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=__emoticons}', "");
    Expect(0, 128591, '\p{^Block=__emoticons}', "");
    Expect(0, 128591, '\P{Block=__emoticons}', "");
    Expect(1, 128591, '\P{^Block=__emoticons}', "");
    Expect(0, 128592, '\p{Block=__emoticons}', "");
    Expect(1, 128592, '\p{^Block=__emoticons}', "");
    Expect(1, 128592, '\P{Block=__emoticons}', "");
    Expect(0, 128592, '\P{^Block=__emoticons}', "");
    Error('\p{Blk=_Emoticons/a/}');
    Error('\P{Blk=_Emoticons/a/}');
    Expect(1, 128591, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Blk=emoticons}', "");
    Expect(0, 128591, '\P{Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Blk=emoticons}', "");
    Expect(0, 128592, '\p{Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Blk=emoticons}', "");
    Expect(1, 128592, '\P{Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Blk=emoticons}', "");
    Expect(1, 128591, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk= emoticons}', "");
    Expect(0, 128591, '\p{^Blk= emoticons}', "");
    Expect(0, 128591, '\P{Blk= emoticons}', "");
    Expect(1, 128591, '\P{^Blk= emoticons}', "");
    Expect(0, 128592, '\p{Blk= emoticons}', "");
    Expect(1, 128592, '\p{^Blk= emoticons}', "");
    Expect(1, 128592, '\P{Blk= emoticons}', "");
    Expect(0, 128592, '\P{^Blk= emoticons}', "");
    Error('\p{Is_Block=_/a/Emoticons}');
    Error('\P{Is_Block=_/a/Emoticons}');
    Expect(1, 128591, '\p{Is_Block=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
    Expect(1, 128591, '\p{Is_Block=--Emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=--Emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=--Emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=--Emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=--Emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=--Emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=--Emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=--Emoticons}', "");
    Error('\p{Is_Blk=-:=Emoticons}');
    Error('\P{Is_Blk=-:=Emoticons}');
    Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
    Expect(1, 128591, '\p{Is_Blk=		emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=		emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=		emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=		emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=		emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=		emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=		emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=		emoticons}', "");
    Error('\p{Block= 	Enclosed_ALPHANUMERICS/a/}');
    Error('\P{Block= 	Enclosed_ALPHANUMERICS/a/}');
    Expect(1, 9471, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\p{^Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\P{Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9471, '\P{^Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\p{Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\p{^Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\P{Block=	 Enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\P{^Block=	 Enclosed_ALPHANUMERICS}', "");
    Error('\p{Blk=:=_Enclosed_alphanum}');
    Error('\P{Blk=:=_Enclosed_alphanum}');
    Expect(1, 9471, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=  enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\p{^Blk=  enclosed_ALPHANUM}', "");
    Expect(0, 9471, '\P{Blk=  enclosed_ALPHANUM}', "");
    Expect(1, 9471, '\P{^Blk=  enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\p{Blk=  enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\p{^Blk=  enclosed_ALPHANUM}', "");
    Expect(1, 9472, '\P{Blk=  enclosed_ALPHANUM}', "");
    Expect(0, 9472, '\P{^Blk=  enclosed_ALPHANUM}', "");
    Error('\p{Is_Block=-:=Enclosed_alphanumerics}');
    Error('\P{Is_Block=-:=Enclosed_alphanumerics}');
    Expect(1, 9471, '\p{Is_Block: enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block: enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block: enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block: enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block: enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block: enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block: enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block: enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=_	Enclosed_alphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=_	Enclosed_alphanumerics}', "");
    Error('\p{Is_Blk=/a/-Enclosed_ALPHANUM}');
    Error('\P{Is_Blk=/a/-Enclosed_ALPHANUM}');
    Expect(1, 9471, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Is_Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=	Enclosed_Alphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=	Enclosed_Alphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=	Enclosed_Alphanum}', "");
    Error('\p{Block=:= -ENCLOSED_Alphanumeric_SUPPLEMENT}');
    Error('\P{Block=:= -ENCLOSED_Alphanumeric_SUPPLEMENT}');
    Expect(1, 127487, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(1, 127487, '\p{Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\p{^Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127487, '\P{Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127487, '\P{^Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\p{Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\p{^Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(1, 127488, '\P{Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Expect(0, 127488, '\P{^Block=	 Enclosed_Alphanumeric_Supplement}', "");
    Error('\p{Blk=:=_-ENCLOSED_Alphanum_Sup}');
    Error('\P{Blk=:=_-ENCLOSED_Alphanum_Sup}');
    Expect(1, 127487, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(1, 127487, '\p{Blk:   enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Blk:   enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Blk:   enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Blk:   enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Blk:   enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Blk:   enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Blk:   enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Blk:   enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(1, 127487, '\p{Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\p{^Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\P{Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(1, 127487, '\P{^Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\p{Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\p{^Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\P{Blk=-	enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\P{^Blk=-	enclosed_Alphanum_Sup}', "");
    Error('\p{Is_Block=/a/ENCLOSED_Alphanumeric_SUPPLEMENT}');
    Error('\P{Is_Block=/a/ENCLOSED_Alphanumeric_SUPPLEMENT}');
    Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\p{^Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127487, '\P{Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127487, '\P{^Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\p{Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\p{^Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(1, 127488, '\P{Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Expect(0, 127488, '\P{^Is_Block= -Enclosed_alphanumeric_SUPPLEMENT}', "");
    Error('\p{Is_Blk=	/a/Enclosed_Alphanum_Sup}');
    Error('\P{Is_Blk=	/a/Enclosed_Alphanum_Sup}');
    Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\p{^Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(0, 127487, '\P{Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(1, 127487, '\P{^Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\p{Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\p{^Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(1, 127488, '\P{Is_Blk=_enclosed_Alphanum_Sup}', "");
    Expect(0, 127488, '\P{^Is_Blk=_enclosed_Alphanum_Sup}', "");
    Error('\p{Block= :=enclosed_CJK_Letters_and_MONTHS}');
    Error('\P{Block= :=enclosed_CJK_Letters_and_MONTHS}');
    Expect(1, 13055, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(0, 13056, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(1, 13055, '\p{Block:   enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Block:   enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Block:   enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Block:   enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Block:   enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Block:   enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Block:   enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Block:   enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(0, 13056, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(1, 13055, '\p{Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(0, 13055, '\p{^Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(0, 13055, '\P{Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(1, 13055, '\P{^Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(0, 13056, '\p{Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(1, 13056, '\p{^Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(1, 13056, '\P{Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Expect(0, 13056, '\P{^Block=	-Enclosed_CJK_Letters_AND_Months}', "");
    Error('\p{Blk=/a/ Enclosed_CJK}');
    Error('\P{Blk=/a/ Enclosed_CJK}');
    Expect(1, 13055, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(1, 13055, '\p{Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(1, 13055, '\p{Blk=__Enclosed_CJK}', "");
    Expect(0, 13055, '\p{^Blk=__Enclosed_CJK}', "");
    Expect(0, 13055, '\P{Blk=__Enclosed_CJK}', "");
    Expect(1, 13055, '\P{^Blk=__Enclosed_CJK}', "");
    Expect(0, 13056, '\p{Blk=__Enclosed_CJK}', "");
    Expect(1, 13056, '\p{^Blk=__Enclosed_CJK}', "");
    Expect(1, 13056, '\P{Blk=__Enclosed_CJK}', "");
    Expect(0, 13056, '\P{^Blk=__Enclosed_CJK}', "");
    Error('\p{Is_Block=/a/ENCLOSED_CJK_letters_And_MONTHS}');
    Error('\P{Is_Block=/a/ENCLOSED_CJK_letters_And_MONTHS}');
    Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13055, '\p{^Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13055, '\P{Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13055, '\P{^Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13056, '\p{Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13056, '\p{^Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(1, 13056, '\P{Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Expect(0, 13056, '\P{^Is_Block:     Enclosed_CJK_letters_and_Months}', "");
    Error('\p{Is_Blk:-ENCLOSED_CJK/a/}');
    Error('\P{Is_Blk:-ENCLOSED_CJK/a/}');
    Expect(1, 13055, '\p{Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Is_Blk: _ENCLOSED_CJK}', "");
    Expect(0, 13055, '\p{^Is_Blk: _ENCLOSED_CJK}', "");
    Expect(0, 13055, '\P{Is_Blk: _ENCLOSED_CJK}', "");
    Expect(1, 13055, '\P{^Is_Blk: _ENCLOSED_CJK}', "");
    Expect(0, 13056, '\p{Is_Blk: _ENCLOSED_CJK}', "");
    Expect(1, 13056, '\p{^Is_Blk: _ENCLOSED_CJK}', "");
    Expect(1, 13056, '\P{Is_Blk: _ENCLOSED_CJK}', "");
    Expect(0, 13056, '\P{^Is_Blk: _ENCLOSED_CJK}', "");
    Error('\p{Block=:=_ENCLOSED_Ideographic_supplement}');
    Error('\P{Block=:=_ENCLOSED_Ideographic_supplement}');
    Expect(1, 127743, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(1, 127743, '\p{Block=--Enclosed_ideographic_Supplement}', "");
    Expect(0, 127743, '\p{^Block=--Enclosed_ideographic_Supplement}', "");
    Expect(0, 127743, '\P{Block=--Enclosed_ideographic_Supplement}', "");
    Expect(1, 127743, '\P{^Block=--Enclosed_ideographic_Supplement}', "");
    Expect(0, 127744, '\p{Block=--Enclosed_ideographic_Supplement}', "");
    Expect(1, 127744, '\p{^Block=--Enclosed_ideographic_Supplement}', "");
    Expect(1, 127744, '\P{Block=--Enclosed_ideographic_Supplement}', "");
    Expect(0, 127744, '\P{^Block=--Enclosed_ideographic_Supplement}', "");
    Error('\p{Blk:   /a/-	Enclosed_Ideographic_sup}');
    Error('\P{Blk:   /a/-	Enclosed_Ideographic_sup}');
    Expect(1, 127743, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(1, 127743, '\p{Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(1, 127743, '\p{Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(0, 127743, '\P{Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\p{Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(1, 127744, '\P{Blk=	-Enclosed_Ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Blk=	-Enclosed_Ideographic_Sup}', "");
    Error('\p{Is_Block: :=	enclosed_Ideographic_Supplement}');
    Error('\P{Is_Block: :=	enclosed_Ideographic_Supplement}');
    Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Is_Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Is_Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127743, '\p{^Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127743, '\P{Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127743, '\P{^Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127744, '\p{Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127744, '\p{^Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(1, 127744, '\P{Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Expect(0, 127744, '\P{^Is_Block= Enclosed_Ideographic_SUPPLEMENT}', "");
    Error('\p{Is_Blk:   -/a/ENCLOSED_IDEOGRAPHIC_Sup}');
    Error('\P{Is_Blk:   -/a/ENCLOSED_IDEOGRAPHIC_Sup}');
    Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(0, 127743, '\P{Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(0, 127744, '\p{Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(1, 127744, '\P{Is_Blk=__enclosed_ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Is_Blk=__enclosed_ideographic_Sup}', "");
    Error('\p{Block=-	Ethiopic/a/}');
    Error('\P{Block=-	Ethiopic/a/}');
    Expect(1, 4991, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Block: ethiopic}', "");
    Expect(0, 4991, '\p{^Block: ethiopic}', "");
    Expect(0, 4991, '\P{Block: ethiopic}', "");
    Expect(1, 4991, '\P{^Block: ethiopic}', "");
    Expect(0, 4992, '\p{Block: ethiopic}', "");
    Expect(1, 4992, '\p{^Block: ethiopic}', "");
    Expect(1, 4992, '\P{Block: ethiopic}', "");
    Expect(0, 4992, '\P{^Block: ethiopic}', "");
    Expect(1, 4991, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Block=_ethiopic}', "");
    Expect(0, 4991, '\p{^Block=_ethiopic}', "");
    Expect(0, 4991, '\P{Block=_ethiopic}', "");
    Expect(1, 4991, '\P{^Block=_ethiopic}', "");
    Expect(0, 4992, '\p{Block=_ethiopic}', "");
    Expect(1, 4992, '\p{^Block=_ethiopic}', "");
    Expect(1, 4992, '\P{Block=_ethiopic}', "");
    Expect(0, 4992, '\P{^Block=_ethiopic}', "");
    Error('\p{Blk=	-Ethiopic:=}');
    Error('\P{Blk=	-Ethiopic:=}');
    Expect(1, 4991, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk: -ETHIOPIC}', "");
    Expect(0, 4991, '\p{^Blk: -ETHIOPIC}', "");
    Expect(0, 4991, '\P{Blk: -ETHIOPIC}', "");
    Expect(1, 4991, '\P{^Blk: -ETHIOPIC}', "");
    Expect(0, 4992, '\p{Blk: -ETHIOPIC}', "");
    Expect(1, 4992, '\p{^Blk: -ETHIOPIC}', "");
    Expect(1, 4992, '\P{Blk: -ETHIOPIC}', "");
    Expect(0, 4992, '\P{^Blk: -ETHIOPIC}', "");
    Error('\p{Is_Block=	/a/Ethiopic}');
    Error('\P{Is_Block=	/a/Ethiopic}');
    Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Block= _ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block= _ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block= _ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block= _ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block= _ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block= _ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block= _ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block= _ethiopic}', "");
    Error('\p{Is_Blk=:=ethiopic}');
    Error('\P{Is_Blk=:=ethiopic}');
    Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Blk= ETHIOPIC}', "");
    Expect(0, 4991, '\p{^Is_Blk= ETHIOPIC}', "");
    Expect(0, 4991, '\P{Is_Blk= ETHIOPIC}', "");
    Expect(1, 4991, '\P{^Is_Blk= ETHIOPIC}', "");
    Expect(0, 4992, '\p{Is_Blk= ETHIOPIC}', "");
    Expect(1, 4992, '\p{^Is_Blk= ETHIOPIC}', "");
    Expect(1, 4992, '\P{Is_Blk= ETHIOPIC}', "");
    Expect(0, 4992, '\P{^Is_Blk= ETHIOPIC}', "");
    Error('\p{Block=/a/-ethiopic_extended}');
    Error('\P{Block=/a/-ethiopic_extended}');
    Expect(1, 11743, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(1, 11743, '\p{Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(1, 11743, '\p{Block=--Ethiopic_Extended}', "");
    Expect(0, 11743, '\p{^Block=--Ethiopic_Extended}', "");
    Expect(0, 11743, '\P{Block=--Ethiopic_Extended}', "");
    Expect(1, 11743, '\P{^Block=--Ethiopic_Extended}', "");
    Expect(0, 11744, '\p{Block=--Ethiopic_Extended}', "");
    Expect(1, 11744, '\p{^Block=--Ethiopic_Extended}', "");
    Expect(1, 11744, '\P{Block=--Ethiopic_Extended}', "");
    Expect(0, 11744, '\P{^Block=--Ethiopic_Extended}', "");
    Error('\p{Blk=:=Ethiopic_EXT}');
    Error('\P{Blk=:=Ethiopic_EXT}');
    Expect(1, 11743, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(1, 11743, '\p{Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(1, 11743, '\p{Blk:   -ETHIOPIC_EXT}', "");
    Expect(0, 11743, '\p{^Blk:   -ETHIOPIC_EXT}', "");
    Expect(0, 11743, '\P{Blk:   -ETHIOPIC_EXT}', "");
    Expect(1, 11743, '\P{^Blk:   -ETHIOPIC_EXT}', "");
    Expect(0, 11744, '\p{Blk:   -ETHIOPIC_EXT}', "");
    Expect(1, 11744, '\p{^Blk:   -ETHIOPIC_EXT}', "");
    Expect(1, 11744, '\P{Blk:   -ETHIOPIC_EXT}', "");
    Expect(0, 11744, '\P{^Blk:   -ETHIOPIC_EXT}', "");
    Error('\p{Is_Block=_-Ethiopic_EXTENDED:=}');
    Error('\P{Is_Block=_-Ethiopic_EXTENDED:=}');
    Expect(1, 11743, '\p{Is_Block:ethiopicextended}', "");
    Expect(0, 11743, '\p{^Is_Block:ethiopicextended}', "");
    Expect(0, 11743, '\P{Is_Block:ethiopicextended}', "");
    Expect(1, 11743, '\P{^Is_Block:ethiopicextended}', "");
    Expect(0, 11744, '\p{Is_Block:ethiopicextended}', "");
    Expect(1, 11744, '\p{^Is_Block:ethiopicextended}', "");
    Expect(1, 11744, '\P{Is_Block:ethiopicextended}', "");
    Expect(0, 11744, '\P{^Is_Block:ethiopicextended}', "");
    Expect(1, 11743, '\p{Is_Block=	 Ethiopic_Extended}', "");
    Expect(0, 11743, '\p{^Is_Block=	 Ethiopic_Extended}', "");
    Expect(0, 11743, '\P{Is_Block=	 Ethiopic_Extended}', "");
    Expect(1, 11743, '\P{^Is_Block=	 Ethiopic_Extended}', "");
    Expect(0, 11744, '\p{Is_Block=	 Ethiopic_Extended}', "");
    Expect(1, 11744, '\p{^Is_Block=	 Ethiopic_Extended}', "");
    Expect(1, 11744, '\P{Is_Block=	 Ethiopic_Extended}', "");
    Expect(0, 11744, '\P{^Is_Block=	 Ethiopic_Extended}', "");
    Error('\p{Is_Blk=:= Ethiopic_Ext}');
    Error('\P{Is_Blk=:= Ethiopic_Ext}');
    Expect(1, 11743, '\p{Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Is_Blk:_	Ethiopic_Ext}', "");
    Expect(0, 11743, '\p{^Is_Blk:_	Ethiopic_Ext}', "");
    Expect(0, 11743, '\P{Is_Blk:_	Ethiopic_Ext}', "");
    Expect(1, 11743, '\P{^Is_Blk:_	Ethiopic_Ext}', "");
    Expect(0, 11744, '\p{Is_Blk:_	Ethiopic_Ext}', "");
    Expect(1, 11744, '\p{^Is_Blk:_	Ethiopic_Ext}', "");
    Expect(1, 11744, '\P{Is_Blk:_	Ethiopic_Ext}', "");
    Expect(0, 11744, '\P{^Is_Blk:_	Ethiopic_Ext}', "");
    Error('\p{Block:   :=  Ethiopic_Extended_A}');
    Error('\P{Block:   :=  Ethiopic_Extended_A}');
    Expect(1, 43823, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(0, 43824, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(1, 43823, '\p{Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(0, 43824, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(1, 43823, '\p{Block= -Ethiopic_Extended_A}', "");
    Expect(0, 43823, '\p{^Block= -Ethiopic_Extended_A}', "");
    Expect(0, 43823, '\P{Block= -Ethiopic_Extended_A}', "");
    Expect(1, 43823, '\P{^Block= -Ethiopic_Extended_A}', "");
    Expect(0, 43824, '\p{Block= -Ethiopic_Extended_A}', "");
    Expect(1, 43824, '\p{^Block= -Ethiopic_Extended_A}', "");
    Expect(1, 43824, '\P{Block= -Ethiopic_Extended_A}', "");
    Expect(0, 43824, '\P{^Block= -Ethiopic_Extended_A}', "");
    Error('\p{Blk=-:=ethiopic_Ext_A}');
    Error('\P{Blk=-:=ethiopic_Ext_A}');
    Expect(1, 43823, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(1, 43823, '\p{Blk= Ethiopic_ext_a}', "");
    Expect(0, 43823, '\p{^Blk= Ethiopic_ext_a}', "");
    Expect(0, 43823, '\P{Blk= Ethiopic_ext_a}', "");
    Expect(1, 43823, '\P{^Blk= Ethiopic_ext_a}', "");
    Expect(0, 43824, '\p{Blk= Ethiopic_ext_a}', "");
    Expect(1, 43824, '\p{^Blk= Ethiopic_ext_a}', "");
    Expect(1, 43824, '\P{Blk= Ethiopic_ext_a}', "");
    Expect(0, 43824, '\P{^Blk= Ethiopic_ext_a}', "");
    Error('\p{Is_Block=/a/ethiopic_Extended_A}');
    Error('\P{Is_Block=/a/ethiopic_Extended_A}');
    Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Is_Block=_-Ethiopic_extended_A}', "");
    Expect(0, 43823, '\p{^Is_Block=_-Ethiopic_extended_A}', "");
    Expect(0, 43823, '\P{Is_Block=_-Ethiopic_extended_A}', "");
    Expect(1, 43823, '\P{^Is_Block=_-Ethiopic_extended_A}', "");
    Expect(0, 43824, '\p{Is_Block=_-Ethiopic_extended_A}', "");
    Expect(1, 43824, '\p{^Is_Block=_-Ethiopic_extended_A}', "");
    Expect(1, 43824, '\P{Is_Block=_-Ethiopic_extended_A}', "");
    Expect(0, 43824, '\P{^Is_Block=_-Ethiopic_extended_A}', "");
    Error('\p{Is_Blk=-	ETHIOPIC_EXT_a:=}');
    Error('\P{Is_Blk=-	ETHIOPIC_EXT_a:=}');
    Expect(1, 43823, '\p{Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Is_Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Is_Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(0, 43823, '\p{^Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(0, 43823, '\P{Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(1, 43823, '\P{^Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(0, 43824, '\p{Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(1, 43824, '\p{^Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(1, 43824, '\P{Is_Blk=	Ethiopic_EXT_A}', "");
    Expect(0, 43824, '\P{^Is_Blk=	Ethiopic_EXT_A}', "");
    Error('\p{Block: /a/ Ethiopic_Supplement}');
    Error('\P{Block: /a/ Ethiopic_Supplement}');
    Expect(1, 5023, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(1, 5023, '\p{Block=- Ethiopic_supplement}', "");
    Expect(0, 5023, '\p{^Block=- Ethiopic_supplement}', "");
    Expect(0, 5023, '\P{Block=- Ethiopic_supplement}', "");
    Expect(1, 5023, '\P{^Block=- Ethiopic_supplement}', "");
    Expect(0, 5024, '\p{Block=- Ethiopic_supplement}', "");
    Expect(1, 5024, '\p{^Block=- Ethiopic_supplement}', "");
    Expect(1, 5024, '\P{Block=- Ethiopic_supplement}', "");
    Expect(0, 5024, '\P{^Block=- Ethiopic_supplement}', "");
    Error('\p{Blk=:=_ETHIOPIC_SUP}');
    Error('\P{Blk=:=_ETHIOPIC_SUP}');
    Expect(1, 5023, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(1, 5023, '\p{Blk=__ethiopic_Sup}', "");
    Expect(0, 5023, '\p{^Blk=__ethiopic_Sup}', "");
    Expect(0, 5023, '\P{Blk=__ethiopic_Sup}', "");
    Expect(1, 5023, '\P{^Blk=__ethiopic_Sup}', "");
    Expect(0, 5024, '\p{Blk=__ethiopic_Sup}', "");
    Expect(1, 5024, '\p{^Blk=__ethiopic_Sup}', "");
    Expect(1, 5024, '\P{Blk=__ethiopic_Sup}', "");
    Expect(0, 5024, '\P{^Blk=__ethiopic_Sup}', "");
    Error('\p{Is_Block=:= Ethiopic_Supplement}');
    Error('\P{Is_Block=:= Ethiopic_Supplement}');
    Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Is_Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Is_Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Is_Block= Ethiopic_Supplement}', "");
    Expect(0, 5023, '\p{^Is_Block= Ethiopic_Supplement}', "");
    Expect(0, 5023, '\P{Is_Block= Ethiopic_Supplement}', "");
    Expect(1, 5023, '\P{^Is_Block= Ethiopic_Supplement}', "");
    Expect(0, 5024, '\p{Is_Block= Ethiopic_Supplement}', "");
    Expect(1, 5024, '\p{^Is_Block= Ethiopic_Supplement}', "");
    Expect(1, 5024, '\P{Is_Block= Ethiopic_Supplement}', "");
    Expect(0, 5024, '\P{^Is_Block= Ethiopic_Supplement}', "");
    Error('\p{Is_Blk=-/a/ethiopic_Sup}');
    Error('\P{Is_Blk=-/a/ethiopic_Sup}');
    Expect(1, 5023, '\p{Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Is_Blk= _Ethiopic_SUP}', "");
    Expect(0, 5023, '\p{^Is_Blk= _Ethiopic_SUP}', "");
    Expect(0, 5023, '\P{Is_Blk= _Ethiopic_SUP}', "");
    Expect(1, 5023, '\P{^Is_Blk= _Ethiopic_SUP}', "");
    Expect(0, 5024, '\p{Is_Blk= _Ethiopic_SUP}', "");
    Expect(1, 5024, '\p{^Is_Blk= _Ethiopic_SUP}', "");
    Expect(1, 5024, '\P{Is_Blk= _Ethiopic_SUP}', "");
    Expect(0, 5024, '\P{^Is_Blk= _Ethiopic_SUP}', "");
    Error('\p{Block=:=_Geometric_SHAPES}');
    Error('\P{Block=:=_Geometric_SHAPES}');
    Expect(1, 9727, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Block: geometricshapes}', "");
    Expect(0, 9727, '\p{^Block: geometricshapes}', "");
    Expect(0, 9727, '\P{Block: geometricshapes}', "");
    Expect(1, 9727, '\P{^Block: geometricshapes}', "");
    Expect(0, 9728, '\p{Block: geometricshapes}', "");
    Expect(1, 9728, '\p{^Block: geometricshapes}', "");
    Expect(1, 9728, '\P{Block: geometricshapes}', "");
    Expect(0, 9728, '\P{^Block: geometricshapes}', "");
    Expect(1, 9727, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Block= GEOMETRIC_Shapes}', "");
    Expect(0, 9727, '\p{^Block= GEOMETRIC_Shapes}', "");
    Expect(0, 9727, '\P{Block= GEOMETRIC_Shapes}', "");
    Expect(1, 9727, '\P{^Block= GEOMETRIC_Shapes}', "");
    Expect(0, 9728, '\p{Block= GEOMETRIC_Shapes}', "");
    Expect(1, 9728, '\p{^Block= GEOMETRIC_Shapes}', "");
    Expect(1, 9728, '\P{Block= GEOMETRIC_Shapes}', "");
    Expect(0, 9728, '\P{^Block= GEOMETRIC_Shapes}', "");
    Error('\p{Blk:-:=Geometric_Shapes}');
    Error('\P{Blk:-:=Geometric_Shapes}');
    Expect(1, 9727, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Blk: geometricshapes}', "");
    Expect(0, 9727, '\p{^Blk: geometricshapes}', "");
    Expect(0, 9727, '\P{Blk: geometricshapes}', "");
    Expect(1, 9727, '\P{^Blk: geometricshapes}', "");
    Expect(0, 9728, '\p{Blk: geometricshapes}', "");
    Expect(1, 9728, '\p{^Blk: geometricshapes}', "");
    Expect(1, 9728, '\P{Blk: geometricshapes}', "");
    Expect(0, 9728, '\P{^Blk: geometricshapes}', "");
    Expect(1, 9727, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=-Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Blk=-Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Blk=-Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Blk=-Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Blk=-Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Blk=-Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Blk=-Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Blk=-Geometric_Shapes}', "");
    Error('\p{Is_Block= 	GEOMETRIC_shapes/a/}');
    Error('\P{Is_Block= 	GEOMETRIC_shapes/a/}');
    Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Block=-Geometric_SHAPES}', "");
    Expect(0, 9727, '\p{^Is_Block=-Geometric_SHAPES}', "");
    Expect(0, 9727, '\P{Is_Block=-Geometric_SHAPES}', "");
    Expect(1, 9727, '\P{^Is_Block=-Geometric_SHAPES}', "");
    Expect(0, 9728, '\p{Is_Block=-Geometric_SHAPES}', "");
    Expect(1, 9728, '\p{^Is_Block=-Geometric_SHAPES}', "");
    Expect(1, 9728, '\P{Is_Block=-Geometric_SHAPES}', "");
    Expect(0, 9728, '\P{^Is_Block=-Geometric_SHAPES}', "");
    Error('\p{Is_Blk=/a/	Geometric_Shapes}');
    Error('\P{Is_Blk=/a/	Geometric_Shapes}');
    Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Blk= _Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Is_Blk= _Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Is_Blk= _Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Is_Blk= _Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Is_Blk= _Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Is_Blk= _Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Is_Blk= _Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Is_Blk= _Geometric_Shapes}', "");
    Error('\p{Block= -GEOMETRIC_shapes_Extended:=}');
    Error('\P{Block= -GEOMETRIC_shapes_Extended:=}');
    Expect(1, 129023, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(1, 129023, '\p{Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(1, 129023, '\p{Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129023, '\p{^Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129023, '\P{Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129023, '\P{^Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129024, '\p{Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129024, '\p{^Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129024, '\P{Block=_ GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129024, '\P{^Block=_ GEOMETRIC_Shapes_Extended}', "");
    Error('\p{Blk=_-Geometric_shapes_Ext/a/}');
    Error('\P{Blk=_-Geometric_shapes_Ext/a/}');
    Expect(1, 129023, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(1, 129023, '\p{Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(1, 129023, '\p{Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129023, '\p{^Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129023, '\P{Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129023, '\P{^Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129024, '\p{Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129024, '\p{^Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(1, 129024, '\P{Blk=  GEOMETRIC_Shapes_Ext}', "");
    Expect(0, 129024, '\P{^Blk=  GEOMETRIC_Shapes_Ext}', "");
    Error('\p{Is_Block=/a/__Geometric_Shapes_Extended}');
    Error('\P{Is_Block=/a/__Geometric_Shapes_Extended}');
    Expect(1, 129023, '\p{Is_Block: geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Is_Block: geometricshapesextended}', "");
    Expect(0, 129023, '\P{Is_Block: geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Is_Block: geometricshapesextended}', "");
    Expect(0, 129024, '\p{Is_Block: geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Is_Block: geometricshapesextended}', "");
    Expect(1, 129024, '\P{Is_Block: geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Is_Block: geometricshapesextended}', "");
    Expect(1, 129023, '\p{Is_Block: geometric_SHAPES_Extended}', "");
    Expect(0, 129023, '\p{^Is_Block: geometric_SHAPES_Extended}', "");
    Expect(0, 129023, '\P{Is_Block: geometric_SHAPES_Extended}', "");
    Expect(1, 129023, '\P{^Is_Block: geometric_SHAPES_Extended}', "");
    Expect(0, 129024, '\p{Is_Block: geometric_SHAPES_Extended}', "");
    Expect(1, 129024, '\p{^Is_Block: geometric_SHAPES_Extended}', "");
    Expect(1, 129024, '\P{Is_Block: geometric_SHAPES_Extended}', "");
    Expect(0, 129024, '\P{^Is_Block: geometric_SHAPES_Extended}', "");
    Error('\p{Is_Blk: :=-geometric_Shapes_Ext}');
    Error('\P{Is_Blk: :=-geometric_Shapes_Ext}');
    Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(0, 129023, '\p{^Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(0, 129023, '\P{Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(1, 129023, '\P{^Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(0, 129024, '\p{Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(1, 129024, '\p{^Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(1, 129024, '\P{Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Expect(0, 129024, '\P{^Is_Blk=	_Geometric_SHAPES_EXT}', "");
    Error('\p{Block=	-georgian:=}');
    Error('\P{Block=	-georgian:=}');
    Expect(1, 4351, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=georgian}', "");
    Expect(0, 4351, '\p{^Block=georgian}', "");
    Expect(0, 4351, '\P{Block=georgian}', "");
    Expect(1, 4351, '\P{^Block=georgian}', "");
    Expect(0, 4352, '\p{Block=georgian}', "");
    Expect(1, 4352, '\p{^Block=georgian}', "");
    Expect(1, 4352, '\P{Block=georgian}', "");
    Expect(0, 4352, '\P{^Block=georgian}', "");
    Expect(1, 4351, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=_ Georgian}', "");
    Expect(0, 4351, '\p{^Block=_ Georgian}', "");
    Expect(0, 4351, '\P{Block=_ Georgian}', "");
    Expect(1, 4351, '\P{^Block=_ Georgian}', "");
    Expect(0, 4352, '\p{Block=_ Georgian}', "");
    Expect(1, 4352, '\p{^Block=_ Georgian}', "");
    Expect(1, 4352, '\P{Block=_ Georgian}', "");
    Expect(0, 4352, '\P{^Block=_ Georgian}', "");
    Error('\p{Blk=	-Georgian:=}');
    Error('\P{Blk=	-Georgian:=}');
    Expect(1, 4351, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=georgian}', "");
    Expect(0, 4351, '\p{^Blk=georgian}', "");
    Expect(0, 4351, '\P{Blk=georgian}', "");
    Expect(1, 4351, '\P{^Blk=georgian}', "");
    Expect(0, 4352, '\p{Blk=georgian}', "");
    Expect(1, 4352, '\p{^Blk=georgian}', "");
    Expect(1, 4352, '\P{Blk=georgian}', "");
    Expect(0, 4352, '\P{^Blk=georgian}', "");
    Expect(1, 4351, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=		Georgian}', "");
    Expect(0, 4351, '\p{^Blk=		Georgian}', "");
    Expect(0, 4351, '\P{Blk=		Georgian}', "");
    Expect(1, 4351, '\P{^Blk=		Georgian}', "");
    Expect(0, 4352, '\p{Blk=		Georgian}', "");
    Expect(1, 4352, '\p{^Blk=		Georgian}', "");
    Expect(1, 4352, '\P{Blk=		Georgian}', "");
    Expect(0, 4352, '\P{^Blk=		Georgian}', "");
    Error('\p{Is_Block=	/a/Georgian}');
    Error('\P{Is_Block=	/a/Georgian}');
    Expect(1, 4351, '\p{Is_Block=georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=georgian}', "");
    Expect(0, 4351, '\P{Is_Block=georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=georgian}', "");
    Expect(0, 4352, '\p{Is_Block=georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=georgian}', "");
    Expect(1, 4352, '\P{Is_Block=georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=georgian}', "");
    Expect(1, 4351, '\p{Is_Block=__Georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=__Georgian}', "");
    Expect(0, 4351, '\P{Is_Block=__Georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=__Georgian}', "");
    Expect(0, 4352, '\p{Is_Block=__Georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=__Georgian}', "");
    Expect(1, 4352, '\P{Is_Block=__Georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=__Georgian}', "");
    Error('\p{Is_Blk= georgian:=}');
    Error('\P{Is_Blk= georgian:=}');
    Expect(1, 4351, '\p{Is_Blk=georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
    Expect(1, 4351, '\p{Is_Blk=_GEORGIAN}', "");
    Expect(0, 4351, '\p{^Is_Blk=_GEORGIAN}', "");
    Expect(0, 4351, '\P{Is_Blk=_GEORGIAN}', "");
    Expect(1, 4351, '\P{^Is_Blk=_GEORGIAN}', "");
    Expect(0, 4352, '\p{Is_Blk=_GEORGIAN}', "");
    Expect(1, 4352, '\p{^Is_Blk=_GEORGIAN}', "");
    Expect(1, 4352, '\P{Is_Blk=_GEORGIAN}', "");
    Expect(0, 4352, '\P{^Is_Blk=_GEORGIAN}', "");
    Error('\p{Block=Georgian_extended/a/}');
    Error('\P{Block=Georgian_extended/a/}');
    Expect(1, 7359, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(1, 7359, '\p{Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Block=georgianextended}', "");
    Expect(0, 7359, '\P{Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Block=georgianextended}', "");
    Expect(0, 7360, '\p{Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Block=georgianextended}', "");
    Expect(1, 7360, '\P{Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Block=georgianextended}', "");
    Expect(1, 7359, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(1, 7359, '\p{Block=	Georgian_Extended}', "");
    Expect(0, 7359, '\p{^Block=	Georgian_Extended}', "");
    Expect(0, 7359, '\P{Block=	Georgian_Extended}', "");
    Expect(1, 7359, '\P{^Block=	Georgian_Extended}', "");
    Expect(0, 7360, '\p{Block=	Georgian_Extended}', "");
    Expect(1, 7360, '\p{^Block=	Georgian_Extended}', "");
    Expect(1, 7360, '\P{Block=	Georgian_Extended}', "");
    Expect(0, 7360, '\P{^Block=	Georgian_Extended}', "");
    Error('\p{Blk:    Georgian_EXT:=}');
    Error('\P{Blk:    Georgian_EXT:=}');
    Expect(1, 7359, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(1, 7359, '\p{Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Blk=georgianext}', "");
    Expect(0, 7359, '\P{Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Blk=georgianext}', "");
    Expect(0, 7360, '\p{Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Blk=georgianext}', "");
    Expect(1, 7360, '\P{Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Blk=georgianext}', "");
    Expect(1, 7359, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(1, 7359, '\p{Blk=	-GEORGIAN_Ext}', "");
    Expect(0, 7359, '\p{^Blk=	-GEORGIAN_Ext}', "");
    Expect(0, 7359, '\P{Blk=	-GEORGIAN_Ext}', "");
    Expect(1, 7359, '\P{^Blk=	-GEORGIAN_Ext}', "");
    Expect(0, 7360, '\p{Blk=	-GEORGIAN_Ext}', "");
    Expect(1, 7360, '\p{^Blk=	-GEORGIAN_Ext}', "");
    Expect(1, 7360, '\P{Blk=	-GEORGIAN_Ext}', "");
    Expect(0, 7360, '\P{^Blk=	-GEORGIAN_Ext}', "");
    Error('\p{Is_Block=	-georgian_EXTENDED:=}');
    Error('\P{Is_Block=	-georgian_EXTENDED:=}');
    Expect(1, 7359, '\p{Is_Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Is_Block=georgianextended}', "");
    Expect(0, 7359, '\P{Is_Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Is_Block=georgianextended}', "");
    Expect(0, 7360, '\p{Is_Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Is_Block=georgianextended}', "");
    Expect(1, 7360, '\P{Is_Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Is_Block=georgianextended}', "");
    Expect(1, 7359, '\p{Is_Block= -Georgian_Extended}', "");
    Expect(0, 7359, '\p{^Is_Block= -Georgian_Extended}', "");
    Expect(0, 7359, '\P{Is_Block= -Georgian_Extended}', "");
    Expect(1, 7359, '\P{^Is_Block= -Georgian_Extended}', "");
    Expect(0, 7360, '\p{Is_Block= -Georgian_Extended}', "");
    Expect(1, 7360, '\p{^Is_Block= -Georgian_Extended}', "");
    Expect(1, 7360, '\P{Is_Block= -Georgian_Extended}', "");
    Expect(0, 7360, '\P{^Is_Block= -Georgian_Extended}', "");
    Error('\p{Is_Blk=/a/  georgian_Ext}');
    Error('\P{Is_Blk=/a/  georgian_Ext}');
    Expect(1, 7359, '\p{Is_Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Is_Blk=georgianext}', "");
    Expect(0, 7359, '\P{Is_Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Is_Blk=georgianext}', "");
    Expect(0, 7360, '\p{Is_Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Is_Blk=georgianext}', "");
    Expect(1, 7360, '\P{Is_Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Is_Blk=georgianext}', "");
    Expect(1, 7359, '\p{Is_Blk=	-georgian_Ext}', "");
    Expect(0, 7359, '\p{^Is_Blk=	-georgian_Ext}', "");
    Expect(0, 7359, '\P{Is_Blk=	-georgian_Ext}', "");
    Expect(1, 7359, '\P{^Is_Blk=	-georgian_Ext}', "");
    Expect(0, 7360, '\p{Is_Blk=	-georgian_Ext}', "");
    Expect(1, 7360, '\p{^Is_Blk=	-georgian_Ext}', "");
    Expect(1, 7360, '\P{Is_Blk=	-georgian_Ext}', "");
    Expect(0, 7360, '\P{^Is_Blk=	-georgian_Ext}', "");
    Error('\p{Block=__georgian_Supplement:=}');
    Error('\P{Block=__georgian_Supplement:=}');
    Expect(1, 11567, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(1, 11567, '\p{Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(1, 11567, '\p{Block=-GEORGIAN_Supplement}', "");
    Expect(0, 11567, '\p{^Block=-GEORGIAN_Supplement}', "");
    Expect(0, 11567, '\P{Block=-GEORGIAN_Supplement}', "");
    Expect(1, 11567, '\P{^Block=-GEORGIAN_Supplement}', "");
    Expect(0, 11568, '\p{Block=-GEORGIAN_Supplement}', "");
    Expect(1, 11568, '\p{^Block=-GEORGIAN_Supplement}', "");
    Expect(1, 11568, '\P{Block=-GEORGIAN_Supplement}', "");
    Expect(0, 11568, '\P{^Block=-GEORGIAN_Supplement}', "");
    Error('\p{Blk: 	/a/Georgian_Sup}');
    Error('\P{Blk: 	/a/Georgian_Sup}');
    Expect(1, 11567, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(1, 11567, '\p{Blk:	georgiansup}', "");
    Expect(0, 11567, '\p{^Blk:	georgiansup}', "");
    Expect(0, 11567, '\P{Blk:	georgiansup}', "");
    Expect(1, 11567, '\P{^Blk:	georgiansup}', "");
    Expect(0, 11568, '\p{Blk:	georgiansup}', "");
    Expect(1, 11568, '\p{^Blk:	georgiansup}', "");
    Expect(1, 11568, '\P{Blk:	georgiansup}', "");
    Expect(0, 11568, '\P{^Blk:	georgiansup}', "");
    Expect(1, 11567, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(1, 11567, '\p{Blk=	-Georgian_Sup}', "");
    Expect(0, 11567, '\p{^Blk=	-Georgian_Sup}', "");
    Expect(0, 11567, '\P{Blk=	-Georgian_Sup}', "");
    Expect(1, 11567, '\P{^Blk=	-Georgian_Sup}', "");
    Expect(0, 11568, '\p{Blk=	-Georgian_Sup}', "");
    Expect(1, 11568, '\p{^Blk=	-Georgian_Sup}', "");
    Expect(1, 11568, '\P{Blk=	-Georgian_Sup}', "");
    Expect(0, 11568, '\P{^Blk=	-Georgian_Sup}', "");
    Error('\p{Is_Block=:= Georgian_Supplement}');
    Error('\P{Is_Block=:= Georgian_Supplement}');
    Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Is_Block=__Georgian_Supplement}', "");
    Expect(0, 11567, '\p{^Is_Block=__Georgian_Supplement}', "");
    Expect(0, 11567, '\P{Is_Block=__Georgian_Supplement}', "");
    Expect(1, 11567, '\P{^Is_Block=__Georgian_Supplement}', "");
    Expect(0, 11568, '\p{Is_Block=__Georgian_Supplement}', "");
    Expect(1, 11568, '\p{^Is_Block=__Georgian_Supplement}', "");
    Expect(1, 11568, '\P{Is_Block=__Georgian_Supplement}', "");
    Expect(0, 11568, '\P{^Is_Block=__Georgian_Supplement}', "");
    Error('\p{Is_Blk=-_Georgian_SUP/a/}');
    Error('\P{Is_Blk=-_Georgian_SUP/a/}');
    Expect(1, 11567, '\p{Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Is_Blk=-Georgian_Sup}', "");
    Expect(0, 11567, '\p{^Is_Blk=-Georgian_Sup}', "");
    Expect(0, 11567, '\P{Is_Blk=-Georgian_Sup}', "");
    Expect(1, 11567, '\P{^Is_Blk=-Georgian_Sup}', "");
    Expect(0, 11568, '\p{Is_Blk=-Georgian_Sup}', "");
    Expect(1, 11568, '\p{^Is_Blk=-Georgian_Sup}', "");
    Expect(1, 11568, '\P{Is_Blk=-Georgian_Sup}', "");
    Expect(0, 11568, '\P{^Is_Blk=-Georgian_Sup}', "");
    Error('\p{Block=/a/GLAGOLITIC}');
    Error('\P{Block=/a/GLAGOLITIC}');
    Expect(1, 11359, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Block=glagolitic}', "");
    Expect(0, 11359, '\P{Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Block=glagolitic}', "");
    Expect(0, 11360, '\p{Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Block=glagolitic}', "");
    Expect(1, 11360, '\P{Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Block=glagolitic}', "");
    Expect(1, 11359, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block: -Glagolitic}', "");
    Expect(0, 11359, '\p{^Block: -Glagolitic}', "");
    Expect(0, 11359, '\P{Block: -Glagolitic}', "");
    Expect(1, 11359, '\P{^Block: -Glagolitic}', "");
    Expect(0, 11360, '\p{Block: -Glagolitic}', "");
    Expect(1, 11360, '\p{^Block: -Glagolitic}', "");
    Expect(1, 11360, '\P{Block: -Glagolitic}', "");
    Expect(0, 11360, '\P{^Block: -Glagolitic}', "");
    Error('\p{Blk=  GLAGOLITIC/a/}');
    Error('\P{Blk=  GLAGOLITIC/a/}');
    Expect(1, 11359, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk:glagolitic}', "");
    Expect(0, 11359, '\p{^Blk:glagolitic}', "");
    Expect(0, 11359, '\P{Blk:glagolitic}', "");
    Expect(1, 11359, '\P{^Blk:glagolitic}', "");
    Expect(0, 11360, '\p{Blk:glagolitic}', "");
    Expect(1, 11360, '\p{^Blk:glagolitic}', "");
    Expect(1, 11360, '\P{Blk:glagolitic}', "");
    Expect(0, 11360, '\P{^Blk:glagolitic}', "");
    Expect(1, 11359, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=__glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=__glagolitic}', "");
    Expect(0, 11359, '\P{Blk=__glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=__glagolitic}', "");
    Expect(0, 11360, '\p{Blk=__glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=__glagolitic}', "");
    Expect(1, 11360, '\P{Blk=__glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=__glagolitic}', "");
    Error('\p{Is_Block= -Glagolitic/a/}');
    Error('\P{Is_Block= -Glagolitic/a/}');
    Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Block:	-	Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block:	-	Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block:	-	Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block:	-	Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block:	-	Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block:	-	Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block:	-	Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block:	-	Glagolitic}', "");
    Error('\p{Is_Blk=:=_-glagolitic}');
    Error('\P{Is_Blk=:=_-glagolitic}');
    Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Blk= -Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk= -Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk= -Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk= -Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk= -Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk= -Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk= -Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk= -Glagolitic}', "");
    Error('\p{Block=/a/_ GLAGOLITIC_Supplement}');
    Error('\P{Block=/a/_ GLAGOLITIC_Supplement}');
    Expect(1, 122927, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(1, 122927, '\p{Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(1, 122927, '\p{Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122927, '\p{^Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122927, '\P{Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122927, '\P{^Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122928, '\p{Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122928, '\p{^Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122928, '\P{Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122928, '\P{^Block=_ Glagolitic_Supplement}', "");
    Error('\p{Blk=	/a/glagolitic_sup}');
    Error('\P{Blk=	/a/glagolitic_sup}');
    Expect(1, 122927, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(1, 122927, '\p{Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(1, 122927, '\p{Blk=__glagolitic_Sup}', "");
    Expect(0, 122927, '\p{^Blk=__glagolitic_Sup}', "");
    Expect(0, 122927, '\P{Blk=__glagolitic_Sup}', "");
    Expect(1, 122927, '\P{^Blk=__glagolitic_Sup}', "");
    Expect(0, 122928, '\p{Blk=__glagolitic_Sup}', "");
    Expect(1, 122928, '\p{^Blk=__glagolitic_Sup}', "");
    Expect(1, 122928, '\P{Blk=__glagolitic_Sup}', "");
    Expect(0, 122928, '\P{^Blk=__glagolitic_Sup}', "");
    Error('\p{Is_Block= 	GLAGOLITIC_Supplement:=}');
    Error('\P{Is_Block= 	GLAGOLITIC_Supplement:=}');
    Expect(1, 122927, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Is_Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122927, '\p{^Is_Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122927, '\P{Is_Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122927, '\P{^Is_Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122928, '\p{Is_Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122928, '\p{^Is_Block=_ Glagolitic_Supplement}', "");
    Expect(1, 122928, '\P{Is_Block=_ Glagolitic_Supplement}', "");
    Expect(0, 122928, '\P{^Is_Block=_ Glagolitic_Supplement}', "");
    Error('\p{Is_Blk::=-_Glagolitic_SUP}');
    Error('\P{Is_Blk::=-_Glagolitic_SUP}');
    Expect(1, 122927, '\p{Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Is_Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Is_Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\p{^Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\P{Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(1, 122927, '\P{^Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\p{Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\p{^Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\P{Is_Blk=__GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\P{^Is_Blk=__GLAGOLITIC_Sup}', "");
    Error('\p{Block=/a/Gothic}');
    Error('\P{Block=/a/Gothic}');
    Expect(1, 66383, '\p{Block=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Block=gothic}', "");
    Expect(0, 66383, '\p{^Block=gothic}', "");
    Expect(0, 66383, '\P{Block=gothic}', "");
    Expect(1, 66383, '\P{^Block=gothic}', "");
    Expect(0, 66384, '\p{Block=gothic}', "");
    Expect(1, 66384, '\p{^Block=gothic}', "");
    Expect(1, 66384, '\P{Block=gothic}', "");
    Expect(0, 66384, '\P{^Block=gothic}', "");
    Expect(1, 66383, '\p{Block=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Block= gothic}', "");
    Expect(0, 66383, '\p{^Block= gothic}', "");
    Expect(0, 66383, '\P{Block= gothic}', "");
    Expect(1, 66383, '\P{^Block= gothic}', "");
    Expect(0, 66384, '\p{Block= gothic}', "");
    Expect(1, 66384, '\p{^Block= gothic}', "");
    Expect(1, 66384, '\P{Block= gothic}', "");
    Expect(0, 66384, '\P{^Block= gothic}', "");
    Error('\p{Blk=_	gothic:=}');
    Error('\P{Blk=_	gothic:=}');
    Expect(1, 66383, '\p{Blk=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=gothic}', "");
    Expect(0, 66383, '\p{^Blk=gothic}', "");
    Expect(0, 66383, '\P{Blk=gothic}', "");
    Expect(1, 66383, '\P{^Blk=gothic}', "");
    Expect(0, 66384, '\p{Blk=gothic}', "");
    Expect(1, 66384, '\p{^Blk=gothic}', "");
    Expect(1, 66384, '\P{Blk=gothic}', "");
    Expect(0, 66384, '\P{^Blk=gothic}', "");
    Expect(1, 66383, '\p{Blk=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Blk= Gothic}', "");
    Expect(0, 66383, '\p{^Blk= Gothic}', "");
    Expect(0, 66383, '\P{Blk= Gothic}', "");
    Expect(1, 66383, '\P{^Blk= Gothic}', "");
    Expect(0, 66384, '\p{Blk= Gothic}', "");
    Expect(1, 66384, '\p{^Blk= Gothic}', "");
    Expect(1, 66384, '\P{Blk= Gothic}', "");
    Expect(0, 66384, '\P{^Blk= Gothic}', "");
    Error('\p{Is_Block= 	Gothic/a/}');
    Error('\P{Is_Block= 	Gothic/a/}');
    Expect(1, 66383, '\p{Is_Block=gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=gothic}', "");
    Expect(0, 66383, '\P{Is_Block=gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=gothic}', "");
    Expect(0, 66384, '\p{Is_Block=gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=gothic}', "");
    Expect(1, 66384, '\P{Is_Block=gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=gothic}', "");
    Expect(1, 66383, '\p{Is_Block:		-GOTHIC}', "");
    Expect(0, 66383, '\p{^Is_Block:		-GOTHIC}', "");
    Expect(0, 66383, '\P{Is_Block:		-GOTHIC}', "");
    Expect(1, 66383, '\P{^Is_Block:		-GOTHIC}', "");
    Expect(0, 66384, '\p{Is_Block:		-GOTHIC}', "");
    Expect(1, 66384, '\p{^Is_Block:		-GOTHIC}', "");
    Expect(1, 66384, '\P{Is_Block:		-GOTHIC}', "");
    Expect(0, 66384, '\P{^Is_Block:		-GOTHIC}', "");
    Error('\p{Is_Blk: :=Gothic}');
    Error('\P{Is_Blk: :=Gothic}');
    Expect(1, 66383, '\p{Is_Blk=gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
    Expect(1, 66383, '\p{Is_Blk=	Gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=	Gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=	Gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=	Gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=	Gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=	Gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=	Gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=	Gothic}', "");
    Error('\p{Block=-:=grantha}');
    Error('\P{Block=-:=grantha}');
    Expect(1, 70527, '\p{Block=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=grantha}', "");
    Expect(0, 70527, '\p{^Block=grantha}', "");
    Expect(0, 70527, '\P{Block=grantha}', "");
    Expect(1, 70527, '\P{^Block=grantha}', "");
    Expect(0, 70528, '\p{Block=grantha}', "");
    Expect(1, 70528, '\p{^Block=grantha}', "");
    Expect(1, 70528, '\P{Block=grantha}', "");
    Expect(0, 70528, '\P{^Block=grantha}', "");
    Expect(1, 70527, '\p{Block=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Block:    Grantha}', "");
    Expect(0, 70527, '\p{^Block:    Grantha}', "");
    Expect(0, 70527, '\P{Block:    Grantha}', "");
    Expect(1, 70527, '\P{^Block:    Grantha}', "");
    Expect(0, 70528, '\p{Block:    Grantha}', "");
    Expect(1, 70528, '\p{^Block:    Grantha}', "");
    Expect(1, 70528, '\P{Block:    Grantha}', "");
    Expect(0, 70528, '\P{^Block:    Grantha}', "");
    Error('\p{Blk=_/a/Grantha}');
    Error('\P{Blk=_/a/Grantha}');
    Expect(1, 70527, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=grantha}', "");
    Expect(0, 70527, '\p{^Blk=grantha}', "");
    Expect(0, 70527, '\P{Blk=grantha}', "");
    Expect(1, 70527, '\P{^Blk=grantha}', "");
    Expect(0, 70528, '\p{Blk=grantha}', "");
    Expect(1, 70528, '\p{^Blk=grantha}', "");
    Expect(1, 70528, '\P{Blk=grantha}', "");
    Expect(0, 70528, '\P{^Blk=grantha}', "");
    Expect(1, 70527, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=		grantha}', "");
    Expect(0, 70527, '\p{^Blk=		grantha}', "");
    Expect(0, 70527, '\P{Blk=		grantha}', "");
    Expect(1, 70527, '\P{^Blk=		grantha}', "");
    Expect(0, 70528, '\p{Blk=		grantha}', "");
    Expect(1, 70528, '\p{^Blk=		grantha}', "");
    Expect(1, 70528, '\P{Blk=		grantha}', "");
    Expect(0, 70528, '\P{^Blk=		grantha}', "");
    Error('\p{Is_Block=/a/	_grantha}');
    Error('\P{Is_Block=/a/	_grantha}');
    Expect(1, 70527, '\p{Is_Block=grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=grantha}', "");
    Expect(0, 70527, '\P{Is_Block=grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=grantha}', "");
    Expect(0, 70528, '\p{Is_Block=grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=grantha}', "");
    Expect(1, 70528, '\P{Is_Block=grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=grantha}', "");
    Expect(1, 70527, '\p{Is_Block= GRANTHA}', "");
    Expect(0, 70527, '\p{^Is_Block= GRANTHA}', "");
    Expect(0, 70527, '\P{Is_Block= GRANTHA}', "");
    Expect(1, 70527, '\P{^Is_Block= GRANTHA}', "");
    Expect(0, 70528, '\p{Is_Block= GRANTHA}', "");
    Expect(1, 70528, '\p{^Is_Block= GRANTHA}', "");
    Expect(1, 70528, '\P{Is_Block= GRANTHA}', "");
    Expect(0, 70528, '\P{^Is_Block= GRANTHA}', "");
    Error('\p{Is_Blk=-:=Grantha}');
    Error('\P{Is_Blk=-:=Grantha}');
    Expect(1, 70527, '\p{Is_Blk=grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk=grantha}', "");
    Expect(0, 70527, '\P{Is_Blk=grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk=grantha}', "");
    Expect(0, 70528, '\p{Is_Blk=grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk=grantha}', "");
    Expect(1, 70528, '\P{Is_Blk=grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk=grantha}', "");
    Expect(1, 70527, '\p{Is_Blk=	_GRANTHA}', "");
    Expect(0, 70527, '\p{^Is_Blk=	_GRANTHA}', "");
    Expect(0, 70527, '\P{Is_Blk=	_GRANTHA}', "");
    Expect(1, 70527, '\P{^Is_Blk=	_GRANTHA}', "");
    Expect(0, 70528, '\p{Is_Blk=	_GRANTHA}', "");
    Expect(1, 70528, '\p{^Is_Blk=	_GRANTHA}', "");
    Expect(1, 70528, '\P{Is_Blk=	_GRANTHA}', "");
    Expect(0, 70528, '\P{^Is_Blk=	_GRANTHA}', "");
    Error('\p{Block=/a/GREEK_and_COPTIC}');
    Error('\P{Block=/a/GREEK_and_COPTIC}');
    Expect(1, 1023, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(1, 1023, '\p{Block:greekandcoptic}', "");
    Expect(0, 1023, '\p{^Block:greekandcoptic}', "");
    Expect(0, 1023, '\P{Block:greekandcoptic}', "");
    Expect(1, 1023, '\P{^Block:greekandcoptic}', "");
    Expect(0, 1024, '\p{Block:greekandcoptic}', "");
    Expect(1, 1024, '\p{^Block:greekandcoptic}', "");
    Expect(1, 1024, '\P{Block:greekandcoptic}', "");
    Expect(0, 1024, '\P{^Block:greekandcoptic}', "");
    Expect(1, 1023, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(1, 1023, '\p{Block=	greek_and_COPTIC}', "");
    Expect(0, 1023, '\p{^Block=	greek_and_COPTIC}', "");
    Expect(0, 1023, '\P{Block=	greek_and_COPTIC}', "");
    Expect(1, 1023, '\P{^Block=	greek_and_COPTIC}', "");
    Expect(0, 1024, '\p{Block=	greek_and_COPTIC}', "");
    Expect(1, 1024, '\p{^Block=	greek_and_COPTIC}', "");
    Expect(1, 1024, '\P{Block=	greek_and_COPTIC}', "");
    Expect(0, 1024, '\P{^Block=	greek_and_COPTIC}', "");
    Error('\p{Blk=/a/	_Greek}');
    Error('\P{Blk=/a/	_Greek}');
    Expect(1, 1023, '\p{Blk=:\AGreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\AGreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=greek}', "");
    Expect(0, 1023, '\p{^Blk=greek}', "");
    Expect(0, 1023, '\P{Blk=greek}', "");
    Expect(1, 1023, '\P{^Blk=greek}', "");
    Expect(0, 1024, '\p{Blk=greek}', "");
    Expect(1, 1024, '\p{^Blk=greek}', "");
    Expect(1, 1024, '\P{Blk=greek}', "");
    Expect(0, 1024, '\P{^Blk=greek}', "");
    Expect(1, 1023, '\p{Blk=:\Agreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\Agreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=- greek}', "");
    Expect(0, 1023, '\p{^Blk=- greek}', "");
    Expect(0, 1023, '\P{Blk=- greek}', "");
    Expect(1, 1023, '\P{^Blk=- greek}', "");
    Expect(0, 1024, '\p{Blk=- greek}', "");
    Expect(1, 1024, '\p{^Blk=- greek}', "");
    Expect(1, 1024, '\P{Blk=- greek}', "");
    Expect(0, 1024, '\P{^Blk=- greek}', "");
    Error('\p{Is_Block=-/a/Greek_AND_coptic}');
    Error('\P{Is_Block=-/a/Greek_AND_coptic}');
    Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
    Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\p{Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\p{^Is_Block=greekandcoptic}', "");
    Expect(1, 1024, '\P{Is_Block=greekandcoptic}', "");
    Expect(0, 1024, '\P{^Is_Block=greekandcoptic}', "");
    Expect(1, 1023, '\p{Is_Block=	Greek_And_Coptic}', "");
    Expect(0, 1023, '\p{^Is_Block=	Greek_And_Coptic}', "");
    Expect(0, 1023, '\P{Is_Block=	Greek_And_Coptic}', "");
    Expect(1, 1023, '\P{^Is_Block=	Greek_And_Coptic}', "");
    Expect(0, 1024, '\p{Is_Block=	Greek_And_Coptic}', "");
    Expect(1, 1024, '\p{^Is_Block=	Greek_And_Coptic}', "");
    Expect(1, 1024, '\P{Is_Block=	Greek_And_Coptic}', "");
    Expect(0, 1024, '\P{^Is_Block=	Greek_And_Coptic}', "");
    Error('\p{Is_Blk=:=greek}');
    Error('\P{Is_Blk=:=greek}');
    Expect(1, 1023, '\p{Is_Blk=greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=greek}', "");
    Expect(0, 1023, '\P{Is_Blk=greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=greek}', "");
    Expect(0, 1024, '\p{Is_Blk=greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=greek}', "");
    Expect(1, 1024, '\P{Is_Blk=greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=greek}', "");
    Expect(1, 1023, '\p{Is_Blk=		greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=		greek}', "");
    Expect(0, 1023, '\P{Is_Blk=		greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=		greek}', "");
    Expect(0, 1024, '\p{Is_Blk=		greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=		greek}', "");
    Expect(1, 1024, '\P{Is_Blk=		greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=		greek}', "");
    Error('\p{Block=:=Greek_EXTENDED}');
    Error('\P{Block=:=Greek_EXTENDED}');
    Expect(1, 8191, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(1, 8191, '\p{Block: greekextended}', "");
    Expect(0, 8191, '\p{^Block: greekextended}', "");
    Expect(0, 8191, '\P{Block: greekextended}', "");
    Expect(1, 8191, '\P{^Block: greekextended}', "");
    Expect(0, 8192, '\p{Block: greekextended}', "");
    Expect(1, 8192, '\p{^Block: greekextended}', "");
    Expect(1, 8192, '\P{Block: greekextended}', "");
    Expect(0, 8192, '\P{^Block: greekextended}', "");
    Expect(1, 8191, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(1, 8191, '\p{Block=		Greek_extended}', "");
    Expect(0, 8191, '\p{^Block=		Greek_extended}', "");
    Expect(0, 8191, '\P{Block=		Greek_extended}', "");
    Expect(1, 8191, '\P{^Block=		Greek_extended}', "");
    Expect(0, 8192, '\p{Block=		Greek_extended}', "");
    Expect(1, 8192, '\p{^Block=		Greek_extended}', "");
    Expect(1, 8192, '\P{Block=		Greek_extended}', "");
    Expect(0, 8192, '\P{^Block=		Greek_extended}', "");
    Error('\p{Blk=-	greek_Ext:=}');
    Error('\P{Blk=-	greek_Ext:=}');
    Expect(1, 8191, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(1, 8191, '\p{Blk=greekext}', "");
    Expect(0, 8191, '\p{^Blk=greekext}', "");
    Expect(0, 8191, '\P{Blk=greekext}', "");
    Expect(1, 8191, '\P{^Blk=greekext}', "");
    Expect(0, 8192, '\p{Blk=greekext}', "");
    Expect(1, 8192, '\p{^Blk=greekext}', "");
    Expect(1, 8192, '\P{Blk=greekext}', "");
    Expect(0, 8192, '\P{^Blk=greekext}', "");
    Expect(1, 8191, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(1, 8191, '\p{Blk=_ GREEK_ext}', "");
    Expect(0, 8191, '\p{^Blk=_ GREEK_ext}', "");
    Expect(0, 8191, '\P{Blk=_ GREEK_ext}', "");
    Expect(1, 8191, '\P{^Blk=_ GREEK_ext}', "");
    Expect(0, 8192, '\p{Blk=_ GREEK_ext}', "");
    Expect(1, 8192, '\p{^Blk=_ GREEK_ext}', "");
    Expect(1, 8192, '\P{Blk=_ GREEK_ext}', "");
    Expect(0, 8192, '\P{^Blk=_ GREEK_ext}', "");
    Error('\p{Is_Block=:=- Greek_Extended}');
    Error('\P{Is_Block=:=- Greek_Extended}');
    Expect(1, 8191, '\p{Is_Block=greekextended}', "");
    Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
    Expect(0, 8191, '\P{Is_Block=greekextended}', "");
    Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
    Expect(0, 8192, '\p{Is_Block=greekextended}', "");
    Expect(1, 8192, '\p{^Is_Block=greekextended}', "");
    Expect(1, 8192, '\P{Is_Block=greekextended}', "");
    Expect(0, 8192, '\P{^Is_Block=greekextended}', "");
    Expect(1, 8191, '\p{Is_Block:	 Greek_EXTENDED}', "");
    Expect(0, 8191, '\p{^Is_Block:	 Greek_EXTENDED}', "");
    Expect(0, 8191, '\P{Is_Block:	 Greek_EXTENDED}', "");
    Expect(1, 8191, '\P{^Is_Block:	 Greek_EXTENDED}', "");
    Expect(0, 8192, '\p{Is_Block:	 Greek_EXTENDED}', "");
    Expect(1, 8192, '\p{^Is_Block:	 Greek_EXTENDED}', "");
    Expect(1, 8192, '\P{Is_Block:	 Greek_EXTENDED}', "");
    Expect(0, 8192, '\P{^Is_Block:	 Greek_EXTENDED}', "");
    Error('\p{Is_Blk=/a/-	Greek_Ext}');
    Error('\P{Is_Blk=/a/-	Greek_Ext}');
    Expect(1, 8191, '\p{Is_Blk=greekext}', "");
    Expect(0, 8191, '\p{^Is_Blk=greekext}', "");
    Expect(0, 8191, '\P{Is_Blk=greekext}', "");
    Expect(1, 8191, '\P{^Is_Blk=greekext}', "");
    Expect(0, 8192, '\p{Is_Blk=greekext}', "");
    Expect(1, 8192, '\p{^Is_Blk=greekext}', "");
    Expect(1, 8192, '\P{Is_Blk=greekext}', "");
    Expect(0, 8192, '\P{^Is_Blk=greekext}', "");
    Expect(1, 8191, '\p{Is_Blk=--greek_Ext}', "");
    Expect(0, 8191, '\p{^Is_Blk=--greek_Ext}', "");
    Expect(0, 8191, '\P{Is_Blk=--greek_Ext}', "");
    Expect(1, 8191, '\P{^Is_Blk=--greek_Ext}', "");
    Expect(0, 8192, '\p{Is_Blk=--greek_Ext}', "");
    Expect(1, 8192, '\p{^Is_Blk=--greek_Ext}', "");
    Expect(1, 8192, '\P{Is_Blk=--greek_Ext}', "");
    Expect(0, 8192, '\P{^Is_Blk=--greek_Ext}', "");
    Error('\p{Block=_:=gujarati}');
    Error('\P{Block=_:=gujarati}');
    Expect(1, 2815, '\p{Block=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=gujarati}', "");
    Expect(0, 2815, '\p{^Block=gujarati}', "");
    Expect(0, 2815, '\P{Block=gujarati}', "");
    Expect(1, 2815, '\P{^Block=gujarati}', "");
    Expect(0, 2816, '\p{Block=gujarati}', "");
    Expect(1, 2816, '\p{^Block=gujarati}', "");
    Expect(1, 2816, '\P{Block=gujarati}', "");
    Expect(0, 2816, '\P{^Block=gujarati}', "");
    Expect(1, 2815, '\p{Block=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=- GUJARATI}', "");
    Expect(0, 2815, '\p{^Block=- GUJARATI}', "");
    Expect(0, 2815, '\P{Block=- GUJARATI}', "");
    Expect(1, 2815, '\P{^Block=- GUJARATI}', "");
    Expect(0, 2816, '\p{Block=- GUJARATI}', "");
    Expect(1, 2816, '\p{^Block=- GUJARATI}', "");
    Expect(1, 2816, '\P{Block=- GUJARATI}', "");
    Expect(0, 2816, '\P{^Block=- GUJARATI}', "");
    Error('\p{Blk=/a/_GUJARATI}');
    Error('\P{Blk=/a/_GUJARATI}');
    Expect(1, 2815, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Blk=gujarati}', "");
    Expect(0, 2815, '\P{Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Blk=gujarati}', "");
    Expect(0, 2816, '\p{Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Blk=gujarati}', "");
    Expect(1, 2816, '\P{Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Blk=gujarati}', "");
    Expect(1, 2815, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=--Gujarati}', "");
    Expect(0, 2815, '\p{^Blk=--Gujarati}', "");
    Expect(0, 2815, '\P{Blk=--Gujarati}', "");
    Expect(1, 2815, '\P{^Blk=--Gujarati}', "");
    Expect(0, 2816, '\p{Blk=--Gujarati}', "");
    Expect(1, 2816, '\p{^Blk=--Gujarati}', "");
    Expect(1, 2816, '\P{Blk=--Gujarati}', "");
    Expect(0, 2816, '\P{^Blk=--Gujarati}', "");
    Error('\p{Is_Block=	:=gujarati}');
    Error('\P{Is_Block=	:=gujarati}');
    Expect(1, 2815, '\p{Is_Block=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=gujarati}', "");
    Expect(1, 2815, '\p{Is_Block=	Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=	Gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=	Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=	Gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=	Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=	Gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=	Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=	Gujarati}', "");
    Error('\p{Is_Blk:	GUJARATI/a/}');
    Error('\P{Is_Blk:	GUJARATI/a/}');
    Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk=gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk=gujarati}', "");
    Expect(1, 2815, '\p{Is_Blk: -_Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk: -_Gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk: -_Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk: -_Gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk: -_Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk: -_Gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk: -_Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk: -_Gujarati}', "");
    Error('\p{Block=-:=gunjala_Gondi}');
    Error('\P{Block=-:=gunjala_Gondi}');
    Expect(1, 73135, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Block=  GUNJALA_GONDI}', "");
    Expect(0, 73135, '\p{^Block=  GUNJALA_GONDI}', "");
    Expect(0, 73135, '\P{Block=  GUNJALA_GONDI}', "");
    Expect(1, 73135, '\P{^Block=  GUNJALA_GONDI}', "");
    Expect(0, 73136, '\p{Block=  GUNJALA_GONDI}', "");
    Expect(1, 73136, '\p{^Block=  GUNJALA_GONDI}', "");
    Expect(1, 73136, '\P{Block=  GUNJALA_GONDI}', "");
    Expect(0, 73136, '\P{^Block=  GUNJALA_GONDI}', "");
    Error('\p{Blk=_Gunjala_Gondi/a/}');
    Error('\P{Blk=_Gunjala_Gondi/a/}');
    Expect(1, 73135, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=_	gunjala_gondi}', "");
    Expect(0, 73135, '\p{^Blk=_	gunjala_gondi}', "");
    Expect(0, 73135, '\P{Blk=_	gunjala_gondi}', "");
    Expect(1, 73135, '\P{^Blk=_	gunjala_gondi}', "");
    Expect(0, 73136, '\p{Blk=_	gunjala_gondi}', "");
    Expect(1, 73136, '\p{^Blk=_	gunjala_gondi}', "");
    Expect(1, 73136, '\P{Blk=_	gunjala_gondi}', "");
    Expect(0, 73136, '\P{^Blk=_	gunjala_gondi}', "");
    Error('\p{Is_Block= gunjala_GONDI/a/}');
    Error('\P{Is_Block= gunjala_GONDI/a/}');
    Expect(1, 73135, '\p{Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Block=- gunjala_gondi}', "");
    Expect(0, 73135, '\p{^Is_Block=- gunjala_gondi}', "");
    Expect(0, 73135, '\P{Is_Block=- gunjala_gondi}', "");
    Expect(1, 73135, '\P{^Is_Block=- gunjala_gondi}', "");
    Expect(0, 73136, '\p{Is_Block=- gunjala_gondi}', "");
    Expect(1, 73136, '\p{^Is_Block=- gunjala_gondi}', "");
    Expect(1, 73136, '\P{Is_Block=- gunjala_gondi}', "");
    Expect(0, 73136, '\P{^Is_Block=- gunjala_gondi}', "");
    Error('\p{Is_Blk= :=GUNJALA_GONDI}');
    Error('\P{Is_Blk= :=GUNJALA_GONDI}');
    Expect(1, 73135, '\p{Is_Blk:   gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Blk:   gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Blk:   gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Blk:   gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Blk:   gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Blk:   gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Blk:   gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Blk:   gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Blk= _Gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Is_Blk= _Gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Is_Blk= _Gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Is_Blk= _Gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Is_Blk= _Gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Is_Blk= _Gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Is_Blk= _Gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Is_Blk= _Gunjala_Gondi}', "");
    Error('\p{Block=	_gurmukhi:=}');
    Error('\P{Block=	_gurmukhi:=}');
    Expect(1, 2687, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block: __Gurmukhi}', "");
    Expect(0, 2687, '\p{^Block: __Gurmukhi}', "");
    Expect(0, 2687, '\P{Block: __Gurmukhi}', "");
    Expect(1, 2687, '\P{^Block: __Gurmukhi}', "");
    Expect(0, 2688, '\p{Block: __Gurmukhi}', "");
    Expect(1, 2688, '\p{^Block: __Gurmukhi}', "");
    Expect(1, 2688, '\P{Block: __Gurmukhi}', "");
    Expect(0, 2688, '\P{^Block: __Gurmukhi}', "");
    Error('\p{Blk=_GURMUKHI:=}');
    Error('\P{Blk=_GURMUKHI:=}');
    Expect(1, 2687, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=	_GURMUKHI}', "");
    Expect(0, 2687, '\p{^Blk=	_GURMUKHI}', "");
    Expect(0, 2687, '\P{Blk=	_GURMUKHI}', "");
    Expect(1, 2687, '\P{^Blk=	_GURMUKHI}', "");
    Expect(0, 2688, '\p{Blk=	_GURMUKHI}', "");
    Expect(1, 2688, '\p{^Blk=	_GURMUKHI}', "");
    Expect(1, 2688, '\P{Blk=	_GURMUKHI}', "");
    Expect(0, 2688, '\P{^Blk=	_GURMUKHI}', "");
    Error('\p{Is_Block=_ Gurmukhi/a/}');
    Error('\P{Is_Block=_ Gurmukhi/a/}');
    Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Block=_ GURMUKHI}', "");
    Expect(0, 2687, '\p{^Is_Block=_ GURMUKHI}', "");
    Expect(0, 2687, '\P{Is_Block=_ GURMUKHI}', "");
    Expect(1, 2687, '\P{^Is_Block=_ GURMUKHI}', "");
    Expect(0, 2688, '\p{Is_Block=_ GURMUKHI}', "");
    Expect(1, 2688, '\p{^Is_Block=_ GURMUKHI}', "");
    Expect(1, 2688, '\P{Is_Block=_ GURMUKHI}', "");
    Expect(0, 2688, '\P{^Is_Block=_ GURMUKHI}', "");
    Error('\p{Is_Blk=- gurmukhi:=}');
    Error('\P{Is_Blk=- gurmukhi:=}');
    Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Blk=-gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=-gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=-gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=-gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=-gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=-gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=-gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=-gurmukhi}', "");
    Error('\p{Block=-/a/Halfwidth_And_FULLWIDTH_FORMS}');
    Error('\P{Block=-/a/Halfwidth_And_FULLWIDTH_FORMS}');
    Expect(1, 65519, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(1, 65519, '\p{Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(0, 65519, '\p{^Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(0, 65519, '\P{Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(1, 65519, '\P{^Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(0, 65520, '\p{Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(1, 65520, '\p{^Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(1, 65520, '\P{Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Expect(0, 65520, '\P{^Block=	HALFWIDTH_and_Fullwidth_forms}', "");
    Error('\p{Blk=__half_And_full_forms:=}');
    Error('\P{Blk=__half_And_full_forms:=}');
    Expect(1, 65519, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(1, 65519, '\p{Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(1, 65519, '\p{Blk:   --HALF_AND_Full_Forms}', "");
    Expect(0, 65519, '\p{^Blk:   --HALF_AND_Full_Forms}', "");
    Expect(0, 65519, '\P{Blk:   --HALF_AND_Full_Forms}', "");
    Expect(1, 65519, '\P{^Blk:   --HALF_AND_Full_Forms}', "");
    Expect(0, 65520, '\p{Blk:   --HALF_AND_Full_Forms}', "");
    Expect(1, 65520, '\p{^Blk:   --HALF_AND_Full_Forms}', "");
    Expect(1, 65520, '\P{Blk:   --HALF_AND_Full_Forms}', "");
    Expect(0, 65520, '\P{^Blk:   --HALF_AND_Full_Forms}', "");
    Error('\p{Is_Block=-HALFWIDTH_And_Fullwidth_Forms:=}');
    Error('\P{Is_Block=-HALFWIDTH_And_Fullwidth_Forms:=}');
    Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(0, 65519, '\p{^Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(0, 65519, '\P{Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(1, 65519, '\P{^Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(0, 65520, '\p{Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(1, 65520, '\p{^Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(1, 65520, '\P{Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Expect(0, 65520, '\P{^Is_Block=-	halfwidth_AND_fullwidth_FORMS}', "");
    Error('\p{Is_Blk=_Half_and_FULL_FORMS:=}');
    Error('\P{Is_Blk=_Half_and_FULL_FORMS:=}');
    Expect(1, 65519, '\p{Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Is_Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Is_Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Is_Blk=	_half_And_full_Forms}', "");
    Expect(0, 65519, '\p{^Is_Blk=	_half_And_full_Forms}', "");
    Expect(0, 65519, '\P{Is_Blk=	_half_And_full_Forms}', "");
    Expect(1, 65519, '\P{^Is_Blk=	_half_And_full_Forms}', "");
    Expect(0, 65520, '\p{Is_Blk=	_half_And_full_Forms}', "");
    Expect(1, 65520, '\p{^Is_Blk=	_half_And_full_Forms}', "");
    Expect(1, 65520, '\P{Is_Blk=	_half_And_full_Forms}', "");
    Expect(0, 65520, '\P{^Is_Blk=	_half_And_full_Forms}', "");
    Error('\p{Block= COMBINING_Half_Marks:=}');
    Error('\P{Block= COMBINING_Half_Marks:=}');
    Expect(1, 65071, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(1, 65071, '\p{Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Block=  COMBINING_Half_MARKS}', "");
    Expect(0, 65071, '\p{^Block=  COMBINING_Half_MARKS}', "");
    Expect(0, 65071, '\P{Block=  COMBINING_Half_MARKS}', "");
    Expect(1, 65071, '\P{^Block=  COMBINING_Half_MARKS}', "");
    Expect(0, 65072, '\p{Block=  COMBINING_Half_MARKS}', "");
    Expect(1, 65072, '\p{^Block=  COMBINING_Half_MARKS}', "");
    Expect(1, 65072, '\P{Block=  COMBINING_Half_MARKS}', "");
    Expect(0, 65072, '\P{^Block=  COMBINING_Half_MARKS}', "");
    Error('\p{Blk=_/a/HALF_Marks}');
    Error('\P{Blk=_/a/HALF_Marks}');
    Expect(1, 65071, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(1, 65071, '\p{Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Blk= Half_marks}', "");
    Expect(0, 65071, '\p{^Blk= Half_marks}', "");
    Expect(0, 65071, '\P{Blk= Half_marks}', "");
    Expect(1, 65071, '\P{^Blk= Half_marks}', "");
    Expect(0, 65072, '\p{Blk= Half_marks}', "");
    Expect(1, 65072, '\p{^Blk= Half_marks}', "");
    Expect(1, 65072, '\P{Blk= Half_marks}', "");
    Expect(0, 65072, '\P{^Blk= Half_marks}', "");
    Error('\p{Is_Block=__combining_half_Marks/a/}');
    Error('\P{Is_Block=__combining_half_Marks/a/}');
    Expect(1, 65071, '\p{Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Is_Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Is_Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Is_Block=	Combining_HALF_Marks}', "");
    Expect(0, 65071, '\p{^Is_Block=	Combining_HALF_Marks}', "");
    Expect(0, 65071, '\P{Is_Block=	Combining_HALF_Marks}', "");
    Expect(1, 65071, '\P{^Is_Block=	Combining_HALF_Marks}', "");
    Expect(0, 65072, '\p{Is_Block=	Combining_HALF_Marks}', "");
    Expect(1, 65072, '\p{^Is_Block=	Combining_HALF_Marks}', "");
    Expect(1, 65072, '\P{Is_Block=	Combining_HALF_Marks}', "");
    Expect(0, 65072, '\P{^Is_Block=	Combining_HALF_Marks}', "");
    Error('\p{Is_Blk=_-Half_Marks/a/}');
    Error('\P{Is_Blk=_-Half_Marks/a/}');
    Expect(1, 65071, '\p{Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Is_Blk=	 half_marks}', "");
    Expect(0, 65071, '\p{^Is_Blk=	 half_marks}', "");
    Expect(0, 65071, '\P{Is_Blk=	 half_marks}', "");
    Expect(1, 65071, '\P{^Is_Blk=	 half_marks}', "");
    Expect(0, 65072, '\p{Is_Blk=	 half_marks}', "");
    Expect(1, 65072, '\p{^Is_Blk=	 half_marks}', "");
    Expect(1, 65072, '\P{Is_Blk=	 half_marks}', "");
    Expect(0, 65072, '\P{^Is_Blk=	 half_marks}', "");
    Error('\p{Block=/a/_ Hangul_syllables}');
    Error('\P{Block=/a/_ Hangul_syllables}');
    Expect(1, 55215, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(1, 55215, '\p{Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(1, 55215, '\p{Block= hangul_SYLLABLES}', "");
    Expect(0, 55215, '\p{^Block= hangul_SYLLABLES}', "");
    Expect(0, 55215, '\P{Block= hangul_SYLLABLES}', "");
    Expect(1, 55215, '\P{^Block= hangul_SYLLABLES}', "");
    Expect(0, 55216, '\p{Block= hangul_SYLLABLES}', "");
    Expect(1, 55216, '\p{^Block= hangul_SYLLABLES}', "");
    Expect(1, 55216, '\P{Block= hangul_SYLLABLES}', "");
    Expect(0, 55216, '\P{^Block= hangul_SYLLABLES}', "");
    Error('\p{Blk=-HANGUL/a/}');
    Error('\P{Blk=-HANGUL/a/}');
    Expect(1, 55215, '\p{Blk=:\AHangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\AHangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=hangul}', "");
    Expect(0, 55215, '\p{^Blk=hangul}', "");
    Expect(0, 55215, '\P{Blk=hangul}', "");
    Expect(1, 55215, '\P{^Blk=hangul}', "");
    Expect(0, 55216, '\p{Blk=hangul}', "");
    Expect(1, 55216, '\p{^Blk=hangul}', "");
    Expect(1, 55216, '\P{Blk=hangul}', "");
    Expect(0, 55216, '\P{^Blk=hangul}', "");
    Expect(1, 55215, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=- Hangul}', "");
    Expect(0, 55215, '\p{^Blk=- Hangul}', "");
    Expect(0, 55215, '\P{Blk=- Hangul}', "");
    Expect(1, 55215, '\P{^Blk=- Hangul}', "");
    Expect(0, 55216, '\p{Blk=- Hangul}', "");
    Expect(1, 55216, '\p{^Blk=- Hangul}', "");
    Expect(1, 55216, '\P{Blk=- Hangul}', "");
    Expect(0, 55216, '\P{^Blk=- Hangul}', "");
    Error('\p{Is_Block= Hangul_Syllables/a/}');
    Error('\P{Is_Block= Hangul_Syllables/a/}');
    Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(0, 55215, '\p{^Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(0, 55215, '\P{Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(1, 55215, '\P{^Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(0, 55216, '\p{Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(1, 55216, '\p{^Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(1, 55216, '\P{Is_Block:	-	hangul_SYLLABLES}', "");
    Expect(0, 55216, '\P{^Is_Block:	-	hangul_SYLLABLES}', "");
    Error('\p{Is_Blk= :=hangul}');
    Error('\P{Is_Blk= :=hangul}');
    Expect(1, 55215, '\p{Is_Blk=hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=hangul}', "");
    Expect(1, 55215, '\p{Is_Blk=-hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=-hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=-hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=-hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=-hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=-hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=-hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=-hangul}', "");
    Error('\p{Block: :=	_Hanifi_Rohingya}');
    Error('\P{Block: :=	_Hanifi_Rohingya}');
    Expect(1, 68927, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Block= -Hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Block= -Hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Block= -Hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Block= -Hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Block= -Hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Block= -Hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Block= -Hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Block= -Hanifi_Rohingya}', "");
    Error('\p{Blk:	/a/-_Hanifi_rohingya}');
    Error('\P{Blk:	/a/-_Hanifi_rohingya}');
    Expect(1, 68927, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=_ HANIFI_Rohingya}', "");
    Expect(0, 68927, '\p{^Blk=_ HANIFI_Rohingya}', "");
    Expect(0, 68927, '\P{Blk=_ HANIFI_Rohingya}', "");
    Expect(1, 68927, '\P{^Blk=_ HANIFI_Rohingya}', "");
    Expect(0, 68928, '\p{Blk=_ HANIFI_Rohingya}', "");
    Expect(1, 68928, '\p{^Blk=_ HANIFI_Rohingya}', "");
    Expect(1, 68928, '\P{Blk=_ HANIFI_Rohingya}', "");
    Expect(0, 68928, '\P{^Blk=_ HANIFI_Rohingya}', "");
    Error('\p{Is_Block=:=-hanifi_rohingya}');
    Error('\P{Is_Block=:=-hanifi_rohingya}');
    Expect(1, 68927, '\p{Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\p{^Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\P{Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(1, 68927, '\P{^Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\p{Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\p{^Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\P{Is_Block=	 Hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\P{^Is_Block=	 Hanifi_ROHINGYA}', "");
    Error('\p{Is_Blk=:=-	hanifi_Rohingya}');
    Error('\P{Is_Blk=:=-	hanifi_Rohingya}');
    Expect(1, 68927, '\p{Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\p{^Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(0, 68927, '\P{Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(1, 68927, '\P{^Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\p{Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\p{^Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(1, 68928, '\P{Is_Blk=_-hanifi_ROHINGYA}', "");
    Expect(0, 68928, '\P{^Is_Blk=_-hanifi_ROHINGYA}', "");
    Error('\p{Block=  hanunoo:=}');
    Error('\P{Block=  hanunoo:=}');
    Expect(1, 5951, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Block=hanunoo}', "");
    Expect(0, 5951, '\P{Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Block=hanunoo}', "");
    Expect(0, 5952, '\p{Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Block=hanunoo}', "");
    Expect(1, 5952, '\P{Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Block=hanunoo}', "");
    Expect(1, 5951, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block= hanunoo}', "");
    Expect(0, 5951, '\p{^Block= hanunoo}', "");
    Expect(0, 5951, '\P{Block= hanunoo}', "");
    Expect(1, 5951, '\P{^Block= hanunoo}', "");
    Expect(0, 5952, '\p{Block= hanunoo}', "");
    Expect(1, 5952, '\p{^Block= hanunoo}', "");
    Expect(1, 5952, '\P{Block= hanunoo}', "");
    Expect(0, 5952, '\P{^Block= hanunoo}', "");
    Error('\p{Blk= /a/hanunoo}');
    Error('\P{Blk= /a/hanunoo}');
    Expect(1, 5951, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=-	hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=-	hanunoo}', "");
    Expect(0, 5951, '\P{Blk=-	hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=-	hanunoo}', "");
    Expect(0, 5952, '\p{Blk=-	hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=-	hanunoo}', "");
    Expect(1, 5952, '\P{Blk=-	hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=-	hanunoo}', "");
    Error('\p{Is_Block=  hanunoo:=}');
    Error('\P{Is_Block=  hanunoo:=}');
    Expect(1, 5951, '\p{Is_Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Block=	_Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block=	_Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block=	_Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block=	_Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block=	_Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block=	_Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block=	_Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block=	_Hanunoo}', "");
    Error('\p{Is_Blk=- HANUNOO/a/}');
    Error('\P{Is_Blk=- HANUNOO/a/}');
    Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Blk=__Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=__Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=__Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=__Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=__Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=__Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=__Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=__Hanunoo}', "");
    Error('\p{Block=:=__hatran}');
    Error('\P{Block=:=__hatran}');
    Expect(1, 67839, '\p{Block=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Block=hatran}', "");
    Expect(0, 67839, '\p{^Block=hatran}', "");
    Expect(0, 67839, '\P{Block=hatran}', "");
    Expect(1, 67839, '\P{^Block=hatran}', "");
    Expect(0, 67840, '\p{Block=hatran}', "");
    Expect(1, 67840, '\p{^Block=hatran}', "");
    Expect(1, 67840, '\P{Block=hatran}', "");
    Expect(0, 67840, '\P{^Block=hatran}', "");
    Expect(1, 67839, '\p{Block=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Block=Hatran}', "");
    Expect(0, 67839, '\p{^Block=Hatran}', "");
    Expect(0, 67839, '\P{Block=Hatran}', "");
    Expect(1, 67839, '\P{^Block=Hatran}', "");
    Expect(0, 67840, '\p{Block=Hatran}', "");
    Expect(1, 67840, '\p{^Block=Hatran}', "");
    Expect(1, 67840, '\P{Block=Hatran}', "");
    Expect(0, 67840, '\P{^Block=Hatran}', "");
    Error('\p{Blk=_ hatran:=}');
    Error('\P{Blk=_ hatran:=}');
    Expect(1, 67839, '\p{Blk=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=hatran}', "");
    Expect(0, 67839, '\p{^Blk=hatran}', "");
    Expect(0, 67839, '\P{Blk=hatran}', "");
    Expect(1, 67839, '\P{^Blk=hatran}', "");
    Expect(0, 67840, '\p{Blk=hatran}', "");
    Expect(1, 67840, '\p{^Blk=hatran}', "");
    Expect(1, 67840, '\P{Blk=hatran}', "");
    Expect(0, 67840, '\P{^Blk=hatran}', "");
    Expect(1, 67839, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=-_HATRAN}', "");
    Expect(0, 67839, '\p{^Blk=-_HATRAN}', "");
    Expect(0, 67839, '\P{Blk=-_HATRAN}', "");
    Expect(1, 67839, '\P{^Blk=-_HATRAN}', "");
    Expect(0, 67840, '\p{Blk=-_HATRAN}', "");
    Expect(1, 67840, '\p{^Blk=-_HATRAN}', "");
    Expect(1, 67840, '\P{Blk=-_HATRAN}', "");
    Expect(0, 67840, '\P{^Blk=-_HATRAN}', "");
    Error('\p{Is_Block=	hatran:=}');
    Error('\P{Is_Block=	hatran:=}');
    Expect(1, 67839, '\p{Is_Block=hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=hatran}', "");
    Expect(0, 67839, '\P{Is_Block=hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=hatran}', "");
    Expect(0, 67840, '\p{Is_Block=hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=hatran}', "");
    Expect(1, 67840, '\P{Is_Block=hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=hatran}', "");
    Expect(1, 67839, '\p{Is_Block= -Hatran}', "");
    Expect(0, 67839, '\p{^Is_Block= -Hatran}', "");
    Expect(0, 67839, '\P{Is_Block= -Hatran}', "");
    Expect(1, 67839, '\P{^Is_Block= -Hatran}', "");
    Expect(0, 67840, '\p{Is_Block= -Hatran}', "");
    Expect(1, 67840, '\p{^Is_Block= -Hatran}', "");
    Expect(1, 67840, '\P{Is_Block= -Hatran}', "");
    Expect(0, 67840, '\P{^Is_Block= -Hatran}', "");
    Error('\p{Is_Blk=- Hatran/a/}');
    Error('\P{Is_Blk=- Hatran/a/}');
    Expect(1, 67839, '\p{Is_Blk=hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=hatran}', "");
    Expect(1, 67839, '\p{Is_Blk=-_Hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=-_Hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=-_Hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=-_Hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=-_Hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=-_Hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=-_Hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=-_Hatran}', "");
    Error('\p{Block=/a/- Hebrew}');
    Error('\P{Block=/a/- Hebrew}');
    Expect(1, 1535, '\p{Block=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Block:hebrew}', "");
    Expect(0, 1535, '\p{^Block:hebrew}', "");
    Expect(0, 1535, '\P{Block:hebrew}', "");
    Expect(1, 1535, '\P{^Block:hebrew}', "");
    Expect(0, 1536, '\p{Block:hebrew}', "");
    Expect(1, 1536, '\p{^Block:hebrew}', "");
    Expect(1, 1536, '\P{Block:hebrew}', "");
    Expect(0, 1536, '\P{^Block:hebrew}', "");
    Expect(1, 1535, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Block=	Hebrew}', "");
    Expect(0, 1535, '\p{^Block=	Hebrew}', "");
    Expect(0, 1535, '\P{Block=	Hebrew}', "");
    Expect(1, 1535, '\P{^Block=	Hebrew}', "");
    Expect(0, 1536, '\p{Block=	Hebrew}', "");
    Expect(1, 1536, '\p{^Block=	Hebrew}', "");
    Expect(1, 1536, '\P{Block=	Hebrew}', "");
    Expect(0, 1536, '\P{^Block=	Hebrew}', "");
    Error('\p{Blk=:=-Hebrew}');
    Error('\P{Blk=:=-Hebrew}');
    Expect(1, 1535, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Blk=hebrew}', "");
    Expect(0, 1535, '\P{Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Blk=hebrew}', "");
    Expect(0, 1536, '\p{Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Blk=hebrew}', "");
    Expect(1, 1536, '\P{Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Blk=hebrew}', "");
    Expect(1, 1535, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk= -hebrew}', "");
    Expect(0, 1535, '\p{^Blk= -hebrew}', "");
    Expect(0, 1535, '\P{Blk= -hebrew}', "");
    Expect(1, 1535, '\P{^Blk= -hebrew}', "");
    Expect(0, 1536, '\p{Blk= -hebrew}', "");
    Expect(1, 1536, '\p{^Blk= -hebrew}', "");
    Expect(1, 1536, '\P{Blk= -hebrew}', "");
    Expect(0, 1536, '\P{^Blk= -hebrew}', "");
    Error('\p{Is_Block=/a/	-Hebrew}');
    Error('\P{Is_Block=/a/	-Hebrew}');
    Expect(1, 1535, '\p{Is_Block=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=hebrew}', "");
    Expect(1, 1535, '\p{Is_Block= hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block= hebrew}', "");
    Expect(0, 1535, '\P{Is_Block= hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block= hebrew}', "");
    Expect(0, 1536, '\p{Is_Block= hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block= hebrew}', "");
    Expect(1, 1536, '\P{Is_Block= hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block= hebrew}', "");
    Error('\p{Is_Blk= HEBREW:=}');
    Error('\P{Is_Blk= HEBREW:=}');
    Expect(1, 1535, '\p{Is_Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=hebrew}', "");
    Expect(1, 1535, '\p{Is_Blk:-HEBREW}', "");
    Expect(0, 1535, '\p{^Is_Blk:-HEBREW}', "");
    Expect(0, 1535, '\P{Is_Blk:-HEBREW}', "");
    Expect(1, 1535, '\P{^Is_Blk:-HEBREW}', "");
    Expect(0, 1536, '\p{Is_Blk:-HEBREW}', "");
    Expect(1, 1536, '\p{^Is_Blk:-HEBREW}', "");
    Expect(1, 1536, '\P{Is_Blk:-HEBREW}', "");
    Expect(0, 1536, '\P{^Is_Blk:-HEBREW}', "");
    Error('\p{Block=-	High_private_use_Surrogates:=}');
    Error('\P{Block=-	High_private_use_Surrogates:=}');
    Expect(1, 56319, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(1, 56319, '\p{Block: _high_private_Use_Surrogates}', "");
    Expect(0, 56319, '\p{^Block: _high_private_Use_Surrogates}', "");
    Expect(0, 56319, '\P{Block: _high_private_Use_Surrogates}', "");
    Expect(1, 56319, '\P{^Block: _high_private_Use_Surrogates}', "");
    Expect(0, 57344, '\p{Block: _high_private_Use_Surrogates}', "");
    Expect(1, 57344, '\p{^Block: _high_private_Use_Surrogates}', "");
    Expect(1, 57344, '\P{Block: _high_private_Use_Surrogates}', "");
    Expect(0, 57344, '\P{^Block: _high_private_Use_Surrogates}', "");
    Error('\p{Blk=:=high_PU_surrogates}');
    Error('\P{Blk=:=high_PU_surrogates}');
    Expect(1, 56319, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=-High_PU_Surrogates}', "");
    Expect(0, 56319, '\p{^Blk=-High_PU_Surrogates}', "");
    Expect(0, 56319, '\P{Blk=-High_PU_Surrogates}', "");
    Expect(1, 56319, '\P{^Blk=-High_PU_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=-High_PU_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=-High_PU_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=-High_PU_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=-High_PU_Surrogates}', "");
    Error('\p{Is_Block=	:=High_PRIVATE_Use_Surrogates}');
    Error('\P{Is_Block=	:=High_PRIVATE_Use_Surrogates}');
    Expect(1, 56319, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(0, 56319, '\p{^Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(0, 56319, '\P{Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(1, 56319, '\P{^Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=_-high_Private_use_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=_-high_Private_use_Surrogates}', "");
    Error('\p{Is_Blk=/a/high_pu_SURROGATES}');
    Error('\P{Is_Blk=/a/high_pu_SURROGATES}');
    Expect(1, 56319, '\p{Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Is_Blk=	High_PU_SURROGATES}', "");
    Expect(0, 56319, '\p{^Is_Blk=	High_PU_SURROGATES}', "");
    Expect(0, 56319, '\P{Is_Blk=	High_PU_SURROGATES}', "");
    Expect(1, 56319, '\P{^Is_Blk=	High_PU_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Blk=	High_PU_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Blk=	High_PU_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Blk=	High_PU_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Blk=	High_PU_SURROGATES}', "");
    Error('\p{Block=	:=HIGH_Surrogates}');
    Error('\P{Block=	:=HIGH_Surrogates}');
    Expect(1, 56191, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=HIGH_Surrogates}', "");
    Expect(0, 56191, '\p{^Block=HIGH_Surrogates}', "");
    Expect(0, 56191, '\P{Block=HIGH_Surrogates}', "");
    Expect(1, 56191, '\P{^Block=HIGH_Surrogates}', "");
    Expect(0, 57344, '\p{Block=HIGH_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=HIGH_Surrogates}', "");
    Expect(1, 57344, '\P{Block=HIGH_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=HIGH_Surrogates}', "");
    Error('\p{Blk=- High_Surrogates:=}');
    Error('\P{Blk=- High_Surrogates:=}');
    Expect(1, 56191, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk= High_SURROGATES}', "");
    Expect(0, 56191, '\p{^Blk= High_SURROGATES}', "");
    Expect(0, 56191, '\P{Blk= High_SURROGATES}', "");
    Expect(1, 56191, '\P{^Blk= High_SURROGATES}', "");
    Expect(0, 57344, '\p{Blk= High_SURROGATES}', "");
    Expect(1, 57344, '\p{^Blk= High_SURROGATES}', "");
    Expect(1, 57344, '\P{Blk= High_SURROGATES}', "");
    Expect(0, 57344, '\P{^Blk= High_SURROGATES}', "");
    Error('\p{Is_Block=  High_surrogates:=}');
    Error('\P{Is_Block=  High_surrogates:=}');
    Expect(1, 56191, '\p{Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Block=-High_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=-High_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Block=-High_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=-High_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=-High_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=-High_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=-High_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=-High_Surrogates}', "");
    Error('\p{Is_Blk=	:=High_Surrogates}');
    Error('\P{Is_Blk=	:=High_Surrogates}');
    Expect(1, 56191, '\p{Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Blk=--high_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=--high_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=--high_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=--high_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=--high_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=--high_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=--high_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=--high_Surrogates}', "");
    Error('\p{Block=- Hiragana:=}');
    Error('\P{Block=- Hiragana:=}');
    Expect(1, 12447, '\p{Block=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=hiragana}', "");
    Expect(0, 12447, '\p{^Block=hiragana}', "");
    Expect(0, 12447, '\P{Block=hiragana}', "");
    Expect(1, 12447, '\P{^Block=hiragana}', "");
    Expect(0, 12448, '\p{Block=hiragana}', "");
    Expect(1, 12448, '\p{^Block=hiragana}', "");
    Expect(1, 12448, '\P{Block=hiragana}', "");
    Expect(0, 12448, '\P{^Block=hiragana}', "");
    Expect(1, 12447, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=Hiragana}', "");
    Expect(0, 12447, '\p{^Block=Hiragana}', "");
    Expect(0, 12447, '\P{Block=Hiragana}', "");
    Expect(1, 12447, '\P{^Block=Hiragana}', "");
    Expect(0, 12448, '\p{Block=Hiragana}', "");
    Expect(1, 12448, '\p{^Block=Hiragana}', "");
    Expect(1, 12448, '\P{Block=Hiragana}', "");
    Expect(0, 12448, '\P{^Block=Hiragana}', "");
    Error('\p{Blk=	hiragana:=}');
    Error('\P{Blk=	hiragana:=}');
    Expect(1, 12447, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Blk=hiragana}', "");
    Expect(0, 12447, '\P{Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Blk=hiragana}', "");
    Expect(0, 12448, '\p{Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Blk=hiragana}', "");
    Expect(1, 12448, '\P{Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Blk=hiragana}', "");
    Expect(1, 12447, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=	-HIRAGANA}', "");
    Expect(0, 12447, '\p{^Blk=	-HIRAGANA}', "");
    Expect(0, 12447, '\P{Blk=	-HIRAGANA}', "");
    Expect(1, 12447, '\P{^Blk=	-HIRAGANA}', "");
    Expect(0, 12448, '\p{Blk=	-HIRAGANA}', "");
    Expect(1, 12448, '\p{^Blk=	-HIRAGANA}', "");
    Expect(1, 12448, '\P{Blk=	-HIRAGANA}', "");
    Expect(0, 12448, '\P{^Blk=	-HIRAGANA}', "");
    Error('\p{Is_Block=-:=Hiragana}');
    Error('\P{Is_Block=-:=Hiragana}');
    Expect(1, 12447, '\p{Is_Block=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=hiragana}', "");
    Expect(1, 12447, '\p{Is_Block=- HIRAGANA}', "");
    Expect(0, 12447, '\p{^Is_Block=- HIRAGANA}', "");
    Expect(0, 12447, '\P{Is_Block=- HIRAGANA}', "");
    Expect(1, 12447, '\P{^Is_Block=- HIRAGANA}', "");
    Expect(0, 12448, '\p{Is_Block=- HIRAGANA}', "");
    Expect(1, 12448, '\p{^Is_Block=- HIRAGANA}', "");
    Expect(1, 12448, '\P{Is_Block=- HIRAGANA}', "");
    Expect(0, 12448, '\P{^Is_Block=- HIRAGANA}', "");
    Error('\p{Is_Blk:   /a/ Hiragana}');
    Error('\P{Is_Blk:   /a/ Hiragana}');
    Expect(1, 12447, '\p{Is_Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=hiragana}', "");
    Expect(1, 12447, '\p{Is_Blk= hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk= hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk= hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk= hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk= hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk= hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk= hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk= hiragana}', "");
    Error('\p{Block=-	ideographic_Description_characters:=}');
    Error('\P{Block=-	ideographic_Description_characters:=}');
    Expect(1, 12287, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(1, 12287, '\p{Block:   	ideographic_Description_characters}', "");
    Expect(0, 12287, '\p{^Block:   	ideographic_Description_characters}', "");
    Expect(0, 12287, '\P{Block:   	ideographic_Description_characters}', "");
    Expect(1, 12287, '\P{^Block:   	ideographic_Description_characters}', "");
    Expect(0, 12288, '\p{Block:   	ideographic_Description_characters}', "");
    Expect(1, 12288, '\p{^Block:   	ideographic_Description_characters}', "");
    Expect(1, 12288, '\P{Block:   	ideographic_Description_characters}', "");
    Expect(0, 12288, '\P{^Block:   	ideographic_Description_characters}', "");
    Error('\p{Blk=/a/_	IDC}');
    Error('\P{Blk=/a/_	IDC}');
    Expect(1, 12287, '\p{Blk=:\AIDC\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\AIDC\z:}', "");;
    Expect(1, 12287, '\p{Blk=idc}', "");
    Expect(0, 12287, '\p{^Blk=idc}', "");
    Expect(0, 12287, '\P{Blk=idc}', "");
    Expect(1, 12287, '\P{^Blk=idc}', "");
    Expect(0, 12288, '\p{Blk=idc}', "");
    Expect(1, 12288, '\p{^Blk=idc}', "");
    Expect(1, 12288, '\P{Blk=idc}', "");
    Expect(0, 12288, '\P{^Blk=idc}', "");
    Expect(1, 12287, '\p{Blk=:\Aidc\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\Aidc\z:}', "");;
    Expect(1, 12287, '\p{Blk= IDC}', "");
    Expect(0, 12287, '\p{^Blk= IDC}', "");
    Expect(0, 12287, '\P{Blk= IDC}', "");
    Expect(1, 12287, '\P{^Blk= IDC}', "");
    Expect(0, 12288, '\p{Blk= IDC}', "");
    Expect(1, 12288, '\p{^Blk= IDC}', "");
    Expect(1, 12288, '\P{Blk= IDC}', "");
    Expect(0, 12288, '\P{^Blk= IDC}', "");
    Error('\p{Is_Block=	ideographic_DESCRIPTION_characters/a/}');
    Error('\P{Is_Block=	ideographic_DESCRIPTION_characters/a/}');
    Expect(1, 12287, '\p{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12287, '\p{^Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12287, '\P{Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12287, '\P{^Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12288, '\p{Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12288, '\p{^Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(1, 12288, '\P{Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Expect(0, 12288, '\P{^Is_Block=  IDEOGRAPHIC_Description_characters}', "");
    Error('\p{Is_Blk=	IDC/a/}');
    Error('\P{Is_Blk=	IDC/a/}');
    Expect(1, 12287, '\p{Is_Blk=idc}', "");
    Expect(0, 12287, '\p{^Is_Blk=idc}', "");
    Expect(0, 12287, '\P{Is_Blk=idc}', "");
    Expect(1, 12287, '\P{^Is_Blk=idc}', "");
    Expect(0, 12288, '\p{Is_Blk=idc}', "");
    Expect(1, 12288, '\p{^Is_Blk=idc}', "");
    Expect(1, 12288, '\P{Is_Blk=idc}', "");
    Expect(0, 12288, '\P{^Is_Blk=idc}', "");
    Expect(1, 12287, '\p{Is_Blk: 	_idc}', "");
    Expect(0, 12287, '\p{^Is_Blk: 	_idc}', "");
    Expect(0, 12287, '\P{Is_Blk: 	_idc}', "");
    Expect(1, 12287, '\P{^Is_Blk: 	_idc}', "");
    Expect(0, 12288, '\p{Is_Blk: 	_idc}', "");
    Expect(1, 12288, '\p{^Is_Blk: 	_idc}', "");
    Expect(1, 12288, '\P{Is_Blk: 	_idc}', "");
    Expect(0, 12288, '\P{^Is_Blk: 	_idc}', "");
    Error('\p{Block=		Ideographic_SYMBOLS_And_Punctuation/a/}');
    Error('\P{Block=		Ideographic_SYMBOLS_And_Punctuation/a/}');
    Expect(1, 94207, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(1, 94207, '\p{Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Block: _ideographic_symbols_and_PUNCTUATION}', "");
    Error('\p{Blk=/a/ _Ideographic_Symbols}');
    Error('\P{Blk=/a/ _Ideographic_Symbols}');
    Expect(1, 94207, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=-_Ideographic_Symbols}', "");
    Expect(0, 94207, '\p{^Blk=-_Ideographic_Symbols}', "");
    Expect(0, 94207, '\P{Blk=-_Ideographic_Symbols}', "");
    Expect(1, 94207, '\P{^Blk=-_Ideographic_Symbols}', "");
    Expect(0, 94208, '\p{Blk=-_Ideographic_Symbols}', "");
    Expect(1, 94208, '\p{^Blk=-_Ideographic_Symbols}', "");
    Expect(1, 94208, '\P{Blk=-_Ideographic_Symbols}', "");
    Expect(0, 94208, '\P{^Blk=-_Ideographic_Symbols}', "");
    Error('\p{Is_Block=_IDEOGRAPHIC_SYMBOLS_and_Punctuation:=}');
    Error('\P{Is_Block=_IDEOGRAPHIC_SYMBOLS_and_Punctuation:=}');
    Expect(1, 94207, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(0, 94207, '\p{^Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(0, 94207, '\P{Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(1, 94207, '\P{^Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(0, 94208, '\p{Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(1, 94208, '\p{^Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(1, 94208, '\P{Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Expect(0, 94208, '\P{^Is_Block:   ideographic_SYMBOLS_and_PUNCTUATION}', "");
    Error('\p{Is_Blk= -ideographic_Symbols:=}');
    Error('\P{Is_Blk= -ideographic_Symbols:=}');
    Expect(1, 94207, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\P{Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\p{Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\P{Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=	IDEOGRAPHIC_Symbols}', "");
    Error('\p{Block=:= -Imperial_Aramaic}');
    Error('\P{Block=:= -Imperial_Aramaic}');
    Expect(1, 67679, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Block: imperialaramaic}', "");
    Expect(0, 67679, '\p{^Block: imperialaramaic}', "");
    Expect(0, 67679, '\P{Block: imperialaramaic}', "");
    Expect(1, 67679, '\P{^Block: imperialaramaic}', "");
    Expect(0, 67680, '\p{Block: imperialaramaic}', "");
    Expect(1, 67680, '\p{^Block: imperialaramaic}', "");
    Expect(1, 67680, '\P{Block: imperialaramaic}', "");
    Expect(0, 67680, '\P{^Block: imperialaramaic}', "");
    Expect(1, 67679, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Block=	imperial_aramaic}', "");
    Expect(0, 67679, '\p{^Block=	imperial_aramaic}', "");
    Expect(0, 67679, '\P{Block=	imperial_aramaic}', "");
    Expect(1, 67679, '\P{^Block=	imperial_aramaic}', "");
    Expect(0, 67680, '\p{Block=	imperial_aramaic}', "");
    Expect(1, 67680, '\p{^Block=	imperial_aramaic}', "");
    Expect(1, 67680, '\P{Block=	imperial_aramaic}', "");
    Expect(0, 67680, '\P{^Block=	imperial_aramaic}', "");
    Error('\p{Blk=__Imperial_Aramaic:=}');
    Error('\P{Blk=__Imperial_Aramaic:=}');
    Expect(1, 67679, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk: imperialaramaic}', "");
    Expect(0, 67679, '\p{^Blk: imperialaramaic}', "");
    Expect(0, 67679, '\P{Blk: imperialaramaic}', "");
    Expect(1, 67679, '\P{^Blk: imperialaramaic}', "");
    Expect(0, 67680, '\p{Blk: imperialaramaic}', "");
    Expect(1, 67680, '\p{^Blk: imperialaramaic}', "");
    Expect(1, 67680, '\P{Blk: imperialaramaic}', "");
    Expect(0, 67680, '\P{^Blk: imperialaramaic}', "");
    Expect(1, 67679, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk= IMPERIAL_Aramaic}', "");
    Expect(0, 67679, '\p{^Blk= IMPERIAL_Aramaic}', "");
    Expect(0, 67679, '\P{Blk= IMPERIAL_Aramaic}', "");
    Expect(1, 67679, '\P{^Blk= IMPERIAL_Aramaic}', "");
    Expect(0, 67680, '\p{Blk= IMPERIAL_Aramaic}', "");
    Expect(1, 67680, '\p{^Blk= IMPERIAL_Aramaic}', "");
    Expect(1, 67680, '\P{Blk= IMPERIAL_Aramaic}', "");
    Expect(0, 67680, '\P{^Blk= IMPERIAL_Aramaic}', "");
    Error('\p{Is_Block:-/a/Imperial_ARAMAIC}');
    Error('\P{Is_Block:-/a/Imperial_ARAMAIC}');
    Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Block=-Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=-Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Block=-Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=-Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Block=-Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=-Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Block=-Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=-Imperial_Aramaic}', "");
    Error('\p{Is_Blk=:=	Imperial_Aramaic}');
    Error('\P{Is_Blk=:=	Imperial_Aramaic}');
    Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Blk=		Imperial_Aramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=		Imperial_Aramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=		Imperial_Aramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=		Imperial_Aramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=		Imperial_Aramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=		Imperial_Aramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=		Imperial_Aramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=		Imperial_Aramaic}', "");
    Error('\p{Block= :=COMMON_Indic_Number_forms}');
    Error('\P{Block= :=COMMON_Indic_Number_forms}');
    Expect(1, 43071, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Block=- common_Indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\p{^Block=- common_Indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\P{Block=- common_Indic_NUMBER_Forms}', "");
    Expect(1, 43071, '\P{^Block=- common_Indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\p{Block=- common_Indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\p{^Block=- common_Indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\P{Block=- common_Indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\P{^Block=- common_Indic_NUMBER_Forms}', "");
    Error('\p{Blk=__INDIC_Number_Forms/a/}');
    Error('\P{Blk=__INDIC_Number_Forms/a/}');
    Expect(1, 43071, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Blk=  Indic_number_FORMS}', "");
    Expect(0, 43071, '\p{^Blk=  Indic_number_FORMS}', "");
    Expect(0, 43071, '\P{Blk=  Indic_number_FORMS}', "");
    Expect(1, 43071, '\P{^Blk=  Indic_number_FORMS}', "");
    Expect(0, 43072, '\p{Blk=  Indic_number_FORMS}', "");
    Expect(1, 43072, '\p{^Blk=  Indic_number_FORMS}', "");
    Expect(1, 43072, '\P{Blk=  Indic_number_FORMS}', "");
    Expect(0, 43072, '\P{^Blk=  Indic_number_FORMS}', "");
    Error('\p{Is_Block=_ COMMON_indic_Number_forms:=}');
    Error('\P{Is_Block=_ COMMON_indic_Number_forms:=}');
    Expect(1, 43071, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(0, 43071, '\p{^Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(0, 43071, '\P{Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(1, 43071, '\P{^Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(0, 43072, '\p{Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(1, 43072, '\p{^Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(1, 43072, '\P{Is_Block=__COMMON_Indic_Number_Forms}', "");
    Expect(0, 43072, '\P{^Is_Block=__COMMON_Indic_Number_Forms}', "");
    Error('\p{Is_Blk=/a/INDIC_number_Forms}');
    Error('\P{Is_Blk=/a/INDIC_number_Forms}');
    Expect(1, 43071, '\p{Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(0, 43071, '\p{^Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(0, 43071, '\P{Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(1, 43071, '\P{^Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(0, 43072, '\p{Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(1, 43072, '\p{^Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(1, 43072, '\P{Is_Blk=-_Indic_NUMBER_forms}', "");
    Expect(0, 43072, '\P{^Is_Blk=-_Indic_NUMBER_forms}', "");
    Error('\p{Block= :=Indic_SIYAQ_NUMBERS}');
    Error('\P{Block= :=Indic_SIYAQ_NUMBERS}');
    Expect(1, 126143, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(0, 126143, '\p{^Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(0, 126143, '\P{Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(1, 126143, '\P{^Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(0, 126144, '\p{Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(1, 126144, '\p{^Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(1, 126144, '\P{Block=-_Indic_siyaq_NUMBERS}', "");
    Expect(0, 126144, '\P{^Block=-_Indic_siyaq_NUMBERS}', "");
    Error('\p{Blk=-:=Indic_siyaq_Numbers}');
    Error('\P{Blk=-:=Indic_siyaq_Numbers}');
    Expect(1, 126143, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\p{^Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\P{Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(1, 126143, '\P{^Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\p{Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\p{^Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\P{Blk= 	INDIC_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\P{^Blk= 	INDIC_SIYAQ_Numbers}', "");
    Error('\p{Is_Block=_/a/indic_Siyaq_Numbers}');
    Error('\P{Is_Block=_/a/indic_Siyaq_Numbers}');
    Expect(1, 126143, '\p{Is_Block: indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Block: indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Block: indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Block: indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Block: indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Block: indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Block: indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Block: indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\p{^Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(0, 126143, '\P{Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(1, 126143, '\P{^Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\p{Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\p{^Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(1, 126144, '\P{Is_Block=  Indic_SIYAQ_Numbers}', "");
    Expect(0, 126144, '\P{^Is_Block=  Indic_SIYAQ_Numbers}', "");
    Error('\p{Is_Blk=/a/ _Indic_siyaq_numbers}');
    Error('\P{Is_Blk=/a/ _Indic_siyaq_numbers}');
    Expect(1, 126143, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(0, 126143, '\p{^Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(0, 126143, '\P{Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(1, 126143, '\P{^Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(0, 126144, '\p{Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(1, 126144, '\p{^Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(1, 126144, '\P{Is_Blk=  Indic_Siyaq_Numbers}', "");
    Expect(0, 126144, '\P{^Is_Blk=  Indic_Siyaq_Numbers}', "");
    Error('\p{Block=- Inscriptional_Pahlavi/a/}');
    Error('\P{Block=- Inscriptional_Pahlavi/a/}');
    Expect(1, 68479, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=_Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\p{^Block=_Inscriptional_pahlavi}', "");
    Expect(0, 68479, '\P{Block=_Inscriptional_pahlavi}', "");
    Expect(1, 68479, '\P{^Block=_Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\p{Block=_Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\p{^Block=_Inscriptional_pahlavi}', "");
    Expect(1, 68480, '\P{Block=_Inscriptional_pahlavi}', "");
    Expect(0, 68480, '\P{^Block=_Inscriptional_pahlavi}', "");
    Error('\p{Blk:	 	INSCRIPTIONAL_Pahlavi/a/}');
    Error('\P{Blk:	 	INSCRIPTIONAL_Pahlavi/a/}');
    Expect(1, 68479, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk:	inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Blk:	inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Blk:	inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Blk:	inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Blk:	inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Blk:	inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Blk:	inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Blk:	inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=_-Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Blk=_-Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Blk=_-Inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Blk=_-Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Blk=_-Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Blk=_-Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Blk=_-Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Blk=_-Inscriptional_Pahlavi}', "");
    Error('\p{Is_Block=/a/Inscriptional_Pahlavi}');
    Error('\P{Is_Block=/a/Inscriptional_Pahlavi}');
    Expect(1, 68479, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(0, 68479, '\P{Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\p{Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(1, 68480, '\P{Is_Block=	Inscriptional_Pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block=	Inscriptional_Pahlavi}', "");
    Error('\p{Is_Blk=/a/	Inscriptional_Pahlavi}');
    Error('\P{Is_Blk=/a/	Inscriptional_Pahlavi}');
    Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\P{Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\p{Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\P{Is_Blk= _Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Is_Blk= _Inscriptional_PAHLAVI}', "");
    Error('\p{Block:/a/-Inscriptional_parthian}');
    Error('\P{Block:/a/-Inscriptional_parthian}');
    Expect(1, 68447, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Block=--inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Block=--inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Block=--inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Block=--inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Block=--inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Block=--inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Block=--inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Block=--inscriptional_parthian}', "");
    Error('\p{Blk=-:=Inscriptional_Parthian}');
    Error('\P{Blk=-:=Inscriptional_Parthian}');
    Expect(1, 68447, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Blk:   inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Blk:   inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Blk:   inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Blk:   inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Blk:   inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Blk:   inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Blk:   inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Blk:   inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=- Inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Blk=- Inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Blk=- Inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Blk=- Inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Blk=- Inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Blk=- Inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Blk=- Inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Blk=- Inscriptional_parthian}', "");
    Error('\p{Is_Block=-/a/Inscriptional_parthian}');
    Error('\P{Is_Block=-/a/Inscriptional_parthian}');
    Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\p{^Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\P{Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(1, 68447, '\P{^Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\p{Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\p{^Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\P{Is_Block=	 Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\P{^Is_Block=	 Inscriptional_PARTHIAN}', "");
    Error('\p{Is_Blk:   /a/	 inscriptional_Parthian}');
    Error('\P{Is_Blk:   /a/	 inscriptional_Parthian}');
    Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Blk= _inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Blk= _inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Is_Blk= _inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Blk= _inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Is_Blk= _inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Blk= _inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Is_Blk= _inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Blk= _inscriptional_Parthian}', "");
    Error('\p{Block:    /a/ipa_Extensions}');
    Error('\P{Block:    /a/ipa_Extensions}');
    Expect(1, 687, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(1, 687, '\p{Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Block=ipaextensions}', "");
    Expect(0, 687, '\P{Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Block=ipaextensions}', "");
    Expect(0, 688, '\p{Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Block=ipaextensions}', "");
    Expect(1, 688, '\P{Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Block=ipaextensions}', "");
    Expect(1, 687, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(1, 687, '\p{Block=	 IPA_extensions}', "");
    Expect(0, 687, '\p{^Block=	 IPA_extensions}', "");
    Expect(0, 687, '\P{Block=	 IPA_extensions}', "");
    Expect(1, 687, '\P{^Block=	 IPA_extensions}', "");
    Expect(0, 688, '\p{Block=	 IPA_extensions}', "");
    Expect(1, 688, '\p{^Block=	 IPA_extensions}', "");
    Expect(1, 688, '\P{Block=	 IPA_extensions}', "");
    Expect(0, 688, '\P{^Block=	 IPA_extensions}', "");
    Error('\p{Blk=-_IPA_Ext/a/}');
    Error('\P{Blk=-_IPA_Ext/a/}');
    Expect(1, 687, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(1, 687, '\p{Blk=ipaext}', "");
    Expect(0, 687, '\p{^Blk=ipaext}', "");
    Expect(0, 687, '\P{Blk=ipaext}', "");
    Expect(1, 687, '\P{^Blk=ipaext}', "");
    Expect(0, 688, '\p{Blk=ipaext}', "");
    Expect(1, 688, '\p{^Blk=ipaext}', "");
    Expect(1, 688, '\P{Blk=ipaext}', "");
    Expect(0, 688, '\P{^Blk=ipaext}', "");
    Expect(1, 687, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(1, 687, '\p{Blk=_ IPA_Ext}', "");
    Expect(0, 687, '\p{^Blk=_ IPA_Ext}', "");
    Expect(0, 687, '\P{Blk=_ IPA_Ext}', "");
    Expect(1, 687, '\P{^Blk=_ IPA_Ext}', "");
    Expect(0, 688, '\p{Blk=_ IPA_Ext}', "");
    Expect(1, 688, '\p{^Blk=_ IPA_Ext}', "");
    Expect(1, 688, '\P{Blk=_ IPA_Ext}', "");
    Expect(0, 688, '\P{^Blk=_ IPA_Ext}', "");
    Error('\p{Is_Block=:= _IPA_extensions}');
    Error('\P{Is_Block=:= _IPA_extensions}');
    Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
    Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
    Expect(0, 688, '\p{Is_Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Is_Block=ipaextensions}', "");
    Expect(1, 688, '\P{Is_Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Is_Block=ipaextensions}', "");
    Expect(1, 687, '\p{Is_Block= _IPA_EXTENSIONS}', "");
    Expect(0, 687, '\p{^Is_Block= _IPA_EXTENSIONS}', "");
    Expect(0, 687, '\P{Is_Block= _IPA_EXTENSIONS}', "");
    Expect(1, 687, '\P{^Is_Block= _IPA_EXTENSIONS}', "");
    Expect(0, 688, '\p{Is_Block= _IPA_EXTENSIONS}', "");
    Expect(1, 688, '\p{^Is_Block= _IPA_EXTENSIONS}', "");
    Expect(1, 688, '\P{Is_Block= _IPA_EXTENSIONS}', "");
    Expect(0, 688, '\P{^Is_Block= _IPA_EXTENSIONS}', "");
    Error('\p{Is_Blk=_/a/ipa_Ext}');
    Error('\P{Is_Blk=_/a/ipa_Ext}');
    Expect(1, 687, '\p{Is_Blk=ipaext}', "");
    Expect(0, 687, '\p{^Is_Blk=ipaext}', "");
    Expect(0, 687, '\P{Is_Blk=ipaext}', "");
    Expect(1, 687, '\P{^Is_Blk=ipaext}', "");
    Expect(0, 688, '\p{Is_Blk=ipaext}', "");
    Expect(1, 688, '\p{^Is_Blk=ipaext}', "");
    Expect(1, 688, '\P{Is_Blk=ipaext}', "");
    Expect(0, 688, '\P{^Is_Blk=ipaext}', "");
    Expect(1, 687, '\p{Is_Blk: - IPA_Ext}', "");
    Expect(0, 687, '\p{^Is_Blk: - IPA_Ext}', "");
    Expect(0, 687, '\P{Is_Blk: - IPA_Ext}', "");
    Expect(1, 687, '\P{^Is_Blk: - IPA_Ext}', "");
    Expect(0, 688, '\p{Is_Blk: - IPA_Ext}', "");
    Expect(1, 688, '\p{^Is_Blk: - IPA_Ext}', "");
    Expect(1, 688, '\P{Is_Blk: - IPA_Ext}', "");
    Expect(0, 688, '\P{^Is_Blk: - IPA_Ext}', "");
    Error('\p{Block=:=-_hangul_JAMO}');
    Error('\P{Block=:=-_hangul_JAMO}');
    Expect(1, 4607, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(1, 4607, '\p{Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(1, 4607, '\p{Block=		hangul_JAMO}', "");
    Expect(0, 4607, '\p{^Block=		hangul_JAMO}', "");
    Expect(0, 4607, '\P{Block=		hangul_JAMO}', "");
    Expect(1, 4607, '\P{^Block=		hangul_JAMO}', "");
    Expect(0, 4608, '\p{Block=		hangul_JAMO}', "");
    Expect(1, 4608, '\p{^Block=		hangul_JAMO}', "");
    Expect(1, 4608, '\P{Block=		hangul_JAMO}', "");
    Expect(0, 4608, '\P{^Block=		hangul_JAMO}', "");
    Error('\p{Blk=	Jamo:=}');
    Error('\P{Blk=	Jamo:=}');
    Expect(1, 4607, '\p{Blk=:\AJamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\AJamo\z:}', "");;
    Expect(1, 4607, '\p{Blk: jamo}', "");
    Expect(0, 4607, '\p{^Blk: jamo}', "");
    Expect(0, 4607, '\P{Blk: jamo}', "");
    Expect(1, 4607, '\P{^Blk: jamo}', "");
    Expect(0, 4608, '\p{Blk: jamo}', "");
    Expect(1, 4608, '\p{^Blk: jamo}', "");
    Expect(1, 4608, '\P{Blk: jamo}', "");
    Expect(0, 4608, '\P{^Blk: jamo}', "");
    Expect(1, 4607, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(1, 4607, '\p{Blk:   Jamo}', "");
    Expect(0, 4607, '\p{^Blk:   Jamo}', "");
    Expect(0, 4607, '\P{Blk:   Jamo}', "");
    Expect(1, 4607, '\P{^Blk:   Jamo}', "");
    Expect(0, 4608, '\p{Blk:   Jamo}', "");
    Expect(1, 4608, '\p{^Blk:   Jamo}', "");
    Expect(1, 4608, '\P{Blk:   Jamo}', "");
    Expect(0, 4608, '\P{^Blk:   Jamo}', "");
    Error('\p{Is_Block=	-HANGUL_Jamo:=}');
    Error('\P{Is_Block=	-HANGUL_Jamo:=}');
    Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Is_Block= _Hangul_Jamo}', "");
    Expect(0, 4607, '\p{^Is_Block= _Hangul_Jamo}', "");
    Expect(0, 4607, '\P{Is_Block= _Hangul_Jamo}', "");
    Expect(1, 4607, '\P{^Is_Block= _Hangul_Jamo}', "");
    Expect(0, 4608, '\p{Is_Block= _Hangul_Jamo}', "");
    Expect(1, 4608, '\p{^Is_Block= _Hangul_Jamo}', "");
    Expect(1, 4608, '\P{Is_Block= _Hangul_Jamo}', "");
    Expect(0, 4608, '\P{^Is_Block= _Hangul_Jamo}', "");
    Error('\p{Is_Blk=_:=jamo}');
    Error('\P{Is_Blk=_:=jamo}');
    Expect(1, 4607, '\p{Is_Blk: jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk: jamo}', "");
    Expect(0, 4607, '\P{Is_Blk: jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk: jamo}', "");
    Expect(0, 4608, '\p{Is_Blk: jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk: jamo}', "");
    Expect(1, 4608, '\P{Is_Blk: jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk: jamo}', "");
    Expect(1, 4607, '\p{Is_Blk=_jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk=_jamo}', "");
    Expect(0, 4607, '\P{Is_Blk=_jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk=_jamo}', "");
    Expect(0, 4608, '\p{Is_Blk=_jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk=_jamo}', "");
    Expect(1, 4608, '\P{Is_Blk=_jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk=_jamo}', "");
    Error('\p{Block=:=_ HANGUL_Jamo_extended_a}');
    Error('\P{Block=:=_ HANGUL_Jamo_extended_a}');
    Expect(1, 43391, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(0, 43392, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(1, 43391, '\p{Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(0, 43392, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(1, 43391, '\p{Block= Hangul_JAMO_Extended_a}', "");
    Expect(0, 43391, '\p{^Block= Hangul_JAMO_Extended_a}', "");
    Expect(0, 43391, '\P{Block= Hangul_JAMO_Extended_a}', "");
    Expect(1, 43391, '\P{^Block= Hangul_JAMO_Extended_a}', "");
    Expect(0, 43392, '\p{Block= Hangul_JAMO_Extended_a}', "");
    Expect(1, 43392, '\p{^Block= Hangul_JAMO_Extended_a}', "");
    Expect(1, 43392, '\P{Block= Hangul_JAMO_Extended_a}', "");
    Expect(0, 43392, '\P{^Block= Hangul_JAMO_Extended_a}', "");
    Error('\p{Blk=_/a/Jamo_Ext_A}');
    Error('\P{Blk=_/a/Jamo_Ext_A}');
    Expect(1, 43391, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(1, 43391, '\p{Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(1, 43391, '\p{Blk=	Jamo_EXT_A}', "");
    Expect(0, 43391, '\p{^Blk=	Jamo_EXT_A}', "");
    Expect(0, 43391, '\P{Blk=	Jamo_EXT_A}', "");
    Expect(1, 43391, '\P{^Blk=	Jamo_EXT_A}', "");
    Expect(0, 43392, '\p{Blk=	Jamo_EXT_A}', "");
    Expect(1, 43392, '\p{^Blk=	Jamo_EXT_A}', "");
    Expect(1, 43392, '\P{Blk=	Jamo_EXT_A}', "");
    Expect(0, 43392, '\P{^Blk=	Jamo_EXT_A}', "");
    Error('\p{Is_Block= Hangul_jamo_EXTENDED_A:=}');
    Error('\P{Is_Block= Hangul_jamo_EXTENDED_A:=}');
    Expect(1, 43391, '\p{Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Is_Block: hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Is_Block: hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(0, 43391, '\p{^Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(0, 43391, '\P{Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(1, 43391, '\P{^Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(0, 43392, '\p{Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(1, 43392, '\p{^Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(1, 43392, '\P{Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Expect(0, 43392, '\P{^Is_Block=_-Hangul_JAMO_Extended_A}', "");
    Error('\p{Is_Blk=/a/ jamo_ext_A}');
    Error('\P{Is_Blk=/a/ jamo_ext_A}');
    Expect(1, 43391, '\p{Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Is_Blk=-JAMO_Ext_A}', "");
    Expect(0, 43391, '\p{^Is_Blk=-JAMO_Ext_A}', "");
    Expect(0, 43391, '\P{Is_Blk=-JAMO_Ext_A}', "");
    Expect(1, 43391, '\P{^Is_Blk=-JAMO_Ext_A}', "");
    Expect(0, 43392, '\p{Is_Blk=-JAMO_Ext_A}', "");
    Expect(1, 43392, '\p{^Is_Blk=-JAMO_Ext_A}', "");
    Expect(1, 43392, '\P{Is_Blk=-JAMO_Ext_A}', "");
    Expect(0, 43392, '\P{^Is_Blk=-JAMO_Ext_A}', "");
    Error('\p{Block=:=-	Hangul_Jamo_Extended_b}');
    Error('\P{Block=:=-	Hangul_Jamo_Extended_b}');
    Expect(1, 55295, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(1, 55295, '\p{Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(0, 55295, '\p{^Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(0, 55295, '\P{Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(1, 55295, '\P{^Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(0, 57344, '\p{Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(1, 57344, '\p{^Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(1, 57344, '\P{Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Expect(0, 57344, '\P{^Block=	-HANGUL_jamo_EXTENDED_B}', "");
    Error('\p{Blk=/a/-	Jamo_ext_B}');
    Error('\P{Blk=/a/-	Jamo_ext_B}');
    Expect(1, 55295, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(1, 55295, '\p{Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(1, 55295, '\p{Blk=  Jamo_ext_b}', "");
    Expect(0, 55295, '\p{^Blk=  Jamo_ext_b}', "");
    Expect(0, 55295, '\P{Blk=  Jamo_ext_b}', "");
    Expect(1, 55295, '\P{^Blk=  Jamo_ext_b}', "");
    Expect(0, 57344, '\p{Blk=  Jamo_ext_b}', "");
    Expect(1, 57344, '\p{^Blk=  Jamo_ext_b}', "");
    Expect(1, 57344, '\P{Blk=  Jamo_ext_b}', "");
    Expect(0, 57344, '\P{^Blk=  Jamo_ext_b}', "");
    Error('\p{Is_Block=:=hangul_JAMO_extended_B}');
    Error('\P{Is_Block=:=hangul_JAMO_extended_B}');
    Expect(1, 55295, '\p{Is_Block:	hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Is_Block:	hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Is_Block:	hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Is_Block:	hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Is_Block:	hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Is_Block:	hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Is_Block:	hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Is_Block:	hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(0, 55295, '\p{^Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(0, 55295, '\P{Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(1, 55295, '\P{^Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(0, 57344, '\p{Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(1, 57344, '\p{^Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(1, 57344, '\P{Is_Block=--hangul_Jamo_extended_B}', "");
    Expect(0, 57344, '\P{^Is_Block=--hangul_Jamo_extended_B}', "");
    Error('\p{Is_Blk=-	jamo_ext_B:=}');
    Error('\P{Is_Blk=-	jamo_ext_B:=}');
    Expect(1, 55295, '\p{Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Is_Blk=Jamo_EXT_B}', "");
    Expect(0, 55295, '\p{^Is_Blk=Jamo_EXT_B}', "");
    Expect(0, 55295, '\P{Is_Blk=Jamo_EXT_B}', "");
    Expect(1, 55295, '\P{^Is_Blk=Jamo_EXT_B}', "");
    Expect(0, 57344, '\p{Is_Blk=Jamo_EXT_B}', "");
    Expect(1, 57344, '\p{^Is_Blk=Jamo_EXT_B}', "");
    Expect(1, 57344, '\P{Is_Blk=Jamo_EXT_B}', "");
    Expect(0, 57344, '\P{^Is_Blk=Jamo_EXT_B}', "");
    Error('\p{Block: :=-JAVANESE}');
    Error('\P{Block: :=-JAVANESE}');
    Expect(1, 43487, '\p{Block=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=javanese}', "");
    Expect(0, 43487, '\p{^Block=javanese}', "");
    Expect(0, 43487, '\P{Block=javanese}', "");
    Expect(1, 43487, '\P{^Block=javanese}', "");
    Expect(0, 43488, '\p{Block=javanese}', "");
    Expect(1, 43488, '\p{^Block=javanese}', "");
    Expect(1, 43488, '\P{Block=javanese}', "");
    Expect(0, 43488, '\P{^Block=javanese}', "");
    Expect(1, 43487, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=-javanese}', "");
    Expect(0, 43487, '\p{^Block=-javanese}', "");
    Expect(0, 43487, '\P{Block=-javanese}', "");
    Expect(1, 43487, '\P{^Block=-javanese}', "");
    Expect(0, 43488, '\p{Block=-javanese}', "");
    Expect(1, 43488, '\p{^Block=-javanese}', "");
    Expect(1, 43488, '\P{Block=-javanese}', "");
    Expect(0, 43488, '\P{^Block=-javanese}', "");
    Error('\p{Blk=/a/ _javanese}');
    Error('\P{Blk=/a/ _javanese}');
    Expect(1, 43487, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=javanese}', "");
    Expect(0, 43487, '\p{^Blk=javanese}', "");
    Expect(0, 43487, '\P{Blk=javanese}', "");
    Expect(1, 43487, '\P{^Blk=javanese}', "");
    Expect(0, 43488, '\p{Blk=javanese}', "");
    Expect(1, 43488, '\p{^Blk=javanese}', "");
    Expect(1, 43488, '\P{Blk=javanese}', "");
    Expect(0, 43488, '\P{^Blk=javanese}', "");
    Expect(1, 43487, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=- Javanese}', "");
    Expect(0, 43487, '\p{^Blk=- Javanese}', "");
    Expect(0, 43487, '\P{Blk=- Javanese}', "");
    Expect(1, 43487, '\P{^Blk=- Javanese}', "");
    Expect(0, 43488, '\p{Blk=- Javanese}', "");
    Expect(1, 43488, '\p{^Blk=- Javanese}', "");
    Expect(1, 43488, '\P{Blk=- Javanese}', "");
    Expect(0, 43488, '\P{^Blk=- Javanese}', "");
    Error('\p{Is_Block=	:=Javanese}');
    Error('\P{Is_Block=	:=Javanese}');
    Expect(1, 43487, '\p{Is_Block=javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=javanese}', "");
    Expect(0, 43487, '\P{Is_Block=javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=javanese}', "");
    Expect(0, 43488, '\p{Is_Block=javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=javanese}', "");
    Expect(1, 43488, '\P{Is_Block=javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=javanese}', "");
    Expect(1, 43487, '\p{Is_Block: - javanese}', "");
    Expect(0, 43487, '\p{^Is_Block: - javanese}', "");
    Expect(0, 43487, '\P{Is_Block: - javanese}', "");
    Expect(1, 43487, '\P{^Is_Block: - javanese}', "");
    Expect(0, 43488, '\p{Is_Block: - javanese}', "");
    Expect(1, 43488, '\p{^Is_Block: - javanese}', "");
    Expect(1, 43488, '\P{Is_Block: - javanese}', "");
    Expect(0, 43488, '\P{^Is_Block: - javanese}', "");
    Error('\p{Is_Blk=_-javanese/a/}');
    Error('\P{Is_Blk=_-javanese/a/}');
    Expect(1, 43487, '\p{Is_Blk=javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=javanese}', "");
    Expect(1, 43487, '\p{Is_Blk=Javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=Javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=Javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=Javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=Javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=Javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=Javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=Javanese}', "");
    Error('\p{Block=_/a/Kaithi}');
    Error('\P{Block=_/a/Kaithi}');
    Expect(1, 69839, '\p{Block=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=kaithi}', "");
    Expect(0, 69839, '\p{^Block=kaithi}', "");
    Expect(0, 69839, '\P{Block=kaithi}', "");
    Expect(1, 69839, '\P{^Block=kaithi}', "");
    Expect(0, 69840, '\p{Block=kaithi}', "");
    Expect(1, 69840, '\p{^Block=kaithi}', "");
    Expect(1, 69840, '\P{Block=kaithi}', "");
    Expect(0, 69840, '\P{^Block=kaithi}', "");
    Expect(1, 69839, '\p{Block=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=	_Kaithi}', "");
    Expect(0, 69839, '\p{^Block=	_Kaithi}', "");
    Expect(0, 69839, '\P{Block=	_Kaithi}', "");
    Expect(1, 69839, '\P{^Block=	_Kaithi}', "");
    Expect(0, 69840, '\p{Block=	_Kaithi}', "");
    Expect(1, 69840, '\p{^Block=	_Kaithi}', "");
    Expect(1, 69840, '\P{Block=	_Kaithi}', "");
    Expect(0, 69840, '\P{^Block=	_Kaithi}', "");
    Error('\p{Blk: :=Kaithi}');
    Error('\P{Blk: :=Kaithi}');
    Expect(1, 69839, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Blk=kaithi}', "");
    Expect(0, 69839, '\P{Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Blk=kaithi}', "");
    Expect(0, 69840, '\p{Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Blk=kaithi}', "");
    Expect(1, 69840, '\P{Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Blk=kaithi}', "");
    Expect(1, 69839, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=	-kaithi}', "");
    Expect(0, 69839, '\p{^Blk=	-kaithi}', "");
    Expect(0, 69839, '\P{Blk=	-kaithi}', "");
    Expect(1, 69839, '\P{^Blk=	-kaithi}', "");
    Expect(0, 69840, '\p{Blk=	-kaithi}', "");
    Expect(1, 69840, '\p{^Blk=	-kaithi}', "");
    Expect(1, 69840, '\P{Blk=	-kaithi}', "");
    Expect(0, 69840, '\P{^Blk=	-kaithi}', "");
    Error('\p{Is_Block=/a/-	Kaithi}');
    Error('\P{Is_Block=/a/-	Kaithi}');
    Expect(1, 69839, '\p{Is_Block=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=kaithi}', "");
    Expect(1, 69839, '\p{Is_Block=  Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=  Kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=  Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=  Kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=  Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=  Kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=  Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=  Kaithi}', "");
    Error('\p{Is_Blk:	 _Kaithi:=}');
    Error('\P{Is_Blk:	 _Kaithi:=}');
    Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=kaithi}', "");
    Expect(1, 69839, '\p{Is_Blk=  Kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=  Kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=  Kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=  Kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=  Kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=  Kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=  Kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=  Kaithi}', "");
    Error('\p{Block= /a/Kana_EXTENDED_A}');
    Error('\P{Block= /a/Kana_EXTENDED_A}');
    Expect(1, 110895, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(0, 110896, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(1, 110895, '\p{Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(0, 110896, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(1, 110895, '\p{Block= _Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\p{^Block= _Kana_EXTENDED_A}', "");
    Expect(0, 110895, '\P{Block= _Kana_EXTENDED_A}', "");
    Expect(1, 110895, '\P{^Block= _Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\p{Block= _Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\p{^Block= _Kana_EXTENDED_A}', "");
    Expect(1, 110896, '\P{Block= _Kana_EXTENDED_A}', "");
    Expect(0, 110896, '\P{^Block= _Kana_EXTENDED_A}', "");
    Error('\p{Blk=	/a/Kana_Ext_A}');
    Error('\P{Blk=	/a/Kana_Ext_A}');
    Expect(1, 110895, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(1, 110895, '\p{Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(1, 110895, '\p{Blk=	Kana_Ext_A}', "");
    Expect(0, 110895, '\p{^Blk=	Kana_Ext_A}', "");
    Expect(0, 110895, '\P{Blk=	Kana_Ext_A}', "");
    Expect(1, 110895, '\P{^Blk=	Kana_Ext_A}', "");
    Expect(0, 110896, '\p{Blk=	Kana_Ext_A}', "");
    Expect(1, 110896, '\p{^Blk=	Kana_Ext_A}', "");
    Expect(1, 110896, '\P{Blk=	Kana_Ext_A}', "");
    Expect(0, 110896, '\P{^Blk=	Kana_Ext_A}', "");
    Error('\p{Is_Block=		Kana_extended_A:=}');
    Error('\P{Is_Block=		Kana_extended_A:=}');
    Expect(1, 110895, '\p{Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Is_Block=  Kana_Extended_A}', "");
    Expect(0, 110895, '\p{^Is_Block=  Kana_Extended_A}', "");
    Expect(0, 110895, '\P{Is_Block=  Kana_Extended_A}', "");
    Expect(1, 110895, '\P{^Is_Block=  Kana_Extended_A}', "");
    Expect(0, 110896, '\p{Is_Block=  Kana_Extended_A}', "");
    Expect(1, 110896, '\p{^Is_Block=  Kana_Extended_A}', "");
    Expect(1, 110896, '\P{Is_Block=  Kana_Extended_A}', "");
    Expect(0, 110896, '\P{^Is_Block=  Kana_Extended_A}', "");
    Error('\p{Is_Blk=:=		Kana_EXT_a}');
    Error('\P{Is_Blk=:=		Kana_EXT_a}');
    Expect(1, 110895, '\p{Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Is_Blk:		-Kana_ext_A}', "");
    Expect(0, 110895, '\p{^Is_Blk:		-Kana_ext_A}', "");
    Expect(0, 110895, '\P{Is_Blk:		-Kana_ext_A}', "");
    Expect(1, 110895, '\P{^Is_Blk:		-Kana_ext_A}', "");
    Expect(0, 110896, '\p{Is_Blk:		-Kana_ext_A}', "");
    Expect(1, 110896, '\p{^Is_Blk:		-Kana_ext_A}', "");
    Expect(1, 110896, '\P{Is_Blk:		-Kana_ext_A}', "");
    Expect(0, 110896, '\P{^Is_Blk:		-Kana_ext_A}', "");
    Error('\p{Block=/a/_ Kana_supplement}');
    Error('\P{Block=/a/_ Kana_supplement}');
    Expect(1, 110847, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(1, 110847, '\p{Block:	kanasupplement}', "");
    Expect(0, 110847, '\p{^Block:	kanasupplement}', "");
    Expect(0, 110847, '\P{Block:	kanasupplement}', "");
    Expect(1, 110847, '\P{^Block:	kanasupplement}', "");
    Expect(0, 110848, '\p{Block:	kanasupplement}', "");
    Expect(1, 110848, '\p{^Block:	kanasupplement}', "");
    Expect(1, 110848, '\P{Block:	kanasupplement}', "");
    Expect(0, 110848, '\P{^Block:	kanasupplement}', "");
    Expect(1, 110847, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(1, 110847, '\p{Block=  Kana_Supplement}', "");
    Expect(0, 110847, '\p{^Block=  Kana_Supplement}', "");
    Expect(0, 110847, '\P{Block=  Kana_Supplement}', "");
    Expect(1, 110847, '\P{^Block=  Kana_Supplement}', "");
    Expect(0, 110848, '\p{Block=  Kana_Supplement}', "");
    Expect(1, 110848, '\p{^Block=  Kana_Supplement}', "");
    Expect(1, 110848, '\P{Block=  Kana_Supplement}', "");
    Expect(0, 110848, '\P{^Block=  Kana_Supplement}', "");
    Error('\p{Blk=:=__Kana_SUP}');
    Error('\P{Blk=:=__Kana_SUP}');
    Expect(1, 110847, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(1, 110847, '\p{Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Blk=kanasup}', "");
    Expect(0, 110847, '\P{Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Blk=kanasup}', "");
    Expect(0, 110848, '\p{Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Blk=kanasup}', "");
    Expect(1, 110848, '\P{Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Blk=kanasup}', "");
    Expect(1, 110847, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(1, 110847, '\p{Blk=--Kana_SUP}', "");
    Expect(0, 110847, '\p{^Blk=--Kana_SUP}', "");
    Expect(0, 110847, '\P{Blk=--Kana_SUP}', "");
    Expect(1, 110847, '\P{^Blk=--Kana_SUP}', "");
    Expect(0, 110848, '\p{Blk=--Kana_SUP}', "");
    Expect(1, 110848, '\p{^Blk=--Kana_SUP}', "");
    Expect(1, 110848, '\P{Blk=--Kana_SUP}', "");
    Expect(0, 110848, '\P{^Blk=--Kana_SUP}', "");
    Error('\p{Is_Block=	:=Kana_supplement}');
    Error('\P{Is_Block=	:=Kana_supplement}');
    Expect(1, 110847, '\p{Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Is_Block=_Kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Is_Block=_Kana_SUPPLEMENT}', "");
    Error('\p{Is_Blk= -Kana_Sup/a/}');
    Error('\P{Is_Blk= -Kana_Sup/a/}');
    Expect(1, 110847, '\p{Is_Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Is_Blk=kanasup}', "");
    Expect(0, 110847, '\P{Is_Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Is_Blk=kanasup}', "");
    Expect(0, 110848, '\p{Is_Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Is_Blk=kanasup}', "");
    Expect(1, 110848, '\P{Is_Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Is_Blk=kanasup}', "");
    Expect(1, 110847, '\p{Is_Blk= Kana_sup}', "");
    Expect(0, 110847, '\p{^Is_Blk= Kana_sup}', "");
    Expect(0, 110847, '\P{Is_Blk= Kana_sup}', "");
    Expect(1, 110847, '\P{^Is_Blk= Kana_sup}', "");
    Expect(0, 110848, '\p{Is_Blk= Kana_sup}', "");
    Expect(1, 110848, '\p{^Is_Blk= Kana_sup}', "");
    Expect(1, 110848, '\P{Is_Blk= Kana_sup}', "");
    Expect(0, 110848, '\P{^Is_Blk= Kana_sup}', "");
    Error('\p{Block=_/a/kanbun}');
    Error('\P{Block=_/a/kanbun}');
    Expect(1, 12703, '\p{Block=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Block=kanbun}', "");
    Expect(0, 12703, '\p{^Block=kanbun}', "");
    Expect(0, 12703, '\P{Block=kanbun}', "");
    Expect(1, 12703, '\P{^Block=kanbun}', "");
    Expect(0, 12704, '\p{Block=kanbun}', "");
    Expect(1, 12704, '\p{^Block=kanbun}', "");
    Expect(1, 12704, '\P{Block=kanbun}', "");
    Expect(0, 12704, '\P{^Block=kanbun}', "");
    Expect(1, 12703, '\p{Block=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Block=_	Kanbun}', "");
    Expect(0, 12703, '\p{^Block=_	Kanbun}', "");
    Expect(0, 12703, '\P{Block=_	Kanbun}', "");
    Expect(1, 12703, '\P{^Block=_	Kanbun}', "");
    Expect(0, 12704, '\p{Block=_	Kanbun}', "");
    Expect(1, 12704, '\p{^Block=_	Kanbun}', "");
    Expect(1, 12704, '\P{Block=_	Kanbun}', "");
    Expect(0, 12704, '\P{^Block=_	Kanbun}', "");
    Error('\p{Blk=--Kanbun/a/}');
    Error('\P{Blk=--Kanbun/a/}');
    Expect(1, 12703, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk:   kanbun}', "");
    Expect(0, 12703, '\p{^Blk:   kanbun}', "");
    Expect(0, 12703, '\P{Blk:   kanbun}', "");
    Expect(1, 12703, '\P{^Blk:   kanbun}', "");
    Expect(0, 12704, '\p{Blk:   kanbun}', "");
    Expect(1, 12704, '\p{^Blk:   kanbun}', "");
    Expect(1, 12704, '\P{Blk:   kanbun}', "");
    Expect(0, 12704, '\P{^Blk:   kanbun}', "");
    Expect(1, 12703, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=_-KANBUN}', "");
    Expect(0, 12703, '\p{^Blk=_-KANBUN}', "");
    Expect(0, 12703, '\P{Blk=_-KANBUN}', "");
    Expect(1, 12703, '\P{^Blk=_-KANBUN}', "");
    Expect(0, 12704, '\p{Blk=_-KANBUN}', "");
    Expect(1, 12704, '\p{^Blk=_-KANBUN}', "");
    Expect(1, 12704, '\P{Blk=_-KANBUN}', "");
    Expect(0, 12704, '\P{^Blk=_-KANBUN}', "");
    Error('\p{Is_Block: :=_	Kanbun}');
    Error('\P{Is_Block: :=_	Kanbun}');
    Expect(1, 12703, '\p{Is_Block=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=kanbun}', "");
    Expect(1, 12703, '\p{Is_Block= -KANBUN}', "");
    Expect(0, 12703, '\p{^Is_Block= -KANBUN}', "");
    Expect(0, 12703, '\P{Is_Block= -KANBUN}', "");
    Expect(1, 12703, '\P{^Is_Block= -KANBUN}', "");
    Expect(0, 12704, '\p{Is_Block= -KANBUN}', "");
    Expect(1, 12704, '\p{^Is_Block= -KANBUN}', "");
    Expect(1, 12704, '\P{Is_Block= -KANBUN}', "");
    Expect(0, 12704, '\P{^Is_Block= -KANBUN}', "");
    Error('\p{Is_Blk=:=  Kanbun}');
    Error('\P{Is_Blk=:=  Kanbun}');
    Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=kanbun}', "");
    Expect(1, 12703, '\p{Is_Blk=- KANBUN}', "");
    Expect(0, 12703, '\p{^Is_Blk=- KANBUN}', "");
    Expect(0, 12703, '\P{Is_Blk=- KANBUN}', "");
    Expect(1, 12703, '\P{^Is_Blk=- KANBUN}', "");
    Expect(0, 12704, '\p{Is_Blk=- KANBUN}', "");
    Expect(1, 12704, '\p{^Is_Blk=- KANBUN}', "");
    Expect(1, 12704, '\P{Is_Blk=- KANBUN}', "");
    Expect(0, 12704, '\P{^Is_Blk=- KANBUN}', "");
    Error('\p{Block=	kangxi_RADICALS/a/}');
    Error('\P{Block=	kangxi_RADICALS/a/}');
    Expect(1, 12255, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(1, 12255, '\p{Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(1, 12255, '\p{Block=		Kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Block=		Kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Block=		Kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Block=		Kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Block=		Kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Block=		Kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Block=		Kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Block=		Kangxi_Radicals}', "");
    Error('\p{Blk=-_kangxi:=}');
    Error('\P{Blk=-_kangxi:=}');
    Expect(1, 12255, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Blk=kangxi}', "");
    Expect(0, 12255, '\P{Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Blk=kangxi}', "");
    Expect(0, 12256, '\p{Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Blk=kangxi}', "");
    Expect(1, 12256, '\P{Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Blk=kangxi}', "");
    Expect(1, 12255, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk= 	Kangxi}', "");
    Expect(0, 12255, '\p{^Blk= 	Kangxi}', "");
    Expect(0, 12255, '\P{Blk= 	Kangxi}', "");
    Expect(1, 12255, '\P{^Blk= 	Kangxi}', "");
    Expect(0, 12256, '\p{Blk= 	Kangxi}', "");
    Expect(1, 12256, '\p{^Blk= 	Kangxi}', "");
    Expect(1, 12256, '\P{Blk= 	Kangxi}', "");
    Expect(0, 12256, '\P{^Blk= 	Kangxi}', "");
    Error('\p{Is_Block=/a/	_KANGXI_Radicals}');
    Error('\P{Is_Block=/a/	_KANGXI_Radicals}');
    Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Is_Block= kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Is_Block= kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Is_Block= kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Is_Block= kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Is_Block= kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Is_Block= kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Is_Block= kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Is_Block= kangxi_Radicals}', "");
    Error('\p{Is_Blk= kangxi:=}');
    Error('\P{Is_Blk= kangxi:=}');
    Expect(1, 12255, '\p{Is_Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=kangxi}', "");
    Expect(1, 12255, '\p{Is_Blk=-Kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=-Kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=-Kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=-Kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=-Kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=-Kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=-Kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=-Kangxi}', "");
    Error('\p{Block=/a/Kannada}');
    Error('\P{Block=/a/Kannada}');
    Expect(1, 3327, '\p{Block=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Block=kannada}', "");
    Expect(0, 3327, '\p{^Block=kannada}', "");
    Expect(0, 3327, '\P{Block=kannada}', "");
    Expect(1, 3327, '\P{^Block=kannada}', "");
    Expect(0, 3328, '\p{Block=kannada}', "");
    Expect(1, 3328, '\p{^Block=kannada}', "");
    Expect(1, 3328, '\P{Block=kannada}', "");
    Expect(0, 3328, '\P{^Block=kannada}', "");
    Expect(1, 3327, '\p{Block=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Block:		kannada}', "");
    Expect(0, 3327, '\p{^Block:		kannada}', "");
    Expect(0, 3327, '\P{Block:		kannada}', "");
    Expect(1, 3327, '\P{^Block:		kannada}', "");
    Expect(0, 3328, '\p{Block:		kannada}', "");
    Expect(1, 3328, '\p{^Block:		kannada}', "");
    Expect(1, 3328, '\P{Block:		kannada}', "");
    Expect(0, 3328, '\P{^Block:		kannada}', "");
    Error('\p{Blk=-:=Kannada}');
    Error('\P{Blk=-:=Kannada}');
    Expect(1, 3327, '\p{Blk=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=kannada}', "");
    Expect(0, 3327, '\p{^Blk=kannada}', "");
    Expect(0, 3327, '\P{Blk=kannada}', "");
    Expect(1, 3327, '\P{^Blk=kannada}', "");
    Expect(0, 3328, '\p{Blk=kannada}', "");
    Expect(1, 3328, '\p{^Blk=kannada}', "");
    Expect(1, 3328, '\P{Blk=kannada}', "");
    Expect(0, 3328, '\P{^Blk=kannada}', "");
    Expect(1, 3327, '\p{Blk=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=_ Kannada}', "");
    Expect(0, 3327, '\p{^Blk=_ Kannada}', "");
    Expect(0, 3327, '\P{Blk=_ Kannada}', "");
    Expect(1, 3327, '\P{^Blk=_ Kannada}', "");
    Expect(0, 3328, '\p{Blk=_ Kannada}', "");
    Expect(1, 3328, '\p{^Blk=_ Kannada}', "");
    Expect(1, 3328, '\P{Blk=_ Kannada}', "");
    Expect(0, 3328, '\P{^Blk=_ Kannada}', "");
    Error('\p{Is_Block=/a/ _Kannada}');
    Error('\P{Is_Block=/a/ _Kannada}');
    Expect(1, 3327, '\p{Is_Block:   kannada}', "");
    Expect(0, 3327, '\p{^Is_Block:   kannada}', "");
    Expect(0, 3327, '\P{Is_Block:   kannada}', "");
    Expect(1, 3327, '\P{^Is_Block:   kannada}', "");
    Expect(0, 3328, '\p{Is_Block:   kannada}', "");
    Expect(1, 3328, '\p{^Is_Block:   kannada}', "");
    Expect(1, 3328, '\P{Is_Block:   kannada}', "");
    Expect(0, 3328, '\P{^Is_Block:   kannada}', "");
    Expect(1, 3327, '\p{Is_Block=-KANNADA}', "");
    Expect(0, 3327, '\p{^Is_Block=-KANNADA}', "");
    Expect(0, 3327, '\P{Is_Block=-KANNADA}', "");
    Expect(1, 3327, '\P{^Is_Block=-KANNADA}', "");
    Expect(0, 3328, '\p{Is_Block=-KANNADA}', "");
    Expect(1, 3328, '\p{^Is_Block=-KANNADA}', "");
    Expect(1, 3328, '\P{Is_Block=-KANNADA}', "");
    Expect(0, 3328, '\P{^Is_Block=-KANNADA}', "");
    Error('\p{Is_Blk=-:=Kannada}');
    Error('\P{Is_Blk=-:=Kannada}');
    Expect(1, 3327, '\p{Is_Blk=kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=kannada}', "");
    Expect(1, 3327, '\p{Is_Blk:	 _Kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk:	 _Kannada}', "");
    Expect(0, 3327, '\P{Is_Blk:	 _Kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk:	 _Kannada}', "");
    Expect(0, 3328, '\p{Is_Blk:	 _Kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk:	 _Kannada}', "");
    Expect(1, 3328, '\P{Is_Blk:	 _Kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk:	 _Kannada}', "");
    Error('\p{Block=:= katakana}');
    Error('\P{Block=:= katakana}');
    Expect(1, 12543, '\p{Block=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=katakana}', "");
    Expect(0, 12543, '\p{^Block=katakana}', "");
    Expect(0, 12543, '\P{Block=katakana}', "");
    Expect(1, 12543, '\P{^Block=katakana}', "");
    Expect(0, 12544, '\p{Block=katakana}', "");
    Expect(1, 12544, '\p{^Block=katakana}', "");
    Expect(1, 12544, '\P{Block=katakana}', "");
    Expect(0, 12544, '\P{^Block=katakana}', "");
    Expect(1, 12543, '\p{Block=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\Akatakana\z:}', "");;
    Error('\p{Blk=	/a/KATAKANA}');
    Error('\P{Blk=	/a/KATAKANA}');
    Expect(1, 12543, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk=katakana}', "");
    Expect(0, 12543, '\p{^Blk=katakana}', "");
    Expect(0, 12543, '\P{Blk=katakana}', "");
    Expect(1, 12543, '\P{^Blk=katakana}', "");
    Expect(0, 12544, '\p{Blk=katakana}', "");
    Expect(1, 12544, '\p{^Blk=katakana}', "");
    Expect(1, 12544, '\P{Blk=katakana}', "");
    Expect(0, 12544, '\P{^Blk=katakana}', "");
    Expect(1, 12543, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk:   katakana}', "");
    Expect(0, 12543, '\p{^Blk:   katakana}', "");
    Expect(0, 12543, '\P{Blk:   katakana}', "");
    Expect(1, 12543, '\P{^Blk:   katakana}', "");
    Expect(0, 12544, '\p{Blk:   katakana}', "");
    Expect(1, 12544, '\p{^Blk:   katakana}', "");
    Expect(1, 12544, '\P{Blk:   katakana}', "");
    Expect(0, 12544, '\P{^Blk:   katakana}', "");
    Error('\p{Is_Block=:=	_katakana}');
    Error('\P{Is_Block=:=	_katakana}');
    Expect(1, 12543, '\p{Is_Block=katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=katakana}', "");
    Expect(0, 12543, '\P{Is_Block=katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=katakana}', "");
    Expect(0, 12544, '\p{Is_Block=katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=katakana}', "");
    Expect(1, 12544, '\P{Is_Block=katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=katakana}', "");
    Expect(1, 12543, '\p{Is_Block= Katakana}', "");
    Expect(0, 12543, '\p{^Is_Block= Katakana}', "");
    Expect(0, 12543, '\P{Is_Block= Katakana}', "");
    Expect(1, 12543, '\P{^Is_Block= Katakana}', "");
    Expect(0, 12544, '\p{Is_Block= Katakana}', "");
    Expect(1, 12544, '\p{^Is_Block= Katakana}', "");
    Expect(1, 12544, '\P{Is_Block= Katakana}', "");
    Expect(0, 12544, '\P{^Is_Block= Katakana}', "");
    Error('\p{Is_Blk=_/a/Katakana}');
    Error('\P{Is_Blk=_/a/Katakana}');
    Expect(1, 12543, '\p{Is_Blk: katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk: katakana}', "");
    Expect(0, 12543, '\P{Is_Blk: katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk: katakana}', "");
    Expect(0, 12544, '\p{Is_Blk: katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk: katakana}', "");
    Expect(1, 12544, '\P{Is_Blk: katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk: katakana}', "");
    Expect(1, 12543, '\p{Is_Blk=	 KATAKANA}', "");
    Expect(0, 12543, '\p{^Is_Blk=	 KATAKANA}', "");
    Expect(0, 12543, '\P{Is_Blk=	 KATAKANA}', "");
    Expect(1, 12543, '\P{^Is_Blk=	 KATAKANA}', "");
    Expect(0, 12544, '\p{Is_Blk=	 KATAKANA}', "");
    Expect(1, 12544, '\p{^Is_Blk=	 KATAKANA}', "");
    Expect(1, 12544, '\P{Is_Blk=	 KATAKANA}', "");
    Expect(0, 12544, '\P{^Is_Blk=	 KATAKANA}', "");
    Error('\p{Block=_:=katakana_Phonetic_EXTENSIONS}');
    Error('\P{Block=_:=katakana_Phonetic_EXTENSIONS}');
    Expect(1, 12799, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(1, 12799, '\p{Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(0, 12799, '\p{^Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(0, 12799, '\P{Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(1, 12799, '\P{^Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(0, 12800, '\p{Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(1, 12800, '\p{^Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(1, 12800, '\P{Block=_	KATAKANA_Phonetic_extensions}', "");
    Expect(0, 12800, '\P{^Block=_	KATAKANA_Phonetic_extensions}', "");
    Error('\p{Blk=_-katakana_EXT/a/}');
    Error('\P{Blk=_-katakana_EXT/a/}');
    Expect(1, 12799, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(1, 12799, '\p{Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(1, 12799, '\p{Blk=	Katakana_Ext}', "");
    Expect(0, 12799, '\p{^Blk=	Katakana_Ext}', "");
    Expect(0, 12799, '\P{Blk=	Katakana_Ext}', "");
    Expect(1, 12799, '\P{^Blk=	Katakana_Ext}', "");
    Expect(0, 12800, '\p{Blk=	Katakana_Ext}', "");
    Expect(1, 12800, '\p{^Blk=	Katakana_Ext}', "");
    Expect(1, 12800, '\P{Blk=	Katakana_Ext}', "");
    Expect(0, 12800, '\P{^Blk=	Katakana_Ext}', "");
    Error('\p{Is_Block=:=-	Katakana_PHONETIC_extensions}');
    Error('\P{Is_Block=:=-	Katakana_PHONETIC_extensions}');
    Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(0, 12799, '\p{^Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(0, 12799, '\P{Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(1, 12799, '\P{^Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(0, 12800, '\p{Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(1, 12800, '\p{^Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(1, 12800, '\P{Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Expect(0, 12800, '\P{^Is_Block=__KATAKANA_PHONETIC_Extensions}', "");
    Error('\p{Is_Blk=-	KATAKANA_Ext/a/}');
    Error('\P{Is_Blk=-	KATAKANA_Ext/a/}');
    Expect(1, 12799, '\p{Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Is_Blk=	-KATAKANA_EXT}', "");
    Expect(0, 12799, '\p{^Is_Blk=	-KATAKANA_EXT}', "");
    Expect(0, 12799, '\P{Is_Blk=	-KATAKANA_EXT}', "");
    Expect(1, 12799, '\P{^Is_Blk=	-KATAKANA_EXT}', "");
    Expect(0, 12800, '\p{Is_Blk=	-KATAKANA_EXT}', "");
    Expect(1, 12800, '\p{^Is_Blk=	-KATAKANA_EXT}', "");
    Expect(1, 12800, '\P{Is_Blk=	-KATAKANA_EXT}', "");
    Expect(0, 12800, '\P{^Is_Blk=	-KATAKANA_EXT}', "");
    Error('\p{Block=		KAYAH_li/a/}');
    Error('\P{Block=		KAYAH_li/a/}');
    Expect(1, 43311, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Block=kayahli}', "");
    Expect(0, 43311, '\p{^Block=kayahli}', "");
    Expect(0, 43311, '\P{Block=kayahli}', "");
    Expect(1, 43311, '\P{^Block=kayahli}', "");
    Expect(0, 43312, '\p{Block=kayahli}', "");
    Expect(1, 43312, '\p{^Block=kayahli}', "");
    Expect(1, 43312, '\P{Block=kayahli}', "");
    Expect(0, 43312, '\P{^Block=kayahli}', "");
    Expect(1, 43311, '\p{Block=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Block=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Block=_ Kayah_Li}', "");
    Expect(0, 43311, '\p{^Block=_ Kayah_Li}', "");
    Expect(0, 43311, '\P{Block=_ Kayah_Li}', "");
    Expect(1, 43311, '\P{^Block=_ Kayah_Li}', "");
    Expect(0, 43312, '\p{Block=_ Kayah_Li}', "");
    Expect(1, 43312, '\p{^Block=_ Kayah_Li}', "");
    Expect(1, 43312, '\P{Block=_ Kayah_Li}', "");
    Expect(0, 43312, '\P{^Block=_ Kayah_Li}', "");
    Error('\p{Blk=/a/	_KAYAH_Li}');
    Error('\P{Blk=/a/	_KAYAH_Li}');
    Expect(1, 43311, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Blk=kayahli}', "");
    Expect(0, 43311, '\P{Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Blk=kayahli}', "");
    Expect(0, 43312, '\p{Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Blk=kayahli}', "");
    Expect(1, 43312, '\P{Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Blk=kayahli}', "");
    Expect(1, 43311, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Blk=- KAYAH_li}', "");
    Expect(0, 43311, '\p{^Blk=- KAYAH_li}', "");
    Expect(0, 43311, '\P{Blk=- KAYAH_li}', "");
    Expect(1, 43311, '\P{^Blk=- KAYAH_li}', "");
    Expect(0, 43312, '\p{Blk=- KAYAH_li}', "");
    Expect(1, 43312, '\p{^Blk=- KAYAH_li}', "");
    Expect(1, 43312, '\P{Blk=- KAYAH_li}', "");
    Expect(0, 43312, '\P{^Blk=- KAYAH_li}', "");
    Error('\p{Is_Block:	/a/Kayah_Li}');
    Error('\P{Is_Block:	/a/Kayah_Li}');
    Expect(1, 43311, '\p{Is_Block=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
    Expect(0, 43311, '\P{Is_Block=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
    Expect(0, 43312, '\p{Is_Block=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Block=kayahli}', "");
    Expect(1, 43312, '\P{Is_Block=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Block=kayahli}', "");
    Expect(1, 43311, '\p{Is_Block=_ kayah_li}', "");
    Expect(0, 43311, '\p{^Is_Block=_ kayah_li}', "");
    Expect(0, 43311, '\P{Is_Block=_ kayah_li}', "");
    Expect(1, 43311, '\P{^Is_Block=_ kayah_li}', "");
    Expect(0, 43312, '\p{Is_Block=_ kayah_li}', "");
    Expect(1, 43312, '\p{^Is_Block=_ kayah_li}', "");
    Expect(1, 43312, '\P{Is_Block=_ kayah_li}', "");
    Expect(0, 43312, '\P{^Is_Block=_ kayah_li}', "");
    Error('\p{Is_Blk=_/a/Kayah_LI}');
    Error('\P{Is_Blk=_/a/Kayah_LI}');
    Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
    Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
    Expect(0, 43312, '\p{Is_Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Blk=kayahli}', "");
    Expect(1, 43312, '\P{Is_Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Blk=kayahli}', "");
    Expect(1, 43311, '\p{Is_Blk=	 Kayah_LI}', "");
    Expect(0, 43311, '\p{^Is_Blk=	 Kayah_LI}', "");
    Expect(0, 43311, '\P{Is_Blk=	 Kayah_LI}', "");
    Expect(1, 43311, '\P{^Is_Blk=	 Kayah_LI}', "");
    Expect(0, 43312, '\p{Is_Blk=	 Kayah_LI}', "");
    Expect(1, 43312, '\p{^Is_Blk=	 Kayah_LI}', "");
    Expect(1, 43312, '\P{Is_Blk=	 Kayah_LI}', "");
    Expect(0, 43312, '\P{^Is_Blk=	 Kayah_LI}', "");
    Error('\p{Block=/a/--kharoshthi}');
    Error('\P{Block=/a/--kharoshthi}');
    Expect(1, 68191, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=__Kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=__Kharoshthi}', "");
    Expect(0, 68191, '\P{Block=__Kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=__Kharoshthi}', "");
    Expect(0, 68192, '\p{Block=__Kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=__Kharoshthi}', "");
    Expect(1, 68192, '\P{Block=__Kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=__Kharoshthi}', "");
    Error('\p{Blk=/a/-KHAROSHTHI}');
    Error('\P{Blk=/a/-KHAROSHTHI}');
    Expect(1, 68191, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk:	kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk:	kharoshthi}', "");
    Expect(0, 68191, '\P{Blk:	kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk:	kharoshthi}', "");
    Expect(0, 68192, '\p{Blk:	kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk:	kharoshthi}', "");
    Expect(1, 68192, '\P{Blk:	kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk:	kharoshthi}', "");
    Expect(1, 68191, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk:   --Kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk:   --Kharoshthi}', "");
    Expect(0, 68191, '\P{Blk:   --Kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk:   --Kharoshthi}', "");
    Expect(0, 68192, '\p{Blk:   --Kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk:   --Kharoshthi}', "");
    Expect(1, 68192, '\P{Blk:   --Kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk:   --Kharoshthi}', "");
    Error('\p{Is_Block=_	kharoshthi:=}');
    Error('\P{Is_Block=_	kharoshthi:=}');
    Expect(1, 68191, '\p{Is_Block:kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block:kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block:kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block:kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block:kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block:kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block:kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block:kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Block=	 KHAROSHTHI}', "");
    Expect(0, 68191, '\p{^Is_Block=	 KHAROSHTHI}', "");
    Expect(0, 68191, '\P{Is_Block=	 KHAROSHTHI}', "");
    Expect(1, 68191, '\P{^Is_Block=	 KHAROSHTHI}', "");
    Expect(0, 68192, '\p{Is_Block=	 KHAROSHTHI}', "");
    Expect(1, 68192, '\p{^Is_Block=	 KHAROSHTHI}', "");
    Expect(1, 68192, '\P{Is_Block=	 KHAROSHTHI}', "");
    Expect(0, 68192, '\P{^Is_Block=	 KHAROSHTHI}', "");
    Error('\p{Is_Blk=:=-	Kharoshthi}');
    Error('\P{Is_Blk=:=-	Kharoshthi}');
    Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Blk:__Kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk:__Kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk:__Kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk:__Kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk:__Kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk:__Kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk:__Kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk:__Kharoshthi}', "");
    Error('\p{Block=	-khitan_SMALL_Script/a/}');
    Error('\P{Block=	-khitan_SMALL_Script/a/}');
    Expect(1, 101631, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Block=_	Khitan_Small_SCRIPT}', "");
    Expect(0, 101631, '\p{^Block=_	Khitan_Small_SCRIPT}', "");
    Expect(0, 101631, '\P{Block=_	Khitan_Small_SCRIPT}', "");
    Expect(1, 101631, '\P{^Block=_	Khitan_Small_SCRIPT}', "");
    Expect(0, 101632, '\p{Block=_	Khitan_Small_SCRIPT}', "");
    Expect(1, 101632, '\p{^Block=_	Khitan_Small_SCRIPT}', "");
    Expect(1, 101632, '\P{Block=_	Khitan_Small_SCRIPT}', "");
    Expect(0, 101632, '\P{^Block=_	Khitan_Small_SCRIPT}', "");
    Error('\p{Blk=_KHITAN_Small_Script:=}');
    Error('\P{Blk=_KHITAN_Small_Script:=}');
    Expect(1, 101631, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Blk=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Blk=khitansmallscript}', "");
    Expect(0, 101631, '\P{Blk=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Blk=khitansmallscript}', "");
    Expect(0, 101632, '\p{Blk=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Blk=khitansmallscript}', "");
    Expect(1, 101632, '\P{Blk=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Blk=khitansmallscript}', "");
    Expect(1, 101631, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Blk=_khitan_small_Script}', "");
    Expect(0, 101631, '\p{^Blk=_khitan_small_Script}', "");
    Expect(0, 101631, '\P{Blk=_khitan_small_Script}', "");
    Expect(1, 101631, '\P{^Blk=_khitan_small_Script}', "");
    Expect(0, 101632, '\p{Blk=_khitan_small_Script}', "");
    Expect(1, 101632, '\p{^Blk=_khitan_small_Script}', "");
    Expect(1, 101632, '\P{Blk=_khitan_small_Script}', "");
    Expect(0, 101632, '\P{^Blk=_khitan_small_Script}', "");
    Error('\p{Is_Block:	 /a/khitan_Small_Script}');
    Error('\P{Is_Block:	 /a/khitan_Small_Script}');
    Expect(1, 101631, '\p{Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Block=		Khitan_Small_Script}', "");
    Expect(0, 101631, '\p{^Is_Block=		Khitan_Small_Script}', "");
    Expect(0, 101631, '\P{Is_Block=		Khitan_Small_Script}', "");
    Expect(1, 101631, '\P{^Is_Block=		Khitan_Small_Script}', "");
    Expect(0, 101632, '\p{Is_Block=		Khitan_Small_Script}', "");
    Expect(1, 101632, '\p{^Is_Block=		Khitan_Small_Script}', "");
    Expect(1, 101632, '\P{Is_Block=		Khitan_Small_Script}', "");
    Expect(0, 101632, '\P{^Is_Block=		Khitan_Small_Script}', "");
    Error('\p{Is_Blk=:=	 KHITAN_SMALL_Script}');
    Error('\P{Is_Blk=:=	 KHITAN_SMALL_Script}');
    Expect(1, 101631, '\p{Is_Blk=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Blk=khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Blk=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Blk=khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Blk=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Blk=khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Blk=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Blk=khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Blk=	Khitan_Small_Script}', "");
    Expect(0, 101631, '\p{^Is_Blk=	Khitan_Small_Script}', "");
    Expect(0, 101631, '\P{Is_Blk=	Khitan_Small_Script}', "");
    Expect(1, 101631, '\P{^Is_Blk=	Khitan_Small_Script}', "");
    Expect(0, 101632, '\p{Is_Blk=	Khitan_Small_Script}', "");
    Expect(1, 101632, '\p{^Is_Blk=	Khitan_Small_Script}', "");
    Expect(1, 101632, '\P{Is_Blk=	Khitan_Small_Script}', "");
    Expect(0, 101632, '\P{^Is_Blk=	Khitan_Small_Script}', "");
    Error('\p{Block=_Khmer/a/}');
    Error('\P{Block=_Khmer/a/}');
    Expect(1, 6143, '\p{Block=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=khmer}', "");
    Expect(0, 6143, '\p{^Block=khmer}', "");
    Expect(0, 6143, '\P{Block=khmer}', "");
    Expect(1, 6143, '\P{^Block=khmer}', "");
    Expect(0, 6144, '\p{Block=khmer}', "");
    Expect(1, 6144, '\p{^Block=khmer}', "");
    Expect(1, 6144, '\P{Block=khmer}', "");
    Expect(0, 6144, '\P{^Block=khmer}', "");
    Expect(1, 6143, '\p{Block=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Block= Khmer}', "");
    Expect(0, 6143, '\p{^Block= Khmer}', "");
    Expect(0, 6143, '\P{Block= Khmer}', "");
    Expect(1, 6143, '\P{^Block= Khmer}', "");
    Expect(0, 6144, '\p{Block= Khmer}', "");
    Expect(1, 6144, '\p{^Block= Khmer}', "");
    Expect(1, 6144, '\P{Block= Khmer}', "");
    Expect(0, 6144, '\P{^Block= Khmer}', "");
    Error('\p{Blk= /a/Khmer}');
    Error('\P{Blk= /a/Khmer}');
    Expect(1, 6143, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=khmer}', "");
    Expect(0, 6143, '\p{^Blk=khmer}', "");
    Expect(0, 6143, '\P{Blk=khmer}', "");
    Expect(1, 6143, '\P{^Blk=khmer}', "");
    Expect(0, 6144, '\p{Blk=khmer}', "");
    Expect(1, 6144, '\p{^Blk=khmer}', "");
    Expect(1, 6144, '\P{Blk=khmer}', "");
    Expect(0, 6144, '\P{^Blk=khmer}', "");
    Expect(1, 6143, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=  Khmer}', "");
    Expect(0, 6143, '\p{^Blk=  Khmer}', "");
    Expect(0, 6143, '\P{Blk=  Khmer}', "");
    Expect(1, 6143, '\P{^Blk=  Khmer}', "");
    Expect(0, 6144, '\p{Blk=  Khmer}', "");
    Expect(1, 6144, '\p{^Blk=  Khmer}', "");
    Expect(1, 6144, '\P{Blk=  Khmer}', "");
    Expect(0, 6144, '\P{^Blk=  Khmer}', "");
    Error('\p{Is_Block=- khmer:=}');
    Error('\P{Is_Block=- khmer:=}');
    Expect(1, 6143, '\p{Is_Block=khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=khmer}', "");
    Expect(0, 6143, '\P{Is_Block=khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=khmer}', "");
    Expect(0, 6144, '\p{Is_Block=khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=khmer}', "");
    Expect(1, 6144, '\P{Is_Block=khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=khmer}', "");
    Expect(1, 6143, '\p{Is_Block=	_Khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=	_Khmer}', "");
    Expect(0, 6143, '\P{Is_Block=	_Khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=	_Khmer}', "");
    Expect(0, 6144, '\p{Is_Block=	_Khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=	_Khmer}', "");
    Expect(1, 6144, '\P{Is_Block=	_Khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=	_Khmer}', "");
    Error('\p{Is_Blk=:= 	Khmer}');
    Error('\P{Is_Blk=:= 	Khmer}');
    Expect(1, 6143, '\p{Is_Blk=khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=khmer}', "");
    Expect(1, 6143, '\p{Is_Blk=	Khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=	Khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=	Khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=	Khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=	Khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=	Khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=	Khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=	Khmer}', "");
    Error('\p{Block=	KHMER_symbols:=}');
    Error('\P{Block=	KHMER_symbols:=}');
    Expect(1, 6655, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Block= KHMER_Symbols}', "");
    Expect(0, 6655, '\p{^Block= KHMER_Symbols}', "");
    Expect(0, 6655, '\P{Block= KHMER_Symbols}', "");
    Expect(1, 6655, '\P{^Block= KHMER_Symbols}', "");
    Expect(0, 6656, '\p{Block= KHMER_Symbols}', "");
    Expect(1, 6656, '\p{^Block= KHMER_Symbols}', "");
    Expect(1, 6656, '\P{Block= KHMER_Symbols}', "");
    Expect(0, 6656, '\P{^Block= KHMER_Symbols}', "");
    Error('\p{Blk:	:=	-Khmer_Symbols}');
    Error('\P{Blk:	:=	-Khmer_Symbols}');
    Expect(1, 6655, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Blk= Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Blk= Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Blk= Khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Blk= Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Blk= Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Blk= Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Blk= Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Blk= Khmer_SYMBOLS}', "");
    Error('\p{Is_Block=:=-Khmer_symbols}');
    Error('\P{Is_Block=:=-Khmer_symbols}');
    Expect(1, 6655, '\p{Is_Block:   khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Block:   khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Block:   khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Block:   khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Block:   khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Block:   khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Block:   khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Block:   khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Block= 	KHMER_Symbols}', "");
    Expect(0, 6655, '\p{^Is_Block= 	KHMER_Symbols}', "");
    Expect(0, 6655, '\P{Is_Block= 	KHMER_Symbols}', "");
    Expect(1, 6655, '\P{^Is_Block= 	KHMER_Symbols}', "");
    Expect(0, 6656, '\p{Is_Block= 	KHMER_Symbols}', "");
    Expect(1, 6656, '\p{^Is_Block= 	KHMER_Symbols}', "");
    Expect(1, 6656, '\P{Is_Block= 	KHMER_Symbols}', "");
    Expect(0, 6656, '\P{^Is_Block= 	KHMER_Symbols}', "");
    Error('\p{Is_Blk=_:=Khmer_SYMBOLS}');
    Error('\P{Is_Blk=_:=Khmer_SYMBOLS}');
    Expect(1, 6655, '\p{Is_Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Blk=--khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Is_Blk=--khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Is_Blk=--khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Is_Blk=--khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Is_Blk=--khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Is_Blk=--khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Is_Blk=--khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Is_Blk=--khmer_SYMBOLS}', "");
    Error('\p{Block=/a/khojki}');
    Error('\P{Block=/a/khojki}');
    Expect(1, 70223, '\p{Block=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=khojki}', "");
    Expect(0, 70223, '\p{^Block=khojki}', "");
    Expect(0, 70223, '\P{Block=khojki}', "");
    Expect(1, 70223, '\P{^Block=khojki}', "");
    Expect(0, 70224, '\p{Block=khojki}', "");
    Expect(1, 70224, '\p{^Block=khojki}', "");
    Expect(1, 70224, '\P{Block=khojki}', "");
    Expect(0, 70224, '\P{^Block=khojki}', "");
    Expect(1, 70223, '\p{Block=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=_Khojki}', "");
    Expect(0, 70223, '\p{^Block=_Khojki}', "");
    Expect(0, 70223, '\P{Block=_Khojki}', "");
    Expect(1, 70223, '\P{^Block=_Khojki}', "");
    Expect(0, 70224, '\p{Block=_Khojki}', "");
    Expect(1, 70224, '\p{^Block=_Khojki}', "");
    Expect(1, 70224, '\P{Block=_Khojki}', "");
    Expect(0, 70224, '\P{^Block=_Khojki}', "");
    Error('\p{Blk=:=  khojki}');
    Error('\P{Blk=:=  khojki}');
    Expect(1, 70223, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=khojki}', "");
    Expect(0, 70223, '\p{^Blk=khojki}', "");
    Expect(0, 70223, '\P{Blk=khojki}', "");
    Expect(1, 70223, '\P{^Blk=khojki}', "");
    Expect(0, 70224, '\p{Blk=khojki}', "");
    Expect(1, 70224, '\p{^Blk=khojki}', "");
    Expect(1, 70224, '\P{Blk=khojki}', "");
    Expect(0, 70224, '\P{^Blk=khojki}', "");
    Expect(1, 70223, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=_-Khojki}', "");
    Expect(0, 70223, '\p{^Blk=_-Khojki}', "");
    Expect(0, 70223, '\P{Blk=_-Khojki}', "");
    Expect(1, 70223, '\P{^Blk=_-Khojki}', "");
    Expect(0, 70224, '\p{Blk=_-Khojki}', "");
    Expect(1, 70224, '\p{^Blk=_-Khojki}', "");
    Expect(1, 70224, '\P{Blk=_-Khojki}', "");
    Expect(0, 70224, '\P{^Blk=_-Khojki}', "");
    Error('\p{Is_Block= /a/Khojki}');
    Error('\P{Is_Block= /a/Khojki}');
    Expect(1, 70223, '\p{Is_Block=khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=khojki}', "");
    Expect(0, 70223, '\P{Is_Block=khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=khojki}', "");
    Expect(0, 70224, '\p{Is_Block=khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=khojki}', "");
    Expect(1, 70224, '\P{Is_Block=khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=khojki}', "");
    Expect(1, 70223, '\p{Is_Block=	_Khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=	_Khojki}', "");
    Expect(0, 70223, '\P{Is_Block=	_Khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=	_Khojki}', "");
    Expect(0, 70224, '\p{Is_Block=	_Khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=	_Khojki}', "");
    Expect(1, 70224, '\P{Is_Block=	_Khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=	_Khojki}', "");
    Error('\p{Is_Blk=	/a/Khojki}');
    Error('\P{Is_Blk=	/a/Khojki}');
    Expect(1, 70223, '\p{Is_Blk=khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=khojki}', "");
    Expect(1, 70223, '\p{Is_Blk=  khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=  khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=  khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=  khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=  khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=  khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=  khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=  khojki}', "");
    Error('\p{Block=_	KHUDAWADI:=}');
    Error('\P{Block=_	KHUDAWADI:=}');
    Expect(1, 70399, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Block=khudawadi}', "");
    Expect(0, 70399, '\P{Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Block=khudawadi}', "");
    Expect(0, 70400, '\p{Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Block=khudawadi}', "");
    Expect(1, 70400, '\P{Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Block=khudawadi}', "");
    Expect(1, 70399, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block=_khudawadi}', "");
    Expect(0, 70399, '\p{^Block=_khudawadi}', "");
    Expect(0, 70399, '\P{Block=_khudawadi}', "");
    Expect(1, 70399, '\P{^Block=_khudawadi}', "");
    Expect(0, 70400, '\p{Block=_khudawadi}', "");
    Expect(1, 70400, '\p{^Block=_khudawadi}', "");
    Expect(1, 70400, '\P{Block=_khudawadi}', "");
    Expect(0, 70400, '\P{^Block=_khudawadi}', "");
    Error('\p{Blk=/a/ _Khudawadi}');
    Error('\P{Blk=/a/ _Khudawadi}');
    Expect(1, 70399, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk:   khudawadi}', "");
    Expect(0, 70399, '\p{^Blk:   khudawadi}', "");
    Expect(0, 70399, '\P{Blk:   khudawadi}', "");
    Expect(1, 70399, '\P{^Blk:   khudawadi}', "");
    Expect(0, 70400, '\p{Blk:   khudawadi}', "");
    Expect(1, 70400, '\p{^Blk:   khudawadi}', "");
    Expect(1, 70400, '\P{Blk:   khudawadi}', "");
    Expect(0, 70400, '\P{^Blk:   khudawadi}', "");
    Expect(1, 70399, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk=_ Khudawadi}', "");
    Expect(0, 70399, '\p{^Blk=_ Khudawadi}', "");
    Expect(0, 70399, '\P{Blk=_ Khudawadi}', "");
    Expect(1, 70399, '\P{^Blk=_ Khudawadi}', "");
    Expect(0, 70400, '\p{Blk=_ Khudawadi}', "");
    Expect(1, 70400, '\p{^Blk=_ Khudawadi}', "");
    Expect(1, 70400, '\P{Blk=_ Khudawadi}', "");
    Expect(0, 70400, '\P{^Blk=_ Khudawadi}', "");
    Error('\p{Is_Block=	/a/KHUDAWADI}');
    Error('\P{Is_Block=	/a/KHUDAWADI}');
    Expect(1, 70399, '\p{Is_Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Block=-_Khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=-_Khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=-_Khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=-_Khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=-_Khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=-_Khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=-_Khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=-_Khudawadi}', "");
    Error('\p{Is_Blk=-KHUDAWADI/a/}');
    Error('\P{Is_Blk=-KHUDAWADI/a/}');
    Expect(1, 70399, '\p{Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Blk= 	Khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk= 	Khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk= 	Khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk= 	Khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk= 	Khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk= 	Khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk= 	Khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk= 	Khudawadi}', "");
    Error('\p{Block=		lao/a/}');
    Error('\P{Block=		lao/a/}');
    Expect(1, 3839, '\p{Block=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Block=lao}', "");
    Expect(0, 3839, '\p{^Block=lao}', "");
    Expect(0, 3839, '\P{Block=lao}', "");
    Expect(1, 3839, '\P{^Block=lao}', "");
    Expect(0, 3840, '\p{Block=lao}', "");
    Expect(1, 3840, '\p{^Block=lao}', "");
    Expect(1, 3840, '\P{Block=lao}', "");
    Expect(0, 3840, '\P{^Block=lao}', "");
    Expect(1, 3839, '\p{Block=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Block=-	lao}', "");
    Expect(0, 3839, '\p{^Block=-	lao}', "");
    Expect(0, 3839, '\P{Block=-	lao}', "");
    Expect(1, 3839, '\P{^Block=-	lao}', "");
    Expect(0, 3840, '\p{Block=-	lao}', "");
    Expect(1, 3840, '\p{^Block=-	lao}', "");
    Expect(1, 3840, '\P{Block=-	lao}', "");
    Expect(0, 3840, '\P{^Block=-	lao}', "");
    Error('\p{Blk= -LAO/a/}');
    Error('\P{Blk= -LAO/a/}');
    Expect(1, 3839, '\p{Blk=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Blk=lao}', "");
    Expect(0, 3839, '\p{^Blk=lao}', "");
    Expect(0, 3839, '\P{Blk=lao}', "");
    Expect(1, 3839, '\P{^Blk=lao}', "");
    Expect(0, 3840, '\p{Blk=lao}', "");
    Expect(1, 3840, '\p{^Blk=lao}', "");
    Expect(1, 3840, '\P{Blk=lao}', "");
    Expect(0, 3840, '\P{^Blk=lao}', "");
    Expect(1, 3839, '\p{Blk=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Blk=-LAO}', "");
    Expect(0, 3839, '\p{^Blk=-LAO}', "");
    Expect(0, 3839, '\P{Blk=-LAO}', "");
    Expect(1, 3839, '\P{^Blk=-LAO}', "");
    Expect(0, 3840, '\p{Blk=-LAO}', "");
    Expect(1, 3840, '\p{^Blk=-LAO}', "");
    Expect(1, 3840, '\P{Blk=-LAO}', "");
    Expect(0, 3840, '\P{^Blk=-LAO}', "");
    Error('\p{Is_Block=/a/_	LAO}');
    Error('\P{Is_Block=/a/_	LAO}');
    Expect(1, 3839, '\p{Is_Block=lao}', "");
    Expect(0, 3839, '\p{^Is_Block=lao}', "");
    Expect(0, 3839, '\P{Is_Block=lao}', "");
    Expect(1, 3839, '\P{^Is_Block=lao}', "");
    Expect(0, 3840, '\p{Is_Block=lao}', "");
    Expect(1, 3840, '\p{^Is_Block=lao}', "");
    Expect(1, 3840, '\P{Is_Block=lao}', "");
    Expect(0, 3840, '\P{^Is_Block=lao}', "");
    Expect(1, 3839, '\p{Is_Block=--LAO}', "");
    Expect(0, 3839, '\p{^Is_Block=--LAO}', "");
    Expect(0, 3839, '\P{Is_Block=--LAO}', "");
    Expect(1, 3839, '\P{^Is_Block=--LAO}', "");
    Expect(0, 3840, '\p{Is_Block=--LAO}', "");
    Expect(1, 3840, '\p{^Is_Block=--LAO}', "");
    Expect(1, 3840, '\P{Is_Block=--LAO}', "");
    Expect(0, 3840, '\P{^Is_Block=--LAO}', "");
    Error('\p{Is_Blk=_	lao:=}');
    Error('\P{Is_Blk=_	lao:=}');
    Expect(1, 3839, '\p{Is_Blk=lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=lao}', "");
    Expect(0, 3839, '\P{Is_Blk=lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=lao}', "");
    Expect(0, 3840, '\p{Is_Blk=lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=lao}', "");
    Expect(1, 3840, '\P{Is_Blk=lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=lao}', "");
    Expect(1, 3839, '\p{Is_Blk=	-Lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=	-Lao}', "");
    Expect(0, 3839, '\P{Is_Blk=	-Lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=	-Lao}', "");
    Expect(0, 3840, '\p{Is_Blk=	-Lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=	-Lao}', "");
    Expect(1, 3840, '\P{Is_Blk=	-Lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=	-Lao}', "");
    Error('\p{Block=- LATIN_1_supplement/a/}');
    Error('\P{Block=- LATIN_1_supplement/a/}');
    Expect(1, 255, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(1, 255, '\p{Block=latin1supplement}', "");
    Expect(0, 255, '\p{^Block=latin1supplement}', "");
    Expect(0, 255, '\P{Block=latin1supplement}', "");
    Expect(1, 255, '\P{^Block=latin1supplement}', "");
    Expect(0, 256, '\p{Block=latin1supplement}', "");
    Expect(1, 256, '\p{^Block=latin1supplement}', "");
    Expect(1, 256, '\P{Block=latin1supplement}', "");
    Expect(0, 256, '\P{^Block=latin1supplement}', "");
    Expect(1, 255, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(1, 255, '\p{Block= _latin_1_supplement}', "");
    Expect(0, 255, '\p{^Block= _latin_1_supplement}', "");
    Expect(0, 255, '\P{Block= _latin_1_supplement}', "");
    Expect(1, 255, '\P{^Block= _latin_1_supplement}', "");
    Expect(0, 256, '\p{Block= _latin_1_supplement}', "");
    Expect(1, 256, '\p{^Block= _latin_1_supplement}', "");
    Expect(1, 256, '\P{Block= _latin_1_supplement}', "");
    Expect(0, 256, '\P{^Block= _latin_1_supplement}', "");
    Error('\p{Blk: __LATIN_1_SUP/a/}');
    Error('\P{Blk: __LATIN_1_SUP/a/}');
    Expect(1, 255, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(1, 255, '\p{Blk=latin1sup}', "");
    Expect(0, 255, '\p{^Blk=latin1sup}', "");
    Expect(0, 255, '\P{Blk=latin1sup}', "");
    Expect(1, 255, '\P{^Blk=latin1sup}', "");
    Expect(0, 256, '\p{Blk=latin1sup}', "");
    Expect(1, 256, '\p{^Blk=latin1sup}', "");
    Expect(1, 256, '\P{Blk=latin1sup}', "");
    Expect(0, 256, '\P{^Blk=latin1sup}', "");
    Expect(1, 255, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(1, 255, '\p{Blk=__Latin_1_Sup}', "");
    Expect(0, 255, '\p{^Blk=__Latin_1_Sup}', "");
    Expect(0, 255, '\P{Blk=__Latin_1_Sup}', "");
    Expect(1, 255, '\P{^Blk=__Latin_1_Sup}', "");
    Expect(0, 256, '\p{Blk=__Latin_1_Sup}', "");
    Expect(1, 256, '\p{^Blk=__Latin_1_Sup}', "");
    Expect(1, 256, '\P{Blk=__Latin_1_Sup}', "");
    Expect(0, 256, '\P{^Blk=__Latin_1_Sup}', "");
    Error('\p{Is_Block=:=-_Latin_1}');
    Error('\P{Is_Block=:=-_Latin_1}');
    Expect(1, 255, '\p{Is_Block=latin1}', "");
    Expect(0, 255, '\p{^Is_Block=latin1}', "");
    Expect(0, 255, '\P{Is_Block=latin1}', "");
    Expect(1, 255, '\P{^Is_Block=latin1}', "");
    Expect(0, 256, '\p{Is_Block=latin1}', "");
    Expect(1, 256, '\p{^Is_Block=latin1}', "");
    Expect(1, 256, '\P{Is_Block=latin1}', "");
    Expect(0, 256, '\P{^Is_Block=latin1}', "");
    Expect(1, 255, '\p{Is_Block= latin_1}', "");
    Expect(0, 255, '\p{^Is_Block= latin_1}', "");
    Expect(0, 255, '\P{Is_Block= latin_1}', "");
    Expect(1, 255, '\P{^Is_Block= latin_1}', "");
    Expect(0, 256, '\p{Is_Block= latin_1}', "");
    Expect(1, 256, '\p{^Is_Block= latin_1}', "");
    Expect(1, 256, '\P{Is_Block= latin_1}', "");
    Expect(0, 256, '\P{^Is_Block= latin_1}', "");
    Error('\p{Is_Blk= _Latin_1_Supplement:=}');
    Error('\P{Is_Blk= _Latin_1_Supplement:=}');
    Expect(1, 255, '\p{Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\P{Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\p{Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\P{Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\p{Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(0, 255, '\p{^Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(0, 255, '\P{Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(1, 255, '\P{^Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(0, 256, '\p{Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(1, 256, '\p{^Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(1, 256, '\P{Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Expect(0, 256, '\P{^Is_Blk=	_latin_1_SUPPLEMENT}', "");
    Error('\p{Block= /a/LATIN_EXTENDED_A}');
    Error('\P{Block= /a/LATIN_EXTENDED_A}');
    Expect(1, 383, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(0, 384, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(1, 383, '\p{Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Block=latinextendeda}', "");
    Expect(0, 383, '\P{Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Block=latinextendeda}', "");
    Expect(0, 384, '\p{Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Block=latinextendeda}', "");
    Expect(1, 384, '\P{Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Block=latinextendeda}', "");
    Expect(1, 383, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(0, 384, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(1, 383, '\p{Block=_ LATIN_EXTENDED_A}', "");
    Expect(0, 383, '\p{^Block=_ LATIN_EXTENDED_A}', "");
    Expect(0, 383, '\P{Block=_ LATIN_EXTENDED_A}', "");
    Expect(1, 383, '\P{^Block=_ LATIN_EXTENDED_A}', "");
    Expect(0, 384, '\p{Block=_ LATIN_EXTENDED_A}', "");
    Expect(1, 384, '\p{^Block=_ LATIN_EXTENDED_A}', "");
    Expect(1, 384, '\P{Block=_ LATIN_EXTENDED_A}', "");
    Expect(0, 384, '\P{^Block=_ LATIN_EXTENDED_A}', "");
    Error('\p{Blk=- latin_Ext_A:=}');
    Error('\P{Blk=- latin_Ext_A:=}');
    Expect(1, 383, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(0, 384, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(1, 383, '\p{Blk=latinexta}', "");
    Expect(0, 383, '\p{^Blk=latinexta}', "");
    Expect(0, 383, '\P{Blk=latinexta}', "");
    Expect(1, 383, '\P{^Blk=latinexta}', "");
    Expect(0, 384, '\p{Blk=latinexta}', "");
    Expect(1, 384, '\p{^Blk=latinexta}', "");
    Expect(1, 384, '\P{Blk=latinexta}', "");
    Expect(0, 384, '\P{^Blk=latinexta}', "");
    Expect(1, 383, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(0, 384, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(1, 383, '\p{Blk=	Latin_ext_A}', "");
    Expect(0, 383, '\p{^Blk=	Latin_ext_A}', "");
    Expect(0, 383, '\P{Blk=	Latin_ext_A}', "");
    Expect(1, 383, '\P{^Blk=	Latin_ext_A}', "");
    Expect(0, 384, '\p{Blk=	Latin_ext_A}', "");
    Expect(1, 384, '\p{^Blk=	Latin_ext_A}', "");
    Expect(1, 384, '\P{Blk=	Latin_ext_A}', "");
    Expect(0, 384, '\P{^Blk=	Latin_ext_A}', "");
    Error('\p{Is_Block=	:=Latin_extended_A}');
    Error('\P{Is_Block=	:=Latin_extended_A}');
    Expect(1, 383, '\p{Is_Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Is_Block=latinextendeda}', "");
    Expect(0, 383, '\P{Is_Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Is_Block=latinextendeda}', "");
    Expect(0, 384, '\p{Is_Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Is_Block=latinextendeda}', "");
    Expect(1, 384, '\P{Is_Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Is_Block=latinextendeda}', "");
    Expect(1, 383, '\p{Is_Block=	Latin_EXTENDED_A}', "");
    Expect(0, 383, '\p{^Is_Block=	Latin_EXTENDED_A}', "");
    Expect(0, 383, '\P{Is_Block=	Latin_EXTENDED_A}', "");
    Expect(1, 383, '\P{^Is_Block=	Latin_EXTENDED_A}', "");
    Expect(0, 384, '\p{Is_Block=	Latin_EXTENDED_A}', "");
    Expect(1, 384, '\p{^Is_Block=	Latin_EXTENDED_A}', "");
    Expect(1, 384, '\P{Is_Block=	Latin_EXTENDED_A}', "");
    Expect(0, 384, '\P{^Is_Block=	Latin_EXTENDED_A}', "");
    Error('\p{Is_Blk:	_/a/latin_EXT_a}');
    Error('\P{Is_Blk:	_/a/latin_EXT_a}');
    Expect(1, 383, '\p{Is_Blk=latinexta}', "");
    Expect(0, 383, '\p{^Is_Blk=latinexta}', "");
    Expect(0, 383, '\P{Is_Blk=latinexta}', "");
    Expect(1, 383, '\P{^Is_Blk=latinexta}', "");
    Expect(0, 384, '\p{Is_Blk=latinexta}', "");
    Expect(1, 384, '\p{^Is_Blk=latinexta}', "");
    Expect(1, 384, '\P{Is_Blk=latinexta}', "");
    Expect(0, 384, '\P{^Is_Blk=latinexta}', "");
    Expect(1, 383, '\p{Is_Blk= Latin_Ext_A}', "");
    Expect(0, 383, '\p{^Is_Blk= Latin_Ext_A}', "");
    Expect(0, 383, '\P{Is_Blk= Latin_Ext_A}', "");
    Expect(1, 383, '\P{^Is_Blk= Latin_Ext_A}', "");
    Expect(0, 384, '\p{Is_Blk= Latin_Ext_A}', "");
    Expect(1, 384, '\p{^Is_Blk= Latin_Ext_A}', "");
    Expect(1, 384, '\P{Is_Blk= Latin_Ext_A}', "");
    Expect(0, 384, '\P{^Is_Blk= Latin_Ext_A}', "");
    Error('\p{Block=_ Latin_EXTENDED_additional:=}');
    Error('\P{Block=_ Latin_EXTENDED_additional:=}');
    Expect(1, 7935, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(1, 7935, '\p{Block= 	LATIN_EXTENDED_additional}', "");
    Expect(0, 7935, '\p{^Block= 	LATIN_EXTENDED_additional}', "");
    Expect(0, 7935, '\P{Block= 	LATIN_EXTENDED_additional}', "");
    Expect(1, 7935, '\P{^Block= 	LATIN_EXTENDED_additional}', "");
    Expect(0, 7936, '\p{Block= 	LATIN_EXTENDED_additional}', "");
    Expect(1, 7936, '\p{^Block= 	LATIN_EXTENDED_additional}', "");
    Expect(1, 7936, '\P{Block= 	LATIN_EXTENDED_additional}', "");
    Expect(0, 7936, '\P{^Block= 	LATIN_EXTENDED_additional}', "");
    Error('\p{Blk=:=-_Latin_Ext_Additional}');
    Error('\P{Blk=:=-_Latin_Ext_Additional}');
    Expect(1, 7935, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(1, 7935, '\p{Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(1, 7935, '\p{Blk=_latin_Ext_Additional}', "");
    Expect(0, 7935, '\p{^Blk=_latin_Ext_Additional}', "");
    Expect(0, 7935, '\P{Blk=_latin_Ext_Additional}', "");
    Expect(1, 7935, '\P{^Blk=_latin_Ext_Additional}', "");
    Expect(0, 7936, '\p{Blk=_latin_Ext_Additional}', "");
    Expect(1, 7936, '\p{^Blk=_latin_Ext_Additional}', "");
    Expect(1, 7936, '\P{Blk=_latin_Ext_Additional}', "");
    Expect(0, 7936, '\P{^Blk=_latin_Ext_Additional}', "");
    Error('\p{Is_Block=/a/	_Latin_extended_ADDITIONAL}');
    Error('\P{Is_Block=/a/	_Latin_extended_ADDITIONAL}');
    Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Is_Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Is_Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Is_Block=	LATIN_Extended_Additional}', "");
    Expect(0, 7935, '\p{^Is_Block=	LATIN_Extended_Additional}', "");
    Expect(0, 7935, '\P{Is_Block=	LATIN_Extended_Additional}', "");
    Expect(1, 7935, '\P{^Is_Block=	LATIN_Extended_Additional}', "");
    Expect(0, 7936, '\p{Is_Block=	LATIN_Extended_Additional}', "");
    Expect(1, 7936, '\p{^Is_Block=	LATIN_Extended_Additional}', "");
    Expect(1, 7936, '\P{Is_Block=	LATIN_Extended_Additional}', "");
    Expect(0, 7936, '\P{^Is_Block=	LATIN_Extended_Additional}', "");
    Error('\p{Is_Blk= :=Latin_ext_ADDITIONAL}');
    Error('\P{Is_Blk= :=Latin_ext_ADDITIONAL}');
    Expect(1, 7935, '\p{Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Is_Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Is_Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Is_Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Is_Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(0, 7935, '\p{^Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(0, 7935, '\P{Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(1, 7935, '\P{^Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(0, 7936, '\p{Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(1, 7936, '\p{^Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(1, 7936, '\P{Is_Blk=_LATIN_Ext_Additional}', "");
    Expect(0, 7936, '\P{^Is_Blk=_LATIN_Ext_Additional}', "");
    Error('\p{Block=:=-Latin_EXTENDED_B}');
    Error('\P{Block=:=-Latin_EXTENDED_B}');
    Expect(1, 591, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(0, 592, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(1, 591, '\p{Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Block=latinextendedb}', "");
    Expect(0, 591, '\P{Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Block=latinextendedb}', "");
    Expect(0, 592, '\p{Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Block=latinextendedb}', "");
    Expect(1, 592, '\P{Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Block=latinextendedb}', "");
    Expect(1, 591, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(0, 592, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(1, 591, '\p{Block=_Latin_Extended_B}', "");
    Expect(0, 591, '\p{^Block=_Latin_Extended_B}', "");
    Expect(0, 591, '\P{Block=_Latin_Extended_B}', "");
    Expect(1, 591, '\P{^Block=_Latin_Extended_B}', "");
    Expect(0, 592, '\p{Block=_Latin_Extended_B}', "");
    Expect(1, 592, '\p{^Block=_Latin_Extended_B}', "");
    Expect(1, 592, '\P{Block=_Latin_Extended_B}', "");
    Expect(0, 592, '\P{^Block=_Latin_Extended_B}', "");
    Error('\p{Blk=:=	LATIN_ext_B}');
    Error('\P{Blk=:=	LATIN_ext_B}');
    Expect(1, 591, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(0, 592, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(1, 591, '\p{Blk=latinextb}', "");
    Expect(0, 591, '\p{^Blk=latinextb}', "");
    Expect(0, 591, '\P{Blk=latinextb}', "");
    Expect(1, 591, '\P{^Blk=latinextb}', "");
    Expect(0, 592, '\p{Blk=latinextb}', "");
    Expect(1, 592, '\p{^Blk=latinextb}', "");
    Expect(1, 592, '\P{Blk=latinextb}', "");
    Expect(0, 592, '\P{^Blk=latinextb}', "");
    Expect(1, 591, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(0, 592, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(1, 591, '\p{Blk=_	Latin_Ext_B}', "");
    Expect(0, 591, '\p{^Blk=_	Latin_Ext_B}', "");
    Expect(0, 591, '\P{Blk=_	Latin_Ext_B}', "");
    Expect(1, 591, '\P{^Blk=_	Latin_Ext_B}', "");
    Expect(0, 592, '\p{Blk=_	Latin_Ext_B}', "");
    Expect(1, 592, '\p{^Blk=_	Latin_Ext_B}', "");
    Expect(1, 592, '\P{Blk=_	Latin_Ext_B}', "");
    Expect(0, 592, '\P{^Blk=_	Latin_Ext_B}', "");
    Error('\p{Is_Block=:= _latin_EXTENDED_B}');
    Error('\P{Is_Block=:= _latin_EXTENDED_B}');
    Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
    Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
    Expect(0, 592, '\p{Is_Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Is_Block=latinextendedb}', "");
    Expect(1, 592, '\P{Is_Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Is_Block=latinextendedb}', "");
    Expect(1, 591, '\p{Is_Block=_	latin_extended_B}', "");
    Expect(0, 591, '\p{^Is_Block=_	latin_extended_B}', "");
    Expect(0, 591, '\P{Is_Block=_	latin_extended_B}', "");
    Expect(1, 591, '\P{^Is_Block=_	latin_extended_B}', "");
    Expect(0, 592, '\p{Is_Block=_	latin_extended_B}', "");
    Expect(1, 592, '\p{^Is_Block=_	latin_extended_B}', "");
    Expect(1, 592, '\P{Is_Block=_	latin_extended_B}', "");
    Expect(0, 592, '\P{^Is_Block=_	latin_extended_B}', "");
    Error('\p{Is_Blk=-LATIN_Ext_B:=}');
    Error('\P{Is_Blk=-LATIN_Ext_B:=}');
    Expect(1, 591, '\p{Is_Blk: latinextb}', "");
    Expect(0, 591, '\p{^Is_Blk: latinextb}', "");
    Expect(0, 591, '\P{Is_Blk: latinextb}', "");
    Expect(1, 591, '\P{^Is_Blk: latinextb}', "");
    Expect(0, 592, '\p{Is_Blk: latinextb}', "");
    Expect(1, 592, '\p{^Is_Blk: latinextb}', "");
    Expect(1, 592, '\P{Is_Blk: latinextb}', "");
    Expect(0, 592, '\P{^Is_Blk: latinextb}', "");
    Expect(1, 591, '\p{Is_Blk=- Latin_Ext_B}', "");
    Expect(0, 591, '\p{^Is_Blk=- Latin_Ext_B}', "");
    Expect(0, 591, '\P{Is_Blk=- Latin_Ext_B}', "");
    Expect(1, 591, '\P{^Is_Blk=- Latin_Ext_B}', "");
    Expect(0, 592, '\p{Is_Blk=- Latin_Ext_B}', "");
    Expect(1, 592, '\p{^Is_Blk=- Latin_Ext_B}', "");
    Expect(1, 592, '\P{Is_Blk=- Latin_Ext_B}', "");
    Expect(0, 592, '\P{^Is_Blk=- Latin_Ext_B}', "");
    Error('\p{Block: /a/Latin_extended_C}');
    Error('\P{Block: /a/Latin_extended_C}');
    Expect(1, 11391, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(0, 11392, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(1, 11391, '\p{Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(0, 11392, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(1, 11391, '\p{Block=_	Latin_extended_C}', "");
    Expect(0, 11391, '\p{^Block=_	Latin_extended_C}', "");
    Expect(0, 11391, '\P{Block=_	Latin_extended_C}', "");
    Expect(1, 11391, '\P{^Block=_	Latin_extended_C}', "");
    Expect(0, 11392, '\p{Block=_	Latin_extended_C}', "");
    Expect(1, 11392, '\p{^Block=_	Latin_extended_C}', "");
    Expect(1, 11392, '\P{Block=_	Latin_extended_C}', "");
    Expect(0, 11392, '\P{^Block=_	Latin_extended_C}', "");
    Error('\p{Blk= 	Latin_Ext_C/a/}');
    Error('\P{Blk= 	Latin_Ext_C/a/}');
    Expect(1, 11391, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(1, 11391, '\p{Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Blk=latinextc}', "");
    Expect(0, 11391, '\P{Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Blk=latinextc}', "");
    Expect(0, 11392, '\p{Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Blk=latinextc}', "");
    Expect(1, 11392, '\P{Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Blk=latinextc}', "");
    Expect(1, 11391, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(1, 11391, '\p{Blk:   	LATIN_Ext_C}', "");
    Expect(0, 11391, '\p{^Blk:   	LATIN_Ext_C}', "");
    Expect(0, 11391, '\P{Blk:   	LATIN_Ext_C}', "");
    Expect(1, 11391, '\P{^Blk:   	LATIN_Ext_C}', "");
    Expect(0, 11392, '\p{Blk:   	LATIN_Ext_C}', "");
    Expect(1, 11392, '\p{^Blk:   	LATIN_Ext_C}', "");
    Expect(1, 11392, '\P{Blk:   	LATIN_Ext_C}', "");
    Expect(0, 11392, '\P{^Blk:   	LATIN_Ext_C}', "");
    Error('\p{Is_Block=/a/	LATIN_Extended_C}');
    Error('\P{Is_Block=/a/	LATIN_Extended_C}');
    Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Is_Block: _latin_Extended_c}', "");
    Expect(0, 11391, '\p{^Is_Block: _latin_Extended_c}', "");
    Expect(0, 11391, '\P{Is_Block: _latin_Extended_c}', "");
    Expect(1, 11391, '\P{^Is_Block: _latin_Extended_c}', "");
    Expect(0, 11392, '\p{Is_Block: _latin_Extended_c}', "");
    Expect(1, 11392, '\p{^Is_Block: _latin_Extended_c}', "");
    Expect(1, 11392, '\P{Is_Block: _latin_Extended_c}', "");
    Expect(0, 11392, '\P{^Is_Block: _latin_Extended_c}', "");
    Error('\p{Is_Blk=-Latin_ext_C:=}');
    Error('\P{Is_Blk=-Latin_ext_C:=}');
    Expect(1, 11391, '\p{Is_Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Is_Blk=latinextc}', "");
    Expect(0, 11391, '\P{Is_Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Is_Blk=latinextc}', "");
    Expect(0, 11392, '\p{Is_Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Is_Blk=latinextc}', "");
    Expect(1, 11392, '\P{Is_Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Is_Blk=latinextc}', "");
    Expect(1, 11391, '\p{Is_Blk=- latin_EXT_C}', "");
    Expect(0, 11391, '\p{^Is_Blk=- latin_EXT_C}', "");
    Expect(0, 11391, '\P{Is_Blk=- latin_EXT_C}', "");
    Expect(1, 11391, '\P{^Is_Blk=- latin_EXT_C}', "");
    Expect(0, 11392, '\p{Is_Blk=- latin_EXT_C}', "");
    Expect(1, 11392, '\p{^Is_Blk=- latin_EXT_C}', "");
    Expect(1, 11392, '\P{Is_Blk=- latin_EXT_C}', "");
    Expect(0, 11392, '\P{^Is_Blk=- latin_EXT_C}', "");
    Error('\p{Block=:=	latin_Extended_D}');
    Error('\P{Block=:=	latin_Extended_D}');
    Expect(1, 43007, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(0, 43008, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(1, 43007, '\p{Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(0, 43008, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(1, 43007, '\p{Block=_Latin_extended_D}', "");
    Expect(0, 43007, '\p{^Block=_Latin_extended_D}', "");
    Expect(0, 43007, '\P{Block=_Latin_extended_D}', "");
    Expect(1, 43007, '\P{^Block=_Latin_extended_D}', "");
    Expect(0, 43008, '\p{Block=_Latin_extended_D}', "");
    Expect(1, 43008, '\p{^Block=_Latin_extended_D}', "");
    Expect(1, 43008, '\P{Block=_Latin_extended_D}', "");
    Expect(0, 43008, '\P{^Block=_Latin_extended_D}', "");
    Error('\p{Blk= LATIN_EXT_D:=}');
    Error('\P{Blk= LATIN_EXT_D:=}');
    Expect(1, 43007, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(1, 43007, '\p{Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Blk=latinextd}', "");
    Expect(0, 43007, '\P{Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Blk=latinextd}', "");
    Expect(0, 43008, '\p{Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Blk=latinextd}', "");
    Expect(1, 43008, '\P{Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Blk=latinextd}', "");
    Expect(1, 43007, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(1, 43007, '\p{Blk= -Latin_Ext_D}', "");
    Expect(0, 43007, '\p{^Blk= -Latin_Ext_D}', "");
    Expect(0, 43007, '\P{Blk= -Latin_Ext_D}', "");
    Expect(1, 43007, '\P{^Blk= -Latin_Ext_D}', "");
    Expect(0, 43008, '\p{Blk= -Latin_Ext_D}', "");
    Expect(1, 43008, '\p{^Blk= -Latin_Ext_D}', "");
    Expect(1, 43008, '\P{Blk= -Latin_Ext_D}', "");
    Expect(0, 43008, '\P{^Blk= -Latin_Ext_D}', "");
    Error('\p{Is_Block=__LATIN_EXTENDED_d:=}');
    Error('\P{Is_Block=__LATIN_EXTENDED_d:=}');
    Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Is_Block=-	LATIN_extended_D}', "");
    Expect(0, 43007, '\p{^Is_Block=-	LATIN_extended_D}', "");
    Expect(0, 43007, '\P{Is_Block=-	LATIN_extended_D}', "");
    Expect(1, 43007, '\P{^Is_Block=-	LATIN_extended_D}', "");
    Expect(0, 43008, '\p{Is_Block=-	LATIN_extended_D}', "");
    Expect(1, 43008, '\p{^Is_Block=-	LATIN_extended_D}', "");
    Expect(1, 43008, '\P{Is_Block=-	LATIN_extended_D}', "");
    Expect(0, 43008, '\P{^Is_Block=-	LATIN_extended_D}', "");
    Error('\p{Is_Blk=	:=latin_Ext_d}');
    Error('\P{Is_Blk=	:=latin_Ext_d}');
    Expect(1, 43007, '\p{Is_Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Is_Blk=latinextd}', "");
    Expect(0, 43007, '\P{Is_Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Is_Blk=latinextd}', "");
    Expect(0, 43008, '\p{Is_Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Is_Blk=latinextd}', "");
    Expect(1, 43008, '\P{Is_Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Is_Blk=latinextd}', "");
    Expect(1, 43007, '\p{Is_Blk:	 LATIN_ext_D}', "");
    Expect(0, 43007, '\p{^Is_Blk:	 LATIN_ext_D}', "");
    Expect(0, 43007, '\P{Is_Blk:	 LATIN_ext_D}', "");
    Expect(1, 43007, '\P{^Is_Blk:	 LATIN_ext_D}', "");
    Expect(0, 43008, '\p{Is_Blk:	 LATIN_ext_D}', "");
    Expect(1, 43008, '\p{^Is_Blk:	 LATIN_ext_D}', "");
    Expect(1, 43008, '\P{Is_Blk:	 LATIN_ext_D}', "");
    Expect(0, 43008, '\P{^Is_Blk:	 LATIN_ext_D}', "");
    Error('\p{Block=:=-Latin_EXTENDED_e}');
    Error('\P{Block=:=-Latin_EXTENDED_e}');
    Expect(1, 43887, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(0, 43888, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(1, 43887, '\p{Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Block=latinextendede}', "");
    Expect(0, 43887, '\P{Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Block=latinextendede}', "");
    Expect(0, 43888, '\p{Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Block=latinextendede}', "");
    Expect(1, 43888, '\P{Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Block=latinextendede}', "");
    Expect(1, 43887, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(0, 43888, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(1, 43887, '\p{Block=_-Latin_EXTENDED_E}', "");
    Expect(0, 43887, '\p{^Block=_-Latin_EXTENDED_E}', "");
    Expect(0, 43887, '\P{Block=_-Latin_EXTENDED_E}', "");
    Expect(1, 43887, '\P{^Block=_-Latin_EXTENDED_E}', "");
    Expect(0, 43888, '\p{Block=_-Latin_EXTENDED_E}', "");
    Expect(1, 43888, '\p{^Block=_-Latin_EXTENDED_E}', "");
    Expect(1, 43888, '\P{Block=_-Latin_EXTENDED_E}', "");
    Expect(0, 43888, '\P{^Block=_-Latin_EXTENDED_E}', "");
    Error('\p{Blk=/a/ Latin_EXT_E}');
    Error('\P{Blk=/a/ Latin_EXT_E}');
    Expect(1, 43887, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(1, 43887, '\p{Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Blk=latinexte}', "");
    Expect(0, 43887, '\P{Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Blk=latinexte}', "");
    Expect(0, 43888, '\p{Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Blk=latinexte}', "");
    Expect(1, 43888, '\P{Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Blk=latinexte}', "");
    Expect(1, 43887, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(1, 43887, '\p{Blk=_ LATIN_ext_e}', "");
    Expect(0, 43887, '\p{^Blk=_ LATIN_ext_e}', "");
    Expect(0, 43887, '\P{Blk=_ LATIN_ext_e}', "");
    Expect(1, 43887, '\P{^Blk=_ LATIN_ext_e}', "");
    Expect(0, 43888, '\p{Blk=_ LATIN_ext_e}', "");
    Expect(1, 43888, '\p{^Blk=_ LATIN_ext_e}', "");
    Expect(1, 43888, '\P{Blk=_ LATIN_ext_e}', "");
    Expect(0, 43888, '\P{^Blk=_ LATIN_ext_e}', "");
    Error('\p{Is_Block=/a/--LATIN_EXTENDED_E}');
    Error('\P{Is_Block=/a/--LATIN_EXTENDED_E}');
    Expect(1, 43887, '\p{Is_Block: latinextendede}', "");
    Expect(0, 43887, '\p{^Is_Block: latinextendede}', "");
    Expect(0, 43887, '\P{Is_Block: latinextendede}', "");
    Expect(1, 43887, '\P{^Is_Block: latinextendede}', "");
    Expect(0, 43888, '\p{Is_Block: latinextendede}', "");
    Expect(1, 43888, '\p{^Is_Block: latinextendede}', "");
    Expect(1, 43888, '\P{Is_Block: latinextendede}', "");
    Expect(0, 43888, '\P{^Is_Block: latinextendede}', "");
    Expect(1, 43887, '\p{Is_Block=--Latin_extended_E}', "");
    Expect(0, 43887, '\p{^Is_Block=--Latin_extended_E}', "");
    Expect(0, 43887, '\P{Is_Block=--Latin_extended_E}', "");
    Expect(1, 43887, '\P{^Is_Block=--Latin_extended_E}', "");
    Expect(0, 43888, '\p{Is_Block=--Latin_extended_E}', "");
    Expect(1, 43888, '\p{^Is_Block=--Latin_extended_E}', "");
    Expect(1, 43888, '\P{Is_Block=--Latin_extended_E}', "");
    Expect(0, 43888, '\P{^Is_Block=--Latin_extended_E}', "");
    Error('\p{Is_Blk=-/a/latin_EXT_E}');
    Error('\P{Is_Blk=-/a/latin_EXT_E}');
    Expect(1, 43887, '\p{Is_Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Is_Blk=latinexte}', "");
    Expect(0, 43887, '\P{Is_Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Is_Blk=latinexte}', "");
    Expect(0, 43888, '\p{Is_Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Is_Blk=latinexte}', "");
    Expect(1, 43888, '\P{Is_Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Is_Blk=latinexte}', "");
    Expect(1, 43887, '\p{Is_Blk:-LATIN_Ext_E}', "");
    Expect(0, 43887, '\p{^Is_Blk:-LATIN_Ext_E}', "");
    Expect(0, 43887, '\P{Is_Blk:-LATIN_Ext_E}', "");
    Expect(1, 43887, '\P{^Is_Blk:-LATIN_Ext_E}', "");
    Expect(0, 43888, '\p{Is_Blk:-LATIN_Ext_E}', "");
    Expect(1, 43888, '\p{^Is_Blk:-LATIN_Ext_E}', "");
    Expect(1, 43888, '\P{Is_Blk:-LATIN_Ext_E}', "");
    Expect(0, 43888, '\P{^Is_Blk:-LATIN_Ext_E}', "");
    Error('\p{Block=:=_Lepcha}');
    Error('\P{Block=:=_Lepcha}');
    Expect(1, 7247, '\p{Block=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=lepcha}', "");
    Expect(0, 7247, '\p{^Block=lepcha}', "");
    Expect(0, 7247, '\P{Block=lepcha}', "");
    Expect(1, 7247, '\P{^Block=lepcha}', "");
    Expect(0, 7248, '\p{Block=lepcha}', "");
    Expect(1, 7248, '\p{^Block=lepcha}', "");
    Expect(1, 7248, '\P{Block=lepcha}', "");
    Expect(0, 7248, '\P{^Block=lepcha}', "");
    Expect(1, 7247, '\p{Block=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=_-Lepcha}', "");
    Expect(0, 7247, '\p{^Block=_-Lepcha}', "");
    Expect(0, 7247, '\P{Block=_-Lepcha}', "");
    Expect(1, 7247, '\P{^Block=_-Lepcha}', "");
    Expect(0, 7248, '\p{Block=_-Lepcha}', "");
    Expect(1, 7248, '\p{^Block=_-Lepcha}', "");
    Expect(1, 7248, '\P{Block=_-Lepcha}', "");
    Expect(0, 7248, '\P{^Block=_-Lepcha}', "");
    Error('\p{Blk=:=_LEPCHA}');
    Error('\P{Blk=:=_LEPCHA}');
    Expect(1, 7247, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Blk=lepcha}', "");
    Expect(0, 7247, '\P{Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Blk=lepcha}', "");
    Expect(0, 7248, '\p{Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Blk=lepcha}', "");
    Expect(1, 7248, '\P{Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Blk=lepcha}', "");
    Expect(1, 7247, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk= LEPCHA}', "");
    Expect(0, 7247, '\p{^Blk= LEPCHA}', "");
    Expect(0, 7247, '\P{Blk= LEPCHA}', "");
    Expect(1, 7247, '\P{^Blk= LEPCHA}', "");
    Expect(0, 7248, '\p{Blk= LEPCHA}', "");
    Expect(1, 7248, '\p{^Blk= LEPCHA}', "");
    Expect(1, 7248, '\P{Blk= LEPCHA}', "");
    Expect(0, 7248, '\P{^Blk= LEPCHA}', "");
    Error('\p{Is_Block= Lepcha:=}');
    Error('\P{Is_Block= Lepcha:=}');
    Expect(1, 7247, '\p{Is_Block=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=lepcha}', "");
    Expect(1, 7247, '\p{Is_Block=-	Lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=-	Lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=-	Lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=-	Lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=-	Lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=-	Lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=-	Lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=-	Lepcha}', "");
    Error('\p{Is_Blk=:=-	Lepcha}');
    Error('\P{Is_Blk=:=-	Lepcha}');
    Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=lepcha}', "");
    Error('\p{Block:   /a/ -LETTERLIKE_SYMBOLS}');
    Error('\P{Block:   /a/ -LETTERLIKE_SYMBOLS}');
    Expect(1, 8527, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Block:letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Block:letterlikesymbols}', "");
    Expect(0, 8527, '\P{Block:letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Block:letterlikesymbols}', "");
    Expect(0, 8528, '\p{Block:letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Block:letterlikesymbols}', "");
    Expect(1, 8528, '\P{Block:letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Block:letterlikesymbols}', "");
    Expect(1, 8527, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Block:	 Letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Block:	 Letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Block:	 Letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Block:	 Letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Block:	 Letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Block:	 Letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Block:	 Letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Block:	 Letterlike_Symbols}', "");
    Error('\p{Blk=_letterlike_symbols:=}');
    Error('\P{Blk=_letterlike_symbols:=}');
    Expect(1, 8527, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\p{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\P{Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8527, '\P{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\p{Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\p{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\P{Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\P{^Blk=-LETTERLIKE_Symbols}', "");
    Error('\p{Is_Block=:= Letterlike_Symbols}');
    Error('\P{Is_Block=:= Letterlike_Symbols}');
    Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\p{^Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(0, 8527, '\P{Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(1, 8527, '\P{^Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\p{Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\p{^Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(1, 8528, '\P{Is_Block=_-LETTERLIKE_symbols}', "");
    Expect(0, 8528, '\P{^Is_Block=_-LETTERLIKE_symbols}', "");
    Error('\p{Is_Blk=/a/ -LETTERLIKE_SYMBOLS}');
    Error('\P{Is_Blk=/a/ -LETTERLIKE_SYMBOLS}');
    Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Blk=_letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=_letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Is_Blk=_letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=_letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Is_Blk=_letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=_letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Is_Blk=_letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=_letterlike_Symbols}', "");
    Error('\p{Block=	Limbu/a/}');
    Error('\P{Block=	Limbu/a/}');
    Expect(1, 6479, '\p{Block=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Block=limbu}', "");
    Expect(0, 6479, '\p{^Block=limbu}', "");
    Expect(0, 6479, '\P{Block=limbu}', "");
    Expect(1, 6479, '\P{^Block=limbu}', "");
    Expect(0, 6480, '\p{Block=limbu}', "");
    Expect(1, 6480, '\p{^Block=limbu}', "");
    Expect(1, 6480, '\P{Block=limbu}', "");
    Expect(0, 6480, '\P{^Block=limbu}', "");
    Expect(1, 6479, '\p{Block=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Block: -Limbu}', "");
    Expect(0, 6479, '\p{^Block: -Limbu}', "");
    Expect(0, 6479, '\P{Block: -Limbu}', "");
    Expect(1, 6479, '\P{^Block: -Limbu}', "");
    Expect(0, 6480, '\p{Block: -Limbu}', "");
    Expect(1, 6480, '\p{^Block: -Limbu}', "");
    Expect(1, 6480, '\P{Block: -Limbu}', "");
    Expect(0, 6480, '\P{^Block: -Limbu}', "");
    Error('\p{Blk= Limbu:=}');
    Error('\P{Blk= Limbu:=}');
    Expect(1, 6479, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=limbu}', "");
    Expect(0, 6479, '\p{^Blk=limbu}', "");
    Expect(0, 6479, '\P{Blk=limbu}', "");
    Expect(1, 6479, '\P{^Blk=limbu}', "");
    Expect(0, 6480, '\p{Blk=limbu}', "");
    Expect(1, 6480, '\p{^Blk=limbu}', "");
    Expect(1, 6480, '\P{Blk=limbu}', "");
    Expect(0, 6480, '\P{^Blk=limbu}', "");
    Expect(1, 6479, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=		LIMBU}', "");
    Expect(0, 6479, '\p{^Blk=		LIMBU}', "");
    Expect(0, 6479, '\P{Blk=		LIMBU}', "");
    Expect(1, 6479, '\P{^Blk=		LIMBU}', "");
    Expect(0, 6480, '\p{Blk=		LIMBU}', "");
    Expect(1, 6480, '\p{^Blk=		LIMBU}', "");
    Expect(1, 6480, '\P{Blk=		LIMBU}', "");
    Expect(0, 6480, '\P{^Blk=		LIMBU}', "");
    Error('\p{Is_Block=:=		limbu}');
    Error('\P{Is_Block=:=		limbu}');
    Expect(1, 6479, '\p{Is_Block=limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=limbu}', "");
    Expect(0, 6479, '\P{Is_Block=limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=limbu}', "");
    Expect(0, 6480, '\p{Is_Block=limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=limbu}', "");
    Expect(1, 6480, '\P{Is_Block=limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=limbu}', "");
    Expect(1, 6479, '\p{Is_Block=_-Limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=_-Limbu}', "");
    Expect(0, 6479, '\P{Is_Block=_-Limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=_-Limbu}', "");
    Expect(0, 6480, '\p{Is_Block=_-Limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=_-Limbu}', "");
    Expect(1, 6480, '\P{Is_Block=_-Limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=_-Limbu}', "");
    Error('\p{Is_Blk:   _-Limbu:=}');
    Error('\P{Is_Blk:   _-Limbu:=}');
    Expect(1, 6479, '\p{Is_Blk:   limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk:   limbu}', "");
    Expect(0, 6479, '\P{Is_Blk:   limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk:   limbu}', "");
    Expect(0, 6480, '\p{Is_Blk:   limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk:   limbu}', "");
    Expect(1, 6480, '\P{Is_Blk:   limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk:   limbu}', "");
    Expect(1, 6479, '\p{Is_Blk=	_Limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=	_Limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=	_Limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=	_Limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=	_Limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=	_Limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=	_Limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=	_Limbu}', "");
    Error('\p{Block=/a/-_Linear_A}');
    Error('\P{Block=/a/-_Linear_A}');
    Expect(1, 67455, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Block=lineara}', "");
    Expect(0, 67455, '\p{^Block=lineara}', "");
    Expect(0, 67455, '\P{Block=lineara}', "");
    Expect(1, 67455, '\P{^Block=lineara}', "");
    Expect(0, 67456, '\p{Block=lineara}', "");
    Expect(1, 67456, '\p{^Block=lineara}', "");
    Expect(1, 67456, '\P{Block=lineara}', "");
    Expect(0, 67456, '\P{^Block=lineara}', "");
    Expect(1, 67455, '\p{Block=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Block=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Block:_ LINEAR_A}', "");
    Expect(0, 67455, '\p{^Block:_ LINEAR_A}', "");
    Expect(0, 67455, '\P{Block:_ LINEAR_A}', "");
    Expect(1, 67455, '\P{^Block:_ LINEAR_A}', "");
    Expect(0, 67456, '\p{Block:_ LINEAR_A}', "");
    Expect(1, 67456, '\p{^Block:_ LINEAR_A}', "");
    Expect(1, 67456, '\P{Block:_ LINEAR_A}', "");
    Expect(0, 67456, '\P{^Block:_ LINEAR_A}', "");
    Error('\p{Blk=--Linear_A:=}');
    Error('\P{Blk=--Linear_A:=}');
    Expect(1, 67455, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Blk=lineara}', "");
    Expect(0, 67455, '\p{^Blk=lineara}', "");
    Expect(0, 67455, '\P{Blk=lineara}', "");
    Expect(1, 67455, '\P{^Blk=lineara}', "");
    Expect(0, 67456, '\p{Blk=lineara}', "");
    Expect(1, 67456, '\p{^Blk=lineara}', "");
    Expect(1, 67456, '\P{Blk=lineara}', "");
    Expect(0, 67456, '\P{^Blk=lineara}', "");
    Expect(1, 67455, '\p{Blk=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Blk: 	 Linear_A}', "");
    Expect(0, 67455, '\p{^Blk: 	 Linear_A}', "");
    Expect(0, 67455, '\P{Blk: 	 Linear_A}', "");
    Expect(1, 67455, '\P{^Blk: 	 Linear_A}', "");
    Expect(0, 67456, '\p{Blk: 	 Linear_A}', "");
    Expect(1, 67456, '\p{^Blk: 	 Linear_A}', "");
    Expect(1, 67456, '\P{Blk: 	 Linear_A}', "");
    Expect(0, 67456, '\P{^Blk: 	 Linear_A}', "");
    Error('\p{Is_Block=:=-_Linear_A}');
    Error('\P{Is_Block=:=-_Linear_A}');
    Expect(1, 67455, '\p{Is_Block=lineara}', "");
    Expect(0, 67455, '\p{^Is_Block=lineara}', "");
    Expect(0, 67455, '\P{Is_Block=lineara}', "");
    Expect(1, 67455, '\P{^Is_Block=lineara}', "");
    Expect(0, 67456, '\p{Is_Block=lineara}', "");
    Expect(1, 67456, '\p{^Is_Block=lineara}', "");
    Expect(1, 67456, '\P{Is_Block=lineara}', "");
    Expect(0, 67456, '\P{^Is_Block=lineara}', "");
    Expect(1, 67455, '\p{Is_Block=-	linear_a}', "");
    Expect(0, 67455, '\p{^Is_Block=-	linear_a}', "");
    Expect(0, 67455, '\P{Is_Block=-	linear_a}', "");
    Expect(1, 67455, '\P{^Is_Block=-	linear_a}', "");
    Expect(0, 67456, '\p{Is_Block=-	linear_a}', "");
    Expect(1, 67456, '\p{^Is_Block=-	linear_a}', "");
    Expect(1, 67456, '\P{Is_Block=-	linear_a}', "");
    Expect(0, 67456, '\P{^Is_Block=-	linear_a}', "");
    Error('\p{Is_Blk=	/a/Linear_a}');
    Error('\P{Is_Blk=	/a/Linear_a}');
    Expect(1, 67455, '\p{Is_Blk=lineara}', "");
    Expect(0, 67455, '\p{^Is_Blk=lineara}', "");
    Expect(0, 67455, '\P{Is_Blk=lineara}', "");
    Expect(1, 67455, '\P{^Is_Blk=lineara}', "");
    Expect(0, 67456, '\p{Is_Blk=lineara}', "");
    Expect(1, 67456, '\p{^Is_Blk=lineara}', "");
    Expect(1, 67456, '\P{Is_Blk=lineara}', "");
    Expect(0, 67456, '\P{^Is_Blk=lineara}', "");
    Expect(1, 67455, '\p{Is_Blk= LINEAR_A}', "");
    Expect(0, 67455, '\p{^Is_Blk= LINEAR_A}', "");
    Expect(0, 67455, '\P{Is_Blk= LINEAR_A}', "");
    Expect(1, 67455, '\P{^Is_Blk= LINEAR_A}', "");
    Expect(0, 67456, '\p{Is_Blk= LINEAR_A}', "");
    Expect(1, 67456, '\p{^Is_Blk= LINEAR_A}', "");
    Expect(1, 67456, '\P{Is_Blk= LINEAR_A}', "");
    Expect(0, 67456, '\P{^Is_Blk= LINEAR_A}', "");
    Error('\p{Block=:=- LINEAR_B_Ideograms}');
    Error('\P{Block=:=- LINEAR_B_Ideograms}');
    Expect(1, 65791, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=	_linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Block=	_linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Block=	_linear_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Block=	_linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Block=	_linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Block=	_linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Block=	_linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Block=	_linear_B_IDEOGRAMS}', "");
    Error('\p{Blk=/a/	Linear_B_Ideograms}');
    Error('\P{Blk=/a/	Linear_B_Ideograms}');
    Expect(1, 65791, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=--Linear_b_Ideograms}', "");
    Expect(0, 65791, '\p{^Blk=--Linear_b_Ideograms}', "");
    Expect(0, 65791, '\P{Blk=--Linear_b_Ideograms}', "");
    Expect(1, 65791, '\P{^Blk=--Linear_b_Ideograms}', "");
    Expect(0, 65792, '\p{Blk=--Linear_b_Ideograms}', "");
    Expect(1, 65792, '\p{^Blk=--Linear_b_Ideograms}', "");
    Expect(1, 65792, '\P{Blk=--Linear_b_Ideograms}', "");
    Expect(0, 65792, '\P{^Blk=--Linear_b_Ideograms}', "");
    Error('\p{Is_Block=/a/-linear_B_Ideograms}');
    Error('\P{Is_Block=/a/-linear_B_Ideograms}');
    Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Block:-_Linear_B_Ideograms}', "");
    Expect(0, 65791, '\p{^Is_Block:-_Linear_B_Ideograms}', "");
    Expect(0, 65791, '\P{Is_Block:-_Linear_B_Ideograms}', "");
    Expect(1, 65791, '\P{^Is_Block:-_Linear_B_Ideograms}', "");
    Expect(0, 65792, '\p{Is_Block:-_Linear_B_Ideograms}', "");
    Expect(1, 65792, '\p{^Is_Block:-_Linear_B_Ideograms}', "");
    Expect(1, 65792, '\P{Is_Block:-_Linear_B_Ideograms}', "");
    Expect(0, 65792, '\P{^Is_Block:-_Linear_B_Ideograms}', "");
    Error('\p{Is_Blk=		LINEAR_B_Ideograms/a/}');
    Error('\P{Is_Blk=		LINEAR_B_Ideograms/a/}');
    Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Blk=	Linear_b_Ideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=	Linear_b_Ideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=	Linear_b_Ideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=	Linear_b_Ideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=	Linear_b_Ideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=	Linear_b_Ideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=	Linear_b_Ideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=	Linear_b_Ideograms}', "");
    Error('\p{Block=-:=Linear_B_SYLLABARY}');
    Error('\P{Block=-:=Linear_B_SYLLABARY}');
    Expect(1, 65663, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=  Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Block=  Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Block=  Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Block=  Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Block=  Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Block=  Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Block=  Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Block=  Linear_B_Syllabary}', "");
    Error('\p{Blk=:=_-LINEAR_B_SYLLABARY}');
    Error('\P{Blk=:=_-LINEAR_B_SYLLABARY}');
    Expect(1, 65663, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk=		Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Blk=		Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Blk=		Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Blk=		Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Blk=		Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Blk=		Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Blk=		Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Blk=		Linear_B_Syllabary}', "");
    Error('\p{Is_Block=/a/ 	linear_B_Syllabary}');
    Error('\P{Is_Block=/a/ 	linear_B_Syllabary}');
    Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Block=_Linear_b_syllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=_Linear_b_syllabary}', "");
    Expect(0, 65663, '\P{Is_Block=_Linear_b_syllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=_Linear_b_syllabary}', "");
    Expect(0, 65664, '\p{Is_Block=_Linear_b_syllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=_Linear_b_syllabary}', "");
    Expect(1, 65664, '\P{Is_Block=_Linear_b_syllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=_Linear_b_syllabary}', "");
    Error('\p{Is_Blk=_-linear_b_SYLLABARY/a/}');
    Error('\P{Is_Blk=_-linear_b_SYLLABARY/a/}');
    Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(0, 65663, '\P{Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(0, 65664, '\p{Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(1, 65664, '\P{Is_Blk:	 LINEAR_B_syllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk:	 LINEAR_B_syllabary}', "");
    Error('\p{Block= :=Lisu}');
    Error('\P{Block= :=Lisu}');
    Expect(1, 42239, '\p{Block=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Block=lisu}', "");
    Expect(0, 42239, '\p{^Block=lisu}', "");
    Expect(0, 42239, '\P{Block=lisu}', "");
    Expect(1, 42239, '\P{^Block=lisu}', "");
    Expect(0, 42240, '\p{Block=lisu}', "");
    Expect(1, 42240, '\p{^Block=lisu}', "");
    Expect(1, 42240, '\P{Block=lisu}', "");
    Expect(0, 42240, '\P{^Block=lisu}', "");
    Expect(1, 42239, '\p{Block=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Block=--lisu}', "");
    Expect(0, 42239, '\p{^Block=--lisu}', "");
    Expect(0, 42239, '\P{Block=--lisu}', "");
    Expect(1, 42239, '\P{^Block=--lisu}', "");
    Expect(0, 42240, '\p{Block=--lisu}', "");
    Expect(1, 42240, '\p{^Block=--lisu}', "");
    Expect(1, 42240, '\P{Block=--lisu}', "");
    Expect(0, 42240, '\P{^Block=--lisu}', "");
    Error('\p{Blk=:=	Lisu}');
    Error('\P{Blk=:=	Lisu}');
    Expect(1, 42239, '\p{Blk=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Blk=lisu}', "");
    Expect(0, 42239, '\p{^Blk=lisu}', "");
    Expect(0, 42239, '\P{Blk=lisu}', "");
    Expect(1, 42239, '\P{^Blk=lisu}', "");
    Expect(0, 42240, '\p{Blk=lisu}', "");
    Expect(1, 42240, '\p{^Blk=lisu}', "");
    Expect(1, 42240, '\P{Blk=lisu}', "");
    Expect(0, 42240, '\P{^Blk=lisu}', "");
    Expect(1, 42239, '\p{Blk=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Blk= 	LISU}', "");
    Expect(0, 42239, '\p{^Blk= 	LISU}', "");
    Expect(0, 42239, '\P{Blk= 	LISU}', "");
    Expect(1, 42239, '\P{^Blk= 	LISU}', "");
    Expect(0, 42240, '\p{Blk= 	LISU}', "");
    Expect(1, 42240, '\p{^Blk= 	LISU}', "");
    Expect(1, 42240, '\P{Blk= 	LISU}', "");
    Expect(0, 42240, '\P{^Blk= 	LISU}', "");
    Error('\p{Is_Block:_:=lisu}');
    Error('\P{Is_Block:_:=lisu}');
    Expect(1, 42239, '\p{Is_Block=lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=lisu}', "");
    Expect(0, 42239, '\P{Is_Block=lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=lisu}', "");
    Expect(0, 42240, '\p{Is_Block=lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=lisu}', "");
    Expect(1, 42240, '\P{Is_Block=lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=lisu}', "");
    Expect(1, 42239, '\p{Is_Block= LISU}', "");
    Expect(0, 42239, '\p{^Is_Block= LISU}', "");
    Expect(0, 42239, '\P{Is_Block= LISU}', "");
    Expect(1, 42239, '\P{^Is_Block= LISU}', "");
    Expect(0, 42240, '\p{Is_Block= LISU}', "");
    Expect(1, 42240, '\p{^Is_Block= LISU}', "");
    Expect(1, 42240, '\P{Is_Block= LISU}', "");
    Expect(0, 42240, '\P{^Is_Block= LISU}', "");
    Error('\p{Is_Blk: /a/ _Lisu}');
    Error('\P{Is_Blk: /a/ _Lisu}');
    Expect(1, 42239, '\p{Is_Blk=lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=lisu}', "");
    Expect(1, 42239, '\p{Is_Blk= -lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk= -lisu}', "");
    Expect(0, 42239, '\P{Is_Blk= -lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk= -lisu}', "");
    Expect(0, 42240, '\p{Is_Blk= -lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk= -lisu}', "");
    Expect(1, 42240, '\P{Is_Blk= -lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk= -lisu}', "");
    Error('\p{Block=--Lisu_SUPPLEMENT:=}');
    Error('\P{Block=--Lisu_SUPPLEMENT:=}');
    Expect(1, 73663, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(1, 73663, '\p{Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(1, 73663, '\p{Block=__Lisu_supplement}', "");
    Expect(0, 73663, '\p{^Block=__Lisu_supplement}', "");
    Expect(0, 73663, '\P{Block=__Lisu_supplement}', "");
    Expect(1, 73663, '\P{^Block=__Lisu_supplement}', "");
    Expect(0, 73664, '\p{Block=__Lisu_supplement}', "");
    Expect(1, 73664, '\p{^Block=__Lisu_supplement}', "");
    Expect(1, 73664, '\P{Block=__Lisu_supplement}', "");
    Expect(0, 73664, '\P{^Block=__Lisu_supplement}', "");
    Error('\p{Blk=		LISU_Sup/a/}');
    Error('\P{Blk=		LISU_Sup/a/}');
    Expect(1, 73663, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(1, 73663, '\p{Blk=lisusup}', "");
    Expect(0, 73663, '\p{^Blk=lisusup}', "");
    Expect(0, 73663, '\P{Blk=lisusup}', "");
    Expect(1, 73663, '\P{^Blk=lisusup}', "");
    Expect(0, 73664, '\p{Blk=lisusup}', "");
    Expect(1, 73664, '\p{^Blk=lisusup}', "");
    Expect(1, 73664, '\P{Blk=lisusup}', "");
    Expect(0, 73664, '\P{^Blk=lisusup}', "");
    Expect(1, 73663, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(1, 73663, '\p{Blk=	-Lisu_sup}', "");
    Expect(0, 73663, '\p{^Blk=	-Lisu_sup}', "");
    Expect(0, 73663, '\P{Blk=	-Lisu_sup}', "");
    Expect(1, 73663, '\P{^Blk=	-Lisu_sup}', "");
    Expect(0, 73664, '\p{Blk=	-Lisu_sup}', "");
    Expect(1, 73664, '\p{^Blk=	-Lisu_sup}', "");
    Expect(1, 73664, '\P{Blk=	-Lisu_sup}', "");
    Expect(0, 73664, '\P{^Blk=	-Lisu_sup}', "");
    Error('\p{Is_Block=	_Lisu_Supplement:=}');
    Error('\P{Is_Block=	_Lisu_Supplement:=}');
    Expect(1, 73663, '\p{Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Is_Block:_Lisu_Supplement}', "");
    Expect(0, 73663, '\p{^Is_Block:_Lisu_Supplement}', "");
    Expect(0, 73663, '\P{Is_Block:_Lisu_Supplement}', "");
    Expect(1, 73663, '\P{^Is_Block:_Lisu_Supplement}', "");
    Expect(0, 73664, '\p{Is_Block:_Lisu_Supplement}', "");
    Expect(1, 73664, '\p{^Is_Block:_Lisu_Supplement}', "");
    Expect(1, 73664, '\P{Is_Block:_Lisu_Supplement}', "");
    Expect(0, 73664, '\P{^Is_Block:_Lisu_Supplement}', "");
    Error('\p{Is_Blk=	-Lisu_Sup:=}');
    Error('\P{Is_Blk=	-Lisu_Sup:=}');
    Expect(1, 73663, '\p{Is_Blk=lisusup}', "");
    Expect(0, 73663, '\p{^Is_Blk=lisusup}', "");
    Expect(0, 73663, '\P{Is_Blk=lisusup}', "");
    Expect(1, 73663, '\P{^Is_Blk=lisusup}', "");
    Expect(0, 73664, '\p{Is_Blk=lisusup}', "");
    Expect(1, 73664, '\p{^Is_Blk=lisusup}', "");
    Expect(1, 73664, '\P{Is_Blk=lisusup}', "");
    Expect(0, 73664, '\P{^Is_Blk=lisusup}', "");
    Expect(1, 73663, '\p{Is_Blk=-_Lisu_Sup}', "");
    Expect(0, 73663, '\p{^Is_Blk=-_Lisu_Sup}', "");
    Expect(0, 73663, '\P{Is_Blk=-_Lisu_Sup}', "");
    Expect(1, 73663, '\P{^Is_Blk=-_Lisu_Sup}', "");
    Expect(0, 73664, '\p{Is_Blk=-_Lisu_Sup}', "");
    Expect(1, 73664, '\p{^Is_Blk=-_Lisu_Sup}', "");
    Expect(1, 73664, '\P{Is_Blk=-_Lisu_Sup}', "");
    Expect(0, 73664, '\P{^Is_Blk=-_Lisu_Sup}', "");
    Error('\p{Block:	:=-_low_Surrogates}');
    Error('\P{Block:	:=-_low_Surrogates}');
    Expect(1, 57343, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Block:	_-Low_surrogates}', "");
    Expect(0, 57343, '\p{^Block:	_-Low_surrogates}', "");
    Expect(0, 57343, '\P{Block:	_-Low_surrogates}', "");
    Expect(1, 57343, '\P{^Block:	_-Low_surrogates}', "");
    Expect(0, 57344, '\p{Block:	_-Low_surrogates}', "");
    Expect(1, 57344, '\p{^Block:	_-Low_surrogates}', "");
    Expect(1, 57344, '\P{Block:	_-Low_surrogates}', "");
    Expect(0, 57344, '\P{^Block:	_-Low_surrogates}', "");
    Error('\p{Blk=-/a/Low_surrogates}');
    Error('\P{Blk=-/a/Low_surrogates}');
    Expect(1, 57343, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=  LOW_Surrogates}', "");
    Expect(0, 57343, '\p{^Blk=  LOW_Surrogates}', "");
    Expect(0, 57343, '\P{Blk=  LOW_Surrogates}', "");
    Expect(1, 57343, '\P{^Blk=  LOW_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=  LOW_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=  LOW_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=  LOW_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=  LOW_Surrogates}', "");
    Error('\p{Is_Block: :=_	Low_Surrogates}');
    Error('\P{Is_Block: :=_	Low_Surrogates}');
    Expect(1, 57343, '\p{Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Block:   Low_SURROGATES}', "");
    Expect(0, 57343, '\p{^Is_Block:   Low_SURROGATES}', "");
    Expect(0, 57343, '\P{Is_Block:   Low_SURROGATES}', "");
    Expect(1, 57343, '\P{^Is_Block:   Low_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block:   Low_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block:   Low_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block:   Low_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block:   Low_SURROGATES}', "");
    Error('\p{Is_Blk= -Low_Surrogates/a/}');
    Error('\P{Is_Blk= -Low_Surrogates/a/}');
    Expect(1, 57343, '\p{Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Blk=	low_Surrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=	low_Surrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=	low_Surrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=	low_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=	low_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=	low_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=	low_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=	low_Surrogates}', "");
    Error('\p{Block=-Lycian/a/}');
    Error('\P{Block=-Lycian/a/}');
    Expect(1, 66207, '\p{Block=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Block=lycian}', "");
    Expect(0, 66207, '\p{^Block=lycian}', "");
    Expect(0, 66207, '\P{Block=lycian}', "");
    Expect(1, 66207, '\P{^Block=lycian}', "");
    Expect(0, 66208, '\p{Block=lycian}', "");
    Expect(1, 66208, '\p{^Block=lycian}', "");
    Expect(1, 66208, '\P{Block=lycian}', "");
    Expect(0, 66208, '\P{^Block=lycian}', "");
    Expect(1, 66207, '\p{Block=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Block=	Lycian}', "");
    Expect(0, 66207, '\p{^Block=	Lycian}', "");
    Expect(0, 66207, '\P{Block=	Lycian}', "");
    Expect(1, 66207, '\P{^Block=	Lycian}', "");
    Expect(0, 66208, '\p{Block=	Lycian}', "");
    Expect(1, 66208, '\p{^Block=	Lycian}', "");
    Expect(1, 66208, '\P{Block=	Lycian}', "");
    Expect(0, 66208, '\P{^Block=	Lycian}', "");
    Error('\p{Blk:-	lycian:=}');
    Error('\P{Blk:-	lycian:=}');
    Expect(1, 66207, '\p{Blk=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=lycian}', "");
    Expect(0, 66207, '\p{^Blk=lycian}', "");
    Expect(0, 66207, '\P{Blk=lycian}', "");
    Expect(1, 66207, '\P{^Blk=lycian}', "");
    Expect(0, 66208, '\p{Blk=lycian}', "");
    Expect(1, 66208, '\p{^Blk=lycian}', "");
    Expect(1, 66208, '\P{Blk=lycian}', "");
    Expect(0, 66208, '\P{^Blk=lycian}', "");
    Expect(1, 66207, '\p{Blk=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=-_lycian}', "");
    Expect(0, 66207, '\p{^Blk=-_lycian}', "");
    Expect(0, 66207, '\P{Blk=-_lycian}', "");
    Expect(1, 66207, '\P{^Blk=-_lycian}', "");
    Expect(0, 66208, '\p{Blk=-_lycian}', "");
    Expect(1, 66208, '\p{^Blk=-_lycian}', "");
    Expect(1, 66208, '\P{Blk=-_lycian}', "");
    Expect(0, 66208, '\P{^Blk=-_lycian}', "");
    Error('\p{Is_Block=:=	Lycian}');
    Error('\P{Is_Block=:=	Lycian}');
    Expect(1, 66207, '\p{Is_Block=lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=lycian}', "");
    Expect(0, 66207, '\P{Is_Block=lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=lycian}', "");
    Expect(0, 66208, '\p{Is_Block=lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=lycian}', "");
    Expect(1, 66208, '\P{Is_Block=lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=lycian}', "");
    Expect(1, 66207, '\p{Is_Block=	Lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=	Lycian}', "");
    Expect(0, 66207, '\P{Is_Block=	Lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=	Lycian}', "");
    Expect(0, 66208, '\p{Is_Block=	Lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=	Lycian}', "");
    Expect(1, 66208, '\P{Is_Block=	Lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=	Lycian}', "");
    Error('\p{Is_Blk=  Lycian/a/}');
    Error('\P{Is_Blk=  Lycian/a/}');
    Expect(1, 66207, '\p{Is_Blk=lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=lycian}', "");
    Expect(1, 66207, '\p{Is_Blk=-	Lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=-	Lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=-	Lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=-	Lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=-	Lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=-	Lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=-	Lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=-	Lycian}', "");
    Error('\p{Block=/a/_Lydian}');
    Error('\P{Block=/a/_Lydian}');
    Expect(1, 67903, '\p{Block=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Block=lydian}', "");
    Expect(0, 67903, '\p{^Block=lydian}', "");
    Expect(0, 67903, '\P{Block=lydian}', "");
    Expect(1, 67903, '\P{^Block=lydian}', "");
    Expect(0, 67904, '\p{Block=lydian}', "");
    Expect(1, 67904, '\p{^Block=lydian}', "");
    Expect(1, 67904, '\P{Block=lydian}', "");
    Expect(0, 67904, '\P{^Block=lydian}', "");
    Expect(1, 67903, '\p{Block=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Block=  LYDIAN}', "");
    Expect(0, 67903, '\p{^Block=  LYDIAN}', "");
    Expect(0, 67903, '\P{Block=  LYDIAN}', "");
    Expect(1, 67903, '\P{^Block=  LYDIAN}', "");
    Expect(0, 67904, '\p{Block=  LYDIAN}', "");
    Expect(1, 67904, '\p{^Block=  LYDIAN}', "");
    Expect(1, 67904, '\P{Block=  LYDIAN}', "");
    Expect(0, 67904, '\P{^Block=  LYDIAN}', "");
    Error('\p{Blk:	:=lydian}');
    Error('\P{Blk:	:=lydian}');
    Expect(1, 67903, '\p{Blk=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=lydian}', "");
    Expect(0, 67903, '\p{^Blk=lydian}', "");
    Expect(0, 67903, '\P{Blk=lydian}', "");
    Expect(1, 67903, '\P{^Blk=lydian}', "");
    Expect(0, 67904, '\p{Blk=lydian}', "");
    Expect(1, 67904, '\p{^Blk=lydian}', "");
    Expect(1, 67904, '\P{Blk=lydian}', "");
    Expect(0, 67904, '\P{^Blk=lydian}', "");
    Expect(1, 67903, '\p{Blk=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=	 lydian}', "");
    Expect(0, 67903, '\p{^Blk=	 lydian}', "");
    Expect(0, 67903, '\P{Blk=	 lydian}', "");
    Expect(1, 67903, '\P{^Blk=	 lydian}', "");
    Expect(0, 67904, '\p{Blk=	 lydian}', "");
    Expect(1, 67904, '\p{^Blk=	 lydian}', "");
    Expect(1, 67904, '\P{Blk=	 lydian}', "");
    Expect(0, 67904, '\P{^Blk=	 lydian}', "");
    Error('\p{Is_Block= /a/LYDIAN}');
    Error('\P{Is_Block= /a/LYDIAN}');
    Expect(1, 67903, '\p{Is_Block=lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=lydian}', "");
    Expect(0, 67903, '\P{Is_Block=lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=lydian}', "");
    Expect(0, 67904, '\p{Is_Block=lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=lydian}', "");
    Expect(1, 67904, '\P{Is_Block=lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=lydian}', "");
    Expect(1, 67903, '\p{Is_Block= -Lydian}', "");
    Expect(0, 67903, '\p{^Is_Block= -Lydian}', "");
    Expect(0, 67903, '\P{Is_Block= -Lydian}', "");
    Expect(1, 67903, '\P{^Is_Block= -Lydian}', "");
    Expect(0, 67904, '\p{Is_Block= -Lydian}', "");
    Expect(1, 67904, '\p{^Is_Block= -Lydian}', "");
    Expect(1, 67904, '\P{Is_Block= -Lydian}', "");
    Expect(0, 67904, '\P{^Is_Block= -Lydian}', "");
    Error('\p{Is_Blk:	-/a/LYDIAN}');
    Error('\P{Is_Blk:	-/a/LYDIAN}');
    Expect(1, 67903, '\p{Is_Blk: lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk: lydian}', "");
    Expect(0, 67903, '\P{Is_Blk: lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk: lydian}', "");
    Expect(0, 67904, '\p{Is_Blk: lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk: lydian}', "");
    Expect(1, 67904, '\P{Is_Blk: lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk: lydian}', "");
    Expect(1, 67903, '\p{Is_Blk=-	lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=-	lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=-	lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=-	lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=-	lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=-	lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=-	lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=-	lydian}', "");
    Error('\p{Block= :=MAHAJANI}');
    Error('\P{Block= :=MAHAJANI}');
    Expect(1, 70015, '\p{Block=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=mahajani}', "");
    Expect(0, 70015, '\p{^Block=mahajani}', "");
    Expect(0, 70015, '\P{Block=mahajani}', "");
    Expect(1, 70015, '\P{^Block=mahajani}', "");
    Expect(0, 70016, '\p{Block=mahajani}', "");
    Expect(1, 70016, '\p{^Block=mahajani}', "");
    Expect(1, 70016, '\P{Block=mahajani}', "");
    Expect(0, 70016, '\P{^Block=mahajani}', "");
    Expect(1, 70015, '\p{Block=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Block= 	Mahajani}', "");
    Expect(0, 70015, '\p{^Block= 	Mahajani}', "");
    Expect(0, 70015, '\P{Block= 	Mahajani}', "");
    Expect(1, 70015, '\P{^Block= 	Mahajani}', "");
    Expect(0, 70016, '\p{Block= 	Mahajani}', "");
    Expect(1, 70016, '\p{^Block= 	Mahajani}', "");
    Expect(1, 70016, '\P{Block= 	Mahajani}', "");
    Expect(0, 70016, '\P{^Block= 	Mahajani}', "");
    Error('\p{Blk=:= MAHAJANI}');
    Error('\P{Blk=:= MAHAJANI}');
    Expect(1, 70015, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk: mahajani}', "");
    Expect(0, 70015, '\p{^Blk: mahajani}', "");
    Expect(0, 70015, '\P{Blk: mahajani}', "");
    Expect(1, 70015, '\P{^Blk: mahajani}', "");
    Expect(0, 70016, '\p{Blk: mahajani}', "");
    Expect(1, 70016, '\p{^Blk: mahajani}', "");
    Expect(1, 70016, '\P{Blk: mahajani}', "");
    Expect(0, 70016, '\P{^Blk: mahajani}', "");
    Expect(1, 70015, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk= 	MAHAJANI}', "");
    Expect(0, 70015, '\p{^Blk= 	MAHAJANI}', "");
    Expect(0, 70015, '\P{Blk= 	MAHAJANI}', "");
    Expect(1, 70015, '\P{^Blk= 	MAHAJANI}', "");
    Expect(0, 70016, '\p{Blk= 	MAHAJANI}', "");
    Expect(1, 70016, '\p{^Blk= 	MAHAJANI}', "");
    Expect(1, 70016, '\P{Blk= 	MAHAJANI}', "");
    Expect(0, 70016, '\P{^Blk= 	MAHAJANI}', "");
    Error('\p{Is_Block= MAHAJANI/a/}');
    Error('\P{Is_Block= MAHAJANI/a/}');
    Expect(1, 70015, '\p{Is_Block=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=mahajani}', "");
    Expect(1, 70015, '\p{Is_Block=_MAHAJANI}', "");
    Expect(0, 70015, '\p{^Is_Block=_MAHAJANI}', "");
    Expect(0, 70015, '\P{Is_Block=_MAHAJANI}', "");
    Expect(1, 70015, '\P{^Is_Block=_MAHAJANI}', "");
    Expect(0, 70016, '\p{Is_Block=_MAHAJANI}', "");
    Expect(1, 70016, '\p{^Is_Block=_MAHAJANI}', "");
    Expect(1, 70016, '\P{Is_Block=_MAHAJANI}', "");
    Expect(0, 70016, '\P{^Is_Block=_MAHAJANI}', "");
    Error('\p{Is_Blk=_	MAHAJANI/a/}');
    Error('\P{Is_Blk=_	MAHAJANI/a/}');
    Expect(1, 70015, '\p{Is_Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=mahajani}', "");
    Expect(1, 70015, '\p{Is_Blk=	-MAHAJANI}', "");
    Expect(0, 70015, '\p{^Is_Blk=	-MAHAJANI}', "");
    Expect(0, 70015, '\P{Is_Blk=	-MAHAJANI}', "");
    Expect(1, 70015, '\P{^Is_Blk=	-MAHAJANI}', "");
    Expect(0, 70016, '\p{Is_Blk=	-MAHAJANI}', "");
    Expect(1, 70016, '\p{^Is_Blk=	-MAHAJANI}', "");
    Expect(1, 70016, '\P{Is_Blk=	-MAHAJANI}', "");
    Expect(0, 70016, '\P{^Is_Blk=	-MAHAJANI}', "");
    Error('\p{Block=__Mahjong_tiles:=}');
    Error('\P{Block=__Mahjong_tiles:=}');
    Expect(1, 127023, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(1, 127023, '\p{Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(1, 127023, '\p{Block=	-mahjong_Tiles}', "");
    Expect(0, 127023, '\p{^Block=	-mahjong_Tiles}', "");
    Expect(0, 127023, '\P{Block=	-mahjong_Tiles}', "");
    Expect(1, 127023, '\P{^Block=	-mahjong_Tiles}', "");
    Expect(0, 127024, '\p{Block=	-mahjong_Tiles}', "");
    Expect(1, 127024, '\p{^Block=	-mahjong_Tiles}', "");
    Expect(1, 127024, '\P{Block=	-mahjong_Tiles}', "");
    Expect(0, 127024, '\P{^Block=	-mahjong_Tiles}', "");
    Error('\p{Blk= /a/MAHJONG}');
    Error('\P{Blk= /a/MAHJONG}');
    Expect(1, 127023, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Blk=mahjong}', "");
    Expect(0, 127023, '\P{Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Blk=mahjong}', "");
    Expect(0, 127024, '\p{Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Blk=mahjong}', "");
    Expect(1, 127024, '\P{Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Blk=mahjong}', "");
    Expect(1, 127023, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=	Mahjong}', "");
    Expect(0, 127023, '\p{^Blk=	Mahjong}', "");
    Expect(0, 127023, '\P{Blk=	Mahjong}', "");
    Expect(1, 127023, '\P{^Blk=	Mahjong}', "");
    Expect(0, 127024, '\p{Blk=	Mahjong}', "");
    Expect(1, 127024, '\p{^Blk=	Mahjong}', "");
    Expect(1, 127024, '\P{Blk=	Mahjong}', "");
    Expect(0, 127024, '\P{^Blk=	Mahjong}', "");
    Error('\p{Is_Block=:=	 MAHJONG_Tiles}');
    Error('\P{Is_Block=:=	 MAHJONG_Tiles}');
    Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Is_Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Is_Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Is_Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Is_Block= _Mahjong_tiles}', "");
    Expect(0, 127023, '\p{^Is_Block= _Mahjong_tiles}', "");
    Expect(0, 127023, '\P{Is_Block= _Mahjong_tiles}', "");
    Expect(1, 127023, '\P{^Is_Block= _Mahjong_tiles}', "");
    Expect(0, 127024, '\p{Is_Block= _Mahjong_tiles}', "");
    Expect(1, 127024, '\p{^Is_Block= _Mahjong_tiles}', "");
    Expect(1, 127024, '\P{Is_Block= _Mahjong_tiles}', "");
    Expect(0, 127024, '\P{^Is_Block= _Mahjong_tiles}', "");
    Error('\p{Is_Blk=:=-_Mahjong}');
    Error('\P{Is_Blk=:=-_Mahjong}');
    Expect(1, 127023, '\p{Is_Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk=mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk=mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk=mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk=mahjong}', "");
    Expect(1, 127023, '\p{Is_Blk= Mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk= Mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk= Mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk= Mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk= Mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk= Mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk= Mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk= Mahjong}', "");
    Error('\p{Block=	:=MAKASAR}');
    Error('\P{Block=	:=MAKASAR}');
    Expect(1, 73471, '\p{Block=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=makasar}', "");
    Expect(0, 73471, '\p{^Block=makasar}', "");
    Expect(0, 73471, '\P{Block=makasar}', "");
    Expect(1, 73471, '\P{^Block=makasar}', "");
    Expect(0, 73472, '\p{Block=makasar}', "");
    Expect(1, 73472, '\p{^Block=makasar}', "");
    Expect(1, 73472, '\P{Block=makasar}', "");
    Expect(0, 73472, '\P{^Block=makasar}', "");
    Expect(1, 73471, '\p{Block=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=  Makasar}', "");
    Expect(0, 73471, '\p{^Block=  Makasar}', "");
    Expect(0, 73471, '\P{Block=  Makasar}', "");
    Expect(1, 73471, '\P{^Block=  Makasar}', "");
    Expect(0, 73472, '\p{Block=  Makasar}', "");
    Expect(1, 73472, '\p{^Block=  Makasar}', "");
    Expect(1, 73472, '\P{Block=  Makasar}', "");
    Expect(0, 73472, '\P{^Block=  Makasar}', "");
    Error('\p{Blk=_:=Makasar}');
    Error('\P{Blk=_:=Makasar}');
    Expect(1, 73471, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=makasar}', "");
    Expect(0, 73471, '\p{^Blk=makasar}', "");
    Expect(0, 73471, '\P{Blk=makasar}', "");
    Expect(1, 73471, '\P{^Blk=makasar}', "");
    Expect(0, 73472, '\p{Blk=makasar}', "");
    Expect(1, 73472, '\p{^Blk=makasar}', "");
    Expect(1, 73472, '\P{Blk=makasar}', "");
    Expect(0, 73472, '\P{^Blk=makasar}', "");
    Expect(1, 73471, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=_	Makasar}', "");
    Expect(0, 73471, '\p{^Blk=_	Makasar}', "");
    Expect(0, 73471, '\P{Blk=_	Makasar}', "");
    Expect(1, 73471, '\P{^Blk=_	Makasar}', "");
    Expect(0, 73472, '\p{Blk=_	Makasar}', "");
    Expect(1, 73472, '\p{^Blk=_	Makasar}', "");
    Expect(1, 73472, '\P{Blk=_	Makasar}', "");
    Expect(0, 73472, '\P{^Blk=_	Makasar}', "");
    Error('\p{Is_Block: _-Makasar/a/}');
    Error('\P{Is_Block: _-Makasar/a/}');
    Expect(1, 73471, '\p{Is_Block=makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=makasar}', "");
    Expect(0, 73471, '\P{Is_Block=makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=makasar}', "");
    Expect(0, 73472, '\p{Is_Block=makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=makasar}', "");
    Expect(1, 73472, '\P{Is_Block=makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=makasar}', "");
    Expect(1, 73471, '\p{Is_Block=_Makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=_Makasar}', "");
    Expect(0, 73471, '\P{Is_Block=_Makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=_Makasar}', "");
    Expect(0, 73472, '\p{Is_Block=_Makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=_Makasar}', "");
    Expect(1, 73472, '\P{Is_Block=_Makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=_Makasar}', "");
    Error('\p{Is_Blk=:=	MAKASAR}');
    Error('\P{Is_Blk=:=	MAKASAR}');
    Expect(1, 73471, '\p{Is_Blk=makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk=makasar}', "");
    Expect(0, 73471, '\P{Is_Blk=makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk=makasar}', "");
    Expect(0, 73472, '\p{Is_Blk=makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk=makasar}', "");
    Expect(1, 73472, '\P{Is_Blk=makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk=makasar}', "");
    Expect(1, 73471, '\p{Is_Blk:    -makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk:    -makasar}', "");
    Expect(0, 73471, '\P{Is_Blk:    -makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk:    -makasar}', "");
    Expect(0, 73472, '\p{Is_Blk:    -makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk:    -makasar}', "");
    Expect(1, 73472, '\P{Is_Blk:    -makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk:    -makasar}', "");
    Error('\p{Block=/a/Malayalam}');
    Error('\P{Block=/a/Malayalam}');
    Expect(1, 3455, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=malayalam}', "");
    Expect(0, 3455, '\p{^Block=malayalam}', "");
    Expect(0, 3455, '\P{Block=malayalam}', "");
    Expect(1, 3455, '\P{^Block=malayalam}', "");
    Expect(0, 3456, '\p{Block=malayalam}', "");
    Expect(1, 3456, '\p{^Block=malayalam}', "");
    Expect(1, 3456, '\P{Block=malayalam}', "");
    Expect(0, 3456, '\P{^Block=malayalam}', "");
    Expect(1, 3455, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=  Malayalam}', "");
    Expect(0, 3455, '\p{^Block=  Malayalam}', "");
    Expect(0, 3455, '\P{Block=  Malayalam}', "");
    Expect(1, 3455, '\P{^Block=  Malayalam}', "");
    Expect(0, 3456, '\p{Block=  Malayalam}', "");
    Expect(1, 3456, '\p{^Block=  Malayalam}', "");
    Expect(1, 3456, '\P{Block=  Malayalam}', "");
    Expect(0, 3456, '\P{^Block=  Malayalam}', "");
    Error('\p{Blk= malayalam/a/}');
    Error('\P{Blk= malayalam/a/}');
    Expect(1, 3455, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk:malayalam}', "");
    Expect(0, 3455, '\p{^Blk:malayalam}', "");
    Expect(0, 3455, '\P{Blk:malayalam}', "");
    Expect(1, 3455, '\P{^Blk:malayalam}', "");
    Expect(0, 3456, '\p{Blk:malayalam}', "");
    Expect(1, 3456, '\p{^Blk:malayalam}', "");
    Expect(1, 3456, '\P{Blk:malayalam}', "");
    Expect(0, 3456, '\P{^Blk:malayalam}', "");
    Expect(1, 3455, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=_-MALAYALAM}', "");
    Expect(0, 3455, '\p{^Blk=_-MALAYALAM}', "");
    Expect(0, 3455, '\P{Blk=_-MALAYALAM}', "");
    Expect(1, 3455, '\P{^Blk=_-MALAYALAM}', "");
    Expect(0, 3456, '\p{Blk=_-MALAYALAM}', "");
    Expect(1, 3456, '\p{^Blk=_-MALAYALAM}', "");
    Expect(1, 3456, '\P{Blk=_-MALAYALAM}', "");
    Expect(0, 3456, '\P{^Blk=_-MALAYALAM}', "");
    Error('\p{Is_Block:   _/a/Malayalam}');
    Error('\P{Is_Block:   _/a/Malayalam}');
    Expect(1, 3455, '\p{Is_Block=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=malayalam}', "");
    Expect(1, 3455, '\p{Is_Block=		malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=		malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=		malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=		malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=		malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=		malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=		malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=		malayalam}', "");
    Error('\p{Is_Blk=/a/	_Malayalam}');
    Error('\P{Is_Blk=/a/	_Malayalam}');
    Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=malayalam}', "");
    Expect(1, 3455, '\p{Is_Blk=- MALAYALAM}', "");
    Expect(0, 3455, '\p{^Is_Blk=- MALAYALAM}', "");
    Expect(0, 3455, '\P{Is_Blk=- MALAYALAM}', "");
    Expect(1, 3455, '\P{^Is_Blk=- MALAYALAM}', "");
    Expect(0, 3456, '\p{Is_Blk=- MALAYALAM}', "");
    Expect(1, 3456, '\p{^Is_Blk=- MALAYALAM}', "");
    Expect(1, 3456, '\P{Is_Blk=- MALAYALAM}', "");
    Expect(0, 3456, '\P{^Is_Blk=- MALAYALAM}', "");
    Error('\p{Block=-:=MANDAIC}');
    Error('\P{Block=-:=MANDAIC}');
    Expect(1, 2143, '\p{Block=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=mandaic}', "");
    Expect(0, 2143, '\p{^Block=mandaic}', "");
    Expect(0, 2143, '\P{Block=mandaic}', "");
    Expect(1, 2143, '\P{^Block=mandaic}', "");
    Expect(0, 2144, '\p{Block=mandaic}', "");
    Expect(1, 2144, '\p{^Block=mandaic}', "");
    Expect(1, 2144, '\P{Block=mandaic}', "");
    Expect(0, 2144, '\P{^Block=mandaic}', "");
    Expect(1, 2143, '\p{Block=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=_Mandaic}', "");
    Expect(0, 2143, '\p{^Block=_Mandaic}', "");
    Expect(0, 2143, '\P{Block=_Mandaic}', "");
    Expect(1, 2143, '\P{^Block=_Mandaic}', "");
    Expect(0, 2144, '\p{Block=_Mandaic}', "");
    Expect(1, 2144, '\p{^Block=_Mandaic}', "");
    Expect(1, 2144, '\P{Block=_Mandaic}', "");
    Expect(0, 2144, '\P{^Block=_Mandaic}', "");
    Error('\p{Blk= :=Mandaic}');
    Error('\P{Blk= :=Mandaic}');
    Expect(1, 2143, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Blk=mandaic}', "");
    Expect(0, 2143, '\P{Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Blk=mandaic}', "");
    Expect(0, 2144, '\p{Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Blk=mandaic}', "");
    Expect(1, 2144, '\P{Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Blk=mandaic}', "");
    Expect(1, 2143, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=Mandaic}', "");
    Expect(0, 2143, '\p{^Blk=Mandaic}', "");
    Expect(0, 2143, '\P{Blk=Mandaic}', "");
    Expect(1, 2143, '\P{^Blk=Mandaic}', "");
    Expect(0, 2144, '\p{Blk=Mandaic}', "");
    Expect(1, 2144, '\p{^Blk=Mandaic}', "");
    Expect(1, 2144, '\P{Blk=Mandaic}', "");
    Expect(0, 2144, '\P{^Blk=Mandaic}', "");
    Error('\p{Is_Block=/a/	_Mandaic}');
    Error('\P{Is_Block=/a/	_Mandaic}');
    Expect(1, 2143, '\p{Is_Block=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=mandaic}', "");
    Expect(1, 2143, '\p{Is_Block=  Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=  Mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=  Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=  Mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=  Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=  Mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=  Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=  Mandaic}', "");
    Error('\p{Is_Blk=_-MANDAIC:=}');
    Error('\P{Is_Blk=_-MANDAIC:=}');
    Expect(1, 2143, '\p{Is_Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=mandaic}', "");
    Expect(1, 2143, '\p{Is_Blk:_mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk:_mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk:_mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk:_mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk:_mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk:_mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk:_mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk:_mandaic}', "");
    Error('\p{Block=	 Manichaean:=}');
    Error('\P{Block=	 Manichaean:=}');
    Expect(1, 68351, '\p{Block=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=manichaean}', "");
    Expect(0, 68351, '\p{^Block=manichaean}', "");
    Expect(0, 68351, '\P{Block=manichaean}', "");
    Expect(1, 68351, '\P{^Block=manichaean}', "");
    Expect(0, 68352, '\p{Block=manichaean}', "");
    Expect(1, 68352, '\p{^Block=manichaean}', "");
    Expect(1, 68352, '\P{Block=manichaean}', "");
    Expect(0, 68352, '\P{^Block=manichaean}', "");
    Expect(1, 68351, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=  Manichaean}', "");
    Expect(0, 68351, '\p{^Block=  Manichaean}', "");
    Expect(0, 68351, '\P{Block=  Manichaean}', "");
    Expect(1, 68351, '\P{^Block=  Manichaean}', "");
    Expect(0, 68352, '\p{Block=  Manichaean}', "");
    Expect(1, 68352, '\p{^Block=  Manichaean}', "");
    Expect(1, 68352, '\P{Block=  Manichaean}', "");
    Expect(0, 68352, '\P{^Block=  Manichaean}', "");
    Error('\p{Blk:   _	Manichaean/a/}');
    Error('\P{Blk:   _	Manichaean/a/}');
    Expect(1, 68351, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Blk=manichaean}', "");
    Expect(0, 68351, '\P{Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Blk=manichaean}', "");
    Expect(0, 68352, '\p{Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Blk=manichaean}', "");
    Expect(1, 68352, '\P{Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Blk=manichaean}', "");
    Expect(1, 68351, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=	Manichaean}', "");
    Expect(0, 68351, '\p{^Blk=	Manichaean}', "");
    Expect(0, 68351, '\P{Blk=	Manichaean}', "");
    Expect(1, 68351, '\P{^Blk=	Manichaean}', "");
    Expect(0, 68352, '\p{Blk=	Manichaean}', "");
    Expect(1, 68352, '\p{^Blk=	Manichaean}', "");
    Expect(1, 68352, '\P{Blk=	Manichaean}', "");
    Expect(0, 68352, '\P{^Blk=	Manichaean}', "");
    Error('\p{Is_Block=_ manichaean:=}');
    Error('\P{Is_Block=_ manichaean:=}');
    Expect(1, 68351, '\p{Is_Block=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=manichaean}', "");
    Expect(1, 68351, '\p{Is_Block=-Manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=-Manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=-Manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=-Manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=-Manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=-Manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=-Manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=-Manichaean}', "");
    Error('\p{Is_Blk=	:=MANICHAEAN}');
    Error('\P{Is_Blk=	:=MANICHAEAN}');
    Expect(1, 68351, '\p{Is_Blk: manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk: manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk: manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk: manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk: manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk: manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk: manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk: manichaean}', "");
    Expect(1, 68351, '\p{Is_Blk=__Manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=__Manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=__Manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=__Manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=__Manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=__Manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=__Manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=__Manichaean}', "");
    Error('\p{Block=	-marchen:=}');
    Error('\P{Block=	-marchen:=}');
    Expect(1, 72895, '\p{Block=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Block=marchen}', "");
    Expect(0, 72895, '\p{^Block=marchen}', "");
    Expect(0, 72895, '\P{Block=marchen}', "");
    Expect(1, 72895, '\P{^Block=marchen}', "");
    Expect(0, 72896, '\p{Block=marchen}', "");
    Expect(1, 72896, '\p{^Block=marchen}', "");
    Expect(1, 72896, '\P{Block=marchen}', "");
    Expect(0, 72896, '\P{^Block=marchen}', "");
    Expect(1, 72895, '\p{Block=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Block=_-MARCHEN}', "");
    Expect(0, 72895, '\p{^Block=_-MARCHEN}', "");
    Expect(0, 72895, '\P{Block=_-MARCHEN}', "");
    Expect(1, 72895, '\P{^Block=_-MARCHEN}', "");
    Expect(0, 72896, '\p{Block=_-MARCHEN}', "");
    Expect(1, 72896, '\p{^Block=_-MARCHEN}', "");
    Expect(1, 72896, '\P{Block=_-MARCHEN}', "");
    Expect(0, 72896, '\P{^Block=_-MARCHEN}', "");
    Error('\p{Blk=	:=Marchen}');
    Error('\P{Blk=	:=Marchen}');
    Expect(1, 72895, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=marchen}', "");
    Expect(0, 72895, '\p{^Blk=marchen}', "");
    Expect(0, 72895, '\P{Blk=marchen}', "");
    Expect(1, 72895, '\P{^Blk=marchen}', "");
    Expect(0, 72896, '\p{Blk=marchen}', "");
    Expect(1, 72896, '\p{^Blk=marchen}', "");
    Expect(1, 72896, '\P{Blk=marchen}', "");
    Expect(0, 72896, '\P{^Blk=marchen}', "");
    Expect(1, 72895, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=	-Marchen}', "");
    Expect(0, 72895, '\p{^Blk=	-Marchen}', "");
    Expect(0, 72895, '\P{Blk=	-Marchen}', "");
    Expect(1, 72895, '\P{^Blk=	-Marchen}', "");
    Expect(0, 72896, '\p{Blk=	-Marchen}', "");
    Expect(1, 72896, '\p{^Blk=	-Marchen}', "");
    Expect(1, 72896, '\P{Blk=	-Marchen}', "");
    Expect(0, 72896, '\P{^Blk=	-Marchen}', "");
    Error('\p{Is_Block=/a/Marchen}');
    Error('\P{Is_Block=/a/Marchen}');
    Expect(1, 72895, '\p{Is_Block=marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=marchen}', "");
    Expect(0, 72895, '\P{Is_Block=marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=marchen}', "");
    Expect(0, 72896, '\p{Is_Block=marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=marchen}', "");
    Expect(1, 72896, '\P{Is_Block=marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=marchen}', "");
    Expect(1, 72895, '\p{Is_Block=-_MARCHEN}', "");
    Expect(0, 72895, '\p{^Is_Block=-_MARCHEN}', "");
    Expect(0, 72895, '\P{Is_Block=-_MARCHEN}', "");
    Expect(1, 72895, '\P{^Is_Block=-_MARCHEN}', "");
    Expect(0, 72896, '\p{Is_Block=-_MARCHEN}', "");
    Expect(1, 72896, '\p{^Is_Block=-_MARCHEN}', "");
    Expect(1, 72896, '\P{Is_Block=-_MARCHEN}', "");
    Expect(0, 72896, '\P{^Is_Block=-_MARCHEN}', "");
    Error('\p{Is_Blk=_:=marchen}');
    Error('\P{Is_Blk=_:=marchen}');
    Expect(1, 72895, '\p{Is_Blk=marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=marchen}', "");
    Expect(1, 72895, '\p{Is_Blk=_marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=_marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=_marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=_marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=_marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=_marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=_marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=_marchen}', "");
    Error('\p{Block=:=-MASARAM_Gondi}');
    Error('\P{Block=:=-MASARAM_Gondi}');
    Expect(1, 73055, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Block:	masaramgondi}', "");
    Expect(0, 73055, '\p{^Block:	masaramgondi}', "");
    Expect(0, 73055, '\P{Block:	masaramgondi}', "");
    Expect(1, 73055, '\P{^Block:	masaramgondi}', "");
    Expect(0, 73056, '\p{Block:	masaramgondi}', "");
    Expect(1, 73056, '\p{^Block:	masaramgondi}', "");
    Expect(1, 73056, '\P{Block:	masaramgondi}', "");
    Expect(0, 73056, '\P{^Block:	masaramgondi}', "");
    Expect(1, 73055, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Block=Masaram_gondi}', "");
    Expect(0, 73055, '\p{^Block=Masaram_gondi}', "");
    Expect(0, 73055, '\P{Block=Masaram_gondi}', "");
    Expect(1, 73055, '\P{^Block=Masaram_gondi}', "");
    Expect(0, 73056, '\p{Block=Masaram_gondi}', "");
    Expect(1, 73056, '\p{^Block=Masaram_gondi}', "");
    Expect(1, 73056, '\P{Block=Masaram_gondi}', "");
    Expect(0, 73056, '\P{^Block=Masaram_gondi}', "");
    Error('\p{Blk= Masaram_Gondi:=}');
    Error('\P{Blk= Masaram_Gondi:=}');
    Expect(1, 73055, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Blk:	masaramgondi}', "");
    Expect(0, 73055, '\p{^Blk:	masaramgondi}', "");
    Expect(0, 73055, '\P{Blk:	masaramgondi}', "");
    Expect(1, 73055, '\P{^Blk:	masaramgondi}', "");
    Expect(0, 73056, '\p{Blk:	masaramgondi}', "");
    Expect(1, 73056, '\p{^Blk:	masaramgondi}', "");
    Expect(1, 73056, '\P{Blk:	masaramgondi}', "");
    Expect(0, 73056, '\P{^Blk:	masaramgondi}', "");
    Expect(1, 73055, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Blk=-	masaram_gondi}', "");
    Expect(0, 73055, '\p{^Blk=-	masaram_gondi}', "");
    Expect(0, 73055, '\P{Blk=-	masaram_gondi}', "");
    Expect(1, 73055, '\P{^Blk=-	masaram_gondi}', "");
    Expect(0, 73056, '\p{Blk=-	masaram_gondi}', "");
    Expect(1, 73056, '\p{^Blk=-	masaram_gondi}', "");
    Expect(1, 73056, '\P{Blk=-	masaram_gondi}', "");
    Expect(0, 73056, '\P{^Blk=-	masaram_gondi}', "");
    Error('\p{Is_Block=--MASARAM_gondi/a/}');
    Error('\P{Is_Block=--MASARAM_gondi/a/}');
    Expect(1, 73055, '\p{Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Block= Masaram_gondi}', "");
    Expect(0, 73055, '\p{^Is_Block= Masaram_gondi}', "");
    Expect(0, 73055, '\P{Is_Block= Masaram_gondi}', "");
    Expect(1, 73055, '\P{^Is_Block= Masaram_gondi}', "");
    Expect(0, 73056, '\p{Is_Block= Masaram_gondi}', "");
    Expect(1, 73056, '\p{^Is_Block= Masaram_gondi}', "");
    Expect(1, 73056, '\P{Is_Block= Masaram_gondi}', "");
    Expect(0, 73056, '\P{^Is_Block= Masaram_gondi}', "");
    Error('\p{Is_Blk=	/a/masaram_gondi}');
    Error('\P{Is_Blk=	/a/masaram_gondi}');
    Expect(1, 73055, '\p{Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Blk=Masaram_gondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=Masaram_gondi}', "");
    Expect(0, 73055, '\P{Is_Blk=Masaram_gondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=Masaram_gondi}', "");
    Expect(0, 73056, '\p{Is_Blk=Masaram_gondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=Masaram_gondi}', "");
    Expect(1, 73056, '\P{Is_Blk=Masaram_gondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=Masaram_gondi}', "");
    Error('\p{Block=:=_ Mathematical_Alphanumeric_Symbols}');
    Error('\P{Block=:=_ Mathematical_Alphanumeric_Symbols}');
    Expect(1, 120831, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(1, 120831, '\p{Block:   mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Block:   mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Block:   mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Block:   mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Block:   mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Block:   mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Block:   mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Block:   mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(1, 120831, '\p{Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120831, '\p{^Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120831, '\P{Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120831, '\P{^Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120832, '\p{Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120832, '\p{^Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(1, 120832, '\P{Block= _Mathematical_Alphanumeric_Symbols}', "");
    Expect(0, 120832, '\P{^Block= _Mathematical_Alphanumeric_Symbols}', "");
    Error('\p{Blk=:=	math_alphanum}');
    Error('\P{Blk=:=	math_alphanum}');
    Expect(1, 120831, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk=__MATH_Alphanum}', "");
    Expect(0, 120831, '\p{^Blk=__MATH_Alphanum}', "");
    Expect(0, 120831, '\P{Blk=__MATH_Alphanum}', "");
    Expect(1, 120831, '\P{^Blk=__MATH_Alphanum}', "");
    Expect(0, 120832, '\p{Blk=__MATH_Alphanum}', "");
    Expect(1, 120832, '\p{^Blk=__MATH_Alphanum}', "");
    Expect(1, 120832, '\P{Blk=__MATH_Alphanum}', "");
    Expect(0, 120832, '\P{^Blk=__MATH_Alphanum}', "");
    Error('\p{Is_Block=_ MATHEMATICAL_ALPHANUMERIC_SYMBOLS/a/}');
    Error('\P{Is_Block=_ MATHEMATICAL_ALPHANUMERIC_SYMBOLS/a/}');
    Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\p{^Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(0, 120831, '\P{Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(1, 120831, '\P{^Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\p{Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\p{^Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(1, 120832, '\P{Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Expect(0, 120832, '\P{^Is_Block: -MATHEMATICAL_alphanumeric_Symbols}', "");
    Error('\p{Is_Blk=:=_	Math_ALPHANUM}');
    Error('\P{Is_Blk=:=_	Math_ALPHANUM}');
    Expect(1, 120831, '\p{Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Is_Blk= -math_Alphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk= -math_Alphanum}', "");
    Expect(0, 120831, '\P{Is_Blk= -math_Alphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk= -math_Alphanum}', "");
    Expect(0, 120832, '\p{Is_Blk= -math_Alphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk= -math_Alphanum}', "");
    Expect(1, 120832, '\P{Is_Blk= -math_Alphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk= -math_Alphanum}', "");
    Error('\p{Block=_-Mathematical_Operators/a/}');
    Error('\P{Block=_-Mathematical_Operators/a/}');
    Expect(1, 8959, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(1, 8959, '\p{Block:   _-Mathematical_Operators}', "");
    Expect(0, 8959, '\p{^Block:   _-Mathematical_Operators}', "");
    Expect(0, 8959, '\P{Block:   _-Mathematical_Operators}', "");
    Expect(1, 8959, '\P{^Block:   _-Mathematical_Operators}', "");
    Expect(0, 8960, '\p{Block:   _-Mathematical_Operators}', "");
    Expect(1, 8960, '\p{^Block:   _-Mathematical_Operators}', "");
    Expect(1, 8960, '\P{Block:   _-Mathematical_Operators}', "");
    Expect(0, 8960, '\P{^Block:   _-Mathematical_Operators}', "");
    Error('\p{Blk=:=	_Math_OPERATORS}');
    Error('\P{Blk=:=	_Math_OPERATORS}');
    Expect(1, 8959, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(1, 8959, '\p{Blk=mathoperators}', "");
    Expect(0, 8959, '\p{^Blk=mathoperators}', "");
    Expect(0, 8959, '\P{Blk=mathoperators}', "");
    Expect(1, 8959, '\P{^Blk=mathoperators}', "");
    Expect(0, 8960, '\p{Blk=mathoperators}', "");
    Expect(1, 8960, '\p{^Blk=mathoperators}', "");
    Expect(1, 8960, '\P{Blk=mathoperators}', "");
    Expect(0, 8960, '\P{^Blk=mathoperators}', "");
    Expect(1, 8959, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(1, 8959, '\p{Blk=	_MATH_Operators}', "");
    Expect(0, 8959, '\p{^Blk=	_MATH_Operators}', "");
    Expect(0, 8959, '\P{Blk=	_MATH_Operators}', "");
    Expect(1, 8959, '\P{^Blk=	_MATH_Operators}', "");
    Expect(0, 8960, '\p{Blk=	_MATH_Operators}', "");
    Expect(1, 8960, '\p{^Blk=	_MATH_Operators}', "");
    Expect(1, 8960, '\P{Blk=	_MATH_Operators}', "");
    Expect(0, 8960, '\P{^Blk=	_MATH_Operators}', "");
    Error('\p{Is_Block= :=mathematical_Operators}');
    Error('\P{Is_Block= :=mathematical_Operators}');
    Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(0, 8959, '\p{^Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(0, 8959, '\P{Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(1, 8959, '\P{^Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(0, 8960, '\p{Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(1, 8960, '\p{^Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(1, 8960, '\P{Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Expect(0, 8960, '\P{^Is_Block=- MATHEMATICAL_OPERATORS}', "");
    Error('\p{Is_Blk=/a/ _math_Operators}');
    Error('\P{Is_Blk=/a/ _math_Operators}');
    Expect(1, 8959, '\p{Is_Blk: mathoperators}', "");
    Expect(0, 8959, '\p{^Is_Blk: mathoperators}', "");
    Expect(0, 8959, '\P{Is_Blk: mathoperators}', "");
    Expect(1, 8959, '\P{^Is_Blk: mathoperators}', "");
    Expect(0, 8960, '\p{Is_Blk: mathoperators}', "");
    Expect(1, 8960, '\p{^Is_Blk: mathoperators}', "");
    Expect(1, 8960, '\P{Is_Blk: mathoperators}', "");
    Expect(0, 8960, '\P{^Is_Blk: mathoperators}', "");
    Expect(1, 8959, '\p{Is_Blk= -math_Operators}', "");
    Expect(0, 8959, '\p{^Is_Blk= -math_Operators}', "");
    Expect(0, 8959, '\P{Is_Blk= -math_Operators}', "");
    Expect(1, 8959, '\P{^Is_Blk= -math_Operators}', "");
    Expect(0, 8960, '\p{Is_Blk= -math_Operators}', "");
    Expect(1, 8960, '\p{^Is_Blk= -math_Operators}', "");
    Expect(1, 8960, '\P{Is_Blk= -math_Operators}', "");
    Expect(0, 8960, '\P{^Is_Blk= -math_Operators}', "");
    Error('\p{Block= _MAYAN_Numerals:=}');
    Error('\P{Block= _MAYAN_Numerals:=}');
    Expect(1, 119551, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Block=mayannumerals}', "");
    Expect(0, 119551, '\p{^Block=mayannumerals}', "");
    Expect(0, 119551, '\P{Block=mayannumerals}', "");
    Expect(1, 119551, '\P{^Block=mayannumerals}', "");
    Expect(0, 119552, '\p{Block=mayannumerals}', "");
    Expect(1, 119552, '\p{^Block=mayannumerals}', "");
    Expect(1, 119552, '\P{Block=mayannumerals}', "");
    Expect(0, 119552, '\P{^Block=mayannumerals}', "");
    Expect(1, 119551, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Block=		MAYAN_numerals}', "");
    Expect(0, 119551, '\p{^Block=		MAYAN_numerals}', "");
    Expect(0, 119551, '\P{Block=		MAYAN_numerals}', "");
    Expect(1, 119551, '\P{^Block=		MAYAN_numerals}', "");
    Expect(0, 119552, '\p{Block=		MAYAN_numerals}', "");
    Expect(1, 119552, '\p{^Block=		MAYAN_numerals}', "");
    Expect(1, 119552, '\P{Block=		MAYAN_numerals}', "");
    Expect(0, 119552, '\P{^Block=		MAYAN_numerals}', "");
    Error('\p{Blk= :=MAYAN_numerals}');
    Error('\P{Blk= :=MAYAN_numerals}');
    Expect(1, 119551, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Blk=mayannumerals}', "");
    Expect(0, 119551, '\p{^Blk=mayannumerals}', "");
    Expect(0, 119551, '\P{Blk=mayannumerals}', "");
    Expect(1, 119551, '\P{^Blk=mayannumerals}', "");
    Expect(0, 119552, '\p{Blk=mayannumerals}', "");
    Expect(1, 119552, '\p{^Blk=mayannumerals}', "");
    Expect(1, 119552, '\P{Blk=mayannumerals}', "");
    Expect(0, 119552, '\P{^Blk=mayannumerals}', "");
    Expect(1, 119551, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Blk= Mayan_NUMERALS}', "");
    Expect(0, 119551, '\p{^Blk= Mayan_NUMERALS}', "");
    Expect(0, 119551, '\P{Blk= Mayan_NUMERALS}', "");
    Expect(1, 119551, '\P{^Blk= Mayan_NUMERALS}', "");
    Expect(0, 119552, '\p{Blk= Mayan_NUMERALS}', "");
    Expect(1, 119552, '\p{^Blk= Mayan_NUMERALS}', "");
    Expect(1, 119552, '\P{Blk= Mayan_NUMERALS}', "");
    Expect(0, 119552, '\P{^Blk= Mayan_NUMERALS}', "");
    Error('\p{Is_Block=:=_Mayan_numerals}');
    Error('\P{Is_Block=:=_Mayan_numerals}');
    Expect(1, 119551, '\p{Is_Block:	mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Block:	mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Block:	mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Block:	mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Block:	mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Block:	mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Block:	mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Block:	mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Block=_Mayan_Numerals}', "");
    Expect(0, 119551, '\p{^Is_Block=_Mayan_Numerals}', "");
    Expect(0, 119551, '\P{Is_Block=_Mayan_Numerals}', "");
    Expect(1, 119551, '\P{^Is_Block=_Mayan_Numerals}', "");
    Expect(0, 119552, '\p{Is_Block=_Mayan_Numerals}', "");
    Expect(1, 119552, '\p{^Is_Block=_Mayan_Numerals}', "");
    Expect(1, 119552, '\P{Is_Block=_Mayan_Numerals}', "");
    Expect(0, 119552, '\P{^Is_Block=_Mayan_Numerals}', "");
    Error('\p{Is_Blk=__Mayan_Numerals:=}');
    Error('\P{Is_Blk=__Mayan_Numerals:=}');
    Expect(1, 119551, '\p{Is_Blk:   mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Blk:   mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Blk:   mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Blk:   mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Blk:   mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Blk:   mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Blk:   mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Blk:   mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Blk=	-MAYAN_Numerals}', "");
    Expect(0, 119551, '\p{^Is_Blk=	-MAYAN_Numerals}', "");
    Expect(0, 119551, '\P{Is_Blk=	-MAYAN_Numerals}', "");
    Expect(1, 119551, '\P{^Is_Blk=	-MAYAN_Numerals}', "");
    Expect(0, 119552, '\p{Is_Blk=	-MAYAN_Numerals}', "");
    Expect(1, 119552, '\p{^Is_Blk=	-MAYAN_Numerals}', "");
    Expect(1, 119552, '\P{Is_Blk=	-MAYAN_Numerals}', "");
    Expect(0, 119552, '\P{^Is_Blk=	-MAYAN_Numerals}', "");
    Error('\p{Block= :=Medefaidrin}');
    Error('\P{Block= :=Medefaidrin}');
    Expect(1, 93855, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block=--Medefaidrin}', "");
    Expect(0, 93855, '\p{^Block=--Medefaidrin}', "");
    Expect(0, 93855, '\P{Block=--Medefaidrin}', "");
    Expect(1, 93855, '\P{^Block=--Medefaidrin}', "");
    Expect(0, 93856, '\p{Block=--Medefaidrin}', "");
    Expect(1, 93856, '\p{^Block=--Medefaidrin}', "");
    Expect(1, 93856, '\P{Block=--Medefaidrin}', "");
    Expect(0, 93856, '\P{^Block=--Medefaidrin}', "");
    Error('\p{Blk=:=_	Medefaidrin}');
    Error('\P{Blk=:=_	Medefaidrin}');
    Expect(1, 93855, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk=medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk=medefaidrin}', "");
    Expect(0, 93855, '\P{Blk=medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk=medefaidrin}', "");
    Expect(0, 93856, '\p{Blk=medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk=medefaidrin}', "");
    Expect(1, 93856, '\P{Blk=medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk=medefaidrin}', "");
    Expect(1, 93855, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk=_Medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk=_Medefaidrin}', "");
    Expect(0, 93855, '\P{Blk=_Medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk=_Medefaidrin}', "");
    Expect(0, 93856, '\p{Blk=_Medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk=_Medefaidrin}', "");
    Expect(1, 93856, '\P{Blk=_Medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk=_Medefaidrin}', "");
    Error('\p{Is_Block=:=Medefaidrin}');
    Error('\P{Is_Block=:=Medefaidrin}');
    Expect(1, 93855, '\p{Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Is_Block=	Medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=	Medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=	Medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=	Medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=	Medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=	Medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=	Medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=	Medefaidrin}', "");
    Error('\p{Is_Blk:	/a/medefaidrin}');
    Error('\P{Is_Blk:	/a/medefaidrin}');
    Expect(1, 93855, '\p{Is_Blk=medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Blk=medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Blk=medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Blk=medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Blk=medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Blk=medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Blk=medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Blk=medefaidrin}', "");
    Expect(1, 93855, '\p{Is_Blk=-Medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Blk=-Medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Blk=-Medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Blk=-Medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Blk=-Medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Blk=-Medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Blk=-Medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Blk=-Medefaidrin}', "");
    Error('\p{Block=		Meetei_Mayek/a/}');
    Error('\P{Block=		Meetei_Mayek/a/}');
    Expect(1, 44031, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Block=_-Meetei_MAYEK}', "");
    Expect(0, 44031, '\p{^Block=_-Meetei_MAYEK}', "");
    Expect(0, 44031, '\P{Block=_-Meetei_MAYEK}', "");
    Expect(1, 44031, '\P{^Block=_-Meetei_MAYEK}', "");
    Expect(0, 44032, '\p{Block=_-Meetei_MAYEK}', "");
    Expect(1, 44032, '\p{^Block=_-Meetei_MAYEK}', "");
    Expect(1, 44032, '\P{Block=_-Meetei_MAYEK}', "");
    Expect(0, 44032, '\P{^Block=_-Meetei_MAYEK}', "");
    Error('\p{Blk=:= Meetei_Mayek}');
    Error('\P{Blk=:= Meetei_Mayek}');
    Expect(1, 44031, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=- meetei_MAYEK}', "");
    Expect(0, 44031, '\p{^Blk=- meetei_MAYEK}', "");
    Expect(0, 44031, '\P{Blk=- meetei_MAYEK}', "");
    Expect(1, 44031, '\P{^Blk=- meetei_MAYEK}', "");
    Expect(0, 44032, '\p{Blk=- meetei_MAYEK}', "");
    Expect(1, 44032, '\p{^Blk=- meetei_MAYEK}', "");
    Expect(1, 44032, '\P{Blk=- meetei_MAYEK}', "");
    Expect(0, 44032, '\P{^Blk=- meetei_MAYEK}', "");
    Error('\p{Is_Block=_	Meetei_Mayek:=}');
    Error('\P{Is_Block=_	Meetei_Mayek:=}');
    Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Block=- Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Is_Block=- Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Is_Block=- Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Is_Block=- Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Is_Block=- Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Is_Block=- Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Is_Block=- Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Is_Block=- Meetei_Mayek}', "");
    Error('\p{Is_Blk=_:=Meetei_Mayek}');
    Error('\P{Is_Blk=_:=Meetei_Mayek}');
    Expect(1, 44031, '\p{Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(0, 44031, '\p{^Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(0, 44031, '\P{Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(1, 44031, '\P{^Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(0, 44032, '\p{Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(1, 44032, '\p{^Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(1, 44032, '\P{Is_Blk= 	MEETEI_MAYEK}', "");
    Expect(0, 44032, '\P{^Is_Blk= 	MEETEI_MAYEK}', "");
    Error('\p{Block=		MEETEI_MAYEK_extensions/a/}');
    Error('\P{Block=		MEETEI_MAYEK_extensions/a/}');
    Expect(1, 43775, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(1, 43775, '\p{Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(1, 43775, '\p{Block= -meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\p{^Block= -meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\P{Block= -meetei_Mayek_Extensions}', "");
    Expect(1, 43775, '\P{^Block= -meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\p{Block= -meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\p{^Block= -meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\P{Block= -meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\P{^Block= -meetei_Mayek_Extensions}', "");
    Error('\p{Blk:   :=	Meetei_Mayek_Ext}');
    Error('\P{Blk:   :=	Meetei_Mayek_Ext}');
    Expect(1, 43775, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(1, 43775, '\p{Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(1, 43775, '\p{Blk=_MEETEI_Mayek_Ext}', "");
    Expect(0, 43775, '\p{^Blk=_MEETEI_Mayek_Ext}', "");
    Expect(0, 43775, '\P{Blk=_MEETEI_Mayek_Ext}', "");
    Expect(1, 43775, '\P{^Blk=_MEETEI_Mayek_Ext}', "");
    Expect(0, 43776, '\p{Blk=_MEETEI_Mayek_Ext}', "");
    Expect(1, 43776, '\p{^Blk=_MEETEI_Mayek_Ext}', "");
    Expect(1, 43776, '\P{Blk=_MEETEI_Mayek_Ext}', "");
    Expect(0, 43776, '\P{^Blk=_MEETEI_Mayek_Ext}', "");
    Error('\p{Is_Block=-	Meetei_Mayek_Extensions:=}');
    Error('\P{Is_Block=-	Meetei_Mayek_Extensions:=}');
    Expect(1, 43775, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\p{^Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(0, 43775, '\P{Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(1, 43775, '\P{^Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\p{Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\p{^Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(1, 43776, '\P{Is_Block= Meetei_Mayek_Extensions}', "");
    Expect(0, 43776, '\P{^Is_Block= Meetei_Mayek_Extensions}', "");
    Error('\p{Is_Blk:   	Meetei_Mayek_ext:=}');
    Error('\P{Is_Blk:   	Meetei_Mayek_ext:=}');
    Expect(1, 43775, '\p{Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Is_Blk=__meetei_Mayek_ext}', "");
    Expect(0, 43775, '\p{^Is_Blk=__meetei_Mayek_ext}', "");
    Expect(0, 43775, '\P{Is_Blk=__meetei_Mayek_ext}', "");
    Expect(1, 43775, '\P{^Is_Blk=__meetei_Mayek_ext}', "");
    Expect(0, 43776, '\p{Is_Blk=__meetei_Mayek_ext}', "");
    Expect(1, 43776, '\p{^Is_Blk=__meetei_Mayek_ext}', "");
    Expect(1, 43776, '\P{Is_Blk=__meetei_Mayek_ext}', "");
    Expect(0, 43776, '\P{^Is_Blk=__meetei_Mayek_ext}', "");
    Error('\p{Block=	:=MENDE_kikakui}');
    Error('\P{Block=	:=MENDE_kikakui}');
    Expect(1, 125151, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Block=	_MENDE_Kikakui}', "");
    Expect(0, 125151, '\p{^Block=	_MENDE_Kikakui}', "");
    Expect(0, 125151, '\P{Block=	_MENDE_Kikakui}', "");
    Expect(1, 125151, '\P{^Block=	_MENDE_Kikakui}', "");
    Expect(0, 125152, '\p{Block=	_MENDE_Kikakui}', "");
    Expect(1, 125152, '\p{^Block=	_MENDE_Kikakui}', "");
    Expect(1, 125152, '\P{Block=	_MENDE_Kikakui}', "");
    Expect(0, 125152, '\P{^Block=	_MENDE_Kikakui}', "");
    Error('\p{Blk=/a/mende_Kikakui}');
    Error('\P{Blk=/a/mende_Kikakui}');
    Expect(1, 125151, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=mende_kikakui}', "");
    Expect(0, 125151, '\p{^Blk=mende_kikakui}', "");
    Expect(0, 125151, '\P{Blk=mende_kikakui}', "");
    Expect(1, 125151, '\P{^Blk=mende_kikakui}', "");
    Expect(0, 125152, '\p{Blk=mende_kikakui}', "");
    Expect(1, 125152, '\p{^Blk=mende_kikakui}', "");
    Expect(1, 125152, '\P{Blk=mende_kikakui}', "");
    Expect(0, 125152, '\P{^Blk=mende_kikakui}', "");
    Error('\p{Is_Block=	:=Mende_Kikakui}');
    Error('\P{Is_Block=	:=Mende_Kikakui}');
    Expect(1, 125151, '\p{Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Block= 	mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Is_Block= 	mende_Kikakui}', "");
    Expect(0, 125151, '\P{Is_Block= 	mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Is_Block= 	mende_Kikakui}', "");
    Expect(0, 125152, '\p{Is_Block= 	mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Is_Block= 	mende_Kikakui}', "");
    Expect(1, 125152, '\P{Is_Block= 	mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Is_Block= 	mende_Kikakui}', "");
    Error('\p{Is_Blk= MENDE_kikakui:=}');
    Error('\P{Is_Blk= MENDE_kikakui:=}');
    Expect(1, 125151, '\p{Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Blk=-_mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=-_mende_Kikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=-_mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=-_mende_Kikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=-_mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=-_mende_Kikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=-_mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=-_mende_Kikakui}', "");
    Error('\p{Block=-:=Meroitic_cursive}');
    Error('\P{Block=-:=Meroitic_cursive}');
    Expect(1, 68095, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(1, 68095, '\p{Block=_ Meroitic_Cursive}', "");
    Expect(0, 68095, '\p{^Block=_ Meroitic_Cursive}', "");
    Expect(0, 68095, '\P{Block=_ Meroitic_Cursive}', "");
    Expect(1, 68095, '\P{^Block=_ Meroitic_Cursive}', "");
    Expect(0, 68096, '\p{Block=_ Meroitic_Cursive}', "");
    Expect(1, 68096, '\p{^Block=_ Meroitic_Cursive}', "");
    Expect(1, 68096, '\P{Block=_ Meroitic_Cursive}', "");
    Expect(0, 68096, '\P{^Block=_ Meroitic_Cursive}', "");
    Error('\p{Blk=:=Meroitic_cursive}');
    Error('\P{Blk=:=Meroitic_cursive}');
    Expect(1, 68095, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Blk=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Blk=meroiticcursive}', "");
    Expect(0, 68095, '\P{Blk=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Blk=meroiticcursive}', "");
    Expect(0, 68096, '\p{Blk=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Blk=meroiticcursive}', "");
    Expect(1, 68096, '\P{Blk=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Blk=meroiticcursive}', "");
    Expect(1, 68095, '\p{Blk=:\Ameroiticcursive\z:}', "");;
    Expect(0, 68096, '\p{Blk=:\Ameroiticcursive\z:}', "");;
    Expect(1, 68095, '\p{Blk= MEROITIC_Cursive}', "");
    Expect(0, 68095, '\p{^Blk= MEROITIC_Cursive}', "");
    Expect(0, 68095, '\P{Blk= MEROITIC_Cursive}', "");
    Expect(1, 68095, '\P{^Blk= MEROITIC_Cursive}', "");
    Expect(0, 68096, '\p{Blk= MEROITIC_Cursive}', "");
    Expect(1, 68096, '\p{^Blk= MEROITIC_Cursive}', "");
    Expect(1, 68096, '\P{Blk= MEROITIC_Cursive}', "");
    Expect(0, 68096, '\P{^Blk= MEROITIC_Cursive}', "");
    Error('\p{Is_Block=/a/ 	meroitic_cursive}');
    Error('\P{Is_Block=/a/ 	meroitic_cursive}');
    Expect(1, 68095, '\p{Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Block=	 meroitic_CURSIVE}', "");
    Expect(0, 68095, '\p{^Is_Block=	 meroitic_CURSIVE}', "");
    Expect(0, 68095, '\P{Is_Block=	 meroitic_CURSIVE}', "");
    Expect(1, 68095, '\P{^Is_Block=	 meroitic_CURSIVE}', "");
    Expect(0, 68096, '\p{Is_Block=	 meroitic_CURSIVE}', "");
    Expect(1, 68096, '\p{^Is_Block=	 meroitic_CURSIVE}', "");
    Expect(1, 68096, '\P{Is_Block=	 meroitic_CURSIVE}', "");
    Expect(0, 68096, '\P{^Is_Block=	 meroitic_CURSIVE}', "");
    Error('\p{Is_Blk=/a/Meroitic_Cursive}');
    Error('\P{Is_Blk=/a/Meroitic_Cursive}');
    Expect(1, 68095, '\p{Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68095, '\P{Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\p{Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68096, '\P{Is_Blk=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Is_Blk=meroiticcursive}', "");
    Expect(1, 68095, '\p{Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(0, 68095, '\p{^Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(0, 68095, '\P{Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(1, 68095, '\P{^Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(0, 68096, '\p{Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(1, 68096, '\p{^Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(1, 68096, '\P{Is_Blk= -Meroitic_CURSIVE}', "");
    Expect(0, 68096, '\P{^Is_Blk= -Meroitic_CURSIVE}', "");
    Error('\p{Block=__meroitic_Hieroglyphs/a/}');
    Error('\P{Block=__meroitic_Hieroglyphs/a/}');
    Expect(1, 67999, '\p{Block=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Block=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Block:   meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Block:   meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Block:   meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Block:   meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Block:   meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Block:   meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Block:   meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Block:   meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Block=:\Ameroitichieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Block=:\Ameroitichieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Block=	Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Block=	Meroitic_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Block=	Meroitic_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Block=	Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Block=	Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Block=	Meroitic_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Block=	Meroitic_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Block=	Meroitic_Hieroglyphs}', "");
    Error('\p{Blk=meroitic_HIEROGLYPHS:=}');
    Error('\P{Blk=meroitic_HIEROGLYPHS:=}');
    Expect(1, 67999, '\p{Blk=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Blk=:\AMeroitic_Hieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Blk=:\Ameroitichieroglyphs\z:}', "");;
    Expect(0, 68000, '\p{Blk=:\Ameroitichieroglyphs\z:}', "");;
    Expect(1, 67999, '\p{Blk=MEROITIC_hieroglyphs}', "");
    Expect(0, 67999, '\p{^Blk=MEROITIC_hieroglyphs}', "");
    Expect(0, 67999, '\P{Blk=MEROITIC_hieroglyphs}', "");
    Expect(1, 67999, '\P{^Blk=MEROITIC_hieroglyphs}', "");
    Expect(0, 68000, '\p{Blk=MEROITIC_hieroglyphs}', "");
    Expect(1, 68000, '\p{^Blk=MEROITIC_hieroglyphs}', "");
    Expect(1, 68000, '\P{Blk=MEROITIC_hieroglyphs}', "");
    Expect(0, 68000, '\P{^Blk=MEROITIC_hieroglyphs}', "");
    Error('\p{Is_Block=/a/_ MEROITIC_Hieroglyphs}');
    Error('\P{Is_Block=/a/_ MEROITIC_Hieroglyphs}');
    Expect(1, 67999, '\p{Is_Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Block=MEROITIC_Hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Block=MEROITIC_Hieroglyphs}', "");
    Error('\p{Is_Blk=:= _Meroitic_Hieroglyphs}');
    Error('\P{Is_Blk=:= _Meroitic_Hieroglyphs}');
    Expect(1, 67999, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk=meroitichieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk=meroitichieroglyphs}', "");
    Expect(1, 67999, '\p{Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(0, 67999, '\p{^Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(0, 67999, '\P{Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(1, 67999, '\P{^Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(0, 68000, '\p{Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(1, 68000, '\p{^Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(1, 68000, '\P{Is_Blk=-	meroitic_hieroglyphs}', "");
    Expect(0, 68000, '\P{^Is_Blk=-	meroitic_hieroglyphs}', "");
    Error('\p{Block=_/a/MIAO}');
    Error('\P{Block=_/a/MIAO}');
    Expect(1, 94111, '\p{Block=:\AMiao\z:}', "");;
    Expect(0, 94112, '\p{Block=:\AMiao\z:}', "");;
    Expect(1, 94111, '\p{Block=miao}', "");
    Expect(0, 94111, '\p{^Block=miao}', "");
    Expect(0, 94111, '\P{Block=miao}', "");
    Expect(1, 94111, '\P{^Block=miao}', "");
    Expect(0, 94112, '\p{Block=miao}', "");
    Expect(1, 94112, '\p{^Block=miao}', "");
    Expect(1, 94112, '\P{Block=miao}', "");
    Expect(0, 94112, '\P{^Block=miao}', "");
    Expect(1, 94111, '\p{Block=:\Amiao\z:}', "");;
    Expect(0, 94112, '\p{Block=:\Amiao\z:}', "");;
    Expect(1, 94111, '\p{Block:Miao}', "");
    Expect(0, 94111, '\p{^Block:Miao}', "");
    Expect(0, 94111, '\P{Block:Miao}', "");
    Expect(1, 94111, '\P{^Block:Miao}', "");
    Expect(0, 94112, '\p{Block:Miao}', "");
    Expect(1, 94112, '\p{^Block:Miao}', "");
    Expect(1, 94112, '\P{Block:Miao}', "");
    Expect(0, 94112, '\P{^Block:Miao}', "");
    Error('\p{Blk=-_miao/a/}');
    Error('\P{Blk=-_miao/a/}');
    Expect(1, 94111, '\p{Blk=:\AMiao\z:}', "");;
    Expect(0, 94112, '\p{Blk=:\AMiao\z:}', "");;
    Expect(1, 94111, '\p{Blk=miao}', "");
    Expect(0, 94111, '\p{^Blk=miao}', "");
    Expect(0, 94111, '\P{Blk=miao}', "");
    Expect(1, 94111, '\P{^Blk=miao}', "");
    Expect(0, 94112, '\p{Blk=miao}', "");
    Expect(1, 94112, '\p{^Blk=miao}', "");
    Expect(1, 94112, '\P{Blk=miao}', "");
    Expect(0, 94112, '\P{^Blk=miao}', "");
    Expect(1, 94111, '\p{Blk=:\Amiao\z:}', "");;
    Expect(0, 94112, '\p{Blk=:\Amiao\z:}', "");;
    Expect(1, 94111, '\p{Blk=_ Miao}', "");
    Expect(0, 94111, '\p{^Blk=_ Miao}', "");
    Expect(0, 94111, '\P{Blk=_ Miao}', "");
    Expect(1, 94111, '\P{^Blk=_ Miao}', "");
    Expect(0, 94112, '\p{Blk=_ Miao}', "");
    Expect(1, 94112, '\p{^Blk=_ Miao}', "");
    Expect(1, 94112, '\P{Blk=_ Miao}', "");
    Expect(0, 94112, '\P{^Blk=_ Miao}', "");
    Error('\p{Is_Block=/a/Miao}');
    Error('\P{Is_Block=/a/Miao}');
    Expect(1, 94111, '\p{Is_Block=miao}', "");
    Expect(0, 94111, '\p{^Is_Block=miao}', "");
    Expect(0, 94111, '\P{Is_Block=miao}', "");
    Expect(1, 94111, '\P{^Is_Block=miao}', "");
    Expect(0, 94112, '\p{Is_Block=miao}', "");
    Expect(1, 94112, '\p{^Is_Block=miao}', "");
    Expect(1, 94112, '\P{Is_Block=miao}', "");
    Expect(0, 94112, '\P{^Is_Block=miao}', "");
    Expect(1, 94111, '\p{Is_Block=-MIAO}', "");
    Expect(0, 94111, '\p{^Is_Block=-MIAO}', "");
    Expect(0, 94111, '\P{Is_Block=-MIAO}', "");
    Expect(1, 94111, '\P{^Is_Block=-MIAO}', "");
    Expect(0, 94112, '\p{Is_Block=-MIAO}', "");
    Expect(1, 94112, '\p{^Is_Block=-MIAO}', "");
    Expect(1, 94112, '\P{Is_Block=-MIAO}', "");
    Expect(0, 94112, '\P{^Is_Block=-MIAO}', "");
    Error('\p{Is_Blk=:= Miao}');
    Error('\P{Is_Blk=:= Miao}');
    Expect(1, 94111, '\p{Is_Blk=miao}', "");
    Expect(0, 94111, '\p{^Is_Blk=miao}', "");
    Expect(0, 94111, '\P{Is_Blk=miao}', "");
    Expect(1, 94111, '\P{^Is_Blk=miao}', "");
    Expect(0, 94112, '\p{Is_Blk=miao}', "");
    Expect(1, 94112, '\p{^Is_Blk=miao}', "");
    Expect(1, 94112, '\P{Is_Blk=miao}', "");
    Expect(0, 94112, '\P{^Is_Blk=miao}', "");
    Expect(1, 94111, '\p{Is_Blk= 	Miao}', "");
    Expect(0, 94111, '\p{^Is_Blk= 	Miao}', "");
    Expect(0, 94111, '\P{Is_Blk= 	Miao}', "");
    Expect(1, 94111, '\P{^Is_Blk= 	Miao}', "");
    Expect(0, 94112, '\p{Is_Blk= 	Miao}', "");
    Expect(1, 94112, '\p{^Is_Blk= 	Miao}', "");
    Expect(1, 94112, '\P{Is_Blk= 	Miao}', "");
    Expect(0, 94112, '\P{^Is_Blk= 	Miao}', "");
    Error('\p{Block:   :=Miscellaneous_SYMBOLS_And_Arrows}');
    Error('\P{Block:   :=Miscellaneous_SYMBOLS_And_Arrows}');
    Expect(1, 11263, '\p{Block=:\AMiscellaneous_Symbols_And_Arrows\z:}', "");;
    Expect(0, 11264, '\p{Block=:\AMiscellaneous_Symbols_And_Arrows\z:}', "");;
    Expect(1, 11263, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Block=:\Amiscellaneoussymbolsandarrows\z:}', "");;
    Expect(0, 11264, '\p{Block=:\Amiscellaneoussymbolsandarrows\z:}', "");;
    Expect(1, 11263, '\p{Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(0, 11263, '\p{^Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(0, 11263, '\P{Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(1, 11263, '\P{^Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(0, 11264, '\p{Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(1, 11264, '\p{^Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(1, 11264, '\P{Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Expect(0, 11264, '\P{^Block=_-MISCELLANEOUS_Symbols_And_Arrows}', "");
    Error('\p{Blk=-misc_arrows/a/}');
    Error('\P{Blk=-misc_arrows/a/}');
    Expect(1, 11263, '\p{Blk=:\AMisc_Arrows\z:}', "");;
    Expect(0, 11264, '\p{Blk=:\AMisc_Arrows\z:}', "");;
    Expect(1, 11263, '\p{Blk=miscarrows}', "");
    Expect(0, 11263, '\p{^Blk=miscarrows}', "");
    Expect(0, 11263, '\P{Blk=miscarrows}', "");
    Expect(1, 11263, '\P{^Blk=miscarrows}', "");
    Expect(0, 11264, '\p{Blk=miscarrows}', "");
    Expect(1, 11264, '\p{^Blk=miscarrows}', "");
    Expect(1, 11264, '\P{Blk=miscarrows}', "");
    Expect(0, 11264, '\P{^Blk=miscarrows}', "");
    Expect(1, 11263, '\p{Blk=:\Amiscarrows\z:}', "");;
    Expect(0, 11264, '\p{Blk=:\Amiscarrows\z:}', "");;
    Expect(1, 11263, '\p{Blk=_	MISC_Arrows}', "");
    Expect(0, 11263, '\p{^Blk=_	MISC_Arrows}', "");
    Expect(0, 11263, '\P{Blk=_	MISC_Arrows}', "");
    Expect(1, 11263, '\P{^Blk=_	MISC_Arrows}', "");
    Expect(0, 11264, '\p{Blk=_	MISC_Arrows}', "");
    Expect(1, 11264, '\p{^Blk=_	MISC_Arrows}', "");
    Expect(1, 11264, '\P{Blk=_	MISC_Arrows}', "");
    Expect(0, 11264, '\P{^Blk=_	MISC_Arrows}', "");
    Error('\p{Is_Block=--Miscellaneous_Symbols_And_arrows:=}');
    Error('\P{Is_Block=--Miscellaneous_Symbols_And_arrows:=}');
    Expect(1, 11263, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11263, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11264, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(0, 11264, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
    Expect(1, 11263, '\p{Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(0, 11263, '\p{^Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(0, 11263, '\P{Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(1, 11263, '\P{^Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(0, 11264, '\p{Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(1, 11264, '\p{^Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(1, 11264, '\P{Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Expect(0, 11264, '\P{^Is_Block=_miscellaneous_Symbols_AND_ARROWS}', "");
    Error('\p{Is_Blk=/a/MISC_arrows}');
    Error('\P{Is_Blk=/a/MISC_arrows}');
    Expect(1, 11263, '\p{Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\p{^Is_Blk=miscarrows}', "");
    Expect(0, 11263, '\P{Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\P{^Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\p{Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\p{^Is_Blk=miscarrows}', "");
    Expect(1, 11264, '\P{Is_Blk=miscarrows}', "");
    Expect(0, 11264, '\P{^Is_Blk=miscarrows}', "");
    Expect(1, 11263, '\p{Is_Blk=	 Misc_Arrows}', "");
    Expect(0, 11263, '\p{^Is_Blk=	 Misc_Arrows}', "");
    Expect(0, 11263, '\P{Is_Blk=	 Misc_Arrows}', "");
    Expect(1, 11263, '\P{^Is_Blk=	 Misc_Arrows}', "");
    Expect(0, 11264, '\p{Is_Blk=	 Misc_Arrows}', "");
    Expect(1, 11264, '\p{^Is_Blk=	 Misc_Arrows}', "");
    Expect(1, 11264, '\P{Is_Blk=	 Misc_Arrows}', "");
    Expect(0, 11264, '\P{^Is_Blk=	 Misc_Arrows}', "");
    Error('\p{Block=/a/_Miscellaneous_MATHEMATICAL_Symbols_A}');
    Error('\P{Block=/a/_Miscellaneous_MATHEMATICAL_Symbols_A}');
    Expect(1, 10223, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_A\z:}', "");;
    Expect(0, 10224, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_A\z:}', "");;
    Expect(1, 10223, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Block=:\Amiscellaneousmathematicalsymbolsa\z:}', "");;
    Expect(0, 10224, '\p{Block=:\Amiscellaneousmathematicalsymbolsa\z:}', "");;
    Expect(1, 10223, '\p{Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(0, 10223, '\p{^Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(0, 10223, '\P{Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(1, 10223, '\P{^Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(0, 10224, '\p{Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(1, 10224, '\p{^Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(1, 10224, '\P{Block=	miscellaneous_mathematical_Symbols_a}', "");
    Expect(0, 10224, '\P{^Block=	miscellaneous_mathematical_Symbols_a}', "");
    Error('\p{Blk=:=-Misc_math_Symbols_A}');
    Error('\P{Blk=:=-Misc_math_Symbols_A}');
    Expect(1, 10223, '\p{Blk=:\AMisc_Math_Symbols_A\z:}', "");;
    Expect(0, 10224, '\p{Blk=:\AMisc_Math_Symbols_A\z:}', "");;
    Expect(1, 10223, '\p{Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Blk=:\Amiscmathsymbolsa\z:}', "");;
    Expect(0, 10224, '\p{Blk=:\Amiscmathsymbolsa\z:}', "");;
    Expect(1, 10223, '\p{Blk=--MISC_MATH_symbols_A}', "");
    Expect(0, 10223, '\p{^Blk=--MISC_MATH_symbols_A}', "");
    Expect(0, 10223, '\P{Blk=--MISC_MATH_symbols_A}', "");
    Expect(1, 10223, '\P{^Blk=--MISC_MATH_symbols_A}', "");
    Expect(0, 10224, '\p{Blk=--MISC_MATH_symbols_A}', "");
    Expect(1, 10224, '\p{^Blk=--MISC_MATH_symbols_A}', "");
    Expect(1, 10224, '\P{Blk=--MISC_MATH_symbols_A}', "");
    Expect(0, 10224, '\P{^Blk=--MISC_MATH_symbols_A}', "");
    Error('\p{Is_Block=/a/  miscellaneous_MATHEMATICAL_Symbols_a}');
    Error('\P{Is_Block=/a/  miscellaneous_MATHEMATICAL_Symbols_a}');
    Expect(1, 10223, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10223, '\p{^Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10223, '\P{Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10223, '\P{^Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10224, '\p{Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10224, '\p{^Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(1, 10224, '\P{Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Expect(0, 10224, '\P{^Is_Block=-miscellaneous_Mathematical_Symbols_a}', "");
    Error('\p{Is_Blk=-/a/Misc_Math_Symbols_A}');
    Error('\P{Is_Blk=-/a/Misc_Math_Symbols_A}');
    Expect(1, 10223, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10223, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\p{Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\p{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10224, '\P{Is_Blk=miscmathsymbolsa}', "");
    Expect(0, 10224, '\P{^Is_Blk=miscmathsymbolsa}', "");
    Expect(1, 10223, '\p{Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10223, '\p{^Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10223, '\P{Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10223, '\P{^Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10224, '\p{Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10224, '\p{^Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(1, 10224, '\P{Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Expect(0, 10224, '\P{^Is_Blk=	Misc_Math_SYMBOLS_A}', "");
    Error('\p{Block=/a/ _miscellaneous_Mathematical_symbols_B}');
    Error('\P{Block=/a/ _miscellaneous_Mathematical_symbols_B}');
    Expect(1, 10751, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_B\z:}', "");;
    Expect(0, 10752, '\p{Block=:\AMiscellaneous_Mathematical_Symbols_B\z:}', "");;
    Expect(1, 10751, '\p{Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Block:   miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Block=:\Amiscellaneousmathematicalsymbolsb\z:}', "");;
    Expect(0, 10752, '\p{Block=:\Amiscellaneousmathematicalsymbolsb\z:}', "");;
    Expect(1, 10751, '\p{Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(0, 10751, '\p{^Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(0, 10751, '\P{Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(1, 10751, '\P{^Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(0, 10752, '\p{Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(1, 10752, '\p{^Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(1, 10752, '\P{Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Expect(0, 10752, '\P{^Block:   -_Miscellaneous_mathematical_symbols_B}', "");
    Error('\p{Blk=_:=MISC_Math_Symbols_B}');
    Error('\P{Blk=_:=MISC_Math_Symbols_B}');
    Expect(1, 10751, '\p{Blk=:\AMisc_Math_Symbols_B\z:}', "");;
    Expect(0, 10752, '\p{Blk=:\AMisc_Math_Symbols_B\z:}', "");;
    Expect(1, 10751, '\p{Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Blk=:\Amiscmathsymbolsb\z:}', "");;
    Expect(0, 10752, '\p{Blk=:\Amiscmathsymbolsb\z:}', "");;
    Expect(1, 10751, '\p{Blk=-Misc_MATH_Symbols_b}', "");
    Expect(0, 10751, '\p{^Blk=-Misc_MATH_Symbols_b}', "");
    Expect(0, 10751, '\P{Blk=-Misc_MATH_Symbols_b}', "");
    Expect(1, 10751, '\P{^Blk=-Misc_MATH_Symbols_b}', "");
    Expect(0, 10752, '\p{Blk=-Misc_MATH_Symbols_b}', "");
    Expect(1, 10752, '\p{^Blk=-Misc_MATH_Symbols_b}', "");
    Expect(1, 10752, '\P{Blk=-Misc_MATH_Symbols_b}', "");
    Expect(0, 10752, '\P{^Blk=-Misc_MATH_Symbols_b}', "");
    Error('\p{Is_Block=/a/Miscellaneous_Mathematical_symbols_B}');
    Error('\P{Is_Block=/a/Miscellaneous_Mathematical_symbols_B}');
    Expect(1, 10751, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10751, '\p{^Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10751, '\P{Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10751, '\P{^Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10752, '\p{Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10752, '\p{^Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(1, 10752, '\P{Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Expect(0, 10752, '\P{^Is_Block= miscellaneous_Mathematical_SYMBOLS_B}', "");
    Error('\p{Is_Blk=--Misc_Math_SYMBOLS_B:=}');
    Error('\P{Is_Blk=--Misc_Math_SYMBOLS_B:=}');
    Expect(1, 10751, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10751, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\p{Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\p{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10752, '\P{Is_Blk=miscmathsymbolsb}', "");
    Expect(0, 10752, '\P{^Is_Blk=miscmathsymbolsb}', "");
    Expect(1, 10751, '\p{Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(0, 10751, '\p{^Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(0, 10751, '\P{Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(1, 10751, '\P{^Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(0, 10752, '\p{Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(1, 10752, '\p{^Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(1, 10752, '\P{Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Expect(0, 10752, '\P{^Is_Blk=_MISC_Math_SYMBOLS_B}', "");
    Error('\p{Block=:=-_miscellaneous_Symbols_AND_Pictographs}');
    Error('\P{Block=:=-_miscellaneous_Symbols_AND_Pictographs}');
    Expect(1, 128511, '\p{Block=:\AMiscellaneous_Symbols_And_Pictographs\z:}', "");;
    Expect(0, 128512, '\p{Block=:\AMiscellaneous_Symbols_And_Pictographs\z:}', "");;
    Expect(1, 128511, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128511, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\p{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\p{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128512, '\P{Block=miscellaneoussymbolsandpictographs}', "");
    Expect(0, 128512, '\P{^Block=miscellaneoussymbolsandpictographs}', "");
    Expect(1, 128511, '\p{Block=:\Amiscellaneoussymbolsandpictographs\z:}', "");;
    Expect(0, 128512, '\p{Block=:\Amiscellaneoussymbolsandpictographs\z:}', "");;
  