/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.ErrorPrecondition;
import liquibase.precondition.FailedPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.util.StringUtil;

public class ValidatingVisitor
implements ChangeSetVisitor {
    private List<String> invalidMD5Sums = new ArrayList<String>();
    private List<FailedPrecondition> failedPreconditions = new ArrayList<FailedPrecondition>();
    private List<ErrorPrecondition> errorPreconditions = new ArrayList<ErrorPrecondition>();
    private Set<ChangeSet> duplicateChangeSets = new HashSet<ChangeSet>();
    private List<SetupException> setupExceptions = new ArrayList<SetupException>();
    private List<Throwable> changeValidationExceptions = new ArrayList<Throwable>();
    private ValidationErrors validationErrors = new ValidationErrors();
    private Warnings warnings = new Warnings();
    private Set<String> seenChangeSets = new HashSet<String>();
    private Map<String, RanChangeSet> ranIndex = new HashMap<String, RanChangeSet>();
    private Database database;

    public ValidatingVisitor(List<RanChangeSet> ranChangeSets) {
        for (RanChangeSet changeSet : ranChangeSets) {
            this.ranIndex.put(changeSet.toString(), changeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Database database, DatabaseChangeLog changeLog) {
        this.database = database;
        PreconditionContainer preconditions = changeLog.getPreconditions();
        try {
            if (preconditions == null) {
                return;
            }
            preconditions.check(database, changeLog, null, null);
        }
        catch (PreconditionFailedException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Precondition Failed: " + e2.getMessage(), e2);
            this.failedPreconditions.addAll(e2.getFailedPreconditions());
        }
        catch (PreconditionErrorException e3) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Precondition Error: " + e3.getMessage(), e3);
            this.errorPreconditions.addAll(e3.getErrorPreconditions());
        }
        finally {
            try {
                if (database.getConnection() != null) {
                    database.rollback();
                }
            }
            catch (DatabaseException e4) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Error rolling back after precondition check", e4);
            }
        }
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    private RanChangeSet findChangeSet(ChangeSet changeSet) {
        RanChangeSet result = this.ranIndex.get(changeSet.toString(false));
        if (result == null) {
            for (RanChangeSet ranChangeSet : this.ranIndex.values()) {
                if (!ranChangeSet.isSameAs(changeSet)) continue;
                result = ranChangeSet;
                break;
            }
        }
        return result;
    }

    @Override
    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        String changeSetString;
        RanChangeSet ranChangeSet = this.findChangeSet(changeSet);
        boolean ran = ranChangeSet != null;
        changeSet.setStoredCheckSum(ran ? ranChangeSet.getLastCheckSum() : null);
        boolean shouldValidate = !ran || changeSet.shouldRunOnChange() || changeSet.shouldAlwaysRun();
        for (Change change : changeSet.getChanges()) {
            try {
                change.finishInitialization();
            }
            catch (SetupException se) {
                this.setupExceptions.add(se);
            }
            if (!shouldValidate) continue;
            this.warnings.addAll(change.warn(database));
            try {
                ValidationErrors foundErrors = change.validate(database);
                if (foundErrors == null) continue;
                if (foundErrors.hasErrors() && changeSet.getOnValidationFail().equals((Object)ChangeSet.ValidationFailOption.MARK_RAN)) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Skipping change set " + changeSet + " due to validation error(s): " + StringUtil.join(foundErrors.getErrorMessages(), ", "));
                    changeSet.setValidationFailed(true);
                    continue;
                }
                if (!foundErrors.getWarningMessages().isEmpty()) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Change set " + changeSet + ": " + StringUtil.join(foundErrors.getWarningMessages(), ", "));
                }
                this.validationErrors.addAll(foundErrors, changeSet);
            }
            catch (Exception e2) {
                this.changeValidationExceptions.add(e2);
            }
        }
        if (ranChangeSet != null && !changeSet.isCheckSumValid(ranChangeSet.getLastCheckSum()) && !changeSet.shouldRunOnChange()) {
            this.invalidMD5Sums.add(changeSet.toString(false) + " was: " + ranChangeSet.getLastCheckSum().toString() + " but is now: " + changeSet.generateCheckSum().toString());
        }
        if (this.seenChangeSets.contains(changeSetString = changeSet.toString(false))) {
            this.duplicateChangeSets.add(changeSet);
            return;
        }
        this.seenChangeSets.add(changeSetString);
    }

    public List<String> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public List<FailedPrecondition> getFailedPreconditions() {
        return this.failedPreconditions;
    }

    public List<ErrorPrecondition> getErrorPreconditions() {
        return this.errorPreconditions;
    }

    public Set<ChangeSet> getDuplicateChangeSets() {
        return this.duplicateChangeSets;
    }

    public List<SetupException> getSetupExceptions() {
        return this.setupExceptions;
    }

    public List<Throwable> getChangeValidationExceptions() {
        return this.changeValidationExceptions;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public boolean validationPassed() {
        return this.invalidMD5Sums.isEmpty() && this.failedPreconditions.isEmpty() && this.errorPreconditions.isEmpty() && this.duplicateChangeSets.isEmpty() && this.changeValidationExceptions.isEmpty() && this.setupExceptions.isEmpty() && !this.validationErrors.hasErrors();
    }

    public Database getDatabase() {
        return this.database;
    }
}

