/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.DataManager;
import org.traccar.database.SimpleObjectManager;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Permission;

public abstract class ExtendedObjectManager<T extends BaseModel>
extends SimpleObjectManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedObjectManager.class);
    private final Map<Long, Set<Long>> deviceItems = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> deviceItemsWithGroups = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> groupItems = new ConcurrentHashMap<Long, Set<Long>>();

    protected ExtendedObjectManager(DataManager dataManager, Class<T> baseClass) {
        super(dataManager, baseClass);
        this.refreshExtendedPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Long> getGroupItems(long groupId) {
        try {
            this.readLock();
            Set<Long> result = this.groupItems.get(groupId);
            if (result != null) {
                HashSet<Long> hashSet = new HashSet<Long>(result);
                return hashSet;
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Long> getDeviceItems(long deviceId) {
        try {
            this.readLock();
            Set<Long> result = this.deviceItems.get(deviceId);
            if (result != null) {
                HashSet<Long> hashSet = new HashSet<Long>(result);
                return hashSet;
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getAllDeviceItems(long deviceId) {
        try {
            this.readLock();
            Set<Long> result = this.deviceItemsWithGroups.get(deviceId);
            if (result != null) {
                HashSet<Long> hashSet = new HashSet<Long>(result);
                return hashSet;
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void removeItem(long itemId) throws SQLException {
        super.removeItem(itemId);
        this.refreshExtendedPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshExtendedPermissions() {
        if (this.getDataManager() != null) {
            try {
                Collection<Permission> databaseGroupPermissions = this.getDataManager().getPermissions(Group.class, this.getBaseClass());
                Collection<Permission> databaseDevicePermissions = this.getDataManager().getPermissions(Device.class, this.getBaseClass());
                this.writeLock();
                this.groupItems.clear();
                this.deviceItems.clear();
                this.deviceItemsWithGroups.clear();
                for (Permission groupPermission : databaseGroupPermissions) {
                    this.groupItems.computeIfAbsent(groupPermission.getOwnerId(), key -> new HashSet()).add(groupPermission.getPropertyId());
                }
                for (Permission devicePermission : databaseDevicePermissions) {
                    this.deviceItems.computeIfAbsent(devicePermission.getOwnerId(), key -> new HashSet()).add(devicePermission.getPropertyId());
                    this.deviceItemsWithGroups.computeIfAbsent(devicePermission.getOwnerId(), key -> new HashSet()).add(devicePermission.getPropertyId());
                }
                for (Device device : Context.getDeviceManager().getAllDevices()) {
                    long groupId = device.getGroupId();
                    while (groupId > 0L) {
                        this.deviceItemsWithGroups.computeIfAbsent(device.getId(), key -> new HashSet()).addAll(this.groupItems.getOrDefault(groupId, new HashSet()));
                        Group group = (Group)Context.getGroupsManager().getById(groupId);
                        groupId = group != null ? group.getGroupId() : 0L;
                    }
                }
            }
            catch (ClassNotFoundException | SQLException error) {
                LOGGER.warn("Refresh permissions error", (Throwable)error);
            }
            finally {
                this.writeUnlock();
            }
        }
    }
}

