/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.CompareDMFormatter;
import ca.sqlpower.architect.swingui.enterprise.RevisionsTable;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffInfo;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import org.apache.log4j.Logger;

public class CompareRevisionsPanel {
    private static final Logger logger = Logger.getLogger(CompareRevisionsPanel.class);
    private final ArchitectClientSideSession session;
    private final RevisionsTable revisionsTableLeft;
    private final RevisionsTable revisionsTableRight;
    private final JTextPane comparePane;
    private final JPanel panel;
    private final Action compareAction = new AbstractAction("Compare..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            DefaultStyledDocument d = new DefaultStyledDocument();
            try {
                d.insertString(0, "...", new SimpleAttributeSet());
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
            CompareRevisionsPanel.this.comparePane.setStyledDocument(d);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CompareRevisionsPanel.this.doCompare();
                }
            }).start();
        }
    };

    public CompareRevisionsPanel(ArchitectClientSideSession session, Action closeAction, long fromRevision, long toRevision) {
        this.session = session;
        this.revisionsTableLeft = new RevisionsTable(this.session, fromRevision, toRevision);
        this.revisionsTableRight = new RevisionsTable(this.session, fromRevision, toRevision);
        final JCheckBox autoCompare = new JCheckBox("Auto-compare", true);
        final ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CompareRevisionsPanel.this.refreshPanel();
                if (autoCompare.isSelected() && CompareRevisionsPanel.this.revisionsTableLeft.getSelectedRow() > -1 && CompareRevisionsPanel.this.revisionsTableRight.getSelectedRow() > -1) {
                    CompareRevisionsPanel.this.compareAction.actionPerformed(null);
                }
            }
        };
        autoCompare.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                listSelectionListener.valueChanged(null);
            }
        });
        this.revisionsTableLeft.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.revisionsTableRight.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.comparePane = new JTextPane();
        this.comparePane.setEditable(false);
        this.comparePane.setMargin(new Insets(6, 10, 4, 6));
        JScrollPane sp = new JScrollPane(this.comparePane);
        sp.setPreferredSize(this.revisionsTableLeft.getScrollPane().getPreferredSize());
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder revisionListsBuilder = new DefaultFormBuilder(new FormLayout("default:grow, 5dlu, default:grow", "pref, 2dlu, default:grow"));
        revisionListsBuilder.add((Component)new JLabel("From revision..."), cc.xy(1, 1));
        revisionListsBuilder.add((Component)new JLabel("To revision..."), cc.xy(3, 1));
        revisionListsBuilder.add((Component)this.revisionsTableLeft.getScrollPane(), cc.xy(1, 3));
        revisionListsBuilder.add((Component)this.revisionsTableRight.getScrollPane(), cc.xy(3, 3));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.compareAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        buttonBarBuilder.append((Component)autoCompare);
        DefaultFormBuilder bottomBuilder = new DefaultFormBuilder(new FormLayout("default:grow, right:default", "default:grow"));
        bottomBuilder.add((Component)sp, cc.xy(1, 1));
        bottomBuilder.add((Component)buttonBarBuilder.getPanel(), cc.xy(2, 1));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("default:grow", "default:grow, 5dlu, default:grow"));
        builder.add((Component)revisionListsBuilder.getPanel(), cc.xy(1, 1));
        builder.add((Component)bottomBuilder.getPanel(), cc.xy(1, 3));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
        this.panel.setPreferredSize(new Dimension(900, 650));
        this.refreshPanel();
    }

    private void refreshPanel() {
        this.compareAction.setEnabled(this.revisionsTableLeft.getSelectedRow() != -1 && this.revisionsTableRight.getSelectedRow() != -1);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void doCompare() {
        int oldRevisionNo = this.revisionsTableLeft.getSelectedRevisionNumber();
        int newRevisionNo = this.revisionsTableRight.getSelectedRevisionNumber();
        DefaultStyledDocument resultDoc = new DefaultStyledDocument();
        try {
            if (oldRevisionNo >= 0 && newRevisionNo >= 0) {
                List<DiffChunk<DiffInfo>> diff = this.session.getComparisonDiffChunks(oldRevisionNo, newRevisionNo);
                if (diff.size() == 0) {
                    resultDoc.insertString(0, "Revisions are identical", null);
                } else {
                    resultDoc = CompareDMFormatter.generateEnglishDescription(CompareDMFormatter.DIFF_STYLES, diff);
                }
            } else {
                JOptionPane.showMessageDialog(this.panel, "A revision must be selected from each table.");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error making comparison", t);
        }
        finally {
            this.refreshPanel();
        }
        this.comparePane.setStyledDocument(resultDoc);
    }
}

