/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import com.google.common.base.Function;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.VisualEdgeRenderer;
import ghidra.graph.viewer.shape.ArticulatedEdgeTransformer;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;

public class ArticulatedEdgeRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualEdgeRenderer<V, E> {
    @Override
    public Shape getEdgeShape(RenderContext<V, E> rc, Graph<V, E> graph, E e, float x1, float y1, float x2, float y2, boolean isLoop, Shape vertexShape) {
        if (isLoop) {
            return GraphViewerUtils.createEgdeLoopInGraphSpace(vertexShape, x1, y1);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        int offset = 0;
        Function edgeShapeTransformer = rc.getEdgeShapeTransformer();
        if (edgeShapeTransformer instanceof ArticulatedEdgeTransformer) {
            offset = ((ArticulatedEdgeTransformer)edgeShapeTransformer).getOverlapOffset(e);
        }
        List<Point2D> articulations = e.getArticulationPoints();
        offset = this.updateOffsetForLeftOrRightHandSizeEdge(rc, offset, x1, articulations);
        for (Point2D point : articulations) {
            Point2D.Float offsetPoint = new Point2D.Float((float)point.getX() + (float)offset, (float)point.getY() + (float)offset);
            point = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)offsetPoint);
            path.lineTo((float)point.getX(), (float)point.getY());
            path.moveTo((float)point.getX(), (float)point.getY());
        }
        path.lineTo(x2, y2);
        path.moveTo(x2, y2);
        path.closePath();
        return path;
    }

    private int updateOffsetForLeftOrRightHandSizeEdge(RenderContext<V, E> rc, int offset, float x, List<Point2D> articulations) {
        int size = articulations.size();
        if (size == 0) {
            return offset;
        }
        Point2D start = articulations.get(0);
        start = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, start);
        double delta = (double)x - start.getX();
        if (delta == 0.0) {
            return 0;
        }
        boolean isLeft = delta > 0.0;
        return isLeft ? -offset : offset;
    }
}

