/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class GTreeNodeTransferable
implements Transferable {
    private final List<GTreeNode> selectedData;
    private final GTreeTransferHandler transferHandler;

    public GTreeNodeTransferable(GTreeTransferHandler handler, List<GTreeNode> selectedData) {
        this.transferHandler = Objects.requireNonNull(handler);
        this.selectedData = Objects.requireNonNull(selectedData);
    }

    public List<GTreeNode> getAllData() {
        return this.selectedData;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.transferHandler.getTransferData(this.selectedData, flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.transferHandler.getSupportedDataFlavors(this.selectedData);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor f : flavors = this.transferHandler.getSupportedDataFlavors(this.selectedData)) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

