/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.DividerLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.FieldNameFieldLocation;
import ghidra.program.util.FunctionCallFixupFieldLocation;
import ghidra.program.util.FunctionCallingConventionFieldLocation;
import ghidra.program.util.FunctionEndParametersFieldLocation;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionParameterNameFieldLocation;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.FunctionSignatureSourceFieldLocation;
import ghidra.program.util.FunctionStartParametersFieldLocation;
import ghidra.program.util.IndentFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RefRepeatCommentFieldLocation;
import ghidra.program.util.RegisterFieldLocation;
import ghidra.program.util.RegisterTransitionFieldLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.program.util.SpaceFieldLocation;
import ghidra.program.util.SpacerFieldLocation;
import ghidra.program.util.SubDataFieldLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.program.util.VariableXRefFieldLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.program.util.XRefHeaderFieldLocation;
import java.util.HashMap;
import java.util.Map;

public class ProgramLocationComparator {
    private static final Class<?>[] PROGRAM_LOCATION_CLASSES = new Class[]{DividerLocation.class, ProgramLocation.class, PlateFieldLocation.class, FunctionLocation.class, FunctionRepeatableCommentFieldLocation.class, FunctionSignatureFieldLocation.class, FunctionSignatureSourceFieldLocation.class, FunctionCallFixupFieldLocation.class, FunctionReturnTypeFieldLocation.class, FunctionCallingConventionFieldLocation.class, FunctionNameFieldLocation.class, FunctionStartParametersFieldLocation.class, FunctionParameterFieldLocation.class, FunctionParameterNameFieldLocation.class, FunctionEndParametersFieldLocation.class, VariableLocation.class, VariableTypeFieldLocation.class, VariableNameFieldLocation.class, VariableLocFieldLocation.class, VariableXRefFieldLocation.class, VariableCommentFieldLocation.class, CommentFieldLocation.class, CodeUnitLocation.class, RegisterTransitionFieldLocation.class, LabelFieldLocation.class, XRefHeaderFieldLocation.class, XRefFieldLocation.class, IndentFieldLocation.class, AddressFieldLocation.class, BytesFieldLocation.class, MnemonicFieldLocation.class, OperandFieldLocation.class, FieldNameFieldLocation.class, AutomaticCommentFieldLocation.class, RefRepeatCommentFieldLocation.class, EolCommentFieldLocation.class, RepeatableCommentFieldLocation.class, PostCommentFieldLocation.class, SpaceFieldLocation.class, SpacerFieldLocation.class, SubDataFieldLocation.class, RegisterFieldLocation.class};
    public static final ProgramLocationComparator instance = new ProgramLocationComparator();
    private Map<Class<?>, Integer> priorityMap = new HashMap();

    private ProgramLocationComparator() {
        for (int ordinal = 0; ordinal < PROGRAM_LOCATION_CLASSES.length; ++ordinal) {
            this.priorityMap.put(PROGRAM_LOCATION_CLASSES[ordinal], ordinal);
        }
    }

    public int compare(ProgramLocation loc1, ProgramLocation loc2) {
        int result = loc1.getAddress().compareTo(loc2.getAddress());
        if (result == 0) {
            Class<?> class2;
            Class<?> class1 = loc1.getClass();
            if (class1 == (class2 = loc2.getClass())) {
                return 0;
            }
            Integer ordinal1 = this.priorityMap.get(class1);
            Integer ordinal2 = this.priorityMap.get(class2);
            if (ordinal1 == null && ordinal2 == null) {
                return class1.getName().compareTo(class2.getName());
            }
            if (ordinal1 == null) {
                return 1;
            }
            if (ordinal2 == null) {
                return -1;
            }
            result = ordinal1 - ordinal2;
        }
        return result;
    }
}

