/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class ApplyFunctionSignatureCmd
extends BackgroundCommand {
    private Address entryPt;
    private SourceType source;
    private boolean setName;
    private boolean preserveCallingConvention;
    private FunctionSignature signature;
    private Program program;

    public ApplyFunctionSignatureCmd(Address entry, FunctionSignature signature, SourceType source) {
        this(entry, signature, source, false, false);
    }

    public ApplyFunctionSignatureCmd(Address entry, FunctionSignature signature, SourceType source, boolean preserveCallingConvention, boolean setName) {
        super("Create Function", true, false, false);
        this.entryPt = entry;
        this.signature = signature;
        this.source = source;
        this.preserveCallingConvention = preserveCallingConvention;
        this.setName = setName;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        Function func = this.program.getListing().getFunctionContaining(this.entryPt);
        if (func == null) {
            return false;
        }
        monitor.setMessage("Rename " + func.getName());
        try {
            this.setSignature(func, this.signature, this.preserveCallingConvention, this.setName, this.source);
        }
        catch (InvalidInputException e) {
            Msg.warn((Object)((Object)this), (Object)e.getMessage());
            this.setStatusMsg(e.getMessage());
            return false;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.setStatusMsg("Invalid signature");
            return false;
        }
        return true;
    }

    private boolean setSignature(Function func, FunctionSignature signature, boolean preserveCallingConvention, boolean forceName, SourceType source) throws InvalidInputException {
        String name = signature.getName();
        ApplyFunctionSignatureCmd.setName(func, name, source, forceName);
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        String conventionName = this.getCallingConvention(func, compilerSpec);
        ParameterDefinition[] args = signature.getArguments();
        List<Parameter> params = this.createParameters(compilerSpec, conventionName, args);
        SymbolTable symbolTable = this.program.getSymbolTable();
        try {
            this.adjustParameterNamesToAvoidConflicts(symbolTable, func, params);
            ReturnParameterImpl returnParam = new ReturnParameterImpl(signature.getReturnType(), this.program);
            func.updateFunction(conventionName, (Variable)returnParam, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, false, source);
            func.setVarArgs(signature.hasVarArgs());
        }
        catch (DuplicateNameException e) {
            throw new InvalidInputException("Parameter name conflict, likely due to concurrent operation");
        }
        ApplyFunctionSignatureCmd.updateStackPurgeSize(func, this.program);
        return true;
    }

    private List<Parameter> createParameters(CompilerSpec compilerSpec, String conventionName, ParameterDefinition[] args) throws InvalidInputException {
        int firstParamIndex = this.getIndexOfFirstParameter(conventionName, args);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        boolean settleCTypes = compilerSpec.doesCDataTypeConversions();
        DataTypeManager dtm = this.program.getDataTypeManager();
        for (int i = firstParamIndex; i < args.length; ++i) {
            String name = args[i].getName();
            if (Function.RETURN_PTR_PARAM_NAME.equals(name)) continue;
            DataType type = args[i].getDataType().clone(dtm);
            if (settleCTypes) {
                type = ApplyFunctionSignatureCmd.settleCDataType(type, dtm);
            }
            ParameterImpl param = new ParameterImpl(name, type, VariableStorage.UNASSIGNED_STORAGE, this.program);
            param.setComment(args[i].getComment());
            params.add((Parameter)param);
        }
        return params;
    }

    private void adjustParameterNamesToAvoidConflicts(SymbolTable symbolTable, Function function, List<Parameter> params) throws DuplicateNameException, InvalidInputException {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.get(i);
            String name = param.getName();
            if (name == null || SymbolUtilities.isDefaultParameterName((String)name)) continue;
            String uniqueName = ApplyFunctionSignatureCmd.getUniqueParameterName(symbolTable, function, name);
            param.setName(uniqueName, param.getSource());
        }
    }

    private int getIndexOfFirstParameter(String conventionName, ParameterDefinition[] args) {
        if (args.length == 0) {
            return 0;
        }
        if (!"__thiscall".equals(conventionName)) {
            return 0;
        }
        if (!Function.THIS_PARAM_NAME.equals(args[0].getName())) {
            return 0;
        }
        return 1;
    }

    private String getCallingConvention(Function function, CompilerSpec compilerSpec) {
        PrototypeModel convention;
        PrototypeModel preferredModel = null;
        if (this.signature.getGenericCallingConvention() != GenericCallingConvention.unknown) {
            preferredModel = compilerSpec.matchConvention(this.signature.getGenericCallingConvention());
        }
        if ((convention = function.getCallingConvention()) == null || !this.preserveCallingConvention) {
            convention = preferredModel;
        }
        String conventionName = function.getCallingConventionName();
        if (!this.preserveCallingConvention && convention != null) {
            conventionName = convention.getName();
        }
        return conventionName;
    }

    private static void updateStackPurgeSize(Function function, Program program) {
        int extraPop;
        if (function.isStackPurgeSizeValid()) {
            return;
        }
        PrototypeModel convention = function.getCallingConvention();
        if (convention == null) {
            convention = program.getCompilerSpec().getDefaultCallingConvention();
        }
        if ((extraPop = convention.getExtrapop()) != 32768) {
            function.setStackPurgeSize(0);
            return;
        }
        int purgeSize = 0;
        Parameter[] parameters = function.getParameters();
        if (parameters.length > 0) {
            int align = convention.getStackParameterAlignment();
            long min = 0xFFFFFFF0L;
            long max = 0L;
            for (Parameter parameter : parameters) {
                Varnode vn = parameter.getFirstStorageVarnode();
                if (vn == null) {
                    purgeSize = Integer.MAX_VALUE;
                    break;
                }
                if (!vn.getAddress().isStackAddress()) continue;
                long val = vn.getOffset();
                if (val < min) {
                    min = val;
                }
                if ((val += (long)vn.getSize()) <= max) continue;
                max = val;
            }
            if (max > min) {
                int diff = (int)(max - min);
                int rem = diff % align;
                if (rem != 0) {
                    diff += align - rem;
                }
                purgeSize += diff;
            }
        }
        if (purgeSize >= 0 && purgeSize != Integer.MAX_VALUE) {
            function.setStackPurgeSize(purgeSize);
        }
    }

    private static void setName(Function function, String name, SourceType source, boolean forceName) throws InvalidInputException {
        if (name == null) {
            return;
        }
        Program program = function.getProgram();
        Address entryPoint = function.getEntryPoint();
        SymbolUtilities.validateName((String)name, (Address)entryPoint, (SymbolType)SymbolType.FUNCTION, (AddressFactory)program.getAddressMap().getAddressFactory());
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol sym = symbolTable.getPrimarySymbol(entryPoint);
        if (sym == null || sym.getName().equals(name)) {
            return;
        }
        if (!forceName && sym.getSource() != SourceType.DEFAULT) {
            return;
        }
        try {
            ApplyFunctionSignatureCmd.removeCodeSymbol(symbolTable, entryPoint, name, function.getParentNamespace());
            sym.setName(name, source);
        }
        catch (DuplicateNameException e) {
            throw new InvalidInputException("Function name conflict occurred when applying function signature.");
        }
    }

    public static DataType settleCDataType(DataType dt, DataTypeManager dtm) {
        if (dt == null) {
            return dt;
        }
        DataType baseType = dt;
        if (baseType instanceof TypedefDataType) {
            baseType = ((TypedefDataType)baseType).getBaseDataType();
        }
        if (!(baseType instanceof ArrayDataType)) {
            return dt;
        }
        baseType = ((ArrayDataType)baseType).getDataType();
        return dtm.getPointer(baseType);
    }

    private static String getUniqueParameterName(SymbolTable symbolTable, Function function, String name) {
        if (name == null || !SymbolUtilities.isDefaultParameterName((String)name)) {
            return name;
        }
        Symbol s = symbolTable.getParameterSymbol(name, (Namespace)function);
        if (s == null || s.getSymbolType() == SymbolType.PARAMETER) {
            return name;
        }
        return ApplyFunctionSignatureCmd.getUniqueName(symbolTable, (Namespace)function, name);
    }

    private static void removeCodeSymbol(SymbolTable symbolTable, Address address, String name, Namespace namespace) {
        Symbol otherSym = symbolTable.getSymbol(name, address, namespace);
        if (otherSym != null && otherSym.getSymbolType() == SymbolType.LABEL) {
            otherSym.delete();
        }
    }

    private static String getUniqueName(SymbolTable symbolTable, Namespace namespace, String baseName) {
        Object name = baseName;
        if (name != null) {
            int cnt = 0;
            while (!symbolTable.getSymbols((String)name, namespace).isEmpty()) {
                name = baseName + ++cnt;
            }
        }
        return name;
    }
}

