/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class CategoryNode
extends GTreeLazyNode
implements DataTypeTreeNode {
    private Category category;
    private String name;
    private boolean isCut;

    public CategoryNode(Category category) {
        this.setCategory(category);
    }

    protected void setCategory(Category category) {
        this.category = category;
        if (category != null) {
            this.name = category.getName();
        }
    }

    protected synchronized int doGetIndexOfChild(GTreeNode node, List<GTreeNode> children) {
        if (children == null) {
            return -1;
        }
        return Collections.binarySearch(children, node);
    }

    protected List<GTreeNode> generateChildren() {
        if (this.category == null) {
            return Collections.emptyList();
        }
        DataTypeArchiveGTree tree = (DataTypeArchiveGTree)this.getTree();
        if (tree == null) {
            return Collections.emptyList();
        }
        Category[] subCategories = this.category.getCategories();
        DataType[] dataTypes = this.category.getDataTypes();
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>(subCategories.length + dataTypes.length);
        for (Category category : subCategories) {
            children.add((GTreeNode)new CategoryNode(category));
        }
        for (Category category : dataTypes) {
            if (this.isFilteredType(tree, (DataType)category)) continue;
            children.add((GTreeNode)new DataTypeNode((DataType)category));
        }
        Collections.sort(children);
        return children;
    }

    private boolean isFilteredType(DataTypeArchiveGTree tree, DataType dataType) {
        if (tree.isFilterArrays() && dataType instanceof Array) {
            return true;
        }
        return tree.isFilterPointers() && dataType instanceof Pointer && !(dataType.getDataTypeManager() instanceof BuiltInDataTypeManager);
    }

    public int compareTo(GTreeNode node) {
        if (node instanceof CategoryNode) {
            return super.compareTo(node);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CategoryNode otherNode = (CategoryNode)o;
        if (!this.category.equals(otherNode.category)) {
            return false;
        }
        return this.name.equals(otherNode.name);
    }

    public Icon getIcon(boolean expanded) {
        if (!expanded) {
            return DataTypeUtils.getClosedFolderIcon(this.isCut);
        }
        return DataTypeUtils.getOpenFolderIcon(this.isCut);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return "<html>" + HTMLUtilities.escapeHTML((String)this.category.getCategoryPathName());
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean canRename() {
        return this.isModifiable();
    }

    public Category getCategory() {
        return this.category;
    }

    public DataTypeNode getNode(DataType dataType) {
        List children = this.getChildren();
        for (GTreeNode node : children) {
            DataTypeNode dataTypeNode;
            if (!(node instanceof DataTypeNode) || (dataTypeNode = (DataTypeNode)node).getDataType() != dataType) continue;
            return dataTypeNode;
        }
        return null;
    }

    public void categoryAdded(Category newCategory) {
        if (!this.isChildrenLoadedOrInProgress()) {
            return;
        }
        CategoryNode node = new CategoryNode(newCategory);
        List allChildrenList = this.getAllChildren();
        int index = Collections.binarySearch(allChildrenList, node);
        if (index < 0) {
            index = -index - 1;
        }
        this.addNode(index, (GTreeNode)node);
    }

    public void dataTypeAdded(DataType dataType) {
        if (!this.isChildrenLoadedOrInProgress()) {
            return;
        }
        DataTypeArchiveGTree tree = (DataTypeArchiveGTree)this.getTree();
        if (tree == null) {
            return;
        }
        if (this.isFilteredType(tree, dataType)) {
            return;
        }
        DataTypeNode node = new DataTypeNode(dataType);
        List allChildrenList = this.getAllChildren();
        int index = Collections.binarySearch(allChildrenList, node);
        if (index >= 0 && node.getName().equals(((GTreeNode)allChildrenList.get(index)).getName())) {
            return;
        }
        if (index < 0) {
            index = -index - 1;
        }
        this.addNode(index, (GTreeNode)node);
    }

    public void categoryRemoved(String categoryName) {
        for (GTreeNode node : this.getAllChildrenIfLoaded()) {
            if (!(node instanceof CategoryNode) || !node.getName().equals(categoryName)) continue;
            this.removeNode(node);
            return;
        }
    }

    public void dataTypeRemoved(String dataTypeName) {
        for (GTreeNode node : this.getAllChildrenIfLoaded()) {
            if (!(node instanceof DataTypeNode) || !node.getName().equals(dataTypeName)) continue;
            this.removeNode(node);
            return;
        }
    }

    public void dataTypeChanged(DataType dataType) {
        String dataTypeName = dataType.getName();
        for (GTreeNode node : this.getAllChildrenIfLoaded()) {
            if (!(node instanceof DataTypeNode) || !node.getName().equals(dataTypeName)) continue;
            ((DataTypeNode)node).dataTypeChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(Object newValue) {
        int transactionID = this.category.getDataTypeManager().startTransaction("rename");
        try {
            this.category.setName(newValue.toString());
        }
        catch (DuplicateNameException e) {
            Msg.showError(this.getClass(), null, (String)"Rename Failed", (Object)("Category by the name " + newValue + " already exists in this category."));
        }
        catch (InvalidNameException exc) {
            Object msg = exc.getMessage();
            if (msg == null) {
                msg = "Invalid name specified: " + newValue;
            }
            Msg.showError(this.getClass(), null, (String)"Invalid name specified", (Object)exc.getMessage());
        }
        finally {
            this.category.getDataTypeManager().endTransaction(transactionID, true);
        }
    }

    public boolean isEditable() {
        return this.isModifiable();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setNodeCut(boolean isCut) {
        if (!this.canCut()) {
            throw new AssertException("Cannot call isCut() on a node that cannot be cut.");
        }
        this.isCut = isCut;
        this.fireNodeChanged(this.getParent(), (GTreeNode)this);
    }

    @Override
    public boolean canCut() {
        return this.isModifiable();
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return this.isModifiable();
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    @Override
    public ArchiveNode getArchiveNode() {
        GTreeNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return ((DataTypeTreeNode)parent).getArchiveNode();
    }

    @Override
    public boolean isModifiable() {
        ArchiveNode archiveNode = this.getArchiveNode();
        if (archiveNode == null) {
            return false;
        }
        return this.getArchiveNode().isModifiable();
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isSystemNode() {
        return false;
    }
}

