/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class RelocationInfo
implements StructConverter {
    protected int r_address = -1;
    protected int r_symbolnum = -1;
    protected int r_pcrel = -1;
    protected int r_length = -1;
    protected int r_extern = -1;
    protected int r_type = -1;

    public static RelocationInfo createRelocationInfo(FactoryBundledWithBinaryReader reader) throws IOException {
        RelocationInfo relocationInfo = (RelocationInfo)reader.getFactory().create(RelocationInfo.class, new Object[0]);
        relocationInfo.initRelocationInfo(reader);
        return relocationInfo;
    }

    private void initRelocationInfo(FactoryBundledWithBinaryReader reader) throws IOException {
        this.r_address = reader.readNextInt();
        int value = reader.readNextInt();
        if (reader.isLittleEndian()) {
            this.r_symbolnum = value & 0xFFFFFF;
            this.r_pcrel = (value & 0x1000000) >> 24;
            this.r_length = (value & 0x6000000) >> 25;
            this.r_extern = (value & 0x8000000) >> 27;
            this.r_type = (value & 0xF0000000) >> 28;
        } else {
            this.r_symbolnum = (value & 0xFFFFFF00) >> 8;
            this.r_pcrel = (value & 0x80) >> 7;
            this.r_length = (value & 0x60) >> 5;
            this.r_extern = (value & 0x10) >> 4;
            this.r_type = value & 0xF;
        }
    }

    public int getAddress() {
        return this.r_address;
    }

    public int getSymbolIndex() {
        return this.r_symbolnum;
    }

    public boolean isPcRelocated() {
        return this.r_pcrel == 1;
    }

    public int getLength() {
        return this.r_length;
    }

    public boolean isExternal() {
        return this.r_extern == 1;
    }

    public int getType() {
        return this.r_type;
    }

    public long[] toValues() {
        return new long[]{0L, (long)this.r_address & 0xFFFFFFFFL, (long)this.r_symbolnum & 0xFFFFFFFFL, (long)this.r_pcrel & 0xFFFFFFFFL, (long)this.r_length & 0xFFFFFFFFL, (long)this.r_extern & 0xFFFFFFFFL, (long)this.r_type & 0xFFFFFFFFL};
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Address:      " + Long.toHexString(this.r_address));
        buffer.append('\n');
        buffer.append("Symbol Index: " + Integer.toHexString(this.r_symbolnum));
        buffer.append('\n');
        buffer.append("PC Relocated: " + this.isPcRelocated());
        buffer.append('\n');
        buffer.append("Length:       " + Integer.toHexString(this.r_length) + this.getLengthInBytes());
        buffer.append('\n');
        buffer.append("External:     " + this.isExternal());
        buffer.append('\n');
        buffer.append("Type:         " + Integer.toHexString(this.r_type));
        buffer.append('\n');
        return buffer.toString();
    }

    protected String getLengthInBytes() {
        switch (this.r_length) {
            case 0: {
                return " (1 byte)";
            }
            case 1: {
                return " (2 bytes)";
            }
            case 2: {
                return " (3 bytes)";
            }
            case 3: {
                return " (4 bytes)";
            }
        }
        return "";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("relocation_info", 0);
        struct.add(DWORD, "r_address", null);
        struct.add(DWORD, "r_mask", "{r_symbolnum,r_pcrel,r_length,r_extern,r_type}");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

