/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import utilities.util.reflection.ReflectionUtilities;

public class TestUtils {
    private TestUtils() {
    }

    public static String createStackTraceForAllThreads() {
        return ReflectionUtilities.createStackTraceForAllThreads();
    }

    public static void setInstanceField(String fieldName, Object ownerInstance, Object value) throws RuntimeException {
        if (ownerInstance == null) {
            throw new NullPointerException("Owner of instance field cannot be null");
        }
        Class<?> objectClass = ownerInstance instanceof Class ? (Class<?>)ownerInstance : ownerInstance.getClass();
        try {
            Field field = ReflectionUtilities.locateFieldObjectOnClass((String)fieldName, objectClass);
            field.setAccessible(true);
            field.set(ownerInstance, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use reflection to obtain field: " + fieldName + " from class: " + objectClass, e);
        }
    }

    public static Object getInstanceField(String fieldName, Object ownerInstance) throws RuntimeException {
        if (ownerInstance == null) {
            throw new NullPointerException("Owner of instance field cannot be null");
        }
        Class<?> objectClass = ownerInstance instanceof Class ? (Class<?>)ownerInstance : ownerInstance.getClass();
        Object result = null;
        try {
            Field field = ReflectionUtilities.locateFieldObjectOnClass((String)fieldName, objectClass);
            field.setAccessible(true);
            result = field.get(ownerInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use reflection to obtain field: " + fieldName + " from class: " + objectClass, e);
        }
        return result;
    }

    public static List<Object> getAllInstanceFields(Object ownerInstance) {
        Field[] fields;
        if (ownerInstance == null) {
            throw new NullPointerException("Owner of instance field cannot be null");
        }
        Class<?> objectClass = ownerInstance instanceof Class ? (Class<?>)ownerInstance : ownerInstance.getClass();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Field field : fields = objectClass.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object fieldInstance = field.get(ownerInstance);
                results.add(fieldInstance);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to use reflection to obtain fields from class: " + objectClass, e);
            }
        }
        return results;
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        if (ownerInstance == null) {
            throw new NullPointerException("Owner of instance field cannot be null");
        }
        Class<?> objectClass = ownerInstance instanceof Class ? (Class<?>)ownerInstance : ownerInstance.getClass();
        Object result = null;
        try {
            Method method = TestUtils.locateMethodObjectOnClass(methodName, objectClass, parameterTypes);
            if (method == null) {
                throw new NoSuchMethodException("Unable to find a method by the name \"" + methodName + "\" on the class " + objectClass + " or any of its parent implementations.");
            }
            method.setAccessible(true);
            result = method.invoke(ownerInstance, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use reflection to call method: " + methodName + " from class: " + objectClass, e);
        }
        return result;
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, List<Class<?>> parameterTypes, List<Object> args) throws RuntimeException {
        Class[] parameterTypesArray = new Class[parameterTypes.size()];
        parameterTypes.toArray(parameterTypesArray);
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, parameterTypesArray, args.toArray());
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, Class<?> parameterType, Object arg) throws RuntimeException {
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, new Class[]{parameterType}, new Object[]{arg});
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, Object ... args) throws RuntimeException {
        Class<?>[] classes = TestUtils.getClasses(args);
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, classes, args);
    }

    private static Class<?>[] getClasses(Object[] args) {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i].getClass();
        }
        return classes;
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance) throws RuntimeException {
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, (Class[])null, null);
    }

    public static Object invokeConstructor(Class<?> containingClass, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        Object result = null;
        try {
            Constructor<?> constructor = TestUtils.locateConstructorOnClass(containingClass, parameterTypes);
            if (constructor == null) {
                throw new NoSuchMethodException("Unable to find a constructor on the class " + containingClass + " with the given parameters");
            }
            constructor.setAccessible(true);
            result = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use reflection to call constructor from class: " + containingClass, e);
        }
        return result;
    }

    public static Class<?>[] argTypes(Class<?> ... classes) {
        return classes;
    }

    public static Object[] args(Object ... objects) {
        return objects;
    }

    private static Constructor<?> locateConstructorOnClass(Class<?> containingClass, Class<?>[] parameterTypes) {
        return ReflectionUtilities.locateConstructorOnClass(containingClass, (Class[])parameterTypes);
    }

    private static Method locateMethodObjectOnClass(String methodName, Class<?> containingClass, Class<?>[] parameterTypes) {
        return ReflectionUtilities.locateMethodObjectOnClass((String)methodName, containingClass, (Class[])parameterTypes);
    }

    public static <T> T getInstanceFieldByClassType(Class<T> classType, Object ownerInstance) {
        if (ownerInstance == null) {
            throw new NullPointerException("Owner of instance field cannot be null");
        }
        Class<?> objectClass = ownerInstance instanceof Class ? (Class<?>)ownerInstance : ownerInstance.getClass();
        Object result = null;
        try {
            Field field = TestUtils.locateFieldByTypeOnClass(classType, objectClass);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            result = field.get(ownerInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use reflection to obtain a field of type: " + classType.getName() + " from class: " + objectClass, e);
        }
        return (T)result;
    }

    public static Field locateFieldByTypeOnClass(Class<?> classType, Class<?> containingClass) {
        return ReflectionUtilities.locateFieldByTypeOnClass(classType, containingClass);
    }
}

