/*
 * Decompiled with CFR 0.152.
 */
package generic.timer;

import generic.timer.GhidraTimer;
import generic.timer.TimerCallback;
import ghidra.util.exception.AssertException;
import java.util.Timer;
import java.util.TimerTask;

public class GhidraSwinglessTimer
implements GhidraTimer {
    private static final long CLEANUP_TIMER_THREAD_DELAY = 60000L;
    private static Timer timer;
    private static int taskCount;
    private static CleanupTimerTask cleanupTask;
    private TimerCallback callback;
    private boolean repeats;
    private int delay;
    private int initialDelay;
    private TimerTask timerTask;

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("GhidraSwinglessTimer", true);
        }
        return timer;
    }

    private static synchronized void incrementCount() {
        ++taskCount;
        if (cleanupTask != null) {
            cleanupTask.cancel();
            cleanupTask = null;
        }
    }

    private static synchronized void decrementCount() {
        if (--taskCount < 0) {
            throw new AssertException("Timer count out of sync.");
        }
        if (taskCount == 0) {
            cleanupTask = new CleanupTimerTask();
            GhidraSwinglessTimer.getTimer().schedule((TimerTask)cleanupTask, 60000L);
        }
    }

    private static synchronized void cleanupTimer() {
        cleanupTask = null;
        if (taskCount == 0) {
            timer.cancel();
            timer = null;
        }
    }

    public GhidraSwinglessTimer() {
        this(100, null);
    }

    public GhidraSwinglessTimer(int delay, TimerCallback callback) {
        this(delay, delay, callback);
    }

    public GhidraSwinglessTimer(int initialDelay, int delay, TimerCallback callback) {
        this.callback = callback;
        this.delay = delay;
        this.initialDelay = initialDelay;
        this.repeats = true;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public int getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    public boolean isRepeats() {
        return this.repeats;
    }

    @Override
    public synchronized void setDelay(int delay) {
        this.delay = delay;
        if (this.isRunning()) {
            this.stop();
            this.start();
        }
    }

    @Override
    public synchronized void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Override
    public synchronized void setRepeats(boolean repeats) {
        this.repeats = repeats;
    }

    @Override
    public synchronized void setTimerCallback(TimerCallback callback) {
        this.callback = callback;
    }

    @Override
    public synchronized void start() {
        if (this.timerTask != null) {
            return;
        }
        this.timerTask = new MyTimerTask();
        GhidraSwinglessTimer.incrementCount();
        GhidraSwinglessTimer.getTimer().schedule(this.timerTask, this.initialDelay, (long)this.delay);
    }

    @Override
    public synchronized void stop() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
            GhidraSwinglessTimer.decrementCount();
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this.timerTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        final GhidraSwinglessTimer t = new GhidraSwinglessTimer(500, null);
        TimerCallback callback1 = new TimerCallback(){
            int i = 0;

            @Override
            public void timerFired() {
                System.out.println("A: " + this.i);
                if (++this.i == 20) {
                    t.stop();
                }
            }
        };
        t.setTimerCallback(callback1);
        t.start();
        final GhidraSwinglessTimer t2 = new GhidraSwinglessTimer(50, null);
        TimerCallback callback2 = new TimerCallback(){
            int i = 0;

            @Override
            public void timerFired() {
                System.out.println("B: " + this.i);
                if (++this.i == 100) {
                    t2.stop();
                }
            }
        };
        t2.setInitialDelay(250);
        t2.setTimerCallback(callback2);
        t2.start();
        System.err.println("waiting");
        Thread.sleep(20000L);
        Class<GhidraSwinglessTimer> clazz = GhidraSwinglessTimer.class;
        synchronized (GhidraSwinglessTimer.class) {
            if (cleanupTask == null) {
                throw new AssertException("cleanup timer is null");
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            final GhidraSwinglessTimer t3 = new GhidraSwinglessTimer(50, null);
            TimerCallback callback3 = new TimerCallback(){
                int i = 0;

                @Override
                public void timerFired() {
                    System.out.println("C: " + this.i);
                    if (++this.i == 100) {
                        t3.stop();
                    }
                }
            };
            t3.setInitialDelay(250);
            t3.setTimerCallback(callback3);
            t3.start();
            System.err.println("waiting");
            Thread.sleep(20000L);
            Class<GhidraSwinglessTimer> clazz2 = GhidraSwinglessTimer.class;
            synchronized (GhidraSwinglessTimer.class) {
                if (cleanupTask == null) {
                    throw new AssertException("cleanup timer is null");
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
                System.err.println("wait for cleanup;");
                Thread.sleep(60000L);
                clazz2 = GhidraSwinglessTimer.class;
                synchronized (GhidraSwinglessTimer.class) {
                    if (cleanupTask != null) {
                        throw new AssertException("cleanup timer did not go away");
                    }
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    System.err.println("done");
                    return;
                }
            }
        }
    }

    static {
        taskCount = 0;
        cleanupTask = null;
    }

    static class CleanupTimerTask
    extends TimerTask {
        CleanupTimerTask() {
        }

        @Override
        public void run() {
            GhidraSwinglessTimer.cleanupTimer();
        }
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimerCallback c;
            GhidraSwinglessTimer ghidraSwinglessTimer = GhidraSwinglessTimer.this;
            synchronized (ghidraSwinglessTimer) {
                c = GhidraSwinglessTimer.this.callback;
                if (!GhidraSwinglessTimer.this.repeats) {
                    GhidraSwinglessTimer.this.timerTask.cancel();
                    GhidraSwinglessTimer.this.timerTask = null;
                    GhidraSwinglessTimer.decrementCount();
                }
            }
            if (c != null) {
                c.timerFired();
            }
        }
    }
}

