/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.scala.HashedClasspath;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.toolchain.DefaultScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.NotFoundScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.ScalaToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DownloadingScalaToolChain
implements ScalaToolChainInternal {
    private final File gradleUserHomeDir;
    private final File daemonWorkingDir;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final JavaVersion javaVersion;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final ClasspathHasher classpathHasher;

    public DownloadingScalaToolChain(File gradleUserHomeDir, File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory, ClasspathHasher classpathHasher) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.forkOptionsFactory = forkOptionsFactory;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.javaVersion = JavaVersion.current();
        this.classpathHasher = classpathHasher;
    }

    public String getName() {
        return "Scala Toolchain";
    }

    public String getDisplayName() {
        return "Scala Toolchain (JDK " + this.javaVersion.getMajorVersion() + " (" + this.javaVersion + "))";
    }

    public ToolProvider select(ScalaPlatform targetPlatform) {
        try {
            Dependency scalaCompiler = this.dependencyHandler.create((Object)("org.scala-lang:scala-compiler:" + targetPlatform.getScalaVersion()));
            Dependency compilerBridge = this.dependencyHandler.create((Object)("org.scala-sbt:compiler-bridge_" + targetPlatform.getScalaCompatibilityVersion() + ":" + "1.3.5" + ":sources@jar"));
            Dependency compilerInterface = this.dependencyHandler.create((Object)"org.scala-sbt:compiler-interface:1.3.5");
            Configuration scalaClasspath = this.resolveDependency(scalaCompiler, compilerBridge, compilerInterface);
            ClassPath resolvedScalaClasspath = DefaultClassPath.of((Collection)scalaClasspath.resolve());
            HashedClasspath hashedScalaClasspath = new HashedClasspath(resolvedScalaClasspath, this.classpathHasher);
            Configuration zincClasspath = this.resolveDependency(this.dependencyHandler.create((Object)"org.scala-sbt:zinc_2.12:1.3.5"));
            Set resolvedZincClasspath = zincClasspath.resolve();
            return new DefaultScalaToolProvider(this.daemonWorkingDir, this.workerDaemonFactory, this.forkOptionsFactory, hashedScalaClasspath, resolvedZincClasspath, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory);
        }
        catch (ResolveException resolveException) {
            return new NotFoundScalaToolProvider((Exception)((Object)resolveException));
        }
    }

    private Configuration resolveDependency(Dependency ... dependencies) {
        return this.configurationContainer.detachedConfiguration(dependencies);
    }
}

