/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import java.io.Closeable;
import java.io.File;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionHistoryStore;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class DefaultImmutableWorkspaceProvider
implements ImmutableWorkspaceProvider,
Closeable {
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File baseDirectory;
    private final ExecutionHistoryStore executionHistoryStore;
    private final PersistentCache cache;

    public DefaultImmutableWorkspaceProvider(String name, File baseDirectory, CacheRepository cacheRepository, FileAccessTimeJournal fileAccessTimeJournal, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner stringInterner) {
        this.baseDirectory = baseDirectory;
        this.cache = cacheRepository.cache(baseDirectory).withCleanup(DefaultImmutableWorkspaceProvider.createCleanupAction(baseDirectory, fileAccessTimeJournal)).withDisplayName(name).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, baseDirectory, 1);
        this.executionHistoryStore = new DefaultExecutionHistoryStore(() -> this.cache, inMemoryCacheDecoratorFactory, stringInterner);
    }

    private static CleanupAction createCleanupAction(File filesOutputDirectory, FileAccessTimeJournal fileAccessTimeJournal) {
        return CompositeCleanupAction.builder().add(filesOutputDirectory, new CleanupAction[]{new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), fileAccessTimeJournal, 7L)}).build();
    }

    @Override
    public <T> T withWorkspace(String identity, ImmutableWorkspaceProvider.WorkspaceAction<T> action) {
        return (T)this.cache.withFileLock(() -> {
            File workspace = new File(this.baseDirectory, identity);
            this.fileAccessTracker.markAccessed(workspace);
            return action.executeInWorkspace(workspace, this.executionHistoryStore);
        });
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

