/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.CertificateFile;
import org.jruby.ext.openssl.x509store.CertificateHashDir;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.LookupMethod;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;

public class Store
implements X509TrustManager {
    private static final X509Object[] NULL_OBJECTS = new X509Object[0];
    private static final Lookup[] NULL_LOOKUP = new Lookup[0];
    private volatile X509Object[] objects = NULL_OBJECTS;
    private volatile Lookup[] certLookups = NULL_LOOKUP;
    final VerifyParameter verifyParameter = new VerifyParameter();
    VerifyFunction verify;
    VerifyCallbackFunction verifyCallback;
    GetIssuerFunction getIssuer;
    CheckIssuedFunction checkIssued;
    CheckRevocationFunction checkRevocation;
    GetCRLFunction getCRL;
    CheckCRLFunction checkCRL;
    CertificateCRLFunction certificateCRL;
    CleanupFunction cleanup;
    LookupCerts lookup_certs;
    private final ArrayList<Object> extraData = new ArrayList(4);

    public List<X509Object> getObjects() {
        return Arrays.asList(this.objects);
    }

    public List<Lookup> getCertificateMethods() {
        return Arrays.asList(this.certLookups);
    }

    public void setVerifyFunction(VerifyFunction func) {
        this.verify = func;
    }

    public void setVerifyCallbackFunction(VerifyCallbackFunction func) {
        this.verifyCallback = func;
    }

    public void free() throws Exception {
        for (Lookup lu : this.certLookups) {
            lu.shutdown();
            lu.free();
        }
        if (this.verifyParameter != null) {
            this.verifyParameter.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraData(int idx, Object data) {
        assert (idx >= 0);
        assert (idx < 4);
        ArrayList<Object> arrayList = this.extraData;
        synchronized (arrayList) {
            while (this.extraData.size() <= idx) {
                this.extraData.add(null);
            }
            this.extraData.set(idx, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getExtraData(int idx) {
        ArrayList<Object> arrayList = this.extraData;
        synchronized (arrayList) {
            if (this.extraData.size() <= idx) {
                return null;
            }
            return this.extraData.get(idx);
        }
    }

    public int setDepth(int depth) {
        this.verifyParameter.setDepth(depth);
        return 1;
    }

    public int setFlags(long flags) {
        return this.verifyParameter.setFlags(flags);
    }

    public int setPurpose(int purpose) {
        return this.verifyParameter.setPurpose(purpose);
    }

    public int setTrust(int trust) {
        return this.verifyParameter.setTrust(trust);
    }

    public VerifyParameter getParam() {
        return this.verifyParameter;
    }

    public void setParam(VerifyParameter param) {
        this.verifyParameter.set(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup addLookup(Ruby runtime, LookupMethod method) {
        Lookup[] certLookups = this.certLookups;
        Lookup foundLookup = Store.findLookupMethod(certLookups, method);
        if (foundLookup != null) {
            return foundLookup;
        }
        Lookup newLookup = new Lookup(runtime, method);
        newLookup.store = this;
        Store store = this;
        synchronized (store) {
            int length = this.certLookups.length;
            if (certLookups.length != length && (foundLookup = Store.findLookupMethod(this.certLookups, method)) != null) {
                return foundLookup;
            }
            Lookup[] newCertLookups = Arrays.copyOf(this.certLookups, length + 1);
            newCertLookups[length] = newLookup;
            this.certLookups = newCertLookups;
        }
        return newLookup;
    }

    private static Lookup findLookupMethod(Lookup[] lookups, LookupMethod method) {
        for (Lookup lookup : lookups) {
            if (!lookup.method.equals(method)) continue;
            return lookup;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCertificate(X509Certificate cert2) {
        if (cert2 == null) {
            return 0;
        }
        Certificate obj = new Certificate(StoreContext.ensureAux(cert2));
        Store store = this;
        synchronized (store) {
            X509Object[] objects = this.objects;
            if (Store.matchedObject(objects, obj)) {
                return 1;
            }
            return this.addObject(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCRL(java.security.cert.CRL crl2) {
        if (crl2 == null) {
            return 0;
        }
        CRL obj = new CRL(crl2);
        Store store = this;
        synchronized (store) {
            X509Object[] objects = this.objects;
            if (Store.matchedObject(objects, obj)) {
                return 1;
            }
            return this.addObject(obj);
        }
    }

    private static boolean matchedObject(X509Object[] objects, X509Object xObject) {
        for (int i2 = 0; i2 < objects.length; ++i2) {
            if (!objects[i2].matches(xObject)) continue;
            return true;
        }
        return false;
    }

    private int addObject(X509Object xObject) {
        int len = this.objects.length;
        X509Object[] objects = Arrays.copyOf(this.objects, len + 1);
        objects[len] = xObject;
        this.objects = objects;
        return 1;
    }

    public int loadLocations(Ruby runtime, String file, String path) throws Exception {
        Lookup lookup;
        if (file != null) {
            lookup = this.addLookup(runtime, Lookup.fileLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.loadFile(new CertificateFile.Path(file, 1)) != 1) {
                return 0;
            }
        }
        if (path != null) {
            lookup = this.addLookup(runtime, Lookup.hashDirLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.addDir(new CertificateHashDir.Dir(path, 1)) != 1) {
                return 0;
            }
        }
        if (path == null && file == null) {
            return 0;
        }
        return 1;
    }

    public int setDefaultPaths(Ruby runtime) throws Exception {
        Lookup lookup = this.addLookup(runtime, Lookup.fileLookup());
        try {
            lookup.loadFile(new CertificateFile.Path(null, 3));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            if (!e.getClass().getSimpleName().equals("NotFound")) {
                throw e;
            }
            OpenSSL.debug(runtime, "add X509_CERT_FILER_CTX (to default paths)", e);
        }
        lookup = this.addLookup(runtime, Lookup.hashDirLookup());
        try {
            lookup.addDir(new CertificateHashDir.Dir(null, 3));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            if (!e.getClass().getSimpleName().equals("NotFound")) {
                throw e;
            }
            OpenSSL.debug(runtime, "add X509_HASH_DIR_CTX (to default paths)", e);
        }
        X509Error.clearErrors();
        return 1;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain2, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain2, String authType) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Object[] objects = this.objects;
        ArrayList<X509AuxCertificate> issuers = new ArrayList<X509AuxCertificate>(objects.length);
        for (int i2 = 0; i2 < objects.length; ++i2) {
            X509Object object = objects[i2];
            if (!(object instanceof Certificate)) continue;
            issuers.add(((Certificate)object).cert);
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    static interface LookupCerts {
        public List<X509AuxCertificate> call(StoreContext var1, Name var2) throws Exception;
    }

    static interface CleanupFunction
    extends Function1<StoreContext> {
    }

    static interface CertificateCRLFunction
    extends Function3<StoreContext, X509CRL, X509AuxCertificate> {
    }

    static interface CheckCRLFunction
    extends Function2<StoreContext, X509CRL> {
    }

    static interface GetCRLFunction
    extends Function3<StoreContext, X509CRL[], X509AuxCertificate> {
    }

    static interface CheckRevocationFunction
    extends Function1<StoreContext> {
    }

    static interface CheckIssuedFunction
    extends Function3<StoreContext, X509AuxCertificate, X509AuxCertificate> {
    }

    static interface GetIssuerFunction
    extends Function3<StoreContext, X509AuxCertificate[], X509AuxCertificate> {
    }

    public static interface VerifyCallbackFunction
    extends Function2<StoreContext, Integer> {
    }

    public static interface VerifyFunction
    extends Function1<StoreContext> {
    }
}

