/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short s, Object object) {
        if (!CertificateStatus.isCorrectType(s, object)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = s;
        this.response = object;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public Vector getOCSPResponseList() {
        if (!CertificateStatus.isCorrectType((short)2, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponseList");
        }
        return (Vector)this.response;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.statusType, outputStream);
        switch (this.statusType) {
            case 1: {
                OCSPResponse oCSPResponse = (OCSPResponse)this.response;
                byte[] byArray = oCSPResponse.getEncoded("DER");
                TlsUtils.writeOpaque24(byArray, outputStream);
                break;
            }
            case 2: {
                Object object;
                int n;
                Vector vector = (Vector)this.response;
                int n2 = vector.size();
                Vector<byte[]> vector2 = new Vector<byte[]>(n2);
                long l = 0L;
                for (n = 0; n < n2; ++n) {
                    object = (OCSPResponse)vector.elementAt(n);
                    if (object == null) {
                        vector2.addElement(TlsUtils.EMPTY_BYTES);
                    } else {
                        byte[] byArray = object.getEncoded("DER");
                        vector2.addElement(byArray);
                        l += (long)byArray.length;
                    }
                    l += 3L;
                }
                TlsUtils.checkUint24(l);
                TlsUtils.writeUint24((int)l, outputStream);
                for (n = 0; n < n2; ++n) {
                    object = (byte[])vector2.elementAt(n);
                    TlsUtils.writeOpaque24((byte[])object, outputStream);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        Object object;
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        Certificate certificate = securityParameters.getPeerCertificate();
        if (null == certificate || certificate.isEmpty() || 0 != certificate.getCertificateType()) {
            throw new TlsFatalAlert(80);
        }
        int n = certificate.getLength();
        int n2 = securityParameters.getStatusRequestVersion();
        short s = TlsUtils.readUint8(inputStream);
        switch (s) {
            case 1: {
                CertificateStatus.requireStatusRequestVersion(1, n2);
                byte[] byArray = TlsUtils.readOpaque24(inputStream, 1);
                ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray);
                object = OCSPResponse.getInstance((Object)aSN1Primitive);
                break;
            }
            case 2: {
                CertificateStatus.requireStatusRequestVersion(2, n2);
                byte[] byArray = TlsUtils.readOpaque24(inputStream, 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Vector<OCSPResponse> vector = new Vector<OCSPResponse>();
                while (byteArrayInputStream.available() > 0) {
                    if (vector.size() >= n) {
                        throw new TlsFatalAlert(47);
                    }
                    int n3 = TlsUtils.readUint24(byteArrayInputStream);
                    if (n3 < 1) {
                        vector.addElement(null);
                        continue;
                    }
                    byte[] byArray2 = TlsUtils.readFully(n3, (InputStream)byteArrayInputStream);
                    ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray2);
                    OCSPResponse oCSPResponse = OCSPResponse.getInstance((Object)aSN1Primitive);
                    vector.addElement(oCSPResponse);
                }
                vector.trimToSize();
                object = vector;
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(s, object);
    }

    protected static boolean isCorrectType(short s, Object object) {
        switch (s) {
            case 1: {
                return object instanceof OCSPResponse;
            }
            case 2: {
                return CertificateStatus.isOCSPResponseList(object);
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }

    protected static boolean isOCSPResponseList(Object object) {
        if (!(object instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)object;
        int n = vector.size();
        if (n < 1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (null == e || e instanceof OCSPResponse) continue;
            return false;
        }
        return true;
    }

    protected static void requireStatusRequestVersion(int n, int n2) throws IOException {
        if (n2 < n) {
            throw new TlsFatalAlert(50);
        }
    }
}

