/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.viewer.HTMLTemplateDisplay;
import com.ca.directory.jxplorer.viewer.MyHTMLEditorKit;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.swing.text.Element;
import javax.swing.text.html.FormView;

class MyFormView
extends FormView {
    public static final String SUBMIT = "Submit";
    HTMLTemplateDisplay templateDisplay;
    private static Logger log = Logger.getLogger(MyHTMLEditorKit.class.getName());

    public MyFormView(Element elem, HTMLTemplateDisplay display) {
        super(elem);
        this.templateDisplay = display;
    }

    protected void submitData(String data) {
        DXEntry oldEntry = this.templateDisplay.currentEntry;
        log.finest("Entry before changes: " + oldEntry);
        DN dn = oldEntry.getDN();
        RDN rdn = new RDN(oldEntry.getRDN());
        String[] namingTypes = rdn.getAtts();
        String[] namingRawValues = rdn.getRawVals();
        boolean nameChanged = false;
        DXEntry newEntry = this.parseData(data, oldEntry);
        newEntry.remove(SUBMIT);
        log.finest("Entry after changes: " + newEntry);
        if (newEntry == null) {
            return;
        }
        try {
            for (int i = 0; i < namingTypes.length; ++i) {
                String newName;
                Attribute namingAtt = newEntry.get(namingTypes[i]);
                if (namingAtt == null || (newName = (String)namingAtt.get()) == null) continue;
                if (!newName.trim().equalsIgnoreCase(newName)) {
                    if ((newName = newName.trim()).length() == 0) {
                        newName = " ";
                    }
                    namingAtt.remove(0);
                    namingAtt.add(0, newName);
                }
                if (newName.equals(namingRawValues)) continue;
                nameChanged = true;
                rdn.setRawVal(newName, i);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error parsing entry name in HTMLEditorKit ", e);
        }
        if (nameChanged) {
            DN newDN = new DN(dn);
            newDN.setRDN(rdn, newDN.size() - 1);
            newEntry.setDN(newDN);
        } else {
            newEntry.setDN(dn);
        }
        NamingEnumeration allOldAtts = oldEntry.getAll();
        while (allOldAtts.hasMoreElements()) {
            Attribute att = (Attribute)allOldAtts.nextElement();
            if (att.size() == 0 || newEntry.get(att.getID()) != null) continue;
            newEntry.put(att);
        }
        this.templateDisplay.currentDataSource.modifyEntry(oldEntry, newEntry);
    }

    public DXEntry parseData(String data, DXEntry oldEntry) {
        DXEntry newEntry = new DXEntry();
        HashSet<Attribute> forbiddenAttributes = null;
        int start = 0;
        int equalpos = 0;
        int end = 0;
        int length = data.length();
        try {
            while (start < length) {
                Attribute att;
                int dataLength;
                end = data.indexOf(38, start);
                if (end == -1) {
                    end = length;
                }
                equalpos = data.indexOf(61, start);
                String attribute = data.substring(start, equalpos);
                String value = URLDecoder.decode(data.substring(equalpos + 1, end));
                Object val = value;
                String stringVal = null;
                if (this.templateDisplay.currentBinaryAttributes.contains(attribute.toLowerCase())) {
                    Object original = null;
                    String oldVal = null;
                    Attribute binAtt = this.templateDisplay.currentEntry.get(attribute);
                    if (binAtt != null && binAtt.size() > 0) {
                        original = binAtt.get();
                        oldVal = CBBase64.binaryToString((byte[])original);
                    }
                    if (value.equals(oldVal)) {
                        val = original;
                    } else if (attribute.toLowerCase().indexOf("password") > -1) {
                        try {
                            val = value.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e2) {
                            CBUtility.error(this.templateDisplay, CBIntText.get("Unable to UTF-8 encode password"), (Exception)e2);
                        }
                    } else {
                        val = CBBase64.stringToBinary(value);
                    }
                } else if (attribute.toLowerCase().indexOf("address") > -1) {
                    val = value.replace('\n', '$');
                }
                if (val instanceof String) {
                    stringVal = val;
                }
                int n = dataLength = stringVal != null ? stringVal.length() : ((byte[])val).length;
                if (stringVal != null && stringVal.equals("[ATTRIBUTE TOO LARGE TO DISPLAY]")) {
                    if (forbiddenAttributes == null) {
                        forbiddenAttributes = new HashSet<Attribute>();
                    }
                    att = oldEntry.get(attribute);
                    newEntry.put(att);
                    forbiddenAttributes.add(att);
                } else if (newEntry.get(attribute) != null) {
                    if (dataLength != 0) {
                        att = newEntry.get(attribute);
                        if (forbiddenAttributes == null || !forbiddenAttributes.contains(att)) {
                            att.add(val);
                        }
                    }
                } else if (dataLength != 0) {
                    newEntry.put(new DXAttribute(attribute, val));
                } else {
                    newEntry.put(new DXAttribute(attribute));
                }
                start = end + 1;
            }
        }
        catch (Exception e) {
            CBUtility.error(this.templateDisplay, "Unable to submit form due\nto a problem with the query url.", new Exception("Parser error in MyHTMLEditorKit - badly formed query url: " + data + "\n  " + e.toString()));
            return null;
        }
        return newEntry;
    }
}

