/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.CounterMetric;
import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Rubyfier;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.plugins.CounterMetricImpl;
import org.logstash.plugins.RootMetricImpl;

public class NamespacedMetricImpl
implements NamespacedMetric {
    private final ThreadContext threadContext;
    private final AbstractNamespacedMetricExt metrics;

    public NamespacedMetricImpl(ThreadContext threadContext, AbstractNamespacedMetricExt metrics) {
        this.threadContext = threadContext;
        this.metrics = metrics;
    }

    @Override
    public void gauge(String key, Object value) {
        this.metrics.gauge(this.threadContext, (IRubyObject)this.getSymbol(key), Rubyfier.deep(this.threadContext.getRuntime(), value));
    }

    @Override
    public CounterMetric counter(String metric) {
        return new CounterMetricImpl(this.threadContext, this.metrics, metric);
    }

    @Override
    public NamespacedMetric namespace(String ... key) {
        IRubyObject[] rubyfiedKeys = (IRubyObject[])Stream.of(key).map(this::getSymbol).toArray(IRubyObject[]::new);
        return new NamespacedMetricImpl(this.threadContext, this.metrics.namespace(this.threadContext, (IRubyObject)RubyArray.newArray((Ruby)this.threadContext.getRuntime(), (IRubyObject[])rubyfiedKeys)));
    }

    @Override
    public void increment(String key) {
        this.metrics.increment(this.threadContext, new IRubyObject[]{this.getSymbol(key)});
    }

    @Override
    public void increment(String key, int amount) {
        this.metrics.increment(this.threadContext, new IRubyObject[]{this.getSymbol(key), this.convert(amount)});
    }

    @Override
    public <T> T time(String key, Supplier<T> callable) {
        long start = System.nanoTime();
        T ret = callable.get();
        long end = System.nanoTime();
        this.reportTime(key, TimeUnit.NANOSECONDS.toMillis(end - start));
        return ret;
    }

    @Override
    public void reportTime(String key, long duration) {
        this.metrics.reportTime(this.threadContext, (IRubyObject)this.getSymbol(key), this.convert(duration));
    }

    @Override
    public String[] namespaceName() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object o : this.metrics.namespaceName(this.threadContext)) {
            if (!(o instanceof RubyObject)) continue;
            names.add(((RubyObject)o).to_s().toString());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public Metric root() {
        return new RootMetricImpl(this.threadContext, this.metrics.root(this.threadContext));
    }

    private RubySymbol getSymbol(String s) {
        return this.threadContext.getRuntime().newSymbol(s);
    }

    private IRubyObject convert(Object o) {
        return Rubyfier.deep(this.threadContext.getRuntime(), o);
    }
}

