/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3JointInfo")
public class B3JointInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_LINKNAME;
    public static final int M_JOINTNAME;
    public static final int M_JOINTTYPE;
    public static final int M_QINDEX;
    public static final int M_UINDEX;
    public static final int M_JOINTINDEX;
    public static final int M_FLAGS;
    public static final int M_JOINTDAMPING;
    public static final int M_JOINTFRICTION;
    public static final int M_JOINTLOWERLIMIT;
    public static final int M_JOINTUPPERLIMIT;
    public static final int M_JOINTMAXFORCE;
    public static final int M_JOINTMAXVELOCITY;
    public static final int M_PARENTFRAME;
    public static final int M_CHILDFRAME;
    public static final int M_JOINTAXIS;
    public static final int M_PARENTINDEX;
    public static final int M_QSIZE;
    public static final int M_USIZE;

    public B3JointInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3JointInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[1024]")
    public ByteBuffer m_linkName() {
        return B3JointInfo.nm_linkName(this.address());
    }

    @NativeType(value="char[1024]")
    public String m_linkNameString() {
        return B3JointInfo.nm_linkNameString(this.address());
    }

    @NativeType(value="char[1024]")
    public ByteBuffer m_jointName() {
        return B3JointInfo.nm_jointName(this.address());
    }

    @NativeType(value="char[1024]")
    public String m_jointNameString() {
        return B3JointInfo.nm_jointNameString(this.address());
    }

    public int m_jointType() {
        return B3JointInfo.nm_jointType(this.address());
    }

    public int m_qIndex() {
        return B3JointInfo.nm_qIndex(this.address());
    }

    public int m_uIndex() {
        return B3JointInfo.nm_uIndex(this.address());
    }

    public int m_jointIndex() {
        return B3JointInfo.nm_jointIndex(this.address());
    }

    public int m_flags() {
        return B3JointInfo.nm_flags(this.address());
    }

    public double m_jointDamping() {
        return B3JointInfo.nm_jointDamping(this.address());
    }

    public double m_jointFriction() {
        return B3JointInfo.nm_jointFriction(this.address());
    }

    public double m_jointLowerLimit() {
        return B3JointInfo.nm_jointLowerLimit(this.address());
    }

    public double m_jointUpperLimit() {
        return B3JointInfo.nm_jointUpperLimit(this.address());
    }

    public double m_jointMaxForce() {
        return B3JointInfo.nm_jointMaxForce(this.address());
    }

    public double m_jointMaxVelocity() {
        return B3JointInfo.nm_jointMaxVelocity(this.address());
    }

    @NativeType(value="double[7]")
    public DoubleBuffer m_parentFrame() {
        return B3JointInfo.nm_parentFrame(this.address());
    }

    public double m_parentFrame(int index) {
        return B3JointInfo.nm_parentFrame(this.address(), index);
    }

    @NativeType(value="double[7]")
    public DoubleBuffer m_childFrame() {
        return B3JointInfo.nm_childFrame(this.address());
    }

    public double m_childFrame(int index) {
        return B3JointInfo.nm_childFrame(this.address(), index);
    }

    @NativeType(value="double[3]")
    public DoubleBuffer m_jointAxis() {
        return B3JointInfo.nm_jointAxis(this.address());
    }

    public double m_jointAxis(int index) {
        return B3JointInfo.nm_jointAxis(this.address(), index);
    }

    public int m_parentIndex() {
        return B3JointInfo.nm_parentIndex(this.address());
    }

    public int m_qSize() {
        return B3JointInfo.nm_qSize(this.address());
    }

    public int m_uSize() {
        return B3JointInfo.nm_uSize(this.address());
    }

    public B3JointInfo m_linkName(@NativeType(value="char[1024]") ByteBuffer value) {
        B3JointInfo.nm_linkName(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointName(@NativeType(value="char[1024]") ByteBuffer value) {
        B3JointInfo.nm_jointName(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointType(int value) {
        B3JointInfo.nm_jointType(this.address(), value);
        return this;
    }

    public B3JointInfo m_qIndex(int value) {
        B3JointInfo.nm_qIndex(this.address(), value);
        return this;
    }

    public B3JointInfo m_uIndex(int value) {
        B3JointInfo.nm_uIndex(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointIndex(int value) {
        B3JointInfo.nm_jointIndex(this.address(), value);
        return this;
    }

    public B3JointInfo m_flags(int value) {
        B3JointInfo.nm_flags(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointDamping(double value) {
        B3JointInfo.nm_jointDamping(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointFriction(double value) {
        B3JointInfo.nm_jointFriction(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointLowerLimit(double value) {
        B3JointInfo.nm_jointLowerLimit(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointUpperLimit(double value) {
        B3JointInfo.nm_jointUpperLimit(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointMaxForce(double value) {
        B3JointInfo.nm_jointMaxForce(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointMaxVelocity(double value) {
        B3JointInfo.nm_jointMaxVelocity(this.address(), value);
        return this;
    }

    public B3JointInfo m_parentFrame(@NativeType(value="double[7]") DoubleBuffer value) {
        B3JointInfo.nm_parentFrame(this.address(), value);
        return this;
    }

    public B3JointInfo m_parentFrame(int index, double value) {
        B3JointInfo.nm_parentFrame(this.address(), index, value);
        return this;
    }

    public B3JointInfo m_childFrame(@NativeType(value="double[7]") DoubleBuffer value) {
        B3JointInfo.nm_childFrame(this.address(), value);
        return this;
    }

    public B3JointInfo m_childFrame(int index, double value) {
        B3JointInfo.nm_childFrame(this.address(), index, value);
        return this;
    }

    public B3JointInfo m_jointAxis(@NativeType(value="double[3]") DoubleBuffer value) {
        B3JointInfo.nm_jointAxis(this.address(), value);
        return this;
    }

    public B3JointInfo m_jointAxis(int index, double value) {
        B3JointInfo.nm_jointAxis(this.address(), index, value);
        return this;
    }

    public B3JointInfo m_parentIndex(int value) {
        B3JointInfo.nm_parentIndex(this.address(), value);
        return this;
    }

    public B3JointInfo m_qSize(int value) {
        B3JointInfo.nm_qSize(this.address(), value);
        return this;
    }

    public B3JointInfo m_uSize(int value) {
        B3JointInfo.nm_uSize(this.address(), value);
        return this;
    }

    public B3JointInfo set(ByteBuffer m_linkName, ByteBuffer m_jointName, int m_jointType, int m_qIndex, int m_uIndex, int m_jointIndex, int m_flags, double m_jointDamping, double m_jointFriction, double m_jointLowerLimit, double m_jointUpperLimit, double m_jointMaxForce, double m_jointMaxVelocity, DoubleBuffer m_parentFrame, DoubleBuffer m_childFrame, DoubleBuffer m_jointAxis, int m_parentIndex, int m_qSize, int m_uSize) {
        this.m_linkName(m_linkName);
        this.m_jointName(m_jointName);
        this.m_jointType(m_jointType);
        this.m_qIndex(m_qIndex);
        this.m_uIndex(m_uIndex);
        this.m_jointIndex(m_jointIndex);
        this.m_flags(m_flags);
        this.m_jointDamping(m_jointDamping);
        this.m_jointFriction(m_jointFriction);
        this.m_jointLowerLimit(m_jointLowerLimit);
        this.m_jointUpperLimit(m_jointUpperLimit);
        this.m_jointMaxForce(m_jointMaxForce);
        this.m_jointMaxVelocity(m_jointMaxVelocity);
        this.m_parentFrame(m_parentFrame);
        this.m_childFrame(m_childFrame);
        this.m_jointAxis(m_jointAxis);
        this.m_parentIndex(m_parentIndex);
        this.m_qSize(m_qSize);
        this.m_uSize(m_uSize);
        return this;
    }

    public B3JointInfo set(B3JointInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3JointInfo malloc() {
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3JointInfo calloc() {
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3JointInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3JointInfo create(long address) {
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)address);
    }

    @Nullable
    public static B3JointInfo createSafe(long address) {
        return address == 0L ? null : (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3JointInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3JointInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3JointInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3JointInfo mallocStack() {
        return B3JointInfo.mallocStack(MemoryStack.stackGet());
    }

    public static B3JointInfo callocStack() {
        return B3JointInfo.callocStack(MemoryStack.stackGet());
    }

    public static B3JointInfo mallocStack(MemoryStack stack) {
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3JointInfo callocStack(MemoryStack stack) {
        return (B3JointInfo)B3JointInfo.wrap(B3JointInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3JointInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3JointInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3JointInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nm_linkName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_LINKNAME), (int)1024);
    }

    public static String nm_linkNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_LINKNAME));
    }

    public static ByteBuffer nm_jointName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)M_JOINTNAME), (int)1024);
    }

    public static String nm_jointNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)M_JOINTNAME));
    }

    public static int nm_jointType(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_JOINTTYPE);
    }

    public static int nm_qIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_QINDEX);
    }

    public static int nm_uIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_UINDEX);
    }

    public static int nm_jointIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_JOINTINDEX);
    }

    public static int nm_flags(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_FLAGS);
    }

    public static double nm_jointDamping(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTDAMPING);
    }

    public static double nm_jointFriction(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTFRICTION);
    }

    public static double nm_jointLowerLimit(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTLOWERLIMIT);
    }

    public static double nm_jointUpperLimit(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTUPPERLIMIT);
    }

    public static double nm_jointMaxForce(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTMAXFORCE);
    }

    public static double nm_jointMaxVelocity(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTMAXVELOCITY);
    }

    public static DoubleBuffer nm_parentFrame(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_PARENTFRAME), (int)7);
    }

    public static double nm_parentFrame(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_PARENTFRAME + Checks.check((int)index, (int)7) * 8L);
    }

    public static DoubleBuffer nm_childFrame(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_CHILDFRAME), (int)7);
    }

    public static double nm_childFrame(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_CHILDFRAME + Checks.check((int)index, (int)7) * 8L);
    }

    public static DoubleBuffer nm_jointAxis(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_JOINTAXIS), (int)3);
    }

    public static double nm_jointAxis(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_JOINTAXIS + Checks.check((int)index, (int)3) * 8L);
    }

    public static int nm_parentIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_PARENTINDEX);
    }

    public static int nm_qSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_QSIZE);
    }

    public static int nm_uSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_USIZE);
    }

    public static void nm_linkName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_LINKNAME), (long)value.remaining());
    }

    public static void nm_jointName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)M_JOINTNAME), (long)value.remaining());
    }

    public static void nm_jointType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_JOINTTYPE, value);
    }

    public static void nm_qIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_QINDEX, value);
    }

    public static void nm_uIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_UINDEX, value);
    }

    public static void nm_jointIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_JOINTINDEX, value);
    }

    public static void nm_flags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_FLAGS, value);
    }

    public static void nm_jointDamping(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTDAMPING, value);
    }

    public static void nm_jointFriction(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTFRICTION, value);
    }

    public static void nm_jointLowerLimit(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTLOWERLIMIT, value);
    }

    public static void nm_jointUpperLimit(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTUPPERLIMIT, value);
    }

    public static void nm_jointMaxForce(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTMAXFORCE, value);
    }

    public static void nm_jointMaxVelocity(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTMAXVELOCITY, value);
    }

    public static void nm_parentFrame(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_PARENTFRAME), (long)(value.remaining() * 8));
    }

    public static void nm_parentFrame(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_PARENTFRAME + Checks.check((int)index, (int)7) * 8L, value);
    }

    public static void nm_childFrame(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_CHILDFRAME), (long)(value.remaining() * 8));
    }

    public static void nm_childFrame(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_CHILDFRAME + Checks.check((int)index, (int)7) * 8L, value);
    }

    public static void nm_jointAxis(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_JOINTAXIS), (long)(value.remaining() * 8));
    }

    public static void nm_jointAxis(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_JOINTAXIS + Checks.check((int)index, (int)3) * 8L, value);
    }

    public static void nm_parentIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_PARENTINDEX, value);
    }

    public static void nm_qSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_QSIZE, value);
    }

    public static void nm_uSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_USIZE, value);
    }

    static {
        Struct.Layout layout = B3JointInfo.__struct((Struct.Member[])new Struct.Member[]{B3JointInfo.__array((int)1, (int)1024), B3JointInfo.__array((int)1, (int)1024), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4), B3JointInfo.__member((int)8), B3JointInfo.__member((int)8), B3JointInfo.__member((int)8), B3JointInfo.__member((int)8), B3JointInfo.__member((int)8), B3JointInfo.__member((int)8), B3JointInfo.__array((int)8, (int)7), B3JointInfo.__array((int)8, (int)7), B3JointInfo.__array((int)8, (int)3), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4), B3JointInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_LINKNAME = layout.offsetof(0);
        M_JOINTNAME = layout.offsetof(1);
        M_JOINTTYPE = layout.offsetof(2);
        M_QINDEX = layout.offsetof(3);
        M_UINDEX = layout.offsetof(4);
        M_JOINTINDEX = layout.offsetof(5);
        M_FLAGS = layout.offsetof(6);
        M_JOINTDAMPING = layout.offsetof(7);
        M_JOINTFRICTION = layout.offsetof(8);
        M_JOINTLOWERLIMIT = layout.offsetof(9);
        M_JOINTUPPERLIMIT = layout.offsetof(10);
        M_JOINTMAXFORCE = layout.offsetof(11);
        M_JOINTMAXVELOCITY = layout.offsetof(12);
        M_PARENTFRAME = layout.offsetof(13);
        M_CHILDFRAME = layout.offsetof(14);
        M_JOINTAXIS = layout.offsetof(15);
        M_PARENTINDEX = layout.offsetof(16);
        M_QSIZE = layout.offsetof(17);
        M_USIZE = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<B3JointInfo, Buffer>
    implements NativeResource {
        private static final B3JointInfo ELEMENT_FACTORY = B3JointInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3JointInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[1024]")
        public ByteBuffer m_linkName() {
            return B3JointInfo.nm_linkName(this.address());
        }

        @NativeType(value="char[1024]")
        public String m_linkNameString() {
            return B3JointInfo.nm_linkNameString(this.address());
        }

        @NativeType(value="char[1024]")
        public ByteBuffer m_jointName() {
            return B3JointInfo.nm_jointName(this.address());
        }

        @NativeType(value="char[1024]")
        public String m_jointNameString() {
            return B3JointInfo.nm_jointNameString(this.address());
        }

        public int m_jointType() {
            return B3JointInfo.nm_jointType(this.address());
        }

        public int m_qIndex() {
            return B3JointInfo.nm_qIndex(this.address());
        }

        public int m_uIndex() {
            return B3JointInfo.nm_uIndex(this.address());
        }

        public int m_jointIndex() {
            return B3JointInfo.nm_jointIndex(this.address());
        }

        public int m_flags() {
            return B3JointInfo.nm_flags(this.address());
        }

        public double m_jointDamping() {
            return B3JointInfo.nm_jointDamping(this.address());
        }

        public double m_jointFriction() {
            return B3JointInfo.nm_jointFriction(this.address());
        }

        public double m_jointLowerLimit() {
            return B3JointInfo.nm_jointLowerLimit(this.address());
        }

        public double m_jointUpperLimit() {
            return B3JointInfo.nm_jointUpperLimit(this.address());
        }

        public double m_jointMaxForce() {
            return B3JointInfo.nm_jointMaxForce(this.address());
        }

        public double m_jointMaxVelocity() {
            return B3JointInfo.nm_jointMaxVelocity(this.address());
        }

        @NativeType(value="double[7]")
        public DoubleBuffer m_parentFrame() {
            return B3JointInfo.nm_parentFrame(this.address());
        }

        public double m_parentFrame(int index) {
            return B3JointInfo.nm_parentFrame(this.address(), index);
        }

        @NativeType(value="double[7]")
        public DoubleBuffer m_childFrame() {
            return B3JointInfo.nm_childFrame(this.address());
        }

        public double m_childFrame(int index) {
            return B3JointInfo.nm_childFrame(this.address(), index);
        }

        @NativeType(value="double[3]")
        public DoubleBuffer m_jointAxis() {
            return B3JointInfo.nm_jointAxis(this.address());
        }

        public double m_jointAxis(int index) {
            return B3JointInfo.nm_jointAxis(this.address(), index);
        }

        public int m_parentIndex() {
            return B3JointInfo.nm_parentIndex(this.address());
        }

        public int m_qSize() {
            return B3JointInfo.nm_qSize(this.address());
        }

        public int m_uSize() {
            return B3JointInfo.nm_uSize(this.address());
        }

        public Buffer m_linkName(@NativeType(value="char[1024]") ByteBuffer value) {
            B3JointInfo.nm_linkName(this.address(), value);
            return this;
        }

        public Buffer m_jointName(@NativeType(value="char[1024]") ByteBuffer value) {
            B3JointInfo.nm_jointName(this.address(), value);
            return this;
        }

        public Buffer m_jointType(int value) {
            B3JointInfo.nm_jointType(this.address(), value);
            return this;
        }

        public Buffer m_qIndex(int value) {
            B3JointInfo.nm_qIndex(this.address(), value);
            return this;
        }

        public Buffer m_uIndex(int value) {
            B3JointInfo.nm_uIndex(this.address(), value);
            return this;
        }

        public Buffer m_jointIndex(int value) {
            B3JointInfo.nm_jointIndex(this.address(), value);
            return this;
        }

        public Buffer m_flags(int value) {
            B3JointInfo.nm_flags(this.address(), value);
            return this;
        }

        public Buffer m_jointDamping(double value) {
            B3JointInfo.nm_jointDamping(this.address(), value);
            return this;
        }

        public Buffer m_jointFriction(double value) {
            B3JointInfo.nm_jointFriction(this.address(), value);
            return this;
        }

        public Buffer m_jointLowerLimit(double value) {
            B3JointInfo.nm_jointLowerLimit(this.address(), value);
            return this;
        }

        public Buffer m_jointUpperLimit(double value) {
            B3JointInfo.nm_jointUpperLimit(this.address(), value);
            return this;
        }

        public Buffer m_jointMaxForce(double value) {
            B3JointInfo.nm_jointMaxForce(this.address(), value);
            return this;
        }

        public Buffer m_jointMaxVelocity(double value) {
            B3JointInfo.nm_jointMaxVelocity(this.address(), value);
            return this;
        }

        public Buffer m_parentFrame(@NativeType(value="double[7]") DoubleBuffer value) {
            B3JointInfo.nm_parentFrame(this.address(), value);
            return this;
        }

        public Buffer m_parentFrame(int index, double value) {
            B3JointInfo.nm_parentFrame(this.address(), index, value);
            return this;
        }

        public Buffer m_childFrame(@NativeType(value="double[7]") DoubleBuffer value) {
            B3JointInfo.nm_childFrame(this.address(), value);
            return this;
        }

        public Buffer m_childFrame(int index, double value) {
            B3JointInfo.nm_childFrame(this.address(), index, value);
            return this;
        }

        public Buffer m_jointAxis(@NativeType(value="double[3]") DoubleBuffer value) {
            B3JointInfo.nm_jointAxis(this.address(), value);
            return this;
        }

        public Buffer m_jointAxis(int index, double value) {
            B3JointInfo.nm_jointAxis(this.address(), index, value);
            return this;
        }

        public Buffer m_parentIndex(int value) {
            B3JointInfo.nm_parentIndex(this.address(), value);
            return this;
        }

        public Buffer m_qSize(int value) {
            B3JointInfo.nm_qSize(this.address(), value);
            return this;
        }

        public Buffer m_uSize(int value) {
            B3JointInfo.nm_uSize(this.address(), value);
            return this;
        }
    }
}

