/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;

    public VkBufferMemoryBarrier(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferMemoryBarrier.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferMemoryBarrier.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferMemoryBarrier.npNext(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkBufferMemoryBarrier.ndstAccessMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcQueueFamilyIndex() {
        return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstQueueFamilyIndex() {
        return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferMemoryBarrier.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkBufferMemoryBarrier.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferMemoryBarrier.nsize(this.address());
    }

    public VkBufferMemoryBarrier sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryBarrier.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier offset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier.noffset(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier.nsize(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long buffer, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkBufferMemoryBarrier set(VkBufferMemoryBarrier src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferMemoryBarrier malloc() {
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferMemoryBarrier calloc() {
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferMemoryBarrier create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferMemoryBarrier create(long address) {
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)address);
    }

    @Nullable
    public static VkBufferMemoryBarrier createSafe(long address) {
        return address == 0L ? null : (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferMemoryBarrier.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferMemoryBarrier.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferMemoryBarrier mallocStack() {
        return VkBufferMemoryBarrier.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryBarrier callocStack() {
        return VkBufferMemoryBarrier.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferMemoryBarrier mallocStack(MemoryStack stack) {
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferMemoryBarrier callocStack(MemoryStack stack) {
        return (VkBufferMemoryBarrier)VkBufferMemoryBarrier.wrap(VkBufferMemoryBarrier.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryBarrier.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryBarrier.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferMemoryBarrier.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsrcAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTACCESSMASK);
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCQUEUEFAMILYINDEX);
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTQUEUEFAMILYINDEX);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTACCESSMASK, value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCQUEUEFAMILYINDEX, value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTQUEUEFAMILYINDEX, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferMemoryBarrier.__struct((Struct.Member[])new Struct.Member[]{VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)POINTER_SIZE), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)8), VkBufferMemoryBarrier.__member((int)8), VkBufferMemoryBarrier.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
        SRCQUEUEFAMILYINDEX = layout.offsetof(4);
        DSTQUEUEFAMILYINDEX = layout.offsetof(5);
        BUFFER = layout.offsetof(6);
        OFFSET = layout.offsetof(7);
        SIZE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBufferMemoryBarrier, Buffer>
    implements NativeResource {
        private static final VkBufferMemoryBarrier ELEMENT_FACTORY = VkBufferMemoryBarrier.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferMemoryBarrier getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferMemoryBarrier.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferMemoryBarrier.npNext(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkBufferMemoryBarrier.ndstAccessMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcQueueFamilyIndex() {
            return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstQueueFamilyIndex() {
            return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferMemoryBarrier.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkBufferMemoryBarrier.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferMemoryBarrier.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryBarrier.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier.nsize(this.address(), value);
            return this;
        }
    }
}

