/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SpvcCombinedImageSampler
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMBINED_ID;
    public static final int IMAGE_ID;
    public static final int SAMPLER_ID;

    public SpvcCombinedImageSampler(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcCombinedImageSampler.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_variable_id")
    public int combined_id() {
        return SpvcCombinedImageSampler.ncombined_id(this.address());
    }

    @NativeType(value="spvc_variable_id")
    public int image_id() {
        return SpvcCombinedImageSampler.nimage_id(this.address());
    }

    @NativeType(value="spvc_variable_id")
    public int sampler_id() {
        return SpvcCombinedImageSampler.nsampler_id(this.address());
    }

    public SpvcCombinedImageSampler combined_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.ncombined_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler image_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.nimage_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler sampler_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.nsampler_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler set(int combined_id, int image_id, int sampler_id) {
        this.combined_id(combined_id);
        this.image_id(image_id);
        this.sampler_id(sampler_id);
        return this;
    }

    public SpvcCombinedImageSampler set(SpvcCombinedImageSampler src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcCombinedImageSampler malloc() {
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcCombinedImageSampler calloc() {
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcCombinedImageSampler create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcCombinedImageSampler create(long address) {
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)address);
    }

    @Nullable
    public static SpvcCombinedImageSampler createSafe(long address) {
        return address == 0L ? null : (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcCombinedImageSampler.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcCombinedImageSampler.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcCombinedImageSampler mallocStack() {
        return SpvcCombinedImageSampler.mallocStack(MemoryStack.stackGet());
    }

    public static SpvcCombinedImageSampler callocStack() {
        return SpvcCombinedImageSampler.callocStack(MemoryStack.stackGet());
    }

    public static SpvcCombinedImageSampler mallocStack(MemoryStack stack) {
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcCombinedImageSampler callocStack(MemoryStack stack) {
        return (SpvcCombinedImageSampler)SpvcCombinedImageSampler.wrap(SpvcCombinedImageSampler.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SpvcCombinedImageSampler.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SpvcCombinedImageSampler.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)SpvcCombinedImageSampler.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ncombined_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMBINED_ID);
    }

    public static int nimage_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGE_ID);
    }

    public static int nsampler_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLER_ID);
    }

    public static void ncombined_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMBINED_ID, value);
    }

    public static void nimage_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGE_ID, value);
    }

    public static void nsampler_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLER_ID, value);
    }

    static {
        Struct.Layout layout = SpvcCombinedImageSampler.__struct((Struct.Member[])new Struct.Member[]{SpvcCombinedImageSampler.__member((int)4), SpvcCombinedImageSampler.__member((int)4), SpvcCombinedImageSampler.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMBINED_ID = layout.offsetof(0);
        IMAGE_ID = layout.offsetof(1);
        SAMPLER_ID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcCombinedImageSampler, Buffer>
    implements NativeResource {
        private static final SpvcCombinedImageSampler ELEMENT_FACTORY = SpvcCombinedImageSampler.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcCombinedImageSampler getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_variable_id")
        public int combined_id() {
            return SpvcCombinedImageSampler.ncombined_id(this.address());
        }

        @NativeType(value="spvc_variable_id")
        public int image_id() {
            return SpvcCombinedImageSampler.nimage_id(this.address());
        }

        @NativeType(value="spvc_variable_id")
        public int sampler_id() {
            return SpvcCombinedImageSampler.nsampler_id(this.address());
        }

        public Buffer combined_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.ncombined_id(this.address(), value);
            return this;
        }

        public Buffer image_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.nimage_id(this.address(), value);
            return this;
        }

        public Buffer sampler_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.nsampler_id(this.address(), value);
            return this;
        }
    }
}

