/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import javax.swing.text.Segment;
import processing.app.syntax.KeywordMap;
import processing.app.syntax.TokenMarker;

public class CTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords = new KeywordMap(false){
        {
            this.add("char", (byte)8);
            this.add("double", (byte)8);
            this.add("enum", (byte)8);
            this.add("float", (byte)8);
            this.add("int", (byte)8);
            this.add("long", (byte)8);
            this.add("short", (byte)8);
            this.add("signed", (byte)8);
            this.add("struct", (byte)8);
            this.add("typedef", (byte)8);
            this.add("union", (byte)8);
            this.add("unsigned", (byte)8);
            this.add("void", (byte)8);
            this.add("auto", (byte)6);
            this.add("const", (byte)6);
            this.add("extern", (byte)6);
            this.add("register", (byte)6);
            this.add("static", (byte)6);
            this.add("volatile", (byte)6);
            this.add("break", (byte)6);
            this.add("case", (byte)6);
            this.add("continue", (byte)6);
            this.add("default", (byte)6);
            this.add("do", (byte)6);
            this.add("else", (byte)6);
            this.add("for", (byte)6);
            this.add("goto", (byte)6);
            this.add("if", (byte)6);
            this.add("return", (byte)6);
            this.add("sizeof", (byte)6);
            this.add("switch", (byte)6);
            this.add("while", (byte)6);
            this.add("asm", (byte)7);
            this.add("asmlinkage", (byte)7);
            this.add("far", (byte)7);
            this.add("huge", (byte)7);
            this.add("inline", (byte)7);
            this.add("near", (byte)7);
            this.add("pascal", (byte)7);
            this.add("true", (byte)4);
            this.add("false", (byte)4);
            this.add("NULL", (byte)4);
        }
    };
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public CTokenMarker() {
        this(true, CTokenMarker.getKeywords());
    }

    public CTokenMarker(boolean cpp, KeywordMap keywords) {
        this.cpp = cpp;
        this.keywords = keywords;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int mlength = line.count + offset;
        boolean backslash = false;
        block21: for (int i = offset; i < mlength; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp || this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(mlength - i, (byte)7);
                            this.lastOffset = this.lastKeyword = mlength;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) break;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (mlength - i <= 1) break;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (mlength - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(mlength - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = mlength;
                                    break block21;
                                }
                            }
                            ++i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') break;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || mlength - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, mlength, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(mlength - this.lastOffset, (byte)10);
                return 0;
            }
            case 7: {
                this.addToken(mlength - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
                this.addToken(mlength - this.lastOffset, token);
                return token;
            }
        }
        this.addToken(mlength - this.lastOffset, token);
        return token;
    }

    public static KeywordMap getKeywords() {
        return cKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

