# Contributing to Bundler

Welcome to Bundler! We are so happy that you're here. We know it can be daunting to joining a new open source project, so here's a quick overview of what you can expect from this documentation.

*Something missing?* Send us a [pull request](../development/PULL_REQUESTS.md)!

**Recommended first steps**

- Join us in the Bundler slack! Generate an invite [here](http://slack.bundler.io/)
- *If you're interested in helping with code:*
  - Get a quick overview of our [development process](../development/README.md)
  - [Setup your machine for development](../development/SETUP.md)
  - Checkout [How you can help: your first contributions!](HOW_YOU_CAN_HELP.md) for a list of suggestions to get started
- *If you're interested in helping with documentation:*
  - Read up on [how documentation works for Bundler](../documentation/README.md)
  - Learn about our [documentation vision](../documentation/VISION.md)

You can start learning about Bundler by reading [the documentation](http://bundler.io). If you want, you can also read a (lengthy) explanation of [why Bundler exists and what it does](http://bundler.io/rationale.html).

##[How you can help: your first contributions!](HOW_YOU_CAN_HELP.md)

A detailed overview of how to get started contributing to Bundler, including a long list of suggestions for your first project.

##[Bug triage](BUG_TRIAGE.md)

Want to take a stab at processing issues? Start here.

##[Getting help](GETTING_HELP.md)

How to get in touch with folks who can help when you're stuck. Don't worry! This happens to all of us. We're really nice, we promise.

##[Filing issues](ISSUES.md)

We see a lot of issues in the Bundler repo! Use this guide to file informative, actionable issues.

##[Community](COMMUNITY.md)

Learn more about our goals for the Bundler community and the ways you can help us build better together.
