/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseObjectResource;
import org.traccar.config.Keys;
import org.traccar.database.UsersManager;
import org.traccar.helper.LogAction;
import org.traccar.model.ManagedUser;
import org.traccar.model.User;

@Path(value="users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserResource
extends BaseObjectResource<User> {
    public UserResource() {
        super(User.class);
    }

    @GET
    public Collection<User> get(@QueryParam(value="userId") long userId) throws SQLException {
        Set<Long> result;
        UsersManager usersManager = Context.getUsersManager();
        if (Context.getPermissionsManager().getUserAdmin(this.getUserId())) {
            result = userId != 0L ? usersManager.getUserItems(userId) : usersManager.getAllItems();
        } else if (Context.getPermissionsManager().getUserManager(this.getUserId())) {
            result = usersManager.getManagedItems(this.getUserId());
        } else {
            throw new SecurityException("Admin or manager access required");
        }
        return usersManager.getItems(result);
    }

    @Override
    @PermitAll
    @POST
    public Response add(User entity) throws SQLException {
        if (!Context.getPermissionsManager().getUserAdmin(this.getUserId())) {
            Context.getPermissionsManager().checkUserUpdate(this.getUserId(), new User(), entity);
            if (Context.getPermissionsManager().getUserManager(this.getUserId())) {
                Context.getPermissionsManager().checkUserLimit(this.getUserId());
            } else {
                Context.getPermissionsManager().checkRegistration(this.getUserId());
                entity.setDeviceLimit(Context.getConfig().getInteger(Keys.USERS_DEFAULT_DEVICE_LIMIT));
                int expirationDays = Context.getConfig().getInteger(Keys.USERS_DEFAULT_EXPIRATION_DAYS);
                if (expirationDays > 0) {
                    entity.setExpirationTime(new Date(System.currentTimeMillis() + (long)expirationDays * 24L * 3600L * 1000L));
                }
            }
        }
        Context.getUsersManager().addItem(entity);
        LogAction.create(this.getUserId(), entity);
        if (Context.getPermissionsManager().getUserManager(this.getUserId())) {
            Context.getDataManager().linkObject(User.class, this.getUserId(), ManagedUser.class, entity.getId(), true);
            LogAction.link(this.getUserId(), User.class, this.getUserId(), ManagedUser.class, entity.getId());
        }
        Context.getUsersManager().refreshUserItems();
        return Response.ok((Object)entity).build();
    }
}

