/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static int indexOf(String needle, ByteBuf haystack) {
        return BufferUtil.indexOf(needle, haystack, haystack.readerIndex(), haystack.writerIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOf(String needle, ByteBuf haystack, int startIndex, int endIndex) {
        ByteBuf wrappedNeedle = Unpooled.wrappedBuffer((byte[])needle.getBytes(StandardCharsets.US_ASCII));
        try {
            int n = BufferUtil.indexOf(wrappedNeedle, haystack, startIndex, endIndex);
            return n;
        }
        finally {
            wrappedNeedle.release();
        }
    }

    public static int indexOf(ByteBuf needle, ByteBuf haystack, int startIndex, int endIndex) {
        ByteBuf wrappedHaystack;
        if (startIndex == haystack.readerIndex() && endIndex == haystack.writerIndex()) {
            wrappedHaystack = haystack;
        } else {
            wrappedHaystack = Unpooled.wrappedBuffer((ByteBuf)haystack);
            wrappedHaystack.readerIndex(startIndex - haystack.readerIndex());
            wrappedHaystack.writerIndex(endIndex - haystack.readerIndex());
        }
        int result = ByteBufUtil.indexOf((ByteBuf)needle, (ByteBuf)wrappedHaystack);
        return result < 0 ? result : haystack.readerIndex() + startIndex + result;
    }
}

