/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistClass;
import org.elasticsearch.painless.spi.WhitelistClassBinding;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistMethod;
import org.elasticsearch.painless.spi.annotation.WhitelistAnnotationParser;

public final class WhitelistLoader {
    public static Whitelist loadFromResourceFiles(Class<?> resource, String ... filepaths) {
        return WhitelistLoader.loadFromResourceFiles(resource, WhitelistAnnotationParser.BASE_ANNOTATION_PARSERS, filepaths);
    }

    public static Whitelist loadFromResourceFiles(Class<?> resource, Map<String, WhitelistAnnotationParser> parsers, String ... filepaths) {
        ArrayList<WhitelistClass> whitelistClasses = new ArrayList<WhitelistClass>();
        ArrayList<WhitelistMethod> whitelistStatics = new ArrayList<WhitelistMethod>();
        ArrayList<WhitelistClassBinding> whitelistClassBindings = new ArrayList<WhitelistClassBinding>();
        for (String filepath : filepaths) {
            int number = -1;
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(resource.getResourceAsStream(filepath), StandardCharsets.UTF_8));){
                String line;
                String parseType = null;
                String whitelistClassOrigin = null;
                String javaClassName = null;
                ArrayList<WhitelistConstructor> whitelistConstructors = null;
                ArrayList<WhitelistMethod> whitelistMethods = null;
                ArrayList<WhitelistField> whitelistFields = null;
                List<Object> classAnnotations = null;
                while ((line = reader.readLine()) != null) {
                    String methodName;
                    int parameterStartIndex;
                    number = reader.getLineNumber();
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    if (line.startsWith("class ")) {
                        if (!line.endsWith("{")) {
                            throw new IllegalArgumentException("invalid class definition: failed to parse class opening bracket [" + line + "]");
                        }
                        if (parseType != null) {
                            throw new IllegalArgumentException("invalid definition: cannot embed class definition [" + line + "]");
                        }
                        int annotationIndex = line.indexOf(64);
                        if (annotationIndex == -1) {
                            annotationIndex = line.length() - 1;
                            classAnnotations = Collections.emptyList();
                        } else {
                            classAnnotations = WhitelistLoader.parseWhitelistAnnotations(parsers, line.substring(annotationIndex, line.length() - 1));
                        }
                        parseType = "class";
                        whitelistClassOrigin = "[" + filepath + "]:[" + number + "]";
                        javaClassName = line.substring(5, annotationIndex).trim();
                        whitelistConstructors = new ArrayList<WhitelistConstructor>();
                        whitelistMethods = new ArrayList<WhitelistMethod>();
                        whitelistFields = new ArrayList<WhitelistField>();
                        continue;
                    }
                    if (line.startsWith("static_import ")) {
                        if (!line.endsWith("{")) {
                            throw new IllegalArgumentException("invalid static import definition: failed to parse static import opening bracket [" + line + "]");
                        }
                        if (parseType != null) {
                            throw new IllegalArgumentException("invalid definition: cannot embed static import definition [" + line + "]");
                        }
                        parseType = "static_import";
                        continue;
                    }
                    if (line.equals("}")) {
                        if (parseType == null) {
                            throw new IllegalArgumentException("invalid definition: extraneous closing bracket");
                        }
                        if ("class".equals(parseType)) {
                            whitelistClasses.add(new WhitelistClass(whitelistClassOrigin, javaClassName, whitelistConstructors, whitelistMethods, whitelistFields, classAnnotations));
                            whitelistClassOrigin = null;
                            javaClassName = null;
                            whitelistConstructors = null;
                            whitelistMethods = null;
                            whitelistFields = null;
                            classAnnotations = null;
                        }
                        parseType = null;
                        continue;
                    }
                    if ("static_import".equals(parseType)) {
                        List<Object> annotations;
                        int annotationIndex;
                        String origin = "[" + filepath + "]:[" + number + "]";
                        parameterStartIndex = line.indexOf(40);
                        if (parameterStartIndex == -1) {
                            throw new IllegalArgumentException("illegal static import definition: start of method parameters not found [" + line + "]");
                        }
                        String[] tokens = line.substring(0, parameterStartIndex).trim().split("\\s+");
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("invalid method definition: unexpected format [" + line + "]");
                        }
                        methodName = tokens[1];
                        String returnCanonicalTypeName = tokens[0];
                        int parameterEndIndex = line.indexOf(41);
                        if (parameterEndIndex == -1) {
                            throw new IllegalArgumentException("illegal static import definition: end of method parameters not found [" + line + "]");
                        }
                        String[] canonicalTypeNameParameters = line.substring(parameterStartIndex + 1, parameterEndIndex).replaceAll("\\s+", "").split(",");
                        if ("".equals(canonicalTypeNameParameters[0])) {
                            canonicalTypeNameParameters = new String[]{};
                        }
                        if ((annotationIndex = line.indexOf(64)) == -1) {
                            annotationIndex = line.length();
                            annotations = Collections.emptyList();
                        } else {
                            annotations = WhitelistLoader.parseWhitelistAnnotations(parsers, line.substring(annotationIndex));
                        }
                        tokens = line.substring(parameterEndIndex + 1, annotationIndex).trim().split("\\s+");
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("invalid static import definition: unexpected format [" + line + "]");
                        }
                        String staticImportType = tokens[0];
                        String targetJavaClassName = tokens[1];
                        if ("from_class".equals(staticImportType)) {
                            whitelistStatics.add(new WhitelistMethod(origin, targetJavaClassName, methodName, returnCanonicalTypeName, Arrays.asList(canonicalTypeNameParameters), annotations));
                            continue;
                        }
                        if ("bound_to".equals(staticImportType)) {
                            whitelistClassBindings.add(new WhitelistClassBinding(origin, targetJavaClassName, methodName, returnCanonicalTypeName, Arrays.asList(canonicalTypeNameParameters), annotations));
                            continue;
                        }
                        throw new IllegalArgumentException("invalid static import definition: unexpected static import type [" + staticImportType + "] [" + line + "]");
                    }
                    if ("class".equals(parseType)) {
                        List<Object> annotations;
                        String origin = "[" + filepath + "]:[" + number + "]";
                        if (line.startsWith("(")) {
                            int annotationIndex;
                            int parameterEndIndex = line.indexOf(41);
                            if (parameterEndIndex == -1) {
                                throw new IllegalArgumentException("illegal constructor definition: end of constructor parameters not found [" + line + "]");
                            }
                            String[] canonicalTypeNameParameters = line.substring(1, parameterEndIndex).replaceAll("\\s+", "").split(",");
                            if ("".equals(canonicalTypeNameParameters[0])) {
                                canonicalTypeNameParameters = new String[]{};
                            }
                            List<Object> annotations2 = (annotationIndex = line.indexOf(64)) == -1 ? Collections.emptyList() : WhitelistLoader.parseWhitelistAnnotations(parsers, line.substring(annotationIndex));
                            whitelistConstructors.add(new WhitelistConstructor(origin, Arrays.asList(canonicalTypeNameParameters), annotations2));
                            continue;
                        }
                        if (line.contains("(")) {
                            int annotationIndex;
                            String javaAugmentedClassName;
                            parameterStartIndex = line.indexOf(40);
                            String[] tokens = line.substring(0, parameterStartIndex).trim().split("\\s+");
                            if (tokens.length == 2) {
                                methodName = tokens[1];
                                javaAugmentedClassName = null;
                            } else if (tokens.length == 3) {
                                methodName = tokens[2];
                                javaAugmentedClassName = tokens[1];
                            } else {
                                throw new IllegalArgumentException("invalid method definition: unexpected format [" + line + "]");
                            }
                            String returnCanonicalTypeName = tokens[0];
                            int parameterEndIndex = line.indexOf(41);
                            if (parameterEndIndex == -1) {
                                throw new IllegalArgumentException("illegal static import definition: end of method parameters not found [" + line + "]");
                            }
                            String[] canonicalTypeNameParameters = line.substring(parameterStartIndex + 1, parameterEndIndex).replaceAll("\\s+", "").split(",");
                            if ("".equals(canonicalTypeNameParameters[0])) {
                                canonicalTypeNameParameters = new String[]{};
                            }
                            List<Object> annotations3 = (annotationIndex = line.indexOf(64)) == -1 ? Collections.emptyList() : WhitelistLoader.parseWhitelistAnnotations(parsers, line.substring(annotationIndex));
                            whitelistMethods.add(new WhitelistMethod(origin, javaAugmentedClassName, methodName, returnCanonicalTypeName, Arrays.asList(canonicalTypeNameParameters), annotations3));
                            continue;
                        }
                        int annotationIndex = line.indexOf(64);
                        if (annotationIndex == -1) {
                            annotationIndex = line.length();
                            annotations = Collections.emptyList();
                        } else {
                            annotations = WhitelistLoader.parseWhitelistAnnotations(parsers, line.substring(annotationIndex));
                        }
                        String[] tokens = line.substring(0, annotationIndex).split("\\s+");
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("invalid field definition: unexpected format [" + line + "]");
                        }
                        whitelistFields.add(new WhitelistField(origin, tokens[1], tokens[0], annotations));
                        continue;
                    }
                    throw new IllegalArgumentException("invalid definition: unable to parse line [" + line + "]");
                }
                if (javaClassName == null) continue;
                throw new IllegalArgumentException("invalid definition: expected closing bracket");
            }
            catch (Exception exception) {
                throw new RuntimeException("error in [" + filepath + "] at line [" + number + "]", exception);
            }
        }
        ClassLoader loader = AccessController.doPrivileged(resource::getClassLoader);
        return new Whitelist(loader, whitelistClasses, whitelistStatics, whitelistClassBindings, Collections.emptyList());
    }

    private static List<Object> parseWhitelistAnnotations(Map<String, WhitelistAnnotationParser> parsers, String line) {
        List<Object> annotations;
        if ("".equals(line.replaceAll("\\s+", ""))) {
            annotations = Collections.emptyList();
        } else {
            if ((line = line.trim()).charAt(0) != '@') {
                throw new IllegalArgumentException("invalid annotation: expected at symbol [" + line + "]");
            }
            if (line.length() < 2) {
                throw new IllegalArgumentException("invalid annotation: expected name [" + line + "]");
            }
            String[] annotationStrings = line.substring(1).split("@");
            annotations = new ArrayList<Object>(annotationStrings.length);
            for (String annotationString : annotationStrings) {
                Map<String, String> arguments;
                String name;
                int index = (annotationString = annotationString.trim()).indexOf(91);
                if (index == -1) {
                    name = annotationString;
                    arguments = Collections.emptyMap();
                } else {
                    String[] argumentsStrings;
                    if (annotationString.charAt(annotationString.length() - 1) != ']') {
                        throw new IllegalArgumentException("invalid annotation: expected closing brace [" + line + "]");
                    }
                    name = annotationString.substring(0, index);
                    arguments = new HashMap<String, String>();
                    for (String argumentString : argumentsStrings = annotationString.substring(index + 1, annotationString.length() - 1).split(",")) {
                        String[] argumentKeyValue = argumentString.split("=");
                        if (argumentKeyValue.length != 2) {
                            throw new IllegalArgumentException("invalid annotation: expected key=\"value\" [" + line + "]");
                        }
                        String argumentKey = argumentKeyValue[0].trim();
                        if (argumentKey.isEmpty()) {
                            throw new IllegalArgumentException("invalid annotation: expected key=\"value\" [" + line + "]");
                        }
                        String argumentValue = argumentKeyValue[1];
                        if (argumentValue.length() < 3 || argumentValue.charAt(0) != '\"' || argumentValue.charAt(argumentValue.length() - 1) != '\"') {
                            throw new IllegalArgumentException("invalid annotation: expected key=\"value\" [" + line + "]");
                        }
                        argumentValue = argumentValue.substring(1, argumentValue.length() - 1);
                        arguments.put(argumentKey, argumentValue);
                    }
                }
                WhitelistAnnotationParser parser = parsers.get(name);
                if (parser == null) {
                    throw new IllegalArgumentException("invalid annotation: parser not found for [" + name + "] [" + line + "]");
                }
                annotations.add(parser.parse(arguments));
            }
        }
        return annotations;
    }

    private WhitelistLoader() {
    }
}

