/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.util.InternalSocket;
import net.i2p.util.TimeoutPipedInputStream;
import net.i2p.util.TimeoutPipedOutputStream;

public class InternalServerSocket
extends ServerSocket {
    private static final ConcurrentHashMap<Integer, InternalServerSocket> _sockets = new ConcurrentHashMap(4);
    private final BlockingQueue<InternalSocket> _acceptQueue;
    private final Integer _port;
    private volatile boolean _running;

    public InternalServerSocket(int port) throws IOException {
        if (port <= 0) {
            throw new IOException("Bad port: " + port);
        }
        this._port = port;
        InternalServerSocket previous = _sockets.putIfAbsent(this._port, this);
        if (previous != null) {
            throw new IOException("Internal port in use: " + port);
        }
        this._running = true;
        this._acceptQueue = new LinkedBlockingQueue<InternalSocket>();
    }

    @Override
    public void close() {
        this._running = false;
        _sockets.remove(this._port);
        this._acceptQueue.clear();
        try {
            this._acceptQueue.put(new InternalSocket(null, null));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Socket accept() throws IOException {
        InternalSocket serverSock = null;
        if (this._running) {
            try {
                serverSock = this._acceptQueue.take();
            }
            catch (InterruptedException ie) {
                if (this._running) {
                    throw new InterruptedIOException();
                }
                throw new IOException("closed");
            }
            if (serverSock.getInputStream() == null) {
                throw new IOException("closed");
            }
        }
        return serverSock;
    }

    @Override
    public String toString() {
        return "Internal server socket on port " + this._port;
    }

    static void internalConnect(int port, InternalSocket clientSock) throws IOException {
        InternalServerSocket iss = _sockets.get(port);
        if (iss == null) {
            throw new IOException("No server for port: " + port);
        }
        TimeoutPipedInputStream cis = new TimeoutPipedInputStream(65536);
        TimeoutPipedInputStream sis = new TimeoutPipedInputStream(65536);
        TimeoutPipedOutputStream cos = new TimeoutPipedOutputStream(sis);
        TimeoutPipedOutputStream sos = new TimeoutPipedOutputStream(cis);
        clientSock.setInputStream(cis);
        clientSock.setOutputStream(cos);
        iss.queueConnection(new InternalSocket(sis, sos));
    }

    private void queueConnection(InternalSocket sock) throws IOException {
        if (!this._running) {
            throw new IOException("Server closed for port: " + this._port);
        }
        try {
            this._acceptQueue.put(sock);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int getLocalPort() {
        return this._port;
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public int getSoTimeout() {
        return 0;
    }

    @Override
    @Deprecated
    public void bind(SocketAddress endpoint) {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    @Deprecated
    public void bind(SocketAddress endpoint, int backlog) {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    public ServerSocketChannel getChannel() {
        return null;
    }

    @Override
    @Deprecated
    public InetAddress getInetAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    @Deprecated
    public SocketAddress getLocalSocketAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    @Deprecated
    public int getReceiveBufferSize() {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    @Deprecated
    public boolean getReuseAddress() {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return !this._running;
    }

    @Override
    @Deprecated
    public void setReceiveBufferSize(int size) {
        throw new IllegalArgumentException("unsupported");
    }

    @Override
    @Deprecated
    public void setReuseAddress(boolean on) {
        throw new IllegalArgumentException("unsupported");
    }

    public static void renderStatusHTML(Writer out) throws IOException {
        out.write("<h2 id=\"debug_portmapper\">Internal Server Sockets</h2><table id=\"portmapper\"><tr><th>Port\n");
        ArrayList ports = new ArrayList(_sockets.keySet());
        Collections.sort(ports);
        for (Integer i : ports) {
            out.write("<tr><td>" + i + '\n');
        }
        out.write("</table>\n");
    }
}

