/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AutomatonTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.SortedDocValuesTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class SortedDocValues
extends BinaryDocValues {
    private final BytesRef empty = new BytesRef();

    protected SortedDocValues() {
    }

    public abstract int ordValue() throws IOException;

    public abstract BytesRef lookupOrd(int var1) throws IOException;

    @Override
    public BytesRef binaryValue() throws IOException {
        int ord = this.ordValue();
        if (ord == -1) {
            return this.empty;
        }
        return this.lookupOrd(ord);
    }

    public abstract int getValueCount();

    public int lookupTerm(BytesRef key) throws IOException {
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public TermsEnum termsEnum() throws IOException {
        return new SortedDocValuesTermsEnum(this);
    }

    public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
        TermsEnum in = this.termsEnum();
        switch (automaton.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return in;
            }
            case SINGLE: {
                return new SingleTermsEnum(in, automaton.term);
            }
            case NORMAL: {
                return new AutomatonTermsEnum(in, automaton);
            }
        }
        throw new RuntimeException("unhandled case");
    }
}

