/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;

class ValueEqualFunction
extends BooleanValue.AbstractBooleanValue {
    private final AnalyticsValue exprA;
    private final AnalyticsValue exprB;
    public static final String name = "equal";
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public ValueEqualFunction(AnalyticsValue exprA, AnalyticsValue exprB) {
        this.exprA = exprA;
        this.exprB = exprB;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
    }

    @Override
    public boolean getBoolean() {
        Object valueA = this.exprA.getObject();
        Object valueB = this.exprB.getObject();
        this.exists = this.exprA.exists() && this.exprB.exists();
        return this.exists ? valueA.equals(valueB) : false;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

