/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.HubRegisterResponse;
import liquibase.hub.model.HubUser;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationChangeEvent;
import liquibase.hub.model.OperationEvent;
import liquibase.hub.model.Organization;
import liquibase.hub.model.Project;

public class MockHubService
implements HubService {
    public static UUID randomUUID;
    public static UUID deletedUUID;
    public static UUID alreadyRegisteredUUID;
    public static UUID failUUID;
    public static UUID notFoundChangeLogUUID;
    public static Date operationCreateDate;
    public List<Project> returnProjects = new ArrayList<Project>();
    public List<Connection> returnConnections;
    public List<HubChangeLog> returnChangeLogs = new ArrayList<HubChangeLog>();
    public SortedMap<String, List> sentObjects = new TreeMap<String, List>();
    public boolean online = true;

    @Override
    public int getPriority() {
        return -1;
    }

    public MockHubService() {
        this.reset();
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public HubUser getMe() throws LiquibaseHubException {
        return null;
    }

    @Override
    public Organization getOrganization() throws LiquibaseHubException {
        return null;
    }

    @Override
    public Project createProject(Project project) {
        return new Project().setName("Project 1");
    }

    @Override
    public HubChangeLog createChangeLog(HubChangeLog hubChangeLog) throws LiquibaseException {
        if (randomUUID == null) {
            randomUUID = UUID.randomUUID();
        }
        hubChangeLog.setId(randomUUID);
        return hubChangeLog;
    }

    @Override
    public List<Project> getProjects() throws LiquibaseHubException {
        Project project1 = new Project();
        project1.setId(UUID.fromString("72e4bc5a-5404-45be-b9e1-280a80c98cbf"));
        project1.setName("Project 1");
        project1.setCreateDate(new Date());
        Project project2 = new Project();
        project2.setId(UUID.randomUUID());
        project2.setName("Project 2");
        project2.setCreateDate(new Date());
        return Arrays.asList(project1, project2);
    }

    @Override
    public Project getProject(UUID projectId) throws LiquibaseHubException {
        if (projectId.equals(failUUID)) {
            return null;
        }
        Project project1 = new Project();
        project1.setId(projectId);
        project1.setName("Project 1");
        project1.setCreateDate(new Date());
        return project1;
    }

    @Override
    public Project findProjectByConnectionIdOrJdbcUrl(UUID connectionId, String jdbcUrl) throws LiquibaseHubException {
        return this.returnProjects.get(0);
    }

    @Override
    public HubRegisterResponse register(String email) throws LiquibaseHubException {
        return null;
    }

    @Override
    public HubChangeLog deactivateChangeLog(HubChangeLog hubChangeLog) throws LiquibaseHubException {
        return null;
    }

    @Override
    public void setRanChangeSets(Connection connectionId, List<RanChangeSet> ranChangeSets) throws LiquibaseHubException {
        this.sentObjects.computeIfAbsent("setRanChangeSets/" + connectionId, k2 -> new ArrayList()).addAll(ranChangeSets);
    }

    @Override
    public List<Connection> getConnections(Connection exampleConnection) {
        if (exampleConnection != null && exampleConnection.getId() != null && exampleConnection.getId().equals(failUUID)) {
            return new ArrayList<Connection>();
        }
        return this.returnConnections;
    }

    @Override
    public Connection getConnection(Connection exampleConnection, boolean createIfNotExists) throws LiquibaseHubException {
        return this.returnConnections.get(0);
    }

    @Override
    public Connection createConnection(Connection connection) throws LiquibaseHubException {
        this.sentObjects.computeIfAbsent("createConnection/" + connection.getProject().getId(), k2 -> new ArrayList()).add(connection);
        return new Connection().setId(UUID.randomUUID()).setJdbcUrl(connection.getJdbcUrl());
    }

    @Override
    public HubChangeLog getHubChangeLog(UUID changeLogId) throws LiquibaseHubException {
        return this.getHubChangeLog(changeLogId, "*");
    }

    @Override
    public HubChangeLog getHubChangeLog(UUID changeLogId, String includeStatus) throws LiquibaseHubException {
        for (HubChangeLog changeLog : this.returnChangeLogs) {
            if (!String.valueOf(changeLog.getId()).equals(String.valueOf(changeLogId))) continue;
            return changeLog;
        }
        return null;
    }

    @Override
    public Operation createOperation(String operationType, String operationCommand, HubChangeLog changeLog, Connection connection) throws LiquibaseHubException {
        operationCreateDate = new Date();
        this.sentObjects.computeIfAbsent("startOperation/" + connection.getId(), k2 -> new ArrayList()).add(operationCreateDate);
        return null;
    }

    @Override
    public OperationEvent sendOperationEvent(Operation operation, OperationEvent operationEvent) throws LiquibaseException {
        return null;
    }

    @Override
    public void sendOperationChangeEvent(OperationChangeEvent operationChangeEvent) throws LiquibaseException {
    }

    @Override
    public void sendOperationChanges(OperationChange operationChange) throws LiquibaseHubException {
    }

    @Override
    public String shortenLink(String url) throws LiquibaseException {
        return null;
    }

    public void reset() {
        randomUUID = UUID.randomUUID();
        this.returnProjects = new ArrayList<Project>(Collections.singletonList(new Project().setId(randomUUID).setName("Test project")));
        this.returnConnections = new ArrayList<Connection>(Collections.singletonList(new Connection().setId(randomUUID).setJdbcUrl("jdbc://test").setProject(this.returnProjects.get(0))));
        this.returnChangeLogs = new ArrayList<HubChangeLog>(Collections.singletonList(new HubChangeLog().setId(randomUUID).setName("Mock changelog").setFileName("com/example/test.xml").setProject(this.returnProjects.get(0))));
        HubChangeLog deletedChangeLog = new HubChangeLog().setId(deletedUUID).setName("Deleted changelog").setFileName("com/example/deleted.xml").setProject(this.returnProjects.get(0));
        deletedChangeLog.setStatus("deleted");
        this.returnChangeLogs.add(deletedChangeLog);
        HubChangeLog alreadyRegisteredChangeLog = new HubChangeLog().setId(alreadyRegisteredUUID).setName("Already registered changelog").setFileName("com/example/registered.xml").setProject(this.returnProjects.get(0));
        this.returnChangeLogs.add(alreadyRegisteredChangeLog);
        HubChangeLog notFoundChangeLog = new HubChangeLog().setId(notFoundChangeLogUUID).setName("Already registered changelog").setFileName("com/example/registered.xml").setProject(this.returnProjects.get(0));
        this.returnChangeLogs.add(notFoundChangeLog);
        this.sentObjects = new TreeMap<String, List>();
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        hubServiceFactory.setOfflineReason("HubService is configured to be offline");
        this.online = true;
    }

    static {
        deletedUUID = UUID.randomUUID();
        alreadyRegisteredUUID = UUID.randomUUID();
        failUUID = UUID.randomUUID();
        notFoundChangeLogUUID = UUID.randomUUID();
    }
}

