/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByVisitor;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.Validator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.FeatureContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.feature.FeatureSetValidation;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.DatabaseMetaDataValidation;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.MetadataContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.Named;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ItemsListValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.OrderByValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public abstract class AbstractValidator<S>
implements Validator<S> {
    private ValidationContext context = new ValidationContext();
    private Map<ValidationCapability, Set<ValidationException>> errors = new HashMap<ValidationCapability, Set<ValidationException>>();
    private Map<Class<? extends AbstractValidator<?>>, AbstractValidator<?>> validatorForwards = new HashMap();

    public <T extends AbstractValidator<?>> T getValidator(Class<T> clazz) {
        return (T)((AbstractValidator)clazz.cast(this.validatorForwards.computeIfAbsent(clazz, this::newObject)));
    }

    private <E extends Validator<?>> E newObject(Class<E> clazz) {
        try {
            Class<E> clazz2 = clazz;
            Validator validator = (Validator)clazz2.cast(clazz2.getConstructor(new Class[0]).newInstance(new Object[0]));
            validator.setContext(this.context());
            return (E)validator;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalStateException("Type " + clazz + " cannot be constructed by empty constructor!");
        }
    }

    protected Consumer<ValidationException> getMessageConsumer(ValidationCapability validationCapability) {
        return validationException -> this.putError(validationCapability, (ValidationException)validationException);
    }

    protected ValidationContext context() {
        return this.context(true);
    }

    protected ValidationContext context(boolean bl2) {
        return this.context.reinit(bl2);
    }

    protected void putError(ValidationCapability validationCapability2, ValidationException validationException) {
        this.errors.computeIfAbsent(validationCapability2, validationCapability -> new HashSet()).add(validationException);
    }

    @Override
    public final Map<ValidationCapability, Set<ValidationException>> getValidationErrors() {
        HashMap<ValidationCapability, Set<ValidationException>> hashMap = new HashMap<ValidationCapability, Set<ValidationException>>();
        hashMap.putAll(this.errors);
        Iterator<AbstractValidator<?>> iterator = this.validatorForwards.values().iterator();
        while (iterator.hasNext()) {
            for (Map.Entry<ValidationCapability, Set<ValidationException>> entry : iterator.next().getValidationErrors().entrySet()) {
                Set set = (Set)hashMap.get(entry.getKey());
                if (set == null) {
                    hashMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                set.addAll((Collection)entry.getValue());
            }
        }
        return hashMap;
    }

    public Collection<ValidationCapability> getCapabilities() {
        return this.context().getCapabilities();
    }

    @Override
    public final void setContext(ValidationContext validationContext) {
        this.context = validationContext;
    }

    protected <E> void validateOptional(E e2, Consumer<E> consumer) {
        if (e2 != null) {
            consumer.accept(e2);
        }
    }

    protected <E, V extends Validator<?>> void validateOptionalList(List<E> list, Supplier<V> object, BiConsumer<E, V> biConsumer) {
        if (this.isNotEmpty(list)) {
            object = (Validator)object.get();
            list.forEach(arg_0 -> AbstractValidator.lambda$validateOptionalList$2(biConsumer, (Validator)object, arg_0));
        }
    }

    protected void validateOptionalMultiExpressionList(MultiExpressionList multiExpressionList) {
        if (multiExpressionList != null) {
            ExpressionValidator expressionValidator = this.getValidator(ExpressionValidator.class);
            multiExpressionList.getExpressionLists().stream().map(ExpressionList::getExpressions).flatMap(Collection::stream).forEach(expression -> expression.accept(expressionValidator));
        }
    }

    protected void validateOptionalExpression(Expression expression2) {
        this.validateOptional(expression2, expression -> expression.accept(this.getValidator(ExpressionValidator.class)));
    }

    protected void validateOptionalExpression(Expression expression2, ExpressionValidator expressionValidator) {
        this.validateOptional(expression2, expression -> expression.accept(expressionValidator));
    }

    protected void validateOptionalExpressions(List<? extends Expression> list) {
        this.validateOptionalList(list, () -> this.getValidator(ExpressionValidator.class), (expression, expressionValidator) -> expression.accept((ExpressionVisitor)expressionValidator));
    }

    protected void validateOptionalFromItems(FromItem ... fromItemArray) {
        this.validateOptionalFromItems(Arrays.asList(fromItemArray));
    }

    protected void validateOptionalFromItems(List<? extends FromItem> list) {
        this.validateOptionalList(list, () -> this.getValidator(SelectValidator.class), this::validateOptionalFromItem);
    }

    protected void validateOptionalOrderByElements(List<OrderByElement> list) {
        this.validateOptionalList(list, () -> this.getValidator(OrderByValidator.class), (orderByElement, orderByValidator) -> orderByElement.accept((OrderByVisitor)orderByValidator));
    }

    protected void validateOptionalFromItem(FromItem fromItem2) {
        this.validateOptional(fromItem2, fromItem -> fromItem.accept(this.getValidator(SelectValidator.class)));
    }

    protected void validateOptionalFromItem(FromItem fromItem2, SelectValidator selectValidator) {
        this.validateOptional(fromItem2, fromItem -> fromItem.accept(selectValidator));
    }

    protected void validateOptionalItemsList(ItemsList itemsList2) {
        this.validateOptional(itemsList2, itemsList -> itemsList.accept(this.getValidator(ItemsListValidator.class)));
    }

    protected void validateFeature(Feature feature) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, feature);
        }
    }

    protected void validateFeatureAndName(Feature feature, NamedObject namedObject, String string) {
        this.validateFeatureAndNameWithAlias(feature, namedObject, string, null);
    }

    protected void validateFeatureAndNameWithAlias(Feature feature, NamedObject namedObject, String string, String string2) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, feature);
            this.validateNameWithAlias(validationCapability, namedObject, string, string2, true, new NamedObject[0]);
        }
    }

    protected void validateName(NamedObject namedObject, String string) {
        this.validateNameWithAlias(namedObject, string, null);
    }

    protected void validateNameWithAlias(NamedObject namedObject, String string, String string2) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateNameWithAlias(validationCapability, namedObject, string, string2, true, new NamedObject[0]);
        }
    }

    protected void validateFeature(ValidationCapability validationCapability, boolean bl2, Feature feature) {
        if (bl2) {
            this.validateFeature(validationCapability, feature);
        }
    }

    protected void validateOptionalFeature(ValidationCapability validationCapability, List<?> list, Feature feature) {
        this.validateFeature(validationCapability, this.isNotEmpty(list), feature);
    }

    protected void validateOptionalFeature(ValidationCapability validationCapability, Object object, Feature feature) {
        this.validateFeature(validationCapability, object != null, feature);
    }

    protected void validateFeature(ValidationCapability validationCapability, Feature feature) {
        if (validationCapability instanceof FeatureSetValidation) {
            validationCapability.validate(this.context().put(FeatureContext.feature, (Object)feature), this.getMessageConsumer(validationCapability));
        }
    }

    protected void validateNameWithAlias(ValidationCapability validationCapability, NamedObject namedObject, String string, String string2) {
        this.validateNameWithAlias(validationCapability, namedObject, string, string2, true, new NamedObject[0]);
    }

    protected void validateName(ValidationCapability validationCapability, NamedObject namedObject, String string) {
        this.validateNameWithAlias(validationCapability, namedObject, string, null, true, new NamedObject[0]);
    }

    protected void validateNameWithAlias(ValidationCapability validationCapability, NamedObject namedObject, String string, String string2, boolean bl2, NamedObject ... namedObjectArray) {
        if (validationCapability instanceof DatabaseMetaDataValidation) {
            validationCapability.validate(this.context().put(MetadataContext.named, new Named(namedObject, string).setAlias(string2).setParents(Arrays.asList(namedObjectArray))).put(MetadataContext.exists, bl2), this.getMessageConsumer(validationCapability));
        }
    }

    protected void validateName(ValidationCapability validationCapability, NamedObject namedObject, String string, boolean bl2, NamedObject ... namedObjectArray) {
        this.validateNameWithAlias(validationCapability, namedObject, string, null, bl2, namedObjectArray);
    }

    protected void validateOptionalColumnName(ValidationCapability validationCapability, String string) {
        this.validateOptionalName(validationCapability, NamedObject.column, string, null, true, new NamedObject[0]);
    }

    protected void validateOptionalColumnNameWithAlias(ValidationCapability validationCapability, String string, String string2) {
        this.validateOptionalName(validationCapability, NamedObject.column, string, string2, true, new NamedObject[0]);
    }

    protected void validateOptionalColumnNames(ValidationCapability validationCapability, List<String> list, NamedObject ... namedObjectArray) {
        this.validateOptionalColumnNames(validationCapability, list, true, namedObjectArray);
    }

    protected void validateOptionalColumnNames(ValidationCapability validationCapability, List<String> list, boolean bl2, NamedObject ... namedObjectArray) {
        if (list != null) {
            list.forEach(string -> this.validateOptionalName(validationCapability, NamedObject.column, (String)string, null, bl2, namedObjectArray));
        }
    }

    protected void validateOptionalNameWithAlias(ValidationCapability validationCapability, NamedObject namedObject, String string, String string2, NamedObject ... namedObjectArray) {
        this.validateOptionalName(validationCapability, namedObject, string, string2, true, namedObjectArray);
    }

    protected void validateOptionalName(ValidationCapability validationCapability, NamedObject namedObject, String string, NamedObject ... namedObjectArray) {
        this.validateOptionalNameWithAlias(validationCapability, namedObject, string, null, namedObjectArray);
    }

    protected void validateOptionalName(ValidationCapability validationCapability, NamedObject namedObject, String string, String string2, boolean bl2, NamedObject ... namedObjectArray) {
        if (string != null) {
            this.validateNameWithAlias(validationCapability, namedObject, string, string2, bl2, namedObjectArray);
        }
    }

    protected boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    protected boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    private static /* synthetic */ void lambda$validateOptionalList$2(BiConsumer biConsumer, Validator validator, Object object) {
        biConsumer.accept(object, validator);
    }
}

