"""Generated client library for cloudresourcemanager version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudresourcemanager.v1 import cloudresourcemanager_v1_messages as messages


class CloudresourcemanagerV1(base_api.BaseApiClient):
  """Generated client library for service cloudresourcemanager version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudresourcemanager.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudresourcemanager.mtls.googleapis.com/'

  _PACKAGE = 'cloudresourcemanager'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudresourcemanagerV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudresourcemanager handle."""
    url = url or self.BASE_URL
    super(CloudresourcemanagerV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders = self.FoldersService(self)
    self.liens = self.LiensService(self)
    self.operations = self.OperationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(CloudresourcemanagerV1.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def ClearOrgPolicy(self, request, global_params=None):
      r"""Clears a `Policy` from a resource.

      Args:
        request: (CloudresourcemanagerFoldersClearOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ClearOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    ClearOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.clearOrgPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:clearOrgPolicy',
        request_field='clearOrgPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersClearOrgPolicyRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def GetEffectiveOrgPolicy(self, request, global_params=None):
      r"""Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy. The returned `Policy` will not have an `etag`set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.

      Args:
        request: (CloudresourcemanagerFoldersGetEffectiveOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.getEffectiveOrgPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:getEffectiveOrgPolicy',
        request_field='getEffectiveOrgPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersGetEffectiveOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def GetOrgPolicy(self, request, global_params=None):
      r"""Gets a `Policy` on a resource. If no `Policy` is set on the resource, a `Policy` is returned with default values including `POLICY_TYPE_NOT_SET` for the `policy_type oneof`. The `etag` value can be used with `SetOrgPolicy()` to create or update a `Policy` during read-modify-write.

      Args:
        request: (CloudresourcemanagerFoldersGetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.getOrgPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:getOrgPolicy',
        request_field='getOrgPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersGetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def ListAvailableOrgPolicyConstraints(self, request, global_params=None):
      r"""Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (CloudresourcemanagerFoldersListAvailableOrgPolicyConstraintsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAvailableOrgPolicyConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableOrgPolicyConstraints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableOrgPolicyConstraints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.listAvailableOrgPolicyConstraints',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:listAvailableOrgPolicyConstraints',
        request_field='listAvailableOrgPolicyConstraintsRequest',
        request_type_name='CloudresourcemanagerFoldersListAvailableOrgPolicyConstraintsRequest',
        response_type_name='ListAvailableOrgPolicyConstraintsResponse',
        supports_download=False,
    )

    def ListOrgPolicies(self, request, global_params=None):
      r"""Lists all the `Policies` set for a particular resource.

      Args:
        request: (CloudresourcemanagerFoldersListOrgPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOrgPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('ListOrgPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListOrgPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.listOrgPolicies',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:listOrgPolicies',
        request_field='listOrgPoliciesRequest',
        request_type_name='CloudresourcemanagerFoldersListOrgPoliciesRequest',
        response_type_name='ListOrgPoliciesResponse',
        supports_download=False,
    )

    def SetOrgPolicy(self, request, global_params=None):
      r"""Updates the specified `Policy` on the resource. Creates a new `Policy` for that `Constraint` on the resource if one does not exist. Not supplying an `etag` on the request `Policy` results in an unconditional write of the `Policy`.

      Args:
        request: (CloudresourcemanagerFoldersSetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('SetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.setOrgPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v1/folders/{foldersId}:setOrgPolicy',
        request_field='setOrgPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersSetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

  class LiensService(base_api.BaseApiService):
    """Service class for the liens resource."""

    _NAME = 'liens'

    def __init__(self, client):
      super(CloudresourcemanagerV1.LiensService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a Lien which applies to the resource denoted by the `parent` field. Callers of this method will require permission on the `parent` resource. For example, applying to `projects/1234` requires permission `resourcemanager.projects.updateLiens`. NOTE: Some resources may limit the number of Liens which may be applied.

      Args:
        request: (Lien) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lien) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.liens.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/liens',
        request_field='<request>',
        request_type_name='Lien',
        response_type_name='Lien',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a Lien by `name`. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.updateLiens`.

      Args:
        request: (CloudresourcemanagerLiensDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='cloudresourcemanager.liens.delete',
        ordered_params=['liensId'],
        path_params=['liensId'],
        query_params=[],
        relative_path='v1/liens/{liensId}',
        request_field='',
        request_type_name='CloudresourcemanagerLiensDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve a Lien by `name`. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.get`.

      Args:
        request: (CloudresourcemanagerLiensGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lien) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.liens.get',
        ordered_params=['liensId'],
        path_params=['liensId'],
        query_params=[],
        relative_path='v1/liens/{liensId}',
        request_field='',
        request_type_name='CloudresourcemanagerLiensGetRequest',
        response_type_name='Lien',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all Liens applied to the `parent` resource. Callers of this method will require permission on the `parent` resource. For example, a Lien with a `parent` of `projects/1234` requires permission `resourcemanager.projects.get`.

      Args:
        request: (CloudresourcemanagerLiensListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLiensResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.liens.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v1/liens',
        request_field='',
        request_type_name='CloudresourcemanagerLiensListRequest',
        response_type_name='ListLiensResponse',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = 'operations'

    def __init__(self, client):
      super(CloudresourcemanagerV1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudresourcemanagerOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.operations.get',
        ordered_params=['operationsId'],
        path_params=['operationsId'],
        query_params=[],
        relative_path='v1/operations/{operationsId}',
        request_field='',
        request_type_name='CloudresourcemanagerOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(CloudresourcemanagerV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def ClearOrgPolicy(self, request, global_params=None):
      r"""Clears a `Policy` from a resource.

      Args:
        request: (CloudresourcemanagerOrganizationsClearOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ClearOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    ClearOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.clearOrgPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:clearOrgPolicy',
        request_field='clearOrgPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsClearOrgPolicyRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches an Organization resource identified by the specified resource name.

      Args:
        request: (CloudresourcemanagerOrganizationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Organization) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.organizations.get',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}',
        request_field='',
        request_type_name='CloudresourcemanagerOrganizationsGetRequest',
        response_type_name='Organization',
        supports_download=False,
    )

    def GetEffectiveOrgPolicy(self, request, global_params=None):
      r"""Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy. The returned `Policy` will not have an `etag`set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.

      Args:
        request: (CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.getEffectiveOrgPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:getEffectiveOrgPolicy',
        request_field='getEffectiveOrgPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for an Organization resource. May be empty if no such policy or resource exists. The `resource` field should be the organization's resource name, e.g. "organizations/123". Authorization requires the Google IAM permission `resourcemanager.organizations.getIamPolicy` on the specified organization.

      Args:
        request: (CloudresourcemanagerOrganizationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.getIamPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetOrgPolicy(self, request, global_params=None):
      r"""Gets a `Policy` on a resource. If no `Policy` is set on the resource, a `Policy` is returned with default values including `POLICY_TYPE_NOT_SET` for the `policy_type oneof`. The `etag` value can be used with `SetOrgPolicy()` to create or update a `Policy` during read-modify-write.

      Args:
        request: (CloudresourcemanagerOrganizationsGetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.getOrgPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:getOrgPolicy',
        request_field='getOrgPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsGetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def ListAvailableOrgPolicyConstraints(self, request, global_params=None):
      r"""Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAvailableOrgPolicyConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableOrgPolicyConstraints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableOrgPolicyConstraints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.listAvailableOrgPolicyConstraints',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:listAvailableOrgPolicyConstraints',
        request_field='listAvailableOrgPolicyConstraintsRequest',
        request_type_name='CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest',
        response_type_name='ListAvailableOrgPolicyConstraintsResponse',
        supports_download=False,
    )

    def ListOrgPolicies(self, request, global_params=None):
      r"""Lists all the `Policies` set for a particular resource.

      Args:
        request: (CloudresourcemanagerOrganizationsListOrgPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOrgPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('ListOrgPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListOrgPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.listOrgPolicies',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:listOrgPolicies',
        request_field='listOrgPoliciesRequest',
        request_type_name='CloudresourcemanagerOrganizationsListOrgPoliciesRequest',
        response_type_name='ListOrgPoliciesResponse',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches Organization resources that are visible to the user and satisfy the specified filter. This method returns Organizations in an unspecified order. New Organizations do not necessarily appear at the end of the results. Search will only return organizations on which the user has the permission `resourcemanager.organizations.get`.

      Args:
        request: (SearchOrganizationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchOrganizationsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/organizations:search',
        request_field='<request>',
        request_type_name='SearchOrganizationsRequest',
        response_type_name='SearchOrganizationsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on an Organization resource. Replaces any existing policy. The `resource` field should be the organization's resource name, e.g. "organizations/123". Authorization requires the Google IAM permission `resourcemanager.organizations.setIamPolicy` on the specified organization.

      Args:
        request: (CloudresourcemanagerOrganizationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.setIamPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetOrgPolicy(self, request, global_params=None):
      r"""Updates the specified `Policy` on the resource. Creates a new `Policy` for that `Constraint` on the resource if one does not exist. Not supplying an `etag` on the request `Policy` results in an unconditional write of the `Policy`.

      Args:
        request: (CloudresourcemanagerOrganizationsSetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('SetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.setOrgPolicy',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:setOrgPolicy',
        request_field='setOrgPolicyRequest',
        request_type_name='CloudresourcemanagerOrganizationsSetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Organization. The `resource` field should be the organization's resource name, e.g. "organizations/123". There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerOrganizationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.organizations.testIamPermissions',
        ordered_params=['organizationsId'],
        path_params=['organizationsId'],
        query_params=[],
        relative_path='v1/organizations/{organizationsId}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerOrganizationsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudresourcemanagerV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def ClearOrgPolicy(self, request, global_params=None):
      r"""Clears a `Policy` from a resource.

      Args:
        request: (CloudresourcemanagerProjectsClearOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ClearOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    ClearOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.clearOrgPolicy',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:clearOrgPolicy',
        request_field='clearOrgPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsClearOrgPolicyRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Request that a new Project be created. The result is an Operation which can be used to track the creation process. This process usually takes a few seconds, but can sometimes take much longer. The tracking Operation is automatically deleted after a few hours, so there is no need to call DeleteOperation. Authorization requires the Google IAM permission `resourcemanager.projects.create` on the specified parent for the new project. The parent is identified by a specified ResourceId, which must include both an ID and a type, such as organization. This method does not associate the new project with a billing account. You can set or update the billing account associated with a project using the [`projects.updateBillingInfo`] (/billing/reference/rest/v1/projects/updateBillingInfo) method.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/projects',
        request_field='<request>',
        request_type_name='Project',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Marks the Project identified by the specified `project_id` (for example, `my-project-123`) for deletion. This method will only affect the Project if it has a lifecycle state of ACTIVE. This method changes the Project's lifecycle state from ACTIVE to DELETE_REQUESTED. The deletion starts at an unspecified time, at which point the Project is no longer accessible. Until the deletion completes, you can check the lifecycle state checked by retrieving the Project with GetProject, and the Project remains visible to ListProjects. However, you cannot update the project. After the deletion completes, the Project is not retrievable by the GetProject and ListProjects methods. The caller must have delete permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='cloudresourcemanager.projects.delete',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the Project identified by the specified `project_id` (for example, `my-project-123`). The caller must have read permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.projects.get',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsGetRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetAncestry(self, request, global_params=None):
      r"""Gets a list of ancestors in the resource hierarchy for the Project identified by the specified `project_id` (for example, `my-project-123`). The caller must have read permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsGetAncestryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetAncestryResponse) The response message.
      """
      config = self.GetMethodConfig('GetAncestry')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAncestry.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.getAncestry',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}:getAncestry',
        request_field='getAncestryRequest',
        request_type_name='CloudresourcemanagerProjectsGetAncestryRequest',
        response_type_name='GetAncestryResponse',
        supports_download=False,
    )

    def GetEffectiveOrgPolicy(self, request, global_params=None):
      r"""Gets the effective `Policy` on a resource. This is the result of merging `Policies` in the resource hierarchy. The returned `Policy` will not have an `etag`set because it is a computed `Policy` across multiple resources. Subtrees of Resource Manager resource hierarchy with 'under:' prefix will not be expanded.

      Args:
        request: (CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.getEffectiveOrgPolicy',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:getEffectiveOrgPolicy',
        request_field='getEffectiveOrgPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns the IAM access control policy for the specified Project. Permission is denied if the policy or the resource does not exist. Authorization requires the Google IAM permission `resourcemanager.projects.getIamPolicy` on the project. For additional information about `resource` (e.g. my-project-id) structure and identification, see [Resource Names](https://cloud.google.com/apis/design/resource_names).

      Args:
        request: (CloudresourcemanagerProjectsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/projects/{resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetOrgPolicy(self, request, global_params=None):
      r"""Gets a `Policy` on a resource. If no `Policy` is set on the resource, a `Policy` is returned with default values including `POLICY_TYPE_NOT_SET` for the `policy_type oneof`. The `etag` value can be used with `SetOrgPolicy()` to create or update a `Policy` during read-modify-write.

      Args:
        request: (CloudresourcemanagerProjectsGetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.getOrgPolicy',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:getOrgPolicy',
        request_field='getOrgPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsGetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Projects that the caller has the `resourcemanager.projects.get` permission on and satisfy the specified filter. This method returns Projects in an unspecified order. This method is eventually consistent with project mutations; this means that a newly created project may not appear in the results or recent updates to an existing project may not be reflected in the results. To retrieve the latest state of a project, use the GetProject method. NOTE: If the request filter contains a `parent.type` and `parent.id` and the caller has the `resourcemanager.projects.list` permission on the parent, the results will be drawn from an alternate index which provides more consistent results. In future versions of this API, this List method will be split into List and Search to properly capture the behavioral difference.

      Args:
        request: (CloudresourcemanagerProjectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListProjectsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.projects.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/projects',
        request_field='',
        request_type_name='CloudresourcemanagerProjectsListRequest',
        response_type_name='ListProjectsResponse',
        supports_download=False,
    )

    def ListAvailableOrgPolicyConstraints(self, request, global_params=None):
      r"""Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAvailableOrgPolicyConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableOrgPolicyConstraints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableOrgPolicyConstraints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.listAvailableOrgPolicyConstraints',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:listAvailableOrgPolicyConstraints',
        request_field='listAvailableOrgPolicyConstraintsRequest',
        request_type_name='CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest',
        response_type_name='ListAvailableOrgPolicyConstraintsResponse',
        supports_download=False,
    )

    def ListOrgPolicies(self, request, global_params=None):
      r"""Lists all the `Policies` set for a particular resource.

      Args:
        request: (CloudresourcemanagerProjectsListOrgPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOrgPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('ListOrgPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListOrgPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.listOrgPolicies',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:listOrgPolicies',
        request_field='listOrgPoliciesRequest',
        request_type_name='CloudresourcemanagerProjectsListOrgPoliciesRequest',
        response_type_name='ListOrgPoliciesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM access control policy for the specified Project. CAUTION: This method will replace the existing policy, and cannot be used to append additional IAM settings. NOTE: Removing service accounts from policies or changing their roles can render services completely inoperable. It is important to understand how the service account is being used before removing or updating its roles. For additional information about `resource` (e.g. my-project-id) structure and identification, see [Resource Names](https://cloud.google.com/apis/design/resource_names). The following constraints apply when using `setIamPolicy()`: + Project does not support `allUsers` and `allAuthenticatedUsers` as `members` in a `Binding` of a `Policy`. + The owner role can be granted to a `user`, `serviceAccount`, or a group that is part of an organization. For example, group@myownpersonaldomain.com could be added as an owner to a project in the myownpersonaldomain.com organization, but not the examplepetstore.com organization. + Service accounts can be made owners of a project directly without any restrictions. However, to be added as an owner, a user must be invited via Cloud Platform console and must accept the invitation. + A user cannot be granted the owner role using `setIamPolicy()`. The user must be granted the owner role using the Cloud Platform Console and must explicitly accept the invitation. + You can only grant ownership of a project to a member by using the GCP Console. Inviting a member will deliver an invitation email that they must accept. An invitation email is not generated if you are granting a role other than owner, or if both the member you are inviting and the project are part of your organization. + If the project is not part of an organization, there must be at least one owner who has accepted the Terms of Service (ToS) agreement in the policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner from the policy will fail. This restriction also applies to legacy projects that no longer have owners who have accepted the ToS. Edits to IAM policies will be rejected until the lack of a ToS-accepting owner is rectified. If the project is part of an organization, you can remove all owners, potentially making the organization inaccessible. Authorization requires the Google IAM permission `resourcemanager.projects.setIamPolicy` on the project.

      Args:
        request: (CloudresourcemanagerProjectsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/projects/{resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetOrgPolicy(self, request, global_params=None):
      r"""Updates the specified `Policy` on the resource. Creates a new `Policy` for that `Constraint` on the resource if one does not exist. Not supplying an `etag` on the request `Policy` results in an unconditional write of the `Policy`.

      Args:
        request: (CloudresourcemanagerProjectsSetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('SetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.setOrgPolicy',
        ordered_params=['projectsId'],
        path_params=['projectsId'],
        query_params=[],
        relative_path='v1/projects/{projectsId}:setOrgPolicy',
        request_field='setOrgPolicyRequest',
        request_type_name='CloudresourcemanagerProjectsSetOrgPolicyRequest',
        response_type_name='OrgPolicy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Project. For additional information about `resource` (e.g. my-project-id) structure and identification, see [Resource Names](https://cloud.google.com/apis/design/resource_names). There are no permissions required for making this API call.

      Args:
        request: (CloudresourcemanagerProjectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/projects/{resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerProjectsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Restores the Project identified by the specified `project_id` (for example, `my-project-123`). You can only use this method for a Project that has a lifecycle state of DELETE_REQUESTED. After deletion starts, the Project cannot be restored. The caller must have undelete permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.projects.undelete',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}:undelete',
        request_field='undeleteProjectRequest',
        request_type_name='CloudresourcemanagerProjectsUndeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the attributes of the Project identified by the specified `project_id` (for example, `my-project-123`). The caller must have modify permissions for this Project.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='cloudresourcemanager.projects.update',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}',
        request_field='<request>',
        request_type_name='Project',
        response_type_name='Project',
        supports_download=False,
    )
