/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class FilterCalcMergeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterCalcMergeRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterCalcMergeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalCalc calc = (LogicalCalc)call.rel(1);
        if (calc.containsOver()) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        progBuilder.addIdentity();
        progBuilder.addCondition(filter.getCondition());
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), mergedProgram);
        call.transformTo(newCalc);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(Filter.class, LogicalCalc.class);

        @Override
        default public FilterCalcMergeRule toRule() {
            return new FilterCalcMergeRule(this);
        }

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Calc> calcClass) {
            return this.withOperandSupplier(b0 -> b0.operand(filterClass).oneInput(b1 -> b1.operand(calcClass).anyInputs())).as(Config.class);
        }
    }
}

